# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtGui`

import PySide6.QtGui
import PySide6.QtCore

import os
import enum
from typing import Any, Callable, ClassVar, Dict, Iterable, List, Optional, Sequence, Set, Tuple, Union, overload
from PySide6.QtCore import Signal
from shiboken6 import Shiboken


class QAbstractFileIconProvider(Shiboken.Object):

    class IconType(enum.Enum):

        Computer                 : QAbstractFileIconProvider.IconType = ... # 0x0
        Desktop                  : QAbstractFileIconProvider.IconType = ... # 0x1
        Trashcan                 : QAbstractFileIconProvider.IconType = ... # 0x2
        Network                  : QAbstractFileIconProvider.IconType = ... # 0x3
        Drive                    : QAbstractFileIconProvider.IconType = ... # 0x4
        Folder                   : QAbstractFileIconProvider.IconType = ... # 0x5
        File                     : QAbstractFileIconProvider.IconType = ... # 0x6


    class Option(enum.Flag):

        DontUseCustomDirectoryIcons: QAbstractFileIconProvider.Option = ... # 0x1


    def __init__(self) -> None: ...

    @overload
    def icon(self, arg__1: PySide6.QtCore.QFileInfo) -> PySide6.QtGui.QIcon: ...
    @overload
    def icon(self, arg__1: PySide6.QtGui.QAbstractFileIconProvider.IconType) -> PySide6.QtGui.QIcon: ...
    def options(self) -> PySide6.QtGui.QAbstractFileIconProvider.Option: ...
    def setOptions(self, arg__1: PySide6.QtGui.QAbstractFileIconProvider.Option) -> None: ...
    def type(self, arg__1: PySide6.QtCore.QFileInfo) -> str: ...


class QAbstractTextDocumentLayout(PySide6.QtCore.QObject):

    documentSizeChanged      : ClassVar[Signal] = ... # documentSizeChanged(QSizeF)
    pageCountChanged         : ClassVar[Signal] = ... # pageCountChanged(int)
    update                   : ClassVar[Signal] = ... # update()
    updateBlock              : ClassVar[Signal] = ... # updateBlock(QTextBlock)

    class PaintContext(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, PaintContext: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Selection(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, Selection: PySide6.QtGui.QAbstractTextDocumentLayout.Selection) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def anchorAt(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> str: ...
    def blockBoundingRect(self, block: PySide6.QtGui.QTextBlock) -> PySide6.QtCore.QRectF: ...
    def blockWithMarkerAt(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtGui.QTextBlock: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def documentChanged(self, from_: int, charsRemoved: int, charsAdded: int) -> None: ...
    def documentSize(self) -> PySide6.QtCore.QSizeF: ...
    def draw(self, painter: PySide6.QtGui.QPainter, context: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...
    def drawInlineObject(self, painter: PySide6.QtGui.QPainter, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], object: PySide6.QtGui.QTextInlineObject, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def format(self, pos: int) -> PySide6.QtGui.QTextCharFormat: ...
    def formatAt(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtGui.QTextFormat: ...
    def formatIndex(self, pos: int) -> int: ...
    def frameBoundingRect(self, frame: PySide6.QtGui.QTextFrame) -> PySide6.QtCore.QRectF: ...
    def handlerForObject(self, objectType: int) -> PySide6.QtGui.QTextObjectInterface: ...
    def hitTest(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], accuracy: PySide6.QtCore.Qt.HitTestAccuracy) -> int: ...
    def imageAt(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> str: ...
    def pageCount(self) -> int: ...
    def paintDevice(self) -> PySide6.QtGui.QPaintDevice: ...
    def positionInlineObject(self, item: PySide6.QtGui.QTextInlineObject, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def registerHandler(self, objectType: int, component: PySide6.QtCore.QObject) -> None: ...
    def resizeInlineObject(self, item: PySide6.QtGui.QTextInlineObject, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def setPaintDevice(self, device: PySide6.QtGui.QPaintDevice) -> None: ...
    def unregisterHandler(self, objectType: int, component: Optional[PySide6.QtCore.QObject] = ...) -> None: ...


class QAccessible(Shiboken.Object):

    class Event(enum.Enum):

        SoundPlayed              : QAccessible.Event = ... # 0x1
        Alert                    : QAccessible.Event = ... # 0x2
        ForegroundChanged        : QAccessible.Event = ... # 0x3
        MenuStart                : QAccessible.Event = ... # 0x4
        MenuEnd                  : QAccessible.Event = ... # 0x5
        PopupMenuStart           : QAccessible.Event = ... # 0x6
        PopupMenuEnd             : QAccessible.Event = ... # 0x7
        ContextHelpStart         : QAccessible.Event = ... # 0xc
        ContextHelpEnd           : QAccessible.Event = ... # 0xd
        DragDropStart            : QAccessible.Event = ... # 0xe
        DragDropEnd              : QAccessible.Event = ... # 0xf
        DialogStart              : QAccessible.Event = ... # 0x10
        DialogEnd                : QAccessible.Event = ... # 0x11
        ScrollingStart           : QAccessible.Event = ... # 0x12
        ScrollingEnd             : QAccessible.Event = ... # 0x13
        MenuCommand              : QAccessible.Event = ... # 0x18
        ActionChanged            : QAccessible.Event = ... # 0x101
        ActiveDescendantChanged  : QAccessible.Event = ... # 0x102
        AttributeChanged         : QAccessible.Event = ... # 0x103
        DocumentContentChanged   : QAccessible.Event = ... # 0x104
        DocumentLoadComplete     : QAccessible.Event = ... # 0x105
        DocumentLoadStopped      : QAccessible.Event = ... # 0x106
        DocumentReload           : QAccessible.Event = ... # 0x107
        HyperlinkEndIndexChanged : QAccessible.Event = ... # 0x108
        HyperlinkNumberOfAnchorsChanged: QAccessible.Event = ... # 0x109
        HyperlinkSelectedLinkChanged: QAccessible.Event = ... # 0x10a
        HypertextLinkActivated   : QAccessible.Event = ... # 0x10b
        HypertextLinkSelected    : QAccessible.Event = ... # 0x10c
        HyperlinkStartIndexChanged: QAccessible.Event = ... # 0x10d
        HypertextChanged         : QAccessible.Event = ... # 0x10e
        HypertextNLinksChanged   : QAccessible.Event = ... # 0x10f
        ObjectAttributeChanged   : QAccessible.Event = ... # 0x110
        PageChanged              : QAccessible.Event = ... # 0x111
        SectionChanged           : QAccessible.Event = ... # 0x112
        TableCaptionChanged      : QAccessible.Event = ... # 0x113
        TableColumnDescriptionChanged: QAccessible.Event = ... # 0x114
        TableColumnHeaderChanged : QAccessible.Event = ... # 0x115
        TableModelChanged        : QAccessible.Event = ... # 0x116
        TableRowDescriptionChanged: QAccessible.Event = ... # 0x117
        TableRowHeaderChanged    : QAccessible.Event = ... # 0x118
        TableSummaryChanged      : QAccessible.Event = ... # 0x119
        TextAttributeChanged     : QAccessible.Event = ... # 0x11a
        TextCaretMoved           : QAccessible.Event = ... # 0x11b
        TextColumnChanged        : QAccessible.Event = ... # 0x11d
        TextInserted             : QAccessible.Event = ... # 0x11e
        TextRemoved              : QAccessible.Event = ... # 0x11f
        TextUpdated              : QAccessible.Event = ... # 0x120
        TextSelectionChanged     : QAccessible.Event = ... # 0x121
        VisibleDataChanged       : QAccessible.Event = ... # 0x122
        ObjectCreated            : QAccessible.Event = ... # 0x8000
        ObjectDestroyed          : QAccessible.Event = ... # 0x8001
        ObjectShow               : QAccessible.Event = ... # 0x8002
        ObjectHide               : QAccessible.Event = ... # 0x8003
        ObjectReorder            : QAccessible.Event = ... # 0x8004
        Focus                    : QAccessible.Event = ... # 0x8005
        Selection                : QAccessible.Event = ... # 0x8006
        SelectionAdd             : QAccessible.Event = ... # 0x8007
        SelectionRemove          : QAccessible.Event = ... # 0x8008
        SelectionWithin          : QAccessible.Event = ... # 0x8009
        StateChanged             : QAccessible.Event = ... # 0x800a
        LocationChanged          : QAccessible.Event = ... # 0x800b
        NameChanged              : QAccessible.Event = ... # 0x800c
        DescriptionChanged       : QAccessible.Event = ... # 0x800d
        ValueChanged             : QAccessible.Event = ... # 0x800e
        ParentChanged            : QAccessible.Event = ... # 0x800f
        HelpChanged              : QAccessible.Event = ... # 0x80a0
        DefaultActionChanged     : QAccessible.Event = ... # 0x80b0
        AcceleratorChanged       : QAccessible.Event = ... # 0x80c0
        InvalidEvent             : QAccessible.Event = ... # 0x80c1


    class InterfaceType(enum.Enum):

        TextInterface            : QAccessible.InterfaceType = ... # 0x0
        EditableTextInterface    : QAccessible.InterfaceType = ... # 0x1
        ValueInterface           : QAccessible.InterfaceType = ... # 0x2
        ActionInterface          : QAccessible.InterfaceType = ... # 0x3
        ImageInterface           : QAccessible.InterfaceType = ... # 0x4
        TableInterface           : QAccessible.InterfaceType = ... # 0x5
        TableCellInterface       : QAccessible.InterfaceType = ... # 0x6
        HyperlinkInterface       : QAccessible.InterfaceType = ... # 0x7


    class RelationFlag(enum.Flag):

        Label                    : QAccessible.RelationFlag = ... # 0x1
        Labelled                 : QAccessible.RelationFlag = ... # 0x2
        Controller               : QAccessible.RelationFlag = ... # 0x4
        Controlled               : QAccessible.RelationFlag = ... # 0x8
        AllRelations             : QAccessible.RelationFlag = ... # 0xffffffff


    class Role(enum.Enum):

        NoRole                   : QAccessible.Role = ... # 0x0
        TitleBar                 : QAccessible.Role = ... # 0x1
        MenuBar                  : QAccessible.Role = ... # 0x2
        ScrollBar                : QAccessible.Role = ... # 0x3
        Grip                     : QAccessible.Role = ... # 0x4
        Sound                    : QAccessible.Role = ... # 0x5
        Cursor                   : QAccessible.Role = ... # 0x6
        Caret                    : QAccessible.Role = ... # 0x7
        AlertMessage             : QAccessible.Role = ... # 0x8
        Window                   : QAccessible.Role = ... # 0x9
        Client                   : QAccessible.Role = ... # 0xa
        PopupMenu                : QAccessible.Role = ... # 0xb
        MenuItem                 : QAccessible.Role = ... # 0xc
        ToolTip                  : QAccessible.Role = ... # 0xd
        Application              : QAccessible.Role = ... # 0xe
        Document                 : QAccessible.Role = ... # 0xf
        Pane                     : QAccessible.Role = ... # 0x10
        Chart                    : QAccessible.Role = ... # 0x11
        Dialog                   : QAccessible.Role = ... # 0x12
        Border                   : QAccessible.Role = ... # 0x13
        Grouping                 : QAccessible.Role = ... # 0x14
        Separator                : QAccessible.Role = ... # 0x15
        ToolBar                  : QAccessible.Role = ... # 0x16
        StatusBar                : QAccessible.Role = ... # 0x17
        Table                    : QAccessible.Role = ... # 0x18
        ColumnHeader             : QAccessible.Role = ... # 0x19
        RowHeader                : QAccessible.Role = ... # 0x1a
        Column                   : QAccessible.Role = ... # 0x1b
        Row                      : QAccessible.Role = ... # 0x1c
        Cell                     : QAccessible.Role = ... # 0x1d
        Link                     : QAccessible.Role = ... # 0x1e
        HelpBalloon              : QAccessible.Role = ... # 0x1f
        Assistant                : QAccessible.Role = ... # 0x20
        List                     : QAccessible.Role = ... # 0x21
        ListItem                 : QAccessible.Role = ... # 0x22
        Tree                     : QAccessible.Role = ... # 0x23
        TreeItem                 : QAccessible.Role = ... # 0x24
        PageTab                  : QAccessible.Role = ... # 0x25
        PropertyPage             : QAccessible.Role = ... # 0x26
        Indicator                : QAccessible.Role = ... # 0x27
        Graphic                  : QAccessible.Role = ... # 0x28
        StaticText               : QAccessible.Role = ... # 0x29
        EditableText             : QAccessible.Role = ... # 0x2a
        Button                   : QAccessible.Role = ... # 0x2b
        PushButton               : QAccessible.Role = ... # 0x2b
        CheckBox                 : QAccessible.Role = ... # 0x2c
        RadioButton              : QAccessible.Role = ... # 0x2d
        ComboBox                 : QAccessible.Role = ... # 0x2e
        ProgressBar              : QAccessible.Role = ... # 0x30
        Dial                     : QAccessible.Role = ... # 0x31
        HotkeyField              : QAccessible.Role = ... # 0x32
        Slider                   : QAccessible.Role = ... # 0x33
        SpinBox                  : QAccessible.Role = ... # 0x34
        Canvas                   : QAccessible.Role = ... # 0x35
        Animation                : QAccessible.Role = ... # 0x36
        Equation                 : QAccessible.Role = ... # 0x37
        ButtonDropDown           : QAccessible.Role = ... # 0x38
        ButtonMenu               : QAccessible.Role = ... # 0x39
        ButtonDropGrid           : QAccessible.Role = ... # 0x3a
        Whitespace               : QAccessible.Role = ... # 0x3b
        PageTabList              : QAccessible.Role = ... # 0x3c
        Clock                    : QAccessible.Role = ... # 0x3d
        Splitter                 : QAccessible.Role = ... # 0x3e
        LayeredPane              : QAccessible.Role = ... # 0x80
        Terminal                 : QAccessible.Role = ... # 0x81
        Desktop                  : QAccessible.Role = ... # 0x82
        Paragraph                : QAccessible.Role = ... # 0x83
        WebDocument              : QAccessible.Role = ... # 0x84
        Section                  : QAccessible.Role = ... # 0x85
        Notification             : QAccessible.Role = ... # 0x86
        ColorChooser             : QAccessible.Role = ... # 0x404
        Footer                   : QAccessible.Role = ... # 0x40e
        Form                     : QAccessible.Role = ... # 0x410
        Heading                  : QAccessible.Role = ... # 0x414
        Note                     : QAccessible.Role = ... # 0x41b
        ComplementaryContent     : QAccessible.Role = ... # 0x42c
        UserRole                 : QAccessible.Role = ... # 0xffff


    class State(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, State: PySide6.QtGui.QAccessible.State) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Text(enum.Enum):

        Name                     : QAccessible.Text = ... # 0x0
        Description              : QAccessible.Text = ... # 0x1
        Value                    : QAccessible.Text = ... # 0x2
        Help                     : QAccessible.Text = ... # 0x3
        Accelerator              : QAccessible.Text = ... # 0x4
        DebugDescription         : QAccessible.Text = ... # 0x5
        UserText                 : QAccessible.Text = ... # 0xffff


    class TextBoundaryType(enum.Enum):

        CharBoundary             : QAccessible.TextBoundaryType = ... # 0x0
        WordBoundary             : QAccessible.TextBoundaryType = ... # 0x1
        SentenceBoundary         : QAccessible.TextBoundaryType = ... # 0x2
        ParagraphBoundary        : QAccessible.TextBoundaryType = ... # 0x3
        LineBoundary             : QAccessible.TextBoundaryType = ... # 0x4
        NoBoundary               : QAccessible.TextBoundaryType = ... # 0x5


    def __init__(self, QAccessible: PySide6.QtGui.QAccessible) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def accessibleInterface(uniqueId: int) -> PySide6.QtGui.QAccessibleInterface: ...
    @staticmethod
    def cleanup() -> None: ...
    @staticmethod
    def deleteAccessibleInterface(uniqueId: int) -> None: ...
    @staticmethod
    def installFactory(arg__1: Callable) -> None: ...
    @staticmethod
    def isActive() -> bool: ...
    @staticmethod
    def qAccessibleTextBoundaryHelper(cursor: PySide6.QtGui.QTextCursor, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> Tuple[int, int]: ...
    @staticmethod
    def queryAccessibleInterface(arg__1: PySide6.QtCore.QObject) -> PySide6.QtGui.QAccessibleInterface: ...
    @staticmethod
    def registerAccessibleInterface(iface: PySide6.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def setActive(active: bool) -> None: ...
    @staticmethod
    def setRootObject(object: PySide6.QtCore.QObject) -> None: ...
    @staticmethod
    def uniqueId(iface: PySide6.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def updateAccessibility(event: PySide6.QtGui.QAccessibleEvent) -> None: ...


class QAccessibleActionInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def actionNames(self) -> List[str]: ...
    @staticmethod
    def decreaseAction() -> str: ...
    def doAction(self, actionName: str) -> None: ...
    @staticmethod
    def increaseAction() -> str: ...
    def keyBindingsForAction(self, actionName: str) -> List[str]: ...
    def localizedActionDescription(self, name: str) -> str: ...
    def localizedActionName(self, name: str) -> str: ...
    @staticmethod
    def nextPageAction() -> str: ...
    @staticmethod
    def pressAction() -> str: ...
    @staticmethod
    def previousPageAction() -> str: ...
    @staticmethod
    def scrollDownAction() -> str: ...
    @staticmethod
    def scrollLeftAction() -> str: ...
    @staticmethod
    def scrollRightAction() -> str: ...
    @staticmethod
    def scrollUpAction() -> str: ...
    @staticmethod
    def setFocusAction() -> str: ...
    @staticmethod
    def showMenuAction() -> str: ...
    @staticmethod
    def toggleAction() -> str: ...


class QAccessibleEditableTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def deleteText(self, startOffset: int, endOffset: int) -> None: ...
    def insertText(self, offset: int, text: str) -> None: ...
    def replaceText(self, startOffset: int, endOffset: int, text: str) -> None: ...


class QAccessibleEvent(Shiboken.Object):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, typ: PySide6.QtGui.QAccessible.Event) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, typ: PySide6.QtGui.QAccessible.Event) -> None: ...

    def accessibleInterface(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def child(self) -> int: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def setChild(self, chld: int) -> None: ...
    def type(self) -> PySide6.QtGui.QAccessible.Event: ...
    def uniqueId(self) -> int: ...


class QAccessibleInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def actionInterface(self) -> PySide6.QtGui.QAccessibleActionInterface: ...
    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def child(self, index: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def childAt(self, x: int, y: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def editableTextInterface(self) -> PySide6.QtGui.QAccessibleEditableTextInterface: ...
    def focusChild(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide6.QtGui.QColor: ...
    def indexOfChild(self, arg__1: PySide6.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, arg__1: PySide6.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def parent(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def relations(self, match: PySide6.QtGui.QAccessible.RelationFlag = ...) -> List[Tuple[PySide6.QtGui.QAccessibleInterface, PySide6.QtGui.QAccessible.RelationFlag]]: ...
    def role(self) -> PySide6.QtGui.QAccessible.Role: ...
    def setText(self, t: PySide6.QtGui.QAccessible.Text, text: str) -> None: ...
    def state(self) -> PySide6.QtGui.QAccessible.State: ...
    def tableCellInterface(self) -> PySide6.QtGui.QAccessibleTableCellInterface: ...
    def text(self, t: PySide6.QtGui.QAccessible.Text) -> str: ...
    def textInterface(self) -> PySide6.QtGui.QAccessibleTextInterface: ...
    def valueInterface(self) -> PySide6.QtGui.QAccessibleValueInterface: ...
    def virtual_hook(self, id: int, data: int) -> None: ...
    def window(self) -> PySide6.QtGui.QWindow: ...


class QAccessibleObject(PySide6.QtGui.QAccessibleInterface):

    def __init__(self, object: PySide6.QtCore.QObject) -> None: ...

    def childAt(self, x: int, y: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def setText(self, t: PySide6.QtGui.QAccessible.Text, text: str) -> None: ...


class QAccessibleStateChangeEvent(PySide6.QtGui.QAccessibleEvent):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, state: PySide6.QtGui.QAccessible.State) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, state: PySide6.QtGui.QAccessible.State) -> None: ...

    def changedStates(self) -> PySide6.QtGui.QAccessible.State: ...


class QAccessibleTableCellInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def columnExtent(self) -> int: ...
    def columnHeaderCells(self) -> List[PySide6.QtGui.QAccessibleInterface]: ...
    def columnIndex(self) -> int: ...
    def isSelected(self) -> bool: ...
    def rowExtent(self) -> int: ...
    def rowHeaderCells(self) -> List[PySide6.QtGui.QAccessibleInterface]: ...
    def rowIndex(self) -> int: ...
    def table(self) -> PySide6.QtGui.QAccessibleInterface: ...


class QAccessibleTableModelChangeEvent(PySide6.QtGui.QAccessibleEvent):

    class ModelChangeType(enum.Enum):

        ModelReset               : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x0
        DataChanged              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x1
        RowsInserted             : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x2
        ColumnsInserted          : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x3
        RowsRemoved              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x4
        ColumnsRemoved           : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x5


    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...

    def firstColumn(self) -> int: ...
    def firstRow(self) -> int: ...
    def lastColumn(self) -> int: ...
    def lastRow(self) -> int: ...
    def modelChangeType(self) -> PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType: ...
    def setFirstColumn(self, col: int) -> None: ...
    def setFirstRow(self, row: int) -> None: ...
    def setLastColumn(self, col: int) -> None: ...
    def setLastRow(self, row: int) -> None: ...
    def setModelChangeType(self, changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...


class QAccessibleTextCursorEvent(PySide6.QtGui.QAccessibleEvent):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, cursorPos: int) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, cursorPos: int) -> None: ...

    def cursorPosition(self) -> int: ...
    def setCursorPosition(self, position: int) -> None: ...


class QAccessibleTextInsertEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, position: int, text: str) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, position: int, text: str) -> None: ...

    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...


class QAccessibleTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def addSelection(self, startOffset: int, endOffset: int) -> None: ...
    def attributes(self, offset: int) -> Tuple[str, int, int]: ...
    def characterCount(self) -> int: ...
    def characterRect(self, offset: int) -> PySide6.QtCore.QRect: ...
    def cursorPosition(self) -> int: ...
    def offsetAtPoint(self, point: PySide6.QtCore.QPoint) -> int: ...
    def removeSelection(self, selectionIndex: int) -> None: ...
    def scrollToSubstring(self, startIndex: int, endIndex: int) -> None: ...
    def selection(self, selectionIndex: int) -> Tuple[int, int]: ...
    def selectionCount(self) -> int: ...
    def setCursorPosition(self, position: int) -> None: ...
    def setSelection(self, selectionIndex: int, startOffset: int, endOffset: int) -> None: ...
    def text(self, startOffset: int, endOffset: int) -> str: ...
    def textAfterOffset(self, offset: int, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> Tuple[str, int, int]: ...
    def textAtOffset(self, offset: int, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> Tuple[str, int, int]: ...
    def textBeforeOffset(self, offset: int, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> Tuple[str, int, int]: ...


class QAccessibleTextRemoveEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, position: int, text: str) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, position: int, text: str) -> None: ...

    def changePosition(self) -> int: ...
    def textRemoved(self) -> str: ...


class QAccessibleTextSelectionEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, start: int, end: int) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, start: int, end: int) -> None: ...

    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setSelection(self, start: int, end: int) -> None: ...


class QAccessibleTextUpdateEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, position: int, oldText: str, text: str) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, position: int, oldText: str, text: str) -> None: ...

    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...
    def textRemoved(self) -> str: ...


class QAccessibleValueChangeEvent(PySide6.QtGui.QAccessibleEvent):

    @overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, val: Any) -> None: ...
    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, val: Any) -> None: ...

    def setValue(self, val: Any) -> None: ...
    def value(self) -> Any: ...


class QAccessibleValueInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def currentValue(self) -> Any: ...
    def maximumValue(self) -> Any: ...
    def minimumStepSize(self) -> Any: ...
    def minimumValue(self) -> Any: ...
    def setCurrentValue(self, value: Any) -> None: ...


class QAction(PySide6.QtCore.QObject):

    changed                  : ClassVar[Signal] = ... # changed()
    checkableChanged         : ClassVar[Signal] = ... # checkableChanged(bool)
    enabledChanged           : ClassVar[Signal] = ... # enabledChanged(bool)
    hovered                  : ClassVar[Signal] = ... # hovered()
    toggled                  : ClassVar[Signal] = ... # toggled(bool)
    triggered                : ClassVar[Signal] = ... # triggered()
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged()

    class ActionEvent(enum.Enum):

        Trigger                  : QAction.ActionEvent = ... # 0x0
        Hover                    : QAction.ActionEvent = ... # 0x1


    class MenuRole(enum.Enum):

        NoRole                   : QAction.MenuRole = ... # 0x0
        TextHeuristicRole        : QAction.MenuRole = ... # 0x1
        ApplicationSpecificRole  : QAction.MenuRole = ... # 0x2
        AboutQtRole              : QAction.MenuRole = ... # 0x3
        AboutRole                : QAction.MenuRole = ... # 0x4
        PreferencesRole          : QAction.MenuRole = ... # 0x5
        QuitRole                 : QAction.MenuRole = ... # 0x6


    class Priority(enum.Enum):

        LowPriority              : QAction.Priority = ... # 0x0
        NormalPriority           : QAction.Priority = ... # 0x80
        HighPriority             : QAction.Priority = ... # 0x100


    @overload
    def __init__(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def actionGroup(self) -> PySide6.QtGui.QActionGroup: ...
    def activate(self, event: PySide6.QtGui.QAction.ActionEvent) -> None: ...
    def associatedObjects(self) -> List[PySide6.QtCore.QObject]: ...
    def autoRepeat(self) -> bool: ...
    def data(self) -> Any: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def hover(self) -> None: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def iconText(self) -> str: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def isSeparator(self) -> bool: ...
    def isShortcutVisibleInContextMenu(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def menu(self) -> PySide6.QtCore.QObject: ...
    def menuRole(self) -> PySide6.QtGui.QAction.MenuRole: ...
    def priority(self) -> PySide6.QtGui.QAction.Priority: ...
    def resetEnabled(self) -> None: ...
    def setActionGroup(self, group: PySide6.QtGui.QActionGroup) -> None: ...
    def setAutoRepeat(self, arg__1: bool) -> None: ...
    def setCheckable(self, arg__1: bool) -> None: ...
    def setChecked(self, arg__1: bool) -> None: ...
    def setData(self, var: Any) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setIconText(self, text: str) -> None: ...
    def setIconVisibleInMenu(self, visible: bool) -> None: ...
    def setMenu(self, arg__1: PySide6.QtCore.QObject) -> None: ...
    def setMenuRole(self, menuRole: PySide6.QtGui.QAction.MenuRole) -> None: ...
    def setPriority(self, priority: PySide6.QtGui.QAction.Priority) -> None: ...
    def setSeparator(self, b: bool) -> None: ...
    @overload
    def setShortcut(self, arg__1: PySide6.QtCore.Qt.Key) -> None: ...
    @overload
    def setShortcut(self, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> None: ...
    def setShortcutContext(self, context: PySide6.QtCore.Qt.ShortcutContext) -> None: ...
    def setShortcutVisibleInContextMenu(self, show: bool) -> None: ...
    @overload
    def setShortcuts(self, arg__1: PySide6.QtGui.QKeySequence.StandardKey) -> None: ...
    @overload
    def setShortcuts(self, shortcuts: Sequence[PySide6.QtGui.QKeySequence]) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def setWhatsThis(self, what: str) -> None: ...
    def shortcut(self) -> PySide6.QtGui.QKeySequence: ...
    def shortcutContext(self) -> PySide6.QtCore.Qt.ShortcutContext: ...
    def shortcuts(self) -> List[PySide6.QtGui.QKeySequence]: ...
    def showStatusText(self, object: Optional[PySide6.QtCore.QObject] = ...) -> bool: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def toggle(self) -> None: ...
    def toolTip(self) -> str: ...
    def trigger(self) -> None: ...
    def whatsThis(self) -> str: ...


class QActionEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QActionEvent) -> None: ...
    @overload
    def __init__(self, type: int, action: PySide6.QtGui.QAction, before: Optional[PySide6.QtGui.QAction] = ...) -> None: ...

    def action(self) -> PySide6.QtGui.QAction: ...
    def before(self) -> PySide6.QtGui.QAction: ...
    def clone(self) -> PySide6.QtGui.QActionEvent: ...


class QActionGroup(PySide6.QtCore.QObject):

    hovered                  : ClassVar[Signal] = ... # hovered(QAction*)
    triggered                : ClassVar[Signal] = ... # triggered(QAction*)

    class ExclusionPolicy(enum.Enum):

        None_                    : QActionGroup.ExclusionPolicy = ... # 0x0
        Exclusive                : QActionGroup.ExclusionPolicy = ... # 0x1
        ExclusiveOptional        : QActionGroup.ExclusionPolicy = ... # 0x2


    def __init__(self, parent: PySide6.QtCore.QObject) -> None: ...

    def actions(self) -> List[PySide6.QtGui.QAction]: ...
    @overload
    def addAction(self, a: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction: ...
    def checkedAction(self) -> PySide6.QtGui.QAction: ...
    def exclusionPolicy(self) -> PySide6.QtGui.QActionGroup.ExclusionPolicy: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def removeAction(self, a: PySide6.QtGui.QAction) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setExclusionPolicy(self, policy: PySide6.QtGui.QActionGroup.ExclusionPolicy) -> None: ...
    def setExclusive(self, arg__1: bool) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...


class QBackingStore(Shiboken.Object):

    def __init__(self, window: PySide6.QtGui.QWindow) -> None: ...

    def beginPaint(self, arg__1: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    def endPaint(self) -> None: ...
    def flush(self, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect], window: Optional[PySide6.QtGui.QWindow] = ..., offset: PySide6.QtCore.QPoint = ...) -> None: ...
    def hasStaticContents(self) -> bool: ...
    def paintDevice(self) -> PySide6.QtGui.QPaintDevice: ...
    def resize(self, size: PySide6.QtCore.QSize) -> None: ...
    def scroll(self, area: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect], dx: int, dy: int) -> bool: ...
    def setStaticContents(self, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def staticContents(self) -> PySide6.QtGui.QRegion: ...
    def window(self) -> PySide6.QtGui.QWindow: ...


class QBitmap(PySide6.QtGui.QPixmap):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QBitmap: Union[PySide6.QtGui.QBitmap, str]) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: Optional[bytes] = ...) -> None: ...
    @overload
    def __init__(self, w: int, h: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    @staticmethod
    def fromData(size: PySide6.QtCore.QSize, bits: bytes, monoFormat: PySide6.QtGui.QImage.Format = ...) -> PySide6.QtGui.QBitmap: ...
    @staticmethod
    def fromImage(image: Union[PySide6.QtGui.QImage, str], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QBitmap: ...
    @staticmethod
    def fromPixmap(pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> PySide6.QtGui.QBitmap: ...
    def swap(self, other: Union[PySide6.QtGui.QBitmap, str]) -> None: ...
    def transformed(self, matrix: PySide6.QtGui.QTransform) -> PySide6.QtGui.QBitmap: ...


class QBrush(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def __init__(self, bs: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def __init__(self, color: PySide6.QtCore.Qt.GlobalColor, bs: PySide6.QtCore.Qt.BrushStyle = ...) -> None: ...
    @overload
    def __init__(self, color: PySide6.QtCore.Qt.GlobalColor, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def __init__(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], bs: PySide6.QtCore.Qt.BrushStyle = ...) -> None: ...
    @overload
    def __init__(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def __init__(self, gradient: Union[PySide6.QtGui.QGradient, PySide6.QtGui.QGradient.Preset]) -> None: ...
    @overload
    def __init__(self, image: Union[PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def __init__(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def gradient(self) -> PySide6.QtGui.QGradient: ...
    def isOpaque(self) -> bool: ...
    @overload
    def setColor(self, color: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def setColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setStyle(self, arg__1: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    def setTexture(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def setTextureImage(self, image: Union[PySide6.QtGui.QImage, str]) -> None: ...
    def setTransform(self, arg__1: PySide6.QtGui.QTransform) -> None: ...
    def style(self) -> PySide6.QtCore.Qt.BrushStyle: ...
    def swap(self, other: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def texture(self) -> PySide6.QtGui.QPixmap: ...
    def textureImage(self) -> PySide6.QtGui.QImage: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...


class QClipboard(PySide6.QtCore.QObject):

    changed                  : ClassVar[Signal] = ... # changed(QClipboard::Mode)
    dataChanged              : ClassVar[Signal] = ... # dataChanged()
    findBufferChanged        : ClassVar[Signal] = ... # findBufferChanged()
    selectionChanged         : ClassVar[Signal] = ... # selectionChanged()

    class Mode(enum.Enum):

        Clipboard                : QClipboard.Mode = ... # 0x0
        Selection                : QClipboard.Mode = ... # 0x1
        FindBuffer               : QClipboard.Mode = ... # 0x2
        LastMode                 : QClipboard.Mode = ... # 0x2


    def clear(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    def image(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> PySide6.QtGui.QImage: ...
    def mimeData(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> PySide6.QtCore.QMimeData: ...
    def ownsClipboard(self) -> bool: ...
    def ownsFindBuffer(self) -> bool: ...
    def ownsSelection(self) -> bool: ...
    def pixmap(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> PySide6.QtGui.QPixmap: ...
    def setImage(self, arg__1: Union[PySide6.QtGui.QImage, str], mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    def setMimeData(self, data: PySide6.QtCore.QMimeData, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    def setPixmap(self, arg__1: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    def setText(self, arg__1: str, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    def supportsFindBuffer(self) -> bool: ...
    def supportsSelection(self) -> bool: ...
    @overload
    def text(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> str: ...
    @overload
    def text(self, subtype: str, mode: PySide6.QtGui.QClipboard.Mode = ...) -> Tuple: ...


class QCloseEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QCloseEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QCloseEvent: ...


class QColor(Shiboken.Object):

    class NameFormat(enum.Enum):

        HexRgb                   : QColor.NameFormat = ... # 0x0
        HexArgb                  : QColor.NameFormat = ... # 0x1


    class Spec(enum.Enum):

        Invalid                  : QColor.Spec = ... # 0x0
        Rgb                      : QColor.Spec = ... # 0x1
        Hsv                      : QColor.Spec = ... # 0x2
        Cmyk                     : QColor.Spec = ... # 0x3
        Hsl                      : QColor.Spec = ... # 0x4
        ExtendedRgb              : QColor.Spec = ... # 0x5


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: Any) -> None: ...
    @overload
    def __init__(self, color: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, r: int, g: int, b: int, a: int = ...) -> None: ...
    @overload
    def __init__(self, rgb: int) -> None: ...
    @overload
    def __init__(self, rgba64: PySide6.QtGui.QRgba64) -> None: ...
    @overload
    def __init__(self, spec: PySide6.QtGui.QColor.Spec, a1: int, a2: int, a3: int, a4: int, a5: int = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __setstate__(self, arg__1: object) -> object: ...
    def __str__(self) -> object: ...
    def alpha(self) -> int: ...
    def alphaF(self) -> float: ...
    def black(self) -> int: ...
    def blackF(self) -> float: ...
    def blue(self) -> int: ...
    def blueF(self) -> float: ...
    @staticmethod
    def colorNames() -> List[str]: ...
    def convertTo(self, colorSpec: PySide6.QtGui.QColor.Spec) -> PySide6.QtGui.QColor: ...
    def cyan(self) -> int: ...
    def cyanF(self) -> float: ...
    def darker(self, f: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromCmyk(c: int, m: int, y: int, k: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromCmykF(c: float, m: float, y: float, k: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHsl(h: int, s: int, l: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHslF(h: float, s: float, l: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHsv(h: int, s: int, v: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHsvF(h: float, s: float, v: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @overload
    @staticmethod
    def fromRgb(r: int, g: int, b: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @overload
    @staticmethod
    def fromRgb(rgb: int) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromRgbF(r: float, g: float, b: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromRgba(rgba: int) -> PySide6.QtGui.QColor: ...
    @overload
    @staticmethod
    def fromRgba64(r: int, g: int, b: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @overload
    @staticmethod
    def fromRgba64(rgba: PySide6.QtGui.QRgba64) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromString(name: str) -> PySide6.QtGui.QColor: ...
    def getCmyk(self) -> object: ...
    def getCmykF(self) -> object: ...
    def getHsl(self) -> object: ...
    def getHslF(self) -> object: ...
    def getHsv(self) -> object: ...
    def getHsvF(self) -> object: ...
    def getRgb(self) -> object: ...
    def getRgbF(self) -> object: ...
    def green(self) -> int: ...
    def greenF(self) -> float: ...
    def hslHue(self) -> int: ...
    def hslHueF(self) -> float: ...
    def hslSaturation(self) -> int: ...
    def hslSaturationF(self) -> float: ...
    def hsvHue(self) -> int: ...
    def hsvHueF(self) -> float: ...
    def hsvSaturation(self) -> int: ...
    def hsvSaturationF(self) -> float: ...
    def hue(self) -> int: ...
    def hueF(self) -> float: ...
    def isValid(self) -> bool: ...
    @overload
    @staticmethod
    def isValidColor(arg__1: str) -> bool: ...
    @overload
    @staticmethod
    def isValidColor(name: str) -> bool: ...
    @staticmethod
    def isValidColorName(arg__1: str) -> bool: ...
    def lighter(self, f: int = ...) -> PySide6.QtGui.QColor: ...
    def lightness(self) -> int: ...
    def lightnessF(self) -> float: ...
    def magenta(self) -> int: ...
    def magentaF(self) -> float: ...
    def name(self, format: PySide6.QtGui.QColor.NameFormat = ...) -> str: ...
    def red(self) -> int: ...
    def redF(self) -> float: ...
    def rgb(self) -> int: ...
    def rgba(self) -> int: ...
    def rgba64(self) -> PySide6.QtGui.QRgba64: ...
    def saturation(self) -> int: ...
    def saturationF(self) -> float: ...
    def setAlpha(self, alpha: int) -> None: ...
    def setAlphaF(self, alpha: float) -> None: ...
    def setBlue(self, blue: int) -> None: ...
    def setBlueF(self, blue: float) -> None: ...
    def setCmyk(self, c: int, m: int, y: int, k: int, a: int = ...) -> None: ...
    def setCmykF(self, c: float, m: float, y: float, k: float, a: float = ...) -> None: ...
    def setGreen(self, green: int) -> None: ...
    def setGreenF(self, green: float) -> None: ...
    def setHsl(self, h: int, s: int, l: int, a: int = ...) -> None: ...
    def setHslF(self, h: float, s: float, l: float, a: float = ...) -> None: ...
    def setHsv(self, h: int, s: int, v: int, a: int = ...) -> None: ...
    def setHsvF(self, h: float, s: float, v: float, a: float = ...) -> None: ...
    def setNamedColor(self, name: str) -> None: ...
    def setRed(self, red: int) -> None: ...
    def setRedF(self, red: float) -> None: ...
    @overload
    def setRgb(self, r: int, g: int, b: int, a: int = ...) -> None: ...
    @overload
    def setRgb(self, rgb: int) -> None: ...
    def setRgbF(self, r: float, g: float, b: float, a: float = ...) -> None: ...
    def setRgba(self, rgba: int) -> None: ...
    def setRgba64(self, rgba: PySide6.QtGui.QRgba64) -> None: ...
    def spec(self) -> PySide6.QtGui.QColor.Spec: ...
    def toCmyk(self) -> PySide6.QtGui.QColor: ...
    def toExtendedRgb(self) -> PySide6.QtGui.QColor: ...
    def toHsl(self) -> PySide6.QtGui.QColor: ...
    def toHsv(self) -> PySide6.QtGui.QColor: ...
    def toRgb(self) -> PySide6.QtGui.QColor: ...
    def toTuple(self) -> object: ...
    def value(self) -> int: ...
    def valueF(self) -> float: ...
    def yellow(self) -> int: ...
    def yellowF(self) -> float: ...


class QColorConstants(Shiboken.Object):

    class Svg(Shiboken.Object): ...


class QColorSpace(Shiboken.Object):

    class NamedColorSpace(enum.Enum):

        SRgb                     : QColorSpace.NamedColorSpace = ... # 0x1
        SRgbLinear               : QColorSpace.NamedColorSpace = ... # 0x2
        AdobeRgb                 : QColorSpace.NamedColorSpace = ... # 0x3
        DisplayP3                : QColorSpace.NamedColorSpace = ... # 0x4
        ProPhotoRgb              : QColorSpace.NamedColorSpace = ... # 0x5


    class Primaries(enum.Enum):

        Custom                   : QColorSpace.Primaries = ... # 0x0
        SRgb                     : QColorSpace.Primaries = ... # 0x1
        AdobeRgb                 : QColorSpace.Primaries = ... # 0x2
        DciP3D65                 : QColorSpace.Primaries = ... # 0x3
        ProPhotoRgb              : QColorSpace.Primaries = ... # 0x4


    class TransferFunction(enum.Enum):

        Custom                   : QColorSpace.TransferFunction = ... # 0x0
        Linear                   : QColorSpace.TransferFunction = ... # 0x1
        Gamma                    : QColorSpace.TransferFunction = ... # 0x2
        SRgb                     : QColorSpace.TransferFunction = ... # 0x3
        ProPhotoRgb              : QColorSpace.TransferFunction = ... # 0x4


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, colorSpace: Union[PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace]) -> None: ...
    @overload
    def __init__(self, namedColorSpace: PySide6.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    @overload
    def __init__(self, primaries: PySide6.QtGui.QColorSpace.Primaries, gamma: float) -> None: ...
    @overload
    def __init__(self, primaries: PySide6.QtGui.QColorSpace.Primaries, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @overload
    def __init__(self, primaries: PySide6.QtGui.QColorSpace.Primaries, transferFunctionTable: Sequence[int]) -> None: ...
    @overload
    def __init__(self, whitePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], redPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], greenPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], bluePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], redTransferFunctionTable: Sequence[int], greenTransferFunctionTable: Sequence[int], blueTransferFunctionTable: Sequence[int]) -> None: ...
    @overload
    def __init__(self, whitePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], redPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], greenPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], bluePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @overload
    def __init__(self, whitePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], redPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], greenPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], bluePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], transferFunctionTable: Sequence[int]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def description(self) -> str: ...
    @staticmethod
    def fromIccProfile(iccProfile: Union[PySide6.QtCore.QByteArray, bytes]) -> PySide6.QtGui.QColorSpace: ...
    def gamma(self) -> float: ...
    def iccProfile(self) -> PySide6.QtCore.QByteArray: ...
    def isValid(self) -> bool: ...
    def primaries(self) -> PySide6.QtGui.QColorSpace.Primaries: ...
    def setDescription(self, description: str) -> None: ...
    @overload
    def setPrimaries(self, primariesId: PySide6.QtGui.QColorSpace.Primaries) -> None: ...
    @overload
    def setPrimaries(self, whitePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], redPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], greenPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], bluePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setTransferFunction(self, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @overload
    def setTransferFunction(self, transferFunctionTable: Sequence[int]) -> None: ...
    def setTransferFunctions(self, redTransferFunctionTable: Sequence[int], greenTransferFunctionTable: Sequence[int], blueTransferFunctionTable: Sequence[int]) -> None: ...
    def swap(self, colorSpace: Union[PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace]) -> None: ...
    def transferFunction(self) -> PySide6.QtGui.QColorSpace.TransferFunction: ...
    def transformationToColorSpace(self, colorspace: Union[PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace]) -> PySide6.QtGui.QColorTransform: ...
    @overload
    def withTransferFunction(self, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> PySide6.QtGui.QColorSpace: ...
    @overload
    def withTransferFunction(self, transferFunctionTable: Sequence[int]) -> PySide6.QtGui.QColorSpace: ...
    def withTransferFunctions(self, redTransferFunctionTable: Sequence[int], greenTransferFunctionTable: Sequence[int], blueTransferFunctionTable: Sequence[int]) -> PySide6.QtGui.QColorSpace: ...


class QColorTransform(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, colorTransform: PySide6.QtGui.QColorTransform) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isIdentity(self) -> bool: ...
    @overload
    def map(self, argb: int) -> int: ...
    @overload
    def map(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> PySide6.QtGui.QColor: ...
    @overload
    def map(self, rgba64: PySide6.QtGui.QRgba64) -> PySide6.QtGui.QRgba64: ...
    def swap(self, other: PySide6.QtGui.QColorTransform) -> None: ...


class QConicalGradient(PySide6.QtGui.QGradient):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QConicalGradient: PySide6.QtGui.QConicalGradient) -> None: ...
    @overload
    def __init__(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], startAngle: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, startAngle: float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def angle(self) -> float: ...
    def center(self) -> PySide6.QtCore.QPointF: ...
    def setAngle(self, angle: float) -> None: ...
    @overload
    def setCenter(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setCenter(self, x: float, y: float) -> None: ...


class QContextMenuEvent(PySide6.QtGui.QInputEvent):

    class Reason(enum.Enum):

        Mouse                    : QContextMenuEvent.Reason = ... # 0x0
        Keyboard                 : QContextMenuEvent.Reason = ... # 0x1
        Other                    : QContextMenuEvent.Reason = ... # 0x2


    @overload
    def __init__(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None: ...
    @overload
    def __init__(self, reason: PySide6.QtGui.QContextMenuEvent.Reason, pos: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, reason: PySide6.QtGui.QContextMenuEvent.Reason, pos: PySide6.QtCore.QPoint, globalPos: PySide6.QtCore.QPoint, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QContextMenuEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def reason(self) -> PySide6.QtGui.QContextMenuEvent.Reason: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QCursor(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bitmap: Union[PySide6.QtGui.QBitmap, str], mask: Union[PySide6.QtGui.QBitmap, str], hotX: int = ..., hotY: int = ...) -> None: ...
    @overload
    def __init__(self, cursor: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def __init__(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], hotX: int = ..., hotY: int = ...) -> None: ...
    @overload
    def __init__(self, shape: PySide6.QtCore.Qt.CursorShape) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, outS: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, inS: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def bitmap(self) -> PySide6.QtGui.QBitmap: ...
    @overload
    def bitmap(self, arg__1: PySide6.QtCore.Qt.ReturnByValueConstant) -> PySide6.QtGui.QBitmap: ...
    def hotSpot(self) -> PySide6.QtCore.QPoint: ...
    @overload
    def mask(self) -> PySide6.QtGui.QBitmap: ...
    @overload
    def mask(self, arg__1: PySide6.QtCore.Qt.ReturnByValueConstant) -> PySide6.QtGui.QBitmap: ...
    def pixmap(self) -> PySide6.QtGui.QPixmap: ...
    @overload
    @staticmethod
    def pos() -> PySide6.QtCore.QPoint: ...
    @overload
    @staticmethod
    def pos(screen: PySide6.QtGui.QScreen) -> PySide6.QtCore.QPoint: ...
    @overload
    @staticmethod
    def setPos(p: PySide6.QtCore.QPoint) -> None: ...
    @overload
    @staticmethod
    def setPos(screen: PySide6.QtGui.QScreen, p: PySide6.QtCore.QPoint) -> None: ...
    @overload
    @staticmethod
    def setPos(screen: PySide6.QtGui.QScreen, x: int, y: int) -> None: ...
    @overload
    @staticmethod
    def setPos(x: int, y: int) -> None: ...
    def setShape(self, newShape: PySide6.QtCore.Qt.CursorShape) -> None: ...
    def shape(self) -> PySide6.QtCore.Qt.CursorShape: ...
    def swap(self, other: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...


class QDesktopServices(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def openUrl(url: Union[PySide6.QtCore.QUrl, str]) -> bool: ...
    @staticmethod
    def setUrlHandler(scheme: str, receiver: PySide6.QtCore.QObject, method: bytes) -> None: ...
    @staticmethod
    def unsetUrlHandler(scheme: str) -> None: ...


class QDoubleValidator(PySide6.QtGui.QValidator):

    bottomChanged            : ClassVar[Signal] = ... # bottomChanged(double)
    decimalsChanged          : ClassVar[Signal] = ... # decimalsChanged(int)
    notationChanged          : ClassVar[Signal] = ... # notationChanged(QDoubleValidator::Notation)
    topChanged               : ClassVar[Signal] = ... # topChanged(double)

    class Notation(enum.Enum):

        StandardNotation         : QDoubleValidator.Notation = ... # 0x0
        ScientificNotation       : QDoubleValidator.Notation = ... # 0x1


    @overload
    def __init__(self, bottom: float, top: float, decimals: int, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def bottom(self) -> float: ...
    def decimals(self) -> int: ...
    def fixup(self, input: str) -> str: ...
    def notation(self) -> PySide6.QtGui.QDoubleValidator.Notation: ...
    def setBottom(self, arg__1: float) -> None: ...
    def setDecimals(self, arg__1: int) -> None: ...
    def setNotation(self, arg__1: PySide6.QtGui.QDoubleValidator.Notation) -> None: ...
    @overload
    def setRange(self, bottom: float, top: float) -> None: ...
    @overload
    def setRange(self, bottom: float, top: float, decimals: int) -> None: ...
    def setTop(self, arg__1: float) -> None: ...
    def top(self) -> float: ...
    def validate(self, arg__1: str, arg__2: int) -> object: ...


class QDrag(PySide6.QtCore.QObject):

    actionChanged            : ClassVar[Signal] = ... # actionChanged(Qt::DropAction)
    targetChanged            : ClassVar[Signal] = ... # targetChanged(QObject*)

    def __init__(self, dragSource: PySide6.QtCore.QObject) -> None: ...

    @staticmethod
    def cancel() -> None: ...
    def defaultAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def dragCursor(self, action: PySide6.QtCore.Qt.DropAction) -> PySide6.QtGui.QPixmap: ...
    @overload
    def exec(self, supportedActions: PySide6.QtCore.Qt.DropAction, defaultAction: PySide6.QtCore.Qt.DropAction) -> PySide6.QtCore.Qt.DropAction: ...
    @overload
    def exec(self, supportedActions: PySide6.QtCore.Qt.DropAction = ...) -> PySide6.QtCore.Qt.DropAction: ...
    @overload
    def exec_(self, arg__1: PySide6.QtCore.Qt.DropAction, arg__2: PySide6.QtCore.Qt.DropAction) -> PySide6.QtCore.Qt.DropAction: ...
    @overload
    def exec_(self, supportedActions: PySide6.QtCore.Qt.DropAction = ...) -> PySide6.QtCore.Qt.DropAction: ...
    def hotSpot(self) -> PySide6.QtCore.QPoint: ...
    def mimeData(self) -> PySide6.QtCore.QMimeData: ...
    def pixmap(self) -> PySide6.QtGui.QPixmap: ...
    def setDragCursor(self, cursor: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], action: PySide6.QtCore.Qt.DropAction) -> None: ...
    def setHotSpot(self, hotspot: PySide6.QtCore.QPoint) -> None: ...
    def setMimeData(self, data: PySide6.QtCore.QMimeData) -> None: ...
    def setPixmap(self, arg__1: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def source(self) -> PySide6.QtCore.QObject: ...
    def supportedActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def target(self) -> PySide6.QtCore.QObject: ...


class QDragEnterEvent(PySide6.QtGui.QDragMoveEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QDragEnterEvent) -> None: ...
    @overload
    def __init__(self, pos: PySide6.QtCore.QPoint, actions: PySide6.QtCore.Qt.DropAction, data: PySide6.QtCore.QMimeData, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QDragEnterEvent: ...


class QDragLeaveEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QDragLeaveEvent) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QDragLeaveEvent: ...


class QDragMoveEvent(PySide6.QtGui.QDropEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QDragMoveEvent) -> None: ...
    @overload
    def __init__(self, pos: PySide6.QtCore.QPoint, actions: PySide6.QtCore.Qt.DropAction, data: PySide6.QtCore.QMimeData, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, type: PySide6.QtCore.QEvent.Type = ...) -> None: ...

    def __repr__(self) -> object: ...
    @overload
    def accept(self) -> None: ...
    @overload
    def accept(self, r: PySide6.QtCore.QRect) -> None: ...
    def answerRect(self) -> PySide6.QtCore.QRect: ...
    def clone(self) -> PySide6.QtGui.QDragMoveEvent: ...
    @overload
    def ignore(self) -> None: ...
    @overload
    def ignore(self, r: PySide6.QtCore.QRect) -> None: ...


class QDropEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QDropEvent) -> None: ...
    @overload
    def __init__(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], actions: PySide6.QtCore.Qt.DropAction, data: PySide6.QtCore.QMimeData, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, type: PySide6.QtCore.QEvent.Type = ...) -> None: ...

    def __repr__(self) -> object: ...
    def acceptProposedAction(self) -> None: ...
    def buttons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def clone(self) -> PySide6.QtGui.QDropEvent: ...
    def dropAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def keyboardModifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def mimeData(self) -> PySide6.QtCore.QMimeData: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def mouseButtons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def posF(self) -> PySide6.QtCore.QPointF: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def possibleActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def proposedAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def setDropAction(self, action: PySide6.QtCore.Qt.DropAction) -> None: ...
    def source(self) -> PySide6.QtCore.QObject: ...


class QEnterEvent(PySide6.QtGui.QSinglePointEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QEnterEvent) -> None: ...
    @overload
    def __init__(self, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scenePos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QEnterEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def windowPos(self) -> PySide6.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QEventPoint(Shiboken.Object):

    class State(enum.Enum):

        Unknown                  : QEventPoint.State = ... # 0x0
        Pressed                  : QEventPoint.State = ... # 0x1
        Updated                  : QEventPoint.State = ... # 0x2
        Stationary               : QEventPoint.State = ... # 0x4
        Released                 : QEventPoint.State = ... # 0x8


    @overload
    def __init__(self, id: int = ..., device: Optional[PySide6.QtGui.QPointingDevice] = ...) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QEventPoint) -> None: ...
    @overload
    def __init__(self, pointId: int, state: PySide6.QtGui.QEventPoint.State, scenePosition: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPosition: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def device(self) -> PySide6.QtGui.QPointingDevice: ...
    def ellipseDiameters(self) -> PySide6.QtCore.QSizeF: ...
    def globalGrabPosition(self) -> PySide6.QtCore.QPointF: ...
    def globalLastPosition(self) -> PySide6.QtCore.QPointF: ...
    def globalPosition(self) -> PySide6.QtCore.QPointF: ...
    def globalPressPosition(self) -> PySide6.QtCore.QPointF: ...
    def grabPosition(self) -> PySide6.QtCore.QPointF: ...
    def id(self) -> int: ...
    def isAccepted(self) -> bool: ...
    def lastNormalizedPos(self) -> PySide6.QtCore.QPointF: ...
    def lastPos(self) -> PySide6.QtCore.QPointF: ...
    def lastPosition(self) -> PySide6.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide6.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide6.QtCore.QPointF: ...
    def lastTimestamp(self) -> int: ...
    def normalizedPos(self) -> PySide6.QtCore.QPointF: ...
    def normalizedPosition(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def pressPosition(self) -> PySide6.QtCore.QPointF: ...
    def pressTimestamp(self) -> int: ...
    def pressure(self) -> float: ...
    def rotation(self) -> float: ...
    def sceneGrabPosition(self) -> PySide6.QtCore.QPointF: ...
    def sceneLastPosition(self) -> PySide6.QtCore.QPointF: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def scenePosition(self) -> PySide6.QtCore.QPointF: ...
    def scenePressPosition(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def setAccepted(self, accepted: bool = ...) -> None: ...
    def startNormalizedPos(self) -> PySide6.QtCore.QPointF: ...
    def startPos(self) -> PySide6.QtCore.QPointF: ...
    def startScenePos(self) -> PySide6.QtCore.QPointF: ...
    def startScreenPos(self) -> PySide6.QtCore.QPointF: ...
    def state(self) -> PySide6.QtGui.QEventPoint.State: ...
    def swap(self, other: PySide6.QtGui.QEventPoint) -> None: ...
    def timeHeld(self) -> float: ...
    def timestamp(self) -> int: ...
    def uniqueId(self) -> PySide6.QtGui.QPointingDeviceUniqueId: ...
    def velocity(self) -> PySide6.QtGui.QVector2D: ...


class QExposeEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    @overload
    def __init__(self, m_region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...

    def clone(self) -> PySide6.QtGui.QExposeEvent: ...
    def region(self) -> PySide6.QtGui.QRegion: ...


class QFileOpenEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QFileOpenEvent) -> None: ...
    @overload
    def __init__(self, file: str) -> None: ...
    @overload
    def __init__(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...

    def clone(self) -> PySide6.QtGui.QFileOpenEvent: ...
    def file(self) -> str: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QFocusEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, reason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QFocusEvent: ...
    def gotFocus(self) -> bool: ...
    def lostFocus(self) -> bool: ...
    def reason(self) -> PySide6.QtCore.Qt.FocusReason: ...


class QFont(Shiboken.Object):

    class Capitalization(enum.Enum):

        MixedCase                : QFont.Capitalization = ... # 0x0
        AllUppercase             : QFont.Capitalization = ... # 0x1
        AllLowercase             : QFont.Capitalization = ... # 0x2
        SmallCaps                : QFont.Capitalization = ... # 0x3
        Capitalize               : QFont.Capitalization = ... # 0x4


    class HintingPreference(enum.Enum):

        PreferDefaultHinting     : QFont.HintingPreference = ... # 0x0
        PreferNoHinting          : QFont.HintingPreference = ... # 0x1
        PreferVerticalHinting    : QFont.HintingPreference = ... # 0x2
        PreferFullHinting        : QFont.HintingPreference = ... # 0x3


    class SpacingType(enum.Enum):

        PercentageSpacing        : QFont.SpacingType = ... # 0x0
        AbsoluteSpacing          : QFont.SpacingType = ... # 0x1


    class Stretch(enum.IntEnum):

        AnyStretch               : QFont.Stretch = ... # 0x0
        UltraCondensed           : QFont.Stretch = ... # 0x32
        ExtraCondensed           : QFont.Stretch = ... # 0x3e
        Condensed                : QFont.Stretch = ... # 0x4b
        SemiCondensed            : QFont.Stretch = ... # 0x57
        Unstretched              : QFont.Stretch = ... # 0x64
        SemiExpanded             : QFont.Stretch = ... # 0x70
        Expanded                 : QFont.Stretch = ... # 0x7d
        ExtraExpanded            : QFont.Stretch = ... # 0x96
        UltraExpanded            : QFont.Stretch = ... # 0xc8


    class Style(enum.Enum):

        StyleNormal              : QFont.Style = ... # 0x0
        StyleItalic              : QFont.Style = ... # 0x1
        StyleOblique             : QFont.Style = ... # 0x2


    class StyleHint(enum.Enum):

        Helvetica                : QFont.StyleHint = ... # 0x0
        SansSerif                : QFont.StyleHint = ... # 0x0
        Serif                    : QFont.StyleHint = ... # 0x1
        Times                    : QFont.StyleHint = ... # 0x1
        Courier                  : QFont.StyleHint = ... # 0x2
        TypeWriter               : QFont.StyleHint = ... # 0x2
        Decorative               : QFont.StyleHint = ... # 0x3
        OldEnglish               : QFont.StyleHint = ... # 0x3
        System                   : QFont.StyleHint = ... # 0x4
        AnyStyle                 : QFont.StyleHint = ... # 0x5
        Cursive                  : QFont.StyleHint = ... # 0x6
        Monospace                : QFont.StyleHint = ... # 0x7
        Fantasy                  : QFont.StyleHint = ... # 0x8


    class StyleStrategy(enum.Flag):

        PreferDefault            : QFont.StyleStrategy = ... # 0x1
        PreferBitmap             : QFont.StyleStrategy = ... # 0x2
        PreferDevice             : QFont.StyleStrategy = ... # 0x4
        PreferOutline            : QFont.StyleStrategy = ... # 0x8
        ForceOutline             : QFont.StyleStrategy = ... # 0x10
        PreferMatch              : QFont.StyleStrategy = ... # 0x20
        PreferQuality            : QFont.StyleStrategy = ... # 0x40
        PreferAntialias          : QFont.StyleStrategy = ... # 0x80
        NoAntialias              : QFont.StyleStrategy = ... # 0x100
        NoSubpixelAntialias      : QFont.StyleStrategy = ... # 0x800
        PreferNoShaping          : QFont.StyleStrategy = ... # 0x1000
        NoFontMerging            : QFont.StyleStrategy = ... # 0x8000


    class Weight(enum.IntEnum):

        Thin                     : QFont.Weight = ... # 0x64
        ExtraLight               : QFont.Weight = ... # 0xc8
        Light                    : QFont.Weight = ... # 0x12c
        Normal                   : QFont.Weight = ... # 0x190
        Medium                   : QFont.Weight = ... # 0x1f4
        DemiBold                 : QFont.Weight = ... # 0x258
        Bold                     : QFont.Weight = ... # 0x2bc
        ExtraBold                : QFont.Weight = ... # 0x320
        Black                    : QFont.Weight = ... # 0x384


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, families: Sequence[str], pointSize: int = ..., weight: int = ..., italic: bool = ...) -> None: ...
    @overload
    def __init__(self, family: str, pointSize: int = ..., weight: int = ..., italic: bool = ...) -> None: ...
    @overload
    def __init__(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @overload
    def __init__(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]], pd: PySide6.QtGui.QPaintDevice) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def bold(self) -> bool: ...
    @staticmethod
    def cacheStatistics() -> None: ...
    def capitalization(self) -> PySide6.QtGui.QFont.Capitalization: ...
    @staticmethod
    def cleanup() -> None: ...
    def defaultFamily(self) -> str: ...
    def exactMatch(self) -> bool: ...
    def families(self) -> List[str]: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def fromString(self, arg__1: str) -> bool: ...
    def hintingPreference(self) -> PySide6.QtGui.QFont.HintingPreference: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def insertSubstitution(arg__1: str, arg__2: str) -> None: ...
    @staticmethod
    def insertSubstitutions(arg__1: str, arg__2: Sequence[str]) -> None: ...
    def isCopyOf(self, arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> bool: ...
    def italic(self) -> bool: ...
    def kerning(self) -> bool: ...
    def key(self) -> str: ...
    def legacyWeight(self) -> int: ...
    def letterSpacing(self) -> float: ...
    def letterSpacingType(self) -> PySide6.QtGui.QFont.SpacingType: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    @staticmethod
    def removeSubstitutions(arg__1: str) -> None: ...
    def resolve(self, arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> PySide6.QtGui.QFont: ...
    def resolveMask(self) -> int: ...
    def setBold(self, arg__1: bool) -> None: ...
    def setCapitalization(self, arg__1: PySide6.QtGui.QFont.Capitalization) -> None: ...
    def setFamilies(self, arg__1: Sequence[str]) -> None: ...
    def setFamily(self, arg__1: str) -> None: ...
    def setFixedPitch(self, arg__1: bool) -> None: ...
    def setHintingPreference(self, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def setItalic(self, b: bool) -> None: ...
    def setKerning(self, arg__1: bool) -> None: ...
    def setLegacyWeight(self, legacyWeight: int) -> None: ...
    def setLetterSpacing(self, type: PySide6.QtGui.QFont.SpacingType, spacing: float) -> None: ...
    def setOverline(self, arg__1: bool) -> None: ...
    def setPixelSize(self, arg__1: int) -> None: ...
    def setPointSize(self, arg__1: int) -> None: ...
    def setPointSizeF(self, arg__1: float) -> None: ...
    def setResolveMask(self, mask: int) -> None: ...
    def setStretch(self, arg__1: int) -> None: ...
    def setStrikeOut(self, arg__1: bool) -> None: ...
    def setStyle(self, style: PySide6.QtGui.QFont.Style) -> None: ...
    def setStyleHint(self, arg__1: PySide6.QtGui.QFont.StyleHint, strategy: PySide6.QtGui.QFont.StyleStrategy = ...) -> None: ...
    def setStyleName(self, arg__1: str) -> None: ...
    def setStyleStrategy(self, s: PySide6.QtGui.QFont.StyleStrategy) -> None: ...
    def setUnderline(self, arg__1: bool) -> None: ...
    def setWeight(self, weight: PySide6.QtGui.QFont.Weight) -> None: ...
    def setWordSpacing(self, spacing: float) -> None: ...
    def stretch(self) -> int: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide6.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide6.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def styleStrategy(self) -> PySide6.QtGui.QFont.StyleStrategy: ...
    @staticmethod
    def substitute(arg__1: str) -> str: ...
    @staticmethod
    def substitutes(arg__1: str) -> List[str]: ...
    @staticmethod
    def substitutions() -> List[str]: ...
    def swap(self, other: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def toString(self) -> str: ...
    def underline(self) -> bool: ...
    def weight(self) -> PySide6.QtGui.QFont.Weight: ...
    def wordSpacing(self) -> float: ...


class QFontDatabase(Shiboken.Object):

    class SystemFont(enum.Enum):

        GeneralFont              : QFontDatabase.SystemFont = ... # 0x0
        FixedFont                : QFontDatabase.SystemFont = ... # 0x1
        TitleFont                : QFontDatabase.SystemFont = ... # 0x2
        SmallestReadableFont     : QFontDatabase.SystemFont = ... # 0x3


    class WritingSystem(enum.Enum):

        Any                      : QFontDatabase.WritingSystem = ... # 0x0
        Latin                    : QFontDatabase.WritingSystem = ... # 0x1
        Greek                    : QFontDatabase.WritingSystem = ... # 0x2
        Cyrillic                 : QFontDatabase.WritingSystem = ... # 0x3
        Armenian                 : QFontDatabase.WritingSystem = ... # 0x4
        Hebrew                   : QFontDatabase.WritingSystem = ... # 0x5
        Arabic                   : QFontDatabase.WritingSystem = ... # 0x6
        Syriac                   : QFontDatabase.WritingSystem = ... # 0x7
        Thaana                   : QFontDatabase.WritingSystem = ... # 0x8
        Devanagari               : QFontDatabase.WritingSystem = ... # 0x9
        Bengali                  : QFontDatabase.WritingSystem = ... # 0xa
        Gurmukhi                 : QFontDatabase.WritingSystem = ... # 0xb
        Gujarati                 : QFontDatabase.WritingSystem = ... # 0xc
        Oriya                    : QFontDatabase.WritingSystem = ... # 0xd
        Tamil                    : QFontDatabase.WritingSystem = ... # 0xe
        Telugu                   : QFontDatabase.WritingSystem = ... # 0xf
        Kannada                  : QFontDatabase.WritingSystem = ... # 0x10
        Malayalam                : QFontDatabase.WritingSystem = ... # 0x11
        Sinhala                  : QFontDatabase.WritingSystem = ... # 0x12
        Thai                     : QFontDatabase.WritingSystem = ... # 0x13
        Lao                      : QFontDatabase.WritingSystem = ... # 0x14
        Tibetan                  : QFontDatabase.WritingSystem = ... # 0x15
        Myanmar                  : QFontDatabase.WritingSystem = ... # 0x16
        Georgian                 : QFontDatabase.WritingSystem = ... # 0x17
        Khmer                    : QFontDatabase.WritingSystem = ... # 0x18
        SimplifiedChinese        : QFontDatabase.WritingSystem = ... # 0x19
        TraditionalChinese       : QFontDatabase.WritingSystem = ... # 0x1a
        Japanese                 : QFontDatabase.WritingSystem = ... # 0x1b
        Korean                   : QFontDatabase.WritingSystem = ... # 0x1c
        Vietnamese               : QFontDatabase.WritingSystem = ... # 0x1d
        Other                    : QFontDatabase.WritingSystem = ... # 0x1e
        Symbol                   : QFontDatabase.WritingSystem = ... # 0x1e
        Ogham                    : QFontDatabase.WritingSystem = ... # 0x1f
        Runic                    : QFontDatabase.WritingSystem = ... # 0x20
        Nko                      : QFontDatabase.WritingSystem = ... # 0x21
        WritingSystemsCount      : QFontDatabase.WritingSystem = ... # 0x22


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QFontDatabase: PySide6.QtGui.QFontDatabase) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def addApplicationFont(fileName: str) -> int: ...
    @staticmethod
    def addApplicationFontFromData(fontData: Union[PySide6.QtCore.QByteArray, bytes]) -> int: ...
    @staticmethod
    def applicationFontFamilies(id: int) -> List[str]: ...
    @staticmethod
    def bold(family: str, style: str) -> bool: ...
    @staticmethod
    def families(writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem = ...) -> List[str]: ...
    @staticmethod
    def font(family: str, style: str, pointSize: int) -> PySide6.QtGui.QFont: ...
    @staticmethod
    def hasFamily(family: str) -> bool: ...
    @staticmethod
    def isBitmapScalable(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def isFixedPitch(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def isPrivateFamily(family: str) -> bool: ...
    @staticmethod
    def isScalable(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def isSmoothlyScalable(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def italic(family: str, style: str) -> bool: ...
    @staticmethod
    def pointSizes(family: str, style: str = ...) -> List[int]: ...
    @staticmethod
    def removeAllApplicationFonts() -> bool: ...
    @staticmethod
    def removeApplicationFont(id: int) -> bool: ...
    @staticmethod
    def smoothSizes(family: str, style: str) -> List[int]: ...
    @staticmethod
    def standardSizes() -> List[int]: ...
    @overload
    @staticmethod
    def styleString(font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> str: ...
    @overload
    @staticmethod
    def styleString(fontInfo: Union[PySide6.QtGui.QFontInfo, PySide6.QtGui.QFont]) -> str: ...
    @staticmethod
    def styles(family: str) -> List[str]: ...
    @staticmethod
    def systemFont(type: PySide6.QtGui.QFontDatabase.SystemFont) -> PySide6.QtGui.QFont: ...
    @staticmethod
    def weight(family: str, style: str) -> int: ...
    @staticmethod
    def writingSystemName(writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @staticmethod
    def writingSystemSample(writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @overload
    @staticmethod
    def writingSystems() -> List[PySide6.QtGui.QFontDatabase.WritingSystem]: ...
    @overload
    @staticmethod
    def writingSystems(family: str) -> List[PySide6.QtGui.QFontDatabase.WritingSystem]: ...


class QFontInfo(Shiboken.Object):

    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QFontInfo, PySide6.QtGui.QFont]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bold(self) -> bool: ...
    def exactMatch(self) -> bool: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def italic(self) -> bool: ...
    def legacyWeight(self) -> int: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide6.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide6.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def swap(self, other: Union[PySide6.QtGui.QFontInfo, PySide6.QtGui.QFont]) -> None: ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...


class QFontMetrics(Shiboken.Object):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QFontMetrics) -> None: ...
    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @overload
    def __init__(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]], pd: PySide6.QtGui.QPaintDevice) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> int: ...
    def averageCharWidth(self) -> int: ...
    @overload
    def boundingRect(self, r: PySide6.QtCore.QRect, flags: int, text: str, tabstops: int, tabarray: object = ...) -> PySide6.QtCore.QRect: ...
    @overload
    def boundingRect(self, text: str) -> PySide6.QtCore.QRect: ...
    @overload
    def boundingRect(self, text: str, textOption: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> PySide6.QtCore.QRect: ...
    @overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str, tabstops: int, tabarray: object = ...) -> PySide6.QtCore.QRect: ...
    def boundingRectChar(self, arg__1: int) -> PySide6.QtCore.QRect: ...
    def capHeight(self) -> int: ...
    def descent(self) -> int: ...
    def elidedText(self, text: str, mode: PySide6.QtCore.Qt.TextElideMode, width: int, flags: int = ...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> int: ...
    @overload
    def horizontalAdvance(self, arg__1: str, len: int = ...) -> int: ...
    @overload
    def horizontalAdvance(self, arg__1: str, textOption: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> int: ...
    def horizontalAdvanceChar(self, arg__1: int) -> int: ...
    def inFont(self, arg__1: str) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> int: ...
    def leftBearing(self, arg__1: str) -> int: ...
    def lineSpacing(self) -> int: ...
    def lineWidth(self) -> int: ...
    def maxWidth(self) -> int: ...
    def minLeftBearing(self) -> int: ...
    def minRightBearing(self) -> int: ...
    def overlinePos(self) -> int: ...
    def rightBearing(self, arg__1: str) -> int: ...
    def size(self, flags: int, str: str, tabstops: int, tabarray: object = ...) -> PySide6.QtCore.QSize: ...
    def strikeOutPos(self) -> int: ...
    def swap(self, other: PySide6.QtGui.QFontMetrics) -> None: ...
    @overload
    def tightBoundingRect(self, text: str) -> PySide6.QtCore.QRect: ...
    @overload
    def tightBoundingRect(self, text: str, textOption: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> PySide6.QtCore.QRect: ...
    def underlinePos(self) -> int: ...
    def xHeight(self) -> int: ...


class QFontMetricsF(Shiboken.Object):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QFontMetrics) -> None: ...
    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QFontMetricsF, PySide6.QtGui.QFontMetrics]) -> None: ...
    @overload
    def __init__(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @overload
    def __init__(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]], pd: PySide6.QtGui.QPaintDevice) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    @overload
    def boundingRect(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], flags: int, string: str, tabstops: int, tabarray: object = ...) -> PySide6.QtCore.QRectF: ...
    @overload
    def boundingRect(self, string: str) -> PySide6.QtCore.QRectF: ...
    @overload
    def boundingRect(self, text: str, textOption: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> PySide6.QtCore.QRectF: ...
    def boundingRectChar(self, arg__1: int) -> PySide6.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def elidedText(self, text: str, mode: PySide6.QtCore.Qt.TextElideMode, width: float, flags: int = ...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> float: ...
    @overload
    def horizontalAdvance(self, string: str, length: int = ...) -> float: ...
    @overload
    def horizontalAdvance(self, string: str, textOption: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> float: ...
    def horizontalAdvanceChar(self, arg__1: int) -> float: ...
    def inFont(self, arg__1: str) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> float: ...
    def leftBearing(self, arg__1: str) -> float: ...
    def lineSpacing(self) -> float: ...
    def lineWidth(self) -> float: ...
    def maxWidth(self) -> float: ...
    def minLeftBearing(self) -> float: ...
    def minRightBearing(self) -> float: ...
    def overlinePos(self) -> float: ...
    def rightBearing(self, arg__1: str) -> float: ...
    def size(self, flags: int, str: str, tabstops: int, tabarray: object = ...) -> PySide6.QtCore.QSizeF: ...
    def strikeOutPos(self) -> float: ...
    def swap(self, other: Union[PySide6.QtGui.QFontMetricsF, PySide6.QtGui.QFontMetrics]) -> None: ...
    @overload
    def tightBoundingRect(self, text: str) -> PySide6.QtCore.QRectF: ...
    @overload
    def tightBoundingRect(self, text: str, textOption: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> PySide6.QtCore.QRectF: ...
    def underlinePos(self) -> float: ...
    def xHeight(self) -> float: ...


class QGlyphRun(Shiboken.Object):

    class GlyphRunFlag(enum.Flag):

        Overline                 : QGlyphRun.GlyphRunFlag = ... # 0x1
        Underline                : QGlyphRun.GlyphRunFlag = ... # 0x2
        StrikeOut                : QGlyphRun.GlyphRunFlag = ... # 0x4
        RightToLeft              : QGlyphRun.GlyphRunFlag = ... # 0x8
        SplitLigature            : QGlyphRun.GlyphRunFlag = ... # 0x10


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QGlyphRun) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def clear(self) -> None: ...
    def flags(self) -> PySide6.QtGui.QGlyphRun.GlyphRunFlag: ...
    def glyphIndexes(self) -> List[int]: ...
    def isEmpty(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def overline(self) -> bool: ...
    def positions(self) -> List[PySide6.QtCore.QPointF]: ...
    def rawFont(self) -> PySide6.QtGui.QRawFont: ...
    def setBoundingRect(self, boundingRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setFlag(self, flag: PySide6.QtGui.QGlyphRun.GlyphRunFlag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtGui.QGlyphRun.GlyphRunFlag) -> None: ...
    def setGlyphIndexes(self, glyphIndexes: Sequence[int]) -> None: ...
    def setOverline(self, overline: bool) -> None: ...
    def setPositions(self, positions: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    def setRawData(self, glyphIndexArray: int, glyphPositionArray: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], size: int) -> None: ...
    def setRawFont(self, rawFont: PySide6.QtGui.QRawFont) -> None: ...
    def setRightToLeft(self, on: bool) -> None: ...
    def setStrikeOut(self, strikeOut: bool) -> None: ...
    def setUnderline(self, underline: bool) -> None: ...
    def strikeOut(self) -> bool: ...
    def swap(self, other: PySide6.QtGui.QGlyphRun) -> None: ...
    def underline(self) -> bool: ...


class QGradient(Shiboken.Object):

    class CoordinateMode(enum.Enum):

        LogicalMode              : QGradient.CoordinateMode = ... # 0x0
        StretchToDeviceMode      : QGradient.CoordinateMode = ... # 0x1
        ObjectBoundingMode       : QGradient.CoordinateMode = ... # 0x2
        ObjectMode               : QGradient.CoordinateMode = ... # 0x3


    class InterpolationMode(enum.Enum):

        ColorInterpolation       : QGradient.InterpolationMode = ... # 0x0
        ComponentInterpolation   : QGradient.InterpolationMode = ... # 0x1


    class Preset(enum.Enum):

        WarmFlame                : QGradient.Preset = ... # 0x1
        NightFade                : QGradient.Preset = ... # 0x2
        SpringWarmth             : QGradient.Preset = ... # 0x3
        JuicyPeach               : QGradient.Preset = ... # 0x4
        YoungPassion             : QGradient.Preset = ... # 0x5
        LadyLips                 : QGradient.Preset = ... # 0x6
        SunnyMorning             : QGradient.Preset = ... # 0x7
        RainyAshville            : QGradient.Preset = ... # 0x8
        FrozenDreams             : QGradient.Preset = ... # 0x9
        WinterNeva               : QGradient.Preset = ... # 0xa
        DustyGrass               : QGradient.Preset = ... # 0xb
        TemptingAzure            : QGradient.Preset = ... # 0xc
        HeavyRain                : QGradient.Preset = ... # 0xd
        AmyCrisp                 : QGradient.Preset = ... # 0xe
        MeanFruit                : QGradient.Preset = ... # 0xf
        DeepBlue                 : QGradient.Preset = ... # 0x10
        RipeMalinka              : QGradient.Preset = ... # 0x11
        CloudyKnoxville          : QGradient.Preset = ... # 0x12
        MalibuBeach              : QGradient.Preset = ... # 0x13
        NewLife                  : QGradient.Preset = ... # 0x14
        TrueSunset               : QGradient.Preset = ... # 0x15
        MorpheusDen              : QGradient.Preset = ... # 0x16
        RareWind                 : QGradient.Preset = ... # 0x17
        NearMoon                 : QGradient.Preset = ... # 0x18
        WildApple                : QGradient.Preset = ... # 0x19
        SaintPetersburg          : QGradient.Preset = ... # 0x1a
        PlumPlate                : QGradient.Preset = ... # 0x1c
        EverlastingSky           : QGradient.Preset = ... # 0x1d
        HappyFisher              : QGradient.Preset = ... # 0x1e
        Blessing                 : QGradient.Preset = ... # 0x1f
        SharpeyeEagle            : QGradient.Preset = ... # 0x20
        LadogaBottom             : QGradient.Preset = ... # 0x21
        LemonGate                : QGradient.Preset = ... # 0x22
        ItmeoBranding            : QGradient.Preset = ... # 0x23
        ZeusMiracle              : QGradient.Preset = ... # 0x24
        OldHat                   : QGradient.Preset = ... # 0x25
        StarWine                 : QGradient.Preset = ... # 0x26
        HappyAcid                : QGradient.Preset = ... # 0x29
        AwesomePine              : QGradient.Preset = ... # 0x2a
        NewYork                  : QGradient.Preset = ... # 0x2b
        ShyRainbow               : QGradient.Preset = ... # 0x2c
        MixedHopes               : QGradient.Preset = ... # 0x2e
        FlyHigh                  : QGradient.Preset = ... # 0x2f
        StrongBliss              : QGradient.Preset = ... # 0x30
        FreshMilk                : QGradient.Preset = ... # 0x31
        SnowAgain                : QGradient.Preset = ... # 0x32
        FebruaryInk              : QGradient.Preset = ... # 0x33
        KindSteel                : QGradient.Preset = ... # 0x34
        SoftGrass                : QGradient.Preset = ... # 0x35
        GrownEarly               : QGradient.Preset = ... # 0x36
        SharpBlues               : QGradient.Preset = ... # 0x37
        ShadyWater               : QGradient.Preset = ... # 0x38
        DirtyBeauty              : QGradient.Preset = ... # 0x39
        GreatWhale               : QGradient.Preset = ... # 0x3a
        TeenNotebook             : QGradient.Preset = ... # 0x3b
        PoliteRumors             : QGradient.Preset = ... # 0x3c
        SweetPeriod              : QGradient.Preset = ... # 0x3d
        WideMatrix               : QGradient.Preset = ... # 0x3e
        SoftCherish              : QGradient.Preset = ... # 0x3f
        RedSalvation             : QGradient.Preset = ... # 0x40
        BurningSpring            : QGradient.Preset = ... # 0x41
        NightParty               : QGradient.Preset = ... # 0x42
        SkyGlider                : QGradient.Preset = ... # 0x43
        HeavenPeach              : QGradient.Preset = ... # 0x44
        PurpleDivision           : QGradient.Preset = ... # 0x45
        AquaSplash               : QGradient.Preset = ... # 0x46
        SpikyNaga                : QGradient.Preset = ... # 0x48
        LoveKiss                 : QGradient.Preset = ... # 0x49
        CleanMirror              : QGradient.Preset = ... # 0x4b
        PremiumDark              : QGradient.Preset = ... # 0x4c
        ColdEvening              : QGradient.Preset = ... # 0x4d
        CochitiLake              : QGradient.Preset = ... # 0x4e
        SummerGames              : QGradient.Preset = ... # 0x4f
        PassionateBed            : QGradient.Preset = ... # 0x50
        MountainRock             : QGradient.Preset = ... # 0x51
        DesertHump               : QGradient.Preset = ... # 0x52
        JungleDay                : QGradient.Preset = ... # 0x53
        PhoenixStart             : QGradient.Preset = ... # 0x54
        OctoberSilence           : QGradient.Preset = ... # 0x55
        FarawayRiver             : QGradient.Preset = ... # 0x56
        AlchemistLab             : QGradient.Preset = ... # 0x57
        OverSun                  : QGradient.Preset = ... # 0x58
        PremiumWhite             : QGradient.Preset = ... # 0x59
        MarsParty                : QGradient.Preset = ... # 0x5a
        EternalConstance         : QGradient.Preset = ... # 0x5b
        JapanBlush               : QGradient.Preset = ... # 0x5c
        SmilingRain              : QGradient.Preset = ... # 0x5d
        CloudyApple              : QGradient.Preset = ... # 0x5e
        BigMango                 : QGradient.Preset = ... # 0x5f
        HealthyWater             : QGradient.Preset = ... # 0x60
        AmourAmour               : QGradient.Preset = ... # 0x61
        RiskyConcrete            : QGradient.Preset = ... # 0x62
        StrongStick              : QGradient.Preset = ... # 0x63
        ViciousStance            : QGradient.Preset = ... # 0x64
        PaloAlto                 : QGradient.Preset = ... # 0x65
        HappyMemories            : QGradient.Preset = ... # 0x66
        MidnightBloom            : QGradient.Preset = ... # 0x67
        Crystalline              : QGradient.Preset = ... # 0x68
        PartyBliss               : QGradient.Preset = ... # 0x6a
        ConfidentCloud           : QGradient.Preset = ... # 0x6b
        LeCocktail               : QGradient.Preset = ... # 0x6c
        RiverCity                : QGradient.Preset = ... # 0x6d
        FrozenBerry              : QGradient.Preset = ... # 0x6e
        ChildCare                : QGradient.Preset = ... # 0x70
        FlyingLemon              : QGradient.Preset = ... # 0x71
        NewRetrowave             : QGradient.Preset = ... # 0x72
        HiddenJaguar             : QGradient.Preset = ... # 0x73
        AboveTheSky              : QGradient.Preset = ... # 0x74
        Nega                     : QGradient.Preset = ... # 0x75
        DenseWater               : QGradient.Preset = ... # 0x76
        Seashore                 : QGradient.Preset = ... # 0x78
        MarbleWall               : QGradient.Preset = ... # 0x79
        CheerfulCaramel          : QGradient.Preset = ... # 0x7a
        NightSky                 : QGradient.Preset = ... # 0x7b
        MagicLake                : QGradient.Preset = ... # 0x7c
        YoungGrass               : QGradient.Preset = ... # 0x7d
        ColorfulPeach            : QGradient.Preset = ... # 0x7e
        GentleCare               : QGradient.Preset = ... # 0x7f
        PlumBath                 : QGradient.Preset = ... # 0x80
        HappyUnicorn             : QGradient.Preset = ... # 0x81
        AfricanField             : QGradient.Preset = ... # 0x83
        SolidStone               : QGradient.Preset = ... # 0x84
        OrangeJuice              : QGradient.Preset = ... # 0x85
        GlassWater               : QGradient.Preset = ... # 0x86
        NorthMiracle             : QGradient.Preset = ... # 0x88
        FruitBlend               : QGradient.Preset = ... # 0x89
        MillenniumPine           : QGradient.Preset = ... # 0x8a
        HighFlight               : QGradient.Preset = ... # 0x8b
        MoleHall                 : QGradient.Preset = ... # 0x8c
        SpaceShift               : QGradient.Preset = ... # 0x8e
        ForestInei               : QGradient.Preset = ... # 0x8f
        RoyalGarden              : QGradient.Preset = ... # 0x90
        RichMetal                : QGradient.Preset = ... # 0x91
        JuicyCake                : QGradient.Preset = ... # 0x92
        SmartIndigo              : QGradient.Preset = ... # 0x93
        SandStrike               : QGradient.Preset = ... # 0x94
        NorseBeauty              : QGradient.Preset = ... # 0x95
        AquaGuidance             : QGradient.Preset = ... # 0x96
        SunVeggie                : QGradient.Preset = ... # 0x97
        SeaLord                  : QGradient.Preset = ... # 0x98
        BlackSea                 : QGradient.Preset = ... # 0x99
        GrassShampoo             : QGradient.Preset = ... # 0x9a
        LandingAircraft          : QGradient.Preset = ... # 0x9b
        WitchDance               : QGradient.Preset = ... # 0x9c
        SleeplessNight           : QGradient.Preset = ... # 0x9d
        AngelCare                : QGradient.Preset = ... # 0x9e
        CrystalRiver             : QGradient.Preset = ... # 0x9f
        SoftLipstick             : QGradient.Preset = ... # 0xa0
        SaltMountain             : QGradient.Preset = ... # 0xa1
        PerfectWhite             : QGradient.Preset = ... # 0xa2
        FreshOasis               : QGradient.Preset = ... # 0xa3
        StrictNovember           : QGradient.Preset = ... # 0xa4
        MorningSalad             : QGradient.Preset = ... # 0xa5
        DeepRelief               : QGradient.Preset = ... # 0xa6
        SeaStrike                : QGradient.Preset = ... # 0xa7
        NightCall                : QGradient.Preset = ... # 0xa8
        SupremeSky               : QGradient.Preset = ... # 0xa9
        LightBlue                : QGradient.Preset = ... # 0xaa
        MindCrawl                : QGradient.Preset = ... # 0xab
        LilyMeadow               : QGradient.Preset = ... # 0xac
        SugarLollipop            : QGradient.Preset = ... # 0xad
        SweetDessert             : QGradient.Preset = ... # 0xae
        MagicRay                 : QGradient.Preset = ... # 0xaf
        TeenParty                : QGradient.Preset = ... # 0xb0
        FrozenHeat               : QGradient.Preset = ... # 0xb1
        GagarinView              : QGradient.Preset = ... # 0xb2
        FabledSunset             : QGradient.Preset = ... # 0xb3
        PerfectBlue              : QGradient.Preset = ... # 0xb4
        NumPresets               : QGradient.Preset = ... # 0xb5


    class Spread(enum.Enum):

        PadSpread                : QGradient.Spread = ... # 0x0
        ReflectSpread            : QGradient.Spread = ... # 0x1
        RepeatSpread             : QGradient.Spread = ... # 0x2


    class Type(enum.Enum):

        LinearGradient           : QGradient.Type = ... # 0x0
        RadialGradient           : QGradient.Type = ... # 0x1
        ConicalGradient          : QGradient.Type = ... # 0x2
        NoGradient               : QGradient.Type = ... # 0x3


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QGradient: Union[PySide6.QtGui.QGradient, PySide6.QtGui.QGradient.Preset]) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QGradient.Preset) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def coordinateMode(self) -> PySide6.QtGui.QGradient.CoordinateMode: ...
    def interpolationMode(self) -> PySide6.QtGui.QGradient.InterpolationMode: ...
    def setColorAt(self, pos: float, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setCoordinateMode(self, mode: PySide6.QtGui.QGradient.CoordinateMode) -> None: ...
    def setInterpolationMode(self, mode: PySide6.QtGui.QGradient.InterpolationMode) -> None: ...
    def setSpread(self, spread: PySide6.QtGui.QGradient.Spread) -> None: ...
    def setStops(self, stops: Sequence[Tuple[float, PySide6.QtGui.QColor]]) -> None: ...
    def spread(self) -> PySide6.QtGui.QGradient.Spread: ...
    def stops(self) -> List[Tuple[float, PySide6.QtGui.QColor]]: ...
    def type(self) -> PySide6.QtGui.QGradient.Type: ...


class QGuiApplication(PySide6.QtCore.QCoreApplication):

    applicationDisplayNameChanged: ClassVar[Signal] = ... # applicationDisplayNameChanged()
    applicationStateChanged  : ClassVar[Signal] = ... # applicationStateChanged(Qt::ApplicationState)
    commitDataRequest        : ClassVar[Signal] = ... # commitDataRequest(QSessionManager&)
    focusObjectChanged       : ClassVar[Signal] = ... # focusObjectChanged(QObject*)
    focusWindowChanged       : ClassVar[Signal] = ... # focusWindowChanged(QWindow*)
    fontChanged              : ClassVar[Signal] = ... # fontChanged(QFont)
    fontDatabaseChanged      : ClassVar[Signal] = ... # fontDatabaseChanged()
    lastWindowClosed         : ClassVar[Signal] = ... # lastWindowClosed()
    layoutDirectionChanged   : ClassVar[Signal] = ... # layoutDirectionChanged(Qt::LayoutDirection)
    paletteChanged           : ClassVar[Signal] = ... # paletteChanged(QPalette)
    primaryScreenChanged     : ClassVar[Signal] = ... # primaryScreenChanged(QScreen*)
    saveStateRequest         : ClassVar[Signal] = ... # saveStateRequest(QSessionManager&)
    screenAdded              : ClassVar[Signal] = ... # screenAdded(QScreen*)
    screenRemoved            : ClassVar[Signal] = ... # screenRemoved(QScreen*)

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: Sequence[str]) -> None: ...

    @staticmethod
    def allWindows() -> List[PySide6.QtGui.QWindow]: ...
    @staticmethod
    def applicationDisplayName() -> str: ...
    @staticmethod
    def applicationState() -> PySide6.QtCore.Qt.ApplicationState: ...
    @staticmethod
    def changeOverrideCursor(arg__1: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    @staticmethod
    def clipboard() -> PySide6.QtGui.QClipboard: ...
    @staticmethod
    def desktopFileName() -> str: ...
    @staticmethod
    def desktopSettingsAware() -> bool: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec() -> int: ...
    def exec_(self) -> int: ...
    @staticmethod
    def focusObject() -> PySide6.QtCore.QObject: ...
    @staticmethod
    def focusWindow() -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def font() -> PySide6.QtGui.QFont: ...
    @staticmethod
    def highDpiScaleFactorRoundingPolicy() -> PySide6.QtCore.Qt.HighDpiScaleFactorRoundingPolicy: ...
    @staticmethod
    def inputMethod() -> PySide6.QtGui.QInputMethod: ...
    @staticmethod
    def isLeftToRight() -> bool: ...
    @staticmethod
    def isRightToLeft() -> bool: ...
    def isSavingSession(self) -> bool: ...
    def isSessionRestored(self) -> bool: ...
    @staticmethod
    def keyboardModifiers() -> PySide6.QtCore.Qt.KeyboardModifier: ...
    @staticmethod
    def layoutDirection() -> PySide6.QtCore.Qt.LayoutDirection: ...
    @staticmethod
    def modalWindow() -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def mouseButtons() -> PySide6.QtCore.Qt.MouseButton: ...
    def notify(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def overrideCursor() -> PySide6.QtGui.QCursor: ...
    @staticmethod
    def palette() -> PySide6.QtGui.QPalette: ...
    @staticmethod
    def platformName() -> str: ...
    @staticmethod
    def primaryScreen() -> PySide6.QtGui.QScreen: ...
    @staticmethod
    def queryKeyboardModifiers() -> PySide6.QtCore.Qt.KeyboardModifier: ...
    @staticmethod
    def quitOnLastWindowClosed() -> bool: ...
    def resolveInterface(self, name: bytes, revision: int) -> int: ...
    @staticmethod
    def restoreOverrideCursor() -> None: ...
    @staticmethod
    def screenAt(point: PySide6.QtCore.QPoint) -> PySide6.QtGui.QScreen: ...
    @staticmethod
    def screens() -> List[PySide6.QtGui.QScreen]: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    @staticmethod
    def setApplicationDisplayName(name: str) -> None: ...
    @staticmethod
    def setDesktopFileName(name: str) -> None: ...
    @staticmethod
    def setDesktopSettingsAware(on: bool) -> None: ...
    @staticmethod
    def setFont(arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @staticmethod
    def setHighDpiScaleFactorRoundingPolicy(policy: PySide6.QtCore.Qt.HighDpiScaleFactorRoundingPolicy) -> None: ...
    @staticmethod
    def setLayoutDirection(direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    @staticmethod
    def setOverrideCursor(arg__1: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> object: ...
    @staticmethod
    def setPalette(pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @staticmethod
    def setQuitOnLastWindowClosed(quit: bool) -> None: ...
    @staticmethod
    def setWindowIcon(icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    @staticmethod
    def styleHints() -> PySide6.QtGui.QStyleHints: ...
    @staticmethod
    def sync() -> None: ...
    @staticmethod
    def topLevelAt(pos: PySide6.QtCore.QPoint) -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def topLevelWindows() -> List[PySide6.QtGui.QWindow]: ...
    @staticmethod
    def windowIcon() -> PySide6.QtGui.QIcon: ...


class QHelpEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QHelpEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, pos: PySide6.QtCore.QPoint, globalPos: PySide6.QtCore.QPoint) -> None: ...

    def clone(self) -> PySide6.QtGui.QHelpEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QHideEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QHideEvent: ...


class QHoverEvent(PySide6.QtGui.QSinglePointEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QHoverEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], oldPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, scenePos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], oldPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QHoverEvent: ...
    def isUpdateEvent(self) -> bool: ...
    def oldPos(self) -> PySide6.QtCore.QPoint: ...
    def oldPosF(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def posF(self) -> PySide6.QtCore.QPointF: ...


class QIcon(Shiboken.Object):

    class Mode(enum.Enum):

        Normal                   : QIcon.Mode = ... # 0x0
        Disabled                 : QIcon.Mode = ... # 0x1
        Active                   : QIcon.Mode = ... # 0x2
        Selected                 : QIcon.Mode = ... # 0x3


    class State(enum.Enum):

        On                       : QIcon.State = ... # 0x0
        Off                      : QIcon.State = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, engine: PySide6.QtGui.QIconEngine) -> None: ...
    @overload
    def __init__(self, fileName: str) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def __init__(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def actualSize(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtCore.QSize: ...
    @overload
    def actualSize(self, window: PySide6.QtGui.QWindow, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide6.QtCore.QSize = ..., mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    @overload
    def addPixmap(self, path: Union[str, bytes, os.PathLike]) -> None: ...
    @overload
    def addPixmap(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    def availableSizes(self, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> List[PySide6.QtCore.QSize]: ...
    def cacheKey(self) -> int: ...
    @staticmethod
    def fallbackSearchPaths() -> List[str]: ...
    @staticmethod
    def fallbackThemeName() -> str: ...
    @overload
    @staticmethod
    def fromTheme(name: str) -> PySide6.QtGui.QIcon: ...
    @overload
    @staticmethod
    def fromTheme(name: str, fallback: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> PySide6.QtGui.QIcon: ...
    @staticmethod
    def hasThemeIcon(name: str) -> bool: ...
    def isMask(self) -> bool: ...
    def isNull(self) -> bool: ...
    def name(self) -> str: ...
    @overload
    def paint(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, alignment: PySide6.QtCore.Qt.AlignmentFlag = ..., mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    @overload
    def paint(self, painter: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ..., mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    @overload
    def pixmap(self, extent: int, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def pixmap(self, size: PySide6.QtCore.QSize, devicePixelRatio: float, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def pixmap(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def pixmap(self, w: int, h: int, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def pixmap(self, window: PySide6.QtGui.QWindow, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def setFallbackSearchPaths(paths: Sequence[str]) -> None: ...
    @staticmethod
    def setFallbackThemeName(name: str) -> None: ...
    def setIsMask(self, isMask: bool) -> None: ...
    @staticmethod
    def setThemeName(path: str) -> None: ...
    @staticmethod
    def setThemeSearchPaths(searchpath: Sequence[str]) -> None: ...
    def swap(self, other: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def themeSearchPaths() -> List[str]: ...


class QIconDragEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QIconDragEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QIconDragEvent: ...


class QIconEngine(Shiboken.Object):

    class IconEngineHook(enum.Enum):

        IsNullHook               : QIconEngine.IconEngineHook = ... # 0x3
        ScaledPixmapHook         : QIconEngine.IconEngineHook = ... # 0x4


    class ScaledPixmapArgument(Shiboken.Object):

        def __init__(self) -> None: ...


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QIconEngine) -> None: ...

    def actualSize(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> PySide6.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> None: ...
    def addPixmap(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> None: ...
    def availableSizes(self, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> List[PySide6.QtCore.QSize]: ...
    def clone(self) -> PySide6.QtGui.QIconEngine: ...
    def iconName(self) -> str: ...
    def isNull(self) -> bool: ...
    def key(self) -> str: ...
    def paint(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> None: ...
    def pixmap(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> PySide6.QtGui.QPixmap: ...
    def read(self, in_: PySide6.QtCore.QDataStream) -> bool: ...
    def scaledPixmap(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State, scale: float) -> PySide6.QtGui.QPixmap: ...
    def write(self, out: PySide6.QtCore.QDataStream) -> bool: ...


class QImage(PySide6.QtGui.QPaintDevice):

    class Format(enum.Enum):

        Format_Invalid           : QImage.Format = ... # 0x0
        Format_Mono              : QImage.Format = ... # 0x1
        Format_MonoLSB           : QImage.Format = ... # 0x2
        Format_Indexed8          : QImage.Format = ... # 0x3
        Format_RGB32             : QImage.Format = ... # 0x4
        Format_ARGB32            : QImage.Format = ... # 0x5
        Format_ARGB32_Premultiplied: QImage.Format = ... # 0x6
        Format_RGB16             : QImage.Format = ... # 0x7
        Format_ARGB8565_Premultiplied: QImage.Format = ... # 0x8
        Format_RGB666            : QImage.Format = ... # 0x9
        Format_ARGB6666_Premultiplied: QImage.Format = ... # 0xa
        Format_RGB555            : QImage.Format = ... # 0xb
        Format_ARGB8555_Premultiplied: QImage.Format = ... # 0xc
        Format_RGB888            : QImage.Format = ... # 0xd
        Format_RGB444            : QImage.Format = ... # 0xe
        Format_ARGB4444_Premultiplied: QImage.Format = ... # 0xf
        Format_RGBX8888          : QImage.Format = ... # 0x10
        Format_RGBA8888          : QImage.Format = ... # 0x11
        Format_RGBA8888_Premultiplied: QImage.Format = ... # 0x12
        Format_BGR30             : QImage.Format = ... # 0x13
        Format_A2BGR30_Premultiplied: QImage.Format = ... # 0x14
        Format_RGB30             : QImage.Format = ... # 0x15
        Format_A2RGB30_Premultiplied: QImage.Format = ... # 0x16
        Format_Alpha8            : QImage.Format = ... # 0x17
        Format_Grayscale8        : QImage.Format = ... # 0x18
        Format_RGBX64            : QImage.Format = ... # 0x19
        Format_RGBA64            : QImage.Format = ... # 0x1a
        Format_RGBA64_Premultiplied: QImage.Format = ... # 0x1b
        Format_Grayscale16       : QImage.Format = ... # 0x1c
        Format_BGR888            : QImage.Format = ... # 0x1d
        Format_RGBX16FPx4        : QImage.Format = ... # 0x1e
        Format_RGBA16FPx4        : QImage.Format = ... # 0x1f
        Format_RGBA16FPx4_Premultiplied: QImage.Format = ... # 0x20
        Format_RGBX32FPx4        : QImage.Format = ... # 0x21
        Format_RGBA32FPx4        : QImage.Format = ... # 0x22
        Format_RGBA32FPx4_Premultiplied: QImage.Format = ... # 0x23
        NImageFormats            : QImage.Format = ... # 0x24


    class InvertMode(enum.Enum):

        InvertRgb                : QImage.InvertMode = ... # 0x0
        InvertRgba               : QImage.InvertMode = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: PySide6.QtGui.QImage.Format) -> None: ...
    @overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: int, arg__5: PySide6.QtGui.QImage.Format) -> None: ...
    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def __init__(self, data: bytes, width: int, height: int, bytesPerLine: int, format: PySide6.QtGui.QImage.Format, cleanupFunction: Optional[Callable] = ..., cleanupInfo: Optional[int] = ...) -> None: ...
    @overload
    def __init__(self, data: bytes, width: int, height: int, format: PySide6.QtGui.QImage.Format, cleanupFunction: Optional[Callable] = ..., cleanupInfo: Optional[int] = ...) -> None: ...
    @overload
    def __init__(self, fileName: Union[str, bytes, os.PathLike], format: Optional[bytes] = ...) -> None: ...
    @overload
    def __init__(self, size: PySide6.QtCore.QSize, format: PySide6.QtGui.QImage.Format) -> None: ...
    @overload
    def __init__(self, width: int, height: int, format: PySide6.QtGui.QImage.Format) -> None: ...
    @overload
    def __init__(self, xpm: Iterable) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def allGray(self) -> bool: ...
    def applyColorTransform(self, transform: PySide6.QtGui.QColorTransform) -> None: ...
    def bitPlaneCount(self) -> int: ...
    def bits(self) -> bytes: ...
    def bytesPerLine(self) -> int: ...
    def cacheKey(self) -> int: ...
    def color(self, i: int) -> int: ...
    def colorCount(self) -> int: ...
    def colorSpace(self) -> PySide6.QtGui.QColorSpace: ...
    def colorTable(self) -> List[int]: ...
    def colorTransformed(self, transform: PySide6.QtGui.QColorTransform) -> PySide6.QtGui.QImage: ...
    def constBits(self) -> bytes: ...
    def constScanLine(self, arg__1: int) -> object: ...
    def convertTo(self, f: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    def convertToColorSpace(self, arg__1: Union[PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace]) -> None: ...
    @overload
    def convertToFormat(self, f: PySide6.QtGui.QImage.Format, colorTable: Sequence[int], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    @overload
    def convertToFormat(self, f: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    def convertToFormat_helper(self, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag) -> PySide6.QtGui.QImage: ...
    def convertToFormat_inplace(self, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag) -> bool: ...
    def convertedTo(self, f: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    def convertedToColorSpace(self, arg__1: Union[PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace]) -> PySide6.QtGui.QImage: ...
    @overload
    def copy(self, rect: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QImage: ...
    @overload
    def copy(self, x: int, y: int, w: int, h: int) -> PySide6.QtGui.QImage: ...
    def createAlphaMask(self, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> PySide6.QtGui.QImage: ...
    def createMaskFromColor(self, color: int, mode: PySide6.QtCore.Qt.MaskMode = ...) -> PySide6.QtGui.QImage: ...
    def depth(self) -> int: ...
    def detachMetadata(self, invalidateCache: bool = ...) -> None: ...
    def devType(self) -> int: ...
    def deviceIndependentSize(self) -> PySide6.QtCore.QSizeF: ...
    def devicePixelRatio(self) -> float: ...
    def dotsPerMeterX(self) -> int: ...
    def dotsPerMeterY(self) -> int: ...
    @overload
    def fill(self, color: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fill(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def fill(self, pixel: int) -> None: ...
    def format(self) -> PySide6.QtGui.QImage.Format: ...
    @staticmethod
    def fromData(data: Union[PySide6.QtCore.QByteArray, bytes], format: Optional[bytes] = ...) -> PySide6.QtGui.QImage: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def invertPixels(self, mode: PySide6.QtGui.QImage.InvertMode = ...) -> None: ...
    def isGrayscale(self) -> bool: ...
    def isNull(self) -> bool: ...
    @overload
    def load(self, device: PySide6.QtCore.QIODevice, format: bytes) -> bool: ...
    @overload
    def load(self, fileName: str, format: Optional[bytes] = ...) -> bool: ...
    def loadFromData(self, data: Union[PySide6.QtCore.QByteArray, bytes], format: Optional[bytes] = ...) -> bool: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def mirror(self, horizontally: bool = ..., vertically: bool = ...) -> None: ...
    def mirrored(self, horizontally: bool = ..., vertically: bool = ...) -> PySide6.QtGui.QImage: ...
    def mirrored_helper(self, horizontal: bool, vertical: bool) -> PySide6.QtGui.QImage: ...
    def mirrored_inplace(self, horizontal: bool, vertical: bool) -> None: ...
    def offset(self) -> PySide6.QtCore.QPoint: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    @overload
    def pixel(self, pt: PySide6.QtCore.QPoint) -> int: ...
    @overload
    def pixel(self, x: int, y: int) -> int: ...
    @overload
    def pixelColor(self, pt: PySide6.QtCore.QPoint) -> PySide6.QtGui.QColor: ...
    @overload
    def pixelColor(self, x: int, y: int) -> PySide6.QtGui.QColor: ...
    def pixelFormat(self) -> PySide6.QtGui.QPixelFormat: ...
    @overload
    def pixelIndex(self, pt: PySide6.QtCore.QPoint) -> int: ...
    @overload
    def pixelIndex(self, x: int, y: int) -> int: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def reinterpretAsFormat(self, f: PySide6.QtGui.QImage.Format) -> bool: ...
    def rgbSwap(self) -> None: ...
    def rgbSwapped(self) -> PySide6.QtGui.QImage: ...
    def rgbSwapped_helper(self) -> PySide6.QtGui.QImage: ...
    def rgbSwapped_inplace(self) -> None: ...
    @overload
    def save(self, device: PySide6.QtCore.QIODevice, format: Optional[bytes] = ..., quality: int = ...) -> bool: ...
    @overload
    def save(self, fileName: str, format: Optional[bytes] = ..., quality: int = ...) -> bool: ...
    @overload
    def scaled(self, s: PySide6.QtCore.QSize, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    @overload
    def scaled(self, w: int, h: int, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    def scaledToHeight(self, h: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    def scaledToWidth(self, w: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    def scanLine(self, arg__1: int) -> object: ...
    def setAlphaChannel(self, alphaChannel: Union[PySide6.QtGui.QImage, str]) -> None: ...
    def setColor(self, i: int, c: int) -> None: ...
    def setColorCount(self, arg__1: int) -> None: ...
    def setColorSpace(self, arg__1: Union[PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace]) -> None: ...
    def setColorTable(self, colors: Sequence[int]) -> None: ...
    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def setDotsPerMeterX(self, arg__1: int) -> None: ...
    def setDotsPerMeterY(self, arg__1: int) -> None: ...
    def setOffset(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def setPixel(self, pt: PySide6.QtCore.QPoint, index_or_rgb: int) -> None: ...
    @overload
    def setPixel(self, x: int, y: int, index_or_rgb: int) -> None: ...
    @overload
    def setPixelColor(self, pt: PySide6.QtCore.QPoint, c: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def setPixelColor(self, x: int, y: int, c: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setText(self, key: str, value: str) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def sizeInBytes(self) -> int: ...
    def smoothScaled(self, w: int, h: int) -> PySide6.QtGui.QImage: ...
    def swap(self, other: Union[PySide6.QtGui.QImage, str]) -> None: ...
    def text(self, key: str = ...) -> str: ...
    def textKeys(self) -> List[str]: ...
    @staticmethod
    def toImageFormat(format: PySide6.QtGui.QPixelFormat) -> PySide6.QtGui.QImage.Format: ...
    @staticmethod
    def toPixelFormat(format: PySide6.QtGui.QImage.Format) -> PySide6.QtGui.QPixelFormat: ...
    def transformed(self, matrix: PySide6.QtGui.QTransform, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    @staticmethod
    def trueMatrix(arg__1: PySide6.QtGui.QTransform, w: int, h: int) -> PySide6.QtGui.QTransform: ...
    @overload
    def valid(self, pt: PySide6.QtCore.QPoint) -> bool: ...
    @overload
    def valid(self, x: int, y: int) -> bool: ...
    def width(self) -> int: ...


class QImageIOHandler(Shiboken.Object):

    class ImageOption(enum.Enum):

        Size                     : QImageIOHandler.ImageOption = ... # 0x0
        ClipRect                 : QImageIOHandler.ImageOption = ... # 0x1
        Description              : QImageIOHandler.ImageOption = ... # 0x2
        ScaledClipRect           : QImageIOHandler.ImageOption = ... # 0x3
        ScaledSize               : QImageIOHandler.ImageOption = ... # 0x4
        CompressionRatio         : QImageIOHandler.ImageOption = ... # 0x5
        Gamma                    : QImageIOHandler.ImageOption = ... # 0x6
        Quality                  : QImageIOHandler.ImageOption = ... # 0x7
        Name                     : QImageIOHandler.ImageOption = ... # 0x8
        SubType                  : QImageIOHandler.ImageOption = ... # 0x9
        IncrementalReading       : QImageIOHandler.ImageOption = ... # 0xa
        Endianness               : QImageIOHandler.ImageOption = ... # 0xb
        Animation                : QImageIOHandler.ImageOption = ... # 0xc
        BackgroundColor          : QImageIOHandler.ImageOption = ... # 0xd
        ImageFormat              : QImageIOHandler.ImageOption = ... # 0xe
        SupportedSubTypes        : QImageIOHandler.ImageOption = ... # 0xf
        OptimizedWrite           : QImageIOHandler.ImageOption = ... # 0x10
        ProgressiveScanWrite     : QImageIOHandler.ImageOption = ... # 0x11
        ImageTransformation      : QImageIOHandler.ImageOption = ... # 0x12


    class Transformation(enum.Flag):

        TransformationNone       : QImageIOHandler.Transformation = ... # 0x0
        TransformationMirror     : QImageIOHandler.Transformation = ... # 0x1
        TransformationFlip       : QImageIOHandler.Transformation = ... # 0x2
        TransformationRotate180  : QImageIOHandler.Transformation = ... # 0x3
        TransformationRotate90   : QImageIOHandler.Transformation = ... # 0x4
        TransformationMirrorAndRotate90: QImageIOHandler.Transformation = ... # 0x5
        TransformationFlipAndRotate90: QImageIOHandler.Transformation = ... # 0x6
        TransformationRotate270  : QImageIOHandler.Transformation = ... # 0x7


    def __init__(self) -> None: ...

    @staticmethod
    def allocateImage(size: PySide6.QtCore.QSize, format: PySide6.QtGui.QImage.Format, image: Union[PySide6.QtGui.QImage, str]) -> bool: ...
    def canRead(self) -> bool: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide6.QtCore.QRect: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def imageCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def option(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> Any: ...
    def read(self, image: Union[PySide6.QtGui.QImage, str]) -> bool: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    def setOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption, value: Any) -> None: ...
    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def write(self, image: Union[PySide6.QtGui.QImage, str]) -> bool: ...


class QImageReader(Shiboken.Object):

    class ImageReaderError(enum.Enum):

        UnknownError             : QImageReader.ImageReaderError = ... # 0x0
        FileNotFoundError        : QImageReader.ImageReaderError = ... # 0x1
        DeviceError              : QImageReader.ImageReaderError = ... # 0x2
        UnsupportedFormatError   : QImageReader.ImageReaderError = ... # 0x3
        InvalidDataError         : QImageReader.ImageReaderError = ... # 0x4


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: Union[PySide6.QtCore.QByteArray, bytes] = ...) -> None: ...
    @overload
    def __init__(self, fileName: str, format: Union[PySide6.QtCore.QByteArray, bytes] = ...) -> None: ...

    @staticmethod
    def allocationLimit() -> int: ...
    def autoDetectImageFormat(self) -> bool: ...
    def autoTransform(self) -> bool: ...
    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def canRead(self) -> bool: ...
    def clipRect(self) -> PySide6.QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide6.QtCore.QRect: ...
    def decideFormatFromContent(self) -> bool: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def error(self) -> PySide6.QtGui.QImageReader.ImageReaderError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def imageCount(self) -> int: ...
    @overload
    @staticmethod
    def imageFormat(device: PySide6.QtCore.QIODevice) -> PySide6.QtCore.QByteArray: ...
    @overload
    @staticmethod
    def imageFormat(fileName: str) -> PySide6.QtCore.QByteArray: ...
    @overload
    def imageFormat(self) -> PySide6.QtGui.QImage.Format: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType: Union[PySide6.QtCore.QByteArray, bytes]) -> List[PySide6.QtCore.QByteArray]: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def quality(self) -> int: ...
    def read(self) -> PySide6.QtGui.QImage: ...
    def scaledClipRect(self) -> PySide6.QtCore.QRect: ...
    def scaledSize(self) -> PySide6.QtCore.QSize: ...
    @staticmethod
    def setAllocationLimit(mbLimit: int) -> None: ...
    def setAutoDetectImageFormat(self, enabled: bool) -> None: ...
    def setAutoTransform(self, enabled: bool) -> None: ...
    def setBackgroundColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setClipRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    def setDecideFormatFromContent(self, ignored: bool) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    def setQuality(self, quality: int) -> None: ...
    def setScaledClipRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    def setScaledSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def subType(self) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> List[PySide6.QtCore.QByteArray]: ...
    @staticmethod
    def supportedMimeTypes() -> List[PySide6.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> List[PySide6.QtCore.QByteArray]: ...
    def supportsAnimation(self) -> bool: ...
    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def text(self, key: str) -> str: ...
    def textKeys(self) -> List[str]: ...
    def transformation(self) -> PySide6.QtGui.QImageIOHandler.Transformation: ...


class QImageWriter(Shiboken.Object):

    class ImageWriterError(enum.Enum):

        UnknownError             : QImageWriter.ImageWriterError = ... # 0x0
        DeviceError              : QImageWriter.ImageWriterError = ... # 0x1
        UnsupportedFormatError   : QImageWriter.ImageWriterError = ... # 0x2
        InvalidImageError        : QImageWriter.ImageWriterError = ... # 0x3


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: Union[PySide6.QtCore.QByteArray, bytes] = ...) -> None: ...

    def canWrite(self) -> bool: ...
    def compression(self) -> int: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def error(self) -> PySide6.QtGui.QImageWriter.ImageWriterError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType: Union[PySide6.QtCore.QByteArray, bytes]) -> List[PySide6.QtCore.QByteArray]: ...
    def optimizedWrite(self) -> bool: ...
    def progressiveScanWrite(self) -> bool: ...
    def quality(self) -> int: ...
    def setCompression(self, compression: int) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    def setOptimizedWrite(self, optimize: bool) -> None: ...
    def setProgressiveScanWrite(self, progressive: bool) -> None: ...
    def setQuality(self, quality: int) -> None: ...
    def setSubType(self, type: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    def setText(self, key: str, text: str) -> None: ...
    def setTransformation(self, orientation: PySide6.QtGui.QImageIOHandler.Transformation) -> None: ...
    def subType(self) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> List[PySide6.QtCore.QByteArray]: ...
    @staticmethod
    def supportedMimeTypes() -> List[PySide6.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> List[PySide6.QtCore.QByteArray]: ...
    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def transformation(self) -> PySide6.QtGui.QImageIOHandler.Transformation: ...
    def write(self, image: Union[PySide6.QtGui.QImage, str]) -> bool: ...


class QInputDevice(PySide6.QtCore.QObject):

    availableVirtualGeometryChanged: ClassVar[Signal] = ... # availableVirtualGeometryChanged(QRect)

    class Capability(enum.Flag):

        None_                    : QInputDevice.Capability = ... # 0x0
        Position                 : QInputDevice.Capability = ... # 0x1
        Area                     : QInputDevice.Capability = ... # 0x2
        Pressure                 : QInputDevice.Capability = ... # 0x4
        Velocity                 : QInputDevice.Capability = ... # 0x8
        NormalizedPosition       : QInputDevice.Capability = ... # 0x20
        MouseEmulation           : QInputDevice.Capability = ... # 0x40
        PixelScroll              : QInputDevice.Capability = ... # 0x80
        Scroll                   : QInputDevice.Capability = ... # 0x100
        Hover                    : QInputDevice.Capability = ... # 0x200
        Rotation                 : QInputDevice.Capability = ... # 0x400
        XTilt                    : QInputDevice.Capability = ... # 0x800
        YTilt                    : QInputDevice.Capability = ... # 0x1000
        TangentialPressure       : QInputDevice.Capability = ... # 0x2000
        ZPosition                : QInputDevice.Capability = ... # 0x4000
        All                      : QInputDevice.Capability = ... # 0x7fffffff


    class DeviceType(enum.Flag):

        Unknown                  : QInputDevice.DeviceType = ... # 0x0
        Mouse                    : QInputDevice.DeviceType = ... # 0x1
        TouchScreen              : QInputDevice.DeviceType = ... # 0x2
        TouchPad                 : QInputDevice.DeviceType = ... # 0x4
        Puck                     : QInputDevice.DeviceType = ... # 0x8
        Stylus                   : QInputDevice.DeviceType = ... # 0x10
        Airbrush                 : QInputDevice.DeviceType = ... # 0x20
        Keyboard                 : QInputDevice.DeviceType = ... # 0x1000
        AllDevices               : QInputDevice.DeviceType = ... # 0x7fffffff


    @overload
    def __init__(self, name: str, systemId: int, type: PySide6.QtGui.QInputDevice.DeviceType, seatName: str = ..., parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def availableVirtualGeometry(self) -> PySide6.QtCore.QRect: ...
    def capabilities(self) -> PySide6.QtGui.QInputDevice.Capability: ...
    @staticmethod
    def devices() -> List[PySide6.QtGui.QInputDevice]: ...
    def hasCapability(self, cap: PySide6.QtGui.QInputDevice.Capability) -> bool: ...
    def name(self) -> str: ...
    @staticmethod
    def primaryKeyboard(seatName: str = ...) -> PySide6.QtGui.QInputDevice: ...
    def seatName(self) -> str: ...
    @staticmethod
    def seatNames() -> List[str]: ...
    def systemId(self) -> int: ...
    def type(self) -> PySide6.QtGui.QInputDevice.DeviceType: ...


class QInputEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QInputEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, m_dev: PySide6.QtGui.QInputDevice, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QInputEvent: ...
    def device(self) -> PySide6.QtGui.QInputDevice: ...
    def deviceType(self) -> PySide6.QtGui.QInputDevice.DeviceType: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...
    def setTimestamp(self, timestamp: int) -> None: ...
    def timestamp(self) -> int: ...


class QInputMethod(PySide6.QtCore.QObject):

    anchorRectangleChanged   : ClassVar[Signal] = ... # anchorRectangleChanged()
    animatingChanged         : ClassVar[Signal] = ... # animatingChanged()
    cursorRectangleChanged   : ClassVar[Signal] = ... # cursorRectangleChanged()
    inputDirectionChanged    : ClassVar[Signal] = ... # inputDirectionChanged(Qt::LayoutDirection)
    inputItemClipRectangleChanged: ClassVar[Signal] = ... # inputItemClipRectangleChanged()
    keyboardRectangleChanged : ClassVar[Signal] = ... # keyboardRectangleChanged()
    localeChanged            : ClassVar[Signal] = ... # localeChanged()
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged()

    class Action(enum.Enum):

        Click                    : QInputMethod.Action = ... # 0x0
        ContextMenu              : QInputMethod.Action = ... # 0x1


    def anchorRectangle(self) -> PySide6.QtCore.QRectF: ...
    def commit(self) -> None: ...
    def cursorRectangle(self) -> PySide6.QtCore.QRectF: ...
    def hide(self) -> None: ...
    def inputDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def inputItemClipRectangle(self) -> PySide6.QtCore.QRectF: ...
    def inputItemRectangle(self) -> PySide6.QtCore.QRectF: ...
    def inputItemTransform(self) -> PySide6.QtGui.QTransform: ...
    def invokeAction(self, a: PySide6.QtGui.QInputMethod.Action, cursorPosition: int) -> None: ...
    def isAnimating(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyboardRectangle(self) -> PySide6.QtCore.QRectF: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    @staticmethod
    def queryFocusObject(query: PySide6.QtCore.Qt.InputMethodQuery, argument: Any) -> Any: ...
    def reset(self) -> None: ...
    def setInputItemRectangle(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setInputItemTransform(self, transform: PySide6.QtGui.QTransform) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def show(self) -> None: ...
    def update(self, queries: PySide6.QtCore.Qt.InputMethodQuery) -> None: ...


class QInputMethodEvent(PySide6.QtCore.QEvent):

    class Attribute(Shiboken.Object):

        @overload
        def __init__(self, Attribute: PySide6.QtGui.QInputMethodEvent.Attribute) -> None: ...
        @overload
        def __init__(self, typ: PySide6.QtGui.QInputMethodEvent.AttributeType, s: int, l: int) -> None: ...
        @overload
        def __init__(self, typ: PySide6.QtGui.QInputMethodEvent.AttributeType, s: int, l: int, val: Any) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class AttributeType(enum.Enum):

        TextFormat               : QInputMethodEvent.AttributeType = ... # 0x0
        Cursor                   : QInputMethodEvent.AttributeType = ... # 0x1
        Language                 : QInputMethodEvent.AttributeType = ... # 0x2
        Ruby                     : QInputMethodEvent.AttributeType = ... # 0x3
        Selection                : QInputMethodEvent.AttributeType = ... # 0x4


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def __init__(self, preeditText: str, attributes: Sequence[PySide6.QtGui.QInputMethodEvent.Attribute]) -> None: ...

    def __repr__(self) -> object: ...
    def attributes(self) -> List[PySide6.QtGui.QInputMethodEvent.Attribute]: ...
    def clone(self) -> PySide6.QtGui.QInputMethodEvent: ...
    def commitString(self) -> str: ...
    def preeditString(self) -> str: ...
    def replacementLength(self) -> int: ...
    def replacementStart(self) -> int: ...
    def setCommitString(self, commitString: str, replaceFrom: int = ..., replaceLength: int = ...) -> None: ...


class QInputMethodQueryEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QInputMethodQueryEvent) -> None: ...
    @overload
    def __init__(self, queries: PySide6.QtCore.Qt.InputMethodQuery) -> None: ...

    def clone(self) -> PySide6.QtGui.QInputMethodQueryEvent: ...
    def queries(self) -> PySide6.QtCore.Qt.InputMethodQuery: ...
    def setValue(self, query: PySide6.QtCore.Qt.InputMethodQuery, value: Any) -> None: ...
    def value(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...


class QIntList(object): ...


class QIntValidator(PySide6.QtGui.QValidator):

    bottomChanged            : ClassVar[Signal] = ... # bottomChanged(int)
    topChanged               : ClassVar[Signal] = ... # topChanged(int)

    @overload
    def __init__(self, bottom: int, top: int, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def bottom(self) -> int: ...
    def fixup(self, input: str) -> str: ...
    def setBottom(self, arg__1: int) -> None: ...
    def setRange(self, bottom: int, top: int) -> None: ...
    def setTop(self, arg__1: int) -> None: ...
    def top(self) -> int: ...
    def validate(self, arg__1: str, arg__2: int) -> object: ...


class QKeyEvent(PySide6.QtGui.QInputEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, key: int, modifiers: PySide6.QtCore.Qt.KeyboardModifier, nativeScanCode: int, nativeVirtualKey: int, nativeModifiers: int, text: str = ..., autorep: bool = ..., count: int = ..., device: PySide6.QtGui.QInputDevice = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, key: int, modifiers: PySide6.QtCore.Qt.KeyboardModifier, text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QKeyEvent: ...
    def count(self) -> int: ...
    def isAutoRepeat(self) -> bool: ...
    def key(self) -> int: ...
    def keyCombination(self) -> PySide6.QtCore.QKeyCombination: ...
    def matches(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> bool: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def nativeModifiers(self) -> int: ...
    def nativeScanCode(self) -> int: ...
    def nativeVirtualKey(self) -> int: ...
    def text(self) -> str: ...


class QKeySequence(Shiboken.Object):

    class SequenceFormat(enum.Enum):

        NativeText               : QKeySequence.SequenceFormat = ... # 0x0
        PortableText             : QKeySequence.SequenceFormat = ... # 0x1


    class SequenceMatch(enum.Enum):

        NoMatch                  : QKeySequence.SequenceMatch = ... # 0x0
        PartialMatch             : QKeySequence.SequenceMatch = ... # 0x1
        ExactMatch               : QKeySequence.SequenceMatch = ... # 0x2


    class StandardKey(enum.Enum):

        UnknownKey               : QKeySequence.StandardKey = ... # 0x0
        HelpContents             : QKeySequence.StandardKey = ... # 0x1
        WhatsThis                : QKeySequence.StandardKey = ... # 0x2
        Open                     : QKeySequence.StandardKey = ... # 0x3
        Close                    : QKeySequence.StandardKey = ... # 0x4
        Save                     : QKeySequence.StandardKey = ... # 0x5
        New                      : QKeySequence.StandardKey = ... # 0x6
        Delete                   : QKeySequence.StandardKey = ... # 0x7
        Cut                      : QKeySequence.StandardKey = ... # 0x8
        Copy                     : QKeySequence.StandardKey = ... # 0x9
        Paste                    : QKeySequence.StandardKey = ... # 0xa
        Undo                     : QKeySequence.StandardKey = ... # 0xb
        Redo                     : QKeySequence.StandardKey = ... # 0xc
        Back                     : QKeySequence.StandardKey = ... # 0xd
        Forward                  : QKeySequence.StandardKey = ... # 0xe
        Refresh                  : QKeySequence.StandardKey = ... # 0xf
        ZoomIn                   : QKeySequence.StandardKey = ... # 0x10
        ZoomOut                  : QKeySequence.StandardKey = ... # 0x11
        Print                    : QKeySequence.StandardKey = ... # 0x12
        AddTab                   : QKeySequence.StandardKey = ... # 0x13
        NextChild                : QKeySequence.StandardKey = ... # 0x14
        PreviousChild            : QKeySequence.StandardKey = ... # 0x15
        Find                     : QKeySequence.StandardKey = ... # 0x16
        FindNext                 : QKeySequence.StandardKey = ... # 0x17
        FindPrevious             : QKeySequence.StandardKey = ... # 0x18
        Replace                  : QKeySequence.StandardKey = ... # 0x19
        SelectAll                : QKeySequence.StandardKey = ... # 0x1a
        Bold                     : QKeySequence.StandardKey = ... # 0x1b
        Italic                   : QKeySequence.StandardKey = ... # 0x1c
        Underline                : QKeySequence.StandardKey = ... # 0x1d
        MoveToNextChar           : QKeySequence.StandardKey = ... # 0x1e
        MoveToPreviousChar       : QKeySequence.StandardKey = ... # 0x1f
        MoveToNextWord           : QKeySequence.StandardKey = ... # 0x20
        MoveToPreviousWord       : QKeySequence.StandardKey = ... # 0x21
        MoveToNextLine           : QKeySequence.StandardKey = ... # 0x22
        MoveToPreviousLine       : QKeySequence.StandardKey = ... # 0x23
        MoveToNextPage           : QKeySequence.StandardKey = ... # 0x24
        MoveToPreviousPage       : QKeySequence.StandardKey = ... # 0x25
        MoveToStartOfLine        : QKeySequence.StandardKey = ... # 0x26
        MoveToEndOfLine          : QKeySequence.StandardKey = ... # 0x27
        MoveToStartOfBlock       : QKeySequence.StandardKey = ... # 0x28
        MoveToEndOfBlock         : QKeySequence.StandardKey = ... # 0x29
        MoveToStartOfDocument    : QKeySequence.StandardKey = ... # 0x2a
        MoveToEndOfDocument      : QKeySequence.StandardKey = ... # 0x2b
        SelectNextChar           : QKeySequence.StandardKey = ... # 0x2c
        SelectPreviousChar       : QKeySequence.StandardKey = ... # 0x2d
        SelectNextWord           : QKeySequence.StandardKey = ... # 0x2e
        SelectPreviousWord       : QKeySequence.StandardKey = ... # 0x2f
        SelectNextLine           : QKeySequence.StandardKey = ... # 0x30
        SelectPreviousLine       : QKeySequence.StandardKey = ... # 0x31
        SelectNextPage           : QKeySequence.StandardKey = ... # 0x32
        SelectPreviousPage       : QKeySequence.StandardKey = ... # 0x33
        SelectStartOfLine        : QKeySequence.StandardKey = ... # 0x34
        SelectEndOfLine          : QKeySequence.StandardKey = ... # 0x35
        SelectStartOfBlock       : QKeySequence.StandardKey = ... # 0x36
        SelectEndOfBlock         : QKeySequence.StandardKey = ... # 0x37
        SelectStartOfDocument    : QKeySequence.StandardKey = ... # 0x38
        SelectEndOfDocument      : QKeySequence.StandardKey = ... # 0x39
        DeleteStartOfWord        : QKeySequence.StandardKey = ... # 0x3a
        DeleteEndOfWord          : QKeySequence.StandardKey = ... # 0x3b
        DeleteEndOfLine          : QKeySequence.StandardKey = ... # 0x3c
        InsertParagraphSeparator : QKeySequence.StandardKey = ... # 0x3d
        InsertLineSeparator      : QKeySequence.StandardKey = ... # 0x3e
        SaveAs                   : QKeySequence.StandardKey = ... # 0x3f
        Preferences              : QKeySequence.StandardKey = ... # 0x40
        Quit                     : QKeySequence.StandardKey = ... # 0x41
        FullScreen               : QKeySequence.StandardKey = ... # 0x42
        Deselect                 : QKeySequence.StandardKey = ... # 0x43
        DeleteCompleteLine       : QKeySequence.StandardKey = ... # 0x44
        Backspace                : QKeySequence.StandardKey = ... # 0x45
        Cancel                   : QKeySequence.StandardKey = ... # 0x46


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, k1: int, k2: int = ..., k3: int = ..., k4: int = ...) -> None: ...
    @overload
    def __init__(self, k1: Union[PySide6.QtCore.QKeyCombination, PySide6.QtCore.Qt.KeyboardModifier, PySide6.QtCore.Qt.Key], k2: Union[PySide6.QtCore.QKeyCombination, PySide6.QtCore.Qt.KeyboardModifier, PySide6.QtCore.Qt.Key] = ..., k3: Union[PySide6.QtCore.QKeyCombination, PySide6.QtCore.Qt.KeyboardModifier, PySide6.QtCore.Qt.Key] = ..., k4: Union[PySide6.QtCore.QKeyCombination, PySide6.QtCore.Qt.KeyboardModifier, PySide6.QtCore.Qt.Key] = ...) -> None: ...
    @overload
    def __init__(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> None: ...
    @overload
    def __init__(self, key: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> None: ...
    @overload
    def __init__(self, ks: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def count(self) -> int: ...
    @staticmethod
    def fromString(str: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> PySide6.QtGui.QKeySequence: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def keyBindings(key: PySide6.QtGui.QKeySequence.StandardKey) -> List[PySide6.QtGui.QKeySequence]: ...
    @staticmethod
    def listFromString(str: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> List[PySide6.QtGui.QKeySequence]: ...
    @staticmethod
    def listToString(list: Sequence[PySide6.QtGui.QKeySequence], format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> str: ...
    def matches(self, seq: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QKeySequence.SequenceMatch: ...
    @staticmethod
    def mnemonic(text: str) -> PySide6.QtGui.QKeySequence: ...
    def swap(self, other: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> None: ...
    def toString(self, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> str: ...


class QLinearGradient(PySide6.QtGui.QGradient):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QLinearGradient: PySide6.QtGui.QLinearGradient) -> None: ...
    @overload
    def __init__(self, start: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], finalStop: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def __init__(self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def finalStop(self) -> PySide6.QtCore.QPointF: ...
    @overload
    def setFinalStop(self, stop: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setFinalStop(self, x: float, y: float) -> None: ...
    @overload
    def setStart(self, start: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setStart(self, x: float, y: float) -> None: ...
    def start(self) -> PySide6.QtCore.QPointF: ...


class QMatrix2x2(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix2x2: PySide6.QtGui.QMatrix2x2) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix2x2) -> PySide6.QtGui.QMatrix2x2: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix2x2: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix2x2) -> PySide6.QtGui.QMatrix2x2: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix2x2: ...


class QMatrix2x3(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix2x3: PySide6.QtGui.QMatrix2x3) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix2x3) -> PySide6.QtGui.QMatrix2x3: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix2x3: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix2x3) -> PySide6.QtGui.QMatrix2x3: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix3x2: ...


class QMatrix2x4(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix2x4: PySide6.QtGui.QMatrix2x4) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix2x4) -> PySide6.QtGui.QMatrix2x4: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix2x4: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix2x4) -> PySide6.QtGui.QMatrix2x4: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix4x2: ...


class QMatrix3x2(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix3x2: PySide6.QtGui.QMatrix3x2) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix3x2) -> PySide6.QtGui.QMatrix3x2: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix3x2: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix3x2) -> PySide6.QtGui.QMatrix3x2: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix2x3: ...


class QMatrix3x3(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix3x3: PySide6.QtGui.QMatrix3x3) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix3x3) -> PySide6.QtGui.QMatrix3x3: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix3x3: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix3x3) -> PySide6.QtGui.QMatrix3x3: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix3x3: ...


class QMatrix3x4(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix3x4: PySide6.QtGui.QMatrix3x4) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix3x4) -> PySide6.QtGui.QMatrix3x4: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix3x4: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix3x4) -> PySide6.QtGui.QMatrix3x4: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix4x3: ...


class QMatrix4x2(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix4x2: PySide6.QtGui.QMatrix4x2) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix4x2) -> PySide6.QtGui.QMatrix4x2: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix4x2: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix4x2) -> PySide6.QtGui.QMatrix4x2: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix2x4: ...


class QMatrix4x3(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QMatrix4x3: PySide6.QtGui.QMatrix4x3) -> None: ...
    @overload
    def __init__(self, arg__1: Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix4x3) -> PySide6.QtGui.QMatrix4x3: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix4x3: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix4x3) -> PySide6.QtGui.QMatrix4x3: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix3x4: ...


class QMatrix4x4(Shiboken.Object):

    class Flag(enum.Flag):

        Identity                 : QMatrix4x4.Flag = ... # 0x0
        Translation              : QMatrix4x4.Flag = ... # 0x1
        Scale                    : QMatrix4x4.Flag = ... # 0x2
        Rotation2D               : QMatrix4x4.Flag = ... # 0x4
        Rotation                 : QMatrix4x4.Flag = ... # 0x8
        Perspective              : QMatrix4x4.Flag = ... # 0x10
        General                  : QMatrix4x4.Flag = ... # 0x1f


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None: ...
    @overload
    def __init__(self, transform: PySide6.QtGui.QTransform) -> None: ...
    @overload
    def __init__(self, values: Iterable) -> None: ...

    def __add__(self, m2: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QMatrix4x4: ...
    @staticmethod
    def __copy__() -> None: ...
    def __dummy(self, arg__1: Sequence[float]) -> None: ...
    def __iadd__(self, other: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QMatrix4x4: ...
    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix4x4: ...
    @overload
    def __imul__(self, other: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QMatrix4x4: ...
    def __isub__(self, other: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QMatrix4x4: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QMatrix4x4: ...
    @overload
    def __mul__(self, m2: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QMatrix4x4: ...
    @overload
    def __mul__(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def __mul__(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def __neg__(self) -> PySide6.QtGui.QMatrix4x4: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, m2: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QMatrix4x4: ...
    def column(self, index: int) -> PySide6.QtGui.QVector4D: ...
    def copyDataTo(self) -> Tuple: ...
    def data(self) -> List[float]: ...
    def determinant(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def flags(self) -> PySide6.QtGui.QMatrix4x4.Flag: ...
    def flipCoordinates(self) -> None: ...
    def frustum(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    def inverted(self) -> Tuple: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def lookAt(self, eye: PySide6.QtGui.QVector3D, center: PySide6.QtGui.QVector3D, up: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def map(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def map(self, point: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @overload
    def map(self, point: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @overload
    def map(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapRect(self, rect: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    @overload
    def mapRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapVector(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def normalMatrix(self) -> PySide6.QtGui.QMatrix3x3: ...
    def optimize(self) -> None: ...
    @overload
    def ortho(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    @overload
    def ortho(self, rect: PySide6.QtCore.QRect) -> None: ...
    @overload
    def ortho(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def perspective(self, verticalAngle: float, aspectRatio: float, nearPlane: float, farPlane: float) -> None: ...
    def projectedRotate(self, angle: float, x: float, y: float, z: float) -> None: ...
    @overload
    def rotate(self, angle: float, vector: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def rotate(self, angle: float, x: float, y: float, z: float = ...) -> None: ...
    @overload
    def rotate(self, quaternion: PySide6.QtGui.QQuaternion) -> None: ...
    def row(self, index: int) -> PySide6.QtGui.QVector4D: ...
    @overload
    def scale(self, factor: float) -> None: ...
    @overload
    def scale(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def scale(self, x: float, y: float) -> None: ...
    @overload
    def scale(self, x: float, y: float, z: float) -> None: ...
    def setColumn(self, index: int, value: PySide6.QtGui.QVector4D) -> None: ...
    def setRow(self, index: int, value: PySide6.QtGui.QVector4D) -> None: ...
    def setToIdentity(self) -> None: ...
    @overload
    def toTransform(self) -> PySide6.QtGui.QTransform: ...
    @overload
    def toTransform(self, distanceToPlane: float) -> PySide6.QtGui.QTransform: ...
    @overload
    def translate(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def translate(self, x: float, y: float) -> None: ...
    @overload
    def translate(self, x: float, y: float, z: float) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix4x4: ...
    @overload
    def viewport(self, left: float, bottom: float, width: float, height: float, nearPlane: float = ..., farPlane: float = ...) -> None: ...
    @overload
    def viewport(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...


class QMouseEvent(PySide6.QtGui.QSinglePointEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scenePos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scenePos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, source: PySide6.QtCore.Qt.MouseEventSource, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QMouseEvent: ...
    def flags(self) -> PySide6.QtCore.Qt.MouseEventFlag: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def source(self) -> PySide6.QtCore.Qt.MouseEventSource: ...
    def windowPos(self) -> PySide6.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QMoveEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QMoveEvent) -> None: ...
    @overload
    def __init__(self, pos: PySide6.QtCore.QPoint, oldPos: PySide6.QtCore.QPoint) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QMoveEvent: ...
    def oldPos(self) -> PySide6.QtCore.QPoint: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...


class QMovie(PySide6.QtCore.QObject):

    error                    : ClassVar[Signal] = ... # error(QImageReader::ImageReaderError)
    finished                 : ClassVar[Signal] = ... # finished()
    frameChanged             : ClassVar[Signal] = ... # frameChanged(int)
    resized                  : ClassVar[Signal] = ... # resized(QSize)
    started                  : ClassVar[Signal] = ... # started()
    stateChanged             : ClassVar[Signal] = ... # stateChanged(QMovie::MovieState)
    updated                  : ClassVar[Signal] = ... # updated(QRect)

    class CacheMode(enum.Enum):

        CacheNone                : QMovie.CacheMode = ... # 0x0
        CacheAll                 : QMovie.CacheMode = ... # 0x1


    class MovieState(enum.Enum):

        NotRunning               : QMovie.MovieState = ... # 0x0
        Paused                   : QMovie.MovieState = ... # 0x1
        Running                  : QMovie.MovieState = ... # 0x2


    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: Union[PySide6.QtCore.QByteArray, bytes] = ..., parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, fileName: str, format: Union[PySide6.QtCore.QByteArray, bytes] = ..., parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def cacheMode(self) -> PySide6.QtGui.QMovie.CacheMode: ...
    def currentFrameNumber(self) -> int: ...
    def currentImage(self) -> PySide6.QtGui.QImage: ...
    def currentPixmap(self) -> PySide6.QtGui.QPixmap: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def frameCount(self) -> int: ...
    def frameRect(self) -> PySide6.QtCore.QRect: ...
    def isValid(self) -> bool: ...
    def jumpToFrame(self, frameNumber: int) -> bool: ...
    def jumpToNextFrame(self) -> bool: ...
    def lastError(self) -> PySide6.QtGui.QImageReader.ImageReaderError: ...
    def lastErrorString(self) -> str: ...
    def loopCount(self) -> int: ...
    def nextFrameDelay(self) -> int: ...
    def scaledSize(self) -> PySide6.QtCore.QSize: ...
    def setBackgroundColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setCacheMode(self, mode: PySide6.QtGui.QMovie.CacheMode) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def setScaledSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setSpeed(self, percentSpeed: int) -> None: ...
    def speed(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> PySide6.QtGui.QMovie.MovieState: ...
    def stop(self) -> None: ...
    @staticmethod
    def supportedFormats() -> List[PySide6.QtCore.QByteArray]: ...


class QNativeGestureEvent(PySide6.QtGui.QSinglePointEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QNativeGestureEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.Qt.NativeGestureType, dev: PySide6.QtGui.QPointingDevice, fingerCount: int, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scenePos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], value: float, delta: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], sequenceId: int = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.Qt.NativeGestureType, dev: PySide6.QtGui.QPointingDevice, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scenePos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], value: float, sequenceId: int, intArgument: int) -> None: ...

    def clone(self) -> PySide6.QtGui.QNativeGestureEvent: ...
    def delta(self) -> PySide6.QtCore.QPointF: ...
    def fingerCount(self) -> int: ...
    def gestureType(self) -> PySide6.QtCore.Qt.NativeGestureType: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def localPos(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def value(self) -> float: ...
    def windowPos(self) -> PySide6.QtCore.QPointF: ...


class QOffscreenSurface(PySide6.QtCore.QObject, PySide6.QtGui.QSurface):

    screenChanged            : ClassVar[Signal] = ... # screenChanged(QScreen*)

    def __init__(self, screen: Optional[PySide6.QtGui.QScreen] = ..., parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def create(self) -> None: ...
    def destroy(self) -> None: ...
    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def isValid(self) -> bool: ...
    def requestedFormat(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def resolveInterface(self, name: bytes, revision: int) -> int: ...
    def screen(self) -> PySide6.QtGui.QScreen: ...
    def setFormat(self, format: Union[PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOption]) -> None: ...
    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType: ...


class QOpenGLContext(PySide6.QtCore.QObject):

    aboutToBeDestroyed       : ClassVar[Signal] = ... # aboutToBeDestroyed()

    class OpenGLModuleType(enum.Enum):

        LibGL                    : QOpenGLContext.OpenGLModuleType = ... # 0x0
        LibGLES                  : QOpenGLContext.OpenGLModuleType = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def areSharing(first: PySide6.QtGui.QOpenGLContext, second: PySide6.QtGui.QOpenGLContext) -> bool: ...
    def create(self) -> bool: ...
    @staticmethod
    def currentContext() -> PySide6.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def extensions(self) -> Set[PySide6.QtCore.QByteArray]: ...
    def extraFunctions(self) -> PySide6.QtGui.QOpenGLExtraFunctions: ...
    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def functions(self) -> PySide6.QtGui.QOpenGLFunctions: ...
    @staticmethod
    def globalShareContext() -> PySide6.QtGui.QOpenGLContext: ...
    def hasExtension(self, extension: Union[PySide6.QtCore.QByteArray, bytes]) -> bool: ...
    def isOpenGLES(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self, surface: PySide6.QtGui.QSurface) -> bool: ...
    @staticmethod
    def openGLModuleType() -> PySide6.QtGui.QOpenGLContext.OpenGLModuleType: ...
    def resolveInterface(self, name: bytes, revision: int) -> int: ...
    def screen(self) -> PySide6.QtGui.QScreen: ...
    def setFormat(self, format: Union[PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOption]) -> None: ...
    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None: ...
    def setShareContext(self, shareContext: PySide6.QtGui.QOpenGLContext) -> None: ...
    def shareContext(self) -> PySide6.QtGui.QOpenGLContext: ...
    def shareGroup(self) -> PySide6.QtGui.QOpenGLContextGroup: ...
    @staticmethod
    def supportsThreadedOpenGL() -> bool: ...
    def surface(self) -> PySide6.QtGui.QSurface: ...
    def swapBuffers(self, surface: PySide6.QtGui.QSurface) -> None: ...


class QOpenGLContextGroup(PySide6.QtCore.QObject):
    @staticmethod
    def currentContextGroup() -> PySide6.QtGui.QOpenGLContextGroup: ...
    def shares(self) -> List[PySide6.QtGui.QOpenGLContext]: ...


class QOpenGLExtraFunctions(PySide6.QtGui.QOpenGLFunctions):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, context: PySide6.QtGui.QOpenGLContext) -> None: ...

    def glActiveShaderProgram(self, pipeline: int, program: int) -> None: ...
    def glBeginQuery(self, target: int, id: int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode: int) -> None: ...
    def glBindBufferBase(self, target: int, index: int, buffer: int) -> None: ...
    def glBindImageTexture(self, unit: int, texture: int, level: int, layered: int, layer: int, access: int, format: int) -> None: ...
    def glBindProgramPipeline(self, pipeline: int) -> None: ...
    def glBindSampler(self, unit: int, sampler: int) -> None: ...
    def glBindTransformFeedback(self, target: int, id: int) -> None: ...
    def glBindVertexArray(self, array: int) -> None: ...
    def glBlendBarrier(self) -> None: ...
    def glBlendEquationSeparatei(self, buf: int, modeRGB: int, modeAlpha: int) -> None: ...
    def glBlendEquationi(self, buf: int, mode: int) -> None: ...
    def glBlendFuncSeparatei(self, buf: int, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int) -> None: ...
    def glBlendFunci(self, buf: int, src: int, dst: int) -> None: ...
    def glBlitFramebuffer(self, srcX0: int, srcY0: int, srcX1: int, srcY1: int, dstX0: int, dstY0: int, dstX1: int, dstY1: int, mask: int, filter: int) -> None: ...
    def glClearBufferfi(self, buffer: int, drawbuffer: int, depth: float, stencil: int) -> None: ...
    def glClearBufferfv(self, buffer: int, drawbuffer: int, value: Sequence[float]) -> None: ...
    def glClearBufferiv(self, buffer: int, drawbuffer: int, value: Sequence[int]) -> None: ...
    def glClearBufferuiv(self, buffer: int, drawbuffer: int, value: Sequence[int]) -> None: ...
    def glColorMaski(self, index: int, r: int, g: int, b: int, a: int) -> None: ...
    def glCompressedTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, imageSize: int, data: int) -> None: ...
    def glCompressedTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, imageSize: int, data: int) -> None: ...
    def glCopyImageSubData(self, srcName: int, srcTarget: int, srcLevel: int, srcX: int, srcY: int, srcZ: int, dstName: int, dstTarget: int, dstLevel: int, dstX: int, dstY: int, dstZ: int, srcWidth: int, srcHeight: int, srcDepth: int) -> None: ...
    def glCopyTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, x: int, y: int, width: int, height: int) -> None: ...
    def glDebugMessageControl(self, source: int, type: int, severity: int, count: int, ids: Sequence[int], enabled: int) -> None: ...
    def glDebugMessageInsert(self, source: int, type: int, id: int, severity: int, length: int, buf: bytes) -> None: ...
    def glDeleteProgramPipelines(self, n: int, pipelines: Sequence[int]) -> None: ...
    def glDeleteQueries(self, n: int, ids: Sequence[int]) -> None: ...
    def glDeleteSamplers(self, count: int, samplers: Sequence[int]) -> None: ...
    def glDeleteTransformFeedbacks(self, n: int, ids: Sequence[int]) -> None: ...
    def glDeleteVertexArrays(self, n: int, arrays: Sequence[int]) -> None: ...
    def glDisablei(self, target: int, index: int) -> None: ...
    def glDispatchCompute(self, num_groups_x: int, num_groups_y: int, num_groups_z: int) -> None: ...
    def glDrawArraysIndirect(self, mode: int, indirect: int) -> None: ...
    def glDrawArraysInstanced(self, mode: int, first: int, count: int, instancecount: int) -> None: ...
    def glDrawBuffers(self, n: int, bufs: Sequence[int]) -> None: ...
    def glDrawElementsBaseVertex(self, mode: int, count: int, type: int, indices: int, basevertex: int) -> None: ...
    def glDrawElementsIndirect(self, mode: int, type: int, indirect: int) -> None: ...
    def glDrawElementsInstanced(self, mode: int, count: int, type: int, indices: int, instancecount: int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode: int, count: int, type: int, indices: int, instancecount: int, basevertex: int) -> None: ...
    def glDrawRangeElements(self, mode: int, start: int, end: int, count: int, type: int, indices: int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode: int, start: int, end: int, count: int, type: int, indices: int, basevertex: int) -> None: ...
    def glEnablei(self, target: int, index: int) -> None: ...
    def glEndQuery(self, target: int) -> None: ...
    def glFramebufferParameteri(self, target: int, pname: int, param: int) -> None: ...
    def glFramebufferTexture(self, target: int, attachment: int, texture: int, level: int) -> None: ...
    def glFramebufferTextureLayer(self, target: int, attachment: int, texture: int, level: int, layer: int) -> None: ...
    def glGenProgramPipelines(self, n: int, pipelines: Sequence[int]) -> None: ...
    def glGenQueries(self, n: int, ids: Sequence[int]) -> None: ...
    def glGenSamplers(self, count: int, samplers: Sequence[int]) -> None: ...
    def glGenTransformFeedbacks(self, n: int, ids: Sequence[int]) -> None: ...
    def glGenVertexArrays(self, n: int, arrays: Sequence[int]) -> None: ...
    def glGetActiveUniformBlockiv(self, program: int, uniformBlockIndex: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetActiveUniformsiv(self, program: int, uniformCount: int, uniformIndices: Sequence[int], pname: int, params: Sequence[int]) -> None: ...
    def glGetBooleani_v(self, target: int, index: int) -> Union[bool, List[Any]]: ...
    def glGetFragDataLocation(self, program: int, name: bytes) -> int: ...
    def glGetFramebufferParameteriv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    @overload
    def glGetIntegeri_v(self, arg__1: int, arg__2: int) -> Union[int, List[Any]]: ...
    @overload
    def glGetIntegeri_v(self, target: int, index: int, data: Sequence[int]) -> None: ...
    def glGetInternalformativ(self, target: int, internalformat: int, pname: int, bufSize: int, params: Sequence[int]) -> None: ...
    def glGetMultisamplefv(self, pname: int, index: int, val: Sequence[float]) -> None: ...
    def glGetProgramInterfaceiv(self, program: int, programInterface: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetProgramPipelineiv(self, pipeline: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetProgramResourceIndex(self, program: int, programInterface: int, name: bytes) -> int: ...
    def glGetProgramResourceLocation(self, program: int, programInterface: int, name: bytes) -> int: ...
    def glGetProgramResourceiv(self, program: int, programInterface: int, index: int, propCount: int, props: Sequence[int], bufSize: int, length: Sequence[int], params: Sequence[int]) -> None: ...
    def glGetQueryObjectuiv(self, id: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetQueryiv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetSamplerParameterIiv(self, sampler: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetSamplerParameterIuiv(self, sampler: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetSamplerParameterfv(self, sampler: int, pname: int, params: Sequence[float]) -> None: ...
    def glGetSamplerParameteriv(self, sampler: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetStringi(self, name: int, index: int) -> str: ...
    def glGetTexLevelParameterfv(self, target: int, level: int, pname: int, params: Sequence[float]) -> None: ...
    def glGetTexLevelParameteriv(self, target: int, level: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetTexParameterIiv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetTexParameterIuiv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetUniformBlockIndex(self, program: int, uniformBlockName: bytes) -> int: ...
    def glGetUniformuiv(self, program: int, location: int, params: Sequence[int]) -> None: ...
    def glGetVertexAttribIiv(self, index: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetVertexAttribIuiv(self, index: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetnUniformfv(self, program: int, location: int, bufSize: int) -> float: ...
    def glGetnUniformiv(self, program: int, location: int, bufSize: int, params: Sequence[int]) -> None: ...
    def glGetnUniformuiv(self, program: int, location: int, bufSize: int, params: Sequence[int]) -> None: ...
    def glInvalidateFramebuffer(self, target: int, numAttachments: int, attachments: Sequence[int]) -> None: ...
    def glInvalidateSubFramebuffer(self, target: int, numAttachments: int, attachments: Sequence[int], x: int, y: int, width: int, height: int) -> None: ...
    def glIsEnabledi(self, target: int, index: int) -> int: ...
    def glIsProgramPipeline(self, pipeline: int) -> int: ...
    def glIsQuery(self, id: int) -> int: ...
    def glIsSampler(self, sampler: int) -> int: ...
    def glIsTransformFeedback(self, id: int) -> int: ...
    def glIsVertexArray(self, array: int) -> int: ...
    def glMemoryBarrier(self, barriers: int) -> None: ...
    def glMemoryBarrierByRegion(self, barriers: int) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glObjectLabel(self, identifier: int, name: int, length: int, label: bytes) -> None: ...
    def glObjectPtrLabel(self, ptr: int, length: int, label: bytes) -> None: ...
    def glPatchParameteri(self, pname: int, value: int) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPrimitiveBoundingBox(self, minX: float, minY: float, minZ: float, minW: float, maxX: float, maxY: float, maxZ: float, maxW: float) -> None: ...
    def glProgramBinary(self, program: int, binaryFormat: int, binary: int, length: int) -> None: ...
    def glProgramParameteri(self, program: int, pname: int, value: int) -> None: ...
    def glProgramUniform1f(self, program: int, location: int, v0: float) -> None: ...
    def glProgramUniform1fv(self, program: int, location: int, count: int, value: Sequence[float]) -> None: ...
    def glProgramUniform1i(self, program: int, location: int, v0: int) -> None: ...
    def glProgramUniform1iv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniform1ui(self, program: int, location: int, v0: int) -> None: ...
    def glProgramUniform1uiv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniform2f(self, program: int, location: int, v0: float, v1: float) -> None: ...
    def glProgramUniform2fv(self, program: int, location: int, count: int, value: Sequence[float]) -> None: ...
    def glProgramUniform2i(self, program: int, location: int, v0: int, v1: int) -> None: ...
    def glProgramUniform2iv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniform2ui(self, program: int, location: int, v0: int, v1: int) -> None: ...
    def glProgramUniform2uiv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniform3f(self, program: int, location: int, v0: float, v1: float, v2: float) -> None: ...
    def glProgramUniform3fv(self, program: int, location: int, count: int, value: Sequence[float]) -> None: ...
    def glProgramUniform3i(self, program: int, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glProgramUniform3iv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniform3ui(self, program: int, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glProgramUniform3uiv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniform4f(self, program: int, location: int, v0: float, v1: float, v2: float, v3: float) -> None: ...
    def glProgramUniform4fv(self, program: int, location: int, count: int, value: Sequence[float]) -> None: ...
    def glProgramUniform4i(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glProgramUniform4iv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniform4ui(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glProgramUniform4uiv(self, program: int, location: int, count: int, value: Sequence[int]) -> None: ...
    def glProgramUniformMatrix2fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix3fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix4fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program: int, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glPushDebugGroup(self, source: int, id: int, length: int, message: bytes) -> None: ...
    def glReadBuffer(self, mode: int) -> None: ...
    def glReadnPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, bufSize: int, data: int) -> None: ...
    def glRenderbufferStorageMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int) -> None: ...
    def glSampleMaski(self, maskNumber: int, mask: int) -> None: ...
    def glSamplerParameterIiv(self, sampler: int, pname: int, param: Sequence[int]) -> None: ...
    def glSamplerParameterIuiv(self, sampler: int, pname: int, param: Sequence[int]) -> None: ...
    def glSamplerParameterf(self, sampler: int, pname: int, param: float) -> None: ...
    def glSamplerParameterfv(self, sampler: int, pname: int, param: Sequence[float]) -> None: ...
    def glSamplerParameteri(self, sampler: int, pname: int, param: int) -> None: ...
    def glSamplerParameteriv(self, sampler: int, pname: int, param: Sequence[int]) -> None: ...
    def glTexBuffer(self, target: int, internalformat: int, buffer: int) -> None: ...
    def glTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, format: int, type: int, pixels: int) -> None: ...
    def glTexParameterIiv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glTexParameterIuiv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glTexStorage2D(self, target: int, levels: int, internalformat: int, width: int, height: int) -> None: ...
    def glTexStorage2DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, fixedsamplelocations: int) -> None: ...
    def glTexStorage3D(self, target: int, levels: int, internalformat: int, width: int, height: int, depth: int) -> None: ...
    def glTexStorage3DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, depth: int, fixedsamplelocations: int) -> None: ...
    def glTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, type: int, pixels: int) -> None: ...
    def glUniform1ui(self, location: int, v0: int) -> None: ...
    def glUniform1uiv(self, location: int, count: int, value: Sequence[int]) -> None: ...
    def glUniform2ui(self, location: int, v0: int, v1: int) -> None: ...
    def glUniform2uiv(self, location: int, count: int, value: Sequence[int]) -> None: ...
    def glUniform3ui(self, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glUniform3uiv(self, location: int, count: int, value: Sequence[int]) -> None: ...
    def glUniform4ui(self, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glUniform4uiv(self, location: int, count: int, value: Sequence[int]) -> None: ...
    def glUniformBlockBinding(self, program: int, uniformBlockIndex: int, uniformBlockBinding: int) -> None: ...
    def glUniformMatrix2x3fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUniformMatrix2x4fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUniformMatrix3x2fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUniformMatrix3x4fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUniformMatrix4x2fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUniformMatrix4x3fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUnmapBuffer(self, target: int) -> int: ...
    def glUseProgramStages(self, pipeline: int, stages: int, program: int) -> None: ...
    def glValidateProgramPipeline(self, pipeline: int) -> None: ...
    def glVertexAttribBinding(self, attribindex: int, bindingindex: int) -> None: ...
    def glVertexAttribDivisor(self, index: int, divisor: int) -> None: ...
    def glVertexAttribFormat(self, attribindex: int, size: int, type: int, normalized: int, relativeoffset: int) -> None: ...
    def glVertexAttribI4i(self, index: int, x: int, y: int, z: int, w: int) -> None: ...
    def glVertexAttribI4iv(self, index: int, v: Sequence[int]) -> None: ...
    def glVertexAttribI4ui(self, index: int, x: int, y: int, z: int, w: int) -> None: ...
    def glVertexAttribI4uiv(self, index: int, v: Sequence[int]) -> None: ...
    def glVertexAttribIFormat(self, attribindex: int, size: int, type: int, relativeoffset: int) -> None: ...
    def glVertexAttribIPointer(self, index: int, size: int, type: int, stride: int, pointer: int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex: int, divisor: int) -> None: ...


class QOpenGLFunctions(Shiboken.Object):

    class OpenGLFeature(enum.Flag):

        Multitexture             : QOpenGLFunctions.OpenGLFeature = ... # 0x1
        Shaders                  : QOpenGLFunctions.OpenGLFeature = ... # 0x2
        Buffers                  : QOpenGLFunctions.OpenGLFeature = ... # 0x4
        Framebuffers             : QOpenGLFunctions.OpenGLFeature = ... # 0x8
        BlendColor               : QOpenGLFunctions.OpenGLFeature = ... # 0x10
        BlendEquation            : QOpenGLFunctions.OpenGLFeature = ... # 0x20
        BlendEquationSeparate    : QOpenGLFunctions.OpenGLFeature = ... # 0x40
        BlendFuncSeparate        : QOpenGLFunctions.OpenGLFeature = ... # 0x80
        BlendSubtract            : QOpenGLFunctions.OpenGLFeature = ... # 0x100
        CompressedTextures       : QOpenGLFunctions.OpenGLFeature = ... # 0x200
        Multisample              : QOpenGLFunctions.OpenGLFeature = ... # 0x400
        StencilSeparate          : QOpenGLFunctions.OpenGLFeature = ... # 0x800
        NPOTTextures             : QOpenGLFunctions.OpenGLFeature = ... # 0x1000
        NPOTTextureRepeat        : QOpenGLFunctions.OpenGLFeature = ... # 0x2000
        FixedFunctionPipeline    : QOpenGLFunctions.OpenGLFeature = ... # 0x4000
        TextureRGFormats         : QOpenGLFunctions.OpenGLFeature = ... # 0x8000
        MultipleRenderTargets    : QOpenGLFunctions.OpenGLFeature = ... # 0x10000
        BlendEquationAdvanced    : QOpenGLFunctions.OpenGLFeature = ... # 0x20000


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, context: PySide6.QtGui.QOpenGLContext) -> None: ...

    def glActiveTexture(self, texture: int) -> None: ...
    def glAttachShader(self, program: int, shader: int) -> None: ...
    def glBindAttribLocation(self, program: int, index: int, name: bytes) -> None: ...
    def glBindBuffer(self, target: int, buffer: int) -> None: ...
    def glBindFramebuffer(self, target: int, framebuffer: int) -> None: ...
    def glBindRenderbuffer(self, target: int, renderbuffer: int) -> None: ...
    def glBindTexture(self, target: int, texture: int) -> None: ...
    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glBlendEquation(self, mode: int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB: int, modeAlpha: int) -> None: ...
    def glBlendFunc(self, sfactor: int, dfactor: int) -> None: ...
    def glBlendFuncSeparate(self, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int) -> None: ...
    def glCheckFramebufferStatus(self, target: int) -> int: ...
    def glClear(self, mask: int) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepthf(self, depth: float) -> None: ...
    def glClearStencil(self, s: int) -> None: ...
    def glColorMask(self, red: int, green: int, blue: int, alpha: int) -> None: ...
    def glCompileShader(self, shader: int) -> None: ...
    def glCompressedTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, imageSize: int, data: int) -> None: ...
    def glCompressedTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, imageSize: int, data: int) -> None: ...
    def glCopyTexImage2D(self, target: int, level: int, internalformat: int, x: int, y: int, width: int, height: int, border: int) -> None: ...
    def glCopyTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, x: int, y: int, width: int, height: int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type: int) -> int: ...
    def glCullFace(self, mode: int) -> None: ...
    def glDeleteBuffers(self, n: int, buffers: Sequence[int]) -> None: ...
    def glDeleteFramebuffers(self, n: int, framebuffers: Sequence[int]) -> None: ...
    def glDeleteProgram(self, program: int) -> None: ...
    def glDeleteRenderbuffers(self, n: int, renderbuffers: Sequence[int]) -> None: ...
    def glDeleteShader(self, shader: int) -> None: ...
    def glDeleteTextures(self, n: int, textures: Sequence[int]) -> None: ...
    def glDepthFunc(self, func: int) -> None: ...
    def glDepthMask(self, flag: int) -> None: ...
    def glDepthRangef(self, zNear: float, zFar: float) -> None: ...
    def glDetachShader(self, program: int, shader: int) -> None: ...
    def glDisable(self, cap: int) -> None: ...
    def glDisableVertexAttribArray(self, index: int) -> None: ...
    def glDrawArrays(self, mode: int, first: int, count: int) -> None: ...
    def glDrawElements(self, mode: int, count: int, type: int, indices: int) -> None: ...
    def glEnable(self, cap: int) -> None: ...
    def glEnableVertexAttribArray(self, index: int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target: int, attachment: int, renderbuffertarget: int, renderbuffer: int) -> None: ...
    def glFramebufferTexture2D(self, target: int, attachment: int, textarget: int, texture: int, level: int) -> None: ...
    def glFrontFace(self, mode: int) -> None: ...
    def glGenBuffers(self, n: int, buffers: Sequence[int]) -> None: ...
    def glGenFramebuffers(self, n: int, framebuffers: Sequence[int]) -> None: ...
    def glGenRenderbuffers(self, n: int, renderbuffers: Sequence[int]) -> None: ...
    def glGenTextures(self, n: int, textures: Sequence[int]) -> None: ...
    def glGenerateMipmap(self, target: int) -> None: ...
    def glGetAttachedShaders(self, program: int, maxcount: int, count: Sequence[int], shaders: Sequence[int]) -> None: ...
    def glGetAttribLocation(self, program: int, name: bytes) -> int: ...
    def glGetBooleanv(self, pname: int) -> Union[bool, List[Any]]: ...
    def glGetBufferParameteriv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetError(self) -> int: ...
    @overload
    def glGetFloatv(self, arg__1: int) -> Union[float, List[Any]]: ...
    @overload
    def glGetFloatv(self, pname: int, params: Sequence[float]) -> None: ...
    def glGetFramebufferAttachmentParameteriv(self, target: int, attachment: int, pname: int, params: Sequence[int]) -> None: ...
    @overload
    def glGetIntegerv(self, arg__1: int) -> Union[int, List[Any]]: ...
    @overload
    def glGetIntegerv(self, pname: int, params: Sequence[int]) -> None: ...
    def glGetProgramiv(self, program: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetRenderbufferParameteriv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetShaderPrecisionFormat(self, shadertype: int, precisiontype: int, range: Sequence[int], precision: Sequence[int]) -> None: ...
    def glGetShaderSource(self, shader: int) -> bytes: ...
    def glGetShaderiv(self, shader: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetString(self, name: int) -> str: ...
    def glGetTexParameterfv(self, target: int, pname: int, params: Sequence[float]) -> None: ...
    def glGetTexParameteriv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glGetUniformLocation(self, program: int, name: bytes) -> int: ...
    def glGetUniformfv(self, program: int, location: int, params: Sequence[float]) -> None: ...
    def glGetUniformiv(self, program: int, location: int, params: Sequence[int]) -> None: ...
    def glGetVertexAttribfv(self, index: int, pname: int, params: Sequence[float]) -> None: ...
    def glGetVertexAttribiv(self, index: int, pname: int, params: Sequence[int]) -> None: ...
    def glHint(self, target: int, mode: int) -> None: ...
    def glIsBuffer(self, buffer: int) -> int: ...
    def glIsEnabled(self, cap: int) -> int: ...
    def glIsFramebuffer(self, framebuffer: int) -> int: ...
    def glIsProgram(self, program: int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer: int) -> int: ...
    def glIsShader(self, shader: int) -> int: ...
    def glIsTexture(self, texture: int) -> int: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLinkProgram(self, program: int) -> None: ...
    def glPixelStorei(self, pname: int, param: int) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glReadPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, pixels: int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target: int, internalformat: int, width: int, height: int) -> None: ...
    def glSampleCoverage(self, value: float, invert: int) -> None: ...
    def glScissor(self, x: int, y: int, width: int, height: int) -> None: ...
    def glShaderBinary(self, n: int, shaders: Sequence[int], binaryformat: int, binary: int, length: int) -> None: ...
    def glShaderSource(self, shader: int, source: str) -> None: ...
    def glStencilFunc(self, func: int, ref: int, mask: int) -> None: ...
    def glStencilFuncSeparate(self, face: int, func: int, ref: int, mask: int) -> None: ...
    def glStencilMask(self, mask: int) -> None: ...
    def glStencilMaskSeparate(self, face: int, mask: int) -> None: ...
    def glStencilOp(self, fail: int, zfail: int, zpass: int) -> None: ...
    def glStencilOpSeparate(self, face: int, fail: int, zfail: int, zpass: int) -> None: ...
    def glTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, format: int, type: int, pixels: int) -> None: ...
    def glTexParameterf(self, target: int, pname: int, param: float) -> None: ...
    def glTexParameterfv(self, target: int, pname: int, params: Sequence[float]) -> None: ...
    def glTexParameteri(self, target: int, pname: int, param: int) -> None: ...
    def glTexParameteriv(self, target: int, pname: int, params: Sequence[int]) -> None: ...
    def glTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, type: int, pixels: int) -> None: ...
    def glUniform1f(self, location: int, x: float) -> None: ...
    def glUniform1fv(self, location: int, count: int, v: Sequence[float]) -> None: ...
    def glUniform1i(self, location: int, x: int) -> None: ...
    def glUniform1iv(self, location: int, count: int, v: Sequence[int]) -> None: ...
    def glUniform2f(self, location: int, x: float, y: float) -> None: ...
    def glUniform2fv(self, location: int, count: int, v: Sequence[float]) -> None: ...
    def glUniform2i(self, location: int, x: int, y: int) -> None: ...
    def glUniform2iv(self, location: int, count: int, v: Sequence[int]) -> None: ...
    def glUniform3f(self, location: int, x: float, y: float, z: float) -> None: ...
    def glUniform3fv(self, location: int, count: int, v: Sequence[float]) -> None: ...
    def glUniform3i(self, location: int, x: int, y: int, z: int) -> None: ...
    def glUniform3iv(self, location: int, count: int, v: Sequence[int]) -> None: ...
    def glUniform4f(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    def glUniform4fv(self, location: int, count: int, v: Sequence[float]) -> None: ...
    def glUniform4i(self, location: int, x: int, y: int, z: int, w: int) -> None: ...
    def glUniform4iv(self, location: int, count: int, v: Sequence[int]) -> None: ...
    def glUniformMatrix2fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUniformMatrix3fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUniformMatrix4fv(self, location: int, count: int, transpose: int, value: Sequence[float]) -> None: ...
    def glUseProgram(self, program: int) -> None: ...
    def glValidateProgram(self, program: int) -> None: ...
    def glVertexAttrib1f(self, indx: int, x: float) -> None: ...
    def glVertexAttrib1fv(self, indx: int, values: Sequence[float]) -> None: ...
    def glVertexAttrib2f(self, indx: int, x: float, y: float) -> None: ...
    def glVertexAttrib2fv(self, indx: int, values: Sequence[float]) -> None: ...
    def glVertexAttrib3f(self, indx: int, x: float, y: float, z: float) -> None: ...
    def glVertexAttrib3fv(self, indx: int, values: Sequence[float]) -> None: ...
    def glVertexAttrib4f(self, indx: int, x: float, y: float, z: float, w: float) -> None: ...
    def glVertexAttrib4fv(self, indx: int, values: Sequence[float]) -> None: ...
    def glVertexAttribPointer(self, indx: int, size: int, type: int, normalized: int, stride: int, ptr: int) -> None: ...
    def glViewport(self, x: int, y: int, width: int, height: int) -> None: ...
    def hasOpenGLFeature(self, feature: PySide6.QtGui.QOpenGLFunctions.OpenGLFeature) -> bool: ...
    def initializeOpenGLFunctions(self) -> None: ...
    def openGLFeatures(self) -> PySide6.QtGui.QOpenGLFunctions.OpenGLFeature: ...


class QOverrideCursorGuard(Shiboken.Object):

    def __init__(self) -> None: ...

    def __enter__(self) -> PySide6.QtGui.QOverrideCursorGuard: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None: ...
    def restoreOverrideCursor(self) -> None: ...


class QPageLayout(Shiboken.Object):

    class Mode(enum.Enum):

        StandardMode             : QPageLayout.Mode = ... # 0x0
        FullPageMode             : QPageLayout.Mode = ... # 0x1


    class Orientation(enum.Enum):

        Portrait                 : QPageLayout.Orientation = ... # 0x0
        Landscape                : QPageLayout.Orientation = ... # 0x1


    class Unit(enum.Enum):

        Millimeter               : QPageLayout.Unit = ... # 0x0
        Point                    : QPageLayout.Unit = ... # 0x1
        Inch                     : QPageLayout.Unit = ... # 0x2
        Pica                     : QPageLayout.Unit = ... # 0x3
        Didot                    : QPageLayout.Unit = ... # 0x4
        Cicero                   : QPageLayout.Unit = ... # 0x5


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QPageLayout) -> None: ...
    @overload
    def __init__(self, pageSize: Union[PySide6.QtGui.QPageSize, PySide6.QtGui.QPageSize.PageSizeId, PySide6.QtCore.QSize], orientation: PySide6.QtGui.QPageLayout.Orientation, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins], units: PySide6.QtGui.QPageLayout.Unit = ..., minMargins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins] = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @overload
    def fullRect(self) -> PySide6.QtCore.QRectF: ...
    @overload
    def fullRect(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QRectF: ...
    def fullRectPixels(self, resolution: int) -> PySide6.QtCore.QRect: ...
    def fullRectPoints(self) -> PySide6.QtCore.QRect: ...
    def isEquivalentTo(self, other: PySide6.QtGui.QPageLayout) -> bool: ...
    def isValid(self) -> bool: ...
    @overload
    def margins(self) -> PySide6.QtCore.QMarginsF: ...
    @overload
    def margins(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QMarginsF: ...
    def marginsPixels(self, resolution: int) -> PySide6.QtCore.QMargins: ...
    def marginsPoints(self) -> PySide6.QtCore.QMargins: ...
    def maximumMargins(self) -> PySide6.QtCore.QMarginsF: ...
    def minimumMargins(self) -> PySide6.QtCore.QMarginsF: ...
    def mode(self) -> PySide6.QtGui.QPageLayout.Mode: ...
    def orientation(self) -> PySide6.QtGui.QPageLayout.Orientation: ...
    def pageSize(self) -> PySide6.QtGui.QPageSize: ...
    @overload
    def paintRect(self) -> PySide6.QtCore.QRectF: ...
    @overload
    def paintRect(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QRectF: ...
    def paintRectPixels(self, resolution: int) -> PySide6.QtCore.QRect: ...
    def paintRectPoints(self) -> PySide6.QtCore.QRect: ...
    def setBottomMargin(self, bottomMargin: float) -> bool: ...
    def setLeftMargin(self, leftMargin: float) -> bool: ...
    def setMargins(self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]) -> bool: ...
    def setMinimumMargins(self, minMargins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]) -> None: ...
    def setMode(self, mode: PySide6.QtGui.QPageLayout.Mode) -> None: ...
    def setOrientation(self, orientation: PySide6.QtGui.QPageLayout.Orientation) -> None: ...
    def setPageSize(self, pageSize: Union[PySide6.QtGui.QPageSize, PySide6.QtGui.QPageSize.PageSizeId, PySide6.QtCore.QSize], minMargins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins] = ...) -> None: ...
    def setRightMargin(self, rightMargin: float) -> bool: ...
    def setTopMargin(self, topMargin: float) -> bool: ...
    def setUnits(self, units: PySide6.QtGui.QPageLayout.Unit) -> None: ...
    def swap(self, other: PySide6.QtGui.QPageLayout) -> None: ...
    def units(self) -> PySide6.QtGui.QPageLayout.Unit: ...


class QPageRanges(Shiboken.Object):

    class Range(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, Range: PySide6.QtGui.QPageRanges.Range) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def contains(self, pageNumber: int) -> bool: ...


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QPageRanges) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def addPage(self, pageNumber: int) -> None: ...
    def addRange(self, from_: int, to: int) -> None: ...
    def clear(self) -> None: ...
    def contains(self, pageNumber: int) -> bool: ...
    def firstPage(self) -> int: ...
    @staticmethod
    def fromString(ranges: str) -> PySide6.QtGui.QPageRanges: ...
    def isEmpty(self) -> bool: ...
    def lastPage(self) -> int: ...
    def swap(self, other: PySide6.QtGui.QPageRanges) -> None: ...
    def toRangeList(self) -> List[PySide6.QtGui.QPageRanges.Range]: ...
    def toString(self) -> str: ...


class QPageSize(Shiboken.Object):

    class PageSizeId(enum.Enum):

        AnsiA                    : QPageSize.PageSizeId = ... # 0x0
        Letter                   : QPageSize.PageSizeId = ... # 0x0
        Legal                    : QPageSize.PageSizeId = ... # 0x1
        Executive                : QPageSize.PageSizeId = ... # 0x2
        A0                       : QPageSize.PageSizeId = ... # 0x3
        A1                       : QPageSize.PageSizeId = ... # 0x4
        A2                       : QPageSize.PageSizeId = ... # 0x5
        A3                       : QPageSize.PageSizeId = ... # 0x6
        A4                       : QPageSize.PageSizeId = ... # 0x7
        A5                       : QPageSize.PageSizeId = ... # 0x8
        A6                       : QPageSize.PageSizeId = ... # 0x9
        A7                       : QPageSize.PageSizeId = ... # 0xa
        A8                       : QPageSize.PageSizeId = ... # 0xb
        A9                       : QPageSize.PageSizeId = ... # 0xc
        A10                      : QPageSize.PageSizeId = ... # 0xd
        B0                       : QPageSize.PageSizeId = ... # 0xe
        B1                       : QPageSize.PageSizeId = ... # 0xf
        B2                       : QPageSize.PageSizeId = ... # 0x10
        B3                       : QPageSize.PageSizeId = ... # 0x11
        B4                       : QPageSize.PageSizeId = ... # 0x12
        B5                       : QPageSize.PageSizeId = ... # 0x13
        B6                       : QPageSize.PageSizeId = ... # 0x14
        B7                       : QPageSize.PageSizeId = ... # 0x15
        B8                       : QPageSize.PageSizeId = ... # 0x16
        B9                       : QPageSize.PageSizeId = ... # 0x17
        B10                      : QPageSize.PageSizeId = ... # 0x18
        C5E                      : QPageSize.PageSizeId = ... # 0x19
        EnvelopeC5               : QPageSize.PageSizeId = ... # 0x19
        Comm10E                  : QPageSize.PageSizeId = ... # 0x1a
        Envelope10               : QPageSize.PageSizeId = ... # 0x1a
        DLE                      : QPageSize.PageSizeId = ... # 0x1b
        EnvelopeDL               : QPageSize.PageSizeId = ... # 0x1b
        Folio                    : QPageSize.PageSizeId = ... # 0x1c
        AnsiB                    : QPageSize.PageSizeId = ... # 0x1d
        Ledger                   : QPageSize.PageSizeId = ... # 0x1d
        Tabloid                  : QPageSize.PageSizeId = ... # 0x1e
        Custom                   : QPageSize.PageSizeId = ... # 0x1f
        A3Extra                  : QPageSize.PageSizeId = ... # 0x20
        A4Extra                  : QPageSize.PageSizeId = ... # 0x21
        A4Plus                   : QPageSize.PageSizeId = ... # 0x22
        A4Small                  : QPageSize.PageSizeId = ... # 0x23
        A5Extra                  : QPageSize.PageSizeId = ... # 0x24
        B5Extra                  : QPageSize.PageSizeId = ... # 0x25
        JisB0                    : QPageSize.PageSizeId = ... # 0x26
        JisB1                    : QPageSize.PageSizeId = ... # 0x27
        JisB2                    : QPageSize.PageSizeId = ... # 0x28
        JisB3                    : QPageSize.PageSizeId = ... # 0x29
        JisB4                    : QPageSize.PageSizeId = ... # 0x2a
        JisB5                    : QPageSize.PageSizeId = ... # 0x2b
        JisB6                    : QPageSize.PageSizeId = ... # 0x2c
        JisB7                    : QPageSize.PageSizeId = ... # 0x2d
        JisB8                    : QPageSize.PageSizeId = ... # 0x2e
        JisB9                    : QPageSize.PageSizeId = ... # 0x2f
        JisB10                   : QPageSize.PageSizeId = ... # 0x30
        AnsiC                    : QPageSize.PageSizeId = ... # 0x31
        AnsiD                    : QPageSize.PageSizeId = ... # 0x32
        AnsiE                    : QPageSize.PageSizeId = ... # 0x33
        LegalExtra               : QPageSize.PageSizeId = ... # 0x34
        LetterExtra              : QPageSize.PageSizeId = ... # 0x35
        LetterPlus               : QPageSize.PageSizeId = ... # 0x36
        LetterSmall              : QPageSize.PageSizeId = ... # 0x37
        TabloidExtra             : QPageSize.PageSizeId = ... # 0x38
        ArchA                    : QPageSize.PageSizeId = ... # 0x39
        ArchB                    : QPageSize.PageSizeId = ... # 0x3a
        ArchC                    : QPageSize.PageSizeId = ... # 0x3b
        ArchD                    : QPageSize.PageSizeId = ... # 0x3c
        ArchE                    : QPageSize.PageSizeId = ... # 0x3d
        Imperial7x9              : QPageSize.PageSizeId = ... # 0x3e
        Imperial8x10             : QPageSize.PageSizeId = ... # 0x3f
        Imperial9x11             : QPageSize.PageSizeId = ... # 0x40
        Imperial9x12             : QPageSize.PageSizeId = ... # 0x41
        Imperial10x11            : QPageSize.PageSizeId = ... # 0x42
        Imperial10x13            : QPageSize.PageSizeId = ... # 0x43
        Imperial10x14            : QPageSize.PageSizeId = ... # 0x44
        Imperial12x11            : QPageSize.PageSizeId = ... # 0x45
        Imperial15x11            : QPageSize.PageSizeId = ... # 0x46
        ExecutiveStandard        : QPageSize.PageSizeId = ... # 0x47
        Note                     : QPageSize.PageSizeId = ... # 0x48
        Quarto                   : QPageSize.PageSizeId = ... # 0x49
        Statement                : QPageSize.PageSizeId = ... # 0x4a
        SuperA                   : QPageSize.PageSizeId = ... # 0x4b
        SuperB                   : QPageSize.PageSizeId = ... # 0x4c
        Postcard                 : QPageSize.PageSizeId = ... # 0x4d
        DoublePostcard           : QPageSize.PageSizeId = ... # 0x4e
        Prc16K                   : QPageSize.PageSizeId = ... # 0x4f
        Prc32K                   : QPageSize.PageSizeId = ... # 0x50
        Prc32KBig                : QPageSize.PageSizeId = ... # 0x51
        FanFoldUS                : QPageSize.PageSizeId = ... # 0x52
        FanFoldGerman            : QPageSize.PageSizeId = ... # 0x53
        FanFoldGermanLegal       : QPageSize.PageSizeId = ... # 0x54
        EnvelopeB4               : QPageSize.PageSizeId = ... # 0x55
        EnvelopeB5               : QPageSize.PageSizeId = ... # 0x56
        EnvelopeB6               : QPageSize.PageSizeId = ... # 0x57
        EnvelopeC0               : QPageSize.PageSizeId = ... # 0x58
        EnvelopeC1               : QPageSize.PageSizeId = ... # 0x59
        EnvelopeC2               : QPageSize.PageSizeId = ... # 0x5a
        EnvelopeC3               : QPageSize.PageSizeId = ... # 0x5b
        EnvelopeC4               : QPageSize.PageSizeId = ... # 0x5c
        EnvelopeC6               : QPageSize.PageSizeId = ... # 0x5d
        EnvelopeC65              : QPageSize.PageSizeId = ... # 0x5e
        EnvelopeC7               : QPageSize.PageSizeId = ... # 0x5f
        Envelope9                : QPageSize.PageSizeId = ... # 0x60
        Envelope11               : QPageSize.PageSizeId = ... # 0x61
        Envelope12               : QPageSize.PageSizeId = ... # 0x62
        Envelope14               : QPageSize.PageSizeId = ... # 0x63
        EnvelopeMonarch          : QPageSize.PageSizeId = ... # 0x64
        EnvelopePersonal         : QPageSize.PageSizeId = ... # 0x65
        EnvelopeChou3            : QPageSize.PageSizeId = ... # 0x66
        EnvelopeChou4            : QPageSize.PageSizeId = ... # 0x67
        EnvelopeInvite           : QPageSize.PageSizeId = ... # 0x68
        EnvelopeItalian          : QPageSize.PageSizeId = ... # 0x69
        EnvelopeKaku2            : QPageSize.PageSizeId = ... # 0x6a
        EnvelopeKaku3            : QPageSize.PageSizeId = ... # 0x6b
        EnvelopePrc1             : QPageSize.PageSizeId = ... # 0x6c
        EnvelopePrc2             : QPageSize.PageSizeId = ... # 0x6d
        EnvelopePrc3             : QPageSize.PageSizeId = ... # 0x6e
        EnvelopePrc4             : QPageSize.PageSizeId = ... # 0x6f
        EnvelopePrc5             : QPageSize.PageSizeId = ... # 0x70
        EnvelopePrc6             : QPageSize.PageSizeId = ... # 0x71
        EnvelopePrc7             : QPageSize.PageSizeId = ... # 0x72
        EnvelopePrc8             : QPageSize.PageSizeId = ... # 0x73
        EnvelopePrc9             : QPageSize.PageSizeId = ... # 0x74
        EnvelopePrc10            : QPageSize.PageSizeId = ... # 0x75
        EnvelopeYou4             : QPageSize.PageSizeId = ... # 0x76
        LastPageSize             : QPageSize.PageSizeId = ... # 0x76


    class SizeMatchPolicy(enum.Enum):

        FuzzyMatch               : QPageSize.SizeMatchPolicy = ... # 0x0
        FuzzyOrientationMatch    : QPageSize.SizeMatchPolicy = ... # 0x1
        ExactMatch               : QPageSize.SizeMatchPolicy = ... # 0x2


    class Unit(enum.Enum):

        Millimeter               : QPageSize.Unit = ... # 0x0
        Point                    : QPageSize.Unit = ... # 0x1
        Inch                     : QPageSize.Unit = ... # 0x2
        Pica                     : QPageSize.Unit = ... # 0x3
        Didot                    : QPageSize.Unit = ... # 0x4
        Cicero                   : QPageSize.Unit = ... # 0x5


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtGui.QPageSize, PySide6.QtGui.QPageSize.PageSizeId, PySide6.QtCore.QSize]) -> None: ...
    @overload
    def __init__(self, pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> None: ...
    @overload
    def __init__(self, pointSize: PySide6.QtCore.QSize, name: str = ..., matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> None: ...
    @overload
    def __init__(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize], units: PySide6.QtGui.QPageSize.Unit, name: str = ..., matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @overload
    @staticmethod
    def definitionSize(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> PySide6.QtCore.QSizeF: ...
    @overload
    def definitionSize(self) -> PySide6.QtCore.QSizeF: ...
    @overload
    @staticmethod
    def definitionUnits(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> PySide6.QtGui.QPageSize.Unit: ...
    @overload
    def definitionUnits(self) -> PySide6.QtGui.QPageSize.Unit: ...
    @overload
    @staticmethod
    def id(pointSize: PySide6.QtCore.QSize, matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    @overload
    def id(self) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    @overload
    @staticmethod
    def id(size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize], units: PySide6.QtGui.QPageSize.Unit, matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    @overload
    @staticmethod
    def id(windowsId: int) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    def isEquivalentTo(self, other: Union[PySide6.QtGui.QPageSize, PySide6.QtGui.QPageSize.PageSizeId, PySide6.QtCore.QSize]) -> bool: ...
    def isValid(self) -> bool: ...
    @overload
    @staticmethod
    def key(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> str: ...
    @overload
    def key(self) -> str: ...
    @overload
    @staticmethod
    def name(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> str: ...
    @overload
    def name(self) -> str: ...
    def rect(self, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QRectF: ...
    def rectPixels(self, resolution: int) -> PySide6.QtCore.QRect: ...
    def rectPoints(self) -> PySide6.QtCore.QRect: ...
    @overload
    @staticmethod
    def size(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QSizeF: ...
    @overload
    def size(self, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QSizeF: ...
    @overload
    @staticmethod
    def sizePixels(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId, resolution: int) -> PySide6.QtCore.QSize: ...
    @overload
    def sizePixels(self, resolution: int) -> PySide6.QtCore.QSize: ...
    @overload
    @staticmethod
    def sizePoints(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> PySide6.QtCore.QSize: ...
    @overload
    def sizePoints(self) -> PySide6.QtCore.QSize: ...
    def swap(self, other: Union[PySide6.QtGui.QPageSize, PySide6.QtGui.QPageSize.PageSizeId, PySide6.QtCore.QSize]) -> None: ...
    @overload
    @staticmethod
    def windowsId(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> int: ...
    @overload
    def windowsId(self) -> int: ...


class QPagedPaintDevice(PySide6.QtGui.QPaintDevice):

    class PdfVersion(enum.Enum):

        PdfVersion_1_4           : QPagedPaintDevice.PdfVersion = ... # 0x0
        PdfVersion_A1b           : QPagedPaintDevice.PdfVersion = ... # 0x1
        PdfVersion_1_6           : QPagedPaintDevice.PdfVersion = ... # 0x2


    def newPage(self) -> bool: ...
    def pageLayout(self) -> PySide6.QtGui.QPageLayout: ...
    def pageRanges(self) -> PySide6.QtGui.QPageRanges: ...
    def setPageLayout(self, pageLayout: PySide6.QtGui.QPageLayout) -> bool: ...
    def setPageMargins(self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins], units: PySide6.QtGui.QPageLayout.Unit = ...) -> bool: ...
    def setPageOrientation(self, orientation: PySide6.QtGui.QPageLayout.Orientation) -> bool: ...
    def setPageRanges(self, ranges: PySide6.QtGui.QPageRanges) -> None: ...
    def setPageSize(self, pageSize: Union[PySide6.QtGui.QPageSize, PySide6.QtGui.QPageSize.PageSizeId, PySide6.QtCore.QSize]) -> bool: ...


class QPaintDevice(Shiboken.Object):

    class PaintDeviceMetric(enum.Enum):

        PdmWidth                 : QPaintDevice.PaintDeviceMetric = ... # 0x1
        PdmHeight                : QPaintDevice.PaintDeviceMetric = ... # 0x2
        PdmWidthMM               : QPaintDevice.PaintDeviceMetric = ... # 0x3
        PdmHeightMM              : QPaintDevice.PaintDeviceMetric = ... # 0x4
        PdmNumColors             : QPaintDevice.PaintDeviceMetric = ... # 0x5
        PdmDepth                 : QPaintDevice.PaintDeviceMetric = ... # 0x6
        PdmDpiX                  : QPaintDevice.PaintDeviceMetric = ... # 0x7
        PdmDpiY                  : QPaintDevice.PaintDeviceMetric = ... # 0x8
        PdmPhysicalDpiX          : QPaintDevice.PaintDeviceMetric = ... # 0x9
        PdmPhysicalDpiY          : QPaintDevice.PaintDeviceMetric = ... # 0xa
        PdmDevicePixelRatio      : QPaintDevice.PaintDeviceMetric = ... # 0xb
        PdmDevicePixelRatioScaled: QPaintDevice.PaintDeviceMetric = ... # 0xc


    def __init__(self) -> None: ...

    def colorCount(self) -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def devicePixelRatioF(self) -> float: ...
    @staticmethod
    def devicePixelRatioFScale() -> float: ...
    def height(self) -> int: ...
    def heightMM(self) -> int: ...
    def initPainter(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def logicalDpiX(self) -> int: ...
    def logicalDpiY(self) -> int: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def paintingActive(self) -> bool: ...
    def physicalDpiX(self) -> int: ...
    def physicalDpiY(self) -> int: ...
    def redirected(self, offset: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPaintDevice: ...
    def sharedPainter(self) -> PySide6.QtGui.QPainter: ...
    def width(self) -> int: ...
    def widthMM(self) -> int: ...


class QPaintDeviceWindow(PySide6.QtGui.QWindow, PySide6.QtGui.QPaintDevice):
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    @overload
    def update(self) -> None: ...
    @overload
    def update(self, rect: PySide6.QtCore.QRect) -> None: ...
    @overload
    def update(self, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...


class QPaintEngine(Shiboken.Object):

    class DirtyFlag(enum.Flag):

        DirtyPen                 : QPaintEngine.DirtyFlag = ... # 0x1
        DirtyBrush               : QPaintEngine.DirtyFlag = ... # 0x2
        DirtyBrushOrigin         : QPaintEngine.DirtyFlag = ... # 0x4
        DirtyFont                : QPaintEngine.DirtyFlag = ... # 0x8
        DirtyBackground          : QPaintEngine.DirtyFlag = ... # 0x10
        DirtyBackgroundMode      : QPaintEngine.DirtyFlag = ... # 0x20
        DirtyTransform           : QPaintEngine.DirtyFlag = ... # 0x40
        DirtyClipRegion          : QPaintEngine.DirtyFlag = ... # 0x80
        DirtyClipPath            : QPaintEngine.DirtyFlag = ... # 0x100
        DirtyHints               : QPaintEngine.DirtyFlag = ... # 0x200
        DirtyCompositionMode     : QPaintEngine.DirtyFlag = ... # 0x400
        DirtyClipEnabled         : QPaintEngine.DirtyFlag = ... # 0x800
        DirtyOpacity             : QPaintEngine.DirtyFlag = ... # 0x1000
        AllDirty                 : QPaintEngine.DirtyFlag = ... # 0xffff


    class PaintEngineFeature(enum.Flag):

        PrimitiveTransform       : QPaintEngine.PaintEngineFeature = ... # 0x1
        PatternTransform         : QPaintEngine.PaintEngineFeature = ... # 0x2
        PixmapTransform          : QPaintEngine.PaintEngineFeature = ... # 0x4
        PatternBrush             : QPaintEngine.PaintEngineFeature = ... # 0x8
        LinearGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x10
        RadialGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x20
        ConicalGradientFill      : QPaintEngine.PaintEngineFeature = ... # 0x40
        AlphaBlend               : QPaintEngine.PaintEngineFeature = ... # 0x80
        PorterDuff               : QPaintEngine.PaintEngineFeature = ... # 0x100
        PainterPaths             : QPaintEngine.PaintEngineFeature = ... # 0x200
        Antialiasing             : QPaintEngine.PaintEngineFeature = ... # 0x400
        BrushStroke              : QPaintEngine.PaintEngineFeature = ... # 0x800
        ConstantOpacity          : QPaintEngine.PaintEngineFeature = ... # 0x1000
        MaskedBrush              : QPaintEngine.PaintEngineFeature = ... # 0x2000
        PerspectiveTransform     : QPaintEngine.PaintEngineFeature = ... # 0x4000
        BlendModes               : QPaintEngine.PaintEngineFeature = ... # 0x8000
        ObjectBoundingModeGradients: QPaintEngine.PaintEngineFeature = ... # 0x10000
        RasterOpModes            : QPaintEngine.PaintEngineFeature = ... # 0x20000
        PaintOutsidePaintEvent   : QPaintEngine.PaintEngineFeature = ... # 0x20000000
        AllFeatures              : QPaintEngine.PaintEngineFeature = ... # 0xffffffff


    class PolygonDrawMode(enum.Enum):

        OddEvenMode              : QPaintEngine.PolygonDrawMode = ... # 0x0
        WindingMode              : QPaintEngine.PolygonDrawMode = ... # 0x1
        ConvexMode               : QPaintEngine.PolygonDrawMode = ... # 0x2
        PolylineMode             : QPaintEngine.PolygonDrawMode = ... # 0x3


    class Type(enum.Enum):

        X11                      : QPaintEngine.Type = ... # 0x0
        Windows                  : QPaintEngine.Type = ... # 0x1
        QuickDraw                : QPaintEngine.Type = ... # 0x2
        CoreGraphics             : QPaintEngine.Type = ... # 0x3
        MacPrinter               : QPaintEngine.Type = ... # 0x4
        QWindowSystem            : QPaintEngine.Type = ... # 0x5
        OpenGL                   : QPaintEngine.Type = ... # 0x6
        Picture                  : QPaintEngine.Type = ... # 0x7
        SVG                      : QPaintEngine.Type = ... # 0x8
        Raster                   : QPaintEngine.Type = ... # 0x9
        Direct3D                 : QPaintEngine.Type = ... # 0xa
        Pdf                      : QPaintEngine.Type = ... # 0xb
        OpenVG                   : QPaintEngine.Type = ... # 0xc
        OpenGL2                  : QPaintEngine.Type = ... # 0xd
        PaintBuffer              : QPaintEngine.Type = ... # 0xe
        Blitter                  : QPaintEngine.Type = ... # 0xf
        Direct2D                 : QPaintEngine.Type = ... # 0x10
        User                     : QPaintEngine.Type = ... # 0x32
        MaxUser                  : QPaintEngine.Type = ... # 0x64


    def __init__(self, features: PySide6.QtGui.QPaintEngine.PaintEngineFeature = ...) -> None: ...

    def begin(self, pdev: PySide6.QtGui.QPaintDevice) -> bool: ...
    def clearDirty(self, df: PySide6.QtGui.QPaintEngine.DirtyFlag) -> None: ...
    def coordinateOffset(self) -> PySide6.QtCore.QPoint: ...
    def createPixmap(self, size: PySide6.QtCore.QSize) -> PySide6.QtGui.QPixmap: ...
    def createPixmapFromImage(self, image: Union[PySide6.QtGui.QImage, str], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def drawEllipse(self, r: PySide6.QtCore.QRect) -> None: ...
    @overload
    def drawEllipse(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def drawImage(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], pm: Union[PySide6.QtGui.QImage, str], sr: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @overload
    def drawLines(self, lines: PySide6.QtCore.QLine, lineCount: int) -> None: ...
    @overload
    def drawLines(self, lines: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine], lineCount: int) -> None: ...
    def drawPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    def drawPixmap(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sr: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawPoints(self, points: PySide6.QtCore.QPoint, pointCount: int) -> None: ...
    @overload
    def drawPoints(self, points: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], pointCount: int) -> None: ...
    @overload
    def drawPolygon(self, points: PySide6.QtCore.QPoint, pointCount: int, mode: PySide6.QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @overload
    def drawPolygon(self, points: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], pointCount: int, mode: PySide6.QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @overload
    def drawRects(self, rects: PySide6.QtCore.QRect, rectCount: int) -> None: ...
    @overload
    def drawRects(self, rects: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], rectCount: int) -> None: ...
    def drawTextItem(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], textItem: PySide6.QtGui.QTextItem) -> None: ...
    def drawTiledPixmap(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], s: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def end(self) -> bool: ...
    def hasFeature(self, feature: PySide6.QtGui.QPaintEngine.PaintEngineFeature) -> bool: ...
    def isActive(self) -> bool: ...
    def isExtended(self) -> bool: ...
    def paintDevice(self) -> PySide6.QtGui.QPaintDevice: ...
    def painter(self) -> PySide6.QtGui.QPainter: ...
    def setActive(self, newState: bool) -> None: ...
    def setDirty(self, df: PySide6.QtGui.QPaintEngine.DirtyFlag) -> None: ...
    def setSystemClip(self, baseClip: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    def setSystemRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    def syncState(self) -> None: ...
    def systemClip(self) -> PySide6.QtGui.QRegion: ...
    def systemRect(self) -> PySide6.QtCore.QRect: ...
    def testDirty(self, df: PySide6.QtGui.QPaintEngine.DirtyFlag) -> bool: ...
    def type(self) -> PySide6.QtGui.QPaintEngine.Type: ...
    def updateState(self, state: PySide6.QtGui.QPaintEngineState) -> None: ...


class QPaintEngineState(Shiboken.Object):

    def __init__(self) -> None: ...

    def backgroundBrush(self) -> PySide6.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide6.QtCore.Qt.BGMode: ...
    def brush(self) -> PySide6.QtGui.QBrush: ...
    def brushNeedsResolving(self) -> bool: ...
    def brushOrigin(self) -> PySide6.QtCore.QPointF: ...
    def clipOperation(self) -> PySide6.QtCore.Qt.ClipOperation: ...
    def clipPath(self) -> PySide6.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide6.QtGui.QRegion: ...
    def compositionMode(self) -> PySide6.QtGui.QPainter.CompositionMode: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def isClipEnabled(self) -> bool: ...
    def opacity(self) -> float: ...
    def painter(self) -> PySide6.QtGui.QPainter: ...
    def pen(self) -> PySide6.QtGui.QPen: ...
    def penNeedsResolving(self) -> bool: ...
    def renderHints(self) -> PySide6.QtGui.QPainter.RenderHint: ...
    def state(self) -> PySide6.QtGui.QPaintEngine.DirtyFlag: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...


class QPaintEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    @overload
    def __init__(self, paintRect: PySide6.QtCore.QRect) -> None: ...
    @overload
    def __init__(self, paintRegion: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...

    def clone(self) -> PySide6.QtGui.QPaintEvent: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def region(self) -> PySide6.QtGui.QRegion: ...


class QPainter(Shiboken.Object):

    class CompositionMode(enum.Enum):

        CompositionMode_SourceOver: QPainter.CompositionMode = ... # 0x0
        CompositionMode_DestinationOver: QPainter.CompositionMode = ... # 0x1
        CompositionMode_Clear    : QPainter.CompositionMode = ... # 0x2
        CompositionMode_Source   : QPainter.CompositionMode = ... # 0x3
        CompositionMode_Destination: QPainter.CompositionMode = ... # 0x4
        CompositionMode_SourceIn : QPainter.CompositionMode = ... # 0x5
        CompositionMode_DestinationIn: QPainter.CompositionMode = ... # 0x6
        CompositionMode_SourceOut: QPainter.CompositionMode = ... # 0x7
        CompositionMode_DestinationOut: QPainter.CompositionMode = ... # 0x8
        CompositionMode_SourceAtop: QPainter.CompositionMode = ... # 0x9
        CompositionMode_DestinationAtop: QPainter.CompositionMode = ... # 0xa
        CompositionMode_Xor      : QPainter.CompositionMode = ... # 0xb
        CompositionMode_Plus     : QPainter.CompositionMode = ... # 0xc
        CompositionMode_Multiply : QPainter.CompositionMode = ... # 0xd
        CompositionMode_Screen   : QPainter.CompositionMode = ... # 0xe
        CompositionMode_Overlay  : QPainter.CompositionMode = ... # 0xf
        CompositionMode_Darken   : QPainter.CompositionMode = ... # 0x10
        CompositionMode_Lighten  : QPainter.CompositionMode = ... # 0x11
        CompositionMode_ColorDodge: QPainter.CompositionMode = ... # 0x12
        CompositionMode_ColorBurn: QPainter.CompositionMode = ... # 0x13
        CompositionMode_HardLight: QPainter.CompositionMode = ... # 0x14
        CompositionMode_SoftLight: QPainter.CompositionMode = ... # 0x15
        CompositionMode_Difference: QPainter.CompositionMode = ... # 0x16
        CompositionMode_Exclusion: QPainter.CompositionMode = ... # 0x17
        RasterOp_SourceOrDestination: QPainter.CompositionMode = ... # 0x18
        RasterOp_SourceAndDestination: QPainter.CompositionMode = ... # 0x19
        RasterOp_SourceXorDestination: QPainter.CompositionMode = ... # 0x1a
        RasterOp_NotSourceAndNotDestination: QPainter.CompositionMode = ... # 0x1b
        RasterOp_NotSourceOrNotDestination: QPainter.CompositionMode = ... # 0x1c
        RasterOp_NotSourceXorDestination: QPainter.CompositionMode = ... # 0x1d
        RasterOp_NotSource       : QPainter.CompositionMode = ... # 0x1e
        RasterOp_NotSourceAndDestination: QPainter.CompositionMode = ... # 0x1f
        RasterOp_SourceAndNotDestination: QPainter.CompositionMode = ... # 0x20
        RasterOp_NotSourceOrDestination: QPainter.CompositionMode = ... # 0x21
        RasterOp_SourceOrNotDestination: QPainter.CompositionMode = ... # 0x22
        RasterOp_ClearDestination: QPainter.CompositionMode = ... # 0x23
        RasterOp_SetDestination  : QPainter.CompositionMode = ... # 0x24
        RasterOp_NotDestination  : QPainter.CompositionMode = ... # 0x25


    class PixmapFragment(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, PixmapFragment: PySide6.QtGui.QPainter.PixmapFragment) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        @staticmethod
        def create(pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], scaleX: float = ..., scaleY: float = ..., rotation: float = ..., opacity: float = ...) -> PySide6.QtGui.QPainter.PixmapFragment: ...

    class PixmapFragmentHint(enum.Flag):

        OpaqueHint               : QPainter.PixmapFragmentHint = ... # 0x1


    class RenderHint(enum.Flag):

        Antialiasing             : QPainter.RenderHint = ... # 0x1
        TextAntialiasing         : QPainter.RenderHint = ... # 0x2
        SmoothPixmapTransform    : QPainter.RenderHint = ... # 0x4
        VerticalSubpixelPositioning: QPainter.RenderHint = ... # 0x8
        LosslessImageRendering   : QPainter.RenderHint = ... # 0x40
        NonCosmeticBrushPatterns : QPainter.RenderHint = ... # 0x80


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QPaintDevice) -> None: ...

    def __enter__(self) -> PySide6.QtGui.QPainter: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide6.QtCore.Qt.BGMode: ...
    def begin(self, arg__1: PySide6.QtGui.QPaintDevice) -> bool: ...
    def beginNativePainting(self) -> None: ...
    @overload
    def boundingRect(self, rect: PySide6.QtCore.QRect, flags: int, text: str) -> PySide6.QtCore.QRect: ...
    @overload
    def boundingRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], flags: int, text: str) -> PySide6.QtCore.QRectF: ...
    @overload
    def boundingRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], text: str, o: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag] = ...) -> PySide6.QtCore.QRectF: ...
    @overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str) -> PySide6.QtCore.QRect: ...
    def brush(self) -> PySide6.QtGui.QBrush: ...
    def brushOrigin(self) -> PySide6.QtCore.QPoint: ...
    def clipBoundingRect(self) -> PySide6.QtCore.QRectF: ...
    def clipPath(self) -> PySide6.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide6.QtGui.QRegion: ...
    def combinedTransform(self) -> PySide6.QtGui.QTransform: ...
    def compositionMode(self) -> PySide6.QtGui.QPainter.CompositionMode: ...
    def device(self) -> PySide6.QtGui.QPaintDevice: ...
    def deviceTransform(self) -> PySide6.QtGui.QTransform: ...
    @overload
    def drawArc(self, arg__1: PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawArc(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], a: int, alen: int) -> None: ...
    @overload
    def drawArc(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, arg__1: PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawConvexPolygon(self, arg__1: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @overload
    def drawConvexPolygon(self, arg__1: Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @overload
    def drawConvexPolygon(self, polygon: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawConvexPolygon(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> None: ...
    @overload
    def drawEllipse(self, center: PySide6.QtCore.QPoint, rx: int, ry: int) -> None: ...
    @overload
    def drawEllipse(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], rx: float, ry: float) -> None: ...
    @overload
    def drawEllipse(self, r: PySide6.QtCore.QRect) -> None: ...
    @overload
    def drawEllipse(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawEllipse(self, x: int, y: int, w: int, h: int) -> None: ...
    def drawGlyphRun(self, position: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], glyphRun: PySide6.QtGui.QGlyphRun) -> None: ...
    @overload
    def drawImage(self, p: PySide6.QtCore.QPoint, image: Union[PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawImage(self, p: PySide6.QtCore.QPoint, image: Union[PySide6.QtGui.QImage, str], sr: PySide6.QtCore.QRect, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @overload
    def drawImage(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], image: Union[PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawImage(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], image: Union[PySide6.QtGui.QImage, str], sr: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @overload
    def drawImage(self, r: PySide6.QtCore.QRect, image: Union[PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawImage(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], image: Union[PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawImage(self, targetRect: PySide6.QtCore.QRect, image: Union[PySide6.QtGui.QImage, str], sourceRect: PySide6.QtCore.QRect, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @overload
    def drawImage(self, targetRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], image: Union[PySide6.QtGui.QImage, str], sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @overload
    def drawImage(self, x: int, y: int, image: Union[PySide6.QtGui.QImage, str], sx: int = ..., sy: int = ..., sw: int = ..., sh: int = ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @overload
    def drawLine(self, line: PySide6.QtCore.QLine) -> None: ...
    @overload
    def drawLine(self, line: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine]) -> None: ...
    @overload
    def drawLine(self, p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def drawLine(self, p1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], p2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def drawLine(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    @overload
    def drawLines(self, lines: Sequence[PySide6.QtCore.QLineF]) -> None: ...
    @overload
    def drawLines(self, lines: Sequence[PySide6.QtCore.QLine]) -> None: ...
    @overload
    def drawLines(self, lines: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine], lineCount: int) -> None: ...
    @overload
    def drawLines(self, pointPairs: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @overload
    def drawLines(self, pointPairs: Sequence[PySide6.QtCore.QPoint]) -> None: ...
    def drawPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    @overload
    def drawPicture(self, p: PySide6.QtCore.QPoint, picture: Union[PySide6.QtGui.QPicture, int]) -> None: ...
    @overload
    def drawPicture(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], picture: Union[PySide6.QtGui.QPicture, int]) -> None: ...
    @overload
    def drawPicture(self, x: int, y: int, picture: Union[PySide6.QtGui.QPicture, int]) -> None: ...
    @overload
    def drawPie(self, arg__1: PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawPie(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], a: int, alen: int) -> None: ...
    @overload
    def drawPie(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawPixmap(self, p: PySide6.QtCore.QPoint, pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawPixmap(self, p: PySide6.QtCore.QPoint, pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sr: PySide6.QtCore.QRect) -> None: ...
    @overload
    def drawPixmap(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawPixmap(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sr: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawPixmap(self, r: PySide6.QtCore.QRect, pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawPixmap(self, targetRect: PySide6.QtCore.QRect, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sourceRect: PySide6.QtCore.QRect) -> None: ...
    @overload
    def drawPixmap(self, targetRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sx: int, sy: int, sw: int, sh: int) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sx: int, sy: int, sw: int, sh: int) -> None: ...
    def drawPixmapFragments(self, fragments: PySide6.QtGui.QPainter.PixmapFragment, fragmentCount: int, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], hints: PySide6.QtGui.QPainter.PixmapFragmentHint = ...) -> None: ...
    @overload
    def drawPoint(self, p: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def drawPoint(self, pt: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def drawPoint(self, x: int, y: int) -> None: ...
    @overload
    def drawPoints(self, arg__1: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @overload
    def drawPoints(self, arg__1: Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @overload
    def drawPoints(self, points: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], pointCount: int) -> None: ...
    @overload
    def drawPoints(self, points: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawPoints(self, points: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> None: ...
    def drawPointsNp(self, x: shibokensupport.signature.mapping.ArrayLikeVariable, y: shibokensupport.signature.mapping.ArrayLikeVariable) -> None: ...
    @overload
    def drawPolygon(self, arg__1: Sequence[PySide6.QtCore.QPointF], arg__2: PySide6.QtCore.Qt.FillRule) -> None: ...
    @overload
    def drawPolygon(self, arg__1: Sequence[PySide6.QtCore.QPoint], arg__2: PySide6.QtCore.Qt.FillRule) -> None: ...
    @overload
    def drawPolygon(self, polygon: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect], fillRule: PySide6.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def drawPolygon(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], fillRule: PySide6.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def drawPolyline(self, arg__1: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @overload
    def drawPolyline(self, arg__1: Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @overload
    def drawPolyline(self, polygon: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawPolyline(self, polyline: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> None: ...
    @overload
    def drawRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    @overload
    def drawRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawRect(self, x1: int, y1: int, w: int, h: int) -> None: ...
    @overload
    def drawRects(self, rectangles: Sequence[PySide6.QtCore.QRectF]) -> None: ...
    @overload
    def drawRects(self, rectangles: Sequence[PySide6.QtCore.QRect]) -> None: ...
    @overload
    def drawRects(self, rects: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], rectCount: int) -> None: ...
    @overload
    def drawRoundedRect(self, rect: PySide6.QtCore.QRect, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def drawRoundedRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def drawRoundedRect(self, x: int, y: int, w: int, h: int, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def drawStaticText(self, left: int, top: int, staticText: PySide6.QtGui.QStaticText) -> None: ...
    @overload
    def drawStaticText(self, topLeftPosition: PySide6.QtCore.QPoint, staticText: PySide6.QtGui.QStaticText) -> None: ...
    @overload
    def drawStaticText(self, topLeftPosition: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], staticText: PySide6.QtGui.QStaticText) -> None: ...
    @overload
    def drawText(self, p: PySide6.QtCore.QPoint, s: str) -> None: ...
    @overload
    def drawText(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], s: str) -> None: ...
    @overload
    def drawText(self, r: PySide6.QtCore.QRect, flags: int, text: str) -> PySide6.QtCore.QRect: ...
    @overload
    def drawText(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], flags: int, text: str) -> PySide6.QtCore.QRectF: ...
    @overload
    def drawText(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], text: str, o: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @overload
    def drawText(self, x: int, y: int, s: str) -> None: ...
    @overload
    def drawText(self, x: int, y: int, w: int, h: int, flags: int, text: str) -> None: ...
    @overload
    def drawTextItem(self, p: PySide6.QtCore.QPoint, ti: PySide6.QtGui.QTextItem) -> None: ...
    @overload
    def drawTextItem(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], ti: PySide6.QtGui.QTextItem) -> None: ...
    @overload
    def drawTextItem(self, x: int, y: int, ti: PySide6.QtGui.QTextItem) -> None: ...
    @overload
    def drawTiledPixmap(self, arg__1: PySide6.QtCore.QRect, arg__2: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], pos: PySide6.QtCore.QPoint = ...) -> None: ...
    @overload
    def drawTiledPixmap(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], pm: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], offset: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element] = ...) -> None: ...
    @overload
    def drawTiledPixmap(self, x: int, y: int, w: int, h: int, arg__5: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], sx: int = ..., sy: int = ...) -> None: ...
    def end(self) -> bool: ...
    def endNativePainting(self) -> None: ...
    @overload
    def eraseRect(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    @overload
    def eraseRect(self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def eraseRect(self, x: int, y: int, w: int, h: int) -> None: ...
    def fillPath(self, path: PySide6.QtGui.QPainterPath, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def fillRect(self, arg__1: PySide6.QtCore.QRect, arg__2: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def fillRect(self, arg__1: PySide6.QtCore.QRect, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def fillRect(self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], arg__2: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def fillRect(self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def fillRect(self, r: PySide6.QtCore.QRect, c: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fillRect(self, r: PySide6.QtCore.QRect, preset: PySide6.QtGui.QGradient.Preset) -> None: ...
    @overload
    def fillRect(self, r: PySide6.QtCore.QRect, style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def fillRect(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], c: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fillRect(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], preset: PySide6.QtGui.QGradient.Preset) -> None: ...
    @overload
    def fillRect(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, arg__5: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, c: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, preset: PySide6.QtGui.QGradient.Preset) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def fontInfo(self) -> PySide6.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide6.QtGui.QFontMetrics: ...
    def hasClipping(self) -> bool: ...
    def isActive(self) -> bool: ...
    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def opacity(self) -> float: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def pen(self) -> PySide6.QtGui.QPen: ...
    def renderHints(self) -> PySide6.QtGui.QPainter.RenderHint: ...
    def resetTransform(self) -> None: ...
    def restore(self) -> None: ...
    def rotate(self, a: float) -> None: ...
    def save(self) -> None: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def setBackground(self, bg: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setBackgroundMode(self, mode: PySide6.QtCore.Qt.BGMode) -> None: ...
    @overload
    def setBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def setBrush(self, style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def setBrushOrigin(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def setBrushOrigin(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setBrushOrigin(self, x: int, y: int) -> None: ...
    def setClipPath(self, path: PySide6.QtGui.QPainterPath, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    @overload
    def setClipRect(self, arg__1: PySide6.QtCore.QRect, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    @overload
    def setClipRect(self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    @overload
    def setClipRect(self, x: int, y: int, w: int, h: int, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    def setClipRegion(self, arg__1: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect], op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    def setClipping(self, enable: bool) -> None: ...
    def setCompositionMode(self, mode: PySide6.QtGui.QPainter.CompositionMode) -> None: ...
    def setFont(self, f: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    @overload
    def setPen(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def setPen(self, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def setPen(self, style: PySide6.QtCore.Qt.PenStyle) -> None: ...
    def setRenderHint(self, hint: PySide6.QtGui.QPainter.RenderHint, on: bool = ...) -> None: ...
    def setRenderHints(self, hints: PySide6.QtGui.QPainter.RenderHint, on: bool = ...) -> None: ...
    def setTransform(self, transform: PySide6.QtGui.QTransform, combine: bool = ...) -> None: ...
    def setViewTransformEnabled(self, enable: bool) -> None: ...
    @overload
    def setViewport(self, viewport: PySide6.QtCore.QRect) -> None: ...
    @overload
    def setViewport(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def setWindow(self, window: PySide6.QtCore.QRect) -> None: ...
    @overload
    def setWindow(self, x: int, y: int, w: int, h: int) -> None: ...
    def setWorldMatrixEnabled(self, enabled: bool) -> None: ...
    def setWorldTransform(self, matrix: PySide6.QtGui.QTransform, combine: bool = ...) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def strokePath(self, path: PySide6.QtGui.QPainterPath, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...
    def testRenderHint(self, hint: PySide6.QtGui.QPainter.RenderHint) -> bool: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def translate(self, offset: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def viewTransformEnabled(self) -> bool: ...
    def viewport(self) -> PySide6.QtCore.QRect: ...
    def window(self) -> PySide6.QtCore.QRect: ...
    def worldMatrixEnabled(self) -> bool: ...
    def worldTransform(self) -> PySide6.QtGui.QTransform: ...


class QPainterPath(Shiboken.Object):

    class Element(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, Element: PySide6.QtGui.QPainterPath.Element) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isCurveTo(self) -> bool: ...
        def isLineTo(self) -> bool: ...
        def isMoveTo(self) -> bool: ...

    class ElementType(enum.Enum):

        MoveToElement            : QPainterPath.ElementType = ... # 0x0
        LineToElement            : QPainterPath.ElementType = ... # 0x1
        CurveToElement           : QPainterPath.ElementType = ... # 0x2
        CurveToDataElement       : QPainterPath.ElementType = ... # 0x3


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QPainterPath) -> None: ...
    @overload
    def __init__(self, startPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...

    def __add__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __and__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __iand__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __ior__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __isub__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPainterPath: ...
    def __or__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def addEllipse(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], rx: float, ry: float) -> None: ...
    @overload
    def addEllipse(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def addEllipse(self, x: float, y: float, w: float, h: float) -> None: ...
    def addPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    def addPolygon(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> None: ...
    @overload
    def addRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def addRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def addRegion(self, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def addRoundedRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def addRoundedRect(self, x: float, y: float, w: float, h: float, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def addText(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], f: Union[PySide6.QtGui.QFont, str, Sequence[str]], text: str) -> None: ...
    @overload
    def addText(self, x: float, y: float, f: Union[PySide6.QtGui.QFont, str, Sequence[str]], text: str) -> None: ...
    def angleAtPercent(self, t: float) -> float: ...
    @overload
    def arcMoveTo(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], angle: float) -> None: ...
    @overload
    def arcMoveTo(self, x: float, y: float, w: float, h: float, angle: float) -> None: ...
    @overload
    def arcTo(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], startAngle: float, arcLength: float) -> None: ...
    @overload
    def arcTo(self, x: float, y: float, w: float, h: float, startAngle: float, arcLength: float) -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def closeSubpath(self) -> None: ...
    def connectPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    @overload
    def contains(self, p: PySide6.QtGui.QPainterPath) -> bool: ...
    @overload
    def contains(self, pt: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    @overload
    def contains(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> bool: ...
    def controlPointRect(self) -> PySide6.QtCore.QRectF: ...
    @overload
    def cubicTo(self, ctrlPt1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], ctrlPt2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], endPt: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def cubicTo(self, ctrlPt1x: float, ctrlPt1y: float, ctrlPt2x: float, ctrlPt2y: float, endPtx: float, endPty: float) -> None: ...
    def currentPosition(self) -> PySide6.QtCore.QPointF: ...
    def elementAt(self, i: int) -> PySide6.QtGui.QPainterPath.Element: ...
    def elementCount(self) -> int: ...
    def fillRule(self) -> PySide6.QtCore.Qt.FillRule: ...
    def intersected(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def intersects(self, p: PySide6.QtGui.QPainterPath) -> bool: ...
    @overload
    def intersects(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def length(self) -> float: ...
    @overload
    def lineTo(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def lineTo(self, x: float, y: float) -> None: ...
    @overload
    def moveTo(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def moveTo(self, x: float, y: float) -> None: ...
    def percentAtLength(self, t: float) -> float: ...
    def pointAtPercent(self, t: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def quadTo(self, ctrlPt: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], endPt: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def quadTo(self, ctrlPtx: float, ctrlPty: float, endPtx: float, endPty: float) -> None: ...
    def reserve(self, size: int) -> None: ...
    def setElementPositionAt(self, i: int, x: float, y: float) -> None: ...
    def setFillRule(self, fillRule: PySide6.QtCore.Qt.FillRule) -> None: ...
    def simplified(self) -> PySide6.QtGui.QPainterPath: ...
    def slopeAtPercent(self, t: float) -> float: ...
    def subtracted(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def swap(self, other: PySide6.QtGui.QPainterPath) -> None: ...
    def toFillPolygon(self, matrix: PySide6.QtGui.QTransform = ...) -> PySide6.QtGui.QPolygonF: ...
    def toFillPolygons(self, matrix: PySide6.QtGui.QTransform = ...) -> List[PySide6.QtGui.QPolygonF]: ...
    def toReversed(self) -> PySide6.QtGui.QPainterPath: ...
    def toSubpathPolygons(self, matrix: PySide6.QtGui.QTransform = ...) -> List[PySide6.QtGui.QPolygonF]: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def translated(self, dx: float, dy: float) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def translated(self, offset: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtGui.QPainterPath: ...
    def united(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...


class QPainterPathStroker(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...

    def capStyle(self) -> PySide6.QtCore.Qt.PenCapStyle: ...
    def createStroke(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def curveThreshold(self) -> float: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> List[float]: ...
    def joinStyle(self) -> PySide6.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setCapStyle(self, style: PySide6.QtCore.Qt.PenCapStyle) -> None: ...
    def setCurveThreshold(self, threshold: float) -> None: ...
    def setDashOffset(self, offset: float) -> None: ...
    @overload
    def setDashPattern(self, arg__1: PySide6.QtCore.Qt.PenStyle) -> None: ...
    @overload
    def setDashPattern(self, dashPattern: Sequence[float]) -> None: ...
    def setJoinStyle(self, style: PySide6.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, length: float) -> None: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...


class QPalette(Shiboken.Object):

    class ColorGroup(enum.Enum):

        Active                   : QPalette.ColorGroup = ... # 0x0
        Normal                   : QPalette.ColorGroup = ... # 0x0
        Disabled                 : QPalette.ColorGroup = ... # 0x1
        Inactive                 : QPalette.ColorGroup = ... # 0x2
        NColorGroups             : QPalette.ColorGroup = ... # 0x3
        Current                  : QPalette.ColorGroup = ... # 0x4
        All                      : QPalette.ColorGroup = ... # 0x5


    class ColorRole(enum.Enum):

        WindowText               : QPalette.ColorRole = ... # 0x0
        Button                   : QPalette.ColorRole = ... # 0x1
        Light                    : QPalette.ColorRole = ... # 0x2
        Midlight                 : QPalette.ColorRole = ... # 0x3
        Dark                     : QPalette.ColorRole = ... # 0x4
        Mid                      : QPalette.ColorRole = ... # 0x5
        Text                     : QPalette.ColorRole = ... # 0x6
        BrightText               : QPalette.ColorRole = ... # 0x7
        ButtonText               : QPalette.ColorRole = ... # 0x8
        Base                     : QPalette.ColorRole = ... # 0x9
        Window                   : QPalette.ColorRole = ... # 0xa
        Shadow                   : QPalette.ColorRole = ... # 0xb
        Highlight                : QPalette.ColorRole = ... # 0xc
        HighlightedText          : QPalette.ColorRole = ... # 0xd
        Link                     : QPalette.ColorRole = ... # 0xe
        LinkVisited              : QPalette.ColorRole = ... # 0xf
        AlternateBase            : QPalette.ColorRole = ... # 0x10
        NoRole                   : QPalette.ColorRole = ... # 0x11
        ToolTipBase              : QPalette.ColorRole = ... # 0x12
        ToolTipText              : QPalette.ColorRole = ... # 0x13
        PlaceholderText          : QPalette.ColorRole = ... # 0x14
        NColorRoles              : QPalette.ColorRole = ... # 0x15


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, button: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def __init__(self, button: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def __init__(self, button: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], window: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def __init__(self, palette: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def __init__(self, windowText: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], button: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], light: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], dark: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], mid: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], text: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], bright_text: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], base: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], window: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def __init__(self, windowText: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], window: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], light: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], dark: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], mid: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], text: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], base: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, ds: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, ds: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def alternateBase(self) -> PySide6.QtGui.QBrush: ...
    def base(self) -> PySide6.QtGui.QBrush: ...
    def brightText(self) -> PySide6.QtGui.QBrush: ...
    @overload
    def brush(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QBrush: ...
    @overload
    def brush(self, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QBrush: ...
    def button(self) -> PySide6.QtGui.QBrush: ...
    def buttonText(self) -> PySide6.QtGui.QBrush: ...
    def cacheKey(self) -> int: ...
    @overload
    def color(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QColor: ...
    @overload
    def color(self, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QColor: ...
    def currentColorGroup(self) -> PySide6.QtGui.QPalette.ColorGroup: ...
    def dark(self) -> PySide6.QtGui.QBrush: ...
    def highlight(self) -> PySide6.QtGui.QBrush: ...
    def highlightedText(self) -> PySide6.QtGui.QBrush: ...
    def isBrushSet(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole) -> bool: ...
    def isCopyOf(self, p: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> bool: ...
    def isEqual(self, cr1: PySide6.QtGui.QPalette.ColorGroup, cr2: PySide6.QtGui.QPalette.ColorGroup) -> bool: ...
    def light(self) -> PySide6.QtGui.QBrush: ...
    def link(self) -> PySide6.QtGui.QBrush: ...
    def linkVisited(self) -> PySide6.QtGui.QBrush: ...
    def mid(self) -> PySide6.QtGui.QBrush: ...
    def midlight(self) -> PySide6.QtGui.QBrush: ...
    def placeholderText(self) -> PySide6.QtGui.QBrush: ...
    def resolve(self, other: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> PySide6.QtGui.QPalette: ...
    def resolveMask(self) -> int: ...
    @overload
    def setBrush(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def setBrush(self, cr: PySide6.QtGui.QPalette.ColorRole, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    @overload
    def setColor(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def setColor(self, cr: PySide6.QtGui.QPalette.ColorRole, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setColorGroup(self, cr: PySide6.QtGui.QPalette.ColorGroup, windowText: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], button: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], light: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], dark: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], mid: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], text: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], bright_text: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], base: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], window: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setCurrentColorGroup(self, cg: PySide6.QtGui.QPalette.ColorGroup) -> None: ...
    def setResolveMask(self, mask: int) -> None: ...
    def shadow(self) -> PySide6.QtGui.QBrush: ...
    def swap(self, other: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    def text(self) -> PySide6.QtGui.QBrush: ...
    def toolTipBase(self) -> PySide6.QtGui.QBrush: ...
    def toolTipText(self) -> PySide6.QtGui.QBrush: ...
    def window(self) -> PySide6.QtGui.QBrush: ...
    def windowText(self) -> PySide6.QtGui.QBrush: ...


class QPdfWriter(PySide6.QtCore.QObject, PySide6.QtGui.QPagedPaintDevice):

    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice) -> None: ...
    @overload
    def __init__(self, filename: str) -> None: ...

    def addFileAttachment(self, fileName: str, data: Union[PySide6.QtCore.QByteArray, bytes], mimeType: str = ...) -> None: ...
    def creator(self) -> str: ...
    def documentXmpMetadata(self) -> PySide6.QtCore.QByteArray: ...
    def metric(self, id: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def pdfVersion(self) -> PySide6.QtGui.QPagedPaintDevice.PdfVersion: ...
    def resolution(self) -> int: ...
    def setCreator(self, creator: str) -> None: ...
    def setDocumentXmpMetadata(self, xmpMetadata: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    def setPdfVersion(self, version: PySide6.QtGui.QPagedPaintDevice.PdfVersion) -> None: ...
    def setResolution(self, resolution: int) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...


class QPen(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtCore.Qt.PenStyle) -> None: ...
    @overload
    def __init__(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap], width: float, s: PySide6.QtCore.Qt.PenStyle = ..., c: PySide6.QtCore.Qt.PenCapStyle = ..., j: PySide6.QtCore.Qt.PenJoinStyle = ...) -> None: ...
    @overload
    def __init__(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def __init__(self, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def brush(self) -> PySide6.QtGui.QBrush: ...
    def capStyle(self) -> PySide6.QtCore.Qt.PenCapStyle: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> List[float]: ...
    def isCosmetic(self) -> bool: ...
    def isSolid(self) -> bool: ...
    def joinStyle(self) -> PySide6.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setCapStyle(self, pcs: PySide6.QtCore.Qt.PenCapStyle) -> None: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setCosmetic(self, cosmetic: bool) -> None: ...
    def setDashOffset(self, doffset: float) -> None: ...
    def setDashPattern(self, pattern: Sequence[float]) -> None: ...
    def setJoinStyle(self, pcs: PySide6.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, limit: float) -> None: ...
    def setStyle(self, arg__1: PySide6.QtCore.Qt.PenStyle) -> None: ...
    def setWidth(self, width: int) -> None: ...
    def setWidthF(self, width: float) -> None: ...
    def style(self) -> PySide6.QtCore.Qt.PenStyle: ...
    def swap(self, other: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...
    def width(self) -> int: ...
    def widthF(self) -> float: ...


class QPicture(PySide6.QtGui.QPaintDevice):

    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QPicture, int]) -> None: ...
    @overload
    def __init__(self, formatVersion: int = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def boundingRect(self) -> PySide6.QtCore.QRect: ...
    def data(self) -> object: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...
    @overload
    def load(self, dev: PySide6.QtCore.QIODevice) -> bool: ...
    @overload
    def load(self, fileName: str) -> bool: ...
    def metric(self, m: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def play(self, p: PySide6.QtGui.QPainter) -> bool: ...
    @overload
    def save(self, dev: PySide6.QtCore.QIODevice) -> bool: ...
    @overload
    def save(self, fileName: str) -> bool: ...
    def setBoundingRect(self, r: PySide6.QtCore.QRect) -> None: ...
    def setData(self, data: bytes) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: Union[PySide6.QtGui.QPicture, int]) -> None: ...


class QPixelFormat(Shiboken.Object):

    class AlphaPosition(enum.Enum):

        AtBeginning              : QPixelFormat.AlphaPosition = ... # 0x0
        AtEnd                    : QPixelFormat.AlphaPosition = ... # 0x1


    class AlphaPremultiplied(enum.Enum):

        NotPremultiplied         : QPixelFormat.AlphaPremultiplied = ... # 0x0
        Premultiplied            : QPixelFormat.AlphaPremultiplied = ... # 0x1


    class AlphaUsage(enum.Enum):

        UsesAlpha                : QPixelFormat.AlphaUsage = ... # 0x0
        IgnoresAlpha             : QPixelFormat.AlphaUsage = ... # 0x1


    class ByteOrder(enum.Enum):

        LittleEndian             : QPixelFormat.ByteOrder = ... # 0x0
        BigEndian                : QPixelFormat.ByteOrder = ... # 0x1
        CurrentSystemEndian      : QPixelFormat.ByteOrder = ... # 0x2


    class ColorModel(enum.Enum):

        RGB                      : QPixelFormat.ColorModel = ... # 0x0
        BGR                      : QPixelFormat.ColorModel = ... # 0x1
        Indexed                  : QPixelFormat.ColorModel = ... # 0x2
        Grayscale                : QPixelFormat.ColorModel = ... # 0x3
        CMYK                     : QPixelFormat.ColorModel = ... # 0x4
        HSL                      : QPixelFormat.ColorModel = ... # 0x5
        HSV                      : QPixelFormat.ColorModel = ... # 0x6
        YUV                      : QPixelFormat.ColorModel = ... # 0x7
        Alpha                    : QPixelFormat.ColorModel = ... # 0x8


    class TypeInterpretation(enum.Enum):

        UnsignedInteger          : QPixelFormat.TypeInterpretation = ... # 0x0
        UnsignedShort            : QPixelFormat.TypeInterpretation = ... # 0x1
        UnsignedByte             : QPixelFormat.TypeInterpretation = ... # 0x2
        FloatingPoint            : QPixelFormat.TypeInterpretation = ... # 0x3


    class YUVLayout(enum.Enum):

        YUV444                   : QPixelFormat.YUVLayout = ... # 0x0
        YUV422                   : QPixelFormat.YUVLayout = ... # 0x1
        YUV411                   : QPixelFormat.YUVLayout = ... # 0x2
        YUV420P                  : QPixelFormat.YUVLayout = ... # 0x3
        YUV420SP                 : QPixelFormat.YUVLayout = ... # 0x4
        YV12                     : QPixelFormat.YUVLayout = ... # 0x5
        UYVY                     : QPixelFormat.YUVLayout = ... # 0x6
        YUYV                     : QPixelFormat.YUVLayout = ... # 0x7
        NV12                     : QPixelFormat.YUVLayout = ... # 0x8
        NV21                     : QPixelFormat.YUVLayout = ... # 0x9
        IMC1                     : QPixelFormat.YUVLayout = ... # 0xa
        IMC2                     : QPixelFormat.YUVLayout = ... # 0xb
        IMC3                     : QPixelFormat.YUVLayout = ... # 0xc
        IMC4                     : QPixelFormat.YUVLayout = ... # 0xd
        Y8                       : QPixelFormat.YUVLayout = ... # 0xe
        Y16                      : QPixelFormat.YUVLayout = ... # 0xf


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QPixelFormat: PySide6.QtGui.QPixelFormat) -> None: ...
    @overload
    def __init__(self, colorModel: PySide6.QtGui.QPixelFormat.ColorModel, firstSize: int, secondSize: int, thirdSize: int, fourthSize: int, fifthSize: int, alphaSize: int, alphaUsage: PySide6.QtGui.QPixelFormat.AlphaUsage, alphaPosition: PySide6.QtGui.QPixelFormat.AlphaPosition, premultiplied: PySide6.QtGui.QPixelFormat.AlphaPremultiplied, typeInterpretation: PySide6.QtGui.QPixelFormat.TypeInterpretation, byteOrder: PySide6.QtGui.QPixelFormat.ByteOrder = ..., subEnum: int = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alphaPosition(self) -> PySide6.QtGui.QPixelFormat.AlphaPosition: ...
    def alphaSize(self) -> int: ...
    def alphaUsage(self) -> PySide6.QtGui.QPixelFormat.AlphaUsage: ...
    def bitsPerPixel(self) -> int: ...
    def blackSize(self) -> int: ...
    def blueSize(self) -> int: ...
    def brightnessSize(self) -> int: ...
    def byteOrder(self) -> PySide6.QtGui.QPixelFormat.ByteOrder: ...
    def channelCount(self) -> int: ...
    def colorModel(self) -> PySide6.QtGui.QPixelFormat.ColorModel: ...
    def cyanSize(self) -> int: ...
    def greenSize(self) -> int: ...
    def hueSize(self) -> int: ...
    def lightnessSize(self) -> int: ...
    def magentaSize(self) -> int: ...
    def premultiplied(self) -> PySide6.QtGui.QPixelFormat.AlphaPremultiplied: ...
    def redSize(self) -> int: ...
    def saturationSize(self) -> int: ...
    def subEnum(self) -> int: ...
    def typeInterpretation(self) -> PySide6.QtGui.QPixelFormat.TypeInterpretation: ...
    def yellowSize(self) -> int: ...
    def yuvLayout(self) -> PySide6.QtGui.QPixelFormat.YUVLayout: ...


class QPixmap(PySide6.QtGui.QPaintDevice):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def __init__(self, fileName: Union[str, bytes, os.PathLike], format: Optional[bytes] = ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @overload
    def __init__(self, image: Union[PySide6.QtGui.QImage, str]) -> None: ...
    @overload
    def __init__(self, w: int, h: int) -> None: ...
    @overload
    def __init__(self, xpm: Iterable) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def cacheKey(self) -> int: ...
    def convertFromImage(self, img: Union[PySide6.QtGui.QImage, str], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    @overload
    def copy(self, rect: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def copy(self, x: int, y: int, width: int, height: int) -> PySide6.QtGui.QPixmap: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> PySide6.QtGui.QBitmap: ...
    def createMaskFromColor(self, maskColor: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int], mode: PySide6.QtCore.Qt.MaskMode = ...) -> PySide6.QtGui.QBitmap: ...
    @staticmethod
    def defaultDepth() -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def deviceIndependentSize(self) -> PySide6.QtCore.QSizeF: ...
    def devicePixelRatio(self) -> float: ...
    def fill(self, fillColor: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int] = ...) -> None: ...
    @staticmethod
    def fromImage(image: Union[PySide6.QtGui.QImage, str], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def fromImageInPlace(image: Union[PySide6.QtGui.QImage, str], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def fromImageReader(imageReader: PySide6.QtGui.QImageReader, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    def hasAlpha(self) -> bool: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def isNull(self) -> bool: ...
    def isQBitmap(self) -> bool: ...
    def load(self, fileName: str, format: Optional[bytes] = ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    @overload
    def loadFromData(self, buf: bytes, format: Optional[bytes] = ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    @overload
    def loadFromData(self, data: Union[PySide6.QtCore.QByteArray, bytes], format: Optional[bytes] = ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    def mask(self) -> PySide6.QtGui.QBitmap: ...
    def metric(self, arg__1: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    @overload
    def save(self, device: PySide6.QtCore.QIODevice, format: Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def save(self, fileName: str, format: Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def scaled(self, s: PySide6.QtCore.QSize, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def scaled(self, w: int, h: int, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    def scaledToHeight(self, h: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    def scaledToWidth(self, w: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    @overload
    def scroll(self, dx: int, dy: int, rect: PySide6.QtCore.QRect, exposed: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect, NoneType] = ...) -> None: ...
    @overload
    def scroll(self, dx: int, dy: int, x: int, y: int, width: int, height: int, exposed: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect, NoneType] = ...) -> None: ...
    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def setMask(self, arg__1: Union[PySide6.QtGui.QBitmap, str]) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def swap(self, other: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def toImage(self) -> PySide6.QtGui.QImage: ...
    def transformed(self, arg__1: PySide6.QtGui.QTransform, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def trueMatrix(m: PySide6.QtGui.QTransform, w: int, h: int) -> PySide6.QtGui.QTransform: ...
    def width(self) -> int: ...


class QPixmapCache(Shiboken.Object):

    class Key(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, other: PySide6.QtGui.QPixmapCache.Key) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isValid(self) -> bool: ...
        def swap(self, other: PySide6.QtGui.QPixmapCache.Key) -> None: ...


    def __init__(self) -> None: ...

    @staticmethod
    def cacheLimit() -> int: ...
    @staticmethod
    def clear() -> None: ...
    @overload
    @staticmethod
    def find(key: PySide6.QtGui.QPixmapCache.Key, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> bool: ...
    @overload
    @staticmethod
    def find(key: str, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> bool: ...
    @overload
    def find(self, arg__1: PySide6.QtGui.QPixmapCache.Key) -> None: ...
    @overload
    def find(self, arg__1: str) -> None: ...
    @overload
    @staticmethod
    def insert(key: str, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> bool: ...
    @overload
    @staticmethod
    def insert(pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> PySide6.QtGui.QPixmapCache.Key: ...
    @overload
    @staticmethod
    def remove(key: PySide6.QtGui.QPixmapCache.Key) -> None: ...
    @overload
    @staticmethod
    def remove(key: str) -> None: ...
    @staticmethod
    def replace(key: PySide6.QtGui.QPixmapCache.Key, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> bool: ...
    @staticmethod
    def setCacheLimit(arg__1: int) -> None: ...


class QPlatformSurfaceEvent(PySide6.QtCore.QEvent):

    class SurfaceEventType(enum.Enum):

        SurfaceCreated           : QPlatformSurfaceEvent.SurfaceEventType = ... # 0x0
        SurfaceAboutToBeDestroyed: QPlatformSurfaceEvent.SurfaceEventType = ... # 0x1


    def __init__(self, arg__1: PySide6.QtGui.QPlatformSurfaceEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QPlatformSurfaceEvent: ...
    def surfaceEventType(self) -> PySide6.QtGui.QPlatformSurfaceEvent.SurfaceEventType: ...


class QPointFList(object): ...


class QPointList(object): ...


class QPointerEvent(PySide6.QtGui.QInputEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QPointerEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, dev: PySide6.QtGui.QPointingDevice, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., points: Sequence[PySide6.QtGui.QEventPoint] = ...) -> None: ...

    def __repr__(self) -> object: ...
    def addPassiveGrabber(self, point: PySide6.QtGui.QEventPoint, grabber: PySide6.QtCore.QObject) -> bool: ...
    def allPointsAccepted(self) -> bool: ...
    def allPointsGrabbed(self) -> bool: ...
    def clearPassiveGrabbers(self, point: PySide6.QtGui.QEventPoint) -> None: ...
    def clone(self) -> PySide6.QtGui.QPointerEvent: ...
    def exclusiveGrabber(self, point: PySide6.QtGui.QEventPoint) -> PySide6.QtCore.QObject: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def point(self, i: int) -> PySide6.QtGui.QEventPoint: ...
    def pointById(self, id: int) -> PySide6.QtGui.QEventPoint: ...
    def pointCount(self) -> int: ...
    def pointerType(self) -> PySide6.QtGui.QPointingDevice.PointerType: ...
    def pointingDevice(self) -> PySide6.QtGui.QPointingDevice: ...
    def points(self) -> List[PySide6.QtGui.QEventPoint]: ...
    def removePassiveGrabber(self, point: PySide6.QtGui.QEventPoint, grabber: PySide6.QtCore.QObject) -> bool: ...
    def setAccepted(self, accepted: bool) -> None: ...
    def setExclusiveGrabber(self, point: PySide6.QtGui.QEventPoint, exclusiveGrabber: PySide6.QtCore.QObject) -> None: ...
    def setTimestamp(self, timestamp: int) -> None: ...


class QPointingDevice(PySide6.QtGui.QInputDevice):

    grabChanged              : ClassVar[Signal] = ... # grabChanged(QObject*,GrabTransition,const QPointerEvent*,QEventPoint)

    class GrabTransition(enum.Enum):

        GrabPassive              : QPointingDevice.GrabTransition = ... # 0x1
        UngrabPassive            : QPointingDevice.GrabTransition = ... # 0x2
        CancelGrabPassive        : QPointingDevice.GrabTransition = ... # 0x3
        OverrideGrabPassive      : QPointingDevice.GrabTransition = ... # 0x4
        GrabExclusive            : QPointingDevice.GrabTransition = ... # 0x10
        UngrabExclusive          : QPointingDevice.GrabTransition = ... # 0x20
        CancelGrabExclusive      : QPointingDevice.GrabTransition = ... # 0x30


    class PointerType(enum.Flag):

        Unknown                  : QPointingDevice.PointerType = ... # 0x0
        Generic                  : QPointingDevice.PointerType = ... # 0x1
        Finger                   : QPointingDevice.PointerType = ... # 0x2
        Pen                      : QPointingDevice.PointerType = ... # 0x4
        Eraser                   : QPointingDevice.PointerType = ... # 0x8
        Cursor                   : QPointingDevice.PointerType = ... # 0x10
        AllPointerTypes          : QPointingDevice.PointerType = ... # 0x7fff


    @overload
    def __init__(self, name: str, systemId: int, devType: PySide6.QtGui.QInputDevice.DeviceType, pType: PySide6.QtGui.QPointingDevice.PointerType, caps: PySide6.QtGui.QInputDevice.Capability, maxPoints: int, buttonCount: int, seatName: str = ..., uniqueId: PySide6.QtGui.QPointingDeviceUniqueId = ..., parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def buttonCount(self) -> int: ...
    def maximumPoints(self) -> int: ...
    def pointerType(self) -> PySide6.QtGui.QPointingDevice.PointerType: ...
    @staticmethod
    def primaryPointingDevice(seatName: str = ...) -> PySide6.QtGui.QPointingDevice: ...
    def setCapabilities(self, caps: PySide6.QtGui.QInputDevice.Capability) -> None: ...
    def setMaximumTouchPoints(self, c: int) -> None: ...
    def setType(self, devType: PySide6.QtGui.QInputDevice.DeviceType) -> None: ...
    def uniqueId(self) -> PySide6.QtGui.QPointingDeviceUniqueId: ...


class QPointingDeviceUniqueId(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QPointingDeviceUniqueId: PySide6.QtGui.QPointingDeviceUniqueId) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromNumericId(id: int) -> PySide6.QtGui.QPointingDeviceUniqueId: ...
    def isValid(self) -> bool: ...
    def numericId(self) -> int: ...


class QPolygon(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QPolygon: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> None: ...
    @overload
    def __init__(self, r: PySide6.QtCore.QRect, closed: bool = ...) -> None: ...
    @overload
    def __init__(self, v: Sequence[PySide6.QtCore.QPoint]) -> None: ...

    def __add__(self, l: Sequence[PySide6.QtCore.QPoint]) -> List[PySide6.QtCore.QPoint]: ...
    @staticmethod
    def __copy__() -> None: ...
    @overload
    def __lshift__(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def __lshift__(self, arg__1: Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @overload
    def __lshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPolygon: ...
    def __reduce__(self) -> object: ...
    def __rshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def append(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def append(self, l: Sequence[PySide6.QtCore.QPoint]) -> None: ...
    def at(self, i: int) -> PySide6.QtCore.QPoint: ...
    def back(self) -> PySide6.QtCore.QPoint: ...
    def boundingRect(self) -> PySide6.QtCore.QRect: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide6.QtCore.QPoint: ...
    def constFirst(self) -> PySide6.QtCore.QPoint: ...
    def constLast(self) -> PySide6.QtCore.QPoint: ...
    def containsPoint(self, pt: PySide6.QtCore.QPoint, fillRule: PySide6.QtCore.Qt.FillRule) -> bool: ...
    def count(self) -> int: ...
    def data(self) -> PySide6.QtCore.QPoint: ...
    def empty(self) -> bool: ...
    @overload
    def first(self) -> PySide6.QtCore.QPoint: ...
    @overload
    def first(self, n: int) -> List[PySide6.QtCore.QPoint]: ...
    @staticmethod
    def fromList(list: Sequence[PySide6.QtCore.QPoint]) -> List[PySide6.QtCore.QPoint]: ...
    @staticmethod
    def fromVector(vector: Sequence[PySide6.QtCore.QPoint]) -> List[PySide6.QtCore.QPoint]: ...
    def front(self) -> PySide6.QtCore.QPoint: ...
    def insert(self, arg__1: int, arg__2: PySide6.QtCore.QPoint) -> None: ...
    def intersected(self, r: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygon: ...
    def intersects(self, r: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: Sequence[PySide6.QtCore.QPoint]) -> bool: ...
    @overload
    def last(self) -> PySide6.QtCore.QPoint: ...
    @overload
    def last(self, n: int) -> List[PySide6.QtCore.QPoint]: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> List[PySide6.QtCore.QPoint]: ...
    def move(self, from_: int, to: int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def push_back(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def push_front(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def remove(self, i: int, n: int = ...) -> None: ...
    def removeAll(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    @overload
    def sliced(self, pos: int) -> List[PySide6.QtCore.QPoint]: ...
    @overload
    def sliced(self, pos: int, n: int) -> List[PySide6.QtCore.QPoint]: ...
    def squeeze(self) -> None: ...
    def subtracted(self, r: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygon: ...
    def swap(self, other: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> PySide6.QtCore.QPoint: ...
    def toList(self) -> List[PySide6.QtCore.QPoint]: ...
    def toPolygonF(self) -> PySide6.QtGui.QPolygonF: ...
    def toVector(self) -> List[PySide6.QtCore.QPoint]: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, offset: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def translated(self, dx: int, dy: int) -> PySide6.QtGui.QPolygon: ...
    @overload
    def translated(self, offset: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPolygon: ...
    def united(self, r: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygon: ...
    def value(self, i: int) -> PySide6.QtCore.QPoint: ...


class QPolygonF(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QPolygonF: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> None: ...
    @overload
    def __init__(self, a: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> None: ...
    @overload
    def __init__(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def __init__(self, v: Sequence[PySide6.QtCore.QPointF]) -> None: ...

    def __add__(self, l: Sequence[PySide6.QtCore.QPointF]) -> List[PySide6.QtCore.QPointF]: ...
    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPolygonF: ...
    def __rshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def append(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def append(self, l: Sequence[PySide6.QtCore.QPointF]) -> None: ...
    def at(self, i: int) -> PySide6.QtCore.QPointF: ...
    def back(self) -> PySide6.QtCore.QPointF: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide6.QtCore.QPointF: ...
    def constFirst(self) -> PySide6.QtCore.QPointF: ...
    def constLast(self) -> PySide6.QtCore.QPointF: ...
    def containsPoint(self, pt: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], fillRule: PySide6.QtCore.Qt.FillRule) -> bool: ...
    def count(self) -> int: ...
    def data(self) -> PySide6.QtCore.QPointF: ...
    def empty(self) -> bool: ...
    @overload
    def first(self) -> PySide6.QtCore.QPointF: ...
    @overload
    def first(self, n: int) -> List[PySide6.QtCore.QPointF]: ...
    @staticmethod
    def fromList(list: Sequence[PySide6.QtCore.QPointF]) -> List[PySide6.QtCore.QPointF]: ...
    @staticmethod
    def fromVector(vector: Sequence[PySide6.QtCore.QPointF]) -> List[PySide6.QtCore.QPointF]: ...
    def front(self) -> PySide6.QtCore.QPointF: ...
    def insert(self, arg__1: int, arg__2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def intersected(self, r: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    def intersects(self, r: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> bool: ...
    def isClosed(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: Sequence[PySide6.QtCore.QPointF]) -> bool: ...
    @overload
    def last(self) -> PySide6.QtCore.QPointF: ...
    @overload
    def last(self, n: int) -> List[PySide6.QtCore.QPointF]: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> List[PySide6.QtCore.QPointF]: ...
    def move(self, from_: int, to: int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def push_back(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def push_front(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def remove(self, i: int, n: int = ...) -> None: ...
    def removeAll(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    @overload
    def sliced(self, pos: int) -> List[PySide6.QtCore.QPointF]: ...
    @overload
    def sliced(self, pos: int, n: int) -> List[PySide6.QtCore.QPointF]: ...
    def squeeze(self) -> None: ...
    def subtracted(self, r: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    def swap(self, other: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> PySide6.QtCore.QPointF: ...
    def toList(self) -> List[PySide6.QtCore.QPointF]: ...
    def toPolygon(self) -> PySide6.QtGui.QPolygon: ...
    def toVector(self) -> List[PySide6.QtCore.QPointF]: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def translated(self, dx: float, dy: float) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def translated(self, offset: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtGui.QPolygonF: ...
    def united(self, r: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    def value(self, i: int) -> PySide6.QtCore.QPointF: ...


class QPyTextObject(PySide6.QtCore.QObject, PySide6.QtGui.QTextObjectInterface):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...


class QQuaternion(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, scalar: float, vector: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def __init__(self, scalar: float, xpos: float, ypos: float, zpos: float) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None: ...

    def __add__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QQuaternion: ...
    @overload
    def __imul__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def __isub__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QQuaternion: ...
    @overload
    def __mul__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def __neg__(self) -> PySide6.QtGui.QQuaternion: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def conjugated(self) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def dotProduct(q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion) -> float: ...
    @staticmethod
    def fromAxes(xAxis: PySide6.QtGui.QVector3D, yAxis: PySide6.QtGui.QVector3D, zAxis: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    @overload
    @staticmethod
    def fromAxisAndAngle(axis: PySide6.QtGui.QVector3D, angle: float) -> PySide6.QtGui.QQuaternion: ...
    @overload
    @staticmethod
    def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def fromDirection(direction: PySide6.QtGui.QVector3D, up: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    @overload
    @staticmethod
    def fromEulerAngles(eulerAngles: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    @overload
    @staticmethod
    def fromEulerAngles(pitch: float, yaw: float, roll: float) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def fromRotationMatrix(rot3x3: PySide6.QtGui.QMatrix3x3) -> PySide6.QtGui.QQuaternion: ...
    def getAxes(self, xAxis: PySide6.QtGui.QVector3D, yAxis: PySide6.QtGui.QVector3D, zAxis: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def getAxisAndAngle(self, axis: PySide6.QtGui.QVector3D) -> float: ...
    @overload
    def getAxisAndAngle(self) -> Tuple[float, float, float, float]: ...
    def getEulerAngles(self) -> Tuple[float, float, float]: ...
    def inverted(self) -> PySide6.QtGui.QQuaternion: ...
    def isIdentity(self) -> bool: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @staticmethod
    def nlerp(q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion, t: float) -> PySide6.QtGui.QQuaternion: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QQuaternion: ...
    def rotatedVector(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @staticmethod
    def rotationTo(from_: PySide6.QtGui.QVector3D, to: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    def scalar(self) -> float: ...
    def setScalar(self, scalar: float) -> None: ...
    @overload
    def setVector(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def setVector(self, x: float, y: float, z: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    @staticmethod
    def slerp(q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion, t: float) -> PySide6.QtGui.QQuaternion: ...
    def toEulerAngles(self) -> PySide6.QtGui.QVector3D: ...
    def toRotationMatrix(self) -> PySide6.QtGui.QMatrix3x3: ...
    def toVector4D(self) -> PySide6.QtGui.QVector4D: ...
    def vector(self) -> PySide6.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QRadialGradient(PySide6.QtGui.QGradient):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QRadialGradient: PySide6.QtGui.QRadialGradient) -> None: ...
    @overload
    def __init__(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], centerRadius: float, focalPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], focalRadius: float) -> None: ...
    @overload
    def __init__(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], radius: float) -> None: ...
    @overload
    def __init__(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], radius: float, focalPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, centerRadius: float, fx: float, fy: float, focalRadius: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, radius: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, radius: float, fx: float, fy: float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def center(self) -> PySide6.QtCore.QPointF: ...
    def centerRadius(self) -> float: ...
    def focalPoint(self) -> PySide6.QtCore.QPointF: ...
    def focalRadius(self) -> float: ...
    def radius(self) -> float: ...
    @overload
    def setCenter(self, center: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setCenter(self, x: float, y: float) -> None: ...
    def setCenterRadius(self, radius: float) -> None: ...
    @overload
    def setFocalPoint(self, focalPoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setFocalPoint(self, x: float, y: float) -> None: ...
    def setFocalRadius(self, radius: float) -> None: ...
    def setRadius(self, radius: float) -> None: ...


class QRasterWindow(PySide6.QtGui.QPaintDeviceWindow):

    def __init__(self, parent: Optional[PySide6.QtGui.QWindow] = ...) -> None: ...

    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def redirected(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPaintDevice: ...


class QRawFont(Shiboken.Object):

    class AntialiasingType(enum.Enum):

        PixelAntialiasing        : QRawFont.AntialiasingType = ... # 0x0
        SubPixelAntialiasing     : QRawFont.AntialiasingType = ... # 0x1


    class LayoutFlag(enum.Flag):

        SeparateAdvances         : QRawFont.LayoutFlag = ... # 0x0
        KernedAdvances           : QRawFont.LayoutFlag = ... # 0x1
        UseDesignMetrics         : QRawFont.LayoutFlag = ... # 0x2


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, fileName: str, pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference = ...) -> None: ...
    @overload
    def __init__(self, fontData: Union[PySide6.QtCore.QByteArray, bytes], pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference = ...) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QRawFont) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @overload
    def advancesForGlyphIndexes(self, glyphIndexes: Sequence[int]) -> List[PySide6.QtCore.QPointF]: ...
    @overload
    def advancesForGlyphIndexes(self, glyphIndexes: Sequence[int], layoutFlags: PySide6.QtGui.QRawFont.LayoutFlag) -> List[PySide6.QtCore.QPointF]: ...
    def alphaMapForGlyph(self, glyphIndex: int, antialiasingType: PySide6.QtGui.QRawFont.AntialiasingType = ..., transform: PySide6.QtGui.QTransform = ...) -> PySide6.QtGui.QImage: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    def boundingRect(self, glyphIndex: int) -> PySide6.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def familyName(self) -> str: ...
    def fontTable(self, tagName: bytes) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromFont(font: Union[PySide6.QtGui.QFont, str, Sequence[str]], writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem = ...) -> PySide6.QtGui.QRawFont: ...
    def glyphIndexesForString(self, text: str) -> List[int]: ...
    def hintingPreference(self) -> PySide6.QtGui.QFont.HintingPreference: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def lineThickness(self) -> float: ...
    def loadFromData(self, fontData: Union[PySide6.QtCore.QByteArray, bytes], pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def loadFromFile(self, fileName: str, pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def maxCharWidth(self) -> float: ...
    def pathForGlyph(self, glyphIndex: int) -> PySide6.QtGui.QPainterPath: ...
    def pixelSize(self) -> float: ...
    def setPixelSize(self, pixelSize: float) -> None: ...
    def style(self) -> PySide6.QtGui.QFont.Style: ...
    def styleName(self) -> str: ...
    def supportedWritingSystems(self) -> List[PySide6.QtGui.QFontDatabase.WritingSystem]: ...
    @overload
    def supportsCharacter(self, character: str) -> bool: ...
    @overload
    def supportsCharacter(self, ucs4: int) -> bool: ...
    def swap(self, other: PySide6.QtGui.QRawFont) -> None: ...
    def underlinePosition(self) -> float: ...
    def unitsPerEm(self) -> float: ...
    def weight(self) -> int: ...
    def xHeight(self) -> float: ...


class QRegion(Shiboken.Object):

    class RegionType(enum.Enum):

        Rectangle                : QRegion.RegionType = ... # 0x0
        Ellipse                  : QRegion.RegionType = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bitmap: Union[PySide6.QtGui.QBitmap, str]) -> None: ...
    @overload
    def __init__(self, pa: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect], fillRule: PySide6.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def __init__(self, r: PySide6.QtCore.QRect, t: PySide6.QtGui.QRegion.RegionType = ...) -> None: ...
    @overload
    def __init__(self, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def __init__(self, x: int, y: int, w: int, h: int, t: PySide6.QtGui.QRegion.RegionType = ...) -> None: ...

    @overload
    def __add__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @overload
    def __add__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    @overload
    def __and__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @overload
    def __and__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    @staticmethod
    def __copy__() -> None: ...
    @overload
    def __iadd__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @overload
    def __iadd__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def __ior__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def __isub__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def __ixor__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QRegion: ...
    def __or__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def __xor__(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def begin(self) -> PySide6.QtCore.QRect: ...
    def boundingRect(self) -> PySide6.QtCore.QRect: ...
    def cbegin(self) -> PySide6.QtCore.QRect: ...
    def cend(self) -> PySide6.QtCore.QRect: ...
    @overload
    def contains(self, p: PySide6.QtCore.QPoint) -> bool: ...
    @overload
    def contains(self, r: PySide6.QtCore.QRect) -> bool: ...
    def end(self) -> PySide6.QtCore.QRect: ...
    @overload
    def intersected(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @overload
    def intersected(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    @overload
    def intersects(self, r: PySide6.QtCore.QRect) -> bool: ...
    @overload
    def intersects(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def rectCount(self) -> int: ...
    def setRects(self, rect: PySide6.QtCore.QRect, num: int) -> None: ...
    def subtracted(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def swap(self, other: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, p: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def translated(self, dx: int, dy: int) -> PySide6.QtGui.QRegion: ...
    @overload
    def translated(self, p: PySide6.QtCore.QPoint) -> PySide6.QtGui.QRegion: ...
    @overload
    def united(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @overload
    def united(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    def xored(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...


class QRegularExpressionValidator(PySide6.QtGui.QValidator):

    regularExpressionChanged : ClassVar[Signal] = ... # regularExpressionChanged(QRegularExpression)

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, re: Union[PySide6.QtCore.QRegularExpression, str], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def regularExpression(self) -> PySide6.QtCore.QRegularExpression: ...
    def setRegularExpression(self, re: Union[PySide6.QtCore.QRegularExpression, str]) -> None: ...
    def validate(self, input: str, pos: int) -> object: ...


class QResizeEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    @overload
    def __init__(self, size: PySide6.QtCore.QSize, oldSize: PySide6.QtCore.QSize) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QResizeEvent: ...
    def oldSize(self) -> PySide6.QtCore.QSize: ...
    def size(self) -> PySide6.QtCore.QSize: ...


class QRgba64(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QRgba64: PySide6.QtGui.QRgba64) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alpha(self) -> int: ...
    def alpha8(self) -> int: ...
    def blue(self) -> int: ...
    def blue8(self) -> int: ...
    @staticmethod
    def fromArgb32(rgb: int) -> PySide6.QtGui.QRgba64: ...
    @staticmethod
    def fromRgba(red: int, green: int, blue: int, alpha: int) -> PySide6.QtGui.QRgba64: ...
    @overload
    @staticmethod
    def fromRgba64(c: int) -> PySide6.QtGui.QRgba64: ...
    @overload
    @staticmethod
    def fromRgba64(red: int, green: int, blue: int, alpha: int) -> PySide6.QtGui.QRgba64: ...
    def green(self) -> int: ...
    def green8(self) -> int: ...
    def isOpaque(self) -> bool: ...
    def isTransparent(self) -> bool: ...
    def premultiplied(self) -> PySide6.QtGui.QRgba64: ...
    def red(self) -> int: ...
    def red8(self) -> int: ...
    def setAlpha(self, _alpha: int) -> None: ...
    def setBlue(self, _blue: int) -> None: ...
    def setGreen(self, _green: int) -> None: ...
    def setRed(self, _red: int) -> None: ...
    def toArgb32(self) -> int: ...
    def toRgb16(self) -> int: ...
    def unpremultiplied(self) -> PySide6.QtGui.QRgba64: ...


class QScreen(PySide6.QtCore.QObject):

    availableGeometryChanged : ClassVar[Signal] = ... # availableGeometryChanged(QRect)
    geometryChanged          : ClassVar[Signal] = ... # geometryChanged(QRect)
    logicalDotsPerInchChanged: ClassVar[Signal] = ... # logicalDotsPerInchChanged(double)
    orientationChanged       : ClassVar[Signal] = ... # orientationChanged(Qt::ScreenOrientation)
    physicalDotsPerInchChanged: ClassVar[Signal] = ... # physicalDotsPerInchChanged(double)
    physicalSizeChanged      : ClassVar[Signal] = ... # physicalSizeChanged(QSizeF)
    primaryOrientationChanged: ClassVar[Signal] = ... # primaryOrientationChanged(Qt::ScreenOrientation)
    refreshRateChanged       : ClassVar[Signal] = ... # refreshRateChanged(double)
    virtualGeometryChanged   : ClassVar[Signal] = ... # virtualGeometryChanged(QRect)
    def angleBetween(self, a: PySide6.QtCore.Qt.ScreenOrientation, b: PySide6.QtCore.Qt.ScreenOrientation) -> int: ...
    def availableGeometry(self) -> PySide6.QtCore.QRect: ...
    def availableSize(self) -> PySide6.QtCore.QSize: ...
    def availableVirtualGeometry(self) -> PySide6.QtCore.QRect: ...
    def availableVirtualSize(self) -> PySide6.QtCore.QSize: ...
    def depth(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def grabWindow(self, window: int, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> PySide6.QtGui.QPixmap: ...
    def isLandscape(self, orientation: PySide6.QtCore.Qt.ScreenOrientation) -> bool: ...
    def isPortrait(self, orientation: PySide6.QtCore.Qt.ScreenOrientation) -> bool: ...
    def logicalDotsPerInch(self) -> float: ...
    def logicalDotsPerInchX(self) -> float: ...
    def logicalDotsPerInchY(self) -> float: ...
    def manufacturer(self) -> str: ...
    def mapBetween(self, a: PySide6.QtCore.Qt.ScreenOrientation, b: PySide6.QtCore.Qt.ScreenOrientation, rect: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def model(self) -> str: ...
    def name(self) -> str: ...
    def nativeOrientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def orientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def physicalDotsPerInch(self) -> float: ...
    def physicalDotsPerInchX(self) -> float: ...
    def physicalDotsPerInchY(self) -> float: ...
    def physicalSize(self) -> PySide6.QtCore.QSizeF: ...
    def primaryOrientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def refreshRate(self) -> float: ...
    def resolveInterface(self, name: bytes, revision: int) -> int: ...
    def serialNumber(self) -> str: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def transformBetween(self, a: PySide6.QtCore.Qt.ScreenOrientation, b: PySide6.QtCore.Qt.ScreenOrientation, target: PySide6.QtCore.QRect) -> PySide6.QtGui.QTransform: ...
    def virtualGeometry(self) -> PySide6.QtCore.QRect: ...
    def virtualSiblingAt(self, point: PySide6.QtCore.QPoint) -> PySide6.QtGui.QScreen: ...
    def virtualSiblings(self) -> List[PySide6.QtGui.QScreen]: ...
    def virtualSize(self) -> PySide6.QtCore.QSize: ...


class QScrollEvent(PySide6.QtCore.QEvent):

    class ScrollState(enum.Enum):

        ScrollStarted            : QScrollEvent.ScrollState = ... # 0x0
        ScrollUpdated            : QScrollEvent.ScrollState = ... # 0x1
        ScrollFinished           : QScrollEvent.ScrollState = ... # 0x2


    @overload
    def __init__(self, arg__1: PySide6.QtGui.QScrollEvent) -> None: ...
    @overload
    def __init__(self, contentPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], overshoot: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scrollState: PySide6.QtGui.QScrollEvent.ScrollState) -> None: ...

    def clone(self) -> PySide6.QtGui.QScrollEvent: ...
    def contentPos(self) -> PySide6.QtCore.QPointF: ...
    def overshootDistance(self) -> PySide6.QtCore.QPointF: ...
    def scrollState(self) -> PySide6.QtGui.QScrollEvent.ScrollState: ...


class QScrollPrepareEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QScrollPrepareEvent) -> None: ...
    @overload
    def __init__(self, startPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...

    def clone(self) -> PySide6.QtGui.QScrollPrepareEvent: ...
    def contentPos(self) -> PySide6.QtCore.QPointF: ...
    def contentPosRange(self) -> PySide6.QtCore.QRectF: ...
    def setContentPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setContentPosRange(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setViewportSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    def startPos(self) -> PySide6.QtCore.QPointF: ...
    def viewportSize(self) -> PySide6.QtCore.QSizeF: ...


class QSessionManager(PySide6.QtCore.QObject):

    class RestartHint(enum.Enum):

        RestartIfRunning         : QSessionManager.RestartHint = ... # 0x0
        RestartAnyway            : QSessionManager.RestartHint = ... # 0x1
        RestartImmediately       : QSessionManager.RestartHint = ... # 0x2
        RestartNever             : QSessionManager.RestartHint = ... # 0x3


    def allowsErrorInteraction(self) -> bool: ...
    def allowsInteraction(self) -> bool: ...
    def cancel(self) -> None: ...
    def discardCommand(self) -> List[str]: ...
    def isPhase2(self) -> bool: ...
    def release(self) -> None: ...
    def requestPhase2(self) -> None: ...
    def restartCommand(self) -> List[str]: ...
    def restartHint(self) -> PySide6.QtGui.QSessionManager.RestartHint: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    def setDiscardCommand(self, arg__1: Sequence[str]) -> None: ...
    @overload
    def setManagerProperty(self, name: str, value: str) -> None: ...
    @overload
    def setManagerProperty(self, name: str, value: Sequence[str]) -> None: ...
    def setRestartCommand(self, arg__1: Sequence[str]) -> None: ...
    def setRestartHint(self, arg__1: PySide6.QtGui.QSessionManager.RestartHint) -> None: ...


class QShortcut(PySide6.QtCore.QObject):

    activated                : ClassVar[Signal] = ... # activated()
    activatedAmbiguously     : ClassVar[Signal] = ... # activatedAmbiguously()

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QKeySequence.StandardKey, arg__2: PySide6.QtCore.QObject, arg__3: Callable, arg__4: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @overload
    def __init__(self, arg__1: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], arg__2: PySide6.QtCore.QObject, arg__3: Callable, arg__4: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @overload
    def __init__(self, key: PySide6.QtGui.QKeySequence.StandardKey, parent: PySide6.QtCore.QObject, member: Optional[bytes] = ..., ambiguousMember: Optional[bytes] = ..., context: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @overload
    def __init__(self, key: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], parent: PySide6.QtCore.QObject, member: Optional[bytes] = ..., ambiguousMember: Optional[bytes] = ..., context: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtCore.QObject) -> None: ...

    def autoRepeat(self) -> bool: ...
    def context(self) -> PySide6.QtCore.Qt.ShortcutContext: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def id(self) -> int: ...
    def isEnabled(self) -> bool: ...
    def key(self) -> PySide6.QtGui.QKeySequence: ...
    def keys(self) -> List[PySide6.QtGui.QKeySequence]: ...
    def setAutoRepeat(self, on: bool) -> None: ...
    def setContext(self, context: PySide6.QtCore.Qt.ShortcutContext) -> None: ...
    def setEnabled(self, enable: bool) -> None: ...
    def setKey(self, key: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> None: ...
    @overload
    def setKeys(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> None: ...
    @overload
    def setKeys(self, keys: Sequence[PySide6.QtGui.QKeySequence]) -> None: ...
    def setWhatsThis(self, text: str) -> None: ...
    def whatsThis(self) -> str: ...


class QShortcutEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QShortcutEvent) -> None: ...
    @overload
    def __init__(self, key: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], id: int, ambiguous: bool = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QShortcutEvent: ...
    def isAmbiguous(self) -> bool: ...
    def key(self) -> PySide6.QtGui.QKeySequence: ...
    def shortcutId(self) -> int: ...


class QShowEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QShowEvent: ...


class QSinglePointEvent(PySide6.QtGui.QPointerEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QSinglePointEvent) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, dev: PySide6.QtGui.QPointingDevice, localPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scenePos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, source: PySide6.QtCore.Qt.MouseEventSource = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, dev: PySide6.QtGui.QPointingDevice, point: PySide6.QtGui.QEventPoint, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, source: PySide6.QtCore.Qt.MouseEventSource) -> None: ...

    def button(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def buttons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def clone(self) -> PySide6.QtGui.QSinglePointEvent: ...
    def exclusivePointGrabber(self) -> PySide6.QtCore.QObject: ...
    def globalPosition(self) -> PySide6.QtCore.QPointF: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def scenePosition(self) -> PySide6.QtCore.QPointF: ...
    def setExclusivePointGrabber(self, exclusiveGrabber: PySide6.QtCore.QObject) -> None: ...


class QStandardItem(Shiboken.Object):

    class ItemType(enum.Enum):

        Type                     : QStandardItem.ItemType = ... # 0x0
        UserType                 : QStandardItem.ItemType = ... # 0x3e8


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QStandardItem) -> None: ...
    @overload
    def __init__(self, rows: int, columns: int = ...) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def accessibleDescription(self) -> str: ...
    def accessibleText(self) -> str: ...
    def appendColumn(self, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @overload
    def appendRow(self, item: PySide6.QtGui.QStandardItem) -> None: ...
    @overload
    def appendRow(self, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def appendRows(self, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def checkState(self) -> PySide6.QtCore.Qt.CheckState: ...
    def child(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def clearData(self) -> None: ...
    def clone(self) -> PySide6.QtGui.QStandardItem: ...
    def column(self) -> int: ...
    def columnCount(self) -> int: ...
    def data(self, role: int = ...) -> Any: ...
    def emitDataChanged(self) -> None: ...
    def flags(self) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def foreground(self) -> PySide6.QtGui.QBrush: ...
    def hasChildren(self) -> bool: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def index(self) -> PySide6.QtCore.QModelIndex: ...
    def insertColumn(self, column: int, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def insertColumns(self, column: int, count: int) -> None: ...
    @overload
    def insertRow(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    @overload
    def insertRow(self, row: int, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @overload
    def insertRows(self, row: int, count: int) -> None: ...
    @overload
    def insertRows(self, row: int, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def isAutoTristate(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def isDragEnabled(self) -> bool: ...
    def isDropEnabled(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isSelectable(self) -> bool: ...
    def isUserTristate(self) -> bool: ...
    def model(self) -> PySide6.QtGui.QStandardItemModel: ...
    def parent(self) -> PySide6.QtGui.QStandardItem: ...
    def read(self, in_: PySide6.QtCore.QDataStream) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeColumns(self, column: int, count: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def removeRows(self, row: int, count: int) -> None: ...
    def row(self) -> int: ...
    def rowCount(self) -> int: ...
    def setAccessibleDescription(self, accessibleDescription: str) -> None: ...
    def setAccessibleText(self, accessibleText: str) -> None: ...
    def setAutoTristate(self, tristate: bool) -> None: ...
    def setBackground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setCheckState(self, checkState: PySide6.QtCore.Qt.CheckState) -> None: ...
    def setCheckable(self, checkable: bool) -> None: ...
    @overload
    def setChild(self, row: int, column: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    @overload
    def setChild(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setData(self, value: Any, role: int = ...) -> None: ...
    def setDragEnabled(self, dragEnabled: bool) -> None: ...
    def setDropEnabled(self, dropEnabled: bool) -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setForeground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def setSizeHint(self, sizeHint: PySide6.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextAlignment(self, textAlignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setUserTristate(self, tristate: bool) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def statusTip(self) -> str: ...
    def takeChild(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def takeColumn(self, column: int) -> List[PySide6.QtGui.QStandardItem]: ...
    def takeRow(self, row: int) -> List[PySide6.QtGui.QStandardItem]: ...
    def text(self) -> str: ...
    def textAlignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream) -> None: ...


class QStandardItemModel(PySide6.QtCore.QAbstractItemModel):

    itemChanged              : ClassVar[Signal] = ... # itemChanged(QStandardItem*)

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, rows: int, columns: int, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def appendColumn(self, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @overload
    def appendRow(self, item: PySide6.QtGui.QStandardItem) -> None: ...
    @overload
    def appendRow(self, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def clear(self) -> None: ...
    def clearItemData(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def columnCount(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> int: ...
    def data(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], role: int = ...) -> Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag = ..., column: int = ...) -> List[PySide6.QtGui.QStandardItem]: ...
    def flags(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...) -> Any: ...
    def horizontalHeaderItem(self, column: int) -> PySide6.QtGui.QStandardItem: ...
    def index(self, row: int, column: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> PySide6.QtCore.QModelIndex: ...
    def indexFromItem(self, item: PySide6.QtGui.QStandardItem) -> PySide6.QtCore.QModelIndex: ...
    @overload
    def insertColumn(self, column: int, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @overload
    def insertColumn(self, column: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    @overload
    def insertRow(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    @overload
    def insertRow(self, row: int, items: Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @overload
    def insertRow(self, row: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    def invisibleRootItem(self) -> PySide6.QtGui.QStandardItem: ...
    def item(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def itemData(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> Dict[int, Any]: ...
    def itemFromIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtGui.QStandardItem: ...
    def itemPrototype(self) -> PySide6.QtGui.QStandardItem: ...
    def mimeData(self, indexes: Sequence[PySide6.QtCore.QModelIndex]) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    @overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @overload
    def parent(self, child: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    def roleNames(self) -> Dict[int, PySide6.QtCore.QByteArray]: ...
    def rowCount(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> int: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setData(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], value: Any, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, value: Any, role: int = ...) -> bool: ...
    def setHorizontalHeaderItem(self, column: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setHorizontalHeaderLabels(self, labels: Sequence[str]) -> None: ...
    @overload
    def setItem(self, row: int, column: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    @overload
    def setItem(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setItemData(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], roles: Dict[int, Any]) -> bool: ...
    def setItemPrototype(self, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setItemRoleNames(self, roleNames: Dict[int, PySide6.QtCore.QByteArray]) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSortRole(self, role: int) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setVerticalHeaderLabels(self, labels: Sequence[str]) -> None: ...
    def sort(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def sortRole(self) -> int: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def takeColumn(self, column: int) -> List[PySide6.QtGui.QStandardItem]: ...
    def takeHorizontalHeaderItem(self, column: int) -> PySide6.QtGui.QStandardItem: ...
    def takeItem(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def takeRow(self, row: int) -> List[PySide6.QtGui.QStandardItem]: ...
    def takeVerticalHeaderItem(self, row: int) -> PySide6.QtGui.QStandardItem: ...
    def verticalHeaderItem(self, row: int) -> PySide6.QtGui.QStandardItem: ...


class QStaticText(Shiboken.Object):

    class PerformanceHint(enum.Enum):

        ModerateCaching          : QStaticText.PerformanceHint = ... # 0x0
        AggressiveCaching        : QStaticText.PerformanceHint = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QStaticText) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def performanceHint(self) -> PySide6.QtGui.QStaticText.PerformanceHint: ...
    def prepare(self, matrix: PySide6.QtGui.QTransform = ..., font: Union[PySide6.QtGui.QFont, str, Sequence[str]] = ...) -> None: ...
    def setPerformanceHint(self, performanceHint: PySide6.QtGui.QStaticText.PerformanceHint) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextFormat(self, textFormat: PySide6.QtCore.Qt.TextFormat) -> None: ...
    def setTextOption(self, textOption: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setTextWidth(self, textWidth: float) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def swap(self, other: PySide6.QtGui.QStaticText) -> None: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide6.QtCore.Qt.TextFormat: ...
    def textOption(self) -> PySide6.QtGui.QTextOption: ...
    def textWidth(self) -> float: ...


class QStatusTipEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QStatusTipEvent) -> None: ...
    @overload
    def __init__(self, tip: str) -> None: ...

    def clone(self) -> PySide6.QtGui.QStatusTipEvent: ...
    def tip(self) -> str: ...


class QStyleHints(PySide6.QtCore.QObject):

    cursorFlashTimeChanged   : ClassVar[Signal] = ... # cursorFlashTimeChanged(int)
    keyboardInputIntervalChanged: ClassVar[Signal] = ... # keyboardInputIntervalChanged(int)
    mouseDoubleClickIntervalChanged: ClassVar[Signal] = ... # mouseDoubleClickIntervalChanged(int)
    mousePressAndHoldIntervalChanged: ClassVar[Signal] = ... # mousePressAndHoldIntervalChanged(int)
    mouseQuickSelectionThresholdChanged: ClassVar[Signal] = ... # mouseQuickSelectionThresholdChanged(int)
    showShortcutsInContextMenusChanged: ClassVar[Signal] = ... # showShortcutsInContextMenusChanged(bool)
    startDragDistanceChanged : ClassVar[Signal] = ... # startDragDistanceChanged(int)
    startDragTimeChanged     : ClassVar[Signal] = ... # startDragTimeChanged(int)
    tabFocusBehaviorChanged  : ClassVar[Signal] = ... # tabFocusBehaviorChanged(Qt::TabFocusBehavior)
    useHoverEffectsChanged   : ClassVar[Signal] = ... # useHoverEffectsChanged(bool)
    wheelScrollLinesChanged  : ClassVar[Signal] = ... # wheelScrollLinesChanged(int)
    def cursorFlashTime(self) -> int: ...
    def fontSmoothingGamma(self) -> float: ...
    def keyboardAutoRepeatRate(self) -> int: ...
    def keyboardInputInterval(self) -> int: ...
    def mouseDoubleClickDistance(self) -> int: ...
    def mouseDoubleClickInterval(self) -> int: ...
    def mousePressAndHoldInterval(self) -> int: ...
    def mouseQuickSelectionThreshold(self) -> int: ...
    def passwordMaskCharacter(self) -> str: ...
    def passwordMaskDelay(self) -> int: ...
    def setCursorFlashTime(self, cursorFlashTime: int) -> None: ...
    def setFocusOnTouchRelease(self) -> bool: ...
    def setKeyboardInputInterval(self, keyboardInputInterval: int) -> None: ...
    def setMouseDoubleClickInterval(self, mouseDoubleClickInterval: int) -> None: ...
    def setMousePressAndHoldInterval(self, mousePressAndHoldInterval: int) -> None: ...
    def setMouseQuickSelectionThreshold(self, threshold: int) -> None: ...
    def setShowShortcutsInContextMenus(self, showShortcutsInContextMenus: bool) -> None: ...
    def setStartDragDistance(self, startDragDistance: int) -> None: ...
    def setStartDragTime(self, startDragTime: int) -> None: ...
    def setTabFocusBehavior(self, tabFocusBehavior: PySide6.QtCore.Qt.TabFocusBehavior) -> None: ...
    def setUseHoverEffects(self, useHoverEffects: bool) -> None: ...
    def setWheelScrollLines(self, scrollLines: int) -> None: ...
    def showIsFullScreen(self) -> bool: ...
    def showIsMaximized(self) -> bool: ...
    def showShortcutsInContextMenus(self) -> bool: ...
    def singleClickActivation(self) -> bool: ...
    def startDragDistance(self) -> int: ...
    def startDragTime(self) -> int: ...
    def startDragVelocity(self) -> int: ...
    def tabFocusBehavior(self) -> PySide6.QtCore.Qt.TabFocusBehavior: ...
    def touchDoubleTapDistance(self) -> int: ...
    def useHoverEffects(self) -> bool: ...
    def useRtlExtensions(self) -> bool: ...
    def wheelScrollLines(self) -> int: ...


class QSurface(Shiboken.Object):

    class SurfaceClass(enum.Enum):

        Window                   : QSurface.SurfaceClass = ... # 0x0
        Offscreen                : QSurface.SurfaceClass = ... # 0x1


    class SurfaceType(enum.Enum):

        RasterSurface            : QSurface.SurfaceType = ... # 0x0
        OpenGLSurface            : QSurface.SurfaceType = ... # 0x1
        RasterGLSurface          : QSurface.SurfaceType = ... # 0x2
        OpenVGSurface            : QSurface.SurfaceType = ... # 0x3
        VulkanSurface            : QSurface.SurfaceType = ... # 0x4
        MetalSurface             : QSurface.SurfaceType = ... # 0x5
        Direct3DSurface          : QSurface.SurfaceType = ... # 0x6


    def __init__(self, type: PySide6.QtGui.QSurface.SurfaceClass) -> None: ...

    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def supportsOpenGL(self) -> bool: ...
    def surfaceClass(self) -> PySide6.QtGui.QSurface.SurfaceClass: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType: ...


class QSurfaceFormat(Shiboken.Object):

    class ColorSpace(enum.Enum):

        DefaultColorSpace        : QSurfaceFormat.ColorSpace = ... # 0x0
        sRGBColorSpace           : QSurfaceFormat.ColorSpace = ... # 0x1


    class FormatOption(enum.Flag):

        StereoBuffers            : QSurfaceFormat.FormatOption = ... # 0x1
        DebugContext             : QSurfaceFormat.FormatOption = ... # 0x2
        DeprecatedFunctions      : QSurfaceFormat.FormatOption = ... # 0x4
        ResetNotification        : QSurfaceFormat.FormatOption = ... # 0x8
        ProtectedContent         : QSurfaceFormat.FormatOption = ... # 0x10


    class OpenGLContextProfile(enum.Enum):

        NoProfile                : QSurfaceFormat.OpenGLContextProfile = ... # 0x0
        CoreProfile              : QSurfaceFormat.OpenGLContextProfile = ... # 0x1
        CompatibilityProfile     : QSurfaceFormat.OpenGLContextProfile = ... # 0x2


    class RenderableType(enum.Enum):

        DefaultRenderableType    : QSurfaceFormat.RenderableType = ... # 0x0
        OpenGL                   : QSurfaceFormat.RenderableType = ... # 0x1
        OpenGLES                 : QSurfaceFormat.RenderableType = ... # 0x2
        OpenVG                   : QSurfaceFormat.RenderableType = ... # 0x4


    class SwapBehavior(enum.Enum):

        DefaultSwapBehavior      : QSurfaceFormat.SwapBehavior = ... # 0x0
        SingleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x1
        DoubleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x2
        TripleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x3


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, options: PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOption]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alphaBufferSize(self) -> int: ...
    def blueBufferSize(self) -> int: ...
    def colorSpace(self) -> PySide6.QtGui.QColorSpace: ...
    @staticmethod
    def defaultFormat() -> PySide6.QtGui.QSurfaceFormat: ...
    def depthBufferSize(self) -> int: ...
    def greenBufferSize(self) -> int: ...
    def hasAlpha(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def options(self) -> PySide6.QtGui.QSurfaceFormat.FormatOption: ...
    def profile(self) -> PySide6.QtGui.QSurfaceFormat.OpenGLContextProfile: ...
    def redBufferSize(self) -> int: ...
    def renderableType(self) -> PySide6.QtGui.QSurfaceFormat.RenderableType: ...
    def samples(self) -> int: ...
    def setAlphaBufferSize(self, size: int) -> None: ...
    def setBlueBufferSize(self, size: int) -> None: ...
    @overload
    def setColorSpace(self, colorSpace: PySide6.QtGui.QSurfaceFormat.ColorSpace) -> None: ...
    @overload
    def setColorSpace(self, colorSpace: Union[PySide6.QtGui.QColorSpace, PySide6.QtGui.QColorSpace.NamedColorSpace]) -> None: ...
    @staticmethod
    def setDefaultFormat(format: Union[PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOption]) -> None: ...
    def setDepthBufferSize(self, size: int) -> None: ...
    def setGreenBufferSize(self, size: int) -> None: ...
    def setMajorVersion(self, majorVersion: int) -> None: ...
    def setMinorVersion(self, minorVersion: int) -> None: ...
    def setOption(self, option: PySide6.QtGui.QSurfaceFormat.FormatOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...
    def setProfile(self, profile: PySide6.QtGui.QSurfaceFormat.OpenGLContextProfile) -> None: ...
    def setRedBufferSize(self, size: int) -> None: ...
    def setRenderableType(self, type: PySide6.QtGui.QSurfaceFormat.RenderableType) -> None: ...
    def setSamples(self, numSamples: int) -> None: ...
    def setStencilBufferSize(self, size: int) -> None: ...
    def setStereo(self, enable: bool) -> None: ...
    def setSwapBehavior(self, behavior: PySide6.QtGui.QSurfaceFormat.SwapBehavior) -> None: ...
    def setSwapInterval(self, interval: int) -> None: ...
    def setVersion(self, major: int, minor: int) -> None: ...
    def stencilBufferSize(self) -> int: ...
    def stereo(self) -> bool: ...
    def swapBehavior(self) -> PySide6.QtGui.QSurfaceFormat.SwapBehavior: ...
    def swapInterval(self) -> int: ...
    def testOption(self, option: PySide6.QtGui.QSurfaceFormat.FormatOption) -> bool: ...
    def version(self) -> Tuple[int, int]: ...


class QSyntaxHighlighter(PySide6.QtCore.QObject):

    @overload
    def __init__(self, parent: PySide6.QtCore.QObject) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtGui.QTextDocument) -> None: ...

    def currentBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def currentBlockState(self) -> int: ...
    def currentBlockUserData(self) -> PySide6.QtGui.QTextBlockUserData: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def format(self, pos: int) -> PySide6.QtGui.QTextCharFormat: ...
    def highlightBlock(self, text: str) -> None: ...
    def previousBlockState(self) -> int: ...
    def rehighlight(self) -> None: ...
    def rehighlightBlock(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def setCurrentBlockState(self, newState: int) -> None: ...
    def setCurrentBlockUserData(self, data: PySide6.QtGui.QTextBlockUserData) -> None: ...
    def setDocument(self, doc: PySide6.QtGui.QTextDocument) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, format: PySide6.QtGui.QTextCharFormat) -> None: ...


class QTabletEvent(PySide6.QtGui.QSinglePointEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QTabletEvent) -> None: ...
    @overload
    def __init__(self, t: PySide6.QtCore.QEvent.Type, device: PySide6.QtGui.QPointingDevice, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], pressure: float, xTilt: float, yTilt: float, tangentialPressure: float, rotation: float, z: float, keyState: PySide6.QtCore.Qt.KeyboardModifier, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QTabletEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalPosF(self) -> PySide6.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def hiResGlobalX(self) -> float: ...
    def hiResGlobalY(self) -> float: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def posF(self) -> PySide6.QtCore.QPointF: ...
    def pressure(self) -> float: ...
    def rotation(self) -> float: ...
    def tangentialPressure(self) -> float: ...
    def uniqueId(self) -> int: ...
    def x(self) -> int: ...
    def xTilt(self) -> float: ...
    def y(self) -> int: ...
    def yTilt(self) -> float: ...
    def z(self) -> float: ...


class QTextBlock(Shiboken.Object):

    class iterator(Shiboken.Object):

        def __init__(self) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def __iadd__(self, arg__1: int) -> PySide6.QtGui.QTextBlock.iterator: ...
        def __isub__(self, arg__1: int) -> PySide6.QtGui.QTextBlock.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def fragment(self) -> PySide6.QtGui.QTextFragment: ...


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: PySide6.QtGui.QTextBlock) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __iter__(self) -> object: ...
    def begin(self) -> PySide6.QtGui.QTextBlock.iterator: ...
    def blockFormat(self) -> PySide6.QtGui.QTextBlockFormat: ...
    def blockFormatIndex(self) -> int: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def clearLayout(self) -> None: ...
    def contains(self, position: int) -> bool: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def end(self) -> PySide6.QtGui.QTextBlock.iterator: ...
    def firstLineNumber(self) -> int: ...
    def fragmentIndex(self) -> int: ...
    def isValid(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def layout(self) -> PySide6.QtGui.QTextLayout: ...
    def length(self) -> int: ...
    def lineCount(self) -> int: ...
    def next(self) -> PySide6.QtGui.QTextBlock: ...
    def position(self) -> int: ...
    def previous(self) -> PySide6.QtGui.QTextBlock: ...
    def revision(self) -> int: ...
    def setLineCount(self, count: int) -> None: ...
    def setRevision(self, rev: int) -> None: ...
    def setUserData(self, data: PySide6.QtGui.QTextBlockUserData) -> None: ...
    def setUserState(self, state: int) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def textFormats(self) -> List[PySide6.QtGui.QTextLayout.FormatRange]: ...
    def textList(self) -> PySide6.QtGui.QTextList: ...
    def userData(self) -> PySide6.QtGui.QTextBlockUserData: ...
    def userState(self) -> int: ...


class QTextBlockFormat(PySide6.QtGui.QTextFormat):

    class LineHeightTypes(enum.Enum):

        SingleHeight             : QTextBlockFormat.LineHeightTypes = ... # 0x0
        ProportionalHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x1
        FixedHeight              : QTextBlockFormat.LineHeightTypes = ... # 0x2
        MinimumHeight            : QTextBlockFormat.LineHeightTypes = ... # 0x3
        LineDistanceHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x4


    class MarkerType(enum.Enum):

        NoMarker                 : QTextBlockFormat.MarkerType = ... # 0x0
        Unchecked                : QTextBlockFormat.MarkerType = ... # 0x1
        Checked                  : QTextBlockFormat.MarkerType = ... # 0x2


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextBlockFormat: PySide6.QtGui.QTextBlockFormat) -> None: ...
    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def bottomMargin(self) -> float: ...
    def headingLevel(self) -> int: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    @overload
    def lineHeight(self) -> float: ...
    @overload
    def lineHeight(self, scriptLineHeight: float, scaling: float) -> float: ...
    def lineHeightType(self) -> int: ...
    def marker(self) -> PySide6.QtGui.QTextBlockFormat.MarkerType: ...
    def nonBreakableLines(self) -> bool: ...
    def pageBreakPolicy(self) -> PySide6.QtGui.QTextFormat.PageBreakFlag: ...
    def rightMargin(self) -> float: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setBottomMargin(self, margin: float) -> None: ...
    def setHeadingLevel(self, alevel: int) -> None: ...
    def setIndent(self, indent: int) -> None: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def setLineHeight(self, height: float, heightType: int) -> None: ...
    def setMarker(self, marker: PySide6.QtGui.QTextBlockFormat.MarkerType) -> None: ...
    def setNonBreakableLines(self, b: bool) -> None: ...
    def setPageBreakPolicy(self, flags: PySide6.QtGui.QTextFormat.PageBreakFlag) -> None: ...
    def setRightMargin(self, margin: float) -> None: ...
    def setTabPositions(self, tabs: Sequence[PySide6.QtGui.QTextOption.Tab]) -> None: ...
    def setTextIndent(self, aindent: float) -> None: ...
    def setTopMargin(self, margin: float) -> None: ...
    def tabPositions(self) -> List[PySide6.QtGui.QTextOption.Tab]: ...
    def textIndent(self) -> float: ...
    def topMargin(self) -> float: ...


class QTextBlockGroup(PySide6.QtGui.QTextObject):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def blockFormatChanged(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def blockInserted(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def blockList(self) -> List[PySide6.QtGui.QTextBlock]: ...
    def blockRemoved(self, block: PySide6.QtGui.QTextBlock) -> None: ...


class QTextBlockUserData(Shiboken.Object):

    def __init__(self) -> None: ...


class QTextCharFormat(PySide6.QtGui.QTextFormat):

    class FontPropertiesInheritanceBehavior(enum.Enum):

        FontPropertiesSpecifiedOnly: QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x0
        FontPropertiesAll        : QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x1


    class UnderlineStyle(enum.Enum):

        NoUnderline              : QTextCharFormat.UnderlineStyle = ... # 0x0
        SingleUnderline          : QTextCharFormat.UnderlineStyle = ... # 0x1
        DashUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x2
        DotLine                  : QTextCharFormat.UnderlineStyle = ... # 0x3
        DashDotLine              : QTextCharFormat.UnderlineStyle = ... # 0x4
        DashDotDotLine           : QTextCharFormat.UnderlineStyle = ... # 0x5
        WaveUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x6
        SpellCheckUnderline      : QTextCharFormat.UnderlineStyle = ... # 0x7


    class VerticalAlignment(enum.Enum):

        AlignNormal              : QTextCharFormat.VerticalAlignment = ... # 0x0
        AlignSuperScript         : QTextCharFormat.VerticalAlignment = ... # 0x1
        AlignSubScript           : QTextCharFormat.VerticalAlignment = ... # 0x2
        AlignMiddle              : QTextCharFormat.VerticalAlignment = ... # 0x3
        AlignTop                 : QTextCharFormat.VerticalAlignment = ... # 0x4
        AlignBottom              : QTextCharFormat.VerticalAlignment = ... # 0x5
        AlignBaseline            : QTextCharFormat.VerticalAlignment = ... # 0x6


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextCharFormat: PySide6.QtGui.QTextCharFormat) -> None: ...
    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def anchorHref(self) -> str: ...
    def anchorNames(self) -> List[str]: ...
    def baselineOffset(self) -> float: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def fontCapitalization(self) -> PySide6.QtGui.QFont.Capitalization: ...
    def fontFamilies(self) -> Any: ...
    def fontFamily(self) -> str: ...
    def fontFixedPitch(self) -> bool: ...
    def fontHintingPreference(self) -> PySide6.QtGui.QFont.HintingPreference: ...
    def fontItalic(self) -> bool: ...
    def fontKerning(self) -> bool: ...
    def fontLetterSpacing(self) -> float: ...
    def fontLetterSpacingType(self) -> PySide6.QtGui.QFont.SpacingType: ...
    def fontOverline(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontStretch(self) -> int: ...
    def fontStrikeOut(self) -> bool: ...
    def fontStyleHint(self) -> PySide6.QtGui.QFont.StyleHint: ...
    def fontStyleName(self) -> Any: ...
    def fontStyleStrategy(self) -> PySide6.QtGui.QFont.StyleStrategy: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def fontWordSpacing(self) -> float: ...
    def isAnchor(self) -> bool: ...
    def isValid(self) -> bool: ...
    def setAnchor(self, anchor: bool) -> None: ...
    def setAnchorHref(self, value: str) -> None: ...
    def setAnchorNames(self, names: Sequence[str]) -> None: ...
    def setBaselineOffset(self, baseline: float) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]], behavior: PySide6.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior = ...) -> None: ...
    def setFontCapitalization(self, capitalization: PySide6.QtGui.QFont.Capitalization) -> None: ...
    def setFontFamilies(self, families: Sequence[str]) -> None: ...
    def setFontFamily(self, family: str) -> None: ...
    def setFontFixedPitch(self, fixedPitch: bool) -> None: ...
    def setFontHintingPreference(self, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def setFontItalic(self, italic: bool) -> None: ...
    def setFontKerning(self, enable: bool) -> None: ...
    def setFontLetterSpacing(self, spacing: float) -> None: ...
    def setFontLetterSpacingType(self, letterSpacingType: PySide6.QtGui.QFont.SpacingType) -> None: ...
    def setFontOverline(self, overline: bool) -> None: ...
    def setFontPointSize(self, size: float) -> None: ...
    def setFontStretch(self, factor: int) -> None: ...
    def setFontStrikeOut(self, strikeOut: bool) -> None: ...
    def setFontStyleHint(self, hint: PySide6.QtGui.QFont.StyleHint, strategy: PySide6.QtGui.QFont.StyleStrategy = ...) -> None: ...
    def setFontStyleName(self, styleName: str) -> None: ...
    def setFontStyleStrategy(self, strategy: PySide6.QtGui.QFont.StyleStrategy) -> None: ...
    def setFontUnderline(self, underline: bool) -> None: ...
    def setFontWeight(self, weight: int) -> None: ...
    def setFontWordSpacing(self, spacing: float) -> None: ...
    def setSubScriptBaseline(self, baseline: float) -> None: ...
    def setSuperScriptBaseline(self, baseline: float) -> None: ...
    def setTableCellColumnSpan(self, tableCellColumnSpan: int) -> None: ...
    def setTableCellRowSpan(self, tableCellRowSpan: int) -> None: ...
    def setTextOutline(self, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setUnderlineColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setUnderlineStyle(self, style: PySide6.QtGui.QTextCharFormat.UnderlineStyle) -> None: ...
    def setVerticalAlignment(self, alignment: PySide6.QtGui.QTextCharFormat.VerticalAlignment) -> None: ...
    def subScriptBaseline(self) -> float: ...
    def superScriptBaseline(self) -> float: ...
    def tableCellColumnSpan(self) -> int: ...
    def tableCellRowSpan(self) -> int: ...
    def textOutline(self) -> PySide6.QtGui.QPen: ...
    def toolTip(self) -> str: ...
    def underlineColor(self) -> PySide6.QtGui.QColor: ...
    def underlineStyle(self) -> PySide6.QtGui.QTextCharFormat.UnderlineStyle: ...
    def verticalAlignment(self) -> PySide6.QtGui.QTextCharFormat.VerticalAlignment: ...


class QTextCursor(Shiboken.Object):

    class MoveMode(enum.Enum):

        MoveAnchor               : QTextCursor.MoveMode = ... # 0x0
        KeepAnchor               : QTextCursor.MoveMode = ... # 0x1


    class MoveOperation(enum.Enum):

        NoMove                   : QTextCursor.MoveOperation = ... # 0x0
        Start                    : QTextCursor.MoveOperation = ... # 0x1
        Up                       : QTextCursor.MoveOperation = ... # 0x2
        StartOfLine              : QTextCursor.MoveOperation = ... # 0x3
        StartOfBlock             : QTextCursor.MoveOperation = ... # 0x4
        StartOfWord              : QTextCursor.MoveOperation = ... # 0x5
        PreviousBlock            : QTextCursor.MoveOperation = ... # 0x6
        PreviousCharacter        : QTextCursor.MoveOperation = ... # 0x7
        PreviousWord             : QTextCursor.MoveOperation = ... # 0x8
        Left                     : QTextCursor.MoveOperation = ... # 0x9
        WordLeft                 : QTextCursor.MoveOperation = ... # 0xa
        End                      : QTextCursor.MoveOperation = ... # 0xb
        Down                     : QTextCursor.MoveOperation = ... # 0xc
        EndOfLine                : QTextCursor.MoveOperation = ... # 0xd
        EndOfWord                : QTextCursor.MoveOperation = ... # 0xe
        EndOfBlock               : QTextCursor.MoveOperation = ... # 0xf
        NextBlock                : QTextCursor.MoveOperation = ... # 0x10
        NextCharacter            : QTextCursor.MoveOperation = ... # 0x11
        NextWord                 : QTextCursor.MoveOperation = ... # 0x12
        Right                    : QTextCursor.MoveOperation = ... # 0x13
        WordRight                : QTextCursor.MoveOperation = ... # 0x14
        NextCell                 : QTextCursor.MoveOperation = ... # 0x15
        PreviousCell             : QTextCursor.MoveOperation = ... # 0x16
        NextRow                  : QTextCursor.MoveOperation = ... # 0x17
        PreviousRow              : QTextCursor.MoveOperation = ... # 0x18


    class SelectionType(enum.Enum):

        WordUnderCursor          : QTextCursor.SelectionType = ... # 0x0
        LineUnderCursor          : QTextCursor.SelectionType = ... # 0x1
        BlockUnderCursor         : QTextCursor.SelectionType = ... # 0x2
        Document                 : QTextCursor.SelectionType = ... # 0x3


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    @overload
    def __init__(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    @overload
    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None: ...
    @overload
    def __init__(self, frame: PySide6.QtGui.QTextFrame) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def anchor(self) -> int: ...
    def atBlockEnd(self) -> bool: ...
    def atBlockStart(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def atStart(self) -> bool: ...
    def beginEditBlock(self) -> None: ...
    def block(self) -> PySide6.QtGui.QTextBlock: ...
    def blockCharFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def blockFormat(self) -> PySide6.QtGui.QTextBlockFormat: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def clearSelection(self) -> None: ...
    def columnNumber(self) -> int: ...
    @overload
    def createList(self, format: PySide6.QtGui.QTextListFormat) -> PySide6.QtGui.QTextList: ...
    @overload
    def createList(self, style: PySide6.QtGui.QTextListFormat.Style) -> PySide6.QtGui.QTextList: ...
    def currentFrame(self) -> PySide6.QtGui.QTextFrame: ...
    def currentList(self) -> PySide6.QtGui.QTextList: ...
    def currentTable(self) -> PySide6.QtGui.QTextTable: ...
    def deleteChar(self) -> None: ...
    def deletePreviousChar(self) -> None: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def endEditBlock(self) -> None: ...
    def hasComplexSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    @overload
    def insertBlock(self) -> None: ...
    @overload
    def insertBlock(self, format: PySide6.QtGui.QTextBlockFormat) -> None: ...
    @overload
    def insertBlock(self, format: PySide6.QtGui.QTextBlockFormat, charFormat: PySide6.QtGui.QTextCharFormat) -> None: ...
    def insertFragment(self, fragment: PySide6.QtGui.QTextDocumentFragment) -> None: ...
    def insertFrame(self, format: PySide6.QtGui.QTextFrameFormat) -> PySide6.QtGui.QTextFrame: ...
    def insertHtml(self, html: str) -> None: ...
    @overload
    def insertImage(self, format: PySide6.QtGui.QTextImageFormat) -> None: ...
    @overload
    def insertImage(self, format: PySide6.QtGui.QTextImageFormat, alignment: PySide6.QtGui.QTextFrameFormat.Position) -> None: ...
    @overload
    def insertImage(self, image: Union[PySide6.QtGui.QImage, str], name: str = ...) -> None: ...
    @overload
    def insertImage(self, name: str) -> None: ...
    @overload
    def insertList(self, format: PySide6.QtGui.QTextListFormat) -> PySide6.QtGui.QTextList: ...
    @overload
    def insertList(self, style: PySide6.QtGui.QTextListFormat.Style) -> PySide6.QtGui.QTextList: ...
    def insertMarkdown(self, markdown: str, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> None: ...
    @overload
    def insertTable(self, rows: int, cols: int) -> PySide6.QtGui.QTextTable: ...
    @overload
    def insertTable(self, rows: int, cols: int, format: PySide6.QtGui.QTextTableFormat) -> PySide6.QtGui.QTextTable: ...
    @overload
    def insertText(self, text: str) -> None: ...
    @overload
    def insertText(self, text: str, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def isCopyOf(self, other: PySide6.QtGui.QTextCursor) -> bool: ...
    def isNull(self) -> bool: ...
    def joinPreviousEditBlock(self) -> None: ...
    def keepPositionOnInsert(self) -> bool: ...
    def mergeBlockCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None: ...
    def mergeBlockFormat(self, modifier: PySide6.QtGui.QTextBlockFormat) -> None: ...
    def mergeCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None: ...
    def movePosition(self, op: PySide6.QtGui.QTextCursor.MoveOperation, arg__2: PySide6.QtGui.QTextCursor.MoveMode = ..., n: int = ...) -> bool: ...
    def position(self) -> int: ...
    def positionInBlock(self) -> int: ...
    def removeSelectedText(self) -> None: ...
    def select(self, selection: PySide6.QtGui.QTextCursor.SelectionType) -> None: ...
    def selectedTableCells(self) -> object: ...
    def selectedText(self) -> str: ...
    def selection(self) -> PySide6.QtGui.QTextDocumentFragment: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setBlockCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setBlockFormat(self, format: PySide6.QtGui.QTextBlockFormat) -> None: ...
    def setCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setKeepPositionOnInsert(self, b: bool) -> None: ...
    def setPosition(self, pos: int, mode: PySide6.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def setVerticalMovementX(self, x: int) -> None: ...
    def setVisualNavigation(self, b: bool) -> None: ...
    def swap(self, other: PySide6.QtGui.QTextCursor) -> None: ...
    def verticalMovementX(self) -> int: ...
    def visualNavigation(self) -> bool: ...


class QTextDocument(PySide6.QtCore.QObject):

    baseUrlChanged           : ClassVar[Signal] = ... # baseUrlChanged(QUrl)
    blockCountChanged        : ClassVar[Signal] = ... # blockCountChanged(int)
    contentsChange           : ClassVar[Signal] = ... # contentsChange(int,int,int)
    contentsChanged          : ClassVar[Signal] = ... # contentsChanged()
    cursorPositionChanged    : ClassVar[Signal] = ... # cursorPositionChanged(QTextCursor)
    documentLayoutChanged    : ClassVar[Signal] = ... # documentLayoutChanged()
    modificationChanged      : ClassVar[Signal] = ... # modificationChanged(bool)
    redoAvailable            : ClassVar[Signal] = ... # redoAvailable(bool)
    undoAvailable            : ClassVar[Signal] = ... # undoAvailable(bool)
    undoCommandAdded         : ClassVar[Signal] = ... # undoCommandAdded()

    class FindFlag(enum.Flag):

        FindBackward             : QTextDocument.FindFlag = ... # 0x1
        FindCaseSensitively      : QTextDocument.FindFlag = ... # 0x2
        FindWholeWords           : QTextDocument.FindFlag = ... # 0x4


    class MarkdownFeature(enum.Flag):

        MarkdownDialectCommonMark: QTextDocument.MarkdownFeature = ... # 0x0
        MarkdownNoHTML           : QTextDocument.MarkdownFeature = ... # 0x60
        MarkdownDialectGitHub    : QTextDocument.MarkdownFeature = ... # 0x4f0c


    class MetaInformation(enum.Enum):

        DocumentTitle            : QTextDocument.MetaInformation = ... # 0x0
        DocumentUrl              : QTextDocument.MetaInformation = ... # 0x1
        CssMedia                 : QTextDocument.MetaInformation = ... # 0x2


    class ResourceType(enum.IntEnum):

        UnknownResource          : QTextDocument.ResourceType = ... # 0x0
        HtmlResource             : QTextDocument.ResourceType = ... # 0x1
        ImageResource            : QTextDocument.ResourceType = ... # 0x2
        StyleSheetResource       : QTextDocument.ResourceType = ... # 0x3
        MarkdownResource         : QTextDocument.ResourceType = ... # 0x4
        UserResource             : QTextDocument.ResourceType = ... # 0x64


    class Stacks(enum.Enum):

        UndoStack                : QTextDocument.Stacks = ... # 0x1
        RedoStack                : QTextDocument.Stacks = ... # 0x2
        UndoAndRedoStacks        : QTextDocument.Stacks = ... # 0x3


    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def addResource(self, type: int, name: Union[PySide6.QtCore.QUrl, str], resource: Any) -> None: ...
    def adjustSize(self) -> None: ...
    def allFormats(self) -> List[PySide6.QtGui.QTextFormat]: ...
    def availableRedoSteps(self) -> int: ...
    def availableUndoSteps(self) -> int: ...
    def baseUrl(self) -> PySide6.QtCore.QUrl: ...
    def baselineOffset(self) -> float: ...
    def begin(self) -> PySide6.QtGui.QTextBlock: ...
    def blockCount(self) -> int: ...
    def characterAt(self, pos: int) -> str: ...
    def characterCount(self) -> int: ...
    def clear(self) -> None: ...
    def clearUndoRedoStacks(self, historyToClear: PySide6.QtGui.QTextDocument.Stacks = ...) -> None: ...
    def clone(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> PySide6.QtGui.QTextDocument: ...
    def createObject(self, f: PySide6.QtGui.QTextFormat) -> PySide6.QtGui.QTextObject: ...
    def defaultCursorMoveStyle(self) -> PySide6.QtCore.Qt.CursorMoveStyle: ...
    def defaultFont(self) -> PySide6.QtGui.QFont: ...
    def defaultStyleSheet(self) -> str: ...
    def defaultTextOption(self) -> PySide6.QtGui.QTextOption: ...
    def documentLayout(self) -> PySide6.QtGui.QAbstractTextDocumentLayout: ...
    def documentMargin(self) -> float: ...
    def drawContents(self, painter: PySide6.QtGui.QPainter, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...) -> None: ...
    def end(self) -> PySide6.QtGui.QTextBlock: ...
    @overload
    def find(self, expr: Union[PySide6.QtCore.QRegularExpression, str], cursor: PySide6.QtGui.QTextCursor, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    @overload
    def find(self, expr: Union[PySide6.QtCore.QRegularExpression, str], from_: int = ..., options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    @overload
    def find(self, subString: str, cursor: PySide6.QtGui.QTextCursor, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    @overload
    def find(self, subString: str, from_: int = ..., options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    def findBlock(self, pos: int) -> PySide6.QtGui.QTextBlock: ...
    def findBlockByLineNumber(self, blockNumber: int) -> PySide6.QtGui.QTextBlock: ...
    def findBlockByNumber(self, blockNumber: int) -> PySide6.QtGui.QTextBlock: ...
    def firstBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def frameAt(self, pos: int) -> PySide6.QtGui.QTextFrame: ...
    def idealWidth(self) -> float: ...
    def indentWidth(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isLayoutEnabled(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def lastBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def lineCount(self) -> int: ...
    def loadResource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any: ...
    def markContentsDirty(self, from_: int, length: int) -> None: ...
    def maximumBlockCount(self) -> int: ...
    def metaInformation(self, info: PySide6.QtGui.QTextDocument.MetaInformation) -> str: ...
    def object(self, objectIndex: int) -> PySide6.QtGui.QTextObject: ...
    def objectForFormat(self, arg__1: PySide6.QtGui.QTextFormat) -> PySide6.QtGui.QTextObject: ...
    def pageCount(self) -> int: ...
    def pageSize(self) -> PySide6.QtCore.QSizeF: ...
    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice) -> None: ...
    @overload
    def redo(self) -> None: ...
    @overload
    def redo(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def resource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any: ...
    def revision(self) -> int: ...
    def rootFrame(self) -> PySide6.QtGui.QTextFrame: ...
    def setBaseUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def setBaselineOffset(self, baseline: float) -> None: ...
    def setDefaultCursorMoveStyle(self, style: PySide6.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setDefaultFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setDefaultStyleSheet(self, sheet: str) -> None: ...
    def setDefaultTextOption(self, option: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setDocumentLayout(self, layout: PySide6.QtGui.QAbstractTextDocumentLayout) -> None: ...
    def setDocumentMargin(self, margin: float) -> None: ...
    def setHtml(self, html: str) -> None: ...
    def setIndentWidth(self, width: float) -> None: ...
    def setLayoutEnabled(self, b: bool) -> None: ...
    def setMarkdown(self, markdown: str, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> None: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setMetaInformation(self, info: PySide6.QtGui.QTextDocument.MetaInformation, arg__2: str) -> None: ...
    def setModified(self, m: bool = ...) -> None: ...
    def setPageSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setSubScriptBaseline(self, baseline: float) -> None: ...
    def setSuperScriptBaseline(self, baseline: float) -> None: ...
    def setTextWidth(self, width: float) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def subScriptBaseline(self) -> float: ...
    def superScriptBaseline(self) -> float: ...
    def textWidth(self) -> float: ...
    def toHtml(self) -> str: ...
    def toMarkdown(self, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def toRawText(self) -> str: ...
    @overload
    def undo(self) -> None: ...
    @overload
    def undo(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def useDesignMetrics(self) -> bool: ...


class QTextDocumentFragment(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None: ...
    @overload
    def __init__(self, range: PySide6.QtGui.QTextCursor) -> None: ...
    @overload
    def __init__(self, rhs: PySide6.QtGui.QTextDocumentFragment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromHtml(html: str, resourceProvider: Optional[PySide6.QtGui.QTextDocument] = ...) -> PySide6.QtGui.QTextDocumentFragment: ...
    @staticmethod
    def fromMarkdown(markdown: str, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> PySide6.QtGui.QTextDocumentFragment: ...
    @staticmethod
    def fromPlainText(plainText: str) -> PySide6.QtGui.QTextDocumentFragment: ...
    def isEmpty(self) -> bool: ...
    def toHtml(self) -> str: ...
    def toMarkdown(self, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def toRawText(self) -> str: ...


class QTextDocumentWriter(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: Union[PySide6.QtCore.QByteArray, bytes] = ...) -> None: ...

    def device(self) -> PySide6.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None: ...
    @staticmethod
    def supportedDocumentFormats() -> List[PySide6.QtCore.QByteArray]: ...
    @overload
    def write(self, document: PySide6.QtGui.QTextDocument) -> bool: ...
    @overload
    def write(self, fragment: PySide6.QtGui.QTextDocumentFragment) -> bool: ...


class QTextFormat(Shiboken.Object):

    class FormatType(enum.IntEnum):

        InvalidFormat            : QTextFormat.FormatType = ... # -0x1
        BlockFormat              : QTextFormat.FormatType = ... # 0x1
        CharFormat               : QTextFormat.FormatType = ... # 0x2
        ListFormat               : QTextFormat.FormatType = ... # 0x3
        FrameFormat              : QTextFormat.FormatType = ... # 0x5
        UserFormat               : QTextFormat.FormatType = ... # 0x64


    class ObjectTypes(enum.IntEnum):

        NoObject                 : QTextFormat.ObjectTypes = ... # 0x0
        ImageObject              : QTextFormat.ObjectTypes = ... # 0x1
        TableObject              : QTextFormat.ObjectTypes = ... # 0x2
        TableCellObject          : QTextFormat.ObjectTypes = ... # 0x3
        UserObject               : QTextFormat.ObjectTypes = ... # 0x1000


    class PageBreakFlag(enum.Flag):

        PageBreak_Auto           : QTextFormat.PageBreakFlag = ... # 0x0
        PageBreak_AlwaysBefore   : QTextFormat.PageBreakFlag = ... # 0x1
        PageBreak_AlwaysAfter    : QTextFormat.PageBreakFlag = ... # 0x10


    class Property(enum.IntEnum):

        ObjectIndex              : QTextFormat.Property = ... # 0x0
        CssFloat                 : QTextFormat.Property = ... # 0x800
        LayoutDirection          : QTextFormat.Property = ... # 0x801
        OutlinePen               : QTextFormat.Property = ... # 0x810
        BackgroundBrush          : QTextFormat.Property = ... # 0x820
        ForegroundBrush          : QTextFormat.Property = ... # 0x821
        BackgroundImageUrl       : QTextFormat.Property = ... # 0x823
        BlockAlignment           : QTextFormat.Property = ... # 0x1010
        BlockTopMargin           : QTextFormat.Property = ... # 0x1030
        BlockBottomMargin        : QTextFormat.Property = ... # 0x1031
        BlockLeftMargin          : QTextFormat.Property = ... # 0x1032
        BlockRightMargin         : QTextFormat.Property = ... # 0x1033
        TextIndent               : QTextFormat.Property = ... # 0x1034
        TabPositions             : QTextFormat.Property = ... # 0x1035
        BlockIndent              : QTextFormat.Property = ... # 0x1040
        LineHeight               : QTextFormat.Property = ... # 0x1048
        LineHeightType           : QTextFormat.Property = ... # 0x1049
        BlockNonBreakableLines   : QTextFormat.Property = ... # 0x1050
        BlockTrailingHorizontalRulerWidth: QTextFormat.Property = ... # 0x1060
        HeadingLevel             : QTextFormat.Property = ... # 0x1070
        BlockQuoteLevel          : QTextFormat.Property = ... # 0x1080
        BlockCodeLanguage        : QTextFormat.Property = ... # 0x1090
        BlockCodeFence           : QTextFormat.Property = ... # 0x1091
        BlockMarker              : QTextFormat.Property = ... # 0x10a0
        FirstFontProperty        : QTextFormat.Property = ... # 0x1fe0
        FontCapitalization       : QTextFormat.Property = ... # 0x1fe0
        FontLetterSpacing        : QTextFormat.Property = ... # 0x1fe1
        FontWordSpacing          : QTextFormat.Property = ... # 0x1fe2
        FontStyleHint            : QTextFormat.Property = ... # 0x1fe3
        FontStyleStrategy        : QTextFormat.Property = ... # 0x1fe4
        FontKerning              : QTextFormat.Property = ... # 0x1fe5
        FontHintingPreference    : QTextFormat.Property = ... # 0x1fe6
        FontFamilies             : QTextFormat.Property = ... # 0x1fe7
        FontStyleName            : QTextFormat.Property = ... # 0x1fe8
        FontLetterSpacingType    : QTextFormat.Property = ... # 0x1fe9
        FontStretch              : QTextFormat.Property = ... # 0x1fea
        FontFamily               : QTextFormat.Property = ... # 0x2000
        OldFontFamily            : QTextFormat.Property = ... # 0x2000
        FontPointSize            : QTextFormat.Property = ... # 0x2001
        FontSizeAdjustment       : QTextFormat.Property = ... # 0x2002
        FontSizeIncrement        : QTextFormat.Property = ... # 0x2002
        FontWeight               : QTextFormat.Property = ... # 0x2003
        FontItalic               : QTextFormat.Property = ... # 0x2004
        FontUnderline            : QTextFormat.Property = ... # 0x2005
        FontOverline             : QTextFormat.Property = ... # 0x2006
        FontStrikeOut            : QTextFormat.Property = ... # 0x2007
        FontFixedPitch           : QTextFormat.Property = ... # 0x2008
        FontPixelSize            : QTextFormat.Property = ... # 0x2009
        LastFontProperty         : QTextFormat.Property = ... # 0x2009
        OldTextUnderlineColor    : QTextFormat.Property = ... # 0x2010
        TextUnderlineColor       : QTextFormat.Property = ... # 0x2020
        TextVerticalAlignment    : QTextFormat.Property = ... # 0x2021
        TextOutline              : QTextFormat.Property = ... # 0x2022
        TextUnderlineStyle       : QTextFormat.Property = ... # 0x2023
        TextToolTip              : QTextFormat.Property = ... # 0x2024
        TextSuperScriptBaseline  : QTextFormat.Property = ... # 0x2025
        TextSubScriptBaseline    : QTextFormat.Property = ... # 0x2026
        TextBaselineOffset       : QTextFormat.Property = ... # 0x2027
        IsAnchor                 : QTextFormat.Property = ... # 0x2030
        AnchorHref               : QTextFormat.Property = ... # 0x2031
        AnchorName               : QTextFormat.Property = ... # 0x2032
        OldFontLetterSpacingType : QTextFormat.Property = ... # 0x2033
        OldFontStretch           : QTextFormat.Property = ... # 0x2034
        ObjectType               : QTextFormat.Property = ... # 0x2f00
        ListStyle                : QTextFormat.Property = ... # 0x3000
        ListIndent               : QTextFormat.Property = ... # 0x3001
        ListNumberPrefix         : QTextFormat.Property = ... # 0x3002
        ListNumberSuffix         : QTextFormat.Property = ... # 0x3003
        FrameBorder              : QTextFormat.Property = ... # 0x4000
        FrameMargin              : QTextFormat.Property = ... # 0x4001
        FramePadding             : QTextFormat.Property = ... # 0x4002
        FrameWidth               : QTextFormat.Property = ... # 0x4003
        FrameHeight              : QTextFormat.Property = ... # 0x4004
        FrameTopMargin           : QTextFormat.Property = ... # 0x4005
        FrameBottomMargin        : QTextFormat.Property = ... # 0x4006
        FrameLeftMargin          : QTextFormat.Property = ... # 0x4007
        FrameRightMargin         : QTextFormat.Property = ... # 0x4008
        FrameBorderBrush         : QTextFormat.Property = ... # 0x4009
        FrameBorderStyle         : QTextFormat.Property = ... # 0x4010
        TableColumns             : QTextFormat.Property = ... # 0x4100
        TableColumnWidthConstraints: QTextFormat.Property = ... # 0x4101
        TableCellSpacing         : QTextFormat.Property = ... # 0x4102
        TableCellPadding         : QTextFormat.Property = ... # 0x4103
        TableHeaderRowCount      : QTextFormat.Property = ... # 0x4104
        TableBorderCollapse      : QTextFormat.Property = ... # 0x4105
        TableCellRowSpan         : QTextFormat.Property = ... # 0x4810
        TableCellColumnSpan      : QTextFormat.Property = ... # 0x4811
        TableCellTopPadding      : QTextFormat.Property = ... # 0x4812
        TableCellBottomPadding   : QTextFormat.Property = ... # 0x4813
        TableCellLeftPadding     : QTextFormat.Property = ... # 0x4814
        TableCellRightPadding    : QTextFormat.Property = ... # 0x4815
        TableCellTopBorder       : QTextFormat.Property = ... # 0x4816
        TableCellBottomBorder    : QTextFormat.Property = ... # 0x4817
        TableCellLeftBorder      : QTextFormat.Property = ... # 0x4818
        TableCellRightBorder     : QTextFormat.Property = ... # 0x4819
        TableCellTopBorderStyle  : QTextFormat.Property = ... # 0x481a
        TableCellBottomBorderStyle: QTextFormat.Property = ... # 0x481b
        TableCellLeftBorderStyle : QTextFormat.Property = ... # 0x481c
        TableCellRightBorderStyle: QTextFormat.Property = ... # 0x481d
        TableCellTopBorderBrush  : QTextFormat.Property = ... # 0x481e
        TableCellBottomBorderBrush: QTextFormat.Property = ... # 0x481f
        TableCellLeftBorderBrush : QTextFormat.Property = ... # 0x4820
        TableCellRightBorderBrush: QTextFormat.Property = ... # 0x4821
        ImageName                : QTextFormat.Property = ... # 0x5000
        ImageTitle               : QTextFormat.Property = ... # 0x5001
        ImageAltText             : QTextFormat.Property = ... # 0x5002
        ImageWidth               : QTextFormat.Property = ... # 0x5010
        ImageHeight              : QTextFormat.Property = ... # 0x5011
        ImageQuality             : QTextFormat.Property = ... # 0x5014
        FullWidthSelection       : QTextFormat.Property = ... # 0x6000
        PageBreakPolicy          : QTextFormat.Property = ... # 0x7000
        UserProperty             : QTextFormat.Property = ... # 0x100000


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, rhs: PySide6.QtGui.QTextFormat) -> None: ...
    @overload
    def __init__(self, type: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def boolProperty(self, propertyId: int) -> bool: ...
    def brushProperty(self, propertyId: int) -> PySide6.QtGui.QBrush: ...
    def clearBackground(self) -> None: ...
    def clearForeground(self) -> None: ...
    def clearProperty(self, propertyId: int) -> None: ...
    def colorProperty(self, propertyId: int) -> PySide6.QtGui.QColor: ...
    def doubleProperty(self, propertyId: int) -> float: ...
    def foreground(self) -> PySide6.QtGui.QBrush: ...
    def hasProperty(self, propertyId: int) -> bool: ...
    def intProperty(self, propertyId: int) -> int: ...
    def isBlockFormat(self) -> bool: ...
    def isCharFormat(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isFrameFormat(self) -> bool: ...
    def isImageFormat(self) -> bool: ...
    def isListFormat(self) -> bool: ...
    def isTableCellFormat(self) -> bool: ...
    def isTableFormat(self) -> bool: ...
    def isValid(self) -> bool: ...
    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def lengthProperty(self, propertyId: int) -> PySide6.QtGui.QTextLength: ...
    def lengthVectorProperty(self, propertyId: int) -> List[PySide6.QtGui.QTextLength]: ...
    def merge(self, other: PySide6.QtGui.QTextFormat) -> None: ...
    def objectIndex(self) -> int: ...
    def objectType(self) -> int: ...
    def penProperty(self, propertyId: int) -> PySide6.QtGui.QPen: ...
    def properties(self) -> Dict[int, Any]: ...
    def property(self, propertyId: int) -> Any: ...
    def propertyCount(self) -> int: ...
    def setBackground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setForeground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setObjectIndex(self, object: int) -> None: ...
    def setObjectType(self, type: int) -> None: ...
    @overload
    def setProperty(self, propertyId: int, lengths: Sequence[PySide6.QtGui.QTextLength]) -> None: ...
    @overload
    def setProperty(self, propertyId: int, value: Any) -> None: ...
    def stringProperty(self, propertyId: int) -> str: ...
    def swap(self, other: PySide6.QtGui.QTextFormat) -> None: ...
    def toBlockFormat(self) -> PySide6.QtGui.QTextBlockFormat: ...
    def toCharFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def toFrameFormat(self) -> PySide6.QtGui.QTextFrameFormat: ...
    def toImageFormat(self) -> PySide6.QtGui.QTextImageFormat: ...
    def toListFormat(self) -> PySide6.QtGui.QTextListFormat: ...
    def toTableCellFormat(self) -> PySide6.QtGui.QTextTableCellFormat: ...
    def toTableFormat(self) -> PySide6.QtGui.QTextTableFormat: ...
    def type(self) -> int: ...


class QTextFragment(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: PySide6.QtGui.QTextFragment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def charFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def contains(self, position: int) -> bool: ...
    def glyphRuns(self, from_: int = ..., length: int = ...) -> List[PySide6.QtGui.QGlyphRun]: ...
    def isValid(self) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def text(self) -> str: ...


class QTextFrame(PySide6.QtGui.QTextObject):

    class iterator(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, iterator: PySide6.QtGui.QTextFrame.iterator) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def __iadd__(self, arg__1: int) -> PySide6.QtGui.QTextFrame.iterator: ...
        def __isub__(self, arg__1: int) -> PySide6.QtGui.QTextFrame.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def currentBlock(self) -> PySide6.QtGui.QTextBlock: ...
        def currentFrame(self) -> PySide6.QtGui.QTextFrame: ...
        def parentFrame(self) -> PySide6.QtGui.QTextFrame: ...


    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def __iter__(self) -> object: ...
    def begin(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def childFrames(self) -> List[PySide6.QtGui.QTextFrame]: ...
    def end(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def frameFormat(self) -> PySide6.QtGui.QTextFrameFormat: ...
    def lastCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def parentFrame(self) -> PySide6.QtGui.QTextFrame: ...
    def setFrameFormat(self, format: PySide6.QtGui.QTextFrameFormat) -> None: ...


class QTextFrameFormat(PySide6.QtGui.QTextFormat):

    class BorderStyle(enum.Enum):

        BorderStyle_None         : QTextFrameFormat.BorderStyle = ... # 0x0
        BorderStyle_Dotted       : QTextFrameFormat.BorderStyle = ... # 0x1
        BorderStyle_Dashed       : QTextFrameFormat.BorderStyle = ... # 0x2
        BorderStyle_Solid        : QTextFrameFormat.BorderStyle = ... # 0x3
        BorderStyle_Double       : QTextFrameFormat.BorderStyle = ... # 0x4
        BorderStyle_DotDash      : QTextFrameFormat.BorderStyle = ... # 0x5
        BorderStyle_DotDotDash   : QTextFrameFormat.BorderStyle = ... # 0x6
        BorderStyle_Groove       : QTextFrameFormat.BorderStyle = ... # 0x7
        BorderStyle_Ridge        : QTextFrameFormat.BorderStyle = ... # 0x8
        BorderStyle_Inset        : QTextFrameFormat.BorderStyle = ... # 0x9
        BorderStyle_Outset       : QTextFrameFormat.BorderStyle = ... # 0xa


    class Position(enum.Enum):

        InFlow                   : QTextFrameFormat.Position = ... # 0x0
        FloatLeft                : QTextFrameFormat.Position = ... # 0x1
        FloatRight               : QTextFrameFormat.Position = ... # 0x2


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextFrameFormat: PySide6.QtGui.QTextFrameFormat) -> None: ...
    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def border(self) -> float: ...
    def borderBrush(self) -> PySide6.QtGui.QBrush: ...
    def borderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def bottomMargin(self) -> float: ...
    def height(self) -> PySide6.QtGui.QTextLength: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    def margin(self) -> float: ...
    def padding(self) -> float: ...
    def pageBreakPolicy(self) -> PySide6.QtGui.QTextFormat.PageBreakFlag: ...
    def position(self) -> PySide6.QtGui.QTextFrameFormat.Position: ...
    def rightMargin(self) -> float: ...
    def setBorder(self, border: float) -> None: ...
    def setBorderBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomMargin(self, margin: float) -> None: ...
    @overload
    def setHeight(self, height: PySide6.QtGui.QTextLength) -> None: ...
    @overload
    def setHeight(self, height: float) -> None: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def setMargin(self, margin: float) -> None: ...
    def setPadding(self, padding: float) -> None: ...
    def setPageBreakPolicy(self, flags: PySide6.QtGui.QTextFormat.PageBreakFlag) -> None: ...
    def setPosition(self, f: PySide6.QtGui.QTextFrameFormat.Position) -> None: ...
    def setRightMargin(self, margin: float) -> None: ...
    def setTopMargin(self, margin: float) -> None: ...
    @overload
    def setWidth(self, length: PySide6.QtGui.QTextLength) -> None: ...
    @overload
    def setWidth(self, width: float) -> None: ...
    def topMargin(self) -> float: ...
    def width(self) -> PySide6.QtGui.QTextLength: ...


class QTextImageFormat(PySide6.QtGui.QTextCharFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextImageFormat: PySide6.QtGui.QTextImageFormat) -> None: ...
    @overload
    def __init__(self, format: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def quality(self) -> int: ...
    def setHeight(self, height: float) -> None: ...
    def setName(self, name: str) -> None: ...
    @overload
    def setQuality(self) -> None: ...
    @overload
    def setQuality(self, quality: int) -> None: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...


class QTextInlineObject(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def format(self) -> PySide6.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setAscent(self, a: float) -> None: ...
    def setDescent(self, d: float) -> None: ...
    def setWidth(self, w: float) -> None: ...
    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def textPosition(self) -> int: ...
    def width(self) -> float: ...


class QTextItem(Shiboken.Object):

    class RenderFlag(enum.Flag):

        RightToLeft              : QTextItem.RenderFlag = ... # 0x1
        Overline                 : QTextItem.RenderFlag = ... # 0x10
        Underline                : QTextItem.RenderFlag = ... # 0x20
        StrikeOut                : QTextItem.RenderFlag = ... # 0x40
        Dummy                    : QTextItem.RenderFlag = ... # 0xffffffff


    def __init__(self) -> None: ...

    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def renderFlags(self) -> PySide6.QtGui.QTextItem.RenderFlag: ...
    def text(self) -> str: ...
    def width(self) -> float: ...


class QTextLayout(Shiboken.Object):

    class CursorMode(enum.Enum):

        SkipCharacters           : QTextLayout.CursorMode = ... # 0x0
        SkipWords                : QTextLayout.CursorMode = ... # 0x1


    class FormatRange(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, FormatRange: PySide6.QtGui.QTextLayout.FormatRange) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, b: PySide6.QtGui.QTextBlock) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self, text: str, font: Union[PySide6.QtGui.QFont, str, Sequence[str]], paintdevice: Optional[PySide6.QtGui.QPaintDevice] = ...) -> None: ...

    def beginLayout(self) -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def cacheEnabled(self) -> bool: ...
    def clearFormats(self) -> None: ...
    def clearLayout(self) -> None: ...
    def createLine(self) -> PySide6.QtGui.QTextLine: ...
    def cursorMoveStyle(self) -> PySide6.QtCore.Qt.CursorMoveStyle: ...
    def draw(self, p: PySide6.QtGui.QPainter, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], selections: Sequence[PySide6.QtGui.QTextLayout.FormatRange] = ..., clip: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...) -> None: ...
    @overload
    def drawCursor(self, p: PySide6.QtGui.QPainter, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], cursorPosition: int) -> None: ...
    @overload
    def drawCursor(self, p: PySide6.QtGui.QPainter, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], cursorPosition: int, width: int) -> None: ...
    def endLayout(self) -> None: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def formats(self) -> List[PySide6.QtGui.QTextLayout.FormatRange]: ...
    def glyphRuns(self, from_: int = ..., length: int = ...) -> List[PySide6.QtGui.QGlyphRun]: ...
    def isValidCursorPosition(self, pos: int) -> bool: ...
    def leftCursorPosition(self, oldPos: int) -> int: ...
    def lineAt(self, i: int) -> PySide6.QtGui.QTextLine: ...
    def lineCount(self) -> int: ...
    def lineForTextPosition(self, pos: int) -> PySide6.QtGui.QTextLine: ...
    def maximumWidth(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def nextCursorPosition(self, oldPos: int, mode: PySide6.QtGui.QTextLayout.CursorMode = ...) -> int: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def preeditAreaPosition(self) -> int: ...
    def preeditAreaText(self) -> str: ...
    def previousCursorPosition(self, oldPos: int, mode: PySide6.QtGui.QTextLayout.CursorMode = ...) -> int: ...
    def rightCursorPosition(self, oldPos: int) -> int: ...
    def setCacheEnabled(self, enable: bool) -> None: ...
    def setCursorMoveStyle(self, style: PySide6.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setFlags(self, flags: int) -> None: ...
    def setFont(self, f: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setFormats(self, overrides: Sequence[PySide6.QtGui.QTextLayout.FormatRange]) -> None: ...
    def setPosition(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setPreeditArea(self, position: int, text: str) -> None: ...
    def setRawFont(self, rawFont: PySide6.QtGui.QRawFont) -> None: ...
    def setText(self, string: str) -> None: ...
    def setTextOption(self, option: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> None: ...
    def text(self) -> str: ...
    def textOption(self) -> PySide6.QtGui.QTextOption: ...


class QTextLength(Shiboken.Object):

    class Type(enum.Enum):

        VariableLength           : QTextLength.Type = ... # 0x0
        FixedLength              : QTextLength.Type = ... # 0x1
        PercentageLength         : QTextLength.Type = ... # 0x2


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextLength: PySide6.QtGui.QTextLength) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtGui.QTextLength.Type, value: float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def rawValue(self) -> float: ...
    def type(self) -> PySide6.QtGui.QTextLength.Type: ...
    def value(self, maximumLength: float) -> float: ...


class QTextLine(Shiboken.Object):

    class CursorPosition(enum.Enum):

        CursorBetweenCharacters  : QTextLine.CursorPosition = ... # 0x0
        CursorOnCharacter        : QTextLine.CursorPosition = ... # 0x1


    class Edge(enum.Enum):

        Leading                  : QTextLine.Edge = ... # 0x0
        Trailing                 : QTextLine.Edge = ... # 0x1


    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def cursorToX(self, cursorPos: int, edge: PySide6.QtGui.QTextLine.Edge = ...) -> object: ...
    def descent(self) -> float: ...
    def draw(self, painter: PySide6.QtGui.QPainter, position: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def glyphRuns(self, from_: int = ..., length: int = ...) -> List[PySide6.QtGui.QGlyphRun]: ...
    def height(self) -> float: ...
    def horizontalAdvance(self) -> float: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def leadingIncluded(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def naturalTextRect(self) -> PySide6.QtCore.QRectF: ...
    def naturalTextWidth(self) -> float: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setLeadingIncluded(self, included: bool) -> None: ...
    def setLineWidth(self, width: float) -> None: ...
    @overload
    def setNumColumns(self, columns: int) -> None: ...
    @overload
    def setNumColumns(self, columns: int, alignmentWidth: float) -> None: ...
    def setPosition(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def textLength(self) -> int: ...
    def textStart(self) -> int: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def xToCursor(self, x: float, edge: PySide6.QtGui.QTextLine.CursorPosition = ...) -> int: ...
    def y(self) -> float: ...


class QTextList(PySide6.QtGui.QTextBlockGroup):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def add(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def count(self) -> int: ...
    def format(self) -> PySide6.QtGui.QTextListFormat: ...
    def item(self, i: int) -> PySide6.QtGui.QTextBlock: ...
    def itemNumber(self, arg__1: PySide6.QtGui.QTextBlock) -> int: ...
    def itemText(self, arg__1: PySide6.QtGui.QTextBlock) -> str: ...
    def remove(self, arg__1: PySide6.QtGui.QTextBlock) -> None: ...
    def removeItem(self, i: int) -> None: ...
    def setFormat(self, format: PySide6.QtGui.QTextListFormat) -> None: ...


class QTextListFormat(PySide6.QtGui.QTextFormat):

    class Style(enum.Enum):

        ListUpperRoman           : QTextListFormat.Style = ... # -0x8
        ListLowerRoman           : QTextListFormat.Style = ... # -0x7
        ListUpperAlpha           : QTextListFormat.Style = ... # -0x6
        ListLowerAlpha           : QTextListFormat.Style = ... # -0x5
        ListDecimal              : QTextListFormat.Style = ... # -0x4
        ListSquare               : QTextListFormat.Style = ... # -0x3
        ListCircle               : QTextListFormat.Style = ... # -0x2
        ListDisc                 : QTextListFormat.Style = ... # -0x1
        ListStyleUndefined       : QTextListFormat.Style = ... # 0x0


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextListFormat: PySide6.QtGui.QTextListFormat) -> None: ...
    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def numberPrefix(self) -> str: ...
    def numberSuffix(self) -> str: ...
    def setIndent(self, indent: int) -> None: ...
    def setNumberPrefix(self, numberPrefix: str) -> None: ...
    def setNumberSuffix(self, numberSuffix: str) -> None: ...
    def setStyle(self, style: PySide6.QtGui.QTextListFormat.Style) -> None: ...
    def style(self) -> PySide6.QtGui.QTextListFormat.Style: ...


class QTextObject(PySide6.QtCore.QObject):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def format(self) -> PySide6.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def objectIndex(self) -> int: ...
    def setFormat(self, format: PySide6.QtGui.QTextFormat) -> None: ...


class QTextObjectInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def drawObject(self, painter: PySide6.QtGui.QPainter, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], doc: PySide6.QtGui.QTextDocument, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def intrinsicSize(self, doc: PySide6.QtGui.QTextDocument, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> PySide6.QtCore.QSizeF: ...


class QTextOption(Shiboken.Object):

    class Flag(enum.Flag):

        ShowTabsAndSpaces        : QTextOption.Flag = ... # 0x1
        ShowLineAndParagraphSeparators: QTextOption.Flag = ... # 0x2
        AddSpaceForLineAndParagraphSeparators: QTextOption.Flag = ... # 0x4
        SuppressColors           : QTextOption.Flag = ... # 0x8
        ShowDocumentTerminator   : QTextOption.Flag = ... # 0x10
        IncludeTrailingSpaces    : QTextOption.Flag = ... # 0x80000000


    class Tab(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, Tab: PySide6.QtGui.QTextOption.Tab) -> None: ...
        @overload
        def __init__(self, pos: float, tabType: PySide6.QtGui.QTextOption.TabType, delim: str = ...) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class TabType(enum.Enum):

        LeftTab                  : QTextOption.TabType = ... # 0x0
        RightTab                 : QTextOption.TabType = ... # 0x1
        CenterTab                : QTextOption.TabType = ... # 0x2
        DelimiterTab             : QTextOption.TabType = ... # 0x3


    class WrapMode(enum.Enum):

        NoWrap                   : QTextOption.WrapMode = ... # 0x0
        WordWrap                 : QTextOption.WrapMode = ... # 0x1
        ManualWrap               : QTextOption.WrapMode = ... # 0x2
        WrapAnywhere             : QTextOption.WrapMode = ... # 0x3
        WrapAtWordBoundaryOrAnywhere: QTextOption.WrapMode = ... # 0x4


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    @overload
    def __init__(self, o: Union[PySide6.QtGui.QTextOption, PySide6.QtCore.Qt.AlignmentFlag]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def flags(self) -> PySide6.QtGui.QTextOption.Flag: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setFlags(self, flags: PySide6.QtGui.QTextOption.Flag) -> None: ...
    def setTabArray(self, tabStops: Sequence[float]) -> None: ...
    def setTabStopDistance(self, tabStopDistance: float) -> None: ...
    def setTabs(self, tabStops: Sequence[PySide6.QtGui.QTextOption.Tab]) -> None: ...
    def setTextDirection(self, aDirection: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def setWrapMode(self, wrap: PySide6.QtGui.QTextOption.WrapMode) -> None: ...
    def tabArray(self) -> List[float]: ...
    def tabStopDistance(self) -> float: ...
    def tabs(self) -> List[PySide6.QtGui.QTextOption.Tab]: ...
    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def useDesignMetrics(self) -> bool: ...
    def wrapMode(self) -> PySide6.QtGui.QTextOption.WrapMode: ...


class QTextTable(PySide6.QtGui.QTextFrame):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def appendColumns(self, count: int) -> None: ...
    def appendRows(self, count: int) -> None: ...
    @overload
    def cellAt(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextTableCell: ...
    @overload
    def cellAt(self, position: int) -> PySide6.QtGui.QTextTableCell: ...
    @overload
    def cellAt(self, row: int, col: int) -> PySide6.QtGui.QTextTableCell: ...
    def columns(self) -> int: ...
    def format(self) -> PySide6.QtGui.QTextTableFormat: ...
    def insertColumns(self, pos: int, num: int) -> None: ...
    def insertRows(self, pos: int, num: int) -> None: ...
    @overload
    def mergeCells(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    @overload
    def mergeCells(self, row: int, col: int, numRows: int, numCols: int) -> None: ...
    def removeColumns(self, pos: int, num: int) -> None: ...
    def removeRows(self, pos: int, num: int) -> None: ...
    def resize(self, rows: int, cols: int) -> None: ...
    def rowEnd(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextCursor: ...
    def rowStart(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextCursor: ...
    def rows(self) -> int: ...
    def setFormat(self, format: PySide6.QtGui.QTextTableFormat) -> None: ...
    def splitCell(self, row: int, col: int, numRows: int, numCols: int) -> None: ...


class QTextTableCell(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: PySide6.QtGui.QTextTableCell) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def begin(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def column(self) -> int: ...
    def columnSpan(self) -> int: ...
    def end(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def format(self) -> PySide6.QtGui.QTextCharFormat: ...
    def isValid(self) -> bool: ...
    def lastCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def row(self) -> int: ...
    def rowSpan(self) -> int: ...
    def setFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def tableCellFormatIndex(self) -> int: ...


class QTextTableCellFormat(PySide6.QtGui.QTextCharFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextTableCellFormat: PySide6.QtGui.QTextTableCellFormat) -> None: ...
    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bottomBorder(self) -> float: ...
    def bottomBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def bottomBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def bottomPadding(self) -> float: ...
    def isValid(self) -> bool: ...
    def leftBorder(self) -> float: ...
    def leftBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def leftBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def leftPadding(self) -> float: ...
    def rightBorder(self) -> float: ...
    def rightBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def rightBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def rightPadding(self) -> float: ...
    def setBorder(self, width: float) -> None: ...
    def setBorderBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomBorder(self, width: float) -> None: ...
    def setBottomBorderBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setBottomBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomPadding(self, padding: float) -> None: ...
    def setLeftBorder(self, width: float) -> None: ...
    def setLeftBorderBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setLeftBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setLeftPadding(self, padding: float) -> None: ...
    def setPadding(self, padding: float) -> None: ...
    def setRightBorder(self, width: float) -> None: ...
    def setRightBorderBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setRightBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setRightPadding(self, padding: float) -> None: ...
    def setTopBorder(self, width: float) -> None: ...
    def setTopBorderBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setTopBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setTopPadding(self, padding: float) -> None: ...
    def topBorder(self) -> float: ...
    def topBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def topBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def topPadding(self) -> float: ...


class QTextTableFormat(PySide6.QtGui.QTextFrameFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTextTableFormat: PySide6.QtGui.QTextTableFormat) -> None: ...
    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def borderCollapse(self) -> bool: ...
    def cellPadding(self) -> float: ...
    def cellSpacing(self) -> float: ...
    def clearColumnWidthConstraints(self) -> None: ...
    def columnWidthConstraints(self) -> List[PySide6.QtGui.QTextLength]: ...
    def columns(self) -> int: ...
    def headerRowCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setBorderCollapse(self, borderCollapse: bool) -> None: ...
    def setCellPadding(self, padding: float) -> None: ...
    def setCellSpacing(self, spacing: float) -> None: ...
    def setColumnWidthConstraints(self, constraints: Sequence[PySide6.QtGui.QTextLength]) -> None: ...
    def setColumns(self, columns: int) -> None: ...
    def setHeaderRowCount(self, count: int) -> None: ...


class QToolBarChangeEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QToolBarChangeEvent) -> None: ...
    @overload
    def __init__(self, t: bool) -> None: ...

    def clone(self) -> PySide6.QtGui.QToolBarChangeEvent: ...
    def toggle(self) -> bool: ...


class QTouchEvent(PySide6.QtGui.QPointerEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QTouchEvent) -> None: ...
    @overload
    def __init__(self, eventType: PySide6.QtCore.QEvent.Type, device: Optional[PySide6.QtGui.QPointingDevice] = ..., modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., touchPoints: Sequence[PySide6.QtGui.QEventPoint] = ...) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QTouchEvent: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def target(self) -> PySide6.QtCore.QObject: ...
    def touchPoints(self) -> List[PySide6.QtGui.QEventPoint]: ...


class QTransform(Shiboken.Object):

    class TransformationType(enum.Enum):

        TxNone                   : QTransform.TransformationType = ... # 0x0
        TxTranslate              : QTransform.TransformationType = ... # 0x1
        TxScale                  : QTransform.TransformationType = ... # 0x2
        TxRotate                 : QTransform.TransformationType = ... # 0x4
        TxShear                  : QTransform.TransformationType = ... # 0x8
        TxProject                : QTransform.TransformationType = ... # 0x10


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, h11: float, h12: float, h13: float, h21: float, h22: float, h23: float, h31: float, h32: float, h33: float) -> None: ...
    @overload
    def __init__(self, h11: float, h12: float, h21: float, h22: float, dx: float, dy: float) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtGui.QTransform) -> None: ...

    def __add__(self, n: float) -> PySide6.QtGui.QTransform: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, div: float) -> PySide6.QtGui.QTransform: ...
    @overload
    def __imul__(self, arg__1: PySide6.QtGui.QTransform) -> PySide6.QtGui.QTransform: ...
    @overload
    def __imul__(self, div: float) -> PySide6.QtGui.QTransform: ...
    def __isub__(self, div: float) -> PySide6.QtGui.QTransform: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def __mul__(self, l: PySide6.QtCore.QLine) -> PySide6.QtCore.QLine: ...
    @overload
    def __mul__(self, l: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine]) -> PySide6.QtCore.QLineF: ...
    @overload
    def __mul__(self, n: float) -> PySide6.QtGui.QTransform: ...
    @overload
    def __mul__(self, o: PySide6.QtGui.QTransform) -> PySide6.QtGui.QTransform: ...
    @overload
    def __mul__(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def __mul__(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, n: float) -> PySide6.QtGui.QTransform: ...
    def adjoint(self) -> PySide6.QtGui.QTransform: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @staticmethod
    def fromScale(dx: float, dy: float) -> PySide6.QtGui.QTransform: ...
    @staticmethod
    def fromTranslate(dx: float, dy: float) -> PySide6.QtGui.QTransform: ...
    def inverted(self) -> Tuple: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def isRotating(self) -> bool: ...
    def isScaling(self) -> bool: ...
    def isTranslating(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m13(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    def m23(self) -> float: ...
    def m31(self) -> float: ...
    def m32(self) -> float: ...
    def m33(self) -> float: ...
    @overload
    def map(self, a: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygon: ...
    @overload
    def map(self, a: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def map(self, l: PySide6.QtCore.QLine) -> PySide6.QtCore.QLine: ...
    @overload
    def map(self, l: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine]) -> PySide6.QtCore.QLineF: ...
    @overload
    def map(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def map(self, p: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def map(self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def map(self, r: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> PySide6.QtGui.QRegion: ...
    @overload
    def map(self, x: float, y: float) -> object: ...
    @overload
    def mapRect(self, arg__1: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    @overload
    def mapRect(self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapToPolygon(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygon: ...
    @overload
    @staticmethod
    def quadToQuad(arg__1: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], arg__2: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> object: ...
    @overload
    @staticmethod
    def quadToQuad(one: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], two: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], result: PySide6.QtGui.QTransform) -> bool: ...
    @overload
    @staticmethod
    def quadToSquare(arg__1: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> object: ...
    @overload
    @staticmethod
    def quadToSquare(quad: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], result: PySide6.QtGui.QTransform) -> bool: ...
    def reset(self) -> None: ...
    def rotate(self, a: float, axis: PySide6.QtCore.Qt.Axis = ...) -> PySide6.QtGui.QTransform: ...
    def rotateRadians(self, a: float, axis: PySide6.QtCore.Qt.Axis = ...) -> PySide6.QtGui.QTransform: ...
    def scale(self, sx: float, sy: float) -> PySide6.QtGui.QTransform: ...
    def setMatrix(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float) -> None: ...
    def shear(self, sh: float, sv: float) -> PySide6.QtGui.QTransform: ...
    @overload
    @staticmethod
    def squareToQuad(arg__1: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> object: ...
    @overload
    @staticmethod
    def squareToQuad(square: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], result: PySide6.QtGui.QTransform) -> bool: ...
    def translate(self, dx: float, dy: float) -> PySide6.QtGui.QTransform: ...
    def transposed(self) -> PySide6.QtGui.QTransform: ...
    def type(self) -> PySide6.QtGui.QTransform.TransformationType: ...


class QUndoCommand(Shiboken.Object):

    @overload
    def __init__(self, parent: Optional[PySide6.QtGui.QUndoCommand] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtGui.QUndoCommand] = ...) -> None: ...

    def actionText(self) -> str: ...
    def child(self, index: int) -> PySide6.QtGui.QUndoCommand: ...
    def childCount(self) -> int: ...
    def id(self) -> int: ...
    def isObsolete(self) -> bool: ...
    def mergeWith(self, other: PySide6.QtGui.QUndoCommand) -> bool: ...
    def redo(self) -> None: ...
    def setObsolete(self, obsolete: bool) -> None: ...
    def setText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def undo(self) -> None: ...


class QUndoGroup(PySide6.QtCore.QObject):

    activeStackChanged       : ClassVar[Signal] = ... # activeStackChanged(QUndoStack*)
    canRedoChanged           : ClassVar[Signal] = ... # canRedoChanged(bool)
    canUndoChanged           : ClassVar[Signal] = ... # canUndoChanged(bool)
    cleanChanged             : ClassVar[Signal] = ... # cleanChanged(bool)
    indexChanged             : ClassVar[Signal] = ... # indexChanged(int)
    redoTextChanged          : ClassVar[Signal] = ... # redoTextChanged(QString)
    undoTextChanged          : ClassVar[Signal] = ... # undoTextChanged(QString)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def activeStack(self) -> PySide6.QtGui.QUndoStack: ...
    def addStack(self, stack: PySide6.QtGui.QUndoStack) -> None: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def createRedoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def createUndoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def isClean(self) -> bool: ...
    def redo(self) -> None: ...
    def redoText(self) -> str: ...
    def removeStack(self, stack: PySide6.QtGui.QUndoStack) -> None: ...
    def setActiveStack(self, stack: PySide6.QtGui.QUndoStack) -> None: ...
    def stacks(self) -> List[PySide6.QtGui.QUndoStack]: ...
    def undo(self) -> None: ...
    def undoText(self) -> str: ...


class QUndoStack(PySide6.QtCore.QObject):

    canRedoChanged           : ClassVar[Signal] = ... # canRedoChanged(bool)
    canUndoChanged           : ClassVar[Signal] = ... # canUndoChanged(bool)
    cleanChanged             : ClassVar[Signal] = ... # cleanChanged(bool)
    indexChanged             : ClassVar[Signal] = ... # indexChanged(int)
    redoTextChanged          : ClassVar[Signal] = ... # redoTextChanged(QString)
    undoTextChanged          : ClassVar[Signal] = ... # undoTextChanged(QString)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def beginMacro(self, text: str) -> None: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def cleanIndex(self) -> int: ...
    def clear(self) -> None: ...
    def command(self, index: int) -> PySide6.QtGui.QUndoCommand: ...
    def count(self) -> int: ...
    def createRedoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def createUndoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def endMacro(self) -> None: ...
    def index(self) -> int: ...
    def isActive(self) -> bool: ...
    def isClean(self) -> bool: ...
    def push(self, cmd: PySide6.QtGui.QUndoCommand) -> None: ...
    def redo(self) -> None: ...
    def redoText(self) -> str: ...
    def resetClean(self) -> None: ...
    def setActive(self, active: bool = ...) -> None: ...
    def setClean(self) -> None: ...
    def setIndex(self, idx: int) -> None: ...
    def setUndoLimit(self, limit: int) -> None: ...
    def text(self, idx: int) -> str: ...
    def undo(self) -> None: ...
    def undoLimit(self) -> int: ...
    def undoText(self) -> str: ...


class QValidator(PySide6.QtCore.QObject):

    changed                  : ClassVar[Signal] = ... # changed()

    class State(enum.Enum):

        Invalid                  : QValidator.State = ... # 0x0
        Intermediate             : QValidator.State = ... # 0x1
        Acceptable               : QValidator.State = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def fixup(self, arg__1: str) -> str: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    def setLocale(self, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]) -> None: ...
    def validate(self, arg__1: str, arg__2: int) -> object: ...


class QVector2D(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None: ...
    @overload
    def __init__(self, xpos: float, ypos: float) -> None: ...

    def __add__(self, v2: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector2D: ...
    @overload
    def __imul__(self, vector: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    def __isub__(self, vector: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector2D: ...
    @overload
    def __mul__(self, v2: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    def __neg__(self) -> PySide6.QtGui.QVector2D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    def distanceToLine(self, point: PySide6.QtGui.QVector2D, direction: PySide6.QtGui.QVector2D) -> float: ...
    def distanceToPoint(self, point: PySide6.QtGui.QVector2D) -> float: ...
    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector2D, v2: PySide6.QtGui.QVector2D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QVector2D: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def toPoint(self) -> PySide6.QtCore.QPoint: ...
    def toPointF(self) -> PySide6.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector3D(self) -> PySide6.QtGui.QVector3D: ...
    def toVector4D(self) -> PySide6.QtGui.QVector4D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QVector2DList(object): ...


class QVector3D(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector2D) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector2D, zpos: float) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None: ...
    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None: ...

    def __add__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector3D: ...
    @overload
    def __imul__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def __isub__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector3D: ...
    @overload
    def __mul__(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QVector3D: ...
    @overload
    def __mul__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QVector3D: ...
    @overload
    def __mul__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def __neg__(self) -> PySide6.QtGui.QVector3D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @staticmethod
    def crossProduct(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def distanceToLine(self, point: PySide6.QtGui.QVector3D, direction: PySide6.QtGui.QVector3D) -> float: ...
    @overload
    def distanceToPlane(self, plane1: PySide6.QtGui.QVector3D, plane2: PySide6.QtGui.QVector3D, plane3: PySide6.QtGui.QVector3D) -> float: ...
    @overload
    def distanceToPlane(self, plane: PySide6.QtGui.QVector3D, normal: PySide6.QtGui.QVector3D) -> float: ...
    def distanceToPoint(self, point: PySide6.QtGui.QVector3D) -> float: ...
    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @overload
    @staticmethod
    def normal(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @overload
    @staticmethod
    def normal(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D, v3: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QVector3D: ...
    def project(self, modelView: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform], projection: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform], viewport: PySide6.QtCore.QRect) -> PySide6.QtGui.QVector3D: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def toPoint(self) -> PySide6.QtCore.QPoint: ...
    def toPointF(self) -> PySide6.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide6.QtGui.QVector2D: ...
    def toVector4D(self) -> PySide6.QtGui.QVector4D: ...
    def unproject(self, modelView: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform], projection: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform], viewport: PySide6.QtCore.QRect) -> PySide6.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QVector3DList(object): ...


class QVector4D(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector2D) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector2D, zpos: float, wpos: float) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    @overload
    def __init__(self, vector: PySide6.QtGui.QVector3D, wpos: float) -> None: ...
    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None: ...

    def __add__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector4D: ...
    @overload
    def __imul__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    def __isub__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector4D: ...
    @overload
    def __mul__(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> PySide6.QtGui.QVector4D: ...
    @overload
    def __mul__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    def __neg__(self) -> PySide6.QtGui.QVector4D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector4D, v2: PySide6.QtGui.QVector4D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QVector4D: ...
    def setW(self, w: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def toPoint(self) -> PySide6.QtCore.QPoint: ...
    def toPointF(self) -> PySide6.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide6.QtGui.QVector2D: ...
    def toVector2DAffine(self) -> PySide6.QtGui.QVector2D: ...
    def toVector3D(self) -> PySide6.QtGui.QVector3D: ...
    def toVector3DAffine(self) -> PySide6.QtGui.QVector3D: ...
    def w(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QVector4DList(object): ...


class QWhatsThisClickedEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QWhatsThisClickedEvent) -> None: ...
    @overload
    def __init__(self, href: str) -> None: ...

    def clone(self) -> PySide6.QtGui.QWhatsThisClickedEvent: ...
    def href(self) -> str: ...


class QWheelEvent(PySide6.QtGui.QSinglePointEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...
    @overload
    def __init__(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], globalPos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], pixelDelta: PySide6.QtCore.QPoint, angleDelta: PySide6.QtCore.QPoint, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, phase: PySide6.QtCore.Qt.ScrollPhase, inverted: bool, source: PySide6.QtCore.Qt.MouseEventSource = ..., device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    def __repr__(self) -> object: ...
    def angleDelta(self) -> PySide6.QtCore.QPoint: ...
    def clone(self) -> PySide6.QtGui.QWheelEvent: ...
    def hasPixelDelta(self) -> bool: ...
    def inverted(self) -> bool: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isInverted(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def phase(self) -> PySide6.QtCore.Qt.ScrollPhase: ...
    def pixelDelta(self) -> PySide6.QtCore.QPoint: ...
    def source(self) -> PySide6.QtCore.Qt.MouseEventSource: ...


class QWindow(PySide6.QtCore.QObject, PySide6.QtGui.QSurface):

    activeChanged            : ClassVar[Signal] = ... # activeChanged()
    contentOrientationChanged: ClassVar[Signal] = ... # contentOrientationChanged(Qt::ScreenOrientation)
    focusObjectChanged       : ClassVar[Signal] = ... # focusObjectChanged(QObject*)
    heightChanged            : ClassVar[Signal] = ... # heightChanged(int)
    maximumHeightChanged     : ClassVar[Signal] = ... # maximumHeightChanged(int)
    maximumWidthChanged      : ClassVar[Signal] = ... # maximumWidthChanged(int)
    minimumHeightChanged     : ClassVar[Signal] = ... # minimumHeightChanged(int)
    minimumWidthChanged      : ClassVar[Signal] = ... # minimumWidthChanged(int)
    modalityChanged          : ClassVar[Signal] = ... # modalityChanged(Qt::WindowModality)
    opacityChanged           : ClassVar[Signal] = ... # opacityChanged(double)
    screenChanged            : ClassVar[Signal] = ... # screenChanged(QScreen*)
    transientParentChanged   : ClassVar[Signal] = ... # transientParentChanged(QWindow*)
    visibilityChanged        : ClassVar[Signal] = ... # visibilityChanged(QWindow::Visibility)
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged(bool)
    widthChanged             : ClassVar[Signal] = ... # widthChanged(int)
    windowStateChanged       : ClassVar[Signal] = ... # windowStateChanged(Qt::WindowState)
    windowTitleChanged       : ClassVar[Signal] = ... # windowTitleChanged(QString)
    xChanged                 : ClassVar[Signal] = ... # xChanged(int)
    yChanged                 : ClassVar[Signal] = ... # yChanged(int)

    class AncestorMode(enum.Enum):

        ExcludeTransients        : QWindow.AncestorMode = ... # 0x0
        IncludeTransients        : QWindow.AncestorMode = ... # 0x1


    class Visibility(enum.Enum):

        Hidden                   : QWindow.Visibility = ... # 0x0
        AutomaticVisibility      : QWindow.Visibility = ... # 0x1
        Windowed                 : QWindow.Visibility = ... # 0x2
        Minimized                : QWindow.Visibility = ... # 0x3
        Maximized                : QWindow.Visibility = ... # 0x4
        FullScreen               : QWindow.Visibility = ... # 0x5


    @overload
    def __init__(self, parent: PySide6.QtGui.QWindow) -> None: ...
    @overload
    def __init__(self, screen: Optional[PySide6.QtGui.QScreen] = ...) -> None: ...

    def accessibleRoot(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def alert(self, msec: int) -> None: ...
    def baseSize(self) -> PySide6.QtCore.QSize: ...
    def close(self) -> bool: ...
    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent) -> None: ...
    def contentOrientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def create(self) -> None: ...
    def cursor(self) -> PySide6.QtGui.QCursor: ...
    def destroy(self) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    def filePath(self) -> str: ...
    def flags(self) -> PySide6.QtCore.Qt.WindowType: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusObject(self) -> PySide6.QtCore.QObject: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def frameGeometry(self) -> PySide6.QtCore.QRect: ...
    def frameMargins(self) -> PySide6.QtCore.QMargins: ...
    def framePosition(self) -> PySide6.QtCore.QPoint: ...
    @staticmethod
    def fromWinId(id: int) -> PySide6.QtGui.QWindow: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def height(self) -> int: ...
    def hide(self) -> None: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: PySide6.QtGui.QWindow, mode: PySide6.QtGui.QWindow.AncestorMode = ...) -> bool: ...
    def isExposed(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def lower(self) -> None: ...
    @overload
    def mapFromGlobal(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapFromGlobal(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToGlobal(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapToGlobal(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mask(self) -> PySide6.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def modality(self) -> PySide6.QtCore.Qt.WindowModality: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, arg__1: PySide6.QtGui.QMoveEvent) -> None: ...
    def nativeEvent(self, eventType: Union[PySide6.QtCore.QByteArray, bytes], message: int) -> object: ...
    def opacity(self) -> float: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def parent(self, mode: PySide6.QtGui.QWindow.AncestorMode = ...) -> PySide6.QtGui.QWindow: ...
    def position(self) -> PySide6.QtCore.QPoint: ...
    def raise_(self) -> None: ...
    def reportContentOrientationChange(self, orientation: PySide6.QtCore.Qt.ScreenOrientation) -> None: ...
    def requestActivate(self) -> None: ...
    def requestUpdate(self) -> None: ...
    def requestedFormat(self) -> PySide6.QtGui.QSurfaceFormat: ...
    @overload
    def resize(self, newSize: PySide6.QtCore.QSize) -> None: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def resolveInterface(self, name: bytes, revision: int) -> int: ...
    def screen(self) -> PySide6.QtGui.QScreen: ...
    def setBaseSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setCursor(self, arg__1: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    def setFilePath(self, filePath: str) -> None: ...
    def setFlag(self, arg__1: PySide6.QtCore.Qt.WindowType, on: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.WindowType) -> None: ...
    def setFormat(self, format: Union[PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOption]) -> None: ...
    def setFramePosition(self, point: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def setGeometry(self, posx: int, posy: int, w: int, h: int) -> None: ...
    @overload
    def setGeometry(self, rect: PySide6.QtCore.QRect) -> None: ...
    def setHeight(self, arg: int) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setKeyboardGrabEnabled(self, grab: bool) -> bool: ...
    def setMask(self, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    def setMaximumHeight(self, h: int) -> None: ...
    def setMaximumSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setMaximumWidth(self, w: int) -> None: ...
    def setMinimumHeight(self, h: int) -> None: ...
    def setMinimumSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setMinimumWidth(self, w: int) -> None: ...
    def setModality(self, modality: PySide6.QtCore.Qt.WindowModality) -> None: ...
    def setMouseGrabEnabled(self, grab: bool) -> bool: ...
    def setOpacity(self, level: float) -> None: ...
    def setParent(self, parent: PySide6.QtGui.QWindow) -> None: ...
    @overload
    def setPosition(self, posx: int, posy: int) -> None: ...
    @overload
    def setPosition(self, pt: PySide6.QtCore.QPoint) -> None: ...
    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None: ...
    def setSizeIncrement(self, size: PySide6.QtCore.QSize) -> None: ...
    def setSurfaceType(self, surfaceType: PySide6.QtGui.QSurface.SurfaceType) -> None: ...
    def setTitle(self, arg__1: str) -> None: ...
    def setTransientParent(self, parent: PySide6.QtGui.QWindow) -> None: ...
    def setVisibility(self, v: PySide6.QtGui.QWindow.Visibility) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setWidth(self, arg: int) -> None: ...
    def setWindowState(self, state: PySide6.QtCore.Qt.WindowState) -> None: ...
    def setWindowStates(self, states: PySide6.QtCore.Qt.WindowState) -> None: ...
    def setX(self, arg: int) -> None: ...
    def setY(self, arg: int) -> None: ...
    def show(self) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def showNormal(self) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide6.QtCore.QSize: ...
    def startSystemMove(self) -> bool: ...
    def startSystemResize(self, edges: PySide6.QtCore.Qt.Edge) -> bool: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType: ...
    def tabletEvent(self, arg__1: PySide6.QtGui.QTabletEvent) -> None: ...
    def title(self) -> str: ...
    def touchEvent(self, arg__1: PySide6.QtGui.QTouchEvent) -> None: ...
    def transientParent(self) -> PySide6.QtGui.QWindow: ...
    def type(self) -> PySide6.QtCore.Qt.WindowType: ...
    def unsetCursor(self) -> None: ...
    def visibility(self) -> PySide6.QtGui.QWindow.Visibility: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def windowState(self) -> PySide6.QtCore.Qt.WindowState: ...
    def windowStates(self) -> PySide6.QtCore.Qt.WindowState: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWindowStateChangeEvent(PySide6.QtCore.QEvent):

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QWindowStateChangeEvent) -> None: ...
    @overload
    def __init__(self, oldState: PySide6.QtCore.Qt.WindowState, isOverride: bool = ...) -> None: ...

    def __repr__(self) -> object: ...
    def clone(self) -> PySide6.QtGui.QWindowStateChangeEvent: ...
    def isOverride(self) -> bool: ...
    def oldState(self) -> PySide6.QtCore.Qt.WindowState: ...


class Qt(PySide6.QtCore.Qt):
    @staticmethod
    def convertFromPlainText(plain: str, mode: PySide6.QtCore.Qt.WhiteSpaceMode = ...) -> str: ...
    @staticmethod
    def mightBeRichText(arg__1: str) -> bool: ...


def qAlpha(rgb: int) -> int: ...
def qBlue(rgb: int) -> int: ...
@overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QQuaternion, arg__2: PySide6.QtGui.QQuaternion) -> bool: ...
@overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QTransform, arg__2: PySide6.QtGui.QTransform) -> bool: ...
@overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QVector2D, arg__2: PySide6.QtGui.QVector2D) -> bool: ...
@overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QVector3D, arg__2: PySide6.QtGui.QVector3D) -> bool: ...
@overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QVector4D, arg__2: PySide6.QtGui.QVector4D) -> bool: ...
@overload
def qFuzzyCompare(arg__1: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform], arg__2: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> bool: ...
@overload
def qGray(r: int, g: int, b: int) -> int: ...
@overload
def qGray(rgb: int) -> int: ...
def qGreen(rgb: int) -> int: ...
def qIsGray(rgb: int) -> bool: ...
def qPixelFormatAlpha(channelSize: int, typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatCmyk(channelSize: int, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatGrayscale(channelSize: int, typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatHsl(channelSize: int, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatHsv(channelSize: int, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatRgba(red: int, green: int, blue: int, alfa: int, usage: PySide6.QtGui.QPixelFormat.AlphaUsage, position: PySide6.QtGui.QPixelFormat.AlphaPosition, pmul: PySide6.QtGui.QPixelFormat.AlphaPremultiplied = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatYuv(layout: PySide6.QtGui.QPixelFormat.YUVLayout, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., p_mul: PySide6.QtGui.QPixelFormat.AlphaPremultiplied = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ..., b_order: PySide6.QtGui.QPixelFormat.ByteOrder = ...) -> PySide6.QtGui.QPixelFormat: ...
def qRed(rgb: int) -> int: ...
def qRgb(r: int, g: int, b: int) -> int: ...
def qRgba(r: int, g: int, b: int, a: int) -> int: ...
def qt_set_sequence_auto_mnemonic(b: bool) -> None: ...


# eof
