# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGLWidgets, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtOpenGLWidgets`

import PySide6.QtOpenGLWidgets
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

import enum
from typing import ClassVar, Optional, Union
from PySide6.QtCore import Signal


class QIntList(object): ...


class QOpenGLWidget(PySide6.QtWidgets.QWidget):

    aboutToCompose           : ClassVar[Signal] = ... # aboutToCompose()
    aboutToResize            : ClassVar[Signal] = ... # aboutToResize()
    frameSwapped             : ClassVar[Signal] = ... # frameSwapped()
    resized                  : ClassVar[Signal] = ... # resized()

    class UpdateBehavior(enum.Enum):

        NoPartialUpdate          : QOpenGLWidget.UpdateBehavior = ... # 0x0
        PartialUpdate            : QOpenGLWidget.UpdateBehavior = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def context(self) -> PySide6.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def grabFramebuffer(self) -> PySide6.QtGui.QImage: ...
    def initializeGL(self) -> None: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def redirected(self, p: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPaintDevice: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def setFormat(self, format: Union[PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOption]) -> None: ...
    def setTextureFormat(self, texFormat: int) -> None: ...
    def setUpdateBehavior(self, updateBehavior: PySide6.QtOpenGLWidgets.QOpenGLWidget.UpdateBehavior) -> None: ...
    def textureFormat(self) -> int: ...
    def updateBehavior(self) -> PySide6.QtOpenGLWidgets.QOpenGLWidget.UpdateBehavior: ...


# eof
