/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.lang.reflect.Field;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ProblemReferenceBinding
extends ReferenceBinding {
    ReferenceBinding closestMatch;
    private int problemReason;

    public ProblemReferenceBinding(char[][] cArray, ReferenceBinding referenceBinding, int n) {
        this.compoundName = cArray;
        this.closestMatch = referenceBinding;
        if (referenceBinding != null) {
            this.sourceName = referenceBinding.sourceName;
        }
        this.problemReason = n;
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        throw new IllegalStateException();
    }

    @Override
    public TypeBinding closestMatch() {
        return this.closestMatch;
    }

    public ReferenceBinding closestReferenceMatch() {
        return this.closestMatch;
    }

    @Override
    public ReferenceBinding superclass() {
        if (this.closestMatch != null) {
            return this.closestMatch.superclass();
        }
        return super.superclass();
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.closestMatch != null) {
            return this.closestMatch.superInterfaces();
        }
        return super.superInterfaces();
    }

    @Override
    public boolean hasTypeBit(int n) {
        if (this.closestMatch != null) {
            return this.closestMatch.hasTypeBit(n);
        }
        return false;
    }

    @Override
    public int problemId() {
        return this.problemReason;
    }

    public static String problemReasonString(int n) {
        try {
            Class<ProblemReasons> clazz = ProblemReasons.class;
            String string = clazz.getName();
            int n2 = string.lastIndexOf(46);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            for (Field field : clazz.getFields()) {
                if (!field.getType().equals(Integer.TYPE) || field.getInt(clazz) != n) continue;
                return string + "." + field.getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "unknown";
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
    }

    @Override
    public char[] shortReadableName() {
        return this.readableName();
    }

    @Override
    public char[] sourceName() {
        return this.compoundName.length == 0 ? null : this.compoundName[this.compoundName.length - 1];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append("ProblemType:[compoundName=");
        stringBuilder.append(this.compoundName == null ? "<null>" : new String(CharOperation.concatWith(this.compoundName, '.')));
        stringBuilder.append("][problemID=").append(ProblemReferenceBinding.problemReasonString(this.problemReason));
        stringBuilder.append("][closestMatch=");
        stringBuilder.append(this.closestMatch == null ? "<null>" : this.closestMatch.toString());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

