/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.recording;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.recording.RecordingNode;
import org.graalvm.visualvm.jfr.views.recording.RecordingViewSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

class JFRSnapshotRecordingView
extends JFRViewTab {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/jfrSnapshot.png";

    JFRSnapshotRecordingView(JFRSnapshot dataSource) {
        super(dataSource, "Recording", new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), Integer.MAX_VALUE);
    }

    @Override
    protected DataViewComponent createComponent() {
        JFRModel model = this.getModel();
        if (model == null) {
            RecordingViewSupport.MasterViewSupport masterView = new RecordingViewSupport.MasterViewSupport((JFRSnapshot)this.getDataSource(), model){

                @Override
                void firstShown() {
                }
            };
            return new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        }
        final RecordingViewSupport.SettingsSupport settingsView = new RecordingViewSupport.SettingsSupport(model);
        final RecordingViewSupport.RecordingsSupport recordingsView = new RecordingViewSupport.RecordingsSupport(model);
        RecordingViewSupport.MasterViewSupport masterView = new RecordingViewSupport.MasterViewSupport((JFRSnapshot)this.getDataSource(), model){

            @Override
            void firstShown() {
                JFRSnapshotRecordingView.this.initialize(settingsView, new JFREventVisitor[]{this, recordingsView});
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsView(new DataViewComponent.DetailsViewConfiguration(-1.0, -1.0, -1.0, -1.0, 0.75, 0.75));
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Settings", true), 1);
        dvc.addDetailsView(settingsView.getDetailsView(), 1);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Concurrent recordings", true), 3);
        dvc.addDetailsView(recordingsView.getDetailsView(), 3);
        return dvc;
    }

    private void initialize(final RecordingViewSupport.SettingsSupport settingsView, final JFREventVisitor ... visitors) {
        new RequestProcessor("JFR Recording Initializer").post(new Runnable(){

            @Override
            public void run() {
                final JFRModel model = JFRSnapshotRecordingView.this.getModel();
                final RecordingNode.Root settingsRoot = new RecordingNode.Root(){

                    @Override
                    void visitEventTypes() {
                        model.visitEventTypes(this);
                    }

                    @Override
                    long toRelativeNanos(Instant time) {
                        return ValuesConverter.instantToRelativeNanos(time, model);
                    }
                };
                ArrayList<JFREventVisitor> allVisitors = new ArrayList<JFREventVisitor>(Arrays.asList(visitors));
                allVisitors.add(settingsRoot);
                model.visitEvents(allVisitors.toArray(new JFREventVisitor[0]));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        settingsView.setData(settingsRoot.getChildCount() > 0 ? settingsRoot : new RecordingNode.Root("<no settings>"){});
                    }
                });
            }
        });
    }
}

