/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.welcome;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JPanel;

class FixedImagePanel
extends JPanel {
    protected Image image;
    protected Dimension imageSize;

    FixedImagePanel(Image img) {
        try {
            this.image = FixedImagePanel.loadImage(img, new MediaTracker(this));
            this.imageSize = new Dimension(this.image.getWidth(null), this.image.getHeight(null));
            this.setOpaque(false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to load image: " + e.getMessage());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.imageSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }

    private static Image loadImage(Image image, MediaTracker mTracker) throws InterruptedException {
        mTracker.addImage(image, 0);
        mTracker.waitForID(0);
        mTracker.removeImage(image, 0);
        return image;
    }
}

