/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.ssl.SecurityKeyStore;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class SecuritySSLReloadCertsAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "_opendistro/_security/api/ssl/{certType}/reloadcerts/"));
    private final Settings settings;
    private final SecurityKeyStore sks;
    private final ThreadContext threadContext;
    private final AdminDNs adminDns;

    public SecuritySSLReloadCertsAction(Settings settings, RestController restController, SecurityKeyStore sks, ThreadPool threadPool, AdminDNs adminDns) {
        this.settings = settings;
        this.sks = sks;
        this.adminDns = adminDns;
        this.threadContext = threadPool.getThreadContext();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final String certType;
            {
                this.certType = request.param("certType").toLowerCase().trim();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                BytesRestResponse response = null;
                User user = (User)SecuritySSLReloadCertsAction.this.threadContext.getTransient("_opendistro_security_user");
                if (user == null || !SecuritySSLReloadCertsAction.this.adminDns.isAdmin(user)) {
                    response = new BytesRestResponse(RestStatus.FORBIDDEN, "");
                } else {
                    try {
                        builder.startObject();
                        if (SecuritySSLReloadCertsAction.this.sks != null) {
                            switch (this.certType) {
                                case "http": {
                                    SecuritySSLReloadCertsAction.this.sks.initHttpSSLConfig();
                                    builder.field("message", "updated http certs");
                                    builder.endObject();
                                    response = new BytesRestResponse(RestStatus.OK, builder);
                                    break;
                                }
                                case "transport": {
                                    SecuritySSLReloadCertsAction.this.sks.initTransportSSLConfig();
                                    builder.field("message", "updated transport certs");
                                    builder.endObject();
                                    response = new BytesRestResponse(RestStatus.OK, builder);
                                    break;
                                }
                                default: {
                                    builder.field("message", "invalid uri path, please use /_opendistro/_security/api/ssl/http/reload or /_opendistro/_security/api/ssl/transport/reload");
                                    builder.endObject();
                                    response = new BytesRestResponse(RestStatus.FORBIDDEN, builder);
                                    break;
                                }
                            }
                        } else {
                            builder.field("message", "keystore is not initialized");
                            builder.endObject();
                            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                        }
                    }
                    catch (Exception e1) {
                        builder = channel.newBuilder();
                        builder.startObject();
                        builder.field("error", e1.toString());
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "SSL Cert Reload Action";
    }
}

