/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.storage.DataSourceFactory;

public class DataSourceServiceImpl
implements DataSourceService {
    private static String DATASOURCE_NAME_REGEX = "[@*A-Za-z]+?[*a-zA-Z_\\-0-9]*";
    private final ConcurrentHashMap<String, DataSource> dataSourceMap;
    private final Map<DataSourceType, DataSourceFactory> dataSourceFactoryMap;

    public DataSourceServiceImpl(Set<DataSourceFactory> dataSourceFactories) {
        this.dataSourceFactoryMap = dataSourceFactories.stream().collect(Collectors.toMap(DataSourceFactory::getDataSourceType, f -> f));
        this.dataSourceMap = new ConcurrentHashMap();
    }

    @Override
    public Set<DataSource> getDataSources() {
        return Set.copyOf(this.dataSourceMap.values());
    }

    @Override
    public DataSource getDataSource(String dataSourceName) {
        if (!this.dataSourceMap.containsKey(dataSourceName)) {
            throw new IllegalArgumentException(String.format("DataSource with name %s doesn't exist.", dataSourceName));
        }
        return this.dataSourceMap.get(dataSourceName);
    }

    @Override
    public void addDataSource(DataSourceMetadata ... metadatas) {
        for (DataSourceMetadata metadata : metadatas) {
            this.validateDataSourceMetaData(metadata);
            this.dataSourceMap.put(metadata.getName(), this.dataSourceFactoryMap.get((Object)metadata.getConnector()).createDataSource(metadata));
        }
    }

    @Override
    public void clear() {
        this.dataSourceMap.clear();
    }

    private void validateDataSourceMetaData(DataSourceMetadata metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)metadata.getName()) ? 1 : 0) != 0, (Object)"Missing Name Field from a DataSource. Name is a required parameter.");
        Preconditions.checkArgument((!this.dataSourceMap.containsKey(metadata.getName()) ? 1 : 0) != 0, (Object)StringUtils.format((String)"Datasource name should be unique, Duplicate datasource found %s.", (Object[])new Object[]{metadata.getName()}));
        Preconditions.checkArgument((boolean)metadata.getName().matches(DATASOURCE_NAME_REGEX), (Object)StringUtils.format((String)"DataSource Name: %s contains illegal characters. Allowed characters: a-zA-Z0-9_-*@.", (Object[])new Object[]{metadata.getName()}));
        Preconditions.checkArgument((!Objects.isNull(metadata.getProperties()) ? 1 : 0) != 0, (Object)"Missing properties field in catalog configuration. Properties are required parameters.");
    }
}

