/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptService;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.DataSourceServiceImpl;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.plugin.RestSqlAction;
import org.opensearch.sql.legacy.plugin.RestSqlStatsAction;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.client.OpenSearchNodeClient;
import org.opensearch.sql.opensearch.security.SecurityAccess;
import org.opensearch.sql.opensearch.setting.LegacyOpenDistroSettings;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.opensearch.storage.OpenSearchDataSourceFactory;
import org.opensearch.sql.opensearch.storage.script.ExpressionScriptEngine;
import org.opensearch.sql.opensearch.storage.serialization.DefaultExpressionSerializer;
import org.opensearch.sql.opensearch.storage.serialization.ExpressionSerializer;
import org.opensearch.sql.plugin.config.OpenSearchPluginConfig;
import org.opensearch.sql.plugin.datasource.DataSourceSettings;
import org.opensearch.sql.plugin.rest.RestPPLQueryAction;
import org.opensearch.sql.plugin.rest.RestPPLStatsAction;
import org.opensearch.sql.plugin.rest.RestQuerySettingsAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.sql.ppl.config.PPLServiceConfig;
import org.opensearch.sql.prometheus.storage.PrometheusStorageFactory;
import org.opensearch.sql.sql.config.SQLServiceConfig;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SQLPlugin
extends Plugin
implements ActionPlugin,
ScriptPlugin,
ReloadablePlugin {
    private static final Logger LOG = LogManager.getLogger();
    private ClusterService clusterService;
    private org.opensearch.sql.common.setting.Settings pluginSettings;
    private NodeClient client;
    private AnnotationConfigApplicationContext applicationContext;
    private DataSourceService dataSourceService;

    public String name() {
        return "sql";
    }

    public String description() {
        return "Use sql to query OpenSearch.";
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        Objects.requireNonNull(this.clusterService, "Cluster service is required");
        Objects.requireNonNull(this.pluginSettings, "Cluster settings is required");
        LocalClusterState.state().setResolver(indexNameExpressionResolver);
        Metrics.getInstance().registerDefaultMetrics();
        return Arrays.asList(new RestHandler[]{new RestPPLQueryAction(this.pluginSettings, settings), new RestSqlAction(settings, this.applicationContext), new RestSqlStatsAction(settings, restController), new RestPPLStatsAction(settings, restController), new RestQuerySettingsAction(settings, restController)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ppl", TransportPPLQueryResponse::new), TransportPPLQueryAction.class, new Class[0]));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry contentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService = clusterService;
        this.pluginSettings = new OpenSearchSettings(clusterService.getClusterSettings());
        this.client = (NodeClient)client;
        this.dataSourceService = new DataSourceServiceImpl((Set)new ImmutableSet.Builder().add((Object)new OpenSearchDataSourceFactory((OpenSearchClient)new OpenSearchNodeClient(this.client), this.pluginSettings)).add((Object)new PrometheusStorageFactory()).build());
        this.dataSourceService.addDataSource(new DataSourceMetadata[]{DataSourceMetadata.defaultOpenSearchDataSourceMetadata()});
        SQLPlugin.loadDataSources(this.dataSourceService, clusterService.getSettings());
        LocalClusterState.state().setClusterService(clusterService);
        LocalClusterState.state().setPluginSettings((OpenSearchSettings)this.pluginSettings);
        this.applicationContext = new AnnotationConfigApplicationContext();
        SecurityAccess.doPrivileged(() -> {
            this.applicationContext.registerBean(ClusterService.class, () -> clusterService, new BeanDefinitionCustomizer[0]);
            this.applicationContext.registerBean(NodeClient.class, () -> (NodeClient)client, new BeanDefinitionCustomizer[0]);
            this.applicationContext.registerBean(org.opensearch.sql.common.setting.Settings.class, () -> this.pluginSettings, new BeanDefinitionCustomizer[0]);
            this.applicationContext.registerBean(DataSourceService.class, () -> this.dataSourceService, new BeanDefinitionCustomizer[0]);
            this.applicationContext.register(new Class[]{OpenSearchPluginConfig.class});
            this.applicationContext.register(new Class[]{PPLServiceConfig.class});
            this.applicationContext.register(new Class[]{SQLServiceConfig.class});
            this.applicationContext.refresh();
            return null;
        });
        return ImmutableList.of((Object)this.applicationContext);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return Collections.singletonList(new FixedExecutorBuilder(settings, "sql-worker", OpenSearchExecutors.allocatedProcessors((Settings)settings), 1000, null));
    }

    public List<Setting<?>> getSettings() {
        return new ImmutableList.Builder().addAll((Iterable)LegacyOpenDistroSettings.legacySettings()).addAll((Iterable)OpenSearchSettings.pluginSettings()).add(DataSourceSettings.DATASOURCE_CONFIG).build();
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new ExpressionScriptEngine((ExpressionSerializer)new DefaultExpressionSerializer());
    }

    public void reload(Settings settings) {
        this.dataSourceService.clear();
        this.dataSourceService.addDataSource(new DataSourceMetadata[]{DataSourceMetadata.defaultOpenSearchDataSourceMetadata()});
        SQLPlugin.loadDataSources(this.dataSourceService, settings);
    }

    @VisibleForTesting
    public static void loadDataSources(DataSourceService dataSourceService, Settings settings) {
        SecurityAccess.doPrivileged(() -> {
            InputStream inputStream = (InputStream)DataSourceSettings.DATASOURCE_CONFIG.get(settings);
            if (inputStream != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                try {
                    List metadataList = (List)objectMapper.readValue(inputStream, (TypeReference)new TypeReference<List<DataSourceMetadata>>(){});
                    dataSourceService.addDataSource(metadataList.toArray(new DataSourceMetadata[0]));
                }
                catch (IOException e) {
                    LOG.error("DataSource Configuration File uploaded is malformed. Verify and re-upload.", (Throwable)e);
                }
                catch (Throwable e) {
                    LOG.error("DataSource construction failed.", e);
                }
            }
            return null;
        });
    }
}

