/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasource.model.auth.AuthenticationType;
import org.opensearch.sql.prometheus.authinterceptors.AwsSigningInterceptor;
import org.opensearch.sql.prometheus.authinterceptors.BasicAuthenticationInterceptor;
import org.opensearch.sql.prometheus.client.PrometheusClientImpl;
import org.opensearch.sql.prometheus.storage.PrometheusStorageEngine;
import org.opensearch.sql.storage.DataSourceFactory;
import org.opensearch.sql.storage.StorageEngine;

public class PrometheusStorageFactory
implements DataSourceFactory {
    public static final String URI = "prometheus.uri";
    public static final String AUTH_TYPE = "prometheus.auth.type";
    public static final String USERNAME = "prometheus.auth.username";
    public static final String PASSWORD = "prometheus.auth.password";
    public static final String REGION = "prometheus.auth.region";
    public static final String ACCESS_KEY = "prometheus.auth.access_key";
    public static final String SECRET_KEY = "prometheus.auth.secret_key";

    public DataSourceType getDataSourceType() {
        return DataSourceType.PROMETHEUS;
    }

    public DataSource createDataSource(DataSourceMetadata metadata) {
        return new DataSource(metadata.getName(), DataSourceType.PROMETHEUS, this.getStorageEngine(metadata.getName(), metadata.getProperties()));
    }

    StorageEngine getStorageEngine(String catalogName, Map<String, String> requiredConfig) {
        PrometheusClientImpl prometheusClient;
        this.validateFieldsInConfig(requiredConfig, Set.of(URI));
        try {
            prometheusClient = new PrometheusClientImpl(this.getHttpClient(requiredConfig), new URI(requiredConfig.get(URI)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Prometheus Client creation failed due to: %s", e.getMessage()));
        }
        return new PrometheusStorageEngine(prometheusClient);
    }

    private OkHttpClient getHttpClient(Map<String, String> config) {
        OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder();
        okHttpClient.callTimeout(1L, TimeUnit.MINUTES);
        okHttpClient.connectTimeout(30L, TimeUnit.SECONDS);
        if (config.get(AUTH_TYPE) != null) {
            AuthenticationType authenticationType = AuthenticationType.get((String)config.get(AUTH_TYPE));
            if (AuthenticationType.BASICAUTH.equals((Object)authenticationType)) {
                this.validateFieldsInConfig(config, Set.of(USERNAME, PASSWORD));
                okHttpClient.addInterceptor((Interceptor)new BasicAuthenticationInterceptor(config.get(USERNAME), config.get(PASSWORD)));
            } else if (AuthenticationType.AWSSIGV4AUTH.equals((Object)authenticationType)) {
                this.validateFieldsInConfig(config, Set.of(REGION, ACCESS_KEY, SECRET_KEY));
                okHttpClient.addInterceptor((Interceptor)new AwsSigningInterceptor(config.get(ACCESS_KEY), config.get(SECRET_KEY), config.get(REGION), "aps"));
            } else {
                throw new IllegalArgumentException(String.format("AUTH Type : %s is not supported with Prometheus Connector", config.get(AUTH_TYPE)));
            }
        }
        return okHttpClient.build();
    }

    private void validateFieldsInConfig(Map<String, String> config, Set<String> fields) {
        HashSet<String> missingFields = new HashSet<String>();
        for (String field : fields) {
            if (config.containsKey(field)) continue;
            missingFields.add(field);
        }
        if (missingFields.size() > 0) {
            throw new IllegalArgumentException(String.format("Missing %s fields in the Prometheus connector properties.", missingFields));
        }
    }
}

