/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

public final class Vector3 {
    private static final float[] COS_THETA = new float[256];
    private static final float[] SIN_THETA = new float[256];
    private static final float[] COS_PHI = new float[256];
    private static final float[] SIN_PHI = new float[256];
    public float x;
    public float y;
    public float z;

    public Vector3() {
    }

    public Vector3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public static final Vector3 decode(short s, Vector3 vector3) {
        int n = (s & 0xFF00) >>> 8;
        int n2 = s & 0xFF;
        vector3.x = SIN_THETA[n] * COS_PHI[n2];
        vector3.y = SIN_THETA[n] * SIN_PHI[n2];
        vector3.z = COS_THETA[n];
        return vector3;
    }

    public static final Vector3 decode(short s) {
        return Vector3.decode(s, new Vector3());
    }

    public final short encode() {
        int n;
        int n2 = (int)(Math.acos(this.z) * 81.48733086305042);
        if (n2 > 255) {
            n2 = 255;
        }
        if ((n = (int)(Math.atan2(this.y, this.x) * 40.74366543152521)) < 0) {
            n += 256;
        } else if (n > 255) {
            n = 255;
        }
        return (short)((n2 & 0xFF) << 8 | n & 0xFF);
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        return this.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final Vector3 negate(Vector3 vector3) {
        vector3.x = -this.x;
        vector3.y = -this.y;
        vector3.z = -this.z;
        return vector3;
    }

    public final Vector3 mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public final Vector3 mul(float f, Vector3 vector3) {
        vector3.x = this.x * f;
        vector3.y = this.y * f;
        vector3.z = this.z * f;
        return vector3;
    }

    public final Vector3 div(float f) {
        this.x /= f;
        this.y /= f;
        this.z /= f;
        return this;
    }

    public final Vector3 div(float f, Vector3 vector3) {
        vector3.x = this.x / f;
        vector3.y = this.y / f;
        vector3.z = this.z / f;
        return vector3;
    }

    public final float normalizeLength() {
        float f = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        float f2 = 1.0f / f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return f;
    }

    public final Vector3 normalize() {
        float f = 1.0f / (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public final Vector3 normalize(Vector3 vector3) {
        float f = 1.0f / (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        vector3.x = this.x * f;
        vector3.y = this.y * f;
        vector3.z = this.z * f;
        return vector3;
    }

    public final Vector3 set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public final Vector3 set(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
        return this;
    }

    public final float dot(float f, float f2, float f3) {
        return f * this.x + f2 * this.y + f3 * this.z;
    }

    public static final float dot(Vector3 vector3, Vector3 vector32) {
        return vector3.x * vector32.x + vector3.y * vector32.y + vector3.z * vector32.z;
    }

    public static final Vector3 cross(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        vector33.x = vector3.y * vector32.z - vector3.z * vector32.y;
        vector33.y = vector3.z * vector32.x - vector3.x * vector32.z;
        vector33.z = vector3.x * vector32.y - vector3.y * vector32.x;
        return vector33;
    }

    public static final Vector3 add(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        vector33.x = vector3.x + vector32.x;
        vector33.y = vector3.y + vector32.y;
        vector33.z = vector3.z + vector32.z;
        return vector33;
    }

    public static final Vector3 sub(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        vector33.x = vector3.x - vector32.x;
        vector33.y = vector3.y - vector32.y;
        vector33.z = vector3.z - vector32.z;
        return vector33;
    }

    public final String toString() {
        return String.format("(%.2f, %.2f, %.2f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    static {
        for (int i = 0; i < 256; ++i) {
            double d = (double)i * Math.PI / 256.0;
            Vector3.COS_THETA[i] = (float)Math.cos(d);
            Vector3.SIN_THETA[i] = (float)Math.sin(d);
            Vector3.COS_PHI[i] = (float)Math.cos(2.0 * d);
            Vector3.SIN_PHI[i] = (float)Math.sin(2.0 * d);
        }
    }
}

