"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateHover = void 0;
const utils_1 = require("../utils");
const sveltekit_1 = require("./sveltekit");
function decorateHover(ls, info, ts, logger) {
    const getQuickInfoAtPosition = ls.getQuickInfoAtPosition;
    ls.getQuickInfoAtPosition = (fileName, position) => {
        var _a, _b;
        const result = (0, sveltekit_1.getVirtualLS)(fileName, info, ts);
        if (!result)
            return getQuickInfoAtPosition(fileName, position);
        const { languageService, toOriginalPos, toVirtualPos } = result;
        const virtualPos = toVirtualPos(position);
        const quickInfo = languageService.getQuickInfoAtPosition(fileName, virtualPos);
        if (!quickInfo)
            return quickInfo;
        const source = (_a = languageService.getProgram()) === null || _a === void 0 ? void 0 : _a.getSourceFile(fileName);
        const node = source && (0, utils_1.findNodeAtPosition)(source, virtualPos);
        if (node && (0, utils_1.isTopLevelExport)(ts, node, source) && ts.isIdentifier(node)) {
            const name = node.text;
            if (name in sveltekit_1.kitExports) {
                quickInfo.documentation = !((_b = quickInfo.documentation) === null || _b === void 0 ? void 0 : _b.length)
                    ? sveltekit_1.kitExports[name].documentation
                    : quickInfo.documentation;
            }
        }
        return {
            ...quickInfo,
            textSpan: { ...quickInfo.textSpan, start: toOriginalPos(quickInfo.textSpan.start).pos }
        };
    };
}
exports.decorateHover = decorateHover;
//# sourceMappingURL=hover.js.map