/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.ByteOrderWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.GeometryInfoGenerator;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Triangulator;
import java.util.HashMap;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class GeometryInfo {
    public static final int TRIANGLE_ARRAY = 1;
    public static final int QUAD_ARRAY = 2;
    public static final int TRIANGLE_FAN_ARRAY = 3;
    public static final int TRIANGLE_STRIP_ARRAY = 4;
    public static final int POLYGON_ARRAY = 5;
    private int prim;
    private static final int DEBUG = 0;
    private Point3f[] coordinates = null;
    private Color3f[] colors3 = null;
    private Color4f[] colors4 = null;
    private Vector3f[] normals = null;
    private Object[][] texCoordSets = null;
    private int[] coordinateIndices = null;
    private int[] colorIndices = null;
    private int[] normalIndices = null;
    private int[][] texCoordIndexSets = null;
    private int[] texCoordSetMap = null;
    private int texCoordSetCount = 0;
    private int texCoordDim = 0;
    private int[] stripCounts = null;
    private int[] contourCounts = null;
    private Triangulator tr = null;
    private NormalGenerator ng = null;
    private int oldPrim = 0;
    private int[] oldStripCounts = null;
    private boolean coordOnly = false;

    public GeometryInfo(int n) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n;
    }

    public GeometryInfo(GeometryArray geometryArray) {
        GeometryInfoGenerator.create(this, geometryArray);
    }

    public void reset(int n) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n;
        this.coordinates = null;
        this.colors3 = null;
        this.colors4 = null;
        this.normals = null;
        this.coordinateIndices = null;
        this.colorIndices = null;
        this.normalIndices = null;
        this.stripCounts = null;
        this.contourCounts = null;
        this.oldPrim = 0;
        this.oldStripCounts = null;
        this.texCoordDim = 0;
        this.texCoordSetCount = 0;
        this.texCoordSets = null;
        this.texCoordIndexSets = null;
        this.texCoordSetMap = null;
        this.coordOnly = false;
    }

    public void reset(GeometryArray geometryArray) {
        GeometryInfoGenerator.create(this, geometryArray);
    }

    private int[] expandQuad(int[] nArray) {
        int[] nArray2 = new int[nArray.length / 4 * 6];
        for (int i = 0; i < nArray.length / 4; ++i) {
            nArray2[i * 6 + 0] = nArray[i * 4];
            nArray2[i * 6 + 1] = nArray[i * 4 + 1];
            nArray2[i * 6 + 2] = nArray[i * 4 + 2];
            nArray2[i * 6 + 3] = nArray[i * 4];
            nArray2[i * 6 + 4] = nArray[i * 4 + 2];
            nArray2[i * 6 + 5] = nArray[i * 4 + 3];
        }
        return nArray2;
    }

    private int[] expandTriFan(int n, int[] nArray) {
        int[] nArray2 = new int[n * 3];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.stripCounts.length; ++i) {
            for (int j = 0; j < this.stripCounts[i] - 2; ++j) {
                nArray2[n2++] = nArray[n3];
                nArray2[n2++] = nArray[n3 + j + 1];
                nArray2[n2++] = nArray[n3 + j + 2];
            }
            n3 += this.stripCounts[i];
        }
        return nArray2;
    }

    private int[] expandTriStrip(int n, int[] nArray) {
        int[] nArray2 = new int[n * 3];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.stripCounts.length; ++i) {
            for (int j = 0; j < this.stripCounts[i] - 2; ++j) {
                if (j % 2 == 0) {
                    nArray2[n2++] = nArray[n3 + j + 0];
                    nArray2[n2++] = nArray[n3 + j + 1];
                    nArray2[n2++] = nArray[n3 + j + 2];
                    continue;
                }
                nArray2[n2++] = nArray[n3 + j + 0];
                nArray2[n2++] = nArray[n3 + j + 2];
                nArray2[n2++] = nArray[n3 + j + 1];
            }
            n3 += this.stripCounts[i];
        }
        return nArray2;
    }

    void rememberOldPrim() {
        this.oldPrim = this.prim;
        this.oldStripCounts = this.stripCounts;
    }

    int getOldPrim() {
        return this.oldPrim;
    }

    void forgetOldPrim() {
        this.oldPrim = 0;
        this.oldStripCounts = null;
    }

    private void changeBackToOldPrim() {
        if (this.oldPrim != 0) {
            this.convertToIndexedTriangles();
            if (this.ng == null) {
                this.ng = new NormalGenerator();
            }
            this.ng.convertBackToOldPrim(this, this.oldPrim, this.oldStripCounts);
            this.oldPrim = 0;
            this.oldStripCounts = null;
        }
    }

    public void convertToIndexedTriangles() {
        int n = 0;
        this.indexify();
        if (this.prim == 1) {
            return;
        }
        switch (this.prim) {
            case 2: {
                this.coordinateIndices = this.expandQuad(this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandQuad(this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandQuad(this.normalIndices);
                }
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    this.texCoordIndexSets[i] = this.expandQuad(this.texCoordIndexSets[i]);
                }
                break;
            }
            case 3: {
                int n2;
                for (n2 = 0; n2 < this.stripCounts.length; ++n2) {
                    n += this.stripCounts[n2] - 2;
                }
                this.coordinateIndices = this.expandTriFan(n, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriFan(n, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriFan(n, this.normalIndices);
                }
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.texCoordIndexSets[n2] = this.expandTriFan(n, this.texCoordIndexSets[n2]);
                }
                break;
            }
            case 4: {
                int n3;
                for (n3 = 0; n3 < this.stripCounts.length; ++n3) {
                    n += this.stripCounts[n3] - 2;
                }
                this.coordinateIndices = this.expandTriStrip(n, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriStrip(n, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriStrip(n, this.normalIndices);
                }
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.texCoordIndexSets[n3] = this.expandTriStrip(n, this.texCoordIndexSets[n3]);
                }
                break;
            }
            case 5: {
                if (this.tr == null) {
                    this.tr = new Triangulator();
                }
                this.tr.triangulate(this);
            }
        }
        this.prim = 1;
        this.stripCounts = null;
    }

    public int getPrimitive() {
        return this.prim;
    }

    void setPrimitive(int n) {
        if (this.prim < 1 || this.prim > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n;
    }

    public void setCoordinates(Point3f[] point3fArray) {
        this.coordinates = point3fArray;
    }

    public void setCoordinates(Point3d[] point3dArray) {
        if (point3dArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[point3dArray.length];
            for (int i = 0; i < point3dArray.length; ++i) {
                this.coordinates[i] = new Point3f((float)point3dArray[i].x, (float)point3dArray[i].y, (float)point3dArray[i].z);
            }
        }
    }

    public void setCoordinates(float[] fArray) {
        if (fArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[fArray.length / 3];
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = new Point3f(fArray[i * 3], fArray[i * 3 + 1], fArray[i * 3 + 2]);
            }
        }
    }

    public void setCoordinates(double[] dArray) {
        if (dArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[dArray.length / 3];
            for (int i = 0; i < dArray.length / 3; ++i) {
                this.coordinates[i] = new Point3f((float)dArray[i * 3], (float)dArray[i * 3 + 1], (float)dArray[i * 3 + 2]);
            }
        }
    }

    public Point3f[] getCoordinates() {
        return this.coordinates;
    }

    public void setColors(Color3f[] color3fArray) {
        this.colors3 = color3fArray;
        this.colors4 = null;
    }

    public void setColors(Color4f[] color4fArray) {
        this.colors3 = null;
        this.colors4 = color4fArray;
    }

    public void setColors(Color3b[] color3bArray) {
        if (color3bArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[color3bArray.length];
            this.colors4 = null;
            for (int i = 0; i < color3bArray.length; ++i) {
                this.colors3[i] = new Color3f((float)(color3bArray[i].x & 0xFF) / 255.0f, (float)(color3bArray[i].y & 0xFF) / 255.0f, (float)(color3bArray[i].z & 0xFF) / 255.0f);
            }
        }
    }

    public void setColors(Color4b[] color4bArray) {
        if (color4bArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[color4bArray.length];
            for (int i = 0; i < color4bArray.length; ++i) {
                this.colors4[i] = new Color4f((float)(color4bArray[i].x & 0xFF) / 255.0f, (float)(color4bArray[i].y & 0xFF) / 255.0f, (float)(color4bArray[i].z & 0xFF) / 255.0f, (float)(color4bArray[i].w & 0xFF) / 255.0f);
            }
        }
    }

    public void setColors3(float[] fArray) {
        if (fArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[fArray.length / 3];
            this.colors4 = null;
            for (int i = 0; i < fArray.length / 3; ++i) {
                this.colors3[i] = new Color3f(fArray[i * 3], fArray[i * 3 + 1], fArray[i * 3 + 2]);
            }
        }
    }

    public void setColors4(float[] fArray) {
        if (fArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[fArray.length / 4];
            for (int i = 0; i < fArray.length / 4; ++i) {
                this.colors4[i] = new Color4f(fArray[i * 4], fArray[i * 4 + 1], fArray[i * 4 + 2], fArray[i * 4 + 3]);
            }
        }
    }

    public void setColors3(byte[] byArray) {
        if (byArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[byArray.length / 3];
            this.colors4 = null;
            for (int i = 0; i < byArray.length / 3; ++i) {
                this.colors3[i] = new Color3f((float)(byArray[i * 3] & 0xFF) / 255.0f, (float)(byArray[i * 3 + 1] & 0xFF) / 255.0f, (float)(byArray[i * 3 + 2] & 0xFF) / 255.0f);
            }
        }
    }

    public void setColors4(byte[] byArray) {
        if (byArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[byArray.length / 4];
            for (int i = 0; i < byArray.length / 4; ++i) {
                this.colors4[i] = new Color4f((float)(byArray[i * 4] & 0xFF) / 255.0f, (float)(byArray[i * 4 + 1] & 0xFF) / 255.0f, (float)(byArray[i * 4 + 2] & 0xFF) / 255.0f, (float)(byArray[i * 4 + 3] & 0xFF) / 255.0f);
            }
        }
    }

    public Object[] getColors() {
        if (this.colors3 != null) {
            return this.colors3;
        }
        return this.colors4;
    }

    public int getNumColorComponents() {
        if (this.colors3 != null) {
            return 3;
        }
        if (this.colors4 != null) {
            return 4;
        }
        return 0;
    }

    public void setNormals(Vector3f[] vector3fArray) {
        this.normals = vector3fArray;
    }

    public void setNormals(float[] fArray) {
        if (fArray == null) {
            this.normals = null;
        } else {
            this.normals = new Vector3f[fArray.length / 3];
            for (int i = 0; i < this.normals.length; ++i) {
                this.normals[i] = new Vector3f(fArray[i * 3], fArray[i * 3 + 1], fArray[i * 3 + 2]);
            }
        }
    }

    public Vector3f[] getNormals() {
        return this.normals;
    }

    public void setTextureCoordinateParams(int n, int n2) {
        if (n2 == 2) {
            this.texCoordSets = new TexCoord2f[n][];
        } else if (n2 == 3) {
            this.texCoordSets = new TexCoord3f[n][];
        } else if (n2 == 4) {
            this.texCoordSets = new TexCoord4f[n][];
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo9"));
        }
        this.texCoordIndexSets = new int[n][];
        this.texCoordDim = n2;
        this.texCoordSetCount = n;
    }

    public int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    public int getNumTexCoordComponents() {
        return this.texCoordDim;
    }

    public void setTexCoordSetMap(int[] nArray) {
        this.texCoordSetMap = nArray;
    }

    public int[] getTexCoordSetMap() {
        return this.texCoordSetMap;
    }

    public void setTextureCoordinates(int n, TexCoord2f[] texCoord2fArray) {
        if (this.texCoordDim != 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo15"));
        }
        if (n >= this.texCoordSetCount || n < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[n] = texCoord2fArray;
    }

    public void setTextureCoordinates(Point2f[] point2fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 2;
        this.texCoordSets = new TexCoord2f[1][];
        if (point2fArray != null) {
            TexCoord2f[] texCoord2fArray = new TexCoord2f[point2fArray.length];
            for (int i = 0; i < point2fArray.length; ++i) {
                texCoord2fArray[i] = new TexCoord2f((Tuple2f)point2fArray[i]);
            }
            this.texCoordSets[0] = texCoord2fArray;
        }
    }

    public void setTextureCoordinates(int n, TexCoord3f[] texCoord3fArray) {
        if (this.texCoordDim != 3) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo16"));
        }
        if (n >= this.texCoordSetCount || n < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[n] = texCoord3fArray;
    }

    public void setTextureCoordinates(Point3f[] point3fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 3;
        this.texCoordSets = new TexCoord3f[1][];
        if (point3fArray != null) {
            TexCoord3f[] texCoord3fArray = new TexCoord3f[point3fArray.length];
            for (int i = 0; i < point3fArray.length; ++i) {
                texCoord3fArray[i] = new TexCoord3f((Tuple3f)point3fArray[i]);
            }
            this.texCoordSets[0] = texCoord3fArray;
        }
    }

    public void setTextureCoordinates(int n, TexCoord4f[] texCoord4fArray) {
        if (this.texCoordDim != 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo17"));
        }
        if (n >= this.texCoordSetCount || n < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[n] = texCoord4fArray;
    }

    public void setTextureCoordinates(int n, float[] fArray) {
        if (fArray.length % this.texCoordDim != 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo2"));
        }
        if (this.texCoordDim == 2) {
            TexCoord2f[] texCoord2fArray = new TexCoord2f[fArray.length / 2];
            for (int i = 0; i < texCoord2fArray.length; ++i) {
                texCoord2fArray[i] = new TexCoord2f(fArray[i * 2], fArray[i * 2 + 1]);
            }
            this.setTextureCoordinates(n, texCoord2fArray);
        } else if (this.texCoordDim == 3) {
            TexCoord3f[] texCoord3fArray = new TexCoord3f[fArray.length / 3];
            for (int i = 0; i < texCoord3fArray.length; ++i) {
                texCoord3fArray[i] = new TexCoord3f(fArray[i * 3], fArray[i * 3 + 1], fArray[i * 3 + 2]);
            }
            this.setTextureCoordinates(n, texCoord3fArray);
        } else if (this.texCoordDim == 4) {
            TexCoord4f[] texCoord4fArray = new TexCoord4f[fArray.length / 4];
            for (int i = 0; i < texCoord4fArray.length; ++i) {
                texCoord4fArray[i] = new TexCoord4f(fArray[i * 4], fArray[i * 4 + 1], fArray[i * 4 + 2], fArray[i * 4 + 3]);
            }
            this.setTextureCoordinates(n, texCoord4fArray);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo21"));
        }
    }

    public void setTextureCoordinates2(float[] fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 2;
        this.texCoordSets = new TexCoord2f[1][];
        this.setTextureCoordinates(0, fArray);
    }

    public void setTextureCoordinates3(float[] fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 3;
        this.texCoordSets = new TexCoord3f[1][];
        this.setTextureCoordinates(0, fArray);
    }

    public Object[] getTextureCoordinates(int n) {
        if (n >= this.texCoordSetCount || n < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        return this.texCoordSets[n];
    }

    public Object[] getTextureCoordinates() {
        return this.texCoordSets[0];
    }

    public void setCoordinateIndices(int[] nArray) {
        this.coordinateIndices = nArray;
    }

    public int[] getCoordinateIndices() {
        return this.coordinateIndices;
    }

    public void setColorIndices(int[] nArray) {
        this.colorIndices = nArray;
    }

    public int[] getColorIndices() {
        return this.colorIndices;
    }

    public void setNormalIndices(int[] nArray) {
        this.normalIndices = nArray;
    }

    public int[] getNormalIndices() {
        return this.normalIndices;
    }

    public void setTextureCoordinateIndices(int n, int[] nArray) {
        if (n >= this.texCoordSetCount || n < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordIndexSets[n] = nArray;
    }

    public void setTextureCoordinateIndices(int[] nArray) {
        if (this.texCoordSetCount > 1) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo1"));
        }
        this.texCoordIndexSets = new int[1][];
        this.texCoordIndexSets[0] = nArray;
    }

    public int[] getTextureCoordinateIndices(int n) {
        return this.texCoordIndexSets[n];
    }

    public int[] getTextureCoordinateIndices() {
        if (this.texCoordIndexSets == null) {
            return null;
        }
        return this.texCoordIndexSets[0];
    }

    public void setStripCounts(int[] nArray) {
        this.stripCounts = nArray;
    }

    public int[] getStripCounts() {
        return this.stripCounts;
    }

    public void setContourCounts(int[] nArray) {
        this.contourCounts = nArray;
    }

    public int[] getContourCounts() {
        return this.contourCounts;
    }

    int[] getListIndices(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n = (Integer)hashMap.get(objectArray[i]);
            if (n == null) {
                nArray[i] = i;
                hashMap.put(objectArray[i], new Integer(i));
                continue;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    public void indexify(boolean bl) {
        this.checkForBadData();
        if (bl) {
            int n;
            int n2;
            if (this.coordOnly) {
                return;
            }
            this.indexify(false);
            int n3 = 1;
            if (this.colorIndices != null) {
                ++n3;
            }
            if (this.normalIndices != null) {
                ++n3;
            }
            n3 += this.texCoordSetCount;
            int n4 = this.coordinateIndices.length;
            Object[] objectArray = new IndexRow[n4];
            for (int i = 0; i < n4; ++i) {
                objectArray[i] = new IndexRow(n3);
                n2 = 0;
                ((IndexRow)objectArray[i]).set(n2++, this.coordinateIndices[i]);
                if (this.colorIndices != null) {
                    ((IndexRow)objectArray[i]).set(n2++, this.colorIndices[i]);
                }
                if (this.normalIndices != null) {
                    ((IndexRow)objectArray[i]).set(n2++, this.normalIndices[i]);
                }
                for (int j = 0; j < this.texCoordSetCount; ++j) {
                    ((IndexRow)objectArray[i]).set(n2++, this.texCoordIndexSets[j][i]);
                }
            }
            int[] nArray = this.getListIndices(objectArray);
            int[] nArray2 = new int[nArray.length];
            objectArray = (IndexRow[])this.compactData(nArray, objectArray, nArray2);
            nArray = nArray2;
            Point3f[] point3fArray = new Point3f[objectArray.length];
            Color3f[] color3fArray = null;
            Color4f[] color4fArray = null;
            Vector3f[] vector3fArray = null;
            Object[][] objectArray2 = null;
            if (this.colors3 != null) {
                color3fArray = new Color3f[objectArray.length];
            } else if (this.colors4 != null) {
                color4fArray = new Color4f[objectArray.length];
            }
            if (this.normals != null) {
                vector3fArray = new Vector3f[objectArray.length];
            }
            for (n = 0; n < this.texCoordSetCount; ++n) {
                if (this.texCoordDim == 2) {
                    if (n == 0) {
                        objectArray2 = new TexCoord2f[this.texCoordSetCount][];
                    }
                    objectArray2[n] = new TexCoord2f[objectArray.length];
                    continue;
                }
                if (this.texCoordDim == 3) {
                    if (n == 0) {
                        objectArray2 = new TexCoord3f[this.texCoordSetCount][];
                    }
                    objectArray2[n] = new TexCoord3f[objectArray.length];
                    continue;
                }
                if (this.texCoordDim != 4) continue;
                if (n == 0) {
                    objectArray2 = new TexCoord4f[this.texCoordSetCount][];
                }
                objectArray2[n] = new TexCoord4f[objectArray.length];
            }
            n4 = objectArray.length;
            for (n = 0; n < n4; ++n) {
                n2 = 0;
                point3fArray[n] = this.coordinates[((IndexRow)objectArray[n]).get(n2++)];
                if (this.colors3 != null) {
                    color3fArray[n] = this.colors3[((IndexRow)objectArray[n]).get(n2++)];
                } else if (this.colors4 != null) {
                    color4fArray[n] = this.colors4[((IndexRow)objectArray[n]).get(n2++)];
                }
                if (this.normals != null) {
                    vector3fArray[n] = this.normals[((IndexRow)objectArray[n]).get(n2++)];
                }
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    objectArray2[i][n] = this.texCoordSets[i][((IndexRow)objectArray[n]).get(n2++)];
                }
            }
            this.coordinates = point3fArray;
            this.colors3 = color3fArray;
            this.colors4 = color4fArray;
            this.normals = vector3fArray;
            this.texCoordSets = objectArray2;
            this.coordinateIndices = nArray;
            this.colorIndices = null;
            this.normalIndices = null;
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            this.coordOnly = true;
        } else if (this.coordOnly) {
            int n;
            int n5 = this.coordinateIndices.length;
            if (this.colors3 != null || this.colors4 != null) {
                this.colorIndices = new int[n5];
                for (n = 0; n < n5; ++n) {
                    this.colorIndices[n] = this.coordinateIndices[n];
                }
            }
            if (this.normals != null) {
                this.normalIndices = new int[n5];
                for (n = 0; n < n5; ++n) {
                    this.normalIndices[n] = this.coordinateIndices[n];
                }
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            for (n = 0; n < this.texCoordSetCount; ++n) {
                this.texCoordIndexSets[n] = new int[n5];
                for (int i = 0; i < n5; ++i) {
                    this.texCoordIndexSets[n][i] = this.coordinateIndices[i];
                }
            }
            this.coordOnly = false;
        } else {
            if (this.coordinateIndices != null) {
                return;
            }
            this.coordinateIndices = this.getListIndices(this.coordinates);
            if (this.colors3 != null) {
                this.colorIndices = this.getListIndices(this.colors3);
            } else if (this.colors4 != null) {
                this.colorIndices = this.getListIndices(this.colors4);
            }
            if (this.normals != null) {
                this.normalIndices = this.getListIndices(this.normals);
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            for (int i = 0; i < this.texCoordSetCount; ++i) {
                this.texCoordIndexSets[i] = this.getListIndices(this.texCoordSets[i]);
            }
            this.coordOnly = false;
        }
    }

    public void indexify() {
        this.indexify(false);
    }

    Object[] allocateArray(Object[] objectArray, int n) {
        Object[] objectArray2 = null;
        if (objectArray instanceof Point3f[]) {
            objectArray2 = new Point3f[n];
        } else if (objectArray instanceof Vector3f[]) {
            objectArray2 = new Vector3f[n];
        } else if (objectArray instanceof Color3f[]) {
            objectArray2 = new Color3f[n];
        } else if (objectArray instanceof Color4f[]) {
            objectArray2 = new Color4f[n];
        } else if (objectArray instanceof TexCoord2f[]) {
            objectArray2 = new TexCoord2f[n];
        } else if (objectArray instanceof TexCoord3f[]) {
            objectArray2 = new TexCoord3f[n];
        } else if (objectArray instanceof TexCoord4f[]) {
            objectArray2 = new TexCoord4f[n];
        } else if (objectArray instanceof IndexRow[]) {
            objectArray2 = new IndexRow[n];
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo9"));
        }
        return objectArray2;
    }

    private Object[] compactData(int[] nArray, Object[] objectArray, int[] nArray2) {
        int n;
        int n2;
        Object[] objectArray2 = null;
        int n3 = 0;
        int[] nArray3 = new int[objectArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray3[nArray[n2]] != 0) continue;
            ++n3;
            nArray3[nArray[n2]] = 1;
        }
        objectArray2 = this.allocateArray(objectArray, n3);
        n2 = 0;
        for (n = 0; n < nArray3.length; ++n) {
            if (nArray3[n] == 0) continue;
            objectArray2[n2] = objectArray[n];
            nArray3[n] = n2++;
        }
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = nArray3[nArray[n]];
        }
        return objectArray2;
    }

    public void compact() {
        this.checkForBadData();
        if (this.coordinateIndices == null) {
            return;
        }
        if (this.coordOnly) {
            return;
        }
        int[] nArray = new int[this.coordinateIndices.length];
        this.coordinates = (Point3f[])this.compactData(this.coordinateIndices, this.coordinates, nArray);
        this.coordinateIndices = nArray;
        if (this.colorIndices != null) {
            nArray = new int[this.colorIndices.length];
            if (this.colors3 != null) {
                this.colors3 = (Color3f[])this.compactData(this.colorIndices, this.colors3, nArray);
            } else if (this.colors4 != null) {
                this.colors4 = (Color4f[])this.compactData(this.colorIndices, this.colors4, nArray);
            }
            this.colorIndices = nArray;
        }
        if (this.normalIndices != null) {
            nArray = new int[this.normalIndices.length];
            this.normals = (Vector3f[])this.compactData(this.normalIndices, this.normals, nArray);
            this.normalIndices = nArray;
        }
        for (int i = 0; i < this.texCoordSetCount; ++i) {
            nArray = new int[this.texCoordIndexSets[i].length];
            this.texCoordSets[i] = this.compactData(this.texCoordIndexSets[i], this.texCoordSets[i], nArray);
            this.texCoordIndexSets[i] = nArray;
        }
    }

    private void checkForBadData() {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        if (this.coordinates == null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo3"));
        }
        if (this.colors3 == null && this.colors4 == null && this.colorIndices != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo4"));
        }
        if (this.normals == null && this.normalIndices != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo11"));
        }
        for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
            if (this.texCoordSets[n4] != null) continue;
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo10"));
        }
        n4 = 0;
        if (this.texCoordIndexSets != null) {
            for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                if (this.texCoordIndexSets[n3] == null) continue;
                n4 = 1;
            }
        }
        if (this.coordinateIndices != null || this.colorIndices != null || this.normalIndices != null || n4 != 0) {
            if (this.coordinateIndices == null) {
                bl = true;
            } else if (this.coordOnly) {
                if (this.colorIndices != null || this.normalIndices != null || n4 == 1) {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo20"));
                }
            } else if ((this.colors3 != null || this.colors4 != null) && this.colorIndices == null) {
                bl = true;
            } else if (this.normals != null && this.normalIndices == null) {
                bl = true;
            } else if (this.texCoordSetCount > 0 && n4 == 0) {
                bl = true;
            }
            if (bl) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo19"));
            }
        }
        if (this.coordinateIndices != null && !this.coordOnly) {
            if ((this.colors3 != null || this.colors4 != null) && this.colorIndices.length != this.coordinateIndices.length) {
                bl = true;
            } else if (this.normals != null && this.normalIndices.length != this.coordinateIndices.length) {
                bl = true;
            } else {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    if (this.texCoordIndexSets[n3].length == this.coordinateIndices.length) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo5"));
            }
        }
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            if (this.stripCounts == null) {
                bl = true;
            }
        } else if (this.stripCounts != null) {
            bl = true;
        }
        if (bl) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo6"));
        }
        n3 = this.coordinateIndices == null ? this.coordinates.length : this.coordinateIndices.length;
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            n2 = 0;
            for (n = 0; n < this.stripCounts.length; ++n) {
                n2 += this.stripCounts[n];
            }
            if (n2 != n3) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo7"));
            }
        } else if (this.prim == 1) {
            if (n3 % 3 != 0) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo12"));
            }
        } else if (this.prim == 2 && n3 % 4 != 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo13"));
        }
        if (this.prim == 5) {
            if (this.contourCounts != null) {
                n2 = 0;
                for (n = 0; n < this.contourCounts.length; ++n) {
                    n2 += this.contourCounts[n];
                }
                if (n2 != this.stripCounts.length) {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo8"));
                }
            }
        } else if (this.contourCounts != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo14"));
        }
    }

    public void unindexify() {
        this.checkForBadData();
        if (this.coordinateIndices != null) {
            if (this.coordOnly) {
                this.indexify(false);
            }
            this.coordinates = (Point3f[])this.unindexifyData(this.coordinates, this.coordinateIndices);
            this.coordinateIndices = null;
            if (this.colors3 != null) {
                this.colors3 = (Color3f[])this.unindexifyData(this.colors3, this.colorIndices);
            } else if (this.colors4 != null) {
                this.colors4 = (Color4f[])this.unindexifyData(this.colors4, this.colorIndices);
            }
            this.colorIndices = null;
            if (this.normals != null) {
                this.normals = (Vector3f[])this.unindexifyData(this.normals, this.normalIndices);
                this.normalIndices = null;
            }
            for (int i = 0; i < this.texCoordSetCount; ++i) {
                this.texCoordSets[i] = this.unindexifyData(this.texCoordSets[i], this.texCoordIndexSets[i]);
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
        }
    }

    private Object[] unindexifyData(Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = this.allocateArray(objectArray, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            objectArray2[i] = objectArray[nArray[i]];
        }
        return objectArray2;
    }

    private int getVertexFormat() {
        int n = 1;
        if (this.colors3 != null) {
            n |= 4;
        } else if (this.colors4 != null) {
            n |= 0xC;
        }
        if (this.normals != null) {
            n |= 2;
        }
        if (this.texCoordDim == 2) {
            n |= 0x20;
        } else if (this.texCoordDim == 3) {
            n |= 0x40;
        } else if (this.texCoordDim == 4) {
            n |= 0x400;
        }
        return n;
    }

    private int getVertexCount() {
        int n = this.coordinates.length;
        if (this.colors3 != null) {
            if (this.colors3.length > n) {
                n = this.colors3.length;
            }
        } else if (this.colors4 != null && this.colors4.length > n) {
            n = this.colors4.length;
        }
        if (this.normals != null && this.normals.length > n) {
            n = this.normals.length;
        }
        for (int i = 0; i < this.texCoordSetCount; ++i) {
            if (this.texCoordSets[i].length <= n) continue;
            n = this.texCoordSets[i].length;
        }
        return n;
    }

    private float[] vecmathToFloat(Object[] objectArray) {
        if (objectArray[0] instanceof Tuple2f) {
            float[] fArray = new float[objectArray.length * 2];
            Tuple2f[] tuple2fArray = (Tuple2f[])objectArray;
            for (int i = 0; i < objectArray.length; ++i) {
                fArray[i * 2] = tuple2fArray[i].x;
                fArray[i * 2 + 1] = tuple2fArray[i].y;
            }
            return fArray;
        }
        if (objectArray[0] instanceof Tuple3f) {
            float[] fArray = new float[objectArray.length * 3];
            Tuple3f[] tuple3fArray = (Tuple3f[])objectArray;
            for (int i = 0; i < objectArray.length; ++i) {
                fArray[i * 3] = tuple3fArray[i].x;
                fArray[i * 3 + 1] = tuple3fArray[i].y;
                fArray[i * 3 + 2] = tuple3fArray[i].z;
            }
            return fArray;
        }
        if (objectArray[0] instanceof Tuple4f) {
            float[] fArray = new float[objectArray.length * 4];
            Tuple4f[] tuple4fArray = (Tuple4f[])objectArray;
            for (int i = 0; i < objectArray.length; ++i) {
                fArray[i * 4] = tuple4fArray[i].x;
                fArray[i * 4 + 1] = tuple4fArray[i].y;
                fArray[i * 4 + 2] = tuple4fArray[i].z;
                fArray[i * 4 + 3] = tuple4fArray[i].w;
            }
            return fArray;
        }
        return null;
    }

    private void fillIn(GeometryArray geometryArray, boolean bl, boolean bl2, boolean bl3) {
        int n;
        Object object;
        if (bl2) {
            int n2 = 3;
            if (this.normals != null) {
                n2 += 3;
            }
            if (this.colors3 != null) {
                n2 += 3;
            } else if (this.colors4 != null) {
                n2 += 4;
            }
            object = new float[(n2 += this.texCoordSetCount * this.texCoordDim) * this.coordinates.length];
            n = 0;
            for (int i = 0; i < this.coordinates.length; ++i) {
                int n3;
                if (this.texCoordDim == 2) {
                    for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                        object[n++] = ((TexCoord2f)this.texCoordSets[n3][i]).x;
                        object[n++] = ((TexCoord2f)this.texCoordSets[n3][i]).y;
                    }
                } else if (this.texCoordDim == 3) {
                    for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                        object[n++] = ((TexCoord3f)this.texCoordSets[n3][i]).x;
                        object[n++] = ((TexCoord3f)this.texCoordSets[n3][i]).y;
                        object[n++] = ((TexCoord3f)this.texCoordSets[n3][i]).z;
                    }
                } else if (this.texCoordDim == 4) {
                    for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                        object[n++] = ((TexCoord4f)this.texCoordSets[n3][i]).x;
                        object[n++] = ((TexCoord4f)this.texCoordSets[n3][i]).y;
                        object[n++] = ((TexCoord4f)this.texCoordSets[n3][i]).z;
                        object[n++] = ((TexCoord4f)this.texCoordSets[n3][i]).w;
                    }
                }
                if (this.colors3 != null) {
                    object[n++] = this.colors3[i].x;
                    object[n++] = this.colors3[i].y;
                    object[n++] = this.colors3[i].z;
                } else if (this.colors4 != null) {
                    object[n++] = this.colors4[i].x;
                    object[n++] = this.colors4[i].y;
                    object[n++] = this.colors4[i].z;
                    object[n++] = this.colors4[i].w;
                }
                if (this.normals != null) {
                    object[n++] = this.normals[i].x;
                    object[n++] = this.normals[i].y;
                    object[n++] = this.normals[i].z;
                }
                object[n++] = this.coordinates[i].x;
                object[n++] = this.coordinates[i].y;
                object[n++] = this.coordinates[i].z;
            }
            if (bl3) {
                ByteBufferWrapper byteBufferWrapper = ByteBufferWrapper.allocateDirect(((Object)object).length * 4);
                FloatBufferWrapper floatBufferWrapper = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                floatBufferWrapper.put((float[])object);
                geometryArray.setInterleavedVertexBuffer(floatBufferWrapper.getJ3DBuffer());
            } else {
                geometryArray.setInterleavedVertices((float[])object);
            }
        } else if (bl3) {
            ByteBufferWrapper byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.coordinates.length * 4 * 3);
            object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
            ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.coordinates));
            geometryArray.setCoordRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            if (this.colors3 != null) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.colors3.length * 4 * 3);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.colors3));
                geometryArray.setColorRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            } else if (this.colors4 != null) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.colors4.length * 4 * 4);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.colors4));
                geometryArray.setColorRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            }
            if (this.normals != null) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.normals.length * 4 * 3);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.normals));
                geometryArray.setNormalRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            }
            for (n = 0; n < this.texCoordSetCount; ++n) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.texCoordSets[n].length * 4 * this.texCoordDim);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.texCoordSets[n]));
                geometryArray.setTexCoordRefBuffer(n, ((FloatBufferWrapper)object).getJ3DBuffer());
            }
        } else if (bl) {
            geometryArray.setCoordRefFloat(this.vecmathToFloat(this.coordinates));
            if (this.colors3 != null) {
                geometryArray.setColorRefFloat(this.vecmathToFloat(this.colors3));
            } else if (this.colors4 != null) {
                geometryArray.setColorRefFloat(this.vecmathToFloat(this.colors4));
            }
            if (this.normals != null) {
                geometryArray.setNormalRefFloat(this.vecmathToFloat(this.normals));
            }
            for (int i = 0; i < this.texCoordSetCount; ++i) {
                geometryArray.setTexCoordRefFloat(i, this.vecmathToFloat(this.texCoordSets[i]));
            }
        } else {
            geometryArray.setCoordinates(0, this.coordinates);
            if (this.colors3 != null) {
                geometryArray.setColors(0, this.colors3);
            } else if (this.colors4 != null) {
                geometryArray.setColors(0, this.colors4);
            }
            if (this.normals != null) {
                geometryArray.setNormals(0, this.normals);
            }
            for (int i = 0; i < this.texCoordSetCount; ++i) {
                if (this.texCoordDim == 2) {
                    geometryArray.setTextureCoordinates(i, 0, (TexCoord2f[])this.texCoordSets[i]);
                    continue;
                }
                if (this.texCoordDim == 3) {
                    geometryArray.setTextureCoordinates(i, 0, (TexCoord3f[])this.texCoordSets[i]);
                    continue;
                }
                if (this.texCoordDim != 4) continue;
                geometryArray.setTextureCoordinates(i, 0, (TexCoord4f[])this.texCoordSets[i]);
            }
        }
        if (this.coordinateIndices != null) {
            IndexedGeometryArray indexedGeometryArray = null;
            indexedGeometryArray = (IndexedGeometryArray)geometryArray;
            indexedGeometryArray.setCoordinateIndices(0, this.coordinateIndices);
            if (!this.coordOnly) {
                if (this.colorIndices != null) {
                    indexedGeometryArray.setColorIndices(0, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    indexedGeometryArray.setNormalIndices(0, this.normalIndices);
                }
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    indexedGeometryArray.setTextureCoordinateIndices(i, 0, this.texCoordIndexSets[i]);
                }
            }
        }
    }

    public void recomputeIndices() {
        boolean bl = this.coordOnly;
        this.unindexify();
        this.indexify(bl);
    }

    private void reverseList(int[] nArray) {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length / 2; ++i) {
            int n = nArray[i];
            nArray[i] = nArray[nArray.length - i - 1];
            nArray[nArray.length - i - 1] = n;
        }
    }

    public void reverse() {
        this.indexify();
        this.reverseList(this.stripCounts);
        this.reverseList(this.oldStripCounts);
        this.reverseList(this.contourCounts);
        this.reverseList(this.coordinateIndices);
        this.reverseList(this.colorIndices);
        this.reverseList(this.normalIndices);
        for (int i = 0; i < this.texCoordSetCount; ++i) {
            this.reverseList(this.texCoordIndexSets[i]);
        }
    }

    public boolean getUseCoordIndexOnly() {
        return this.coordOnly;
    }

    public void setUseCoordIndexOnly(boolean bl) {
        this.coordOnly = bl;
    }

    public GeometryArray getGeometryArray(boolean bl, boolean bl2, boolean bl3) {
        this.checkForBadData();
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        this.unindexify();
        int n = this.getVertexFormat();
        if (bl3) {
            n |= 0x880;
        }
        if (bl2) {
            n |= 0x180;
        }
        if (bl) {
            n |= 0x80;
        }
        int n2 = this.coordinates.length;
        if (this.texCoordSetCount > 0 && this.texCoordSetMap == null) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 0;
        }
        TriangleArray triangleArray = null;
        switch (this.prim) {
            case 1: {
                TriangleArray triangleArray2;
                triangleArray = triangleArray2 = new TriangleArray(n2, n, this.texCoordSetCount, this.texCoordSetMap);
                break;
            }
            case 2: {
                QuadArray quadArray = new QuadArray(n2, n, this.texCoordSetCount, this.texCoordSetMap);
                triangleArray = quadArray;
                break;
            }
            case 4: {
                TriangleStripArray triangleStripArray = new TriangleStripArray(n2, n, this.texCoordSetCount, this.texCoordSetMap, this.stripCounts);
                triangleArray = triangleStripArray;
                break;
            }
            case 3: {
                TriangleFanArray triangleFanArray = new TriangleFanArray(n2, n, this.texCoordSetCount, this.texCoordSetMap, this.stripCounts);
                triangleArray = triangleFanArray;
            }
        }
        this.fillIn((GeometryArray)triangleArray, bl, bl2, bl3);
        return triangleArray;
    }

    public GeometryArray getGeometryArray() {
        return this.getGeometryArray(false, false, false);
    }

    public IndexedGeometryArray getIndexedGeometryArray(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n;
        int n2;
        this.indexify(bl4);
        if (bl) {
            this.compact();
        }
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        if (bl4 && !this.coordOnly) {
            boolean bl6 = true;
            if (this.coordinateIndices != null) {
                if (this.colorIndices != null && this.colorIndices.length != this.coordinateIndices.length) {
                    bl6 = false;
                }
                if (this.normalIndices != null && this.normalIndices.length != this.coordinateIndices.length) {
                    bl6 = false;
                }
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    if (this.texCoordIndexSets[n2] == null || this.texCoordIndexSets[n2].length == this.coordinateIndices.length) continue;
                    bl6 = false;
                    break;
                }
                if (bl6 && (this.colorIndices != null || this.normalIndices != null || this.texCoordSetCount > 0)) {
                    block7: for (n2 = 0; n2 < this.coordinateIndices.length; ++n2) {
                        int n3 = this.coordinateIndices[n2];
                        if (this.colorIndices != null && this.colorIndices[n2] != n3) {
                            bl6 = false;
                            break;
                        }
                        if (this.normalIndices != null && this.normalIndices[n2] != n3) {
                            bl6 = false;
                            break;
                        }
                        for (n = 0; n < this.texCoordSetCount; ++n) {
                            if (this.texCoordIndexSets[n] == null || this.texCoordIndexSets[n][n2] == n3) continue;
                            bl6 = false;
                            continue block7;
                        }
                    }
                }
            }
            this.coordOnly = bl6;
        }
        n2 = this.getVertexFormat();
        if (bl5) {
            n2 |= 0x880;
        }
        if (bl3) {
            n2 |= 0x180;
        }
        if (bl2) {
            n2 |= 0x80;
        }
        if (this.coordOnly) {
            n2 |= 0x200;
        }
        n = this.getVertexCount();
        if (this.texCoordSetCount > 0 && this.texCoordSetMap == null) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 0;
        }
        IndexedTriangleArray indexedTriangleArray = null;
        switch (this.prim) {
            case 1: {
                IndexedTriangleArray indexedTriangleArray2;
                indexedTriangleArray = indexedTriangleArray2 = new IndexedTriangleArray(n, n2, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length);
                break;
            }
            case 2: {
                IndexedQuadArray indexedQuadArray = new IndexedQuadArray(n, n2, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length);
                indexedTriangleArray = indexedQuadArray;
                break;
            }
            case 4: {
                IndexedTriangleStripArray indexedTriangleStripArray = new IndexedTriangleStripArray(n, n2, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length, this.stripCounts);
                indexedTriangleArray = indexedTriangleStripArray;
                break;
            }
            case 3: {
                IndexedTriangleFanArray indexedTriangleFanArray = new IndexedTriangleFanArray(n, n2, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length, this.stripCounts);
                indexedTriangleArray = indexedTriangleFanArray;
            }
        }
        this.fillIn((GeometryArray)indexedTriangleArray, bl2, bl3, bl5);
        return indexedTriangleArray;
    }

    public IndexedGeometryArray getIndexedGeometryArray(boolean bl) {
        return this.getIndexedGeometryArray(bl, false, false, false, false);
    }

    public IndexedGeometryArray getIndexedGeometryArray() {
        return this.getIndexedGeometryArray(false, false, false, false, false);
    }

    private class IndexRow {
        int[] val;
        int size;
        private static final int HASHCONST = -1161889074;

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.size; ++i) {
                n ^= n * -1161889074 << 2;
            }
            return n;
        }

        public boolean equals(Object object) {
            for (int i = 0; i < this.size; ++i) {
                if (((IndexRow)object).get(i) == this.val[i]) continue;
                return false;
            }
            return true;
        }

        public int get(int n) {
            return this.val[n];
        }

        public void set(int n, int n2) {
            this.val[n] = n2;
        }

        IndexRow(int n) {
            this.size = n;
            this.val = new int[this.size];
        }
    }
}

