/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IJavadocTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocModuleReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public IJavadocTypeReference[] usesReferences;
    public IJavadocTypeReference[] providesReferences;
    public long[] inheritedPositions = null;
    public JavadocSingleNameReference[] invalidParameters;
    public long valuePositions = -1L;

    public Javadoc(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.bits |= 0x10000;
    }

    boolean canBeSeen(int n, int n2) {
        if (n2 < 0) {
            return true;
        }
        switch (n2 & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return n != 1;
            }
            case 0: {
                return n == 0 || n == 2;
            }
            case 2: {
                return n == 2;
            }
        }
        return true;
    }

    public ASTNode getNodeStartingAt(int n) {
        int n2 = 0;
        if (this.paramReferences != null) {
            for (JavadocSingleNameReference expression2 : this.paramReferences) {
                if (expression2.sourceStart != n) continue;
                return expression2;
            }
        }
        if (this.invalidParameters != null) {
            for (JavadocSingleNameReference javadocSingleNameReference : this.invalidParameters) {
                if (javadocSingleNameReference.sourceStart != n) continue;
                return javadocSingleNameReference;
            }
        }
        if (this.paramTypeParameters != null) {
            for (JavadocSingleTypeReference javadocSingleTypeReference : this.paramTypeParameters) {
                if (javadocSingleTypeReference.sourceStart != n) continue;
                return javadocSingleTypeReference;
            }
        }
        if (this.exceptionReferences != null) {
            for (TypeReference typeReference : this.exceptionReferences) {
                if (typeReference.sourceStart != n) continue;
                return typeReference;
            }
        }
        if (this.seeReferences != null) {
            n2 = this.seeReferences.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                Expression expression;
                Expression expression2 = this.seeReferences[i];
                if (expression2.sourceStart == n) {
                    return expression2;
                }
                if (expression2 instanceof JavadocAllocationExpression) {
                    expression = (JavadocAllocationExpression)this.seeReferences[i];
                    if (expression.binding == null || !expression.binding.isValidBinding() || expression.arguments == null) continue;
                    n3 = expression.arguments.length;
                    for (int j = 0; j < n3; ++j) {
                        if (expression.arguments[j].sourceStart != n) continue;
                        return expression.arguments[j];
                    }
                    continue;
                }
                if (expression2 instanceof JavadocMessageSend) {
                    expression = (JavadocMessageSend)this.seeReferences[i];
                    if (((JavadocMessageSend)expression).binding == null || !((JavadocMessageSend)expression).binding.isValidBinding() || ((JavadocMessageSend)expression).arguments == null) continue;
                    n3 = ((JavadocMessageSend)expression).arguments.length;
                    for (int j = 0; j < n3; ++j) {
                        if (((JavadocMessageSend)expression).arguments[j].sourceStart != n) continue;
                        return ((JavadocMessageSend)expression).arguments[j];
                    }
                    continue;
                }
                if (expression2 instanceof JavadocModuleReference) {
                    expression = (JavadocModuleReference)expression2;
                    if (((JavadocModuleReference)expression).typeReference == null || ((JavadocModuleReference)expression).typeReference.sourceStart != n) continue;
                    return ((JavadocModuleReference)expression).typeReference;
                }
                if (!(expression2 instanceof JavadocFieldReference)) continue;
                expression = (JavadocFieldReference)expression2;
                if (!(((JavadocFieldReference)expression).receiver instanceof JavadocModuleReference)) continue;
                JavadocModuleReference javadocModuleReference = (JavadocModuleReference)((JavadocFieldReference)expression).receiver;
                if (javadocModuleReference.sourceStart == n) {
                    return javadocModuleReference;
                }
                if (javadocModuleReference.typeReference == null || javadocModuleReference.typeReference.sourceStart != n) continue;
                return javadocModuleReference.typeReference;
            }
        }
        return null;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        Javadoc.printIndent(n, stringBuffer).append("/**\n");
        if (this.paramReferences != null) {
            n3 = this.paramReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param ");
                this.paramReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        if (this.paramTypeParameters != null) {
            n3 = this.paramTypeParameters.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param <");
                this.paramTypeParameters[n2].print(n, stringBuffer).append(">\n");
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(n + 1, stringBuffer).append(" * @");
            this.returnStatement.print(n, stringBuffer).append('\n');
        }
        if (this.exceptionReferences != null) {
            n3 = this.exceptionReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @throws ");
                this.exceptionReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        if (this.seeReferences != null) {
            n3 = this.seeReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @see ");
                this.seeReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        Javadoc.printIndent(n, stringBuffer).append(" */\n");
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        int n;
        int n2;
        int n3;
        int n4;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        this.bits &= 0xFFFEFFFF;
        if (this.inheritedPositions != null) {
            n4 = this.inheritedPositions.length;
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = (int)(this.inheritedPositions[n3] >>> 32);
                int n6 = (int)this.inheritedPositions[n3];
                classScope.problemReporter().javadocUnexpectedTag(n5, n6);
            }
        }
        n4 = this.paramReferences == null ? 0 : this.paramReferences.length;
        for (n3 = 0; n3 < n4 && classScope.referenceContext.nRecordComponents <= 0; ++n3) {
            JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n3];
            classScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
        }
        this.resolveTypeParameterTags(classScope, true);
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        n3 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n7;
            int n8;
            TypeReference typeReference;
            TypeReference typeReference2 = this.exceptionReferences[n2];
            if (typeReference2 instanceof JavadocSingleTypeReference) {
                typeReference = (JavadocSingleTypeReference)typeReference2;
                n8 = typeReference.tagSourceStart;
                n7 = typeReference.tagSourceEnd;
            } else if (typeReference2 instanceof JavadocQualifiedTypeReference) {
                typeReference = (JavadocQualifiedTypeReference)typeReference2;
                n8 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                n7 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
            } else {
                n8 = typeReference2.sourceStart;
                n7 = typeReference2.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(n8, n7);
        }
        n2 = this.seeReferences == null ? 0 : this.seeReferences.length;
        for (n = 0; n < n2; ++n) {
            this.resolveReference(this.seeReferences[n], classScope);
        }
        int n9 = n = classScope.compilerOptions().sourceLevel >= 0x310000L ? 1 : 0;
        if (n == 0 && this.valuePositions != -1L) {
            classScope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
    }

    public void resolve(CompilationUnitScope compilationUnitScope) {
        if ((this.bits & 0x10000) == 0) {
            return;
        }
    }

    public void resolve(ModuleScope moduleScope) {
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        this.bits &= 0xFFFEFFFF;
        int n = this.seeReferences == null ? 0 : this.seeReferences.length;
        for (int i = 0; i < n; ++i) {
            this.resolveReference(this.seeReferences[i], moduleScope);
        }
        this.resolveUsesTags(moduleScope, true);
        this.resolveProvidesTags(moduleScope, true);
    }

    public void resolve(MethodScope methodScope) {
        boolean bl;
        int n;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        this.bits &= 0xFFFEFFFF;
        AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
        boolean bl2 = abstractMethodDeclaration == null || abstractMethodDeclaration.binding == null ? false : !abstractMethodDeclaration.binding.isStatic() && (abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0;
        int n2 = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean bl3 = false;
        for (n = 0; n < n2; n += 1) {
            MethodBinding methodBinding;
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding;
            Expression expression;
            this.resolveReference(this.seeReferences[n], methodScope);
            if (abstractMethodDeclaration == null || bl3) continue;
            if (!abstractMethodDeclaration.isConstructor()) {
                if (!bl2 || !(this.seeReferences[n] instanceof JavadocMessageSend)) continue;
                expression = (JavadocMessageSend)this.seeReferences[n];
                if (((JavadocMessageSend)expression).binding == null || !((JavadocMessageSend)expression).binding.isValidBinding() || !(((JavadocMessageSend)expression).actualReceiverType instanceof ReferenceBinding) || (typeBinding = abstractMethodDeclaration.binding.declaringClass.findSuperTypeOriginatingFrom(referenceBinding = (ReferenceBinding)((JavadocMessageSend)expression).actualReceiverType)) == null || !TypeBinding.notEquals(typeBinding.original(), abstractMethodDeclaration.binding.declaringClass) || !CharOperation.equals(((JavadocMessageSend)expression).selector, abstractMethodDeclaration.selector) || !methodScope.environment().methodVerifier().doesMethodOverride(abstractMethodDeclaration.binding, ((JavadocMessageSend)expression).binding.original())) continue;
                bl3 = true;
                continue;
            }
            if (!(this.seeReferences[n] instanceof JavadocAllocationExpression)) continue;
            expression = (JavadocAllocationExpression)this.seeReferences[n];
            if (expression.binding == null || !expression.binding.isValidBinding() || (typeBinding = (ReferenceBinding)abstractMethodDeclaration.binding.declaringClass.findSuperTypeOriginatingFrom(referenceBinding = (ReferenceBinding)expression.resolvedType.original())) == null || !TypeBinding.notEquals(typeBinding.original(), abstractMethodDeclaration.binding.declaringClass) || !(methodBinding = methodScope.getConstructor((ReferenceBinding)typeBinding, abstractMethodDeclaration.binding.parameters, (InvocationSite)((Object)expression))).isValidBinding() || methodBinding.original() != expression.binding.original()) continue;
            MethodBinding methodBinding2 = abstractMethodDeclaration.binding;
            if (methodScope.compilerOptions().sourceLevel >= 0x340000L && methodBinding2.typeVariables != Binding.NO_TYPE_VARIABLES) {
                methodBinding2 = methodBinding2.asRawMethod(methodScope.environment());
            }
            if (!methodBinding.areParametersEqual(methodBinding2)) continue;
            bl3 = true;
        }
        if (!bl3 && abstractMethodDeclaration != null && abstractMethodDeclaration.annotations != null) {
            n = abstractMethodDeclaration.annotations.length;
            for (int i = 0; i < n && !bl3; i += 1) {
                bl3 = (abstractMethodDeclaration.binding.tagBits & 0x2000000000000L) != 0L;
            }
        }
        int n3 = n = abstractMethodDeclaration == null || (!bl2 || this.inheritedPositions == null) && !bl3 && (abstractMethodDeclaration.binding.declaringClass == null || !abstractMethodDeclaration.binding.declaringClass.isLocalType()) ? 1 : 0;
        if (!bl2 && this.inheritedPositions != null) {
            int n4 = this.inheritedPositions.length;
            for (int i = 0; i < n4; ++i) {
                int n5 = (int)(this.inheritedPositions[i] >>> 32);
                int n6 = (int)this.inheritedPositions[i];
                methodScope.problemReporter().javadocUnexpectedTag(n5, n6);
            }
        }
        CompilerOptions compilerOptions = methodScope.compilerOptions();
        this.resolveParamTags(methodScope, n != 0, compilerOptions.reportUnusedParameterIncludeDocCommentReference);
        this.resolveTypeParameterTags(methodScope, n != 0 && compilerOptions.reportMissingJavadocTagsMethodTypeParameters);
        if (this.returnStatement == null) {
            if (n && abstractMethodDeclaration != null && abstractMethodDeclaration.isMethod()) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)abstractMethodDeclaration;
                if (methodDeclaration.binding.returnType != TypeBinding.VOID) {
                    methodScope.problemReporter().javadocMissingReturnTag(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methodScope);
        }
        this.resolveThrowsTags(methodScope, n != 0);
        boolean bl4 = bl = compilerOptions.sourceLevel >= 0x310000L;
        if (!bl && abstractMethodDeclaration != null && this.valuePositions != -1L) {
            methodScope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
        int n7 = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        for (int i = 0; i < n7; ++i) {
            this.invalidParameters[i].resolve(methodScope, false, false);
        }
    }

    private void resolveReference(Expression expression, Scope scope) {
        Object object;
        Object object2;
        int n = scope.referenceContext().compilationResult().problemCount;
        switch (scope.kind) {
            case 2: {
                expression.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                expression.resolveType((ClassScope)scope);
            }
        }
        boolean bl = scope.referenceContext().compilationResult().problemCount > n;
        boolean bl2 = scope.compilerOptions().sourceLevel >= 0x310000L;
        int n2 = -1;
        if (expression instanceof JavadocFieldReference) {
            ReferenceBinding referenceBinding;
            JavadocFieldReference javadocFieldReference = (JavadocFieldReference)expression;
            if (javadocFieldReference.methodBinding != null) {
                if (javadocFieldReference.tagValue == 10) {
                    if (n2 == -1) {
                        n2 = scope.getDeclarationModifiers();
                    }
                    scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n2);
                } else if (javadocFieldReference.actualReceiverType != null) {
                    if (scope.kind != 5 && scope.enclosingSourceType().isCompatibleWith(javadocFieldReference.actualReceiverType)) {
                        javadocFieldReference.bits |= 0x4000;
                    }
                    javadocFieldReference.methodBinding = CharOperation.equals((referenceBinding = (ReferenceBinding)javadocFieldReference.actualReceiverType).sourceName(), javadocFieldReference.token) ? scope.getConstructor(referenceBinding, Binding.NO_TYPES, javadocFieldReference) : scope.findMethod(referenceBinding, javadocFieldReference.token, Binding.NO_TYPES, javadocFieldReference, false);
                }
            } else if (bl2 && javadocFieldReference.binding != null && javadocFieldReference.binding.isValidBinding() && javadocFieldReference.tagValue == 10 && !javadocFieldReference.binding.isStatic()) {
                if (n2 == -1) {
                    n2 = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n2);
            }
            if (!bl && javadocFieldReference.binding != null && javadocFieldReference.binding.isValidBinding() && javadocFieldReference.actualReceiverType instanceof ReferenceBinding) {
                referenceBinding = (ReferenceBinding)javadocFieldReference.actualReceiverType;
                this.verifyTypeReference(javadocFieldReference, javadocFieldReference.receiver, scope, bl2, referenceBinding, javadocFieldReference.binding.modifiers);
            }
            return;
        }
        if (!bl && (expression instanceof JavadocSingleTypeReference || expression instanceof JavadocQualifiedTypeReference) && expression.resolvedType instanceof ReferenceBinding) {
            object2 = (ReferenceBinding)expression.resolvedType;
            this.verifyTypeReference(expression, expression, scope, bl2, (ReferenceBinding)object2, ((ReferenceBinding)object2).modifiers);
        }
        if (!bl && expression instanceof JavadocModuleReference) {
            TypeReference typeReference;
            ModuleBinding moduleBinding;
            object2 = (JavadocModuleReference)expression;
            ((JavadocModuleReference)object2).resolve(scope);
            object = ((JavadocModuleReference)object2).getModuleReference();
            if (object != null && (moduleBinding = ((ModuleReference)object).resolve(scope)) != null && this.verifyModuleReference(expression, expression, scope, bl2, moduleBinding, moduleBinding.modifiers) && ((typeReference = ((JavadocModuleReference)object2).getTypeReference()) instanceof JavadocSingleTypeReference || typeReference instanceof JavadocQualifiedTypeReference) && typeReference.resolvedType instanceof ReferenceBinding) {
                ReferenceBinding referenceBinding = (ReferenceBinding)typeReference.resolvedType;
                this.verifyTypeReference(expression, expression, scope, bl2, referenceBinding, referenceBinding.modifiers);
            }
        }
        if (expression instanceof JavadocMessageSend) {
            object2 = (JavadocMessageSend)expression;
            if (bl2 && ((JavadocMessageSend)object2).tagValue == 10) {
                if (n2 == -1) {
                    n2 = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(((JavadocMessageSend)object2).sourceStart, ((JavadocMessageSend)object2).sourceEnd, n2);
            }
            if (!bl && ((JavadocMessageSend)object2).binding != null && ((JavadocMessageSend)object2).binding.isValidBinding() && ((JavadocMessageSend)object2).actualReceiverType instanceof ReferenceBinding) {
                object = (ReferenceBinding)((JavadocMessageSend)object2).actualReceiverType;
                this.verifyTypeReference((Expression)object2, ((JavadocMessageSend)object2).receiver, scope, bl2, (ReferenceBinding)object, ((JavadocMessageSend)object2).binding.modifiers);
            }
        } else if (expression instanceof JavadocAllocationExpression) {
            object2 = (JavadocAllocationExpression)expression;
            if (bl2 && ((JavadocAllocationExpression)object2).tagValue == 10) {
                if (n2 == -1) {
                    n2 = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(((JavadocAllocationExpression)object2).sourceStart, ((JavadocAllocationExpression)object2).sourceEnd, n2);
            }
            if (!bl && ((JavadocAllocationExpression)object2).binding != null && ((JavadocAllocationExpression)object2).binding.isValidBinding() && ((JavadocAllocationExpression)object2).resolvedType instanceof ReferenceBinding) {
                object = (ReferenceBinding)((JavadocAllocationExpression)object2).resolvedType;
                this.verifyTypeReference((Expression)object2, ((JavadocAllocationExpression)object2).type, scope, bl2, (ReferenceBinding)object, ((JavadocAllocationExpression)object2).binding.modifiers);
            }
        } else if (expression instanceof JavadocSingleTypeReference && expression.resolvedType != null && expression.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(expression.sourceStart, expression.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope methodScope, boolean bl, boolean bl2) {
        block9: {
            int n;
            boolean bl3;
            Statement statement;
            int n2;
            int n3;
            int n4;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block8: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n5 = n4 = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (abstractMethodDeclaration == null) {
                    for (int i = 0; i < n4; ++i) {
                        JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[i];
                        methodScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                    }
                    return;
                }
                int n6 = n3 = abstractMethodDeclaration.arguments == null ? 0 : abstractMethodDeclaration.arguments.length;
                if (n4 != 0) break block8;
                if (!bl) break block9;
                for (int i = 0; i < n3; ++i) {
                    Argument argument = abstractMethodDeclaration.arguments[i];
                    methodScope.problemReporter().javadocMissingParamTag(argument.name, argument.sourceStart, argument.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
                break block9;
            }
            LocalVariableBinding[] localVariableBindingArray = new LocalVariableBinding[n4];
            int n7 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                statement = this.paramReferences[n2];
                statement.resolve(methodScope, true, bl2);
                if (statement.binding == null || !statement.binding.isValidBinding()) continue;
                bl3 = false;
                for (n = 0; n < n7 && !bl3; ++n) {
                    if (localVariableBindingArray[n] != statement.binding) continue;
                    methodScope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                    bl3 = true;
                }
                if (bl3) continue;
                localVariableBindingArray[n7++] = (LocalVariableBinding)statement.binding;
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    statement = abstractMethodDeclaration.arguments[n2];
                    bl3 = false;
                    for (n = 0; n < n7; ++n) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[n];
                        if (((Argument)statement).binding != localVariableBinding) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    methodScope.problemReporter().javadocMissingParamTag(((Argument)statement).name, ((Argument)statement).sourceStart, ((Argument)statement).sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        }
    }

    private void resolveUsesTags(BlockScope blockScope, boolean bl) {
        block11: {
            int n;
            boolean bl2;
            ASTNode aSTNode;
            int n2;
            int n3;
            int n4;
            ModuleDeclaration moduleDeclaration;
            block10: {
                moduleDeclaration = (ModuleDeclaration)blockScope.referenceContext();
                int n5 = n4 = this.usesReferences == null ? 0 : this.usesReferences.length;
                if (moduleDeclaration == null) {
                    for (int i = 0; i < n4; ++i) {
                        IJavadocTypeReference iJavadocTypeReference = this.usesReferences[i];
                        blockScope.problemReporter().javadocUnexpectedTag(iJavadocTypeReference.getTagSourceStart(), iJavadocTypeReference.getTagSourceEnd());
                    }
                    return;
                }
                n3 = moduleDeclaration.usesCount;
                if (n4 != 0) break block10;
                if (!bl) break block11;
                for (int i = 0; i < n3; ++i) {
                    UsesStatement usesStatement = moduleDeclaration.uses[i];
                    blockScope.problemReporter().javadocMissingUsesTag(usesStatement.serviceInterface, usesStatement.sourceStart, usesStatement.sourceEnd, moduleDeclaration.binding.modifiers);
                }
                break block11;
            }
            TypeBinding[] typeBindingArray = new TypeBinding[n4];
            int n6 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                aSTNode = (TypeReference)((Object)this.usesReferences[n2]);
                try {
                    aSTNode.resolve(blockScope);
                    if (aSTNode.resolvedType == null || !aSTNode.resolvedType.isValidBinding()) continue;
                    bl2 = false;
                    for (n = 0; n < n6 && !bl2; ++n) {
                        if (!typeBindingArray[n].equals(aSTNode.resolvedType)) continue;
                        blockScope.problemReporter().javadocDuplicatedUsesTag(aSTNode.sourceStart, aSTNode.sourceEnd);
                        bl2 = true;
                    }
                    if (bl2) continue;
                    typeBindingArray[n6++] = aSTNode.resolvedType;
                    continue;
                }
                catch (Exception exception) {
                    blockScope.problemReporter().javadocInvalidUsesClass(aSTNode.sourceStart, aSTNode.sourceEnd);
                }
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    aSTNode = moduleDeclaration.uses[n2];
                    bl2 = false;
                    for (n = 0; n < n6 && !bl2; ++n) {
                        TypeBinding typeBinding = typeBindingArray[n];
                        if (!((UsesStatement)aSTNode).serviceInterface.getTypeBinding(blockScope).equals(typeBinding)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    blockScope.problemReporter().javadocMissingUsesTag(((UsesStatement)aSTNode).serviceInterface, ((UsesStatement)aSTNode).sourceStart, ((UsesStatement)aSTNode).sourceEnd, moduleDeclaration.binding.modifiers);
                }
            }
        }
    }

    private void resolveProvidesTags(BlockScope blockScope, boolean bl) {
        block11: {
            int n;
            boolean bl2;
            ASTNode aSTNode;
            int n2;
            int n3;
            int n4;
            ModuleDeclaration moduleDeclaration;
            block10: {
                moduleDeclaration = (ModuleDeclaration)blockScope.referenceContext();
                int n5 = n4 = this.providesReferences == null ? 0 : this.providesReferences.length;
                if (moduleDeclaration == null) {
                    for (int i = 0; i < n4; ++i) {
                        IJavadocTypeReference iJavadocTypeReference = this.providesReferences[i];
                        blockScope.problemReporter().javadocUnexpectedTag(iJavadocTypeReference.getTagSourceStart(), iJavadocTypeReference.getTagSourceEnd());
                    }
                    return;
                }
                n3 = moduleDeclaration.servicesCount;
                if (n4 != 0) break block10;
                if (!bl) break block11;
                for (int i = 0; i < n3; ++i) {
                    ProvidesStatement providesStatement = moduleDeclaration.services[i];
                    blockScope.problemReporter().javadocMissingProvidesTag(providesStatement.serviceInterface, providesStatement.sourceStart, providesStatement.sourceEnd, moduleDeclaration.binding.modifiers);
                }
                break block11;
            }
            TypeBinding[] typeBindingArray = new TypeBinding[n4];
            int n6 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                aSTNode = (TypeReference)((Object)this.providesReferences[n2]);
                try {
                    aSTNode.resolve(blockScope);
                    if (aSTNode.resolvedType == null || !aSTNode.resolvedType.isValidBinding()) continue;
                    bl2 = false;
                    for (n = 0; n < n6 && !bl2; ++n) {
                        if (!typeBindingArray[n].equals(aSTNode.resolvedType)) continue;
                        blockScope.problemReporter().javadocDuplicatedProvidesTag(aSTNode.sourceStart, aSTNode.sourceEnd);
                        bl2 = true;
                    }
                    if (bl2) continue;
                    typeBindingArray[n6++] = aSTNode.resolvedType;
                    continue;
                }
                catch (Exception exception) {
                    blockScope.problemReporter().javadocInvalidProvidesClass(aSTNode.sourceStart, aSTNode.sourceEnd);
                }
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    aSTNode = moduleDeclaration.services[n2];
                    bl2 = false;
                    for (n = 0; n < n6 && !bl2; ++n) {
                        TypeBinding typeBinding = typeBindingArray[n];
                        if (!((ProvidesStatement)aSTNode).serviceInterface.getTypeBinding(blockScope).equals(typeBinding)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    blockScope.problemReporter().javadocMissingProvidesTag(((ProvidesStatement)aSTNode).serviceInterface, ((ProvidesStatement)aSTNode).sourceStart, ((ProvidesStatement)aSTNode).sourceEnd, moduleDeclaration.binding.modifiers);
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean bl) {
        block29: {
            int n;
            int n2;
            int n3;
            Object object;
            int n4;
            Object[] objectArray;
            int n5;
            TypeVariableBinding[] typeVariableBindingArray;
            TypeParameter[] typeParameterArray;
            int n6;
            block30: {
                n6 = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                int n7 = this.paramReferences == null ? 0 : this.paramReferences.length;
                typeParameterArray = null;
                typeVariableBindingArray = null;
                RecordComponent[] recordComponentArray = null;
                n5 = -1;
                switch (scope.kind) {
                    case 2: {
                        AbstractMethodDeclaration abstractMethodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (abstractMethodDeclaration == null) {
                            for (int i = 0; i < n6; ++i) {
                                JavadocSingleTypeReference javadocSingleTypeReference = this.paramTypeParameters[i];
                                scope.problemReporter().javadocUnexpectedTag(javadocSingleTypeReference.tagSourceStart, javadocSingleTypeReference.tagSourceEnd);
                            }
                            return;
                        }
                        typeParameterArray = abstractMethodDeclaration.typeParameters();
                        typeVariableBindingArray = abstractMethodDeclaration.binding.typeVariables;
                        n5 = abstractMethodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        objectArray = ((ClassScope)scope).referenceContext;
                        typeParameterArray = objectArray.typeParameters;
                        typeVariableBindingArray = objectArray.binding.typeVariables;
                        n5 = objectArray.binding.modifiers;
                        recordComponentArray = objectArray.recordComponents;
                    }
                }
                if (!(recordComponentArray != null && recordComponentArray.length != 0 || typeVariableBindingArray != null && typeVariableBindingArray.length != 0)) {
                    for (int i = 0; i < n6; ++i) {
                        objectArray = this.paramTypeParameters[i];
                        scope.problemReporter().javadocUnexpectedTag(objectArray.tagSourceStart, objectArray.tagSourceEnd);
                    }
                    return;
                }
                if (recordComponentArray != null) {
                    bl = bl && scope.compilerOptions().sourceLevel >= 0x310000L;
                    int n8 = recordComponentArray.length;
                    objectArray = new String[n7];
                    if (n7 == 0) {
                        if (bl) {
                            int n9 = n8;
                            for (n4 = 0; n4 < n9; ++n4) {
                                scope.problemReporter().javadocMissingParamTag(recordComponentArray[n4].name, recordComponentArray[n4].sourceStart, recordComponentArray[n4].sourceEnd, n5);
                            }
                        }
                    } else {
                        Object object2;
                        Statement statement;
                        for (n4 = 0; n4 < n7; ++n4) {
                            statement = this.paramReferences[n4];
                            object = new String(((SingleNameReference)statement).getName()[0]);
                            n3 = 0;
                            for (n2 = 0; n2 < n4 && n3 == 0; ++n2) {
                                if (!((String)object).equals(objectArray[n2])) continue;
                                scope.problemReporter().javadocDuplicatedParamTag(((JavadocSingleNameReference)statement).token, ((JavadocSingleNameReference)statement).sourceStart, ((JavadocSingleNameReference)statement).sourceEnd, n5);
                                n3 = 1;
                            }
                            if (n3 != 0) continue;
                            objectArray[n4] = object;
                        }
                        if (bl) {
                            for (n4 = 0; n4 < recordComponentArray.length; ++n4) {
                                statement = recordComponentArray[n4];
                                boolean bl2 = false;
                                for (n3 = 0; n3 < n7 && !bl2; ++n3) {
                                    JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n3];
                                    object2 = new String(javadocSingleNameReference.getName()[0]);
                                    if (!((String)object2).equals(new String(((RecordComponent)statement).name))) continue;
                                    bl2 = true;
                                }
                                if (bl2) continue;
                                scope.problemReporter().javadocMissingParamTag(((RecordComponent)statement).name, ((RecordComponent)statement).sourceStart, ((RecordComponent)statement).sourceEnd, n5);
                            }
                        }
                        for (n4 = 0; n4 < n7; ++n4) {
                            statement = this.paramReferences[n4];
                            object = new String(((SingleNameReference)statement).getName()[0]);
                            n3 = 0;
                            for (n2 = 0; n2 < recordComponentArray.length; ++n2) {
                                object2 = recordComponentArray[n2];
                                if (!((String)object).equals(new String(((RecordComponent)object2).name))) continue;
                                n3 = 1;
                            }
                            if (n3 != 0) continue;
                            scope.problemReporter().javadocInvalidParamTagName(((JavadocSingleNameReference)statement).sourceStart, ((JavadocSingleNameReference)statement).sourceEnd);
                        }
                    }
                }
                if (typeParameterArray == null) break block29;
                bl = bl && scope.compilerOptions().sourceLevel >= 0x310000L;
                n = typeParameterArray.length;
                if (n6 != 0) break block30;
                if (!bl) break block29;
                n4 = n;
                for (int i = 0; i < n4; ++i) {
                    scope.problemReporter().javadocMissingParamTag(typeParameterArray[i].name, typeParameterArray[i].sourceStart, typeParameterArray[i].sourceEnd, n5);
                }
                break block29;
            }
            if (typeVariableBindingArray.length == n) {
                objectArray = new TypeVariableBinding[n6];
                for (n4 = 0; n4 < n6; ++n4) {
                    JavadocSingleTypeReference javadocSingleTypeReference = this.paramTypeParameters[n4];
                    object = javadocSingleTypeReference.internalResolveType(scope, 0);
                    if (object == null || !((Binding)object).isValidBinding()) continue;
                    if (((TypeBinding)object).isTypeVariable()) {
                        if (scope.compilerOptions().reportUnusedParameterIncludeDocCommentReference) {
                            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)object;
                            typeVariableBinding.modifiers |= 0x8000000;
                        }
                        n3 = 0;
                        for (n2 = 0; n2 < n4 && n3 == 0; ++n2) {
                            if (!TypeBinding.equalsEquals((TypeBinding)objectArray[n2], javadocSingleTypeReference.resolvedType)) continue;
                            scope.problemReporter().javadocDuplicatedParamTag(javadocSingleTypeReference.token, javadocSingleTypeReference.sourceStart, javadocSingleTypeReference.sourceEnd, n5);
                            n3 = 1;
                        }
                        if (n3 != 0) continue;
                        objectArray[n4] = (TypeVariableBinding)javadocSingleTypeReference.resolvedType;
                        continue;
                    }
                    scope.problemReporter().javadocUndeclaredParamTagName(javadocSingleTypeReference.token, javadocSingleTypeReference.sourceStart, javadocSingleTypeReference.sourceEnd, n5);
                }
                for (n4 = 0; n4 < n; ++n4) {
                    TypeParameter typeParameter = typeParameterArray[n4];
                    boolean bl3 = false;
                    for (n3 = 0; n3 < n6 && !bl3; ++n3) {
                        if (!TypeBinding.equalsEquals(typeParameter.binding, (TypeBinding)objectArray[n3])) continue;
                        bl3 = true;
                        objectArray[n3] = null;
                    }
                    if (bl3 || !bl) continue;
                    scope.problemReporter().javadocMissingParamTag(typeParameter.name, typeParameter.sourceStart, typeParameter.sourceEnd, n5);
                }
                for (n4 = 0; n4 < n6; ++n4) {
                    if (objectArray[n4] == null) continue;
                    JavadocSingleTypeReference javadocSingleTypeReference = this.paramTypeParameters[n4];
                    scope.problemReporter().javadocUndeclaredParamTagName(javadocSingleTypeReference.token, javadocSingleTypeReference.sourceStart, javadocSingleTypeReference.sourceEnd, n5);
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methodScope, boolean bl) {
        block15: {
            TypeBinding typeBinding;
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block14: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n6 = n5 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (abstractMethodDeclaration == null) {
                    for (int i = 0; i < n5; ++i) {
                        TypeReference typeReference = this.exceptionReferences[i];
                        int n7 = typeReference.sourceStart;
                        int n8 = typeReference.sourceEnd;
                        if (typeReference instanceof JavadocQualifiedTypeReference) {
                            n7 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
                        } else if (typeReference instanceof JavadocSingleTypeReference) {
                            n7 = ((JavadocSingleTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocSingleTypeReference)typeReference).tagSourceEnd;
                        }
                        methodScope.problemReporter().javadocUnexpectedTag(n7, n8);
                    }
                    return;
                }
                n4 = abstractMethodDeclaration.binding == null ? 0 : abstractMethodDeclaration.binding.thrownExceptions.length;
                int n9 = n3 = abstractMethodDeclaration.thrownExceptions == null ? 0 : abstractMethodDeclaration.thrownExceptions.length;
                if (n5 != 0) break block14;
                if (!bl) break block15;
                for (int i = 0; i < n4; ++i) {
                    int n10;
                    ReferenceBinding referenceBinding = abstractMethodDeclaration.binding.thrownExceptions[i];
                    if (referenceBinding == null || !referenceBinding.isValidBinding()) continue;
                    for (n10 = i; n10 < n3 && TypeBinding.notEquals(referenceBinding, abstractMethodDeclaration.thrownExceptions[n10].resolvedType); ++n10) {
                    }
                    if (n10 >= n3) continue;
                    methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n10], abstractMethodDeclaration.binding.modifiers);
                }
                break block15;
            }
            int n11 = 0;
            TypeReference[] typeReferenceArray = new TypeReference[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                object = this.exceptionReferences[n2];
                ((Expression)object).resolve(methodScope);
                TypeBinding typeBinding2 = ((TypeReference)object).resolvedType;
                if (typeBinding2 == null || !typeBinding2.isValidBinding() || !typeBinding2.isClass()) continue;
                typeReferenceArray[n11++] = object;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                object = abstractMethodDeclaration.binding.thrownExceptions[n2];
                if (object != null) {
                    object = (ReferenceBinding)((TypeBinding)object).erasure();
                }
                boolean bl2 = false;
                for (n = 0; n < n11 && !bl2; ++n) {
                    if (typeReferenceArray[n] == null || !TypeBinding.equalsEquals((TypeBinding)object, typeBinding = typeReferenceArray[n].resolvedType)) continue;
                    bl2 = true;
                    typeReferenceArray[n] = null;
                }
                if (bl2 || !bl || object == null || !((Binding)object).isValidBinding()) continue;
                for (n = n2; n < n3 && TypeBinding.notEquals((TypeBinding)object, abstractMethodDeclaration.thrownExceptions[n].resolvedType); ++n) {
                }
                if (n >= n3) continue;
                methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n], abstractMethodDeclaration.binding.modifiers);
            }
            for (n2 = 0; n2 < n11; ++n2) {
                object = typeReferenceArray[n2];
                if (object == null) continue;
                boolean bl3 = false;
                for (n = 0; n < n3 && !bl3; ++n) {
                    typeBinding = abstractMethodDeclaration.thrownExceptions[n].resolvedType;
                    if (typeBinding == null) continue;
                    bl3 = ((TypeReference)object).resolvedType.isCompatibleWith(typeBinding);
                }
                if (bl3 || ((TypeReference)object).resolvedType.isUncheckedException(false)) continue;
                methodScope.problemReporter().javadocInvalidThrowsClassName((TypeReference)object, abstractMethodDeclaration.binding.modifiers);
            }
        }
    }

    private void verifyTypeReference(Expression expression, Expression expression2, Scope scope, boolean bl, ReferenceBinding referenceBinding, int n) {
        if (referenceBinding.isValidBinding()) {
            int n2 = -1;
            if (!this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, n)) {
                scope.problemReporter().javadocHiddenReference(expression2.sourceStart, expression.sourceEnd, scope, n);
                return;
            }
            if (expression != expression2 && !this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, referenceBinding.modifiers)) {
                scope.problemReporter().javadocHiddenReference(expression2.sourceStart, expression2.sourceEnd, scope, referenceBinding.modifiers);
                return;
            }
            if (referenceBinding.isMemberType()) {
                ReferenceBinding referenceBinding2 = referenceBinding;
                int n3 = referenceBinding2.fPackage.compoundName.length;
                int n4 = referenceBinding.depth();
                int n5 = n4 + n3;
                char[][] cArrayArray = new char[n5 + 1][];
                cArrayArray[n5] = referenceBinding2.sourceName;
                while (referenceBinding2.enclosingType() != null) {
                    referenceBinding2 = referenceBinding2.enclosingType();
                    cArrayArray[--n5] = referenceBinding2.sourceName;
                }
                int n6 = n3;
                while (--n6 >= 0) {
                    cArrayArray[--n5] = referenceBinding2.fPackage.compoundName[n6];
                }
                if (scope.kind != 5) {
                    int n7;
                    ClassScope classScope = scope.classScope();
                    if (classScope.parent.kind != 4 || !CharOperation.equals(referenceBinding2.sourceName, classScope.referenceContext.name)) {
                        classScope = classScope.outerMostClassScope();
                        if (expression2 instanceof JavadocSingleTypeReference && (!bl && n4 == 1 || TypeBinding.notEquals(referenceBinding2, classScope.referenceContext.binding))) {
                            boolean bl2 = false;
                            if (bl) {
                                CompilationUnitScope compilationUnitScope = classScope.compilationUnitScope();
                                ImportBinding[] importBindingArray = compilationUnitScope.imports;
                                n7 = importBindingArray == null ? 0 : importBindingArray.length;
                                block2: for (int i = 0; i < n7; ++i) {
                                    char[][] cArray = importBindingArray[i].compoundName;
                                    int n8 = cArray.length;
                                    if ((!importBindingArray[i].onDemand || n8 != cArrayArray.length - 1) && n8 != cArrayArray.length) continue;
                                    int n9 = n8;
                                    while (--n9 >= 0 && CharOperation.equals(importBindingArray[i].compoundName[n9], cArrayArray[n9])) {
                                        if (n9 != 0) continue;
                                        bl2 = true;
                                        ImportReference importReference = importBindingArray[i].reference;
                                        if (importReference == null) break block2;
                                        importReference.bits |= 2;
                                        break block2;
                                    }
                                }
                                if (!bl2) {
                                    if (n2 == -1) {
                                        n2 = scope.getDeclarationModifiers();
                                    }
                                    scope.problemReporter().javadocInvalidMemberTypeQualification(expression2.sourceStart, expression2.sourceEnd, n2);
                                }
                            } else {
                                if (n2 == -1) {
                                    n2 = scope.getDeclarationModifiers();
                                }
                                scope.problemReporter().javadocInvalidMemberTypeQualification(expression2.sourceStart, expression2.sourceEnd, n2);
                                return;
                            }
                        }
                    }
                    if (expression2 instanceof JavadocQualifiedTypeReference && !scope.isDefinedInSameUnit(referenceBinding)) {
                        char[][] cArray = ((JavadocQualifiedTypeReference)expression2).getTypeName();
                        int n10 = 0;
                        if (classScope.getCurrentPackage() == referenceBinding.getPackage() && cArray.length < cArrayArray.length) {
                            n10 = referenceBinding.fPackage.compoundName.length;
                        }
                        boolean bl3 = true;
                        if (cArray.length == cArrayArray.length - n10) {
                            for (n7 = 0; n7 < cArray.length; ++n7) {
                                if (CharOperation.equals(cArray[n7], cArrayArray[n7 + n10])) continue;
                                bl3 = false;
                                break;
                            }
                        } else {
                            bl3 = false;
                        }
                        if (!bl3) {
                            if (n2 == -1) {
                                n2 = scope.getDeclarationModifiers();
                            }
                            scope.problemReporter().javadocInvalidMemberTypeQualification(expression2.sourceStart, expression2.sourceEnd, n2);
                            return;
                        }
                    }
                }
            }
            if (scope.referenceCompilationUnit().isPackageInfo() && expression2 instanceof JavadocSingleTypeReference && referenceBinding.fPackage.compoundName.length > 0) {
                scope.problemReporter().javadocInvalidReference(expression2.sourceStart, expression2.sourceEnd);
                return;
            }
        }
    }

    private boolean verifyModuleReference(Expression expression, Expression expression2, Scope scope, boolean bl, ModuleBinding moduleBinding, int n) {
        boolean bl2 = false;
        if (moduleBinding != null && moduleBinding.isValidBinding()) {
            int n2 = -1;
            ModuleBinding moduleBinding2 = scope.module();
            if (moduleBinding2 == null) {
                scope.problemReporter().javadocInvalidModuleQualification(expression2.sourceStart, expression2.sourceEnd, n2);
                return bl2;
            }
            if (moduleBinding2.equals(moduleBinding)) {
                bl2 = true;
            } else {
                ModuleBinding[] moduleBindingArray;
                for (ModuleBinding moduleBinding3 : moduleBindingArray = moduleBinding2.getAllRequiredModules()) {
                    if (!moduleBinding.equals(moduleBinding3)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2 && !this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, moduleBinding.modifiers)) {
                scope.problemReporter().javadocHiddenReference(expression2.sourceStart, expression2.sourceEnd, scope, moduleBinding.modifiers);
                return bl2;
            }
        }
        return bl2;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.paramReferences != null) {
                n2 = this.paramReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.paramReferences[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.paramTypeParameters != null) {
                n2 = this.paramTypeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.paramTypeParameters[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(aSTVisitor, blockScope);
            }
            if (this.exceptionReferences != null) {
                n2 = this.exceptionReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.exceptionReferences[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.seeReferences != null) {
                n2 = this.seeReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.seeReferences[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.paramReferences != null) {
                n2 = this.paramReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.paramReferences[n].traverse(aSTVisitor, classScope);
                }
            }
            if (this.paramTypeParameters != null) {
                n2 = this.paramTypeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.paramTypeParameters[n].traverse(aSTVisitor, classScope);
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(aSTVisitor, classScope);
            }
            if (this.exceptionReferences != null) {
                n2 = this.exceptionReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.exceptionReferences[n].traverse(aSTVisitor, classScope);
                }
            }
            if (this.seeReferences != null) {
                n2 = this.seeReferences.length;
                for (n = 0; n < n2; ++n) {
                    this.seeReferences[n].traverse(aSTVisitor, classScope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

