/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.util.Util;

public class CompilationUnit
implements ICompilationUnit {
    public char[] contents;
    public char[] fileName;
    public char[] mainTypeName;
    String encoding;
    public String destinationPath;
    public char[] module;
    private boolean ignoreOptionalProblems;
    private ModuleBinding moduleBinding;
    private Function<String, String> annotationPathProvider;

    public CompilationUnit(char[] cArray, String string, String string2) {
        this(cArray, string, string2, null);
    }

    public CompilationUnit(char[] cArray, String string, String string2, String string3) {
        this(cArray, string, string2, string3, false, null);
    }

    public CompilationUnit(char[] cArray, String string, String string2, String string3, boolean bl, String string4) {
        this(cArray, string, string2, string3, bl, string4, null);
    }

    public CompilationUnit(char[] cArray, String string, String string2, String string3, boolean bl, String string4, Function<String, String> function) {
        this.annotationPathProvider = function;
        this.contents = cArray;
        if (string4 != null) {
            this.module = string4.toCharArray();
        }
        char[] cArray2 = string.toCharArray();
        switch (File.separatorChar) {
            case '/': {
                if (CharOperation.indexOf('\\', cArray2) == -1) break;
                CharOperation.replace(cArray2, '\\', '/');
                break;
            }
            case '\\': {
                if (CharOperation.indexOf('/', cArray2) == -1) break;
                CharOperation.replace(cArray2, '/', '\\');
            }
        }
        this.fileName = cArray2;
        int n = CharOperation.lastIndexOf(File.separatorChar, cArray2) + 1;
        int n2 = CharOperation.lastIndexOf('.', cArray2);
        if (n2 == -1) {
            n2 = cArray2.length;
        }
        this.mainTypeName = CharOperation.subarray(cArray2, n, n2);
        this.encoding = string2;
        this.destinationPath = string3;
        this.ignoreOptionalProblems = bl;
    }

    @Override
    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            this.contents = CharOperation.NO_CHAR;
            throw new AbortCompilationUnit(null, iOException, this.encoding);
        }
    }

    @Override
    public char[] getFileName() {
        return this.fileName;
    }

    @Override
    public char[] getMainTypeName() {
        return this.mainTypeName;
    }

    @Override
    public char[][] getPackageName() {
        return null;
    }

    @Override
    public boolean ignoreOptionalProblems() {
        return this.ignoreOptionalProblems;
    }

    public String toString() {
        return "CompilationUnit[" + new String(this.fileName) + "]";
    }

    @Override
    public char[] getModuleName() {
        return this.module;
    }

    @Override
    public ModuleBinding module(LookupEnvironment lookupEnvironment) {
        if (this.moduleBinding != null) {
            return this.moduleBinding;
        }
        this.moduleBinding = lookupEnvironment.getModule(this.module);
        if (this.moduleBinding == null) {
            throw new IllegalStateException("Module should be known");
        }
        return this.moduleBinding;
    }

    @Override
    public String getDestinationPath() {
        return this.destinationPath;
    }

    @Override
    public String getExternalAnnotationPath(String string) {
        if (this.annotationPathProvider != null) {
            return this.annotationPathProvider.apply(string);
        }
        return null;
    }
}

