"""Diagnostics support for Pure Energie."""
from __future__ import annotations

from dataclasses import asdict
from typing import Any

from homeassistant.components.diagnostics import async_redact_data
from homeassistant.config_entries import ConfigEntry
from homeassistant.const import CONF_HOST
from homeassistant.core import HomeAssistant

from . import PureEnergieDataUpdateCoordinator
from .const import DOMAIN

TO_REDACT = {
    CONF_HOST,
    "n2g_id",
}


async def async_get_config_entry_diagnostics(
    hass: HomeAssistant, entry: ConfigEntry
) -> dict[str, Any]:
    """Return diagnostics for a config entry."""
    coordinator: PureEnergieDataUpdateCoordinator = hass.data[DOMAIN][entry.entry_id]

    return {
        "entry": {
            "title": entry.title,
            "data": async_redact_data(entry.data, TO_REDACT),
        },
        "data": {
            "device": async_redact_data(asdict(coordinator.data.device), TO_REDACT),
            "smartbridge": asdict(coordinator.data.smartbridge),
        },
    }
