/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.search.GetAllPitNodeResponse;
import org.opensearch.action.search.ListPitInfo;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class GetAllPitNodesResponse
extends BaseNodesResponse<GetAllPitNodeResponse>
implements ToXContentObject {
    private final Set<ListPitInfo> pitInfos = new HashSet<ListPitInfo>();
    private static final ConstructingObjectParser<GetAllPitNodesResponse, Void> PARSER = new ConstructingObjectParser("get_all_pits_response", true, parsedObjects -> {
        List listPitInfos = (List)parsedObjects[0];
        ArrayList<FailedNodeException> failures = null;
        if (((Object[])parsedObjects).length > 1) {
            failures = (ArrayList<FailedNodeException>)parsedObjects[1];
        }
        if (failures == null) {
            failures = new ArrayList<FailedNodeException>();
        }
        return new GetAllPitNodesResponse(listPitInfos, new ClusterName(""), new ArrayList<GetAllPitNodeResponse>(), failures);
    });

    public GetAllPitNodesResponse(StreamInput in) throws IOException {
        super(in);
    }

    public GetAllPitNodesResponse(ClusterName clusterName, List<GetAllPitNodeResponse> getAllPitNodeResponseList, List<FailedNodeException> failures) {
        super(clusterName, getAllPitNodeResponseList, failures);
        HashSet uniquePitIds = new HashSet();
        this.pitInfos.addAll(getAllPitNodeResponseList.stream().flatMap(p -> p.getPitInfos().stream().filter(t -> uniquePitIds.add(t.getPitId()))).collect(Collectors.toList()));
    }

    public GetAllPitNodesResponse(List<ListPitInfo> listPitInfos, GetAllPitNodesResponse response) {
        super(response.getClusterName(), response.getNodes(), response.failures());
        this.pitInfos.addAll(listPitInfos);
    }

    public GetAllPitNodesResponse(List<ListPitInfo> listPitInfos, ClusterName clusterName, List<GetAllPitNodeResponse> getAllPitNodeResponseList, List<FailedNodeException> failures) {
        super(clusterName, getAllPitNodeResponseList, failures);
        this.pitInfos.addAll(listPitInfos);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("pits");
        for (ListPitInfo pit : this.pitInfos) {
            pit.toXContent(builder, params);
        }
        builder.endArray();
        if (!this.failures().isEmpty()) {
            builder.startArray("failures");
            for (FailedNodeException e : this.failures()) {
                e.toXContent(builder, params);
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public List<GetAllPitNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(GetAllPitNodeResponse::new);
    }

    @Override
    public void writeNodesTo(StreamOutput out, List<GetAllPitNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<ListPitInfo> getPitInfos() {
        return Collections.unmodifiableList(new ArrayList<ListPitInfo>(this.pitInfos));
    }

    public static GetAllPitNodesResponse fromXContent(XContentParser parser) throws IOException {
        return (GetAllPitNodesResponse)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ListPitInfo.PARSER, new ParseField("pits", new String[0]));
    }
}

