/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.AbstractPagedHashMap;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.LongArray;
import org.opensearch.common.util.ObjectArray;

public class LongObjectPagedHashMap<T>
extends AbstractPagedHashMap
implements Iterable<Cursor<T>> {
    private LongArray keys;
    private ObjectArray<T> values;

    public LongObjectPagedHashMap(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    public LongObjectPagedHashMap(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        this.keys = bigArrays.newLongArray(this.capacity(), false);
        this.values = bigArrays.newObjectArray(this.capacity());
    }

    public T get(long key) {
        long i = LongObjectPagedHashMap.slot(LongObjectPagedHashMap.hash(key), this.mask);
        T value;
        while ((value = this.values.get(i)) != null) {
            if (this.keys.get(i) == key) {
                return value;
            }
            i = LongObjectPagedHashMap.nextSlot(i, this.mask);
        }
        return null;
    }

    public T put(long key, T value) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key, value);
    }

    public T remove(long key) {
        long i = LongObjectPagedHashMap.slot(LongObjectPagedHashMap.hash(key), this.mask);
        T previous;
        while ((previous = this.values.set(i, null)) != null) {
            if (this.keys.get(i) == key) {
                --this.size;
                long j = LongObjectPagedHashMap.nextSlot(i, this.mask);
                while (this.used(j)) {
                    this.removeAndAdd(j);
                    j = LongObjectPagedHashMap.nextSlot(j, this.mask);
                }
                return previous;
            }
            this.values.set(i, previous);
            i = LongObjectPagedHashMap.nextSlot(i, this.mask);
        }
        return null;
    }

    private T set(long key, T value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are not supported");
        }
        long i = LongObjectPagedHashMap.slot(LongObjectPagedHashMap.hash(key), this.mask);
        while (true) {
            T previous;
            if ((previous = this.values.set(i, value)) == null) {
                this.keys.set(i, key);
                ++this.size;
                return null;
            }
            if (key == this.keys.get(i)) {
                return previous;
            }
            this.values.set(i, previous);
            i = LongObjectPagedHashMap.nextSlot(i, this.mask);
        }
    }

    @Override
    public Iterator<Cursor<T>> iterator() {
        return new Iterator<Cursor<T>>(){
            boolean cached;
            final Cursor<T> cursor = new Cursor();
            {
                this.cursor.index = -1L;
                this.cached = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.cached) {
                    block2: {
                        do {
                            ++this.cursor.index;
                            if (this.cursor.index >= LongObjectPagedHashMap.this.capacity()) break block2;
                        } while (!LongObjectPagedHashMap.this.used(this.cursor.index));
                        this.cursor.key = LongObjectPagedHashMap.this.keys.get(this.cursor.index);
                        this.cursor.value = LongObjectPagedHashMap.this.values.get(this.cursor.index);
                    }
                    this.cached = true;
                }
                return this.cursor.index < LongObjectPagedHashMap.this.capacity();
            }

            @Override
            public Cursor<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.cached = false;
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        Releasables.close(this.keys, this.values);
    }

    @Override
    protected void resize(long capacity) {
        this.keys = this.bigArrays.resize(this.keys, capacity);
        this.values = this.bigArrays.resize(this.values, capacity);
    }

    @Override
    protected boolean used(long bucket) {
        return this.values.get(bucket) != null;
    }

    @Override
    protected void removeAndAdd(long index) {
        long key = this.keys.get(index);
        T value = this.values.set(index, null);
        --this.size;
        Object removed = this.set(key, value);
        assert (removed == null);
    }

    public static final class Cursor<T> {
        public long index;
        public long key;
        public T value;
    }
}

