/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.file;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

abstract class OnDemandBlockIndexInput
extends IndexInput
implements RandomAccessInput {
    protected final long offset;
    protected final long length;
    protected final boolean isClone;
    protected final int blockSizeShift;
    protected final int blockSize;
    protected final int blockMask;
    protected IndexInput currentBlock;
    protected int currentBlockId;

    OnDemandBlockIndexInput(Builder builder) {
        super(builder.resourceDescription);
        this.isClone = builder.isClone;
        this.offset = builder.offset;
        this.length = builder.length;
        this.blockSizeShift = builder.blockSizeShift;
        this.blockSize = builder.blockSize;
        this.blockMask = builder.blockMask;
    }

    protected abstract OnDemandBlockIndexInput buildSlice(String var1, long var2, long var4);

    protected abstract IndexInput fetchBlock(int var1) throws IOException;

    public OnDemandBlockIndexInput clone() {
        OnDemandBlockIndexInput clone = this.buildSlice("clone", this.offset, this.length());
        if (this.currentBlock != null) {
            clone.currentBlock = this.currentBlock.clone();
            clone.currentBlockId = this.currentBlockId;
        }
        return clone;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + this);
        }
        return this.buildSlice(sliceDescription, offset, length);
    }

    public void close() throws IOException {
        if (this.currentBlock != null) {
            this.currentBlock.close();
            this.currentBlock = null;
            this.currentBlockId = 0;
        }
    }

    public long getFilePointer() {
        if (this.currentBlock == null) {
            return 0L;
        }
        return this.currentBlockStart() + (long)this.currentBlockPosition() - this.offset;
    }

    public long length() {
        return this.length;
    }

    public byte readByte() throws IOException {
        if (this.currentBlock == null) {
            this.seek(0L);
        } else if (this.currentBlockPosition() >= this.blockSize) {
            int blockId = this.currentBlockId + 1;
            this.demandBlock(blockId);
        }
        return this.currentBlock.readByte();
    }

    public short readShort() throws IOException {
        if (this.currentBlock != null && 2 <= this.blockSize - this.currentBlockPosition()) {
            return this.currentBlock.readShort();
        }
        return super.readShort();
    }

    public int readInt() throws IOException {
        if (this.currentBlock != null && 4 <= this.blockSize - this.currentBlockPosition()) {
            return this.currentBlock.readInt();
        }
        return super.readInt();
    }

    public long readLong() throws IOException {
        if (this.currentBlock != null && 8 <= this.blockSize - this.currentBlockPosition()) {
            return this.currentBlock.readLong();
        }
        return super.readLong();
    }

    public final int readVInt() throws IOException {
        if (this.currentBlock != null && 5 <= this.blockSize - this.currentBlockPosition()) {
            return this.currentBlock.readVInt();
        }
        return super.readVInt();
    }

    public final long readVLong() throws IOException {
        if (this.currentBlock != null && 9 <= this.blockSize - this.currentBlockPosition()) {
            return this.currentBlock.readVLong();
        }
        return super.readVLong();
    }

    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + this);
        }
        this.seekInternal(pos + this.offset);
    }

    public final byte readByte(long pos) throws IOException {
        if (this.currentBlock != null && this.isInCurrentBlockRange(pos += this.offset)) {
            return ((RandomAccessInput)this.currentBlock).readByte((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return this.currentBlock.readByte();
    }

    public short readShort(long pos) throws IOException {
        if (this.currentBlock != null && this.isInCurrentBlockRange(pos += this.offset, 2)) {
            return ((RandomAccessInput)this.currentBlock).readShort((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readShort();
    }

    public int readInt(long pos) throws IOException {
        if (this.currentBlock != null && this.isInCurrentBlockRange(pos += this.offset, 4)) {
            return ((RandomAccessInput)this.currentBlock).readInt((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readInt();
    }

    public long readLong(long pos) throws IOException {
        if (this.currentBlock != null && this.isInCurrentBlockRange(pos += this.offset, 8)) {
            return ((RandomAccessInput)this.currentBlock).readLong((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readLong();
    }

    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        int available;
        if (this.currentBlock == null) {
            this.seek(0L);
        }
        if (len <= (available = this.blockSize - this.currentBlockPosition())) {
            this.currentBlock.readBytes(b, offset, len);
        } else {
            if (available > 0) {
                this.currentBlock.readBytes(b, offset, available);
                offset += available;
                len -= available;
            }
            while (len > 0) {
                int blockId = this.currentBlockId + 1;
                int toRead = Math.min(len, this.blockSize);
                this.demandBlock(blockId);
                this.currentBlock.readBytes(b, offset, toRead);
                offset += toRead;
                len -= toRead;
            }
        }
    }

    private void seekInternal(long pos) throws IOException {
        if (this.currentBlock == null || !this.isInCurrentBlockRange(pos)) {
            this.demandBlock(this.getBlock(pos));
        }
        this.currentBlock.seek((long)this.getBlockOffset(pos));
    }

    private boolean isInCurrentBlockRange(long pos) {
        long offset = pos - this.currentBlockStart();
        return offset >= 0L && offset < (long)this.blockSize;
    }

    private boolean isInCurrentBlockRange(long pos, int len) {
        long offset = pos - this.currentBlockStart();
        return offset >= 0L && offset + (long)len <= (long)this.blockSize;
    }

    private void demandBlock(int blockId) throws IOException {
        if (this.currentBlock != null && this.currentBlockId == blockId) {
            return;
        }
        if (this.currentBlock != null) {
            this.currentBlock.close();
        }
        this.currentBlock = this.fetchBlock(blockId).clone();
        this.currentBlockId = blockId;
    }

    protected int getBlock(long pos) {
        return (int)(pos >>> this.blockSizeShift);
    }

    protected int getBlockOffset(long pos) {
        return (int)(pos & (long)this.blockMask);
    }

    protected long getBlockStart(int blockId) {
        return (long)blockId << this.blockSizeShift;
    }

    protected long currentBlockStart() {
        return this.getBlockStart(this.currentBlockId);
    }

    protected int currentBlockPosition() {
        return (int)this.currentBlock.getFilePointer();
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        public static final int DEFAULT_BLOCK_SIZE_SHIFT = 13;
        private String resourceDescription;
        private boolean isClone;
        private long offset;
        private long length;
        private int blockSizeShift = 13;
        private int blockSize = 1 << this.blockSizeShift;
        private int blockMask = this.blockSize - 1;

        private Builder() {
        }

        public Builder resourceDescription(String resourceDescription) {
            this.resourceDescription = resourceDescription;
            return this;
        }

        public Builder isClone(boolean clone) {
            this.isClone = clone;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder blockSizeShift(int blockSizeShift) {
            assert (blockSizeShift < 31) : "blockSizeShift must be < 31";
            this.blockSizeShift = blockSizeShift;
            this.blockSize = 1 << blockSizeShift;
            this.blockMask = this.blockSize - 1;
            return this;
        }
    }
}

