/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BufferedHttpResponse
extends HttpResponse {
    private static final ClientLogger LOGGER = new ClientLogger(BufferedHttpResponse.class);
    private final HttpResponse innerHttpResponse;
    private final Mono<List<ByteBuffer>> cachedBody;
    private final AtomicLong cachedBodySize = new AtomicLong();

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        super(innerHttpResponse.getRequest());
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = innerHttpResponse.getBody().map(buffer -> {
            this.cachedBodySize.addAndGet(buffer.remaining());
            return ByteBuffer.wrap(FluxUtil.byteBufferToArray(buffer));
        }).collectList().cache();
    }

    @Override
    public int getStatusCode() {
        return this.innerHttpResponse.getStatusCode();
    }

    @Override
    public String getHeaderValue(String name) {
        return this.innerHttpResponse.getHeaderValue(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.innerHttpResponse.getHeaders();
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        return this.cachedBody.flatMapMany(Flux::fromIterable).map(ByteBuffer::duplicate);
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return this.cachedBodySize.get() > Integer.MAX_VALUE ? FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Response with body size " + this.cachedBodySize.get() + " doesn't fit into a byte array.")) : FluxUtil.collectBytesInByteBufferStream(this.getBody(), (int)this.cachedBodySize.get());
    }

    @Override
    public Mono<String> getBodyAsString() {
        return this.cachedBodySize.get() > Integer.MAX_VALUE ? FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Response with body size " + this.cachedBodySize.get() + " doesn't fit into a String.")) : this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString(bytes, this.innerHttpResponse.getHeaderValue("Content-Type")));
    }

    @Override
    public Mono<String> getBodyAsString(Charset charset) {
        return this.cachedBodySize.get() > Integer.MAX_VALUE ? FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Response with body size " + this.cachedBodySize.get() + " doesn't fit into a String.")) : this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

