"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEventHandler = exports.isAttributeShorthand = exports.isAttributeName = exports.isInTag = void 0;
function matchesOnly(type, only) {
    return (!only ||
        // We hide the detail that body/window are also like elements in the context of this usage
        (only === 'Element' && ['Element', 'Body', 'Window'].includes(type)) ||
        (only === 'InlineComponent' && type === 'InlineComponent'));
}
/**
 * Returns true if given node is a component or html element, or if the offset is at the end of the node
 * and its parent is a component or html element.
 */
function isInTag(node, offset) {
    var _a, _b;
    return ((node === null || node === void 0 ? void 0 : node.type) === 'InlineComponent' ||
        (node === null || node === void 0 ? void 0 : node.type) === 'Element' ||
        ((node === null || node === void 0 ? void 0 : node.end) === offset &&
            (((_a = node === null || node === void 0 ? void 0 : node.parent) === null || _a === void 0 ? void 0 : _a.type) === 'InlineComponent' || ((_b = node === null || node === void 0 ? void 0 : node.parent) === null || _b === void 0 ? void 0 : _b.type) === 'Element')));
}
exports.isInTag = isInTag;
/**
 * Returns when given node represents an HTML Attribute.
 * Example: The `class` in `<div class=".."`.
 * Note: This method returns `false` for shorthands like `<div {foo}`.
 */
function isAttributeName(node, only) {
    var _a;
    return !!node && node.type === 'Attribute' && matchesOnly((_a = node.parent) === null || _a === void 0 ? void 0 : _a.type, only);
}
exports.isAttributeName = isAttributeName;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `{foo}` in `<div {foo}`
 */
function isAttributeShorthand(node, only) {
    if (!node) {
        return false;
    }
    do {
        // We could get the expression, or the shorthand, or the attribute
        // Be pragmatic and just go upwards until we can't anymore
        if (isAttributeName(node, only)) {
            return true;
        }
        node = node.parent;
    } while (node);
    return false;
}
exports.isAttributeShorthand = isAttributeShorthand;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `on:click={foo}` in `<div on:click={foo}`
 */
function isEventHandler(node, only) {
    var _a;
    return !!node && node.type === 'EventHandler' && matchesOnly((_a = node.parent) === null || _a === void 0 ? void 0 : _a.type, only);
}
exports.isEventHandler = isEventHandler;
//# sourceMappingURL=svelte-ast-utils.js.map