/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypePattern;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    static final int CASE_CONSTANT = 1;
    static final int CASE_PATTERN = 2;
    public BranchLabel targetLabel;
    public Expression[] constantExpressions;
    public BranchLabel[] targetLabels;
    public boolean isExpr;
    int patternIndex;

    public CaseStatement(Expression expression, int n, int n2) {
        Expression[] expressionArray;
        if (expression != null) {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = expression;
        } else {
            expressionArray = null;
        }
        this(n, n2, expressionArray);
    }

    public CaseStatement(int n, int n2, Expression[] expressionArray) {
        this.isExpr = false;
        this.patternIndex = -1;
        this.constantExpressions = expressionArray;
        this.sourceEnd = n;
        this.sourceStart = n2;
        this.initPatterns();
    }

    private void initPatterns() {
        int n = this.constantExpressions == null ? 0 : this.constantExpressions.length;
        for (int i = 0; i < n; ++i) {
            Expression expression = this.constantExpressions[i];
            if (!(expression instanceof Pattern)) continue;
            this.patternIndex = i;
            break;
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpressions != null) {
            int n = 0;
            for (int i = 0; i < this.constantExpressions.length; ++i) {
                LocalVariableBinding localVariableBinding;
                Expression expression;
                if (i > 0 && expression instanceof Pattern && (i != (n += (expression = this.constantExpressions[i]) instanceof NullLiteral ? 1 : 0) || !(expression instanceof TypePattern))) {
                    blockScope.problemReporter().IllegalFallThroughToPattern(expression);
                }
                this.analyseConstantExpression(blockScope, flowContext, flowInfo, expression);
                if (n <= 0 || !(expression instanceof TypePattern) || (localVariableBinding = ((TypePattern)expression).local.binding) == null) continue;
                flowInfo.markNullStatus(localVariableBinding, 16);
            }
        }
        return flowInfo;
    }

    private void analyseConstantExpression(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Expression expression) {
        if (expression.constant == Constant.NotAConstant && !expression.resolvedType.isEnum()) {
            Expression expression2;
            boolean bl;
            boolean bl2 = bl = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(blockScope.compilerOptions()) && (expression instanceof NullLiteral || expression instanceof FakeDefaultLiteral);
            if (!bl) {
                blockScope.problemReporter().caseExpressionMustBeConstant(expression);
            }
            if (expression instanceof NullLiteral && flowContext.associatedNode instanceof SwitchStatement && (expression2 = ((SwitchStatement)flowContext.associatedNode).expression) != null && expression2.nullStatus(flowInfo, flowContext) == 4) {
                blockScope.problemReporter().unnecessaryNullCaseInSwitchOverNonNull(this);
            }
        }
        expression.analyseCode(blockScope, flowContext, flowInfo);
    }

    @Override
    public boolean containsPatternVariable() {
        return this.patternIndex != -1;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        CaseStatement.printIndent(n, stringBuffer);
        if (this.constantExpressions == null) {
            stringBuffer.append("default ");
            stringBuffer.append(this.isExpr ? "->" : ":");
        } else {
            stringBuffer.append("case ");
            int n2 = this.constantExpressions.length;
            for (int i = 0; i < n2; ++i) {
                this.constantExpressions[i].printExpression(0, stringBuffer);
                if (i >= n2 - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(this.isExpr ? " ->" : " :");
        }
        return stringBuffer;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.targetLabels != null) {
            int n2 = this.targetLabels.length;
            for (int i = 0; i < n2; ++i) {
                this.targetLabels[i].place();
            }
        }
        if (this.targetLabel != null) {
            this.targetLabel.place();
        }
        this.casePatternExpressionGenerateCode(blockScope, codeStream);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    private void casePatternExpressionGenerateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.patternIndex != -1) {
            LocalVariableBinding localVariableBinding = blockScope.findVariable(SwitchStatement.SecretPatternVariableName, null);
            codeStream.load(localVariableBinding);
            Pattern pattern = (Pattern)this.constantExpressions[this.patternIndex];
            pattern.generateCode(blockScope, codeStream);
        }
    }

    @Override
    public void resolve(BlockScope blockScope) {
    }

    public ResolvedCase[] resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        if (this.containsPatternVariable()) {
            return this.resolveWithPatternVariablesInScope(this.patternVarsWhenTrue, blockScope, typeBinding, switchStatement);
        }
        return this.resolveCasePrivate(blockScope, typeBinding, switchStatement);
    }

    public ResolvedCase[] resolveWithPatternVariablesInScope(LocalVariableBinding[] localVariableBindingArray, BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        if (localVariableBindingArray != null) {
            for (LocalVariableBinding localVariableBinding : localVariableBindingArray) {
                localVariableBinding.modifiers &= 0xEFFFFFFF;
            }
            Object[] objectArray = this.resolveCasePrivate(blockScope, typeBinding, switchStatement);
            for (LocalVariableBinding localVariableBinding : localVariableBindingArray) {
                localVariableBinding.modifiers |= 0x10000000;
            }
            return objectArray;
        }
        return this.resolveCasePrivate(blockScope, typeBinding, switchStatement);
    }

    private Expression getFirstValidExpression(BlockScope blockScope, SwitchStatement switchStatement) {
        assert (this.constantExpressions != null);
        Expression expression = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(blockScope.compilerOptions());
        if (bl) {
            for (Expression expression2 : this.constantExpressions) {
                if (expression2 instanceof FakeDefaultLiteral) {
                    blockScope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, expression2.sourceStart, expression2.sourceEnd);
                    this.flagDuplicateDefault(blockScope, switchStatement, this.constantExpressions.length > 1 ? expression2 : this);
                    if (n > 0) {
                        blockScope.problemReporter().switchPatternBothPatternAndDefaultCaseLabelsNotAllowed(expression2);
                    }
                    ++n3;
                    continue;
                }
                if (expression2 instanceof Pattern) {
                    blockScope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, expression2.sourceStart, expression2.sourceEnd);
                    if (n++ > 0) {
                        blockScope.problemReporter().switchPatternOnlyOnePatternCaseLabelAllowed(expression2);
                        return expression2;
                    }
                    if (n3 > 0) {
                        blockScope.problemReporter().switchPatternBothPatternAndDefaultCaseLabelsNotAllowed(expression2);
                        return expression2;
                    }
                    if (expression2 instanceof TypePattern) {
                        ++n2;
                    } else if (n4 > 0) {
                        blockScope.problemReporter().switchPatternBothNullAndNonTypePatternNotAllowed(expression2);
                        return expression2;
                    }
                } else if (expression2 instanceof NullLiteral) {
                    blockScope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, expression2.sourceStart, expression2.sourceEnd);
                    if (switchStatement.nullCase == null) {
                        switchStatement.nullCase = this;
                        if ((switchStatement.switchBits & 4) != 0) {
                            blockScope.problemReporter().patternDominatedByAnother(this.constantExpressions[0]);
                            return expression2;
                        }
                    }
                    if (n4++ > 0) {
                        // empty if block
                    }
                    if (n - n2 > 0) {
                        blockScope.problemReporter().switchPatternBothNullAndNonTypePatternNotAllowed(expression2);
                        return expression2;
                    }
                }
                if (expression != null) continue;
                expression = expression2;
            }
        } else {
            for (Expression expression3 : this.constantExpressions) {
                if (expression3 instanceof Pattern || expression3 instanceof NullLiteral || expression3 instanceof FakeDefaultLiteral) {
                    blockScope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, expression3.sourceStart, expression3.sourceEnd);
                    continue;
                }
                if (expression != null) continue;
                expression = expression3;
            }
        }
        return expression;
    }

    private ResolvedCase[] resolveCasePrivate(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        TypeBinding typeBinding2;
        blockScope.enclosingCase = this;
        if (this.constantExpressions == null) {
            this.flagDuplicateDefault(blockScope, switchStatement, this);
            return ResolvedCase.UnresolvedCase;
        }
        Expression expression = this.getFirstValidExpression(blockScope, switchStatement);
        if (expression == null) {
            return ResolvedCase.UnresolvedCase;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        if (typeBinding != null && typeBinding.isEnum() && expression instanceof SingleNameReference) {
            ((SingleNameReference)expression).setActualReceiverType((ReferenceBinding)typeBinding);
        }
        if ((typeBinding2 = expression.resolveType(blockScope)) == null || typeBinding == null) {
            return ResolvedCase.UnresolvedCase;
        }
        ArrayList<ResolvedCase> arrayList = new ArrayList<ResolvedCase>();
        for (Expression expression2 : this.constantExpressions) {
            Constant constant;
            if (expression2 != expression) {
                if (typeBinding.isEnum() && expression2 instanceof SingleNameReference) {
                    ((SingleNameReference)expression2).setActualReceiverType((ReferenceBinding)typeBinding);
                } else if (expression2 instanceof FakeDefaultLiteral) continue;
                typeBinding2 = expression2.resolveType(blockScope);
            }
            if (typeBinding2 == null) {
                return ResolvedCase.UnresolvedCase;
            }
            if (!typeBinding2.isValidBinding() || (constant = this.resolveConstantExpression(blockScope, typeBinding2, typeBinding, switchStatement, expression2)) == Constant.NotAConstant) continue;
            arrayList.add(new ResolvedCase(constant, expression2, typeBinding2));
        }
        this.resolveWithPatternVariablesInScope(this.getPatternVariablesWhenTrue(), blockScope);
        if (arrayList.size() > 0) {
            return arrayList.toArray(new ResolvedCase[arrayList.size()]);
        }
        return ResolvedCase.UnresolvedCase;
    }

    private void flagDuplicateDefault(BlockScope blockScope, SwitchStatement switchStatement, ASTNode aSTNode) {
        if (switchStatement.defaultCase != null) {
            blockScope.problemReporter().duplicateDefaultCase(aSTNode);
        }
        switchStatement.defaultCase = this;
        if ((switchStatement.switchBits & 4) != 0) {
            blockScope.problemReporter().illegalTotalPatternWithDefault(this);
        }
    }

    public void collectPatternVariablesToScope(LocalVariableBinding[] localVariableBindingArray, BlockScope blockScope) {
        if (!this.containsPatternVariable()) {
            return;
        }
        for (Expression expression : this.constantExpressions) {
            expression.collectPatternVariablesToScope(localVariableBindingArray, blockScope);
            LocalVariableBinding[] localVariableBindingArray2 = expression.getPatternVariablesWhenTrue();
            this.addPatternVariablesWhenTrue(localVariableBindingArray2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveConstantExpression(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2, SwitchStatement switchStatement, Expression expression) {
        boolean bl;
        boolean bl2 = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(blockScope.compilerOptions());
        if (bl2) {
            if (expression instanceof Pattern) {
                return this.resolveConstantExpression(blockScope, typeBinding, typeBinding2, switchStatement, (Pattern)expression);
            }
            if (expression instanceof NullLiteral) {
                if (!(typeBinding2 instanceof ReferenceBinding)) {
                    blockScope.problemReporter().typeMismatchError((TypeBinding)TypeBinding.NULL, typeBinding2, expression, null);
                }
                switchStatement.switchBits |= 2;
                return IntConstant.fromValue(-1);
            }
            if (!(expression instanceof FakeDefaultLiteral) && switchStatement.isNonTraditional && typeBinding2.isBaseType() && !expression.isConstantValueOfTypeAssignableToType(typeBinding, typeBinding2)) {
                blockScope.problemReporter().typeMismatchError(typeBinding, typeBinding2, expression, null);
                return Constant.NotAConstant;
            }
        }
        boolean bl3 = bl = !bl2 || switchStatement.isAllowedType(typeBinding2);
        if (expression.isConstantValueOfTypeAssignableToType(typeBinding, typeBinding2) || typeBinding.isCompatibleWith(typeBinding2) && !(expression instanceof StringLiteral)) {
            if (!typeBinding.isEnum()) return expression.constant;
            if ((expression.bits & 0x1FE00000) >> 21 != 0) {
                blockScope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(expression);
            }
            if (expression instanceof NameReference && (expression.bits & 7) == 1) {
                NameReference nameReference = (NameReference)expression;
                FieldBinding fieldBinding = nameReference.fieldBinding();
                if ((fieldBinding.modifiers & 0x4000) == 0) {
                    blockScope.problemReporter().enumSwitchCannotTargetField(nameReference, fieldBinding);
                    return IntConstant.fromValue(fieldBinding.original().id + 1);
                } else {
                    if (!(nameReference instanceof QualifiedNameReference)) return IntConstant.fromValue(fieldBinding.original().id + 1);
                    blockScope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(nameReference, fieldBinding);
                }
                return IntConstant.fromValue(fieldBinding.original().id + 1);
            }
        } else if (bl && this.isBoxingCompatible(typeBinding, typeBinding2, expression, blockScope)) {
            return expression.constant;
        }
        blockScope.problemReporter().typeMismatchError(expression.resolvedType, typeBinding2, expression, (ASTNode)switchStatement.expression);
        return Constant.NotAConstant;
    }

    private Constant resolveConstantExpression(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2, SwitchStatement switchStatement, Pattern pattern) {
        Constant constant = Constant.NotAConstant;
        TypeBinding typeBinding3 = pattern.resolveType(blockScope);
        if (typeBinding3 != null) {
            constant = IntConstant.fromValue(switchStatement.caseLabelElements.size());
            switchStatement.caseLabelElements.add(pattern);
            if (pattern.resolvedType != null) {
                TypeBinding typeBinding4 = pattern.resolveAtType(blockScope, switchStatement.expression.resolvedType);
                if (typeBinding4 != null) {
                    switchStatement.caseLabelElementTypes.add(typeBinding4);
                }
                TypeBinding typeBinding5 = switchStatement.expression.resolvedType;
                LocalDeclaration localDeclaration = pattern.getPatternVariableIntroduced();
                if (localDeclaration != null && !localDeclaration.type.isTypeNameVar(blockScope)) {
                    if (!typeBinding4.isReifiable()) {
                        boolean bl;
                        if (!(typeBinding5 == TypeBinding.NULL || (bl = pattern.checkCastTypesCompatibility(blockScope, typeBinding4, typeBinding5, pattern, false)) && (pattern.bits & 0x80) == 0)) {
                            blockScope.problemReporter().unsafeCastInInstanceof(pattern, typeBinding4, typeBinding5);
                        }
                    } else if (typeBinding4.isValidBinding()) {
                        if (typeBinding4.isPrimitiveType()) {
                            blockScope.problemReporter().unexpectedTypeinSwitchPattern(typeBinding4, pattern);
                            return Constant.NotAConstant;
                        }
                        if (typeBinding4.isBaseType() || !pattern.checkCastTypesCompatibility(blockScope, typeBinding4, typeBinding5, null, false)) {
                            blockScope.problemReporter().typeMismatchError(typeBinding5, typeBinding4, pattern, null);
                            return Constant.NotAConstant;
                        }
                    }
                }
                if (pattern.isTotalForType(typeBinding5)) {
                    if ((switchStatement.switchBits & 4) != 0) {
                        blockScope.problemReporter().duplicateTotalPattern(pattern);
                        return IntConstant.fromValue(-1);
                    }
                    switchStatement.switchBits |= 0xC;
                    if (switchStatement.defaultCase != null) {
                        blockScope.problemReporter().illegalTotalPatternWithDefault(this);
                    }
                    switchStatement.totalPattern = pattern;
                    pattern.isTotalTypeNode = true;
                    if (switchStatement.nullCase == null) {
                        constant = IntConstant.fromValue(-1);
                    }
                }
            }
        }
        return constant;
    }

    void patternCaseRemovePatternLocals(final CodeStream codeStream) {
        for (Expression expression : this.constantExpressions) {
            if (!(expression instanceof Pattern)) continue;
            expression.traverse(new ASTVisitor(){

                @Override
                public boolean visit(TypePattern typePattern, BlockScope blockScope) {
                    LocalDeclaration localDeclaration = typePattern.getPatternVariableIntroduced();
                    if (localDeclaration != null && localDeclaration.binding != null) {
                        codeStream.removeVariable(localDeclaration.binding);
                    }
                    return false;
                }
            }, (BlockScope)null);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.constantExpressions != null) {
            for (Expression expression : this.constantExpressions) {
                expression.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public LocalDeclaration getLocalDeclaration() {
        Expression expression = this.constantExpressions[this.patternIndex];
        LocalDeclaration localDeclaration = expression.getPatternVariableIntroduced();
        return localDeclaration;
    }

    public static class ResolvedCase {
        static final ResolvedCase[] UnresolvedCase = new ResolvedCase[0];
        public Constant c;
        public Expression e;
        public TypeBinding t;
        private int intValue;
        private boolean isPattern;

        ResolvedCase(Constant constant, Expression expression, TypeBinding typeBinding) {
            this.c = constant;
            this.e = expression;
            this.t = typeBinding;
            if (constant.typeID() == 11) {
                constant.stringValue().hashCode();
            } else {
                this.intValue = constant.intValue();
            }
            this.isPattern = expression instanceof Pattern;
        }

        public int intValue() {
            return this.intValue;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("case ");
            stringBuilder.append(this.e);
            stringBuilder.append(" [CONSTANT=");
            stringBuilder.append(this.c);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

