/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.audio.AudioDevice;

public final class AudioPlayer
extends Thread {
    private final AudioDevice devAudio = AudioDevice.device;
    private static final boolean DEBUG = false;
    public static final AudioPlayer player = AudioPlayer.getAudioPlayer();

    private static ThreadGroup getAudioThreadGroup() {
        ThreadGroup g = AudioPlayer.currentThread().getThreadGroup();
        while (g.getParent() != null && g.getParent().getParent() != null) {
            g = g.getParent();
        }
        return g;
    }

    private static AudioPlayer getAudioPlayer() {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                AudioPlayer t = new AudioPlayer();
                t.setPriority(10);
                t.setDaemon(true);
                t.start();
                return t;
            }
        };
        AudioPlayer audioPlayer = (AudioPlayer)AccessController.doPrivileged(action);
        return audioPlayer;
    }

    private AudioPlayer() {
        super(AudioPlayer.getAudioThreadGroup(), "Audio Player");
        this.devAudio.open();
    }

    public synchronized void start(InputStream in) {
        this.devAudio.openChannel(in);
        this.notify();
    }

    public synchronized void stop(InputStream in) {
        this.devAudio.closeChannel(in);
    }

    @Override
    public void run() {
        this.devAudio.play();
        try {
            while (true) {
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

