/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.Interface;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import jspecview.api.JSVZipReader;
import jspecview.api.SourceReader;
import jspecview.common.Coordinate;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PeakInfo;
import jspecview.common.Spectrum;
import jspecview.exception.JSVException;
import jspecview.source.BrukerReader;
import jspecview.source.JDXDataObject;
import jspecview.source.JDXDecompressor;
import jspecview.source.JDXHeader;
import jspecview.source.JDXSource;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.api.GenericFileInterface;
import org.jmol.api.JmolJDXMOLParser;
import org.jmol.api.JmolJDXMOLReader;
import org.jmol.util.Logger;

public class JDXReader
implements JmolJDXMOLReader {
    private static final String[] VAR_LIST_TABLE = new String[]{"PEAKTABLE   XYDATA      XYPOINTS", " (XY..XY)    (X++(Y..Y)) (XY..XY)    "};
    static final String ERROR_SEPARATOR = "=====================\n";
    private float nmrMaxY = Float.NaN;
    private JDXSource source;
    private JDXSourceStreamTokenizer t;
    private SB errorLog;
    private boolean obscure;
    private boolean done;
    private boolean isZipFile;
    private String filePath;
    private boolean loadImaginary = true;
    private boolean isSimulation;
    private boolean ignoreShiftReference;
    private boolean ignorePeakTables;
    String lastErrPath = null;
    private boolean isTabularData;
    private int firstSpec = 0;
    private int lastSpec = 0;
    private int nSpec = 0;
    private double blockID;
    private JmolJDXMOLParser mpr;
    private BufferedReader reader;
    private Spectrum modelSpectrum;
    private Lst<String[]> acdAssignments;
    private String acdMolFile;
    private Lst<PeakInfo> peakData;

    public static String getVarList(String string) {
        int n = VAR_LIST_TABLE[0].indexOf(string);
        return VAR_LIST_TABLE[1].substring(n + 1, n + 12).trim();
    }

    private JDXReader(String string, boolean bl, boolean bl2, int n, int n2, float f) {
        string = PT.trimQuotes(string);
        boolean bl3 = this.isSimulation = string != null && string.startsWith("http://SIMULATION/");
        if (this.isSimulation) {
            this.nmrMaxY = Float.isNaN(f) ? 10000.0f : f;
        }
        this.filePath = string;
        this.obscure = bl;
        this.firstSpec = n;
        this.lastSpec = n2;
        this.loadImaginary = bl2;
    }

    public static JDXSource createJDXSourceFromStream(InputStream inputStream, boolean bl, boolean bl2, float f) throws Exception {
        return JDXReader.createJDXSource(null, inputStream, "stream", bl, bl2, -1, -1, f);
    }

    public static Map<String, String> getHeaderMap(InputStream inputStream, Map<String, String> map) throws Exception {
        return JDXReader.getHeaderMapS(inputStream, map, null);
    }

    public static Map<String, String> getHeaderMapS(InputStream inputStream, Map<String, String> map, String string) throws Exception {
        if (map == null) {
            map = new LinkedHashMap<String, String>();
        }
        Lst lst = JDXReader.createJDXSource(null, (Object)inputStream, null, (boolean)false, (boolean)false, (int)0, (int)-1, (float)0.0f).getJDXSpectrum((int)0).headerTable;
        int n = 0;
        int n2 = lst.size();
        while (n < n2) {
            String[] stringArray = (String[])lst.get(n);
            map.put(string == null ? stringArray[2] : String.valueOf(stringArray[2]) + string, stringArray[1]);
            ++n;
        }
        return map;
    }

    public static JDXSource createJDXSource(GenericFileInterface genericFileInterface, Object object, String string, boolean bl, boolean bl2, int n, int n2, float f) throws Exception {
        BufferedReader bufferedReader;
        boolean bl3 = n2 < n;
        String string2 = null;
        byte[] byArray = null;
        if (AU.isAB(object) && Rdr.isZipB(byArray = (byte[])object)) {
            return JDXReader.readBrukerFileZip(byArray, genericFileInterface == null ? string : genericFileInterface.getFullPath());
        }
        if (object instanceof String || byArray != null) {
            if (object instanceof String) {
                string2 = (String)object;
            }
            bufferedReader = JSVFileManager.getBufferedReaderForStringOrBytes(object);
        } else {
            bufferedReader = object instanceof InputStream ? JSVFileManager.getBufferedReaderForInputStream((InputStream)object) : (BufferedReader)object;
        }
        String string3 = null;
        JDXSource jDXSource = null;
        try {
            if (bufferedReader == null) {
                if (genericFileInterface != null && genericFileInterface.isDirectory()) {
                    return JDXReader.readBrukerFileDir(genericFileInterface.getFullPath());
                }
                bufferedReader = JSVFileManager.getBufferedReaderFromName(string, "##TITLE");
            }
            if (!bl3) {
                bufferedReader.mark(400);
                char[] cArray = new char[400];
                bufferedReader.read(cArray, 0, 400);
                bufferedReader.reset();
                string3 = new String(cArray);
                if (string3.startsWith("PK")) {
                    bufferedReader.close();
                    return JDXReader.readBrukerFileZip(null, genericFileInterface.getFullPath());
                }
                if (string3.indexOf(0) >= 0 || string3.indexOf(65533) >= 0 || string3.indexOf("##TITLE= Parameter file") == 0 || string3.indexOf("##TITLE= Audit trail") == 0) {
                    bufferedReader.close();
                    return JDXReader.readBrukerFileDir(genericFileInterface.getParentAsFile().getFullPath());
                }
                int n3 = string3.indexOf(35);
                int n4 = string3.indexOf(60);
                if (n3 < 0 || n4 >= 0 && n4 < n3) {
                    String string4 = string3.toLowerCase();
                    String string5 = string4.contains("<animl") || string4.contains("<!doctype technique") ? "AnIML" : (string4 = string4.contains("xml-cml") ? "CML" : null);
                    if (string4 == null) {
                        return JDXReader.readBrukerFileDir(genericFileInterface.getFullPath());
                    }
                    jDXSource = ((SourceReader)JSViewer.getInterface("jspecview.source." + string4 + "Reader")).getSource(string, bufferedReader);
                    bufferedReader.close();
                    if (jDXSource == null) {
                        Logger.error(String.valueOf(string3) + "...");
                        throw new JSVException("File type not recognized");
                    }
                }
            }
            if (jDXSource == null) {
                jDXSource = new JDXReader(string, bl, bl2, n, n2, f).getJDXSource(bufferedReader, bl3);
            }
            if (string2 != null) {
                jDXSource.setInlineData(string2);
            }
            return jDXSource;
        }
        catch (Exception exception) {
            if (!JSViewer.isJS) {
                exception.printStackTrace();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (string3 != null) {
                Logger.error(String.valueOf(string3) + "...");
            }
            String string6 = exception.getMessage();
            throw new JSVException("Error reading data: " + string6);
        }
    }

    private static JDXSource readBrukerFileDir(String string) throws FileNotFoundException, Exception {
        return ((BrukerReader)Interface.getInterface("jspecview.source.BrukerReader")).readBrukerDir(string);
    }

    private static JDXSource readBrukerFileZip(byte[] byArray, String string) throws FileNotFoundException, Exception {
        return ((BrukerReader)Interface.getInterface("jspecview.source.BrukerReader")).readBrukerZip(byArray, string);
    }

    private JDXSource getJDXSource(Object object, boolean bl) throws JSVException {
        this.source = new JDXSource(0, this.filePath);
        this.isZipFile = object instanceof JSVZipReader;
        this.t = new JDXSourceStreamTokenizer((BufferedReader)object);
        this.errorLog = new SB();
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        while (!this.done && "##TITLE".equals(this.t.peakLabel())) {
            bl2 = true;
            if (string != null && !this.isZipFile) {
                this.logError("Warning - file is a concatenation without LINK record -- does not conform to JCAMP-DX standard 6.1.3!");
            }
            Spectrum spectrum = new Spectrum();
            Lst<String[]> lst = new Lst<String[]>();
            if (bl) {
                spectrum.setHeaderTable(lst);
            }
            while (!this.done && (string = this.t.getLabel()) != null && (string2 = this.getValue(string)) != null) {
                if (this.isTabularData) {
                    this.processTabularData(spectrum, lst, string, bl);
                    this.addSpectrum(spectrum, false);
                    if (this.isSimulation && spectrum.getXUnits().equals("PPM")) {
                        spectrum.setHZtoPPM(true);
                    }
                    spectrum = null;
                    if (!bl) continue;
                    JDXReader.addHeader(lst, this.t.rawLabel, "<data>");
                    break;
                }
                if (!bl) {
                    if (string.equals("##DATATYPE") && string2.toUpperCase().equals("LINK")) {
                        this.getBlockSpectra(lst);
                        spectrum = null;
                        continue;
                    }
                    if (string.equals("##NTUPLES") || string.equals("##VARNAME")) {
                        this.getNTupleSpectra(lst, spectrum, string);
                        spectrum = null;
                        continue;
                    }
                }
                if (string.equals("##JCAMPDX")) {
                    this.setVenderSpecificValues(this.t.rawLine);
                }
                if (spectrum == null) {
                    spectrum = new Spectrum();
                }
                this.processLabel(spectrum, lst, string, string2, bl);
            }
            if (!bl || spectrum == null) continue;
            this.addSpectrum(spectrum, false);
        }
        if (!bl2) {
            throw new JSVException("##TITLE record not found");
        }
        this.source.setErrorLog(this.errorLog.toString());
        return this.source;
    }

    private void processLabel(Spectrum spectrum, Lst<String[]> lst, String string, String string2, boolean bl) throws JSVException {
        if (!this.readDataLabel(spectrum, string, string2, this.errorLog, this.obscure, bl) && !bl) {
            return;
        }
        JDXReader.addHeader(lst, this.t.rawLabel, string2);
        if (!bl) {
            this.checkCustomTags(spectrum, string, string2);
        }
    }

    private void logError(String string) {
        this.errorLog.append(this.filePath == null || this.filePath.equals(this.lastErrPath) ? "" : this.filePath).append("\n").append(string).append("\n");
        this.lastErrPath = this.filePath;
    }

    private void setVenderSpecificValues(String string) {
        if (string.indexOf("JEOL") >= 0) {
            System.out.println("Skipping ##SHIFTREFERENCE for JEOL " + string);
            this.ignoreShiftReference = true;
        }
        if (string.indexOf("MestReNova") >= 0) {
            this.ignorePeakTables = true;
        }
    }

    private String getValue(String string) {
        String string2 = this.isTabularDataLabel(string) ? "" : this.t.getValue();
        return "##END".equals(string) ? null : string2;
    }

    private boolean isTabularDataLabel(String string) {
        this.isTabularData = "##DATATABLE##PEAKTABLE##XYDATA##XYPOINTS#".indexOf(String.valueOf(string) + "#") >= 0;
        return this.isTabularData;
    }

    private boolean addSpectrum(Spectrum spectrum, boolean bl) {
        if (!this.loadImaginary && spectrum.isImaginary()) {
            Logger.info("FileReader skipping imaginary spectrum -- use LOADIMAGINARY TRUE to load this spectrum.");
            return true;
        }
        if (this.acdAssignments != null) {
            if (!spectrum.dataType.equals("MASS SPECTRUM") && !spectrum.isContinuous()) {
                Logger.info("Skipping ACD Labs line spectrum for " + spectrum);
                return true;
            }
            if (this.acdAssignments.size() > 0) {
                try {
                    this.mpr.setACDAssignments(spectrum.title, spectrum.getTypeLabel(), this.source.peakCount, this.acdAssignments, this.acdMolFile);
                }
                catch (Exception exception) {
                    Logger.info("Failed to create peak data: " + exception);
                }
            }
            if (this.acdMolFile != null) {
                JSVFileManager.cachePut("mol", this.acdMolFile);
            }
        }
        if (!Float.isNaN(this.nmrMaxY)) {
            spectrum.normalizeSimulation(this.nmrMaxY);
        } else if (spectrum.getMaxY() >= 10000.0) {
            spectrum.normalizeSimulation(1000.0);
        }
        if (this.isSimulation) {
            spectrum.setSimulated(this.filePath);
        }
        ++this.nSpec;
        if (this.firstSpec > 0 && this.nSpec < this.firstSpec) {
            return true;
        }
        if (this.lastSpec > 0 && this.nSpec > this.lastSpec) {
            this.done = true;
            return !true;
        }
        spectrum.setBlockID(this.blockID);
        this.source.addJDXSpectrum(null, spectrum, bl);
        return true;
    }

    private JDXSource getBlockSpectra(Lst<String[]> lst) throws JSVException {
        Logger.debug("--JDX block start--");
        String string = "";
        String string2 = null;
        boolean bl = this.source.type == 0;
        boolean bl2 = false;
        while ((string = this.t.getLabel()) != null && !string.equals("##TITLE")) {
            int n;
            string2 = this.getValue(string);
            if (bl && !JDXReader.readHeaderLabel(this.source, string, string2, this.errorLog, this.obscure)) {
                JDXReader.addHeader(lst, this.t.rawLabel, string2);
            }
            if (!string.equals("##BLOCKS") || (n = PT.parseInt(string2)) <= 100 || this.firstSpec > 0) continue;
            bl2 = true;
        }
        string2 = this.getValue(string);
        if (!"##TITLE".equals(string)) {
            throw new JSVException("Unable to read block source");
        }
        if (bl) {
            this.source.setHeaderTable(lst);
        }
        this.source.type = 1;
        this.source.isCompoundSource = true;
        Spectrum spectrum = new Spectrum();
        Lst<Object> lst2 = new Lst<String[]>();
        this.readDataLabel(spectrum, string, string2, this.errorLog, this.obscure, false);
        try {
            String string3;
            while ((string3 = this.t.getLabel()) != null) {
                string2 = this.getValue(string3);
                if (string2 == null && "##END".equals(string)) {
                    Logger.debug("##END= " + this.t.getValue());
                } else {
                    string = string3;
                    if (this.isTabularData) {
                        this.processTabularData(spectrum, lst2, string, false);
                        continue;
                    }
                    if (string.equals("##DATATYPE")) {
                        if (string2.toUpperCase().equals("LINK")) {
                            this.getBlockSpectra(lst2);
                            spectrum = null;
                            string = null;
                        } else if (string2.toUpperCase().startsWith("NMR PEAK") && this.ignorePeakTables) {
                            this.done = true;
                            return this.source;
                        }
                    } else if (string.equals("##NTUPLES") || string.equals("##VARNAME")) {
                        this.getNTupleSpectra(lst2, spectrum, string);
                        spectrum = null;
                        string = "";
                    }
                    if (!this.done) {
                        if (spectrum == null) {
                            spectrum = new Spectrum();
                            lst2 = new Lst();
                            if (string == "") continue;
                            if (string == null) {
                                string = "##END";
                                continue;
                            }
                        }
                        if (string2 == null) {
                            if (spectrum.getXYCoords().length > 0 && !this.addSpectrum(spectrum, bl2)) {
                                return this.source;
                            }
                            spectrum = new Spectrum();
                            lst2 = new Lst();
                            continue;
                        }
                        this.processLabel(spectrum, lst2, string, string2, false);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            if (!JSViewer.isJS) {
                exception.printStackTrace();
            }
            throw new JSVException(exception.getMessage());
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.debug("--JDX block end--");
        return this.source;
    }

    private void addErrorLogSeparator() {
        if (this.errorLog.length() > 0 && this.errorLog.lastIndexOf(ERROR_SEPARATOR) != this.errorLog.length() - ERROR_SEPARATOR.length()) {
            this.logError(ERROR_SEPARATOR);
        }
    }

    private JDXSource getNTupleSpectra(Lst<String[]> lst, JDXDataObject jDXDataObject, String string) throws JSVException {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        double[] dArray = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        this.blockID = Math.random();
        boolean bl3 = true;
        if (this.firstSpec > 0) {
            jDXDataObject.setNumDim(1);
        }
        if (!(bl2 = string.equals("##VARNAME"))) {
            string = "";
        }
        Hashtable<String, Lst<String>> hashtable = new Hashtable<String, Lst<String>>();
        String[] stringArray = new String[2];
        boolean bl4 = bl = this.source.type == 0;
        if (bl) {
            this.source.type = 2;
            this.source.isCompoundSource = true;
            this.source.setHeaderTable(lst);
        }
        while (!(string = bl2 ? string : this.t.getLabel()).equals("##PAGE")) {
            bl2 = false;
            object2 = new StringTokenizer(this.t.getValue(), ",");
            object = new Lst();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((Lst)object).addLast(((StringTokenizer)object2).nextToken().trim());
            }
            hashtable.put(string, (Lst<String>)object);
        }
        object2 = (Lst)hashtable.get("##SYMBOL");
        if (!string.equals("##PAGE")) {
            throw new JSVException("Error Reading NTuple Source");
        }
        object = this.t.getValue();
        Spectrum spectrum = null;
        boolean bl5 = true;
        while (!this.done) {
            String[] stringArray2;
            string = this.t.getLabel();
            if (string.equals("##ENDNTUPLES")) {
                this.t.getValue();
                break;
            }
            if (string.equals("##PAGE")) {
                object = this.t.getValue();
                continue;
            }
            if (spectrum == null) {
                int n;
                spectrum = new Spectrum();
                jDXDataObject.copyTo(spectrum);
                spectrum.setTitle(jDXDataObject.getTitle());
                if (!spectrum.is1D() && (n = ((String)object).indexOf(61)) >= 0) {
                    try {
                        spectrum.setY2D(this.parseAFFN(((String)object).substring(0, n), ((String)object).substring(n + 1).trim()));
                        String string2 = ((String)object).substring(0, n).trim();
                        int n2 = ((ArrayList)object2).indexOf(string2);
                        if (n2 >= 0) {
                            spectrum.setY2DUnits((String)((Lst)hashtable.get("##UNITS")).get(n2));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Lst<String[]> lst2 = new Lst<String[]>();
            spectrum.setHeaderTable(lst2);
            while (!string.equals("##DATATABLE")) {
                JDXReader.addHeader(lst2, this.t.rawLabel, this.t.getValue());
                string = this.t.getLabel();
            }
            boolean bl6 = true;
            String string3 = this.t.flushLine();
            if (string3.trim().indexOf("PEAKS") > 0) {
                bl6 = false;
            }
            int n = string3.indexOf(40);
            int n3 = string3.lastIndexOf(41);
            if (n == -1 || n3 == -1) {
                throw new JSVException("Variable List not Found");
            }
            String string4 = string3.substring(n, n3 + 1);
            int n4 = 0;
            int n5 = 0;
            while (n5 < ((ArrayList)object2).size()) {
                stringArray2 = ((String)((ArrayList)object2).get(n5)).trim();
                if (string4.indexOf((String)stringArray2) != -1) {
                    stringArray[n4++] = stringArray2;
                }
                if (n4 == 2) break;
                ++n5;
            }
            this.setTabularDataType(spectrum, "##" + (bl6 ? "XYDATA" : "PEAKTABLE"));
            if (!this.readNTUPLECoords(spectrum, hashtable, stringArray, dArray)) {
                throw new JSVException("Unable to read Ntuple Source");
            }
            if (!spectrum.nucleusX.equals("?")) {
                jDXDataObject.nucleusX = spectrum.nucleusX;
            }
            jDXDataObject.nucleusY = spectrum.nucleusY;
            jDXDataObject.freq2dX = spectrum.freq2dX;
            jDXDataObject.freq2dY = spectrum.freq2dY;
            jDXDataObject.y2DUnits = spectrum.y2DUnits;
            n5 = 0;
            while (n5 < lst.size()) {
                stringArray2 = (String[])lst.get(n5);
                String string5 = JDXSourceStreamTokenizer.cleanLabel(stringArray2[0]);
                if (!(string5.equals("##TITLE") || string5.equals("##DATACLASS") || string5.equals("##NTUPLES"))) {
                    lst2.addLast(stringArray2);
                }
                ++n5;
            }
            if (bl3) {
                this.addSpectrum(spectrum, !bl5);
            }
            bl5 = false;
            spectrum = null;
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.info("NTUPLE MIN/MAX Y = " + dArray[0] + " " + dArray[1]);
        return this.source;
    }

    private boolean readDataLabel(JDXDataObject jDXDataObject, String string, String string2, SB sB, boolean bl, boolean bl2) {
        if (!JDXReader.readHeaderLabel(jDXDataObject, string, string2, sB, bl)) {
            return false;
        }
        if ("##MINX ##MINY ##MAXX ##MAXY ##FIRSTY ##DELTAX ##DATACLASS ".indexOf(string = String.valueOf(string) + " ") >= 0) {
            return false;
        }
        switch ("##FIRSTX  ##LASTX   ##NPOINTS ##XFACTOR ##YFACTOR ##XUNITS  ##YUNITS  ##XLABEL  ##YLABEL  ##NUMDIM  ##OFFSET  ".indexOf(string)) {
            case 0: {
                jDXDataObject.fileFirstX = this.parseAFFN(string, string2);
                return false;
            }
            case 10: {
                jDXDataObject.fileLastX = this.parseAFFN(string, string2);
                return false;
            }
            case 20: {
                jDXDataObject.fileNPoints = Integer.parseInt(string2);
                return false;
            }
            case 30: {
                jDXDataObject.setXFactor(this.parseAFFN(string, string2));
                return false;
            }
            case 40: {
                jDXDataObject.yFactor = this.parseAFFN(string, string2);
                return false;
            }
            case 50: {
                jDXDataObject.setXUnits(string2);
                return false;
            }
            case 60: {
                jDXDataObject.setYUnits(string2);
                return false;
            }
            case 70: {
                jDXDataObject.setXLabel(string2);
                return true;
            }
            case 80: {
                jDXDataObject.setYLabel(string2);
                return true;
            }
            case 90: {
                jDXDataObject.setNumDim(Integer.parseInt(string2));
                return false;
            }
            case 100: {
                if (!jDXDataObject.isShiftTypeSpecified()) {
                    jDXDataObject.setShiftReference(this.parseAFFN(string, string2), 1, 1);
                }
                return false;
            }
        }
        if (string.length() < 17) {
            return true;
        }
        if (string.equals("##.OBSERVEFREQUENCY ")) {
            jDXDataObject.setObservedFreq(this.parseAFFN(string, string2));
            return false;
        }
        if (string.equals("##.OBSERVENUCLEUS ")) {
            jDXDataObject.setObservedNucleus(string2);
            return false;
        }
        if (string.equals("##$REFERENCEPOINT ") && !jDXDataObject.isShiftTypeSpecified()) {
            int n = string2.indexOf(" ");
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            jDXDataObject.setShiftReference(this.parseAFFN(string, string2), 1, 2);
            return false;
        }
        if (string.equals("##.SHIFTREFERENCE ")) {
            if (this.ignoreShiftReference || !jDXDataObject.dataType.toUpperCase().contains("SPECTRUM")) {
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2 = PT.replaceAllCharacters(string2, ")(", ""), ",");
            if (stringTokenizer.countTokens() != 4) {
                return false;
            }
            try {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                double d = this.parseAFFN(string, stringTokenizer.nextToken().trim());
                jDXDataObject.setShiftReference(d, n, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private static boolean readHeaderLabel(JDXHeader jDXHeader, String string, String string2, SB sB, boolean bl) {
        switch ("##TITLE#####JCAMPDX###ORIGIN####OWNER#####DATATYPE##LONGDATE##DATE######TIME####".indexOf(String.valueOf(string) + "#")) {
            case 0: {
                jDXHeader.setTitle(bl || string2 == null || string2.equals("") ? "Unknown" : string2);
                return false;
            }
            case 10: {
                jDXHeader.jcampdx = string2;
                float f = PT.parseFloat(string2);
                if (((double)f >= 6.0 || Float.isNaN(f)) && sB != null) {
                    sB.append("Warning: JCAMP-DX version may not be fully supported: " + string2);
                }
                return false;
            }
            case 20: {
                jDXHeader.origin = string2 != null && !string2.equals("") ? string2 : "Unknown";
                return false;
            }
            case 30: {
                jDXHeader.owner = string2 != null && !string2.equals("") ? string2 : "Unknown";
                return false;
            }
            case 40: {
                jDXHeader.dataType = string2;
                return false;
            }
            case 50: {
                jDXHeader.longDate = string2;
                return false;
            }
            case 60: {
                jDXHeader.date = string2;
                return false;
            }
            case 70: {
                jDXHeader.time = string2;
                return false;
            }
        }
        return true;
    }

    private void setTabularDataType(JDXDataObject jDXDataObject, String string) {
        if (string.equals("##PEAKASSIGNMENTS")) {
            jDXDataObject.setDataClass("PEAKASSIGNMENTS");
        } else if (string.equals("##PEAKTABLE")) {
            jDXDataObject.setDataClass("PEAKTABLE");
        } else if (string.equals("##XYDATA")) {
            jDXDataObject.setDataClass("XYDATA");
        } else if (string.equals("##XYPOINTS")) {
            jDXDataObject.setDataClass("XYPOINTS");
        }
    }

    private void processTabularData(JDXDataObject jDXDataObject, Lst<String[]> lst, String string, boolean bl) throws JSVException {
        this.setTabularDataType(jDXDataObject, string);
        jDXDataObject.setHeaderTable(lst);
        if (jDXDataObject.dataClass.equals("XYDATA")) {
            jDXDataObject.checkJDXRequiredTokens();
            if (!bl) {
                this.decompressData(jDXDataObject, null);
            }
            return;
        }
        if (jDXDataObject.dataClass.equals("PEAKTABLE") || jDXDataObject.dataClass.equals("XYPOINTS")) {
            Coordinate[] coordinateArray;
            jDXDataObject.setContinuous(jDXDataObject.dataClass.equals("XYPOINTS"));
            try {
                this.t.readLineTrimmed();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (jDXDataObject.xFactor != Double.MAX_VALUE && jDXDataObject.yFactor != Double.MAX_VALUE) {
                String string2 = this.t.getValue();
                coordinateArray = Coordinate.parseDSV(string2, jDXDataObject.xFactor, jDXDataObject.yFactor);
            } else {
                coordinateArray = Coordinate.parseDSV(this.t.getValue(), 1.0, 1.0);
            }
            jDXDataObject.setXYCoords(coordinateArray);
            double d = Coordinate.deltaX(coordinateArray[coordinateArray.length - 1].getXVal(), coordinateArray[0].getXVal(), coordinateArray.length);
            jDXDataObject.setIncreasing(d > 0.0);
            return;
        }
        throw new JSVException("Unable to read JDX file tabular data for line " + this.t.labelLineNo);
    }

    private boolean readNTUPLECoords(JDXDataObject jDXDataObject, Map<String, Lst<String>> map, String[] stringArray, double[] dArray) {
        if (jDXDataObject.dataClass.equals("XYDATA")) {
            Lst<String> lst = map.get("##SYMBOL");
            int n = lst.indexOf(stringArray[0]);
            int n2 = lst.indexOf(stringArray[1]);
            lst = map.get("##VARNAME");
            jDXDataObject.setVarName(((String)lst.get(n2)).toUpperCase());
            String string = "##FACTOR";
            lst = map.get("##FACTOR");
            jDXDataObject.setXFactor(this.parseAFFN(string, (String)lst.get(n)));
            jDXDataObject.setYFactor(this.parseAFFN(string, (String)lst.get(n2)));
            string = "##LAST";
            lst = map.get("##LAST");
            jDXDataObject.fileLastX = this.parseAFFN(string, (String)lst.get(n));
            string = "##FIRST";
            lst = map.get("##FIRST");
            jDXDataObject.fileFirstX = this.parseAFFN(string, (String)lst.get(n));
            lst = map.get("##VARDIM");
            jDXDataObject.fileNPoints = Integer.parseInt((String)lst.get(n));
            lst = map.get("##UNITS");
            jDXDataObject.setXUnits((String)lst.get(n));
            jDXDataObject.setYUnits((String)lst.get(n2));
            if (jDXDataObject.nucleusX == null && (lst = map.get("##.NUCLEUS")) != null) {
                jDXDataObject.setNucleusAndFreq((String)lst.get(0), false);
                jDXDataObject.setNucleusAndFreq((String)lst.get(n), true);
            } else if (jDXDataObject.nucleusX == null) {
                jDXDataObject.nucleusX = "?";
            }
            this.decompressData(jDXDataObject, dArray);
            return true;
        }
        if (jDXDataObject.dataClass.equals("PEAKTABLE") || jDXDataObject.dataClass.equals("XYPOINTS")) {
            jDXDataObject.setContinuous(jDXDataObject.dataClass.equals("XYPOINTS"));
            Lst<String> lst = map.get("##SYMBOL");
            int n = lst.indexOf(stringArray[0]);
            int n3 = lst.indexOf(stringArray[1]);
            lst = map.get("##UNITS");
            jDXDataObject.setXUnits((String)lst.get(n));
            jDXDataObject.setYUnits((String)lst.get(n3));
            jDXDataObject.setXYCoords(Coordinate.parseDSV(this.t.getValue(), jDXDataObject.xFactor, jDXDataObject.yFactor));
            return true;
        }
        return false;
    }

    private double parseAFFN(String string, String string2) {
        int n = string2.indexOf("E");
        if (n > 0) {
            int n2 = string2.length();
            switch (n2 - n) {
                case 2: 
                case 3: {
                    this.logError("Warning - " + string + " value " + string2 + " is not of the format xxxE[+/-]nn or xxxE[+/-]nnn (spec. 4.5.3) -- warning only; accepted");
                    break;
                }
                case 4: 
                case 5: {
                    char c = string2.charAt(n + 1);
                    if (c == '+' || c == '-') break;
                }
                default: {
                    this.logError("Error - " + string + " value " + string2 + " is not of the format xxxE[+/-]nn or xxxE[+/-]nnn (spec. 4.5.3) -- " + string2.substring(n) + " ignored!");
                    string2 = string2.substring(0, n);
                }
            }
        }
        return Double.parseDouble(string2);
    }

    private void decompressData(JDXDataObject jDXDataObject, double[] dArray) {
        int n = this.errorLog.length();
        jDXDataObject.setIncreasing(jDXDataObject.fileLastX > jDXDataObject.fileFirstX);
        jDXDataObject.setContinuous(true);
        JDXDecompressor jDXDecompressor = new JDXDecompressor(this.t, jDXDataObject.fileFirstX, jDXDataObject.fileLastX, jDXDataObject.xFactor, jDXDataObject.yFactor, jDXDataObject.fileNPoints);
        long l = System.currentTimeMillis();
        Coordinate[] coordinateArray = jDXDecompressor.decompressData(this.errorLog);
        if (Logger.debugging) {
            Logger.debug("decompression time = " + (System.currentTimeMillis() - l) + " ms");
        }
        jDXDataObject.setXYCoords(coordinateArray);
        double d = jDXDecompressor.getMinY();
        if (dArray != null) {
            if (d < dArray[0]) {
                dArray[0] = d;
            }
            if ((d = jDXDecompressor.getMaxY()) > dArray[1]) {
                dArray[1] = d;
            }
        }
        jDXDataObject.finalizeCoordinates();
        if (this.errorLog.length() != n) {
            double d2 = Coordinate.deltaX(jDXDataObject.fileLastX, jDXDataObject.fileFirstX, jDXDataObject.fileNPoints);
            this.logError(jDXDataObject.getTitle());
            this.logError("firstX from Header " + jDXDataObject.fileFirstX);
            this.logError("lastX from Header " + jDXDataObject.fileLastX + " Found " + jDXDecompressor.lastX);
            this.logError("deltaX from Header " + d2);
            this.logError("Number of points in Header " + jDXDataObject.fileNPoints + " Found " + jDXDecompressor.getNPointsFound());
        }
        if (Logger.debugging) {
            System.err.println(this.errorLog.toString());
        }
    }

    public static void addHeader(Lst<String[]> lst, String string, String string2) {
        String[] stringArray = null;
        int n = 0;
        while (n < lst.size()) {
            stringArray = (String[])lst.get(n);
            if (stringArray[0].equals(string)) {
                stringArray[1] = string2;
                return;
            }
            ++n;
        }
        lst.addLast(new String[]{string, string2, JDXSourceStreamTokenizer.cleanLabel(string)});
    }

    private boolean checkCustomTags(Spectrum spectrum, String string, String string2) throws JSVException {
        if (string.length() > 10) {
            string = string.substring(0, 10);
        }
        if (spectrum == null) {
            System.out.println(string);
        } else {
            this.modelSpectrum = spectrum;
        }
        int n = "##$MODELS ##$PEAKS  ##$SIGNALS##$MOLFILE##PEAKASSI##$UVIRASS##$MSFRAGM".indexOf(string);
        if (n < 0) {
            return false;
        }
        this.getMpr().set(this, this.filePath, null);
        try {
            try {
                this.reader = new BufferedReader(new StringReader(string2));
                switch (n) {
                    case 0: {
                        this.mpr.readModels();
                        break;
                    }
                    case 10: 
                    case 20: {
                        this.peakData = new Lst();
                        this.source.peakCount = this.source.peakCount + this.mpr.readPeaks(n == 20, this.source.peakCount);
                        break;
                    }
                    case 30: {
                        this.acdAssignments = new Lst();
                        this.acdMolFile = PT.rep(string2, "$$ Empty String", "");
                        break;
                    }
                    case 40: 
                    case 50: 
                    case 60: {
                        this.acdAssignments = this.mpr.readACDAssignments(spectrum.fileNPoints, n == 40);
                    }
                }
            }
            catch (Exception exception) {
                throw new JSVException(exception.getMessage());
            }
        }
        finally {
            this.reader = null;
        }
        return true;
    }

    private JmolJDXMOLParser getMpr() {
        return this.mpr == null ? (this.mpr = (JmolJDXMOLParser)JSViewer.getInterface("org.jmol.jsv.JDXMOLParser")) : this.mpr;
    }

    @Override
    public String rd() throws Exception {
        return this.reader.readLine();
    }

    @Override
    public void setSpectrumPeaks(int n, String string, String string2) {
        this.modelSpectrum.setPeakList(this.peakData, string, string2);
        if (this.modelSpectrum.isNMR()) {
            this.modelSpectrum.setHydrogenCount(n);
        }
    }

    @Override
    public void addPeakData(String string) {
        if (this.peakData == null) {
            this.peakData = new Lst();
        }
        this.peakData.addLast(new PeakInfo(string));
    }

    @Override
    public void processModelData(String string, String string2, String string3, String string4, String string5, float f, float f2, boolean bl) throws Exception {
    }

    @Override
    public String discardLinesUntilContains(String string) throws Exception {
        String string2;
        while ((string2 = this.rd()) != null && string2.indexOf(string) < 0) {
        }
        return string2;
    }

    @Override
    public String discardLinesUntilContains2(String string, String string2) throws Exception {
        String string3;
        while ((string3 = this.rd()) != null && string3.indexOf(string) < 0 && string3.indexOf(string2) < 0) {
        }
        return string3;
    }

    @Override
    public String discardLinesUntilNonBlank() throws Exception {
        String string;
        while ((string = this.rd()) != null && string.trim().length() == 0) {
        }
        return string;
    }
}

