/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.PatchableResourceApiAction;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.ActionGroupValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class ActionGroupsApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroup/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroup/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/actiongroup/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/actiongroup/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroups/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroups/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/actiongroups/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/actiongroups/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/actiongroups/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/actiongroups/{name}")));

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.ACTIONGROUPS;
    }

    @Inject
    public ActionGroupsApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new ActionGroupValidator(request, this.isSuperAdmin(), ref, this.settings, param);
    }

    @Override
    protected CType getConfigName() {
        return CType.ACTIONGROUPS;
    }

    @Override
    protected String getResourceName() {
        return "actiongroup";
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("name");
    }

    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        String name = request.param("name");
        if (name == null || name.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        SecurityDynamicConfiguration<?> existingRolesConfig = this.load(CType.ROLES, false);
        Set<String> existingRoles = existingRolesConfig.getCEntries().keySet();
        if (existingRoles.contains(name)) {
            this.badRequestResponse(channel, name + " is an existing role. A action group cannot be named with an existing role name.");
            return;
        }
        SecurityDynamicConfiguration<?> existingActionGroupsConfig = this.load(this.getConfigName(), false);
        existingActionGroupsConfig.putCObject(name, DefaultObjectMapper.readTree(content, existingActionGroupsConfig.getImplementingClass()));
        if (this.hasActionGroupSelfReference(existingActionGroupsConfig, name).booleanValue()) {
            this.badRequestResponse(channel, name + " cannot be an allowed_action of itself");
            return;
        }
        super.handlePut(channel, request, client, content);
    }
}

