/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor;

import org.opensearch.sql.legacy.executor.AsyncRestExecutor;
import org.opensearch.sql.legacy.executor.ElasticDefaultRestExecutor;
import org.opensearch.sql.legacy.executor.Format;
import org.opensearch.sql.legacy.executor.RestExecutor;
import org.opensearch.sql.legacy.executor.csv.CSVResultRestExecutor;
import org.opensearch.sql.legacy.executor.format.PrettyFormatRestExecutor;
import org.opensearch.sql.legacy.query.QueryAction;
import org.opensearch.sql.legacy.query.join.OpenSearchJoinQueryAction;
import org.opensearch.sql.legacy.query.multi.MultiQueryAction;

public class ActionRequestRestExecutorFactory {
    public static RestExecutor createExecutor(Format format, QueryAction queryAction) {
        switch (format) {
            case CSV: {
                return new AsyncRestExecutor(new CSVResultRestExecutor());
            }
            case JSON: {
                return new AsyncRestExecutor(new ElasticDefaultRestExecutor(queryAction), action -> ActionRequestRestExecutorFactory.isJoin(action) || ActionRequestRestExecutorFactory.isUnionMinus(action));
            }
        }
        return new AsyncRestExecutor(new PrettyFormatRestExecutor(format.getFormatName()));
    }

    private static boolean isJoin(QueryAction queryAction) {
        return queryAction instanceof OpenSearchJoinQueryAction;
    }

    private static boolean isUnionMinus(QueryAction queryAction) {
        return queryAction instanceof MultiQueryAction;
    }
}

