import { ComponentEvents } from 'svelte2tsx';
import ts from 'typescript';
export type ComponentPartInfo = ReturnType<ComponentEvents['getAll']>;
export interface ComponentInfoProvider {
    getEvents(): ComponentPartInfo;
    getSlotLets(slot?: string): ComponentPartInfo;
    getProps(): ComponentPartInfo;
    getProp(propName: string): ts.CompletionEntry[];
}
export declare class JsOrTsComponentInfoProvider implements ComponentInfoProvider {
    private readonly typeChecker;
    private readonly classType;
    private constructor();
    getEvents(): ComponentPartInfo;
    getSlotLets(slot?: string): ComponentPartInfo;
    getProps(): {
        name: string;
        type: string;
        doc?: string | undefined;
    }[];
    getProp(propName: string): ts.CompletionEntry[];
    /**
     * adopted from https://github.com/microsoft/TypeScript/blob/0921eac6dc9eba0be6319dff10b85d60c90155ea/src/services/stringCompletions.ts#L310
     */
    private getStringLiteralTypes;
    private getType;
    private mapPropertiesOfType;
    /**
     * The result of this shouldn't be cached as it could lead to memory leaks. The type checker
     * could become old and then multiple versions of it could exist.
     */
    static create(lang: ts.LanguageService, def: ts.DefinitionInfo): ComponentInfoProvider | null;
}
