// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega16U4.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega16u4

// Device information for the ATmega16U4.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega16U4"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin,Power-on Reset,Brown-out Reset,Watchdog Reset,and JTAG AVR Reset. See Datasheet.
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_INT2         = 3  // External Interrupt Request 2
	IRQ_INT3         = 4  // External Interrupt Request 3
	IRQ_Reserved1    = 5  // Reserved1
	IRQ_Reserved2    = 6  // Reserved2
	IRQ_INT6         = 7  // External Interrupt Request 6
	IRQ_Reserved3    = 8  // Reserved3
	IRQ_PCINT0       = 9  // Pin Change Interrupt Request 0
	IRQ_USB_GEN      = 10 // USB General Interrupt Request
	IRQ_USB_COM      = 11 // USB Endpoint/Pipe Interrupt Communication Request
	IRQ_WDT          = 12 // Watchdog Time-out Interrupt
	IRQ_Reserved4    = 13 // Reserved4
	IRQ_Reserved5    = 14 // Reserved5
	IRQ_Reserved6    = 15 // Reserved6
	IRQ_TIMER1_CAPT  = 16 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 17 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 18 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_COMPC = 19 // Timer/Counter1 Compare Match C
	IRQ_TIMER1_OVF   = 20 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 21 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 22 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 23 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 24 // SPI Serial Transfer Complete
	IRQ_USART1_RX    = 25 // USART1, Rx Complete
	IRQ_USART1_UDRE  = 26 // USART1 Data register Empty
	IRQ_USART1_TX    = 27 // USART1, Tx Complete
	IRQ_ANALOG_COMP  = 28 // Analog Comparator
	IRQ_ADC          = 29 // ADC Conversion Complete
	IRQ_EE_READY     = 30 // EEPROM Ready
	IRQ_TIMER3_CAPT  = 31 // Timer/Counter3 Capture Event
	IRQ_TIMER3_COMPA = 32 // Timer/Counter3 Compare Match A
	IRQ_TIMER3_COMPB = 33 // Timer/Counter3 Compare Match B
	IRQ_TIMER3_COMPC = 34 // Timer/Counter3 Compare Match C
	IRQ_TIMER3_OVF   = 35 // Timer/Counter3 Overflow
	IRQ_TWI          = 36 // 2-wire Serial Interface
	IRQ_SPM_READY    = 37 // Store Program Memory Read
	IRQ_TIMER4_COMPA = 38 // Timer/Counter4 Compare Match A
	IRQ_TIMER4_COMPB = 39 // Timer/Counter4 Compare Match B
	IRQ_TIMER4_COMPD = 40 // Timer/Counter4 Compare Match D
	IRQ_TIMER4_OVF   = 41 // Timer/Counter4 Overflow
	IRQ_TIMER4_FPF   = 42 // Timer/Counter4 Fault Protection Interrupt
	IRQ_max          = 42 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_INT3
//go:interrupt
func interruptINT3() {
	callHandlers(IRQ_INT3)
}

//export __vector_Reserved1
//go:interrupt
func interruptReserved1() {
	callHandlers(IRQ_Reserved1)
}

//export __vector_Reserved2
//go:interrupt
func interruptReserved2() {
	callHandlers(IRQ_Reserved2)
}

//export __vector_INT6
//go:interrupt
func interruptINT6() {
	callHandlers(IRQ_INT6)
}

//export __vector_Reserved3
//go:interrupt
func interruptReserved3() {
	callHandlers(IRQ_Reserved3)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_USB_GEN
//go:interrupt
func interruptUSB_GEN() {
	callHandlers(IRQ_USB_GEN)
}

//export __vector_USB_COM
//go:interrupt
func interruptUSB_COM() {
	callHandlers(IRQ_USB_COM)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_Reserved4
//go:interrupt
func interruptReserved4() {
	callHandlers(IRQ_Reserved4)
}

//export __vector_Reserved5
//go:interrupt
func interruptReserved5() {
	callHandlers(IRQ_Reserved5)
}

//export __vector_Reserved6
//go:interrupt
func interruptReserved6() {
	callHandlers(IRQ_Reserved6)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_COMPC
//go:interrupt
func interruptTIMER1_COMPC() {
	callHandlers(IRQ_TIMER1_COMPC)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMPA
//go:interrupt
func interruptTIMER0_COMPA() {
	callHandlers(IRQ_TIMER0_COMPA)
}

//export __vector_TIMER0_COMPB
//go:interrupt
func interruptTIMER0_COMPB() {
	callHandlers(IRQ_TIMER0_COMPB)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART1_RX
//go:interrupt
func interruptUSART1_RX() {
	callHandlers(IRQ_USART1_RX)
}

//export __vector_USART1_UDRE
//go:interrupt
func interruptUSART1_UDRE() {
	callHandlers(IRQ_USART1_UDRE)
}

//export __vector_USART1_TX
//go:interrupt
func interruptUSART1_TX() {
	callHandlers(IRQ_USART1_TX)
}

//export __vector_ANALOG_COMP
//go:interrupt
func interruptANALOG_COMP() {
	callHandlers(IRQ_ANALOG_COMP)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_TIMER3_CAPT
//go:interrupt
func interruptTIMER3_CAPT() {
	callHandlers(IRQ_TIMER3_CAPT)
}

//export __vector_TIMER3_COMPA
//go:interrupt
func interruptTIMER3_COMPA() {
	callHandlers(IRQ_TIMER3_COMPA)
}

//export __vector_TIMER3_COMPB
//go:interrupt
func interruptTIMER3_COMPB() {
	callHandlers(IRQ_TIMER3_COMPB)
}

//export __vector_TIMER3_COMPC
//go:interrupt
func interruptTIMER3_COMPC() {
	callHandlers(IRQ_TIMER3_COMPC)
}

//export __vector_TIMER3_OVF
//go:interrupt
func interruptTIMER3_OVF() {
	callHandlers(IRQ_TIMER3_OVF)
}

//export __vector_TWI
//go:interrupt
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export __vector_SPM_READY
//go:interrupt
func interruptSPM_READY() {
	callHandlers(IRQ_SPM_READY)
}

//export __vector_TIMER4_COMPA
//go:interrupt
func interruptTIMER4_COMPA() {
	callHandlers(IRQ_TIMER4_COMPA)
}

//export __vector_TIMER4_COMPB
//go:interrupt
func interruptTIMER4_COMPB() {
	callHandlers(IRQ_TIMER4_COMPB)
}

//export __vector_TIMER4_COMPD
//go:interrupt
func interruptTIMER4_COMPD() {
	callHandlers(IRQ_TIMER4_COMPD)
}

//export __vector_TIMER4_OVF
//go:interrupt
func interruptTIMER4_OVF() {
	callHandlers(IRQ_TIMER4_OVF)
}

//export __vector_TIMER4_FPF
//go:interrupt
func interruptTIMER4_FPF() {
	callHandlers(IRQ_TIMER4_FPF)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// I/O Port
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	PORTF = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	DDRF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))
	PINF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// USART
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	UCSR1D = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcb)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 10-bit
	TCCR4A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc0)))
	TCCR4B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc1)))
	TCCR4C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc2)))
	TCCR4D = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc3)))
	TCCR4E = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc4)))
	TCNT4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbe)))
	TC4H   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbf)))
	OCR4A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcf)))
	OCR4B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd0)))
	OCR4C  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd1)))
	OCR4D  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd2)))
	TIMSK4 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x72)))
	TIFR4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	DT4    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd4)))

	// Timer/Counter, 16-bit
	TCCR3A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))
	TCCR3B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	TCCR3C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	TCNT3L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x94)))
	TCNT3H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x95)))
	OCR3AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x98)))
	OCR3AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x99)))
	OCR3BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9a)))
	OCR3BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9b)))
	OCR3CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9c)))
	OCR3CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9d)))
	ICR3L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	ICR3H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))
	TIMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x71)))
	TIFR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	OCR1CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8c)))
	OCR1CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8d)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))

	// JTAG Interface
	OCDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))
	MCUCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EICRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))

	// Two Wire Serial Interface
	TWAMR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbd)))
	TWBR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	TWAR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))
	DIDR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))

	// Analog Comparator
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	DIDR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))

	// CPU Registers
	SREG    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	OSCCAL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	RCCTRL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x67)))
	CLKPR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	EIND    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	RAMPZ   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GPIOR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PRR1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x65)))
	PRR0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))
	CLKSTA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc7)))
	CLKSEL1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc6)))
	CLKSEL0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc5)))

	// Phase Locked Loop
	PLLCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	PLLFRQ = (*volatile.Register8)(unsafe.Pointer(uintptr(0x52)))

	// USB Device Registers
	UEINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	UEBCHX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	UEBCLX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	UEDATX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	UEIENX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	UESTA1X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xef)))
	UESTA0X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xee)))
	UECFG1X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xed)))
	UECFG0X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xec)))
	UECONX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xeb)))
	UERST   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xea)))
	UENUM   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	UEINTX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	UDMFN   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	UDFNUML = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	UDFNUMH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	UDADDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	UDIEN   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	UDINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	UDCON   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))
	USBCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	USBINT  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xda)))
	USBSTA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd9)))
	UHWCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd7)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODLEVEL0    = 0x1 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL1    = 0x2 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL2    = 0x4 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL_Msk = 0x7 // Brown-out Detector trigger level
	EXTENDED_HWBE         = 0x8 // Hardware Boot Enable
	EXTENDED_HWBE_Msk     = 0x8 // Hardware Boot Enable

	// HIGH
	HIGH_OCDEN       = 0x80 // On-Chip Debug Enabled
	HIGH_OCDEN_Msk   = 0x80 // On-Chip Debug Enabled
	HIGH_JTAGEN      = 0x40 // JTAG Interface Enabled
	HIGH_JTAGEN_Msk  = 0x40 // JTAG Interface Enabled
	HIGH_SPIEN       = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON       = 0x10 // Watchdog timer always on
	HIGH_WDTON_Msk   = 0x10 // Watchdog timer always on
	HIGH_EESAVE      = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0     = 0x2  // Select Boot Size
	HIGH_BOOTSZ1     = 0x4  // Select Boot Size
	HIGH_BOOTSZ_Msk  = 0x6  // Select Boot Size
	HIGH_BOOTRST     = 0x1  // Boot Reset vector Enabled
	HIGH_BOOTRST_Msk = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on PORTC7
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTC7
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF     = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIF_Msk = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE     = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDIE_Msk = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCSR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCSR_WDE      = 0x8  // Watch Dog Enable
	WDTCSR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPDR: SPI Data Register
	SPDR_SPDR0    = 0x1  // SPI Data bits
	SPDR_SPDR1    = 0x2  // SPI Data bits
	SPDR_SPDR2    = 0x4  // SPI Data bits
	SPDR_SPDR3    = 0x8  // SPI Data bits
	SPDR_SPDR4    = 0x10 // SPI Data bits
	SPDR_SPDR5    = 0x20 // SPI Data bits
	SPDR_SPDR6    = 0x40 // SPI Data bits
	SPDR_SPDR7    = 0x80 // SPI Data bits
	SPDR_SPDR_Msk = 0xff // SPI Data bits
)

// Bitfields for USART: USART
const (
	// UDR1: USART I/O Data Register
	UDR1_UDR10    = 0x1  // USART I/O Data bits
	UDR1_UDR11    = 0x2  // USART I/O Data bits
	UDR1_UDR12    = 0x4  // USART I/O Data bits
	UDR1_UDR13    = 0x8  // USART I/O Data bits
	UDR1_UDR14    = 0x10 // USART I/O Data bits
	UDR1_UDR15    = 0x20 // USART I/O Data bits
	UDR1_UDR16    = 0x40 // USART I/O Data bits
	UDR1_UDR17    = 0x80 // USART I/O Data bits
	UDR1_UDR1_Msk = 0xff // USART I/O Data bits

	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1      = 0x80 // USART Receive Complete
	UCSR1A_RXC1_Msk  = 0x80 // USART Receive Complete
	UCSR1A_TXC1      = 0x40 // USART Transmitt Complete
	UCSR1A_TXC1_Msk  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1     = 0x20 // USART Data Register Empty
	UCSR1A_UDRE1_Msk = 0x20 // USART Data Register Empty
	UCSR1A_FE1       = 0x10 // Framing Error
	UCSR1A_FE1_Msk   = 0x10 // Framing Error
	UCSR1A_DOR1      = 0x8  // Data overRun
	UCSR1A_DOR1_Msk  = 0x8  // Data overRun
	UCSR1A_UPE1      = 0x4  // Parity Error
	UCSR1A_UPE1_Msk  = 0x4  // Parity Error
	UCSR1A_U2X1      = 0x2  // Double the USART transmission speed
	UCSR1A_U2X1_Msk  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1     = 0x1  // Multi-processor Communication Mode
	UCSR1A_MPCM1_Msk = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1     = 0x80 // RX Complete Interrupt Enable
	UCSR1B_RXCIE1_Msk = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1     = 0x40 // TX Complete Interrupt Enable
	UCSR1B_TXCIE1_Msk = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1     = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_UDRIE1_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1      = 0x10 // Receiver Enable
	UCSR1B_RXEN1_Msk  = 0x10 // Receiver Enable
	UCSR1B_TXEN1      = 0x8  // Transmitter Enable
	UCSR1B_TXEN1_Msk  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12     = 0x4  // Character Size
	UCSR1B_UCSZ12_Msk = 0x4  // Character Size
	UCSR1B_RXB81      = 0x2  // Receive Data Bit 8
	UCSR1B_RXB81_Msk  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81      = 0x1  // Transmit Data Bit 8
	UCSR1B_TXB81_Msk  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_UMSEL10    = 0x40 // USART Mode Select
	UCSR1C_UMSEL11    = 0x80 // USART Mode Select
	UCSR1C_UMSEL1_Msk = 0xc0 // USART Mode Select
	UCSR1C_UPM10      = 0x10 // Parity Mode Bits
	UCSR1C_UPM11      = 0x20 // Parity Mode Bits
	UCSR1C_UPM1_Msk   = 0x30 // Parity Mode Bits
	UCSR1C_USBS1      = 0x8  // Stop Bit Select
	UCSR1C_USBS1_Msk  = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10     = 0x2  // Character Size
	UCSR1C_UCSZ11     = 0x4  // Character Size
	UCSR1C_UCSZ1_Msk  = 0x6  // Character Size
	UCSR1C_UCPOL1     = 0x1  // Clock Polarity
	UCSR1C_UCPOL1_Msk = 0x1  // Clock Polarity

	// UCSR1D: USART Control and Status Register D
	UCSR1D_CTSEN     = 0x2 // CTS Enable
	UCSR1D_CTSEN_Msk = 0x2 // CTS Enable
	UCSR1D_RTSEN     = 0x1 // RTS Enable
	UCSR1D_RTSEN_Msk = 0x1 // RTS Enable
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD      = 0x20 // Signature Row Read
	SPMCSR_SIGRD_Msk  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE     = 0x10 // Read While Write section read enable
	SPMCSR_RWWSRE_Msk = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCSR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT      = 0x4  // Page Write
	SPMCSR_PGWRT_Msk  = 0x4  // Page Write
	SPMCSR_PGERS      = 0x2  // Page Erase
	SPMCSR_PGERS_Msk  = 0x2  // Page Erase
	SPMCSR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EEARL: EEPROM Address Register Low Bytes

	// EEARH: EEPROM Address Register Low Bytes
	EEAR_EEAR0    = 0x1   // EEPROM Address Bits
	EEAR_EEAR1    = 0x2   // EEPROM Address Bits
	EEAR_EEAR2    = 0x4   // EEPROM Address Bits
	EEAR_EEAR3    = 0x8   // EEPROM Address Bits
	EEAR_EEAR4    = 0x10  // EEPROM Address Bits
	EEAR_EEAR5    = 0x20  // EEPROM Address Bits
	EEAR_EEAR6    = 0x40  // EEPROM Address Bits
	EEAR_EEAR7    = 0x80  // EEPROM Address Bits
	EEAR_EEAR_Msk = 0xfff // EEPROM Address Bits

	// EEDR: EEPROM Data Register
	EEDR_EEDR0    = 0x1  // EEPROM Data Bits
	EEDR_EEDR1    = 0x2  // EEPROM Data Bits
	EEDR_EEDR2    = 0x4  // EEPROM Data Bits
	EEDR_EEDR3    = 0x8  // EEPROM Data Bits
	EEDR_EEDR4    = 0x10 // EEPROM Data Bits
	EEDR_EEDR5    = 0x20 // EEPROM Data Bits
	EEDR_EEDR6    = 0x40 // EEPROM Data Bits
	EEDR_EEDR7    = 0x80 // EEPROM Data Bits
	EEDR_EEDR_Msk = 0xff // EEPROM Data Bits

	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1     = 0x20 // EEPROM Programming Mode Bits
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming Mode Bits
	EECR_EERIE     = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE     = 0x4  // EEPROM Master Write Enable
	EECR_EEMPE_Msk = 0x4  // EEPROM Master Write Enable
	EECR_EEPE      = 0x2  // EEPROM Write Enable
	EECR_EEPE_Msk  = 0x2  // EEPROM Write Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// OCR0B: Timer/Counter0 Output Compare Register
	OCR0B_OCR0B0    = 0x1  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B1    = 0x2  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B2    = 0x4  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B3    = 0x8  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B4    = 0x10 // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B5    = 0x20 // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B6    = 0x40 // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B7    = 0x80 // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B_Msk = 0xff // Timer/Counter0 Output Compare B bits

	// OCR0A: Timer/Counter0 Output Compare Register
	OCR0A_OCR0A0    = 0x1  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A1    = 0x2  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A2    = 0x4  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A3    = 0x8  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A4    = 0x10 // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A5    = 0x20 // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A6    = 0x40 // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A7    = 0x80 // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A_Msk = 0xff // Timer/Counter0 Output Compare A bits

	// TCNT0: Timer/Counter0
	TCNT0_TCNT00    = 0x1  // Timer/Counter0 bits
	TCNT0_TCNT01    = 0x2  // Timer/Counter0 bits
	TCNT0_TCNT02    = 0x4  // Timer/Counter0 bits
	TCNT0_TCNT03    = 0x8  // Timer/Counter0 bits
	TCNT0_TCNT04    = 0x10 // Timer/Counter0 bits
	TCNT0_TCNT05    = 0x20 // Timer/Counter0 bits
	TCNT0_TCNT06    = 0x40 // Timer/Counter0 bits
	TCNT0_TCNT07    = 0x80 // Timer/Counter0 bits
	TCNT0_TCNT0_Msk = 0xff // Timer/Counter0 bits

	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A     = 0x80 // Force Output Compare A
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare A
	TCCR0B_FOC0B     = 0x40 // Force Output Compare B
	TCCR0B_FOC0B_Msk = 0x40 // Force Output Compare B
	TCCR0B_WGM02     = 0x8
	TCCR0B_WGM02_Msk = 0x8
	TCCR0B_CS00      = 0x1 // Clock Select
	TCCR0B_CS01      = 0x2 // Clock Select
	TCCR0B_CS02      = 0x4 // Clock Select
	TCCR0B_CS0_Msk   = 0x7 // Clock Select

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0    = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1    = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A_Msk = 0xc0 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0    = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1    = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B_Msk = 0x30 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00     = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01     = 0x2  // Waveform Generation Mode
	TCCR0A_WGM0_Msk  = 0x3  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B     = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0B_Msk = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B     = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0B_Msk = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A     = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_OCF0A_Msk = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM         = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSRSYNC     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRSYNC_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
)

// Bitfields for TC10: Timer/Counter, 10-bit
const (
	// TCCR4A: Timer/Counter4 Control Register A
	TCCR4A_COM4A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR4A_COM4A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR4A_COM4A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR4A_COM4B0    = 0x10 // Compare Output Mode 4B, bits
	TCCR4A_COM4B1    = 0x20 // Compare Output Mode 4B, bits
	TCCR4A_COM4B_Msk = 0x30 // Compare Output Mode 4B, bits
	TCCR4A_FOC4A     = 0x8  // Force Output Compare Match 4A
	TCCR4A_FOC4A_Msk = 0x8  // Force Output Compare Match 4A
	TCCR4A_FOC4B     = 0x4  // Force Output Compare Match 4B
	TCCR4A_FOC4B_Msk = 0x4  // Force Output Compare Match 4B
	TCCR4A_PWM4A     = 0x2
	TCCR4A_PWM4A_Msk = 0x2
	TCCR4A_PWM4B     = 0x1
	TCCR4A_PWM4B_Msk = 0x1

	// TCCR4B: Timer/Counter4 Control Register B
	TCCR4B_PWM4X     = 0x80 // PWM Inversion Mode
	TCCR4B_PWM4X_Msk = 0x80 // PWM Inversion Mode
	TCCR4B_PSR4      = 0x40 // Prescaler Reset Timer/Counter 4
	TCCR4B_PSR4_Msk  = 0x40 // Prescaler Reset Timer/Counter 4
	TCCR4B_DTPS40    = 0x10 // Dead Time Prescaler Bits
	TCCR4B_DTPS41    = 0x20 // Dead Time Prescaler Bits
	TCCR4B_DTPS4_Msk = 0x30 // Dead Time Prescaler Bits
	TCCR4B_CS40      = 0x1  // Clock Select Bits
	TCCR4B_CS41      = 0x2  // Clock Select Bits
	TCCR4B_CS42      = 0x4  // Clock Select Bits
	TCCR4B_CS43      = 0x8  // Clock Select Bits
	TCCR4B_CS4_Msk   = 0xf  // Clock Select Bits

	// TCCR4C: Timer/Counter 4 Control Register C
	TCCR4C_COM4A1S     = 0x80 // Comparator A Output Mode
	TCCR4C_COM4A1S_Msk = 0x80 // Comparator A Output Mode
	TCCR4C_COM4A0S     = 0x40 // Comparator A Output Mode
	TCCR4C_COM4A0S_Msk = 0x40 // Comparator A Output Mode
	TCCR4C_COM4B1S     = 0x20 // Comparator B Output Mode
	TCCR4C_COM4B1S_Msk = 0x20 // Comparator B Output Mode
	TCCR4C_COM4B0S     = 0x10 // Comparator B Output Mode
	TCCR4C_COM4B0S_Msk = 0x10 // Comparator B Output Mode
	TCCR4C_COM4D0      = 0x4  // Comparator D Output Mode
	TCCR4C_COM4D1      = 0x8  // Comparator D Output Mode
	TCCR4C_COM4D_Msk   = 0xc  // Comparator D Output Mode
	TCCR4C_FOC4D       = 0x2  // Force Output Compare Match 4D
	TCCR4C_FOC4D_Msk   = 0x2  // Force Output Compare Match 4D
	TCCR4C_PWM4D       = 0x1  // Pulse Width Modulator D Enable
	TCCR4C_PWM4D_Msk   = 0x1  // Pulse Width Modulator D Enable

	// TCCR4D: Timer/Counter 4 Control Register D
	TCCR4D_FPIE4     = 0x80 // Fault Protection Interrupt Enable
	TCCR4D_FPIE4_Msk = 0x80 // Fault Protection Interrupt Enable
	TCCR4D_FPEN4     = 0x40 // Fault Protection Mode Enable
	TCCR4D_FPEN4_Msk = 0x40 // Fault Protection Mode Enable
	TCCR4D_FPNC4     = 0x20 // Fault Protection Noise Canceler
	TCCR4D_FPNC4_Msk = 0x20 // Fault Protection Noise Canceler
	TCCR4D_FPES4     = 0x10 // Fault Protection Edge Select
	TCCR4D_FPES4_Msk = 0x10 // Fault Protection Edge Select
	TCCR4D_FPAC4     = 0x8  // Fault Protection Analog Comparator Enable
	TCCR4D_FPAC4_Msk = 0x8  // Fault Protection Analog Comparator Enable
	TCCR4D_FPF4      = 0x4  // Fault Protection Interrupt Flag
	TCCR4D_FPF4_Msk  = 0x4  // Fault Protection Interrupt Flag
	TCCR4D_WGM40     = 0x1  // Waveform Generation Mode bits
	TCCR4D_WGM41     = 0x2  // Waveform Generation Mode bits
	TCCR4D_WGM4_Msk  = 0x3  // Waveform Generation Mode bits

	// TCCR4E: Timer/Counter 4 Control Register E
	TCCR4E_TLOCK4     = 0x80 // Register Update Lock
	TCCR4E_TLOCK4_Msk = 0x80 // Register Update Lock
	TCCR4E_ENHC4      = 0x40 // Enhanced Compare/PWM Mode
	TCCR4E_ENHC4_Msk  = 0x40 // Enhanced Compare/PWM Mode
	TCCR4E_OC4OE0     = 0x1  // Output Compare Override Enable bit
	TCCR4E_OC4OE1     = 0x2  // Output Compare Override Enable bit
	TCCR4E_OC4OE2     = 0x4  // Output Compare Override Enable bit
	TCCR4E_OC4OE3     = 0x8  // Output Compare Override Enable bit
	TCCR4E_OC4OE4     = 0x10 // Output Compare Override Enable bit
	TCCR4E_OC4OE5     = 0x20 // Output Compare Override Enable bit
	TCCR4E_OC4OE_Msk  = 0x3f // Output Compare Override Enable bit

	// TCNT4: Timer/Counter4 Low Bytes
	TCNT4_TC40    = 0x1  // Timer/Counter4 bits
	TCNT4_TC41    = 0x2  // Timer/Counter4 bits
	TCNT4_TC42    = 0x4  // Timer/Counter4 bits
	TCNT4_TC43    = 0x8  // Timer/Counter4 bits
	TCNT4_TC44    = 0x10 // Timer/Counter4 bits
	TCNT4_TC45    = 0x20 // Timer/Counter4 bits
	TCNT4_TC46    = 0x40 // Timer/Counter4 bits
	TCNT4_TC47    = 0x80 // Timer/Counter4 bits
	TCNT4_TC4_Msk = 0xff // Timer/Counter4 bits

	// TC4H: Timer/Counter4
	TC4H_TC40    = 0x1 // Timer/Counter4 bits
	TC4H_TC41    = 0x2 // Timer/Counter4 bits
	TC4H_TC42    = 0x4 // Timer/Counter4 bits
	TC4H_TC4_Msk = 0x7 // Timer/Counter4 bits

	// OCR4A: Timer/Counter4 Output Compare Register A
	OCR4A_OCR4A0    = 0x1  // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A1    = 0x2  // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A2    = 0x4  // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A3    = 0x8  // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A4    = 0x10 // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A5    = 0x20 // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A6    = 0x40 // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A7    = 0x80 // Timer/Counter4 Output Compare A bits
	OCR4A_OCR4A_Msk = 0xff // Timer/Counter4 Output Compare A bits

	// OCR4B: Timer/Counter4 Output Compare Register B
	OCR4B_OCR4B0    = 0x1  // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B1    = 0x2  // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B2    = 0x4  // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B3    = 0x8  // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B4    = 0x10 // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B5    = 0x20 // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B6    = 0x40 // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B7    = 0x80 // Timer/Counter4 Output Compare B bits
	OCR4B_OCR4B_Msk = 0xff // Timer/Counter4 Output Compare B bits

	// OCR4C: Timer/Counter4 Output Compare Register C
	OCR4C_OCR4C0    = 0x1  // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C1    = 0x2  // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C2    = 0x4  // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C3    = 0x8  // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C4    = 0x10 // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C5    = 0x20 // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C6    = 0x40 // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C7    = 0x80 // Timer/Counter4 Output Compare C bits
	OCR4C_OCR4C_Msk = 0xff // Timer/Counter4 Output Compare C bits

	// OCR4D: Timer/Counter4 Output Compare Register D
	OCR4D_OCR4D0    = 0x1  // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D1    = 0x2  // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D2    = 0x4  // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D3    = 0x8  // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D4    = 0x10 // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D5    = 0x20 // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D6    = 0x40 // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D7    = 0x80 // Timer/Counter4 Output Compare D bits
	OCR4D_OCR4D_Msk = 0xff // Timer/Counter4 Output Compare D bits

	// TIMSK4: Timer/Counter4 Interrupt Mask Register
	TIMSK4_OCIE4D     = 0x80 // Timer/Counter4 Output Compare D Match Interrupt Enable
	TIMSK4_OCIE4D_Msk = 0x80 // Timer/Counter4 Output Compare D Match Interrupt Enable
	TIMSK4_OCIE4A     = 0x40 // Timer/Counter4 Output Compare A Match Interrupt Enable
	TIMSK4_OCIE4A_Msk = 0x40 // Timer/Counter4 Output Compare A Match Interrupt Enable
	TIMSK4_OCIE4B     = 0x20 // Timer/Counter4 Output Compare B Match Interrupt Enable
	TIMSK4_OCIE4B_Msk = 0x20 // Timer/Counter4 Output Compare B Match Interrupt Enable
	TIMSK4_TOIE4      = 0x4  // Timer/Counter4 Overflow Interrupt Enable
	TIMSK4_TOIE4_Msk  = 0x4  // Timer/Counter4 Overflow Interrupt Enable

	// TIFR4: Timer/Counter4 Interrupt Flag register
	TIFR4_OCF4D     = 0x80 // Output Compare Flag 4D
	TIFR4_OCF4D_Msk = 0x80 // Output Compare Flag 4D
	TIFR4_OCF4A     = 0x40 // Output Compare Flag 4A
	TIFR4_OCF4A_Msk = 0x40 // Output Compare Flag 4A
	TIFR4_OCF4B     = 0x20 // Output Compare Flag 4B
	TIFR4_OCF4B_Msk = 0x20 // Output Compare Flag 4B
	TIFR4_TOV4      = 0x4  // Timer/Counter4 Overflow Flag
	TIFR4_TOV4_Msk  = 0x4  // Timer/Counter4 Overflow Flag

	// DT4: Timer/Counter 4 Dead Time Value
	DT4_DT4L0    = 0x1  // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L1    = 0x2  // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L2    = 0x4  // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L3    = 0x8  // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L4    = 0x10 // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L5    = 0x20 // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L6    = 0x40 // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L7    = 0x80 // Timer/Counter 4 Dead Time Value Bits
	DT4_DT4L_Msk = 0xff // Timer/Counter 4 Dead Time Value Bits
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR3A: Timer/Counter3 Control Register A
	TCCR3A_COM3A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR3A_COM3A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR3A_COM3A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR3A_COM3B0    = 0x10 // Compare Output Mode 3B, bits
	TCCR3A_COM3B1    = 0x20 // Compare Output Mode 3B, bits
	TCCR3A_COM3B_Msk = 0x30 // Compare Output Mode 3B, bits
	TCCR3A_COM3C0    = 0x4  // Compare Output Mode 3C, bits
	TCCR3A_COM3C1    = 0x8  // Compare Output Mode 3C, bits
	TCCR3A_COM3C_Msk = 0xc  // Compare Output Mode 3C, bits
	TCCR3A_WGM30     = 0x1  // Waveform Generation Mode
	TCCR3A_WGM31     = 0x2  // Waveform Generation Mode
	TCCR3A_WGM3_Msk  = 0x3  // Waveform Generation Mode

	// TCCR3B: Timer/Counter3 Control Register B
	TCCR3B_ICNC3     = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICNC3_Msk = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICES3     = 0x40 // Input Capture 3 Edge Select
	TCCR3B_ICES3_Msk = 0x40 // Input Capture 3 Edge Select
	TCCR3B_WGM30     = 0x8  // Waveform Generation Mode
	TCCR3B_WGM31     = 0x10 // Waveform Generation Mode
	TCCR3B_WGM3_Msk  = 0x18 // Waveform Generation Mode
	TCCR3B_CS30      = 0x1  // Prescaler source of Timer/Counter 3
	TCCR3B_CS31      = 0x2  // Prescaler source of Timer/Counter 3
	TCCR3B_CS32      = 0x4  // Prescaler source of Timer/Counter 3
	TCCR3B_CS3_Msk   = 0x7  // Prescaler source of Timer/Counter 3

	// TCCR3C: Timer/Counter 3 Control Register C
	TCCR3C_FOC3A     = 0x80 // Force Output Compare 3A
	TCCR3C_FOC3A_Msk = 0x80 // Force Output Compare 3A
	TCCR3C_FOC3B     = 0x40 // Force Output Compare 3B
	TCCR3C_FOC3B_Msk = 0x40 // Force Output Compare 3B
	TCCR3C_FOC3C     = 0x20 // Force Output Compare 3C
	TCCR3C_FOC3C_Msk = 0x20 // Force Output Compare 3C

	// TCNT3L: Timer/Counter3 Bytes

	// TCNT3H: Timer/Counter3 Bytes
	TCNT3_TCNT30    = 0x1    // Timer/Counter3 bits
	TCNT3_TCNT31    = 0x2    // Timer/Counter3 bits
	TCNT3_TCNT32    = 0x4    // Timer/Counter3 bits
	TCNT3_TCNT33    = 0x8    // Timer/Counter3 bits
	TCNT3_TCNT34    = 0x10   // Timer/Counter3 bits
	TCNT3_TCNT35    = 0x20   // Timer/Counter3 bits
	TCNT3_TCNT36    = 0x40   // Timer/Counter3 bits
	TCNT3_TCNT37    = 0x80   // Timer/Counter3 bits
	TCNT3_TCNT3_Msk = 0xffff // Timer/Counter3 bits

	// OCR3AL: Timer/Counter3 Output Compare Register A  Bytes

	// OCR3AH: Timer/Counter3 Output Compare Register A  Bytes
	OCR3A_OCR3A0    = 0x1    // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A1    = 0x2    // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A2    = 0x4    // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A3    = 0x8    // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A4    = 0x10   // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A5    = 0x20   // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A6    = 0x40   // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A7    = 0x80   // Timer/Counter3 Output Compare A bits
	OCR3A_OCR3A_Msk = 0xffff // Timer/Counter3 Output Compare A bits

	// OCR3BL: Timer/Counter3 Output Compare Register B Bytes

	// OCR3BH: Timer/Counter3 Output Compare Register B Bytes
	OCR3B_OCR3B0    = 0x1    // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B1    = 0x2    // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B2    = 0x4    // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B3    = 0x8    // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B4    = 0x10   // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B5    = 0x20   // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B6    = 0x40   // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B7    = 0x80   // Timer/Counter3 Output Compare B bits
	OCR3B_OCR3B_Msk = 0xffff // Timer/Counter3 Output Compare B bits

	// OCR3CL: Timer/Counter3 Output Compare Register C Bytes

	// OCR3CH: Timer/Counter3 Output Compare Register C Bytes
	OCR3C_OCR3C0    = 0x1    // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C1    = 0x2    // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C2    = 0x4    // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C3    = 0x8    // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C4    = 0x10   // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C5    = 0x20   // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C6    = 0x40   // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C7    = 0x80   // Timer/Counter3 Output Compare C bits
	OCR3C_OCR3C_Msk = 0xffff // Timer/Counter3 Output Compare C bits

	// ICR3L: Timer/Counter3 Input Capture Register  Bytes

	// ICR3H: Timer/Counter3 Input Capture Register  Bytes
	ICR3_ICR30    = 0x1    // Timer/Counter3 Input Capture bits
	ICR3_ICR31    = 0x2    // Timer/Counter3 Input Capture bits
	ICR3_ICR32    = 0x4    // Timer/Counter3 Input Capture bits
	ICR3_ICR33    = 0x8    // Timer/Counter3 Input Capture bits
	ICR3_ICR34    = 0x10   // Timer/Counter3 Input Capture bits
	ICR3_ICR35    = 0x20   // Timer/Counter3 Input Capture bits
	ICR3_ICR36    = 0x40   // Timer/Counter3 Input Capture bits
	ICR3_ICR37    = 0x80   // Timer/Counter3 Input Capture bits
	ICR3_ICR3_Msk = 0xffff // Timer/Counter3 Input Capture bits

	// TIMSK3: Timer/Counter3 Interrupt Mask Register
	TIMSK3_ICIE3      = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_ICIE3_Msk  = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_OCIE3C     = 0x8  // Timer/Counter3 Output Compare C Match Interrupt Enable
	TIMSK3_OCIE3C_Msk = 0x8  // Timer/Counter3 Output Compare C Match Interrupt Enable
	TIMSK3_OCIE3B     = 0x4  // Timer/Counter3 Output Compare B Match Interrupt Enable
	TIMSK3_OCIE3B_Msk = 0x4  // Timer/Counter3 Output Compare B Match Interrupt Enable
	TIMSK3_OCIE3A     = 0x2  // Timer/Counter3 Output Compare A Match Interrupt Enable
	TIMSK3_OCIE3A_Msk = 0x2  // Timer/Counter3 Output Compare A Match Interrupt Enable
	TIMSK3_TOIE3      = 0x1  // Timer/Counter3 Overflow Interrupt Enable
	TIMSK3_TOIE3_Msk  = 0x1  // Timer/Counter3 Overflow Interrupt Enable

	// TIFR3: Timer/Counter3 Interrupt Flag register
	TIFR3_ICF3      = 0x20 // Input Capture Flag 3
	TIFR3_ICF3_Msk  = 0x20 // Input Capture Flag 3
	TIFR3_OCF3C     = 0x8  // Output Compare Flag 3C
	TIFR3_OCF3C_Msk = 0x8  // Output Compare Flag 3C
	TIFR3_OCF3B     = 0x4  // Output Compare Flag 3B
	TIFR3_OCF3B_Msk = 0x4  // Output Compare Flag 3B
	TIFR3_OCF3A     = 0x2  // Output Compare Flag 3A
	TIFR3_OCF3A_Msk = 0x2  // Output Compare Flag 3A
	TIFR3_TOV3      = 0x1  // Timer/Counter3 Overflow Flag
	TIFR3_TOV3_Msk  = 0x1  // Timer/Counter3 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_COM1C0    = 0x4  // Compare Output Mode 1C, bits
	TCCR1A_COM1C1    = 0x8  // Compare Output Mode 1C, bits
	TCCR1A_COM1C_Msk = 0xc  // Compare Output Mode 1C, bits
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter 1 Control Register C
	TCCR1C_FOC1A     = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1A_Msk = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1B     = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1B_Msk = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1C     = 0x20 // Force Output Compare 1C
	TCCR1C_FOC1C_Msk = 0x20 // Force Output Compare 1C

	// TCNT1L: Timer/Counter1 Bytes

	// TCNT1H: Timer/Counter1 Bytes
	TCNT1_TCNT10    = 0x1    // Timer/Counter1 bits
	TCNT1_TCNT11    = 0x2    // Timer/Counter1 bits
	TCNT1_TCNT12    = 0x4    // Timer/Counter1 bits
	TCNT1_TCNT13    = 0x8    // Timer/Counter1 bits
	TCNT1_TCNT14    = 0x10   // Timer/Counter1 bits
	TCNT1_TCNT15    = 0x20   // Timer/Counter1 bits
	TCNT1_TCNT16    = 0x40   // Timer/Counter1 bits
	TCNT1_TCNT17    = 0x80   // Timer/Counter1 bits
	TCNT1_TCNT1_Msk = 0xffff // Timer/Counter1 bits

	// OCR1AL: Timer/Counter1 Output Compare Register A Bytes

	// OCR1AH: Timer/Counter1 Output Compare Register A Bytes
	OCR1A_OCR1A0    = 0x1    // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A1    = 0x2    // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A2    = 0x4    // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A3    = 0x8    // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A4    = 0x10   // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A5    = 0x20   // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A6    = 0x40   // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A7    = 0x80   // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A_Msk = 0xffff // Timer/Counter1 Output Compare A bits

	// OCR1BL: Timer/Counter1 Output Compare Register B Bytes

	// OCR1BH: Timer/Counter1 Output Compare Register B Bytes
	OCR1B_OCR1B0    = 0x1    // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B1    = 0x2    // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B2    = 0x4    // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B3    = 0x8    // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B4    = 0x10   // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B5    = 0x20   // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B6    = 0x40   // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B7    = 0x80   // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B_Msk = 0xffff // Timer/Counter1 Output Compare B bits

	// OCR1CL: Timer/Counter1 Output Compare Register C Bytes

	// OCR1CH: Timer/Counter1 Output Compare Register C Bytes
	OCR1C_OCR1C0    = 0x1    // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C1    = 0x2    // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C2    = 0x4    // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C3    = 0x8    // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C4    = 0x10   // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C5    = 0x20   // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C6    = 0x40   // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C7    = 0x80   // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C_Msk = 0xffff // Timer/Counter1 Output Compare C bits

	// ICR1L: Timer/Counter1 Input Capture Register Bytes

	// ICR1H: Timer/Counter1 Input Capture Register Bytes
	ICR1_ICR10    = 0x1    // Timer/Counter1 Input Capture bits
	ICR1_ICR11    = 0x2    // Timer/Counter1 Input Capture bits
	ICR1_ICR12    = 0x4    // Timer/Counter1 Input Capture bits
	ICR1_ICR13    = 0x8    // Timer/Counter1 Input Capture bits
	ICR1_ICR14    = 0x10   // Timer/Counter1 Input Capture bits
	ICR1_ICR15    = 0x20   // Timer/Counter1 Input Capture bits
	ICR1_ICR16    = 0x40   // Timer/Counter1 Input Capture bits
	ICR1_ICR17    = 0x80   // Timer/Counter1 Input Capture bits
	ICR1_ICR1_Msk = 0xffff // Timer/Counter1 Input Capture bits

	// TIMSK1: Timer/Counter1 Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1C     = 0x8  // Timer/Counter1 Output Compare C Match Interrupt Enable
	TIMSK1_OCIE1C_Msk = 0x8  // Timer/Counter1 Output Compare C Match Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter1 Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Input Capture Flag 1
	TIFR1_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1C     = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1C_Msk = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1B     = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1B_Msk = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A     = 0x2  // Output Compare Flag 1A
	TIFR1_OCF1A_Msk = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag
)

// Bitfields for JTAG: JTAG Interface
const (
	// MCUCR: MCU Control Register
	MCUCR_JTD       = 0x80 // JTAG Interface Disable
	MCUCR_JTD_Msk   = 0x80 // JTAG Interface Disable
	MCUCR_PUD       = 0x10 // Pull-up disable
	MCUCR_PUD_Msk   = 0x10 // Pull-up disable
	MCUCR_IVSEL     = 0x2  // Interrupt Vector Select
	MCUCR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	MCUCR_IVCE      = 0x1  // Interrupt Vector Change Enable
	MCUCR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_JTRF      = 0x10 // JTAG Reset Flag
	MCUSR_JTRF_Msk  = 0x10 // JTAG Reset Flag
	MCUSR_WDRF      = 0x8  // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8  // Watchdog Reset Flag
	MCUSR_BORF      = 0x4  // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4  // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2  // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2  // External Reset Flag
	MCUSR_PORF      = 0x1  // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1  // Power-on reset flag
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register A
	EICRA_ISC30    = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31    = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC3_Msk = 0xc0 // External Interrupt Sense Control Bit
	EICRA_ISC20    = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21    = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC2_Msk = 0x30 // External Interrupt Sense Control Bit
	EICRA_ISC10    = 0x4  // External Interrupt Sense Control Bit
	EICRA_ISC11    = 0x8  // External Interrupt Sense Control Bit
	EICRA_ISC1_Msk = 0xc  // External Interrupt Sense Control Bit
	EICRA_ISC00    = 0x1  // External Interrupt Sense Control Bit
	EICRA_ISC01    = 0x2  // External Interrupt Sense Control Bit
	EICRA_ISC0_Msk = 0x3  // External Interrupt Sense Control Bit

	// EICRB: External Interrupt Control Register B
	EICRB_ISC70    = 0x40 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC71    = 0x80 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC7_Msk = 0xc0 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC60    = 0x10 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC61    = 0x20 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC6_Msk = 0x30 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC50    = 0x4  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC51    = 0x8  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC5_Msk = 0xc  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC40    = 0x1  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC41    = 0x2  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC4_Msk = 0x3  // External Interrupt 7-4 Sense Control Bit

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1  // External Interrupt Request 7 Enable
	EIMSK_INT1    = 0x2  // External Interrupt Request 7 Enable
	EIMSK_INT2    = 0x4  // External Interrupt Request 7 Enable
	EIMSK_INT3    = 0x8  // External Interrupt Request 7 Enable
	EIMSK_INT4    = 0x10 // External Interrupt Request 7 Enable
	EIMSK_INT5    = 0x20 // External Interrupt Request 7 Enable
	EIMSK_INT6    = 0x40 // External Interrupt Request 7 Enable
	EIMSK_INT7    = 0x80 // External Interrupt Request 7 Enable
	EIMSK_INT_Msk = 0xff // External Interrupt Request 7 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1  // External Interrupt Flags
	EIFR_INTF1    = 0x2  // External Interrupt Flags
	EIFR_INTF2    = 0x4  // External Interrupt Flags
	EIFR_INTF3    = 0x8  // External Interrupt Flags
	EIFR_INTF4    = 0x10 // External Interrupt Flags
	EIFR_INTF5    = 0x20 // External Interrupt Flags
	EIFR_INTF6    = 0x40 // External Interrupt Flags
	EIFR_INTF7    = 0x80 // External Interrupt Flags
	EIFR_INTF_Msk = 0xff // External Interrupt Flags

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0    = 0x1  // Pin Change Mask 0
	PCMSK0_PCINT1    = 0x2  // Pin Change Mask 0
	PCMSK0_PCINT2    = 0x4  // Pin Change Mask 0
	PCMSK0_PCINT3    = 0x8  // Pin Change Mask 0
	PCMSK0_PCINT4    = 0x10 // Pin Change Mask 0
	PCMSK0_PCINT5    = 0x20 // Pin Change Mask 0
	PCMSK0_PCINT6    = 0x40 // Pin Change Mask 0
	PCMSK0_PCINT7    = 0x80 // Pin Change Mask 0
	PCMSK0_PCINT_Msk = 0xff // Pin Change Mask 0

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0     = 0x1 // Pin Change Interrupt Flag 0
	PCIFR_PCIF0_Msk = 0x1 // Pin Change Interrupt Flag 0

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0     = 0x1 // Pin Change Interrupt Enable 0
	PCICR_PCIE0_Msk = 0x1 // Pin Change Interrupt Enable 0
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWAMR: TWI (Slave) Address Mask Register
	TWAMR_TWAM0    = 0x2
	TWAMR_TWAM1    = 0x4
	TWAMR_TWAM2    = 0x8
	TWAMR_TWAM3    = 0x10
	TWAMR_TWAM4    = 0x20
	TWAMR_TWAM5    = 0x40
	TWAMR_TWAM6    = 0x80
	TWAMR_TWAM_Msk = 0xfe

	// TWCR: TWI Control Register
	TWCR_TWINT     = 0x80 // TWI Interrupt Flag
	TWCR_TWINT_Msk = 0x80 // TWI Interrupt Flag
	TWCR_TWEA      = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWEA_Msk  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA     = 0x20 // TWI Start Condition Bit
	TWCR_TWSTA_Msk = 0x20 // TWI Start Condition Bit
	TWCR_TWSTO     = 0x10 // TWI Stop Condition Bit
	TWCR_TWSTO_Msk = 0x10 // TWI Stop Condition Bit
	TWCR_TWWC      = 0x8  // TWI Write Collition Flag
	TWCR_TWWC_Msk  = 0x8  // TWI Write Collition Flag
	TWCR_TWEN      = 0x4  // TWI Enable Bit
	TWCR_TWEN_Msk  = 0x4  // TWI Enable Bit
	TWCR_TWIE      = 0x1  // TWI Interrupt Enable
	TWCR_TWIE_Msk  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0     = 0x8  // TWI Status
	TWSR_TWS1     = 0x10 // TWI Status
	TWSR_TWS2     = 0x20 // TWI Status
	TWSR_TWS3     = 0x40 // TWI Status
	TWSR_TWS4     = 0x80 // TWI Status
	TWSR_TWS_Msk  = 0xf8 // TWI Status
	TWSR_TWPS0    = 0x1  // TWI Prescaler
	TWSR_TWPS1    = 0x2  // TWI Prescaler
	TWSR_TWPS_Msk = 0x3  // TWI Prescaler

	// TWAR: TWI (Slave) Address register
	TWAR_TWA0      = 0x2  // TWI (Slave) Address register Bits
	TWAR_TWA1      = 0x4  // TWI (Slave) Address register Bits
	TWAR_TWA2      = 0x8  // TWI (Slave) Address register Bits
	TWAR_TWA3      = 0x10 // TWI (Slave) Address register Bits
	TWAR_TWA4      = 0x20 // TWI (Slave) Address register Bits
	TWAR_TWA5      = 0x40 // TWI (Slave) Address register Bits
	TWAR_TWA6      = 0x80 // TWI (Slave) Address register Bits
	TWAR_TWA_Msk   = 0xfe // TWI (Slave) Address register Bits
	TWAR_TWGCE     = 0x1  // TWI General Call Recognition Enable Bit
	TWAR_TWGCE_Msk = 0x1  // TWI General Call Recognition Enable Bit
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC  Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC  Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC  Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC  Prescaler Select Bits

	// ADCL: ADC Data Register  Bytes

	// ADCH: ADC Data Register  Bytes
	ADC_ADC0    = 0x1   // ADC Data Bits
	ADC_ADC1    = 0x2   // ADC Data Bits
	ADC_ADC2    = 0x4   // ADC Data Bits
	ADC_ADC3    = 0x8   // ADC Data Bits
	ADC_ADC4    = 0x10  // ADC Data Bits
	ADC_ADC5    = 0x20  // ADC Data Bits
	ADC_ADC6    = 0x40  // ADC Data Bits
	ADC_ADC7    = 0x80  // ADC Data Bits
	ADC_ADC_Msk = 0x3ff // ADC Data Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADHSM     = 0x80 // ADC High Speed Mode
	ADCSRB_ADHSM_Msk = 0x80 // ADC High Speed Mode
	ADCSRB_MUX5      = 0x20 // Analog Channel and Gain Selection Bits
	ADCSRB_MUX5_Msk  = 0x20 // Analog Channel and Gain Selection Bits
	ADCSRB_ADTS0     = 0x1  // ADC Auto Trigger Sources
	ADCSRB_ADTS1     = 0x2  // ADC Auto Trigger Sources
	ADCSRB_ADTS2     = 0x4  // ADC Auto Trigger Sources
	ADCSRB_ADTS3     = 0x8  // ADC Auto Trigger Sources
	ADCSRB_ADTS_Msk  = 0xf  // ADC Auto Trigger Sources
	ADCSRB_ACME      = 0x40 // Analog Comparator Multiplexer Enable
	ADCSRB_ACME_Msk  = 0x40 // Analog Comparator Multiplexer Enable

	// DIDR0: Digital Input Disable Register 1
	DIDR0_ADC7D     = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC7D_Msk = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC6D     = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC6D_Msk = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC5D     = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC5D_Msk = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC4D     = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC4D_Msk = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC3D     = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC3D_Msk = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC2D     = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC2D_Msk = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC1D     = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC1D_Msk = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC0D     = 0x1  // ADC0 Digital input Disable
	DIDR0_ADC0D_Msk = 0x1  // ADC0 Digital input Disable

	// DIDR2: Digital Input Disable Register 1
	DIDR2_ADC13D     = 0x20 // ADC13 Digital input Disable
	DIDR2_ADC13D_Msk = 0x20 // ADC13 Digital input Disable
	DIDR2_ADC12D     = 0x10 // ADC12 Digital input Disable
	DIDR2_ADC12D_Msk = 0x10 // ADC12 Digital input Disable
	DIDR2_ADC11D     = 0x8  // ADC11 Digital input Disable
	DIDR2_ADC11D_Msk = 0x8  // ADC11 Digital input Disable
	DIDR2_ADC10D     = 0x4  // ADC10 Digital input Disable
	DIDR2_ADC10D_Msk = 0x4  // ADC10 Digital input Disable
	DIDR2_ADC9D      = 0x2  // ADC9 Digital input Disable
	DIDR2_ADC9D_Msk  = 0x2  // ADC9 Digital input Disable
	DIDR2_ADC8D      = 0x1  // ADC8 Digital input Disable
	DIDR2_ADC8D_Msk  = 0x1  // ADC8 Digital input Disable
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC     = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits

	// DIDR1
	DIDR1_AIN1D     = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN1D_Msk = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN0D     = 0x1 // AIN0 Digital Input Disable
	DIDR1_AIN0D_Msk = 0x1 // AIN0 Digital Input Disable
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// RCCTRL: Oscillator Control Register
	RCCTRL_RCFREQ     = 0x1
	RCCTRL_RCFREQ_Msk = 0x1

	// CLKPR
	CLKPR_CLKPCE     = 0x80
	CLKPR_CLKPCE_Msk = 0x80
	CLKPR_CLKPS0     = 0x1
	CLKPR_CLKPS1     = 0x2
	CLKPR_CLKPS2     = 0x4
	CLKPR_CLKPS3     = 0x8
	CLKPR_CLKPS_Msk  = 0xf

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select bits
	SMCR_SM1    = 0x4 // Sleep Mode Select bits
	SMCR_SM2    = 0x8 // Sleep Mode Select bits
	SMCR_SM_Msk = 0xe // Sleep Mode Select bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// RAMPZ: Extended Z-pointer Register for ELPM/SPM
	RAMPZ_RAMPZ0    = 0x1 // Extended Z-Pointer Value
	RAMPZ_RAMPZ1    = 0x2 // Extended Z-Pointer Value
	RAMPZ_RAMPZ_Msk = 0x3 // Extended Z-Pointer Value

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0    = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1    = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2    = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3    = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4    = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5    = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6    = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7    = 0x80 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR_Msk = 0xff // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0    = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1    = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2    = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3    = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4    = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5    = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6    = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7    = 0x80 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR_Msk = 0xff // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07     = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR07_Msk = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06     = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR06_Msk = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05     = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR05_Msk = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04     = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR04_Msk = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03     = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR03_Msk = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02     = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR02_Msk = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01     = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR01_Msk = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00     = 0x1  // General Purpose IO Register 0 bit 0
	GPIOR0_GPIOR00_Msk = 0x1  // General Purpose IO Register 0 bit 0

	// PRR1: Power Reduction Register1
	PRR1_PRUSB        = 0x80 // Power Reduction USB
	PRR1_PRUSB_Msk    = 0x80 // Power Reduction USB
	PRR1_PRTIM3       = 0x8  // Power Reduction Timer/Counter3
	PRR1_PRTIM3_Msk   = 0x8  // Power Reduction Timer/Counter3
	PRR1_PRUSART1     = 0x1  // Power Reduction USART1
	PRR1_PRUSART1_Msk = 0x1  // Power Reduction USART1

	// PRR0: Power Reduction Register0
	PRR0_PRTWI        = 0x80 // Power Reduction TWI
	PRR0_PRTWI_Msk    = 0x80 // Power Reduction TWI
	PRR0_PRTIM2       = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM2_Msk   = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM0       = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM0_Msk   = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM1       = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRTIM1_Msk   = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRSPI        = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRSPI_Msk    = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRUSART0     = 0x2  // Power Reduction USART
	PRR0_PRUSART0_Msk = 0x2  // Power Reduction USART
	PRR0_PRADC        = 0x1  // Power Reduction ADC
	PRR0_PRADC_Msk    = 0x1  // Power Reduction ADC

	// CLKSTA
	CLKSTA_RCON      = 0x2
	CLKSTA_RCON_Msk  = 0x2
	CLKSTA_EXTON     = 0x1
	CLKSTA_EXTON_Msk = 0x1

	// CLKSEL1
	CLKSEL1_RCCKSEL0    = 0x10
	CLKSEL1_RCCKSEL1    = 0x20
	CLKSEL1_RCCKSEL2    = 0x40
	CLKSEL1_RCCKSEL3    = 0x80
	CLKSEL1_RCCKSEL_Msk = 0xf0
	CLKSEL1_EXCKSEL0    = 0x1
	CLKSEL1_EXCKSEL1    = 0x2
	CLKSEL1_EXCKSEL2    = 0x4
	CLKSEL1_EXCKSEL3    = 0x8
	CLKSEL1_EXCKSEL_Msk = 0xf

	// CLKSEL0
	CLKSEL0_RCSUT0    = 0x40
	CLKSEL0_RCSUT1    = 0x80
	CLKSEL0_RCSUT_Msk = 0xc0
	CLKSEL0_EXSUT0    = 0x10
	CLKSEL0_EXSUT1    = 0x20
	CLKSEL0_EXSUT_Msk = 0x30
	CLKSEL0_RCE       = 0x8
	CLKSEL0_RCE_Msk   = 0x8
	CLKSEL0_EXTE      = 0x4
	CLKSEL0_EXTE_Msk  = 0x4
	CLKSEL0_CLKS      = 0x1
	CLKSEL0_CLKS_Msk  = 0x1
)

// Bitfields for PLL: Phase Locked Loop
const (
	// PLLCSR: PLL Status and Control register
	PLLCSR_PINDIV     = 0x10 // PLL prescaler Bit 2
	PLLCSR_PINDIV_Msk = 0x10 // PLL prescaler Bit 2
	PLLCSR_PLLE       = 0x2  // PLL Enable Bit
	PLLCSR_PLLE_Msk   = 0x2  // PLL Enable Bit
	PLLCSR_PLOCK      = 0x1  // PLL Lock Status Bit
	PLLCSR_PLOCK_Msk  = 0x1  // PLL Lock Status Bit

	// PLLFRQ: PLL Frequency Control Register
	PLLFRQ_PINMUX     = 0x80
	PLLFRQ_PINMUX_Msk = 0x80
	PLLFRQ_PLLUSB     = 0x40
	PLLFRQ_PLLUSB_Msk = 0x40
	PLLFRQ_PLLTM0     = 0x10
	PLLFRQ_PLLTM1     = 0x20
	PLLFRQ_PLLTM_Msk  = 0x30
	PLLFRQ_PDIV0      = 0x1
	PLLFRQ_PDIV1      = 0x2
	PLLFRQ_PDIV2      = 0x4
	PLLFRQ_PDIV3      = 0x8
	PLLFRQ_PDIV_Msk   = 0xf
)

// Bitfields for USB_DEVICE: USB Device Registers
const (
	// UEINT
	UEINT_EPINT0    = 0x1  // Endpoint interrupt bits
	UEINT_EPINT1    = 0x2  // Endpoint interrupt bits
	UEINT_EPINT2    = 0x4  // Endpoint interrupt bits
	UEINT_EPINT3    = 0x8  // Endpoint interrupt bits
	UEINT_EPINT4    = 0x10 // Endpoint interrupt bits
	UEINT_EPINT5    = 0x20 // Endpoint interrupt bits
	UEINT_EPINT6    = 0x40 // Endpoint interrupt bits
	UEINT_EPINT_Msk = 0x7f // Endpoint interrupt bits

	// UEBCHX
	UEBCHX_BYCT0    = 0x1 // Byte count bits
	UEBCHX_BYCT1    = 0x2 // Byte count bits
	UEBCHX_BYCT2    = 0x4 // Byte count bits
	UEBCHX_BYCT_Msk = 0x7 // Byte count bits

	// UEBCLX
	UEBCLX_BYCT0    = 0x1  // Byte count bits
	UEBCLX_BYCT1    = 0x2  // Byte count bits
	UEBCLX_BYCT2    = 0x4  // Byte count bits
	UEBCLX_BYCT3    = 0x8  // Byte count bits
	UEBCLX_BYCT4    = 0x10 // Byte count bits
	UEBCLX_BYCT5    = 0x20 // Byte count bits
	UEBCLX_BYCT6    = 0x40 // Byte count bits
	UEBCLX_BYCT7    = 0x80 // Byte count bits
	UEBCLX_BYCT_Msk = 0xff // Byte count bits

	// UEDATX
	UEDATX_DAT0    = 0x1
	UEDATX_DAT1    = 0x2
	UEDATX_DAT2    = 0x4
	UEDATX_DAT3    = 0x8
	UEDATX_DAT4    = 0x10
	UEDATX_DAT5    = 0x20
	UEDATX_DAT6    = 0x40
	UEDATX_DAT7    = 0x80
	UEDATX_DAT_Msk = 0xff

	// UEIENX
	UEIENX_FLERRE       = 0x80
	UEIENX_FLERRE_Msk   = 0x80
	UEIENX_NAKINE       = 0x40
	UEIENX_NAKINE_Msk   = 0x40
	UEIENX_NAKOUTE      = 0x10
	UEIENX_NAKOUTE_Msk  = 0x10
	UEIENX_RXSTPE       = 0x8
	UEIENX_RXSTPE_Msk   = 0x8
	UEIENX_RXOUTE       = 0x4
	UEIENX_RXOUTE_Msk   = 0x4
	UEIENX_STALLEDE     = 0x2
	UEIENX_STALLEDE_Msk = 0x2
	UEIENX_TXINE        = 0x1
	UEIENX_TXINE_Msk    = 0x1

	// UESTA1X
	UESTA1X_CTRLDIR     = 0x4
	UESTA1X_CTRLDIR_Msk = 0x4
	UESTA1X_CURRBK0     = 0x1
	UESTA1X_CURRBK1     = 0x2
	UESTA1X_CURRBK_Msk  = 0x3

	// UESTA0X
	UESTA0X_CFGOK       = 0x80
	UESTA0X_CFGOK_Msk   = 0x80
	UESTA0X_OVERFI      = 0x40
	UESTA0X_OVERFI_Msk  = 0x40
	UESTA0X_UNDERFI     = 0x20
	UESTA0X_UNDERFI_Msk = 0x20
	UESTA0X_DTSEQ0      = 0x4
	UESTA0X_DTSEQ1      = 0x8
	UESTA0X_DTSEQ_Msk   = 0xc
	UESTA0X_NBUSYBK0    = 0x1
	UESTA0X_NBUSYBK1    = 0x2
	UESTA0X_NBUSYBK_Msk = 0x3

	// UECFG1X
	UECFG1X_EPSIZE0    = 0x10
	UECFG1X_EPSIZE1    = 0x20
	UECFG1X_EPSIZE2    = 0x40
	UECFG1X_EPSIZE_Msk = 0x70
	UECFG1X_EPBK0      = 0x4
	UECFG1X_EPBK1      = 0x8
	UECFG1X_EPBK_Msk   = 0xc
	UECFG1X_ALLOC      = 0x2
	UECFG1X_ALLOC_Msk  = 0x2

	// UECFG0X
	UECFG0X_EPTYPE0    = 0x40
	UECFG0X_EPTYPE1    = 0x80
	UECFG0X_EPTYPE_Msk = 0xc0
	UECFG0X_EPDIR      = 0x1
	UECFG0X_EPDIR_Msk  = 0x1

	// UECONX
	UECONX_STALLRQ      = 0x20
	UECONX_STALLRQ_Msk  = 0x20
	UECONX_STALLRQC     = 0x10
	UECONX_STALLRQC_Msk = 0x10
	UECONX_RSTDT        = 0x8
	UECONX_RSTDT_Msk    = 0x8
	UECONX_EPEN         = 0x1
	UECONX_EPEN_Msk     = 0x1

	// UERST
	UERST_EPRST0    = 0x1
	UERST_EPRST1    = 0x2
	UERST_EPRST2    = 0x4
	UERST_EPRST3    = 0x8
	UERST_EPRST4    = 0x10
	UERST_EPRST5    = 0x20
	UERST_EPRST6    = 0x40
	UERST_EPRST_Msk = 0x7f

	// UENUM
	UENUM_UENUM0    = 0x1
	UENUM_UENUM1    = 0x2
	UENUM_UENUM2    = 0x4
	UENUM_UENUM_Msk = 0x7

	// UEINTX
	UEINTX_FIFOCON      = 0x80
	UEINTX_FIFOCON_Msk  = 0x80
	UEINTX_NAKINI       = 0x40
	UEINTX_NAKINI_Msk   = 0x40
	UEINTX_RWAL         = 0x20
	UEINTX_RWAL_Msk     = 0x20
	UEINTX_NAKOUTI      = 0x10
	UEINTX_NAKOUTI_Msk  = 0x10
	UEINTX_RXSTPI       = 0x8
	UEINTX_RXSTPI_Msk   = 0x8
	UEINTX_RXOUTI       = 0x4
	UEINTX_RXOUTI_Msk   = 0x4
	UEINTX_STALLEDI     = 0x2
	UEINTX_STALLEDI_Msk = 0x2
	UEINTX_TXINI        = 0x1
	UEINTX_TXINI_Msk    = 0x1

	// UDMFN
	UDMFN_FNCERR     = 0x10
	UDMFN_FNCERR_Msk = 0x10

	// UDFNUML

	// UDFNUMH
	UDFNUM_FNUM0    = 0x1   // Frame number value
	UDFNUM_FNUM1    = 0x2   // Frame number value
	UDFNUM_FNUM2    = 0x4   // Frame number value
	UDFNUM_FNUM3    = 0x8   // Frame number value
	UDFNUM_FNUM4    = 0x10  // Frame number value
	UDFNUM_FNUM5    = 0x20  // Frame number value
	UDFNUM_FNUM6    = 0x40  // Frame number value
	UDFNUM_FNUM7    = 0x80  // Frame number value
	UDFNUM_FNUM_Msk = 0x7ff // Frame number value

	// UDADDR
	UDADDR_ADDEN     = 0x80
	UDADDR_ADDEN_Msk = 0x80
	UDADDR_UADD0     = 0x1
	UDADDR_UADD1     = 0x2
	UDADDR_UADD2     = 0x4
	UDADDR_UADD3     = 0x8
	UDADDR_UADD4     = 0x10
	UDADDR_UADD5     = 0x20
	UDADDR_UADD6     = 0x40
	UDADDR_UADD_Msk  = 0x7f

	// UDIEN
	UDIEN_UPRSME      = 0x40
	UDIEN_UPRSME_Msk  = 0x40
	UDIEN_EORSME      = 0x20
	UDIEN_EORSME_Msk  = 0x20
	UDIEN_WAKEUPE     = 0x10
	UDIEN_WAKEUPE_Msk = 0x10
	UDIEN_EORSTE      = 0x8
	UDIEN_EORSTE_Msk  = 0x8
	UDIEN_SOFE        = 0x4
	UDIEN_SOFE_Msk    = 0x4
	UDIEN_SUSPE       = 0x1
	UDIEN_SUSPE_Msk   = 0x1

	// UDINT
	UDINT_UPRSMI      = 0x40
	UDINT_UPRSMI_Msk  = 0x40
	UDINT_EORSMI      = 0x20
	UDINT_EORSMI_Msk  = 0x20
	UDINT_WAKEUPI     = 0x10
	UDINT_WAKEUPI_Msk = 0x10
	UDINT_EORSTI      = 0x8
	UDINT_EORSTI_Msk  = 0x8
	UDINT_SOFI        = 0x4
	UDINT_SOFI_Msk    = 0x4
	UDINT_SUSPI       = 0x1
	UDINT_SUSPI_Msk   = 0x1

	// UDCON
	UDCON_LSM        = 0x4 // USB low speed mode
	UDCON_LSM_Msk    = 0x4 // USB low speed mode
	UDCON_RSTCPU     = 0x8
	UDCON_RSTCPU_Msk = 0x8
	UDCON_RMWKUP     = 0x2
	UDCON_RMWKUP_Msk = 0x2
	UDCON_DETACH     = 0x1
	UDCON_DETACH_Msk = 0x1

	// USBCON: USB General Control Register
	USBCON_USBE        = 0x80
	USBCON_USBE_Msk    = 0x80
	USBCON_FRZCLK      = 0x20
	USBCON_FRZCLK_Msk  = 0x20
	USBCON_OTGPADE     = 0x10
	USBCON_OTGPADE_Msk = 0x10
	USBCON_VBUSTE      = 0x1
	USBCON_VBUSTE_Msk  = 0x1

	// USBINT
	USBINT_VBUSTI     = 0x1
	USBINT_VBUSTI_Msk = 0x1

	// USBSTA
	USBSTA_SPEED     = 0x8
	USBSTA_SPEED_Msk = 0x8
	USBSTA_VBUS      = 0x1
	USBSTA_VBUS_Msk  = 0x1

	// UHWCON
	UHWCON_UVREGE     = 0x1
	UHWCON_UVREGE_Msk = 0x1
)
