/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class PooledSender
extends AbstractSender
implements MultiPointSender {
    private static final Log log = LogFactory.getLog(PooledSender.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.transport");
    private final SenderQueue queue = new SenderQueue(this, this.poolSize);
    private int poolSize = 25;
    private long maxWait = 3000L;

    public abstract DataSender getNewDataSender();

    public DataSender getSender() {
        return this.queue.getSender(this.getMaxWait());
    }

    public void returnSender(DataSender dataSender) {
        dataSender.keepalive();
        this.queue.returnSender(dataSender);
    }

    @Override
    public synchronized void connect() throws IOException {
        this.queue.open();
        this.setConnected(true);
    }

    @Override
    public synchronized void disconnect() {
        this.queue.close();
        this.setConnected(false);
    }

    public int getInPoolSize() {
        return this.queue.getInPoolSize();
    }

    public int getInUsePoolSize() {
        return this.queue.getInUsePoolSize();
    }

    public void setPoolSize(int n) {
        this.poolSize = n;
        this.queue.setLimit(n);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long l) {
        this.maxWait = l;
    }

    @Override
    public boolean keepalive() {
        return this.queue == null ? false : this.queue.checkIdleKeepAlive();
    }

    @Override
    public void add(Member member) {
    }

    @Override
    public void remove(Member member) {
    }

    private static class SenderQueue {
        private int limit = 25;
        PooledSender parent = null;
        private List<DataSender> notinuse = null;
        private List<DataSender> inuse = null;
        private boolean isOpen = true;

        SenderQueue(PooledSender pooledSender, int n) {
            this.limit = n;
            this.parent = pooledSender;
            this.notinuse = new ArrayList<DataSender>();
            this.inuse = new ArrayList<DataSender>();
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int n) {
            this.limit = n;
        }

        public int getInUsePoolSize() {
            return this.inuse.size();
        }

        public int getInPoolSize() {
            return this.notinuse.size();
        }

        public synchronized boolean checkIdleKeepAlive() {
            DataSender[] dataSenderArray = this.notinuse.toArray(new DataSender[0]);
            boolean bl = false;
            for (DataSender dataSender : dataSenderArray) {
                bl |= dataSender.keepalive();
            }
            return bl;
        }

        public synchronized DataSender getSender(long l) {
            long l2 = System.currentTimeMillis();
            while (true) {
                if (!this.isOpen) {
                    throw new IllegalStateException(sm.getString("pooledSender.closed.queue"));
                }
                DataSender dataSender = null;
                if (this.notinuse.size() == 0 && this.inuse.size() < this.limit) {
                    dataSender = this.parent.getNewDataSender();
                } else if (this.notinuse.size() > 0) {
                    dataSender = this.notinuse.remove(0);
                }
                if (dataSender != null) {
                    this.inuse.add(dataSender);
                    return dataSender;
                }
                long l3 = System.currentTimeMillis() - l2;
                if (l3 > l && l > 0L) {
                    return null;
                }
                try {
                    this.wait(Math.max(l - l3, 1L));
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public synchronized void returnSender(DataSender dataSender) {
            block5: {
                if (!this.isOpen) {
                    dataSender.disconnect();
                    return;
                }
                this.inuse.remove(dataSender);
                if (this.notinuse.size() < this.getLimit()) {
                    this.notinuse.add(dataSender);
                } else {
                    try {
                        dataSender.disconnect();
                    }
                    catch (Exception exception) {
                        if (!log.isDebugEnabled()) break block5;
                        log.debug((Object)sm.getString("PooledSender.senderDisconnectFail"), (Throwable)exception);
                    }
                }
            }
            this.notifyAll();
        }

        public synchronized void close() {
            DataSender dataSender;
            this.isOpen = false;
            Object[] objectArray = this.notinuse.toArray();
            Object[] objectArray2 = this.inuse.toArray();
            for (Object object : objectArray) {
                dataSender = (DataSender)object;
                dataSender.disconnect();
            }
            for (Object object : objectArray2) {
                dataSender = (DataSender)object;
                dataSender.disconnect();
            }
            this.notinuse.clear();
            this.inuse.clear();
            this.notifyAll();
        }

        public synchronized void open() {
            this.isOpen = true;
            this.notifyAll();
        }
    }
}

