/* catalog.c generated by valac 0.56.3, the Vala compiler
 * generated from catalog.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

enum  {
	SEAHORSE_CATALOG_0_PROPERTY,
	SEAHORSE_CATALOG_UI_NAME_PROPERTY,
	SEAHORSE_CATALOG_NUM_PROPERTIES
};
static GParamSpec* seahorse_catalog_properties[SEAHORSE_CATALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SEAHORSE_CATALOG_SELECTION_CHANGED_SIGNAL,
	SEAHORSE_CATALOG_NUM_SIGNALS
};
static guint seahorse_catalog_signals[SEAHORSE_CATALOG_NUM_SIGNALS] = {0};

struct _SeahorseCatalogPrivate {
	gchar* _ui_name;
	gboolean _disposed;
	GSettings* _settings;
};

static gint SeahorseCatalog_private_offset;
static gpointer seahorse_catalog_parent_class = NULL;

static void seahorse_catalog_on_key_export_file (SeahorseCatalog* self,
                                          GSimpleAction* action,
                                          GVariant* param);
static void _seahorse_catalog_on_key_export_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void seahorse_catalog_on_key_export_clipboard (SeahorseCatalog* self,
                                               GSimpleAction* action,
                                               GVariant* param);
static void _seahorse_catalog_on_key_export_clipboard_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void seahorse_catalog_on_object_delete (SeahorseCatalog* self,
                                        GSimpleAction* action,
                                        GVariant* param);
static void _seahorse_catalog_on_object_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void seahorse_catalog_on_properties_object (SeahorseCatalog* self,
                                            GSimpleAction* action,
                                            GVariant* param);
static void _seahorse_catalog_on_properties_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static GList* seahorse_catalog_real_get_backends (SeahorseCatalog* self);
static GList* seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self);
static void seahorse_catalog_real_dispose (GObject* base);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_catalog_real_selection_changed (SeahorseCatalog* self);
static GObject * seahorse_catalog_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void seahorse_catalog_finalize (GObject * obj);
static GType seahorse_catalog_get_type_once (void);
static void _vala_seahorse_catalog_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_seahorse_catalog_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static const GActionEntry SEAHORSE_CATALOG_ACTION_ENTRIES[4] = {{"file-export", _seahorse_catalog_on_key_export_file_gsimple_action_activate_callback}, {"copy", _seahorse_catalog_on_key_export_clipboard_gsimple_action_activate_callback}, {"edit-delete", _seahorse_catalog_on_object_delete_gsimple_action_activate_callback}, {"properties-object", _seahorse_catalog_on_properties_object_gsimple_action_activate_callback}};

static inline gpointer
seahorse_catalog_get_instance_private (SeahorseCatalog* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseCatalog_private_offset);
}

static void
_seahorse_catalog_on_key_export_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	seahorse_catalog_on_key_export_file ((SeahorseCatalog*) self, action, parameter);
}

static void
_seahorse_catalog_on_key_export_clipboard_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	seahorse_catalog_on_key_export_clipboard ((SeahorseCatalog*) self, action, parameter);
}

static void
_seahorse_catalog_on_object_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	seahorse_catalog_on_object_delete ((SeahorseCatalog*) self, action, parameter);
}

static void
_seahorse_catalog_on_properties_object_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	seahorse_catalog_on_properties_object ((SeahorseCatalog*) self, action, parameter);
}

static GList*
seahorse_catalog_real_get_backends (SeahorseCatalog* self)
{
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_backends'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GList*
seahorse_catalog_get_backends (SeahorseCatalog* self)
{
	SeahorseCatalogClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SEAHORSE_CATALOG_GET_CLASS (self);
	if (_klass_->get_backends) {
		return _klass_->get_backends (self);
	}
	return NULL;
}

static GList*
seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self)
{
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_selected_objects'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GList*
seahorse_catalog_get_selected_objects (SeahorseCatalog* self)
{
	SeahorseCatalogClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SEAHORSE_CATALOG_GET_CLASS (self);
	if (_klass_->get_selected_objects) {
		return _klass_->get_selected_objects (self);
	}
	return NULL;
}

static void
seahorse_catalog_real_dispose (GObject* base)
{
	SeahorseCatalog * self;
	self = (SeahorseCatalog*) base;
	if (!self->priv->_disposed) {
		gint width = 0;
		gint height = 0;
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GSettings* _tmp2_;
		GSettings* _tmp3_;
		self->priv->_disposed = TRUE;
		gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
		width = _tmp0_;
		height = _tmp1_;
		_tmp2_ = self->priv->_settings;
		g_settings_set_int (_tmp2_, "width", width);
		_tmp3_ = self->priv->_settings;
		g_settings_set_int (_tmp3_, "height", height);
	}
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
}

void
seahorse_catalog_show_properties (SeahorseCatalog* self,
                                  GObject* obj)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	seahorse_viewable_view (obj, (GtkWindow*) self);
}

void
seahorse_catalog_show_context_menu (SeahorseCatalog* self,
                                    GdkEvent* event)
{
	GtkMenu* menu = NULL;
	GMenuModel* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	GList* _tmp3_;
	GtkMenu* _tmp12_;
	GtkMenu* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->context_menu;
	_tmp1_ = (GtkMenu*) gtk_menu_new_from_model (_tmp0_);
	g_object_ref_sink (_tmp1_);
	menu = _tmp1_;
	_tmp2_ = menu;
	gtk_widget_insert_action_group ((GtkWidget*) _tmp2_, "win", (GActionGroup*) self);
	_tmp3_ = seahorse_catalog_get_backends (self);
	{
		GList* backend_collection = NULL;
		GList* backend_it = NULL;
		backend_collection = _tmp3_;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			SeahorseBackend* backend = NULL;
			backend = (SeahorseBackend*) backend_it->data;
			{
				SeahorseActionGroup* actions = NULL;
				SeahorseBackend* _tmp4_;
				SeahorseActionGroup* _tmp5_;
				SeahorseActionGroup* _tmp6_;
				GtkMenu* _tmp7_;
				SeahorseActionGroup* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				SeahorseActionGroup* _tmp11_;
				_tmp4_ = backend;
				_tmp5_ = seahorse_backend_get_actions (_tmp4_);
				_tmp6_ = _tmp5_;
				actions = _tmp6_;
				_tmp7_ = menu;
				_tmp8_ = actions;
				_tmp9_ = seahorse_action_group_get_prefix (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = actions;
				gtk_widget_insert_action_group ((GtkWidget*) _tmp7_, _tmp10_, (GActionGroup*) _tmp11_);
				_g_object_unref0 (actions);
			}
		}
		(backend_collection == NULL) ? NULL : (backend_collection = (g_list_free (backend_collection), NULL));
	}
	_tmp12_ = menu;
	gtk_menu_popup_at_pointer (_tmp12_, event);
	_tmp13_ = menu;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_g_object_unref0 (menu);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
seahorse_catalog_on_object_delete (SeahorseCatalog* self,
                                   GSimpleAction* action,
                                   GVariant* param)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GList* objects = NULL;
		GList* _tmp0_;
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
		objects = _tmp0_;
		seahorse_deletable_delete_with_prompt_wait (objects, (GtkWindow*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
			goto __catch0_g_error;
		}
		(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Cannot delete"), _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
seahorse_catalog_on_properties_object (SeahorseCatalog* self,
                                       GSimpleAction* action,
                                       GVariant* param)
{
	GList* objects = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
	objects = _tmp0_;
	_tmp1_ = objects;
	if (g_list_length (_tmp1_) > ((guint) 0)) {
		GList* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = objects;
		_tmp3_ = _tmp2_->data;
		seahorse_catalog_show_properties (self, (GObject*) _tmp3_);
	}
	(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
}

static void
seahorse_catalog_on_key_export_file (SeahorseCatalog* self,
                                     GSimpleAction* action,
                                     GVariant* param)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GList* _tmp0_;
		GList* _tmp1_;
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
		_tmp1_ = _tmp0_;
		seahorse_exportable_export_to_prompt_wait (_tmp1_, (GtkWindow*) self, &_inner_error0_);
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (_g_list_free__g_object_unref0_ (_tmp1_), NULL));
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t export keys"), _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
seahorse_catalog_on_key_export_clipboard (SeahorseCatalog* self,
                                          GSimpleAction* action,
                                          GVariant* param)
{
	guint8* output = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	GtkClipboard* board = NULL;
	GtkClipboard* _tmp6_;
	GtkClipboard* _tmp7_;
	GtkClipboard* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GList* objects = NULL;
		GList* _tmp0_;
		GList* _tmp1_;
		guint8* _tmp2_ = NULL;
		size_t _tmp3_ = 0;
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
		objects = _tmp0_;
		_tmp1_ = objects;
		seahorse_exportable_export_to_text_wait (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
		output = (g_free (output), NULL);
		output = _tmp2_;
		output_length1 = _tmp3_;
		_output_size_ = output_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
			goto __catch0_g_error;
		}
		(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t export data"), _tmp5_);
		_g_error_free0 (err);
		output = (g_free (output), NULL);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		output = (g_free (output), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	board = _tmp7_;
	_tmp8_ = board;
	_tmp9_ = output;
	_tmp9__length1 = output_length1;
	_tmp10_ = output;
	_tmp10__length1 = output_length1;
	gtk_clipboard_set_text (_tmp8_, (const gchar*) _tmp9_, _tmp10__length1);
	_g_object_unref0 (board);
	output = (g_free (output), NULL);
}

SeahorseCatalog*
seahorse_catalog_construct (GType object_type)
{
	SeahorseCatalog * self = NULL;
	self = (SeahorseCatalog*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
seahorse_catalog_get_ui_name (SeahorseCatalog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ui_name;
	result = _tmp0_;
	return result;
}

static void
seahorse_catalog_set_ui_name (SeahorseCatalog* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_catalog_get_ui_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_ui_name);
		self->priv->_ui_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_catalog_properties[SEAHORSE_CATALOG_UI_NAME_PROPERTY]);
	}
}

static void
seahorse_catalog_real_selection_changed (SeahorseCatalog* self)
{
	gboolean can_properties = FALSE;
	gboolean can_delete = FALSE;
	gboolean can_export = FALSE;
	GList* objects = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GAction* _tmp8_;
	GAction* _tmp9_;
	GAction* _tmp10_;
	GAction* _tmp11_;
	can_properties = FALSE;
	can_delete = FALSE;
	can_export = FALSE;
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
	objects = _tmp0_;
	_tmp1_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp1_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp2_;
			GObject* object = NULL;
			_tmp2_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp2_;
			{
				GObject* _tmp3_;
				GObject* _tmp4_;
				GObject* _tmp5_;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				_tmp3_ = object;
				if (seahorse_exportable_can_export (_tmp3_)) {
					can_export = TRUE;
				}
				_tmp4_ = object;
				if (seahorse_deletable_can_delete (_tmp4_)) {
					can_delete = TRUE;
				}
				_tmp5_ = object;
				if (seahorse_viewable_can_view (_tmp5_)) {
					can_properties = TRUE;
				}
				if (can_export) {
					_tmp7_ = can_delete;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = can_properties;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_object_unref0 (object);
					break;
				}
				_g_object_unref0 (object);
			}
		}
	}
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) self, "properties-object");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_simple_action_get_type (), GSimpleAction), can_properties);
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) self, "edit-delete");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction), can_delete);
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) self, "copy");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_simple_action_get_type (), GSimpleAction), can_export);
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) self, "file-export");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_simple_action_get_type (), GSimpleAction), can_export);
	(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
}

static GObject *
seahorse_catalog_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseCatalog * self;
	gchar* key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GSettings* _tmp3_;
	gint width = 0;
	GSettings* _tmp4_;
	gint height = 0;
	GSettings* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GtkBuilder* builder = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkBuilder* _tmp10_;
	GtkBuilder* _tmp11_;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_;
	GMenuModel* _tmp14_;
	parent_class = G_OBJECT_CLASS (seahorse_catalog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	_tmp0_ = self->priv->_ui_name;
	_tmp1_ = g_strdup_printf ("/apps/seahorse/windows/%s/", _tmp0_);
	key = _tmp1_;
	_tmp2_ = key;
	_tmp3_ = g_settings_new_with_path ("org.gnome.seahorse.window", _tmp2_);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp3_;
	_tmp4_ = self->priv->_settings;
	width = g_settings_get_int (_tmp4_, "width");
	_tmp5_ = self->priv->_settings;
	height = g_settings_get_int (_tmp5_, "height");
	if (width > 0) {
		_tmp6_ = height > 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gtk_window_resize ((GtkWindow*) self, width, height);
	}
	_tmp7_ = self->priv->_ui_name;
	_tmp8_ = g_strdup_printf ("/org/gnome/Seahorse/seahorse-%s-widgets.ui", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_builder_new_from_resource (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	builder = _tmp11_;
	_tmp12_ = builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "context_menu");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (self->context_menu);
	self->context_menu = _tmp14_;
	g_action_map_add_action_entries ((GActionMap*) self, SEAHORSE_CATALOG_ACTION_ENTRIES, (gint) G_N_ELEMENTS (SEAHORSE_CATALOG_ACTION_ENTRIES), self);
	_g_object_unref0 (builder);
	_g_free0 (key);
	return obj;
}

static void
seahorse_catalog_class_init (SeahorseCatalogClass * klass,
                             gpointer klass_data)
{
	seahorse_catalog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseCatalog_private_offset);
	((SeahorseCatalogClass *) klass)->get_backends = (GList* (*) (SeahorseCatalog*)) seahorse_catalog_real_get_backends;
	((SeahorseCatalogClass *) klass)->get_selected_objects = (GList* (*) (SeahorseCatalog*)) seahorse_catalog_real_get_selected_objects;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) seahorse_catalog_real_dispose;
	((SeahorseCatalogClass *) klass)->selection_changed = seahorse_catalog_real_selection_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_catalog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_catalog_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_catalog_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_catalog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CATALOG_UI_NAME_PROPERTY, seahorse_catalog_properties[SEAHORSE_CATALOG_UI_NAME_PROPERTY] = g_param_spec_string ("ui-name", "ui-name", "ui-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	seahorse_catalog_signals[SEAHORSE_CATALOG_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", SEAHORSE_TYPE_CATALOG, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SeahorseCatalogClass, selection_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
seahorse_catalog_instance_init (SeahorseCatalog * self,
                                gpointer klass)
{
	self->priv = seahorse_catalog_get_instance_private (self);
}

static void
seahorse_catalog_finalize (GObject * obj)
{
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	_g_free0 (self->priv->_ui_name);
	_g_object_unref0 (self->context_menu);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_catalog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseCatalogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_catalog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseCatalog), 0, (GInstanceInitFunc) seahorse_catalog_instance_init, NULL };
	GType seahorse_catalog_type_id;
	seahorse_catalog_type_id = g_type_register_static (gtk_application_window_get_type (), "SeahorseCatalog", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SeahorseCatalog_private_offset = g_type_add_instance_private (seahorse_catalog_type_id, sizeof (SeahorseCatalogPrivate));
	return seahorse_catalog_type_id;
}

GType
seahorse_catalog_get_type (void)
{
	static volatile gsize seahorse_catalog_type_id__once = 0;
	if (g_once_init_enter (&seahorse_catalog_type_id__once)) {
		GType seahorse_catalog_type_id;
		seahorse_catalog_type_id = seahorse_catalog_get_type_once ();
		g_once_init_leave (&seahorse_catalog_type_id__once, seahorse_catalog_type_id);
	}
	return seahorse_catalog_type_id__once;
}

static void
_vala_seahorse_catalog_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	switch (property_id) {
		case SEAHORSE_CATALOG_UI_NAME_PROPERTY:
		g_value_set_string (value, seahorse_catalog_get_ui_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_catalog_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	switch (property_id) {
		case SEAHORSE_CATALOG_UI_NAME_PROPERTY:
		seahorse_catalog_set_ui_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

