/* import-dialog.c generated by valac 0.56.3, the Vala compiler
 * generated from import-dialog.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <ui/gcr-ui.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gcr/gcr-base.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "seahorse-common.h"

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SEAHORSE_TYPE_IMPORT_DIALOG (seahorse_import_dialog_get_type ())
#define SEAHORSE_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_IMPORT_DIALOG, SeahorseImportDialog))
#define SEAHORSE_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_IMPORT_DIALOG, SeahorseImportDialogClass))
#define SEAHORSE_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_IMPORT_DIALOG))
#define SEAHORSE_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_IMPORT_DIALOG))
#define SEAHORSE_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_IMPORT_DIALOG, SeahorseImportDialogClass))

typedef struct _SeahorseImportDialog SeahorseImportDialog;
typedef struct _SeahorseImportDialogClass SeahorseImportDialogClass;
typedef struct _SeahorseImportDialogPrivate SeahorseImportDialogPrivate;
enum  {
	SEAHORSE_IMPORT_DIALOG_0_PROPERTY,
	SEAHORSE_IMPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* seahorse_import_dialog_properties[SEAHORSE_IMPORT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SeahorseImportDialog {
	GtkDialog parent_instance;
	SeahorseImportDialogPrivate * priv;
};

struct _SeahorseImportDialogClass {
	GtkDialogClass parent_class;
};

struct _SeahorseImportDialogPrivate {
	GcrViewerWidget* viewer;
	GcrImportButton* import;
};

static gint SeahorseImportDialog_private_offset;
static gpointer seahorse_import_dialog_parent_class = NULL;

VALA_EXTERN GType seahorse_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseImportDialog, g_object_unref)
VALA_EXTERN SeahorseImportDialog* seahorse_import_dialog_new (GtkWindow* parent);
VALA_EXTERN SeahorseImportDialog* seahorse_import_dialog_construct (GType object_type,
                                                        GtkWindow* parent);
static void __lambda15_ (SeahorseImportDialog* self);
static void ___lambda15__gcr_import_button_importing (GcrImportButton* _sender,
                                               GObject* importer,
                                               gpointer self);
static void seahorse_import_dialog_on_import_button_imported (SeahorseImportDialog* self,
                                                       GObject* importer,
                                                       GError* _error_);
static void _seahorse_import_dialog_on_import_button_imported_gcr_import_button_imported (GcrImportButton* _sender,
                                                                                   GObject* importer,
                                                                                   GError* _error_,
                                                                                   gpointer self);
static void __lambda16_ (SeahorseImportDialog* self,
                  GcrViewerWidget* v,
                  GcrRenderer* r,
                  GcrParsed* parsed);
static void ___lambda16__gcr_viewer_widget_added (GcrViewerWidget* _sender,
                                           GcrRenderer* renderer,
                                           GcrParsed* parsed,
                                           gpointer self);
VALA_EXTERN void seahorse_import_dialog_add_uris (SeahorseImportDialog* self,
                                      gchar** uris,
                                      gint uris_length1);
VALA_EXTERN void seahorse_import_dialog_add_text (SeahorseImportDialog* self,
                                      const gchar* display_name,
                                      const gchar* text);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_import_dialog_finalize (GObject * obj);
static GType seahorse_import_dialog_get_type_once (void);

static inline gpointer
seahorse_import_dialog_get_instance_private (SeahorseImportDialog* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseImportDialog_private_offset);
}

static void
__lambda15_ (SeahorseImportDialog* self)
{
	GcrViewerWidget* _tmp0_;
	_tmp0_ = self->priv->viewer;
	gcr_viewer_widget_clear_error (_tmp0_);
}

static void
___lambda15__gcr_import_button_importing (GcrImportButton* _sender,
                                          GObject* importer,
                                          gpointer self)
{
	__lambda15_ ((SeahorseImportDialog*) self);
}

static void
_seahorse_import_dialog_on_import_button_imported_gcr_import_button_imported (GcrImportButton* _sender,
                                                                              GObject* importer,
                                                                              GError* _error_,
                                                                              gpointer self)
{
	seahorse_import_dialog_on_import_button_imported ((SeahorseImportDialog*) self, importer, _error_);
}

static void
__lambda16_ (SeahorseImportDialog* self,
             GcrViewerWidget* v,
             GcrRenderer* r,
             GcrParsed* parsed)
{
	const gchar* _tmp0_;
	GcrImportButton* _tmp1_;
	g_return_if_fail (v != NULL);
	g_return_if_fail (r != NULL);
	g_return_if_fail (parsed != NULL);
	_tmp0_ = gcr_parsed_get_description (parsed);
	g_debug ("import-dialog.vala:48: Parsed a '%s' with format %d", _tmp0_, (gint) gcr_parsed_get_format (parsed));
	_tmp1_ = self->priv->import;
	gcr_import_button_add_parsed (_tmp1_, parsed);
}

static void
___lambda16__gcr_viewer_widget_added (GcrViewerWidget* _sender,
                                      GcrRenderer* renderer,
                                      GcrParsed* parsed,
                                      gpointer self)
{
	__lambda16_ ((SeahorseImportDialog*) self, _sender, renderer, parsed);
}

SeahorseImportDialog*
seahorse_import_dialog_construct (GType object_type,
                                  GtkWindow* parent)
{
	SeahorseImportDialog * self = NULL;
	GtkWidget* button = NULL;
	GtkButton* _tmp0_;
	GcrImportButton* _tmp1_;
	GcrImportButton* _tmp2_;
	GcrImportButton* _tmp3_;
	GcrImportButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	GcrImportButton* _tmp6_;
	GcrImportButton* _tmp7_;
	GtkHeaderBar* _tmp8_;
	GcrImportButton* _tmp9_;
	GcrViewerWidget* _tmp10_;
	GcrViewerWidget* _tmp11_;
	GcrViewerWidget* _tmp12_;
	GtkBox* _tmp13_;
	GcrViewerWidget* _tmp14_;
	self = (SeahorseImportDialog*) g_object_new (object_type, "transient-for", parent, "title", _ ("Data to be imported"), "use-header-bar", 1, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Cancel"));
	g_object_ref_sink (_tmp0_);
	button = (GtkWidget*) _tmp0_;
	gtk_widget_show (button);
	gtk_dialog_add_action_widget ((GtkDialog*) self, button, (gint) GTK_RESPONSE_CANCEL);
	_tmp1_ = gcr_import_button_new (_ ("_Import"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->import);
	self->priv->import = _tmp1_;
	_tmp2_ = self->priv->import;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_END);
	_tmp3_ = self->priv->import;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->import;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "suggested-action");
	_tmp6_ = self->priv->import;
	g_signal_connect_object (_tmp6_, "importing", (GCallback) ___lambda15__gcr_import_button_importing, self, 0);
	_tmp7_ = self->priv->import;
	g_signal_connect_object (_tmp7_, "imported", (GCallback) _seahorse_import_dialog_on_import_button_imported_gcr_import_button_imported, self, 0);
	_tmp8_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp9_ = self->priv->import;
	gtk_header_bar_pack_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_header_bar_get_type (), GtkHeaderBar), (GtkWidget*) _tmp9_);
	_tmp10_ = gcr_viewer_widget_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->viewer);
	self->priv->viewer = _tmp10_;
	_tmp11_ = self->priv->viewer;
	g_signal_connect_object (_tmp11_, "added", (GCallback) ___lambda16__gcr_viewer_widget_added, self, 0);
	_tmp12_ = self->priv->viewer;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp14_ = self->priv->viewer;
	gtk_box_pack_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (button);
	return self;
}

SeahorseImportDialog*
seahorse_import_dialog_new (GtkWindow* parent)
{
	return seahorse_import_dialog_construct (SEAHORSE_TYPE_IMPORT_DIALOG, parent);
}

void
seahorse_import_dialog_add_uris (SeahorseImportDialog* self,
                                 gchar** uris,
                                 gint uris_length1)
{
	g_return_if_fail (self != NULL);
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = uris;
		uri_collection_length1 = uris_length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp0_;
			gchar* uri = NULL;
			_tmp0_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp0_;
			{
				GcrViewerWidget* _tmp1_;
				const gchar* _tmp2_;
				GFile* _tmp3_;
				GFile* _tmp4_;
				_tmp1_ = self->priv->viewer;
				_tmp2_ = uri;
				_tmp3_ = g_file_new_for_uri (_tmp2_);
				_tmp4_ = _tmp3_;
				gcr_viewer_widget_load_file (_tmp1_, _tmp4_);
				_g_object_unref0 (_tmp4_);
				_g_free0 (uri);
			}
		}
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
seahorse_import_dialog_add_text (SeahorseImportDialog* self,
                                 const gchar* display_name,
                                 const gchar* text)
{
	GcrViewerWidget* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->viewer;
	_tmp1_ = string_get_data (text, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	gcr_viewer_widget_load_data (_tmp0_, display_name, _tmp3_, (gsize) _tmp3__length1);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
seahorse_import_dialog_on_import_button_imported (SeahorseImportDialog* self,
                                                  GObject* importer,
                                                  GError* _error_)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (importer != NULL);
	if (_error_ == NULL) {
		gchar* uri = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GList* _tmp2_;
		gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (importer, gcr_importer_get_type (), GcrImporter), "uri", &_tmp0_, NULL);
		_tmp1_ = _tmp0_;
		uri = _tmp1_;
		_tmp2_ = seahorse_backend_get_registered ();
		{
			GList* backend_collection = NULL;
			GList* backend_it = NULL;
			backend_collection = _tmp2_;
			for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
				SeahorseBackend* _tmp3_;
				SeahorseBackend* backend = NULL;
				_tmp3_ = _g_object_ref0 ((SeahorseBackend*) backend_it->data);
				backend = _tmp3_;
				{
					SeahorsePlace* place = NULL;
					SeahorseBackend* _tmp4_;
					const gchar* _tmp5_;
					SeahorsePlace* _tmp6_;
					SeahorsePlace* _tmp7_;
					_tmp4_ = backend;
					_tmp5_ = uri;
					_tmp6_ = seahorse_backend_lookup_place (_tmp4_, _tmp5_);
					place = _tmp6_;
					_tmp7_ = place;
					if (_tmp7_ != NULL) {
						SeahorsePlace* _tmp8_;
						_tmp8_ = place;
						seahorse_place_load (_tmp8_, NULL, NULL, NULL);
					}
					_g_object_unref0 (place);
					_g_object_unref0 (backend);
				}
			}
			(backend_collection == NULL) ? NULL : (backend_collection = (_g_list_free__g_object_unref0_ (backend_collection), NULL));
		}
		_g_free0 (uri);
	} else {
		if (!g_error_matches (_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GcrViewerWidget* _tmp9_;
			_tmp9_ = self->priv->viewer;
			gcr_viewer_widget_show_error (_tmp9_, _ ("Import failed"), _error_);
		}
	}
}

static void
seahorse_import_dialog_class_init (SeahorseImportDialogClass * klass,
                                   gpointer klass_data)
{
	seahorse_import_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseImportDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = seahorse_import_dialog_finalize;
}

static void
seahorse_import_dialog_instance_init (SeahorseImportDialog * self,
                                      gpointer klass)
{
	self->priv = seahorse_import_dialog_get_instance_private (self);
}

static void
seahorse_import_dialog_finalize (GObject * obj)
{
	SeahorseImportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_IMPORT_DIALOG, SeahorseImportDialog);
	_g_object_unref0 (self->priv->viewer);
	_g_object_unref0 (self->priv->import);
	G_OBJECT_CLASS (seahorse_import_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_import_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseImportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_import_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseImportDialog), 0, (GInstanceInitFunc) seahorse_import_dialog_instance_init, NULL };
	GType seahorse_import_dialog_type_id;
	seahorse_import_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseImportDialog", &g_define_type_info, 0);
	SeahorseImportDialog_private_offset = g_type_add_instance_private (seahorse_import_dialog_type_id, sizeof (SeahorseImportDialogPrivate));
	return seahorse_import_dialog_type_id;
}

GType
seahorse_import_dialog_get_type (void)
{
	static volatile gsize seahorse_import_dialog_type_id__once = 0;
	if (g_once_init_enter (&seahorse_import_dialog_type_id__once)) {
		GType seahorse_import_dialog_type_id;
		seahorse_import_dialog_type_id = seahorse_import_dialog_get_type_once ();
		g_once_init_leave (&seahorse_import_dialog_type_id__once, seahorse_import_dialog_type_id);
	}
	return seahorse_import_dialog_type_id__once;
}

