/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.WebResource;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.servlets.WebdavStatus;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.util.XMLWriter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.ConcurrentDateFormat;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final URLEncoder URL_ENCODER_XML = (URLEncoder)URLEncoder.DEFAULT.clone();
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final ConcurrentDateFormat creationDateFormat;
    private final Map<String, LockInfo> resourceLocks = new ConcurrentHashMap<String, LockInfo>();
    private final Map<String, List<String>> lockNullResources = new ConcurrentHashMap<String, List<String>>();
    private final List<LockInfo> collectionLocks = Collections.synchronizedList(new ArrayList());
    private String secret = "catalina";
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("secret") != null) {
            this.secret = this.getServletConfig().getInitParameter("secret");
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    @Override
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        if (httpServletRequest.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isSpecialPath(string)) {
            httpServletResponse.sendError(404);
            return;
        }
        String string2 = httpServletRequest.getMethod();
        if (this.debug > 0) {
            this.log("[" + string2 + "] " + string);
        }
        if (string2.equals(METHOD_PROPFIND)) {
            this.doPropfind(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_PROPPATCH)) {
            this.doProppatch(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MKCOL)) {
            this.doMkcol(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_COPY)) {
            this.doCopy(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MOVE)) {
            this.doMove(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_LOCK)) {
            this.doLock(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_UNLOCK)) {
            this.doUnlock(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    private boolean isSpecialPath(String string) {
        return !this.allowSpecialPaths && (string.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || string.toUpperCase(Locale.ENGLISH).startsWith("/META-INF"));
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        return super.checkIfHeaders(httpServletRequest, httpServletResponse, webResource);
    }

    @Override
    protected String rewriteUrl(String string) {
        return URL_ENCODER_XML.encode(string, StandardCharsets.UTF_8);
    }

    @Override
    protected String getRelativePath(HttpServletRequest httpServletRequest) {
        return this.getRelativePath(httpServletRequest, false);
    }

    @Override
    protected String getRelativePath(HttpServletRequest httpServletRequest, boolean bl) {
        String string = httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null ? (String)httpServletRequest.getAttribute("javax.servlet.include.path_info") : httpServletRequest.getPathInfo();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getPathPrefix(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getContextPath();
        if (httpServletRequest.getServletPath() != null) {
            string = string + httpServletRequest.getServletPath();
        }
        return string;
    }

    @Override
    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.addHeader("DAV", "1,2");
        httpServletResponse.addHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
        httpServletResponse.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n;
        SequencedCollection<String> sequencedCollection;
        SequencedCollection<String> sequencedCollection2;
        Object object2;
        Object object3;
        if (!this.listings) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (string.length() > 1 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        ArrayList<String> arrayList = null;
        int n2 = this.maxDepth;
        int n3 = 1;
        String string2 = httpServletRequest.getHeader("Depth");
        if (string2 == null) {
            n2 = this.maxDepth;
        } else if (string2.equals("0")) {
            n2 = 0;
        } else if (string2.equals("1")) {
            n2 = 1;
        } else if (string2.equals("infinity")) {
            n2 = this.maxDepth;
        }
        Node node = null;
        if (httpServletRequest.getContentLengthLong() > 0L) {
            object3 = this.getDocumentBuilder();
            try {
                object2 = ((DocumentBuilder)object3).parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
                sequencedCollection2 = object2.getDocumentElement();
                sequencedCollection = sequencedCollection2.getChildNodes();
                block10: for (int i = 0; i < sequencedCollection.getLength(); ++i) {
                    Node object5 = sequencedCollection.item(i);
                    switch (object5.getNodeType()) {
                        case 3: {
                            continue block10;
                        }
                        case 1: {
                            if (object5.getNodeName().endsWith("prop")) {
                                n3 = 0;
                                node = object5;
                            }
                            if (object5.getNodeName().endsWith("propname")) {
                                n3 = 2;
                            }
                            if (!object5.getNodeName().endsWith("allprop")) continue block10;
                            n3 = 1;
                        }
                    }
                }
            }
            catch (IOException | SAXException exception) {
                httpServletResponse.sendError(400);
                return;
            }
        }
        if (n3 == 0) {
            arrayList = new ArrayList<String>();
            object3 = node.getChildNodes();
            block11: for (int i = 0; i < object3.getLength(); ++i) {
                sequencedCollection2 = object3.item(i);
                switch (sequencedCollection2.getNodeType()) {
                    case 3: {
                        continue block11;
                    }
                    case 1: {
                        sequencedCollection = sequencedCollection2.getNodeName();
                        Object object4 = null;
                        object4 = ((String)((Object)sequencedCollection)).indexOf(58) != -1 ? ((String)((Object)sequencedCollection)).substring(((String)((Object)sequencedCollection)).indexOf(58) + 1) : sequencedCollection;
                        arrayList.add((String)object4);
                    }
                }
            }
        }
        if (!(object3 = this.resources.getResource(string)).exists() && (n = string.lastIndexOf(47)) != -1 && (sequencedCollection = this.lockNullResources.get(sequencedCollection2 = string.substring(0, n))) != null) {
            for (String string3 : sequencedCollection) {
                if (!string3.equals(string)) continue;
                httpServletResponse.setStatus(207);
                httpServletResponse.setContentType("text/xml; charset=UTF-8");
                XMLWriter xMLWriter = new XMLWriter(httpServletResponse.getWriter());
                xMLWriter.writeXMLHeader();
                xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                this.parseLockNullProperties(httpServletRequest, xMLWriter, string3, n3, arrayList);
                xMLWriter.writeElement("D", "multistatus", 1);
                xMLWriter.sendData();
                return;
            }
        }
        if (!object3.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(207);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object2 = new XMLWriter(httpServletResponse.getWriter());
        ((XMLWriter)object2).writeXMLHeader();
        ((XMLWriter)object2).writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (n2 == 0) {
            this.parseProperties(httpServletRequest, (XMLWriter)object2, string, n3, arrayList);
        } else {
            sequencedCollection2 = new ArrayDeque<String>();
            sequencedCollection2.addFirst(string);
            sequencedCollection = new ArrayDeque();
            while (!sequencedCollection2.isEmpty() && n2 >= 0) {
                String string3 = (String)sequencedCollection2.remove();
                this.parseProperties(httpServletRequest, (XMLWriter)object2, string3, n3, arrayList);
                object3 = this.resources.getResource(string3);
                if (object3.isDirectory() && n2 > 0) {
                    List<String> list;
                    String[] stringArray = this.resources.list(string3);
                    for (String string4 : stringArray) {
                        String string5 = string3;
                        if (!string5.endsWith("/")) {
                            string5 = string5 + "/";
                        }
                        string5 = string5 + string4;
                        sequencedCollection.addFirst(string5);
                    }
                    Object object = string3;
                    if (((String)object).endsWith("/")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    if ((list = this.lockNullResources.get(object)) != null) {
                        for (String string4 : list) {
                            this.parseLockNullProperties(httpServletRequest, (XMLWriter)object2, string4, n3, arrayList);
                        }
                    }
                }
                if (sequencedCollection2.isEmpty()) {
                    --n2;
                    sequencedCollection2 = sequencedCollection;
                    sequencedCollection = new ArrayDeque();
                }
                ((XMLWriter)object2).sendData();
            }
        }
        ((XMLWriter)object2).writeElement("D", "multistatus", 1);
        ((XMLWriter)object2).sendData();
    }

    protected void doProppatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        httpServletResponse.sendError(501);
    }

    protected void doMkcol(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (webResource.exists()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        if (httpServletRequest.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
                httpServletResponse.sendError(501);
                return;
            }
            catch (SAXException sAXException) {
                httpServletResponse.sendError(415);
                return;
            }
        }
        if (this.resources.mkdir(string)) {
            httpServletResponse.setStatus(201);
            this.lockNullResources.remove(string);
        } else {
            httpServletResponse.sendError(409, WebdavStatus.getStatusText(409));
        }
    }

    @Override
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        this.deleteResource(httpServletRequest, httpServletResponse);
    }

    @Override
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (webResource.isDirectory()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        super.doPut(httpServletRequest, httpServletResponse);
        this.lockNullResources.remove(string);
    }

    protected void doCopy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        this.copyResource(httpServletRequest, httpServletResponse);
    }

    protected void doMove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (this.copyResource(httpServletRequest, httpServletResponse)) {
            this.deleteResource(string, httpServletRequest, httpServletResponse, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doLock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Serializable serializable;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        Serializable object7 = new LockInfo(this.maxDepth);
        String string = httpServletRequest.getHeader("Depth");
        ((LockInfo)object7).depth = string == null ? this.maxDepth : (string.equals("0") ? 0 : this.maxDepth);
        int n2 = 3600;
        String string2 = httpServletRequest.getHeader("Timeout");
        if (string2 == null) {
            n2 = 3600;
        } else {
            n = string2.indexOf(44);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if (string2.startsWith("Second-")) {
                n2 = Integer.parseInt(string2.substring(7));
            } else if (string2.equalsIgnoreCase("infinity")) {
                n2 = 604800;
            } else {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 604800;
                }
            }
            if (n2 == 0) {
                n2 = 3600;
            }
            if (n2 > 604800) {
                n2 = 604800;
            }
        }
        ((LockInfo)object7).expiresAt = System.currentTimeMillis() + (long)(n2 * 1000);
        n = 0;
        Node node = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            object6 = documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
            object5 = object6.getDocumentElement();
            node = object5;
        }
        catch (IOException | SAXException exception) {
            n = 1;
        }
        if (node != null) {
            void bl;
            String string3;
            int n3;
            object6 = node.getChildNodes();
            object5 = null;
            object4 = null;
            object3 = null;
            serializable = null;
            Object object22 = null;
            block20: for (n3 = 0; n3 < object6.getLength(); ++n3) {
                Node node2 = object6.item(n3);
                switch (node2.getNodeType()) {
                    case 3: {
                        continue block20;
                    }
                    case 1: {
                        string3 = node2.getNodeName();
                        if (string3.endsWith("lockscope")) {
                            object3 = node2;
                        }
                        if (string3.endsWith("locktype")) {
                            serializable = node2;
                        }
                        if (!string3.endsWith("owner")) continue block20;
                        Node n4 = node2;
                    }
                }
            }
            if (object3 != null) {
                object6 = object3.getChildNodes();
                block21: for (n3 = 0; n3 < object6.getLength(); ++n3) {
                    Node node3 = object6.item(n3);
                    switch (node3.getNodeType()) {
                        case 3: {
                            continue block21;
                        }
                        case 1: {
                            string3 = node3.getNodeName();
                            ((LockInfo)object7).scope = string3.indexOf(58) != -1 ? string3.substring(string3.indexOf(58) + 1) : string3;
                        }
                    }
                }
                if (((LockInfo)object7).scope == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (serializable != null) {
                object6 = serializable.getChildNodes();
                block22: for (n3 = 0; n3 < object6.getLength(); ++n3) {
                    Node node4 = object6.item(n3);
                    switch (node4.getNodeType()) {
                        case 3: {
                            continue block22;
                        }
                        case 1: {
                            string3 = node4.getNodeName();
                            ((LockInfo)object7).type = string3.indexOf(58) != -1 ? string3.substring(string3.indexOf(58) + 1) : string3;
                        }
                    }
                }
                if (((LockInfo)object7).type == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (bl != null) {
                object6 = bl.getChildNodes();
                block23: for (n3 = 0; n3 < object6.getLength(); ++n3) {
                    Node node5 = object6.item(n3);
                    switch (node5.getNodeType()) {
                        case 3: {
                            ((LockInfo)object7).owner = ((LockInfo)object7).owner + node5.getNodeValue();
                            continue block23;
                        }
                        case 1: {
                            object5 = new StringWriter();
                            object4 = new DOMWriter((Writer)object5);
                            ((DOMWriter)object4).print(node5);
                            ((LockInfo)object7).owner = ((LockInfo)object7).owner + ((StringWriter)object5).toString();
                        }
                    }
                }
                if (((LockInfo)object7).owner == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                ((LockInfo)object7).owner = "";
            }
        }
        ((LockInfo)object7).path = object6 = this.getRelativePath(httpServletRequest);
        object5 = this.resources.getResource((String)object6);
        if (n == 0) {
            object4 = httpServletRequest.getServletPath() + "-" + ((LockInfo)object7).type + "-" + ((LockInfo)object7).scope + "-" + httpServletRequest.getUserPrincipal() + "-" + ((LockInfo)object7).depth + "-" + ((LockInfo)object7).owner + "-" + ((LockInfo)object7).tokens + "-" + ((LockInfo)object7).expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            object3 = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{((String)object4).getBytes(StandardCharsets.ISO_8859_1)}));
            if (object5.isDirectory() && ((LockInfo)object7).depth == this.maxDepth) {
                boolean bl;
                serializable = new ArrayList<String>();
                for (LockInfo lockInfo : this.collectionLocks) {
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(lockInfo.path);
                        continue;
                    }
                    if (!lockInfo.path.startsWith(((LockInfo)object7).path) || !lockInfo.isExclusive() && !((LockInfo)object7).isExclusive()) continue;
                    serializable.add(lockInfo.path);
                }
                for (LockInfo lockInfo : this.resourceLocks.values()) {
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(lockInfo.path);
                        continue;
                    }
                    if (!lockInfo.path.startsWith(((LockInfo)object7).path) || !lockInfo.isExclusive() && !((LockInfo)object7).isExclusive()) continue;
                    serializable.add(lockInfo.path);
                }
                if (!serializable.isEmpty()) {
                    httpServletResponse.setStatus(409);
                    XMLWriter xMLWriter = new XMLWriter();
                    xMLWriter.writeXMLHeader();
                    xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    for (String string4 : serializable) {
                        xMLWriter.writeElement("D", "response", 0);
                        xMLWriter.writeElement("D", "href", 0);
                        xMLWriter.writeText(string4);
                        xMLWriter.writeElement("D", "href", 1);
                        xMLWriter.writeElement("D", "status", 0);
                        xMLWriter.writeText("HTTP/1.1 423 " + WebdavStatus.getStatusText(423));
                        xMLWriter.writeElement("D", "status", 1);
                        xMLWriter.writeElement("D", "response", 1);
                    }
                    xMLWriter.writeElement("D", "multistatus", 1);
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    ((Writer)printWriter).write(xMLWriter.toString());
                    ((Writer)printWriter).close();
                    return;
                }
                boolean bl2 = true;
                for (LockInfo lockInfo : this.collectionLocks) {
                    if (!lockInfo.path.equals(((LockInfo)object7).path)) continue;
                    if (lockInfo.isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    if (((LockInfo)object7).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    lockInfo.tokens.add((String)object3);
                    object7 = lockInfo;
                    bl = false;
                }
                if (bl) {
                    ((LockInfo)object7).tokens.add((String)object3);
                    this.collectionLocks.add((LockInfo)object7);
                }
            } else {
                serializable = this.resourceLocks.get(((LockInfo)object7).path);
                if (serializable != null) {
                    if (((LockInfo)serializable).isExclusive() || ((LockInfo)object7).isExclusive()) {
                        httpServletResponse.sendError(412);
                        return;
                    }
                    ((LockInfo)serializable).tokens.add((String)object3);
                    object7 = serializable;
                } else {
                    ((LockInfo)object7).tokens.add((String)object3);
                    this.resourceLocks.put(((LockInfo)object7).path, (LockInfo)object7);
                    if (!object5.exists()) {
                        void var17_50;
                        int n4 = ((LockInfo)object7).path.lastIndexOf(47);
                        String string5 = ((LockInfo)object7).path.substring(0, n4);
                        List<String> list = this.lockNullResources.get(string5);
                        if (list == null) {
                            ArrayList arrayList = new ArrayList();
                            this.lockNullResources.put(string5, arrayList);
                        }
                        var17_50.add(((LockInfo)object7).path);
                    }
                    httpServletResponse.addHeader("Lock-Token", "<opaquelocktoken:" + (String)object3 + ">");
                }
            }
        }
        if (n == 1) {
            object4 = httpServletRequest.getHeader("If");
            if (object4 == null) {
                object4 = "";
            }
            if ((object3 = this.resourceLocks.get(object6)) != null) {
                for (String string6 : ((LockInfo)object3).tokens) {
                    if (!((String)object4).contains(string6)) continue;
                    ((LockInfo)object3).expiresAt = ((LockInfo)object7).expiresAt;
                    object7 = object3;
                }
            }
            for (LockInfo lockInfo : this.collectionLocks) {
                if (!((String)object6).equals(lockInfo.path)) continue;
                for (String string7 : lockInfo.tokens) {
                    if (!((String)object4).contains(string7)) continue;
                    lockInfo.expiresAt = ((LockInfo)object7).expiresAt;
                    object7 = lockInfo;
                }
            }
        }
        object4 = new XMLWriter();
        ((XMLWriter)object4).writeXMLHeader();
        ((XMLWriter)object4).writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        ((XMLWriter)object4).writeElement("D", "lockdiscovery", 0);
        ((LockInfo)object7).toXML((XMLWriter)object4);
        ((XMLWriter)object4).writeElement("D", "lockdiscovery", 1);
        ((XMLWriter)object4).writeElement("D", "prop", 1);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object3 = httpServletResponse.getWriter();
        ((Writer)object3).write(((XMLWriter)object4).toString());
        ((Writer)object3).close();
    }

    protected void doUnlock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        Iterator<Object> iterator;
        LockInfo lockInfo;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        String string2 = httpServletRequest.getHeader("Lock-Token");
        if (string2 == null) {
            string2 = "";
        }
        if ((lockInfo = this.resourceLocks.get(string)) != null) {
            iterator = lockInfo.tokens.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!string2.contains((CharSequence)object)) continue;
                iterator.remove();
            }
            if (lockInfo.tokens.isEmpty()) {
                this.resourceLocks.remove(string);
                this.lockNullResources.remove(string);
            }
        }
        iterator = this.collectionLocks.iterator();
        while (iterator.hasNext()) {
            lockInfo = (LockInfo)iterator.next();
            if (!string.equals(lockInfo.path)) continue;
            object = lockInfo.tokens.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                if (!string2.contains(string3)) continue;
                object.remove();
                break;
            }
            if (!lockInfo.tokens.isEmpty()) continue;
            iterator.remove();
            this.lockNullResources.remove(string);
        }
        httpServletResponse.setStatus(204);
    }

    private boolean isLocked(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = this.getRelativePath(httpServletRequest);
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string = httpServletRequest.getHeader("Lock-Token")) == null) {
            string = "";
        }
        return this.isLocked(string2, string3 + string);
    }

    private boolean isLocked(String string, String string2) {
        LockInfo lockInfo = this.resourceLocks.get(string);
        if (lockInfo != null && lockInfo.hasExpired()) {
            this.resourceLocks.remove(string);
        } else if (lockInfo != null) {
            boolean bl = false;
            for (String object : lockInfo.tokens) {
                if (!string2.contains(object)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return true;
            }
        }
        Iterator<LockInfo> iterator = this.collectionLocks.iterator();
        while (iterator.hasNext()) {
            lockInfo = iterator.next();
            if (lockInfo.hasExpired()) {
                iterator.remove();
                continue;
            }
            if (!string.startsWith(lockInfo.path)) continue;
            boolean bl = false;
            for (String string3 : lockInfo.tokens) {
                if (!string2.contains(string3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        HashMap<String, Integer> hashMap;
        boolean bl;
        String string;
        URI uRI;
        String string2 = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string2);
        if (!webResource.exists()) {
            httpServletResponse.sendError(404);
            return false;
        }
        String string3 = httpServletRequest.getHeader("Destination");
        if (string3 == null || string3.isEmpty()) {
            httpServletResponse.sendError(400);
            return false;
        }
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            httpServletResponse.sendError(400);
            return false;
        }
        String string4 = uRI.getPath();
        if (!string4.equals(RequestUtil.normalize((String)string4))) {
            httpServletResponse.sendError(400);
            return false;
        }
        if (uRI.isAbsolute()) {
            if (!httpServletRequest.getScheme().equals(uRI.getScheme()) || !httpServletRequest.getServerName().equals(uRI.getHost())) {
                httpServletResponse.sendError(403);
                return false;
            }
            if (!(httpServletRequest.getServerPort() == uRI.getPort() || uRI.getPort() == -1 && ("http".equals(httpServletRequest.getScheme()) && httpServletRequest.getServerPort() == 80 || "https".equals(httpServletRequest.getScheme()) && httpServletRequest.getServerPort() == 443))) {
                httpServletResponse.sendError(403);
                return false;
            }
        }
        if (!string4.startsWith((string = httpServletRequest.getContextPath()) + "/")) {
            httpServletResponse.sendError(403);
            return false;
        }
        string4 = string4.substring(string.length() + httpServletRequest.getServletPath().length());
        if (this.debug > 0) {
            this.log("Dest path :" + string4);
        }
        if (this.isSpecialPath(string4)) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string4.equals(string2)) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string4.startsWith(string2) && string4.charAt(string2.length()) == '/' || string2.startsWith(string4) && string2.charAt(string4.length()) == '/') {
            httpServletResponse.sendError(403);
            return false;
        }
        boolean bl2 = true;
        String string5 = httpServletRequest.getHeader("Overwrite");
        if (string5 != null) {
            bl2 = string5.equalsIgnoreCase("T");
        }
        WebResource webResource2 = this.resources.getResource(string4);
        if (bl2) {
            if (webResource2.exists()) {
                if (!this.deleteResource(string4, httpServletRequest, httpServletResponse, true)) {
                    return false;
                }
            } else {
                httpServletResponse.setStatus(201);
            }
        } else if (webResource2.exists()) {
            httpServletResponse.sendError(412);
            return false;
        }
        if (!(bl = this.copyResource(hashMap = new HashMap<String, Integer>(), string2, string4)) || !hashMap.isEmpty()) {
            if (hashMap.size() == 1) {
                httpServletResponse.sendError(((Integer)hashMap.values().iterator().next()).intValue());
            } else {
                this.sendReport(httpServletRequest, httpServletResponse, hashMap);
            }
            return false;
        }
        if (webResource2.exists()) {
            httpServletResponse.setStatus(204);
        } else {
            httpServletResponse.setStatus(201);
        }
        this.lockNullResources.remove(string4);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(Map<String, Integer> map, String string, String string2) {
        Object object;
        WebResource webResource;
        int n;
        WebResource webResource2;
        if (this.debug > 1) {
            this.log("Copy: " + string + " To: " + string2);
        }
        if ((webResource2 = this.resources.getResource(string)).isDirectory()) {
            String[] stringArray;
            if (!this.resources.mkdir(string2) && !(stringArray = this.resources.getResource(string2)).isDirectory()) {
                map.put(string2, 409);
                return false;
            }
            String[] stringArray2 = stringArray = this.resources.list(string);
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                String string4 = string2;
                if (!string4.equals("/")) {
                    string4 = string4 + "/";
                }
                string4 = string4 + string3;
                String string5 = string;
                if (!string5.equals("/")) {
                    string5 = string5 + "/";
                }
                string5 = string5 + string3;
                this.copyResource(map, string5, string4);
                ++n3;
            }
            return true;
        }
        if (!webResource2.isFile()) {
            map.put(string, 500);
            return false;
        }
        WebResource webResource3 = this.resources.getResource(string2);
        if (!(webResource3.exists() || webResource3.getWebappPath().endsWith("/") || (n = webResource3.getWebappPath().lastIndexOf(47)) <= 0 || (webResource = this.resources.getResource((String)(object = webResource3.getWebappPath().substring(0, n)))).isDirectory())) {
            map.put(string, 409);
            return false;
        }
        if (!webResource3.exists() && string2.endsWith("/") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        try {
            InputStream inputStream = webResource2.getInputStream();
            object = null;
            try {
                if (this.resources.write(string2, inputStream, false)) return true;
                map.put(string, 500);
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.log(sm.getString("webdavservlet.inputstreamclosefail", new Object[]{string}), iOException);
            return true;
        }
    }

    private boolean deleteResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = this.getRelativePath(httpServletRequest);
        return this.deleteResource(string, httpServletRequest, httpServletResponse, true);
    }

    private boolean deleteResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        String string2;
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        if (this.isLocked(string, string3 + string2)) {
            httpServletResponse.sendError(423);
            return false;
        }
        WebResource webResource = this.resources.getResource(string);
        if (!webResource.exists()) {
            httpServletResponse.sendError(404);
            return false;
        }
        if (!webResource.isDirectory()) {
            if (!webResource.delete()) {
                httpServletResponse.sendError(500);
                return false;
            }
        } else {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            this.deleteCollection(httpServletRequest, string, hashMap);
            if (!webResource.delete()) {
                hashMap.put(string, 500);
            }
            if (!hashMap.isEmpty()) {
                this.sendReport(httpServletRequest, httpServletResponse, hashMap);
                return false;
            }
        }
        if (bl) {
            httpServletResponse.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest httpServletRequest, String string, Map<String, Integer> map) {
        String[] stringArray;
        String string2;
        if (this.debug > 1) {
            this.log("Delete:" + string);
        }
        if (this.isSpecialPath(string)) {
            map.put(string, 403);
            return;
        }
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        for (String string4 : stringArray = this.resources.list(string)) {
            String string5 = string;
            if (!string5.equals("/")) {
                string5 = string5 + "/";
            }
            if (this.isLocked(string5 = string5 + string4, string3 + string2)) {
                map.put(string5, 423);
                continue;
            }
            WebResource webResource = this.resources.getResource(string5);
            if (webResource.isDirectory()) {
                this.deleteCollection(httpServletRequest, string5, map);
            }
            if (webResource.delete() || webResource.isDirectory()) continue;
            map.put(string5, 500);
        }
    }

    private void sendReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Integer> map) throws IOException {
        httpServletResponse.setStatus(207);
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey();
            int n = entry.getValue();
            xMLWriter.writeElement("D", "response", 0);
            xMLWriter.writeElement("D", "href", 0);
            xMLWriter.writeText(this.getServletContext().getContextPath() + string);
            xMLWriter.writeElement("D", "href", 1);
            xMLWriter.writeElement("D", "status", 0);
            xMLWriter.writeText("HTTP/1.1 " + n + " " + WebdavStatus.getStatusText(n));
            xMLWriter.writeElement("D", "status", 1);
            xMLWriter.writeElement("D", "response", 1);
        }
        xMLWriter.writeElement("D", "multistatus", 1);
        PrintWriter printWriter = httpServletResponse.getWriter();
        ((Writer)printWriter).write(xMLWriter.toString());
        ((Writer)printWriter).close();
    }

    private void parseProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, List<String> list) {
        if (this.isSpecialPath(string)) {
            return;
        }
        WebResource webResource = this.resources.getResource(string);
        if (!webResource.exists()) {
            return;
        }
        String string2 = httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
        string2 = string2.endsWith("/") && string.startsWith("/") ? string2 + string.substring(1) : string2 + string;
        if (webResource.isDirectory() && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        String string3 = this.rewriteUrl(string2);
        this.generatePropFindResponse(xMLWriter, string3, string, n, list, webResource.isFile(), false, webResource.getCreation(), webResource.getLastModified(), webResource.getContentLength(), this.getServletContext().getMimeType(webResource.getName()), this.generateETag(webResource));
    }

    private void parseLockNullProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, List<String> list) {
        if (this.isSpecialPath(string)) {
            return;
        }
        LockInfo lockInfo = this.resourceLocks.get(string);
        if (lockInfo == null) {
            return;
        }
        String string2 = httpServletRequest.getRequestURI();
        String string3 = this.getRelativePath(httpServletRequest);
        String string4 = string.substring(string3.length());
        if (!string4.startsWith("/")) {
            string4 = "/" + string4;
        }
        String string5 = this.rewriteUrl(RequestUtil.normalize((String)(string2 + string4)));
        this.generatePropFindResponse(xMLWriter, string5, string, n, list, true, true, lockInfo.creationDate.getTime(), lockInfo.creationDate.getTime(), 0L, "", "");
    }

    private void generatePropFindResponse(XMLWriter xMLWriter, String string, String string2, int n, List<String> list, boolean bl, boolean bl2, long l, long l2, long l3, String string3, String string4) {
        xMLWriter.writeElement("D", "response", 0);
        String string5 = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        xMLWriter.writeElement("D", "href", 0);
        xMLWriter.writeText(string);
        xMLWriter.writeElement("D", "href", 1);
        String string6 = string2;
        int n2 = string2.lastIndexOf(47);
        if (n2 != -1) {
            string6 = string6.substring(n2 + 1);
        }
        switch (n) {
            case 1: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeProperty("D", "creationdate", this.getISOCreationDate(l));
                xMLWriter.writeElement("D", "displayname", 0);
                xMLWriter.writeData(string6);
                xMLWriter.writeElement("D", "displayname", 1);
                if (bl) {
                    xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                    xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                    if (string3 != null) {
                        xMLWriter.writeProperty("D", "getcontenttype", string3);
                    }
                    xMLWriter.writeProperty("D", "getetag", string4);
                    if (bl2) {
                        xMLWriter.writeElement("D", "resourcetype", 0);
                        xMLWriter.writeElement("D", "lock-null", 2);
                        xMLWriter.writeElement("D", "resourcetype", 1);
                    } else {
                        xMLWriter.writeElement("D", "resourcetype", 2);
                    }
                } else {
                    xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                    xMLWriter.writeElement("D", "resourcetype", 0);
                    xMLWriter.writeElement("D", "collection", 2);
                    xMLWriter.writeElement("D", "resourcetype", 1);
                }
                xMLWriter.writeProperty("D", "source", "");
                String string7 = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                xMLWriter.writeElement("D", "supportedlock", 0);
                xMLWriter.writeText(string7);
                xMLWriter.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(string2, xMLWriter);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeElement("D", "creationdate", 2);
                xMLWriter.writeElement("D", "displayname", 2);
                if (bl) {
                    xMLWriter.writeElement("D", "getcontentlanguage", 2);
                    xMLWriter.writeElement("D", "getcontentlength", 2);
                    xMLWriter.writeElement("D", "getcontenttype", 2);
                    xMLWriter.writeElement("D", "getetag", 2);
                    xMLWriter.writeElement("D", "getlastmodified", 2);
                }
                xMLWriter.writeElement("D", "resourcetype", 2);
                xMLWriter.writeElement("D", "source", 2);
                xMLWriter.writeElement("D", "lockdiscovery", 2);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                ArrayList<String> arrayList = new ArrayList<String>();
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                for (String string8 : list) {
                    if (string8.equals("creationdate")) {
                        xMLWriter.writeProperty("D", "creationdate", this.getISOCreationDate(l));
                        continue;
                    }
                    if (string8.equals("displayname")) {
                        xMLWriter.writeElement("D", "displayname", 0);
                        xMLWriter.writeData(string6);
                        xMLWriter.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (string8.equals("getcontentlanguage")) {
                        if (bl) {
                            xMLWriter.writeElement("D", "getcontentlanguage", 2);
                            continue;
                        }
                        arrayList.add(string8);
                        continue;
                    }
                    if (string8.equals("getcontentlength")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                            continue;
                        }
                        arrayList.add(string8);
                        continue;
                    }
                    if (string8.equals("getcontenttype")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getcontenttype", string3);
                            continue;
                        }
                        arrayList.add(string8);
                        continue;
                    }
                    if (string8.equals("getetag")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getetag", string4);
                            continue;
                        }
                        arrayList.add(string8);
                        continue;
                    }
                    if (string8.equals("getlastmodified")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                            continue;
                        }
                        arrayList.add(string8);
                        continue;
                    }
                    if (string8.equals("resourcetype")) {
                        if (bl) {
                            if (bl2) {
                                xMLWriter.writeElement("D", "resourcetype", 0);
                                xMLWriter.writeElement("D", "lock-null", 2);
                                xMLWriter.writeElement("D", "resourcetype", 1);
                                continue;
                            }
                            xMLWriter.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        xMLWriter.writeElement("D", "resourcetype", 0);
                        xMLWriter.writeElement("D", "collection", 2);
                        xMLWriter.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (string8.equals("source")) {
                        xMLWriter.writeProperty("D", "source", "");
                        continue;
                    }
                    if (string8.equals("supportedlock")) {
                        String string9 = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        xMLWriter.writeElement("D", "supportedlock", 0);
                        xMLWriter.writeText(string9);
                        xMLWriter.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (string8.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(string2, xMLWriter)) continue;
                        arrayList.add(string8);
                        continue;
                    }
                    arrayList.add(string8);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                if (arrayList.isEmpty()) break;
                string5 = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                for (String string8 : arrayList) {
                    xMLWriter.writeElement("D", string8, 2);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
            }
        }
        xMLWriter.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String string, XMLWriter xMLWriter) {
        LockInfo lockInfo = this.resourceLocks.get(string);
        boolean bl = false;
        if (lockInfo != null) {
            bl = true;
            xMLWriter.writeElement("D", "lockdiscovery", 0);
            lockInfo.toXML(xMLWriter);
        }
        for (LockInfo lockInfo2 : this.collectionLocks) {
            if (!string.startsWith(lockInfo2.path)) continue;
            if (!bl) {
                bl = true;
                xMLWriter.writeElement("D", "lockdiscovery", 0);
            }
            lockInfo2.toXML(xMLWriter);
        }
        if (!bl) {
            return false;
        }
        xMLWriter.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long l) {
        return creationDateFormat.format(new Date(l));
    }

    @Override
    protected String determineMethodsAllowed(HttpServletRequest httpServletRequest) {
        WebResource webResource = this.resources.getResource(this.getRelativePath(httpServletRequest));
        StringBuilder stringBuilder = new StringBuilder("OPTIONS, GET, POST, HEAD");
        if (!this.readOnly) {
            stringBuilder.append(", DELETE");
            if (!webResource.isDirectory()) {
                stringBuilder.append(", PUT");
            }
        }
        if (httpServletRequest instanceof RequestFacade && ((RequestFacade)httpServletRequest).getAllowTrace()) {
            stringBuilder.append(", TRACE");
        }
        stringBuilder.append(", LOCK, UNLOCK, PROPPATCH, COPY, MOVE");
        if (this.listings) {
            stringBuilder.append(", PROPFIND");
        }
        if (!webResource.exists()) {
            stringBuilder.append(", MKCOL");
        }
        return stringBuilder.toString();
    }

    static {
        URL_ENCODER_XML.removeSafeCharacter('&');
        creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        WebdavResolver(ServletContext servletContext) {
            this.context = servletContext;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.externalEntityIgnored", new Object[]{string, string2}));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    private static class LockInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int maxDepth;
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        List<String> tokens = Collections.synchronizedList(new ArrayList());
        long expiresAt = 0L;
        Date creationDate = new Date();

        LockInfo(int n) {
            this.maxDepth = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Type:");
            stringBuilder.append(this.type);
            stringBuilder.append("\nScope:");
            stringBuilder.append(this.scope);
            stringBuilder.append("\nDepth:");
            stringBuilder.append(this.depth);
            stringBuilder.append("\nOwner:");
            stringBuilder.append(this.owner);
            stringBuilder.append("\nExpiration:");
            stringBuilder.append(FastHttpDateFormat.formatDate((long)this.expiresAt));
            for (String string : this.tokens) {
                stringBuilder.append("\nToken:");
                stringBuilder.append(string);
            }
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter xMLWriter) {
            xMLWriter.writeElement("D", "activelock", 0);
            xMLWriter.writeElement("D", "locktype", 0);
            xMLWriter.writeElement("D", this.type, 2);
            xMLWriter.writeElement("D", "locktype", 1);
            xMLWriter.writeElement("D", "lockscope", 0);
            xMLWriter.writeElement("D", this.scope, 2);
            xMLWriter.writeElement("D", "lockscope", 1);
            xMLWriter.writeElement("D", "depth", 0);
            if (this.depth == this.maxDepth) {
                xMLWriter.writeText("Infinity");
            } else {
                xMLWriter.writeText("0");
            }
            xMLWriter.writeElement("D", "depth", 1);
            xMLWriter.writeElement("D", "owner", 0);
            xMLWriter.writeText(this.owner);
            xMLWriter.writeElement("D", "owner", 1);
            xMLWriter.writeElement("D", "timeout", 0);
            long l = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            xMLWriter.writeText("Second-" + l);
            xMLWriter.writeElement("D", "timeout", 1);
            xMLWriter.writeElement("D", "locktoken", 0);
            for (String string : this.tokens) {
                xMLWriter.writeElement("D", "href", 0);
                xMLWriter.writeText("opaquelocktoken:" + string);
                xMLWriter.writeElement("D", "href", 1);
            }
            xMLWriter.writeElement("D", "locktoken", 1);
            xMLWriter.writeElement("D", "activelock", 1);
        }
    }
}

