/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class LocalResolver
implements EntityResolver2 {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final String[] JAVA_EE_NAMESPACES = new String[]{"http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee"};
    private final Map<String, String> publicIds;
    private final Map<String, String> systemIds;
    private final boolean blockExternal;

    public LocalResolver(Map<String, String> map, Map<String, String> map2, boolean bl) {
        this.publicIds = map;
        this.systemIds = map2;
        this.blockExternal = bl;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.resolveEntity(null, string, null, string2);
    }

    @Override
    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        Object object;
        String string5 = this.publicIds.get(string2);
        if (string5 != null) {
            InputSource inputSource = new InputSource(string5);
            inputSource.setPublicId(string2);
            return inputSource;
        }
        if (string4 == null) {
            throw new FileNotFoundException(sm.getString("localResolver.unresolvedEntity", new Object[]{string, string2, null, string3}));
        }
        string5 = this.systemIds.get(string4);
        if (string5 != null) {
            InputSource inputSource = new InputSource(string5);
            inputSource.setPublicId(string2);
            return inputSource;
        }
        for (String string6 : JAVA_EE_NAMESPACES) {
            String string7 = string6 + '/' + string4;
            string5 = this.systemIds.get(string7);
            if (string5 == null) continue;
            InputSource inputSource = new InputSource(string5);
            inputSource.setPublicId(string2);
            return inputSource;
        }
        try {
            if (string3 == null) {
                object = new URI(string4);
            } else {
                URI uRI = new URI(string3);
                object = UriUtil.resolve((URI)uRI, (String)string4);
            }
            object = ((URI)object).normalize();
        }
        catch (URISyntaxException uRISyntaxException) {
            if (this.blockExternal) {
                throw new MalformedURLException(uRISyntaxException.getMessage());
            }
            return new InputSource(string4);
        }
        if (((URI)object).isAbsolute()) {
            string5 = this.systemIds.get(((URI)object).toString());
            if (string5 != null) {
                InputSource inputSource = new InputSource(string5);
                inputSource.setPublicId(string2);
                return inputSource;
            }
            if (!this.blockExternal) {
                InputSource inputSource = new InputSource(((URI)object).toString());
                inputSource.setPublicId(string2);
                return inputSource;
            }
        }
        throw new FileNotFoundException(sm.getString("localResolver.unresolvedEntity", new Object[]{string, string2, string4, string3}));
    }

    @Override
    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        return null;
    }
}

