/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterChain
implements FilterChain {
    private static final ThreadLocal<ServletRequest> lastServicedRequest;
    private static final ThreadLocal<ServletResponse> lastServicedResponse;
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private boolean servletSupportsAsync = false;
    private static final StringManager sm;
    private static final Class<?>[] classType;
    private static final Class<?>[] classTypeUsedInService;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            ServletRequest servletRequest2 = servletRequest;
            ServletResponse servletResponse2 = servletResponse;
            try {
                AccessController.doPrivileged(() -> {
                    this.internalDoFilter(servletRequest2, servletResponse2);
                    return null;
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new ServletException(exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.internalDoFilter(servletRequest, servletResponse);
        }
    }

    private void internalDoFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig applicationFilterConfig = this.filters[this.pos++];
            try {
                Filter filter = applicationFilterConfig.getFilter();
                if (servletRequest.isAsyncSupported() && "false".equalsIgnoreCase(applicationFilterConfig.getFilterDef().getAsyncSupported())) {
                    servletRequest.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)Boolean.FALSE);
                }
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest servletRequest2 = servletRequest;
                    ServletResponse servletResponse2 = servletResponse;
                    Principal principal = ((HttpServletRequest)servletRequest2).getUserPrincipal();
                    Object[] objectArray = new Object[]{servletRequest2, servletResponse2, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, classType, objectArray, principal);
                } else {
                    filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
                }
            }
            catch (IOException | RuntimeException | ServletException throwable) {
                throw throwable;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                throw new ServletException(sm.getString("filterChain.filter"), throwable2);
            }
            return;
        }
        try {
            if (ApplicationDispatcher.WRAP_SAME_OBJECT) {
                lastServicedRequest.set(servletRequest);
                lastServicedResponse.set(servletResponse);
            }
            if (servletRequest.isAsyncSupported() && !this.servletSupportsAsync) {
                servletRequest.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)Boolean.FALSE);
            }
            if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse && Globals.IS_SECURITY_ENABLED) {
                ServletRequest servletRequest3 = servletRequest;
                ServletResponse servletResponse3 = servletResponse;
                Principal principal = ((HttpServletRequest)servletRequest3).getUserPrincipal();
                Object[] objectArray = new Object[]{servletRequest3, servletResponse3};
                SecurityUtil.doAsPrivilege("service", this.servlet, classTypeUsedInService, objectArray, principal);
            } else {
                this.servlet.service(servletRequest, servletResponse);
            }
        }
        catch (IOException | RuntimeException | ServletException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
            ExceptionUtils.handleThrowable((Throwable)throwable3);
            throw new ServletException(sm.getString("filterChain.servlet"), throwable3);
        }
        finally {
            if (ApplicationDispatcher.WRAP_SAME_OBJECT) {
                lastServicedRequest.set(null);
                lastServicedResponse.set(null);
            }
        }
    }

    public static ServletRequest getLastServicedRequest() {
        return lastServicedRequest.get();
    }

    public static ServletResponse getLastServicedResponse() {
        return lastServicedResponse.get();
    }

    void addFilter(ApplicationFilterConfig applicationFilterConfig) {
        for (ApplicationFilterConfig applicationFilterConfig2 : this.filters) {
            if (applicationFilterConfig2 != applicationFilterConfig) continue;
            return;
        }
        if (this.n == this.filters.length) {
            ApplicationFilterConfig[] applicationFilterConfigArray = new ApplicationFilterConfig[this.n + 10];
            System.arraycopy(this.filters, 0, applicationFilterConfigArray, 0, this.n);
            this.filters = applicationFilterConfigArray;
        }
        this.filters[this.n++] = applicationFilterConfig;
    }

    void release() {
        for (int i = 0; i < this.n; ++i) {
            this.filters[i] = null;
        }
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.servletSupportsAsync = false;
    }

    void reuse() {
        this.pos = 0;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setServletSupportsAsync(boolean bl) {
        this.servletSupportsAsync = bl;
    }

    public void findNonAsyncFilters(Set<String> set) {
        for (int i = 0; i < this.n; ++i) {
            ApplicationFilterConfig applicationFilterConfig = this.filters[i];
            if (!"false".equalsIgnoreCase(applicationFilterConfig.getFilterDef().getAsyncSupported())) continue;
            set.add(applicationFilterConfig.getFilterClass());
        }
    }

    static {
        if (ApplicationDispatcher.WRAP_SAME_OBJECT) {
            lastServicedRequest = new ThreadLocal();
            lastServicedResponse = new ThreadLocal();
        } else {
            lastServicedRequest = null;
            lastServicedResponse = null;
        }
        sm = StringManager.getManager(ApplicationFilterChain.class);
        classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
        classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};
    }
}

