#!/usr/bin/env node
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 634:
/***/ ((module) => {

module.exports = require("open");

/***/ }),

/***/ 269:
/***/ ((module) => {

module.exports = require("url");

/***/ }),

/***/ 147:
/***/ ((module) => {

module.exports = JSON.parse('{"name":"@bitwarden/cli","description":"A secure and free password manager for all of your devices.","version":"2023.4.0","keywords":["bitwarden","password","vault","password manager","cli"],"author":"Bitwarden Inc. <hello@bitwarden.com> (https://bitwarden.com)","homepage":"https://bitwarden.com","repository":{"type":"git","url":"https://github.com/bitwarden/clients"},"license":"GPL-3.0-only","scripts":{"clean":"rimraf dist/**/*","build":"webpack","build:debug":"npm run build && node --inspect ./build/bw.js","build:watch":"webpack --watch","build:prod":"cross-env NODE_ENV=production webpack","build:prod:watch":"cross-env NODE_ENV=production webpack --watch","package":"npm run package:win && npm run package:mac && npm run package:lin","package:win":"pkg . --targets win-x64 --output ./dist/windows/bw.exe --build","package:mac":"pkg . --targets macos-x64 --output ./dist/macos/bw","package:lin":"pkg . --targets linux-x64 --output ./dist/linux/bw","debug":"node --inspect ./build/bw.js","dist":"npm run build:prod && npm run clean && npm run package","dist:win":"npm run build:prod && npm run clean && npm run package:win","dist:mac":"npm run build:prod && npm run clean && npm run package:mac","dist:lin":"npm run build:prod && npm run clean && npm run package:lin","publish:npm":"npm run build:prod && npm publish --access public","test":"jest","test:watch":"jest --watch","test:watch:all":"jest --watchAll"},"bin":{"bw":"build/bw.js"},"pkg":{"assets":["./build/**/*","../../node_modules/argon2/**/*"]},"dependencies":{"@koa/multer":"^3.0.0","@koa/router":"^10.1.1","argon2":"^0.30.3","big-integer":"^1.6.51","browser-hrtime":"^1.1.8","chalk":"^4.1.1","commander":"7.2.0","form-data":"4.0.0","https-proxy-agent":"5.0.0","inquirer":"8.0.0","jsdom":"^16.7.0","jszip":"^3.10.0","koa":"^2.13.4","koa-bodyparser":"^4.3.0","koa-json":"^2.0.2","lowdb":"1.0.0","lunr":"^2.3.9","multer":"^1.4.5-lts.1","node-fetch":"^2.6.7","node-forge":"1.3.1","open":"^8.4.0","papaparse":"^5.3.2","proper-lockfile":"^4.1.2","rxjs":"^7.5.5","tldts":"^5.7.84","zxcvbn":"^4.4.2"}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {

// UNUSED EXPORTS: Main

;// CONCATENATED MODULE: external "fs"
const external_fs_namespaceObject = require("fs");
;// CONCATENATED MODULE: external "path"
const external_path_namespaceObject = require("path");
;// CONCATENATED MODULE: external "commander"
const external_commander_namespaceObject = require("commander");
;// CONCATENATED MODULE: external "jsdom"
const external_jsdom_namespaceObject = require("jsdom");
;// CONCATENATED MODULE: ../../libs/common/src/models/domain/tree-node.ts
class TreeNode {
    constructor(node, parent, name, id) {
        this.children = [];
        this.parent = parent;
        this.node = node;
        if (name) {
            this.node.name = name;
        }
        if (id) {
            this.node.id = id;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/misc/serviceUtils.ts

class ServiceUtils {
    /**
     * Recursively adds a node to nodeTree
     * @param {TreeNode<ITreeNodeObject>[]} nodeTree - An array of TreeNodes that the node will be added to
     * @param {number} partIndex - Index of the `parts` array that is being processed
     * @param {string[]} parts - Array of strings that represent the path to the `obj` node
     * @param {ITreeNodeObject} obj - The node to be added to the tree
     * @param {ITreeNodeObject} parent - The parent node of the `obj` node
     * @param {string} delimiter - The delimiter used to split the path string, will be used to combine the path for missing nodes
     */
    static nestedTraverse(nodeTree, partIndex, parts, obj, parent, delimiter) {
        if (parts.length <= partIndex) {
            return;
        }
        const end = partIndex === parts.length - 1;
        const partName = parts[partIndex];
        for (let i = 0; i < nodeTree.length; i++) {
            if (nodeTree[i].node.name !== partName) {
                continue;
            }
            if (end && nodeTree[i].node.id !== obj.id) {
                // Another node exists with the same name as the node being added
                nodeTree.push(new TreeNode(obj, parent, partName));
                return;
            }
            // Move down the tree to the next level
            ServiceUtils.nestedTraverse(nodeTree[i].children, partIndex + 1, parts, obj, nodeTree[i], delimiter);
            return;
        }
        // If there's no node here with the same name...
        if (nodeTree.filter((n) => n.node.name === partName).length === 0) {
            // And we're at the end of the path given, add the node
            if (end) {
                nodeTree.push(new TreeNode(obj, parent, partName));
                return;
            }
            // And we're not at the end of the path, combine the current name with the next name
            // 1, *1.2, 1.2.1 becomes
            // 1, *1.2/1.2.1
            const newPartName = partName + delimiter + parts[partIndex + 1];
            ServiceUtils.nestedTraverse(nodeTree, 0, [newPartName, ...parts.slice(partIndex + 2)], obj, parent, delimiter);
        }
    }
    /**
     * Searches a tree for a node with a matching `id`
     * @param {TreeNode<T>} nodeTree - A single TreeNode branch that will be searched
     * @param {string} id - The id of the node to be found
     * @returns {TreeNode<T>} The node with a matching `id`
     */
    static getTreeNodeObject(nodeTree, id) {
        if (nodeTree.node.id === id) {
            return nodeTree;
        }
        for (let i = 0; i < nodeTree.children.length; i++) {
            if (nodeTree.children[i].children != null) {
                const node = ServiceUtils.getTreeNodeObject(nodeTree.children[i], id);
                if (node !== null) {
                    return node;
                }
            }
        }
        return null;
    }
    /**
     * Searches an array of tree nodes for a node with a matching `id`
     * @param {TreeNode<T>} nodeTree - An array of TreeNode branches that will be searched
     * @param {string} id - The id of the node to be found
     * @returns {TreeNode<T>} The node with a matching `id`
     */
    static getTreeNodeObjectFromList(nodeTree, id) {
        for (let i = 0; i < nodeTree.length; i++) {
            if (nodeTree[i].node.id === id) {
                return nodeTree[i];
            }
            else if (nodeTree[i].children != null) {
                const node = ServiceUtils.getTreeNodeObjectFromList(nodeTree[i].children, id);
                if (node !== null) {
                    return node;
                }
            }
        }
        return null;
    }
}

;// CONCATENATED MODULE: external "rxjs"
const external_rxjs_namespaceObject = require("rxjs");
;// CONCATENATED MODULE: external "tldts"
const external_tldts_namespaceObject = require("tldts");
;// CONCATENATED MODULE: ../../libs/common/src/misc/utils.ts
/* eslint-disable no-useless-escape */



const nodeURL = typeof window === "undefined" ? __webpack_require__(269) : null;
class utils_Utils {
    static init() {
        if (utils_Utils.inited) {
            return;
        }
        utils_Utils.inited = true;
        utils_Utils.isNode =
            typeof process !== "undefined" &&
                process.release != null &&
                process.release.name === "node";
        utils_Utils.isBrowser = typeof window !== "undefined";
        utils_Utils.isMobileBrowser = utils_Utils.isBrowser && this.isMobile(window);
        utils_Utils.isAppleMobileBrowser = utils_Utils.isBrowser && this.isAppleMobile(window);
        if (utils_Utils.isNode) {
            utils_Utils.global = global;
        }
        else if (utils_Utils.isBrowser) {
            utils_Utils.global = window;
        }
        else {
            // If it's not browser or node then it must be a service worker
            utils_Utils.global = self;
        }
    }
    static fromB64ToArray(str) {
        if (str == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "base64"));
        }
        else {
            const binaryString = utils_Utils.global.atob(str);
            const bytes = new Uint8Array(binaryString.length);
            for (let i = 0; i < binaryString.length; i++) {
                bytes[i] = binaryString.charCodeAt(i);
            }
            return bytes;
        }
    }
    static fromUrlB64ToArray(str) {
        return utils_Utils.fromB64ToArray(utils_Utils.fromUrlB64ToB64(str));
    }
    static fromHexToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "hex"));
        }
        else {
            const bytes = new Uint8Array(str.length / 2);
            for (let i = 0; i < str.length; i += 2) {
                bytes[i / 2] = parseInt(str.substr(i, 2), 16);
            }
            return bytes;
        }
    }
    static fromUtf8ToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "utf8"));
        }
        else {
            const strUtf8 = unescape(encodeURIComponent(str));
            const arr = new Uint8Array(strUtf8.length);
            for (let i = 0; i < strUtf8.length; i++) {
                arr[i] = strUtf8.charCodeAt(i);
            }
            return arr;
        }
    }
    static fromByteStringToArray(str) {
        if (str == null) {
            return null;
        }
        const arr = new Uint8Array(str.length);
        for (let i = 0; i < str.length; i++) {
            arr[i] = str.charCodeAt(i);
        }
        return arr;
    }
    static fromBufferToB64(buffer) {
        if (buffer == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("base64");
        }
        else {
            let binary = "";
            const bytes = new Uint8Array(buffer);
            for (let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            return utils_Utils.global.btoa(binary);
        }
    }
    static fromBufferToUrlB64(buffer) {
        return utils_Utils.fromB64toUrlB64(utils_Utils.fromBufferToB64(buffer));
    }
    static fromB64toUrlB64(b64Str) {
        return b64Str.replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
    }
    static fromBufferToUtf8(buffer) {
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("utf8");
        }
        else {
            const bytes = new Uint8Array(buffer);
            const encodedString = String.fromCharCode.apply(null, bytes);
            return decodeURIComponent(escape(encodedString));
        }
    }
    static fromBufferToByteString(buffer) {
        return String.fromCharCode.apply(null, new Uint8Array(buffer));
    }
    // ref: https://stackoverflow.com/a/40031979/1090359
    static fromBufferToHex(buffer) {
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("hex");
        }
        else {
            const bytes = new Uint8Array(buffer);
            return Array.prototype.map
                .call(bytes, (x) => ("00" + x.toString(16)).slice(-2))
                .join("");
        }
    }
    static fromUrlB64ToB64(urlB64Str) {
        let output = urlB64Str.replace(/-/g, "+").replace(/_/g, "/");
        switch (output.length % 4) {
            case 0:
                break;
            case 2:
                output += "==";
                break;
            case 3:
                output += "=";
                break;
            default:
                throw new Error("Illegal base64url string!");
        }
        return output;
    }
    static fromUrlB64ToUtf8(urlB64Str) {
        return utils_Utils.fromB64ToUtf8(utils_Utils.fromUrlB64ToB64(urlB64Str));
    }
    static fromUtf8ToB64(utfStr) {
        if (utils_Utils.isNode) {
            return Buffer.from(utfStr, "utf8").toString("base64");
        }
        else {
            return decodeURIComponent(escape(utils_Utils.global.btoa(utfStr)));
        }
    }
    static fromUtf8ToUrlB64(utfStr) {
        return utils_Utils.fromBufferToUrlB64(utils_Utils.fromUtf8ToArray(utfStr));
    }
    static fromB64ToUtf8(b64Str) {
        if (utils_Utils.isNode) {
            return Buffer.from(b64Str, "base64").toString("utf8");
        }
        else {
            return decodeURIComponent(escape(utils_Utils.global.atob(b64Str)));
        }
    }
    // ref: http://stackoverflow.com/a/2117523/1090359
    static newGuid() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
            const r = (Math.random() * 16) | 0;
            const v = c === "x" ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    static isGuid(id) {
        return RegExp(/^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/, "i").test(id);
    }
    static getHostname(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        if (uriString.startsWith("file:")) {
            return null;
        }
        // Does uriString contain invalid characters
        // TODO Needs to possibly be extended, although '!' is a reserved character
        if (uriString.indexOf("!") > 0) {
            return null;
        }
        try {
            const hostname = (0,external_tldts_namespaceObject.getHostname)(uriString, { validHosts: this.validHosts });
            if (hostname != null) {
                return hostname;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getHost(uriString) {
        const url = utils_Utils.getUrl(uriString);
        try {
            return url != null && url.host !== "" ? url.host : null;
        }
        catch (_a) {
            return null;
        }
    }
    static getDomain(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        try {
            const parseResult = (0,external_tldts_namespaceObject.parse)(uriString, { validHosts: this.validHosts });
            if (parseResult != null && parseResult.hostname != null) {
                if (parseResult.hostname === "localhost" || parseResult.isIp) {
                    return parseResult.hostname;
                }
                if (parseResult.domain != null) {
                    return parseResult.domain;
                }
                return null;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getQueryParams(uriString) {
        const url = utils_Utils.getUrl(uriString);
        if (url == null || url.search == null || url.search === "") {
            return null;
        }
        const map = new Map();
        const pairs = (url.search[0] === "?" ? url.search.substr(1) : url.search).split("&");
        pairs.forEach((pair) => {
            const parts = pair.split("=");
            if (parts.length < 1) {
                return;
            }
            map.set(decodeURIComponent(parts[0]).toLowerCase(), parts[1] == null ? "" : decodeURIComponent(parts[1]));
        });
        return map;
    }
    static getSortFunction(i18nService, prop) {
        return (a, b) => {
            if (a[prop] == null && b[prop] != null) {
                return -1;
            }
            if (a[prop] != null && b[prop] == null) {
                return 1;
            }
            if (a[prop] == null && b[prop] == null) {
                return 0;
            }
            // The `as unknown as string` here is unfortunate because typescript doesn't property understand that the return of T[prop] will be a string
            return i18nService.collator
                ? i18nService.collator.compare(a[prop], b[prop])
                : a[prop].localeCompare(b[prop]);
        };
    }
    static isNullOrWhitespace(str) {
        return str == null || typeof str !== "string" || str.trim() === "";
    }
    static isNullOrEmpty(str) {
        return str == null || typeof str !== "string" || str == "";
    }
    static isPromise(obj) {
        return (obj != undefined && typeof obj["then"] === "function" && typeof obj["catch"] === "function");
    }
    static nameOf(name) {
        return name;
    }
    static assign(target, source) {
        return Object.assign(target, source);
    }
    static iterateEnum(obj) {
        return Object.keys(obj).filter((k) => Number.isNaN(+k)).map((k) => obj[k]);
    }
    static getUrl(uriString) {
        if (this.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        return utils_Utils.getUrlObject(uriString);
    }
    static camelToPascalCase(s) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    }
    /**
     * There are a few ways to calculate text color for contrast, this one seems to fit accessibility guidelines best.
     * https://stackoverflow.com/a/3943023/6869691
     *
     * @param {string} bgColor
     * @param {number} [threshold] see stackoverflow link above
     * @param {boolean} [svgTextFill]
     * Indicates if this method is performed on an SVG <text> 'fill' attribute (e.g. <text fill="black"></text>).
     * This check is necessary because the '!important' tag cannot be used in a 'fill' attribute.
     */
    static pickTextColorBasedOnBgColor(bgColor, threshold = 186, svgTextFill = false) {
        const bgColorHexNums = bgColor.charAt(0) === "#" ? bgColor.substring(1, 7) : bgColor;
        const r = parseInt(bgColorHexNums.substring(0, 2), 16); // hexToR
        const g = parseInt(bgColorHexNums.substring(2, 4), 16); // hexToG
        const b = parseInt(bgColorHexNums.substring(4, 6), 16); // hexToB
        const blackColor = svgTextFill ? "black" : "black !important";
        const whiteColor = svgTextFill ? "white" : "white !important";
        return r * 0.299 + g * 0.587 + b * 0.114 > threshold ? blackColor : whiteColor;
    }
    static stringToColor(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = str.charCodeAt(i) + ((hash << 5) - hash);
        }
        let color = "#";
        for (let i = 0; i < 3; i++) {
            const value = (hash >> (i * 8)) & 0xff;
            color += ("00" + value.toString(16)).substr(-2);
        }
        return color;
    }
    /**
     * @throws Will throw an error if the ContainerService has not been attached to the window object
     */
    static getContainerService() {
        if (this.global.bitwardenContainerService == null) {
            throw new Error("global bitwardenContainerService not initialized.");
        }
        return this.global.bitwardenContainerService;
    }
    static validateHexColor(color) {
        return /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/.test(color);
    }
    /**
     * Converts map to a Record<string, V> with the same data. Inverse of recordToMap
     * Useful in toJSON methods, since Maps are not serializable
     * @param map
     * @returns
     */
    static mapToRecord(map) {
        if (map == null) {
            return null;
        }
        if (!(map instanceof Map)) {
            return map;
        }
        return Object.fromEntries(map);
    }
    /**
     * Converts record to a Map<string, V> with the same data. Inverse of mapToRecord
     * Useful in fromJSON methods, since Maps are not serializable
     *
     * Warning: If the record has string keys that are numbers, they will be converted to numbers in the map
     * @param record
     * @returns
     */
    static recordToMap(record) {
        if (record == null) {
            return null;
        }
        else if (record instanceof Map) {
            return record;
        }
        const entries = Object.entries(record);
        if (entries.length === 0) {
            return new Map();
        }
        if (isNaN(Number(entries[0][0]))) {
            return new Map(entries);
        }
        else {
            return new Map(entries.map((e) => [Number(e[0]), e[1]]));
        }
    }
    /** Applies Object.assign, but converts the type nicely using Type-Fest Merge<Destination, Source> */
    static merge(destination, source) {
        return Object.assign(destination, source);
    }
    /**
     * encodeURIComponent escapes all characters except the following:
     * alphabetic, decimal digits, - _ . ! ~ * ' ( )
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent#encoding_for_rfc3986
     */
    static encodeRFC3986URIComponent(str) {
        return encodeURIComponent(str).replace(/[!'()*]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
    }
    /**
     * Normalizes a path for defense against attacks like traversals
     * @param denormalizedPath
     * @returns
     */
    static normalizePath(denormalizedPath) {
        return external_path_namespaceObject.normalize(decodeURIComponent(denormalizedPath)).replace(/^(\.\.(\/|\\|$))+/, "");
    }
    static isMobile(win) {
        let mobile = false;
        ((a) => {
            if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
                /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
                mobile = true;
            }
        })(win.navigator.userAgent || win.navigator.vendor || win.opera);
        return mobile || win.navigator.userAgent.match(/iPad/i) != null;
    }
    static delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    /**
     * Generate an observable from a function that returns a promise.
     * Similar to the rxjs function {@link from} with one big exception:
     * {@link from} will not re-execute the function when observers resubscribe.
     * {@link Util.asyncToObservable} will execute `generator` for every
     * subscribe, making it ideal if the value ever needs to be refreshed.
     * */
    static asyncToObservable(generator) {
        return (0,external_rxjs_namespaceObject.of)(undefined).pipe((0,external_rxjs_namespaceObject.switchMap)(() => generator()));
    }
    static isAppleMobile(win) {
        return (win.navigator.userAgent.match(/iPhone/i) != null ||
            win.navigator.userAgent.match(/iPad/i) != null);
    }
    static getUrlObject(uriString) {
        // All the methods below require a protocol to properly parse a URL string
        // Assume http if no other protocol is present
        const hasProtocol = uriString.indexOf("://") > -1;
        if (!hasProtocol && uriString.indexOf(".") > -1) {
            uriString = "http://" + uriString;
        }
        else if (!hasProtocol) {
            return null;
        }
        try {
            if (nodeURL != null) {
                return new nodeURL.URL(uriString);
            }
            return new URL(uriString);
        }
        catch (e) {
            // Ignore error
        }
        return null;
    }
}
utils_Utils.inited = false;
utils_Utils.isNode = false;
utils_Utils.isBrowser = true;
utils_Utils.isMobileBrowser = false;
utils_Utils.isAppleMobileBrowser = false;
utils_Utils.global = null;
// Transpiled version of /\p{Emoji_Presentation}/gu using https://mothereff.in/regexpu. Used for compatability in older browsers.
utils_Utils.regexpEmojiPresentation = /(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])/g;
utils_Utils.validHosts = ["localhost"];
utils_Utils.minimumPasswordLength = 12;
utils_Utils.DomainMatchBlacklist = new Map([
    ["google.com", new Set(["script.google.com"])],
]);
utils_Utils.init();

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/collection.data.ts
class CollectionData {
    constructor(response) {
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.name = response.name;
        this.externalId = response.externalId;
        this.readOnly = response.readOnly;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/client-type.enum.ts
var ClientType;
(function (ClientType) {
    ClientType["Web"] = "web";
    ClientType["Browser"] = "browser";
    ClientType["Desktop"] = "desktop";
    ClientType["Mobile"] = "mobile";
    ClientType["Cli"] = "cli";
    ClientType["DirectoryConnector"] = "connector";
})(ClientType || (ClientType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/device-type.enum.ts
var DeviceType;
(function (DeviceType) {
    DeviceType[DeviceType["Android"] = 0] = "Android";
    DeviceType[DeviceType["iOS"] = 1] = "iOS";
    DeviceType[DeviceType["ChromeExtension"] = 2] = "ChromeExtension";
    DeviceType[DeviceType["FirefoxExtension"] = 3] = "FirefoxExtension";
    DeviceType[DeviceType["OperaExtension"] = 4] = "OperaExtension";
    DeviceType[DeviceType["EdgeExtension"] = 5] = "EdgeExtension";
    DeviceType[DeviceType["WindowsDesktop"] = 6] = "WindowsDesktop";
    DeviceType[DeviceType["MacOsDesktop"] = 7] = "MacOsDesktop";
    DeviceType[DeviceType["LinuxDesktop"] = 8] = "LinuxDesktop";
    DeviceType[DeviceType["ChromeBrowser"] = 9] = "ChromeBrowser";
    DeviceType[DeviceType["FirefoxBrowser"] = 10] = "FirefoxBrowser";
    DeviceType[DeviceType["OperaBrowser"] = 11] = "OperaBrowser";
    DeviceType[DeviceType["EdgeBrowser"] = 12] = "EdgeBrowser";
    DeviceType[DeviceType["IEBrowser"] = 13] = "IEBrowser";
    DeviceType[DeviceType["UnknownBrowser"] = 14] = "UnknownBrowser";
    DeviceType[DeviceType["AndroidAmazon"] = 15] = "AndroidAmazon";
    DeviceType[DeviceType["UWP"] = 16] = "UWP";
    DeviceType[DeviceType["SafariBrowser"] = 17] = "SafariBrowser";
    DeviceType[DeviceType["VivaldiBrowser"] = 18] = "VivaldiBrowser";
    DeviceType[DeviceType["VivaldiExtension"] = 19] = "VivaldiExtension";
    DeviceType[DeviceType["SafariExtension"] = 20] = "SafariExtension";
    DeviceType[DeviceType["SDK"] = 21] = "SDK";
    DeviceType[DeviceType["Server"] = 22] = "Server";
})(DeviceType || (DeviceType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/encrypted-export-type.enum.ts
var EncryptedExportType;
(function (EncryptedExportType) {
    EncryptedExportType[EncryptedExportType["AccountEncrypted"] = 0] = "AccountEncrypted";
    EncryptedExportType[EncryptedExportType["FileEncrypted"] = 1] = "FileEncrypted";
})(EncryptedExportType || (EncryptedExportType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/encryption-type.enum.ts
var EncryptionType;
(function (EncryptionType) {
    EncryptionType[EncryptionType["AesCbc256_B64"] = 0] = "AesCbc256_B64";
    EncryptionType[EncryptionType["AesCbc128_HmacSha256_B64"] = 1] = "AesCbc128_HmacSha256_B64";
    EncryptionType[EncryptionType["AesCbc256_HmacSha256_B64"] = 2] = "AesCbc256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_B64"] = 3] = "Rsa2048_OaepSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_B64"] = 4] = "Rsa2048_OaepSha1_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_HmacSha256_B64"] = 5] = "Rsa2048_OaepSha256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_HmacSha256_B64"] = 6] = "Rsa2048_OaepSha1_HmacSha256_B64";
})(EncryptionType || (EncryptionType = {}));
/** The expected number of parts to a serialized EncString of the given encryption type.
 * For example, an EncString of type AesCbc256_B64 will have 2 parts, and an EncString of type
 * AesCbc128_HmacSha256_B64 will have 3 parts.
 *
 * Example of annotated serialized EncStrings:
 * 0.iv|data
 * 1.iv|data|mac
 * 2.iv|data|mac
 * 3.data
 * 4.data
 *
 * @see EncString
 * @see EncryptionType
 * @see EncString.parseEncryptedString
 */
const EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE = {
    [EncryptionType.AesCbc256_B64]: 2,
    [EncryptionType.AesCbc128_HmacSha256_B64]: 3,
    [EncryptionType.AesCbc256_HmacSha256_B64]: 3,
    [EncryptionType.Rsa2048_OaepSha256_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha1_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64]: 2,
    [EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64]: 2,
};

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-system-user.enum.ts
// Note: the enum key is used to describe the EventSystemUser in the UI. Be careful about changing it.
var EventSystemUser;
(function (EventSystemUser) {
    EventSystemUser[EventSystemUser["SCIM"] = 1] = "SCIM";
    EventSystemUser[EventSystemUser["DomainVerification"] = 2] = "DomainVerification";
})(EventSystemUser || (EventSystemUser = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-type.enum.ts
// Increment by 100 for each new set of events
var EventType;
(function (EventType) {
    EventType[EventType["User_LoggedIn"] = 1000] = "User_LoggedIn";
    EventType[EventType["User_ChangedPassword"] = 1001] = "User_ChangedPassword";
    EventType[EventType["User_Updated2fa"] = 1002] = "User_Updated2fa";
    EventType[EventType["User_Disabled2fa"] = 1003] = "User_Disabled2fa";
    EventType[EventType["User_Recovered2fa"] = 1004] = "User_Recovered2fa";
    EventType[EventType["User_FailedLogIn"] = 1005] = "User_FailedLogIn";
    EventType[EventType["User_FailedLogIn2fa"] = 1006] = "User_FailedLogIn2fa";
    EventType[EventType["User_ClientExportedVault"] = 1007] = "User_ClientExportedVault";
    EventType[EventType["User_UpdatedTempPassword"] = 1008] = "User_UpdatedTempPassword";
    EventType[EventType["User_MigratedKeyToKeyConnector"] = 1009] = "User_MigratedKeyToKeyConnector";
    EventType[EventType["Cipher_Created"] = 1100] = "Cipher_Created";
    EventType[EventType["Cipher_Updated"] = 1101] = "Cipher_Updated";
    EventType[EventType["Cipher_Deleted"] = 1102] = "Cipher_Deleted";
    EventType[EventType["Cipher_AttachmentCreated"] = 1103] = "Cipher_AttachmentCreated";
    EventType[EventType["Cipher_AttachmentDeleted"] = 1104] = "Cipher_AttachmentDeleted";
    EventType[EventType["Cipher_Shared"] = 1105] = "Cipher_Shared";
    EventType[EventType["Cipher_UpdatedCollections"] = 1106] = "Cipher_UpdatedCollections";
    EventType[EventType["Cipher_ClientViewed"] = 1107] = "Cipher_ClientViewed";
    EventType[EventType["Cipher_ClientToggledPasswordVisible"] = 1108] = "Cipher_ClientToggledPasswordVisible";
    EventType[EventType["Cipher_ClientToggledHiddenFieldVisible"] = 1109] = "Cipher_ClientToggledHiddenFieldVisible";
    EventType[EventType["Cipher_ClientToggledCardCodeVisible"] = 1110] = "Cipher_ClientToggledCardCodeVisible";
    EventType[EventType["Cipher_ClientCopiedPassword"] = 1111] = "Cipher_ClientCopiedPassword";
    EventType[EventType["Cipher_ClientCopiedHiddenField"] = 1112] = "Cipher_ClientCopiedHiddenField";
    EventType[EventType["Cipher_ClientCopiedCardCode"] = 1113] = "Cipher_ClientCopiedCardCode";
    EventType[EventType["Cipher_ClientAutofilled"] = 1114] = "Cipher_ClientAutofilled";
    EventType[EventType["Cipher_SoftDeleted"] = 1115] = "Cipher_SoftDeleted";
    EventType[EventType["Cipher_Restored"] = 1116] = "Cipher_Restored";
    EventType[EventType["Cipher_ClientToggledCardNumberVisible"] = 1117] = "Cipher_ClientToggledCardNumberVisible";
    EventType[EventType["Collection_Created"] = 1300] = "Collection_Created";
    EventType[EventType["Collection_Updated"] = 1301] = "Collection_Updated";
    EventType[EventType["Collection_Deleted"] = 1302] = "Collection_Deleted";
    EventType[EventType["Group_Created"] = 1400] = "Group_Created";
    EventType[EventType["Group_Updated"] = 1401] = "Group_Updated";
    EventType[EventType["Group_Deleted"] = 1402] = "Group_Deleted";
    EventType[EventType["OrganizationUser_Invited"] = 1500] = "OrganizationUser_Invited";
    EventType[EventType["OrganizationUser_Confirmed"] = 1501] = "OrganizationUser_Confirmed";
    EventType[EventType["OrganizationUser_Updated"] = 1502] = "OrganizationUser_Updated";
    EventType[EventType["OrganizationUser_Removed"] = 1503] = "OrganizationUser_Removed";
    EventType[EventType["OrganizationUser_UpdatedGroups"] = 1504] = "OrganizationUser_UpdatedGroups";
    EventType[EventType["OrganizationUser_UnlinkedSso"] = 1505] = "OrganizationUser_UnlinkedSso";
    EventType[EventType["OrganizationUser_ResetPassword_Enroll"] = 1506] = "OrganizationUser_ResetPassword_Enroll";
    EventType[EventType["OrganizationUser_ResetPassword_Withdraw"] = 1507] = "OrganizationUser_ResetPassword_Withdraw";
    EventType[EventType["OrganizationUser_AdminResetPassword"] = 1508] = "OrganizationUser_AdminResetPassword";
    EventType[EventType["OrganizationUser_ResetSsoLink"] = 1509] = "OrganizationUser_ResetSsoLink";
    EventType[EventType["OrganizationUser_FirstSsoLogin"] = 1510] = "OrganizationUser_FirstSsoLogin";
    EventType[EventType["OrganizationUser_Revoked"] = 1511] = "OrganizationUser_Revoked";
    EventType[EventType["OrganizationUser_Restored"] = 1512] = "OrganizationUser_Restored";
    EventType[EventType["Organization_Updated"] = 1600] = "Organization_Updated";
    EventType[EventType["Organization_PurgedVault"] = 1601] = "Organization_PurgedVault";
    EventType[EventType["Organization_ClientExportedVault"] = 1602] = "Organization_ClientExportedVault";
    EventType[EventType["Organization_VaultAccessed"] = 1603] = "Organization_VaultAccessed";
    EventType[EventType["Organization_EnabledSso"] = 1604] = "Organization_EnabledSso";
    EventType[EventType["Organization_DisabledSso"] = 1605] = "Organization_DisabledSso";
    EventType[EventType["Organization_EnabledKeyConnector"] = 1606] = "Organization_EnabledKeyConnector";
    EventType[EventType["Organization_DisabledKeyConnector"] = 1607] = "Organization_DisabledKeyConnector";
    EventType[EventType["Organization_SponsorshipsSynced"] = 1608] = "Organization_SponsorshipsSynced";
    EventType[EventType["Policy_Updated"] = 1700] = "Policy_Updated";
    EventType[EventType["ProviderUser_Invited"] = 1800] = "ProviderUser_Invited";
    EventType[EventType["ProviderUser_Confirmed"] = 1801] = "ProviderUser_Confirmed";
    EventType[EventType["ProviderUser_Updated"] = 1802] = "ProviderUser_Updated";
    EventType[EventType["ProviderUser_Removed"] = 1803] = "ProviderUser_Removed";
    EventType[EventType["ProviderOrganization_Created"] = 1900] = "ProviderOrganization_Created";
    EventType[EventType["ProviderOrganization_Added"] = 1901] = "ProviderOrganization_Added";
    EventType[EventType["ProviderOrganization_Removed"] = 1902] = "ProviderOrganization_Removed";
    EventType[EventType["ProviderOrganization_VaultAccessed"] = 1903] = "ProviderOrganization_VaultAccessed";
    EventType[EventType["OrganizationDomain_Added"] = 2000] = "OrganizationDomain_Added";
    EventType[EventType["OrganizationDomain_Removed"] = 2001] = "OrganizationDomain_Removed";
    EventType[EventType["OrganizationDomain_Verified"] = 2002] = "OrganizationDomain_Verified";
    EventType[EventType["OrganizationDomain_NotVerified"] = 2003] = "OrganizationDomain_NotVerified";
    EventType[EventType["Secret_Retrieved"] = 2100] = "Secret_Retrieved";
})(EventType || (EventType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/field-type.enum.ts
var FieldType;
(function (FieldType) {
    FieldType[FieldType["Text"] = 0] = "Text";
    FieldType[FieldType["Hidden"] = 1] = "Hidden";
    FieldType[FieldType["Boolean"] = 2] = "Boolean";
    FieldType[FieldType["Linked"] = 3] = "Linked";
})(FieldType || (FieldType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/file-upload-type.enum.ts
var FileUploadType;
(function (FileUploadType) {
    FileUploadType[FileUploadType["Direct"] = 0] = "Direct";
    FileUploadType[FileUploadType["Azure"] = 1] = "Azure";
})(FileUploadType || (FileUploadType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/hash-purpose.enum.ts
var HashPurpose;
(function (HashPurpose) {
    HashPurpose[HashPurpose["ServerAuthorization"] = 1] = "ServerAuthorization";
    HashPurpose[HashPurpose["LocalAuthorization"] = 2] = "LocalAuthorization";
})(HashPurpose || (HashPurpose = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/html-storage-location.enum.ts
var HtmlStorageLocation;
(function (HtmlStorageLocation) {
    HtmlStorageLocation["Local"] = "local";
    HtmlStorageLocation["Memory"] = "memory";
    HtmlStorageLocation["Session"] = "session";
})(HtmlStorageLocation || (HtmlStorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/http-status-code.enum.ts
/**
 * Hypertext Transfer Protocol (HTTP) response status codes.
 *
 * @see {@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}
 * src: https://gist.github.com/RWOverdijk/6cef816cfdf5722228e01cc05fd4b094
 */
var HttpStatusCode;
(function (HttpStatusCode) {
    /**
     * The server has received the request headers and the client should proceed to send the request body
     * (in the case of a request for which a body needs to be sent; for example, a POST request).
     * Sending a large request body to a server after a request has been rejected for inappropriate headers would be inefficient.
     * To have a server check the request's headers, a client must send Expect: 100-continue as a header in its initial request
     * and receive a 100 Continue status code in response before sending the body. The response 417 Expectation Failed indicates the request should not be continued.
     */
    HttpStatusCode[HttpStatusCode["Continue"] = 100] = "Continue";
    /**
     * The requester has asked the server to switch protocols and the server has agreed to do so.
     */
    HttpStatusCode[HttpStatusCode["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    /**
     * A WebDAV request may contain many sub-requests involving file operations, requiring a long time to complete the request.
     * This code indicates that the server has received and is processing the request, but no response is available yet.
     * This prevents the client from timing out and assuming the request was lost.
     */
    HttpStatusCode[HttpStatusCode["Processing"] = 102] = "Processing";
    // **********************************************************************************************************
    //#region 200s - SUCCESS
    // **********************************************************************************************************
    /**
     * Standard response for successful HTTP requests.
     * The actual response will depend on the request method used.
     * In a GET request, the response will contain an entity corresponding to the requested resource.
     * In a POST request, the response will contain an entity describing or containing the result of the action.
     */
    HttpStatusCode[HttpStatusCode["Ok"] = 200] = "Ok";
    /**
     * The request has been fulfilled, resulting in the creation of a new resource.
     */
    HttpStatusCode[HttpStatusCode["Created"] = 201] = "Created";
    /**
     * The request has been accepted for processing, but the processing has not been completed.
     * The request might or might not be eventually acted upon, and may be disallowed when processing occurs.
     */
    HttpStatusCode[HttpStatusCode["Accepted"] = 202] = "Accepted";
    /**
     * SINCE HTTP/1.1
     * The server is a transforming proxy that received a 200 OK from its origin,
     * but is returning a modified version of the origin's response.
     */
    HttpStatusCode[HttpStatusCode["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
    /**
     * The server successfully processed the request and is not returning any content.
     */
    HttpStatusCode[HttpStatusCode["NoContent"] = 204] = "NoContent";
    /**
     * The server successfully processed the request, but is not returning any content.
     * Unlike a 204 response, this response requires that the requester reset the document view.
     */
    HttpStatusCode[HttpStatusCode["ResetContent"] = 205] = "ResetContent";
    /**
     * The server is delivering only part of the resource (byte serving) due to a range header sent by the client.
     * The range header is used by HTTP clients to enable resuming of interrupted downloads,
     * or split a download into multiple simultaneous streams.
     */
    HttpStatusCode[HttpStatusCode["PartialContent"] = 206] = "PartialContent";
    /**
     * The message body that follows is an XML message and can contain a number of separate response codes,
     * depending on how many sub-requests were made.
     */
    HttpStatusCode[HttpStatusCode["MultiStatus"] = 207] = "MultiStatus";
    /**
     * The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response,
     * and are not being included again.
     */
    HttpStatusCode[HttpStatusCode["AlreadyReported"] = 208] = "AlreadyReported";
    /**
     * The server has fulfilled a request for the resource,
     * and the response is a representation of the result of one or more instance-manipulations applied to the current instance.
     */
    HttpStatusCode[HttpStatusCode["ImUsed"] = 226] = "ImUsed";
    // #endregion
    // **********************************************************************************************************
    //#region 300s - Redirections
    // **********************************************************************************************************
    /**
     * Indicates multiple options for the resource from which the client may choose (via agent-driven content negotiation).
     * For example, this code could be used to present multiple video format options,
     * to list files with different filename extensions, or to suggest word-sense disambiguation.
     */
    HttpStatusCode[HttpStatusCode["MultipleChoices"] = 300] = "MultipleChoices";
    /**
     * This and all future requests should be directed to the given URI.
     */
    HttpStatusCode[HttpStatusCode["MovedPermanently"] = 301] = "MovedPermanently";
    /**
     * This is an example of industry practice contradicting the standard.
     * The HTTP/1.0 specification (RFC 1945) required the client to perform a temporary redirect
     * (the original describing phrase was "Moved Temporarily"), but popular browsers implemented 302
     * with the functionality of a 303 See Other. Therefore, HTTP/1.1 added status codes 303 and 307
     * to distinguish between the two behaviours. However, some Web applications and frameworks
     * use the 302 status code as if it were the 303.
     */
    HttpStatusCode[HttpStatusCode["Found"] = 302] = "Found";
    /**
     * SINCE HTTP/1.1
     * The response to the request can be found under another URI using a GET method.
     * When received in response to a POST (or PUT/DELETE), the client should presume that
     * the server has received the data and should issue a redirect with a separate GET message.
     */
    HttpStatusCode[HttpStatusCode["SeeOther"] = 303] = "SeeOther";
    /**
     * Indicates that the resource has not been modified since the version specified by the request headers If-Modified-Since or If-None-Match.
     * In such case, there is no need to retransmit the resource since the client still has a previously-downloaded copy.
     */
    HttpStatusCode[HttpStatusCode["NotModified"] = 304] = "NotModified";
    /**
     * SINCE HTTP/1.1
     * The requested resource is available only through a proxy, the address for which is provided in the response.
     * Many HTTP clients (such as Mozilla and Internet Explorer) do not correctly handle responses with this status code, primarily for security reasons.
     */
    HttpStatusCode[HttpStatusCode["UseProxy"] = 305] = "UseProxy";
    /**
     * No longer used. Originally meant "Subsequent requests should use the specified proxy."
     */
    HttpStatusCode[HttpStatusCode["SwitchProxy"] = 306] = "SwitchProxy";
    /**
     * SINCE HTTP/1.1
     * In this case, the request should be repeated with another URI; however, future requests should still use the original URI.
     * In contrast to how 302 was historically implemented, the request method is not allowed to be changed when reissuing the original request.
     * For example, a POST request should be repeated using another POST request.
     */
    HttpStatusCode[HttpStatusCode["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    /**
     * The request and all future requests should be repeated using another URI.
     * 307 and 308 parallel the behaviors of 302 and 301, but do not allow the HTTP method to change.
     * So, for example, submitting a form to a permanently redirected resource may continue smoothly.
     */
    HttpStatusCode[HttpStatusCode["PermanentRedirect"] = 308] = "PermanentRedirect";
    // #endregion
    // **********************************************************************************************************
    // #region - 400s - Client / User messed up
    // **********************************************************************************************************
    /**
     * The server cannot or will not process the request due to an apparent client error
     * (e.g., malformed request syntax, too large size, invalid request message framing, or deceptive request routing).
     */
    HttpStatusCode[HttpStatusCode["BadRequest"] = 400] = "BadRequest";
    /**
     * Similar to 403 Forbidden, but specifically for use when authentication is required and has failed or has not yet
     * been provided. The response must include a WWW-Authenticate header field containing a challenge applicable to the
     * requested resource. See Basic access authentication and Digest access authentication. 401 semantically means
     * "unauthenticated",i.e. the user does not have the necessary credentials.
     */
    HttpStatusCode[HttpStatusCode["Unauthorized"] = 401] = "Unauthorized";
    /**
     * Reserved for future use. The original intention was that this code might be used as part of some form of digital
     * cash or micro payment scheme, but that has not happened, and this code is not usually used.
     * Google Developers API uses this status if a particular developer has exceeded the daily limit on requests.
     */
    HttpStatusCode[HttpStatusCode["PaymentRequired"] = 402] = "PaymentRequired";
    /**
     * The request was valid, but the server is refusing action.
     * The user might not have the necessary permissions for a resource.
     */
    HttpStatusCode[HttpStatusCode["Forbidden"] = 403] = "Forbidden";
    /**
     * The requested resource could not be found but may be available in the future.
     * Subsequent requests by the client are permissible.
     */
    HttpStatusCode[HttpStatusCode["NotFound"] = 404] = "NotFound";
    /**
     * A request method is not supported for the requested resource;
     * for example, a GET request on a form that requires data to be presented via POST, or a PUT request on a read-only resource.
     */
    HttpStatusCode[HttpStatusCode["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    /**
     * The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.
     */
    HttpStatusCode[HttpStatusCode["NotAcceptable"] = 406] = "NotAcceptable";
    /**
     * The client must first authenticate itself with the proxy.
     */
    HttpStatusCode[HttpStatusCode["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
    /**
     * The server timed out waiting for the request.
     * According to HTTP specifications:
     * "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time."
     */
    HttpStatusCode[HttpStatusCode["RequestTimeout"] = 408] = "RequestTimeout";
    /**
     * Indicates that the request could not be processed because of conflict in the request,
     * such as an edit conflict between multiple simultaneous updates.
     */
    HttpStatusCode[HttpStatusCode["Conflict"] = 409] = "Conflict";
    /**
     * Indicates that the resource requested is no longer available and will not be available again.
     * This should be used when a resource has been intentionally removed and the resource should be purged.
     * Upon receiving a 410 status code, the client should not request the resource in the future.
     * Clients such as search engines should remove the resource from their indices.
     * Most use cases do not require clients and search engines to purge the resource, and a "404 Not Found" may be used instead.
     */
    HttpStatusCode[HttpStatusCode["Gone"] = 410] = "Gone";
    /**
     * The request did not specify the length of its content, which is required by the requested resource.
     */
    HttpStatusCode[HttpStatusCode["LengthRequired"] = 411] = "LengthRequired";
    /**
     * The server does not meet one of the preconditions that the requester put on the request.
     */
    HttpStatusCode[HttpStatusCode["PreconditionFailed"] = 412] = "PreconditionFailed";
    /**
     * The request is larger than the server is willing or able to process. Previously called "Request Entity Too Large".
     */
    HttpStatusCode[HttpStatusCode["PayloadTooLarge"] = 413] = "PayloadTooLarge";
    /**
     * The URI provided was too long for the server to process. Often the result of too much data being encoded as a query-string of a GET request,
     * in which case it should be converted to a POST request.
     * Called "Request-URI Too Long" previously.
     */
    HttpStatusCode[HttpStatusCode["UriTooLong"] = 414] = "UriTooLong";
    /**
     * The request entity has a media type which the server or resource does not support.
     * For example, the client uploads an image as image/svg+xml, but the server requires that images use a different format.
     */
    HttpStatusCode[HttpStatusCode["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    /**
     * The client has asked for a portion of the file (byte serving), but the server cannot supply that portion.
     * For example, if the client asked for a part of the file that lies beyond the end of the file.
     * Called "Requested Range Not Satisfiable" previously.
     */
    HttpStatusCode[HttpStatusCode["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
    /**
     * The server cannot meet the requirements of the Expect request-header field.
     */
    HttpStatusCode[HttpStatusCode["ExpectationFailed"] = 417] = "ExpectationFailed";
    /**
     * This code was defined in 1998 as one of the traditional IETF April Fools' jokes, in RFC 2324, Hyper Text Coffee Pot Control Protocol,
     * and is not expected to be implemented by actual HTTP servers. The RFC specifies this code should be returned by
     * teapots requested to brew coffee. This HTTP status is used as an Easter egg in some websites, including Google.com.
     */
    HttpStatusCode[HttpStatusCode["IAmATeapot"] = 418] = "IAmATeapot";
    /**
     * The request was directed at a server that is not able to produce a response (for example because a connection reuse).
     */
    HttpStatusCode[HttpStatusCode["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    /**
     * The request was well-formed but was unable to be followed due to semantic errors.
     */
    HttpStatusCode[HttpStatusCode["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    /**
     * The resource that is being accessed is locked.
     */
    HttpStatusCode[HttpStatusCode["Locked"] = 423] = "Locked";
    /**
     * The request failed due to failure of a previous request (e.g., a PROPPATCH).
     */
    HttpStatusCode[HttpStatusCode["FailedDependency"] = 424] = "FailedDependency";
    /**
     * The client should switch to a different protocol such as TLS/1.0, given in the Upgrade header field.
     */
    HttpStatusCode[HttpStatusCode["UpgradeRequired"] = 426] = "UpgradeRequired";
    /**
     * The origin server requires the request to be conditional.
     * Intended to prevent "the 'lost update' problem, where a client
     * GETs a resource's state, modifies it, and PUTs it back to the server,
     * when meanwhile a third party has modified the state on the server, leading to a conflict."
     */
    HttpStatusCode[HttpStatusCode["PreconditionRequired"] = 428] = "PreconditionRequired";
    /**
     * The user has sent too many requests in a given amount of time. Intended for use with rate-limiting schemes.
     */
    HttpStatusCode[HttpStatusCode["TooManyRequests"] = 429] = "TooManyRequests";
    /**
     * The server is unwilling to process the request because either an individual header field,
     * or all the header fields collectively, are too large.
     */
    HttpStatusCode[HttpStatusCode["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    /**
     * A server operator has received a legal demand to deny access to a resource or to a set of resources
     * that includes the requested resource. The code 451 was chosen as a reference to the novel Fahrenheit 451.
     */
    HttpStatusCode[HttpStatusCode["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    // #endregion
    // **********************************************************************************************************
    // #region - 500s - Serve messed up
    // **********************************************************************************************************
    /**
     * A generic error message, given when an unexpected condition was encountered and no more specific message is suitable.
     */
    HttpStatusCode[HttpStatusCode["InternalServerError"] = 500] = "InternalServerError";
    /**
     * The server either does not recognize the request method, or it lacks the ability to fulfill the request.
     * Usually this implies future availability (e.g., a new feature of a web-service API).
     */
    HttpStatusCode[HttpStatusCode["NotImplemented"] = 501] = "NotImplemented";
    /**
     * The server was acting as a gateway or proxy and received an invalid response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["BadGateway"] = 502] = "BadGateway";
    /**
     * The server is currently unavailable (because it is overloaded or down for maintenance).
     * Generally, this is a temporary state.
     */
    HttpStatusCode[HttpStatusCode["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    /**
     * The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["GatewayTimeout"] = 504] = "GatewayTimeout";
    /**
     * The server does not support the HTTP protocol version used in the request
     */
    HttpStatusCode[HttpStatusCode["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
    /**
     * Transparent content negotiation for the request results in a circular reference.
     */
    HttpStatusCode[HttpStatusCode["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    /**
     * The server is unable to store the representation needed to complete the request.
     */
    HttpStatusCode[HttpStatusCode["InsufficientStorage"] = 507] = "InsufficientStorage";
    /**
     * The server detected an infinite loop while processing the request.
     */
    HttpStatusCode[HttpStatusCode["LoopDetected"] = 508] = "LoopDetected";
    /**
     * Further extensions to the request are required for the server to fulfill it.
     */
    HttpStatusCode[HttpStatusCode["NotExtended"] = 510] = "NotExtended";
    /**
     * The client needs to authenticate to gain network access.
     * Intended for use by intercepting proxies used to control access to the network (e.g., "captive portals" used
     * to require agreement to Terms of Service before granting full Internet access via a Wi-Fi hotspot).
     */
    HttpStatusCode[HttpStatusCode["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
    // #endregion
})(HttpStatusCode || (HttpStatusCode = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/kdf-config.ts
class KdfConfig {
    constructor(iterations, memory, parallelism) {
        this.iterations = iterations;
        this.memory = memory;
        this.parallelism = parallelism;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/kdf-type.enum.ts

var KdfType;
(function (KdfType) {
    KdfType[KdfType["PBKDF2_SHA256"] = 0] = "PBKDF2_SHA256";
    KdfType[KdfType["Argon2id"] = 1] = "Argon2id";
})(KdfType || (KdfType = {}));
const DEFAULT_ARGON2_MEMORY = 64;
const DEFAULT_ARGON2_PARALLELISM = 4;
const DEFAULT_ARGON2_ITERATIONS = 3;
const DEFAULT_KDF_TYPE = KdfType.PBKDF2_SHA256;
const DEFAULT_PBKDF2_ITERATIONS = 600000;
const DEFAULT_KDF_CONFIG = new KdfConfig(DEFAULT_PBKDF2_ITERATIONS);
const SEND_KDF_ITERATIONS = 100000;

;// CONCATENATED MODULE: ../../libs/common/src/enums/key-suffix-options.enum.ts
var KeySuffixOptions;
(function (KeySuffixOptions) {
    KeySuffixOptions["Auto"] = "auto";
    KeySuffixOptions["Biometric"] = "biometric";
})(KeySuffixOptions || (KeySuffixOptions = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/linked-id-type.enum.ts
// LoginView
var LoginLinkedId;
(function (LoginLinkedId) {
    LoginLinkedId[LoginLinkedId["Username"] = 100] = "Username";
    LoginLinkedId[LoginLinkedId["Password"] = 101] = "Password";
})(LoginLinkedId || (LoginLinkedId = {}));
// CardView
var CardLinkedId;
(function (CardLinkedId) {
    CardLinkedId[CardLinkedId["CardholderName"] = 300] = "CardholderName";
    CardLinkedId[CardLinkedId["ExpMonth"] = 301] = "ExpMonth";
    CardLinkedId[CardLinkedId["ExpYear"] = 302] = "ExpYear";
    CardLinkedId[CardLinkedId["Code"] = 303] = "Code";
    CardLinkedId[CardLinkedId["Brand"] = 304] = "Brand";
    CardLinkedId[CardLinkedId["Number"] = 305] = "Number";
})(CardLinkedId || (CardLinkedId = {}));
// IdentityView
var IdentityLinkedId;
(function (IdentityLinkedId) {
    IdentityLinkedId[IdentityLinkedId["Title"] = 400] = "Title";
    IdentityLinkedId[IdentityLinkedId["MiddleName"] = 401] = "MiddleName";
    IdentityLinkedId[IdentityLinkedId["Address1"] = 402] = "Address1";
    IdentityLinkedId[IdentityLinkedId["Address2"] = 403] = "Address2";
    IdentityLinkedId[IdentityLinkedId["Address3"] = 404] = "Address3";
    IdentityLinkedId[IdentityLinkedId["City"] = 405] = "City";
    IdentityLinkedId[IdentityLinkedId["State"] = 406] = "State";
    IdentityLinkedId[IdentityLinkedId["PostalCode"] = 407] = "PostalCode";
    IdentityLinkedId[IdentityLinkedId["Country"] = 408] = "Country";
    IdentityLinkedId[IdentityLinkedId["Company"] = 409] = "Company";
    IdentityLinkedId[IdentityLinkedId["Email"] = 410] = "Email";
    IdentityLinkedId[IdentityLinkedId["Phone"] = 411] = "Phone";
    IdentityLinkedId[IdentityLinkedId["Ssn"] = 412] = "Ssn";
    IdentityLinkedId[IdentityLinkedId["Username"] = 413] = "Username";
    IdentityLinkedId[IdentityLinkedId["PassportNumber"] = 414] = "PassportNumber";
    IdentityLinkedId[IdentityLinkedId["LicenseNumber"] = 415] = "LicenseNumber";
    IdentityLinkedId[IdentityLinkedId["FirstName"] = 416] = "FirstName";
    IdentityLinkedId[IdentityLinkedId["LastName"] = 417] = "LastName";
    IdentityLinkedId[IdentityLinkedId["FullName"] = 418] = "FullName";
})(IdentityLinkedId || (IdentityLinkedId = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/log-level-type.enum.ts
var LogLevelType;
(function (LogLevelType) {
    LogLevelType[LogLevelType["Debug"] = 0] = "Debug";
    LogLevelType[LogLevelType["Info"] = 1] = "Info";
    LogLevelType[LogLevelType["Warning"] = 2] = "Warning";
    LogLevelType[LogLevelType["Error"] = 3] = "Error";
})(LogLevelType || (LogLevelType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/native-messaging-version.enum.ts
var NativeMessagingVersion;
(function (NativeMessagingVersion) {
    NativeMessagingVersion[NativeMessagingVersion["One"] = 1] = "One";
    NativeMessagingVersion[NativeMessagingVersion["Latest"] = 1] = "Latest";
})(NativeMessagingVersion || (NativeMessagingVersion = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/notification-type.enum.ts
var NotificationType;
(function (NotificationType) {
    NotificationType[NotificationType["SyncCipherUpdate"] = 0] = "SyncCipherUpdate";
    NotificationType[NotificationType["SyncCipherCreate"] = 1] = "SyncCipherCreate";
    NotificationType[NotificationType["SyncLoginDelete"] = 2] = "SyncLoginDelete";
    NotificationType[NotificationType["SyncFolderDelete"] = 3] = "SyncFolderDelete";
    NotificationType[NotificationType["SyncCiphers"] = 4] = "SyncCiphers";
    NotificationType[NotificationType["SyncVault"] = 5] = "SyncVault";
    NotificationType[NotificationType["SyncOrgKeys"] = 6] = "SyncOrgKeys";
    NotificationType[NotificationType["SyncFolderCreate"] = 7] = "SyncFolderCreate";
    NotificationType[NotificationType["SyncFolderUpdate"] = 8] = "SyncFolderUpdate";
    NotificationType[NotificationType["SyncCipherDelete"] = 9] = "SyncCipherDelete";
    NotificationType[NotificationType["SyncSettings"] = 10] = "SyncSettings";
    NotificationType[NotificationType["LogOut"] = 11] = "LogOut";
    NotificationType[NotificationType["SyncSendCreate"] = 12] = "SyncSendCreate";
    NotificationType[NotificationType["SyncSendUpdate"] = 13] = "SyncSendUpdate";
    NotificationType[NotificationType["SyncSendDelete"] = 14] = "SyncSendDelete";
    NotificationType[NotificationType["AuthRequest"] = 15] = "AuthRequest";
    NotificationType[NotificationType["AuthRequestResponse"] = 16] = "AuthRequestResponse";
})(NotificationType || (NotificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/product-type.enum.ts
var ProductType;
(function (ProductType) {
    ProductType[ProductType["Free"] = 0] = "Free";
    ProductType[ProductType["Families"] = 1] = "Families";
    ProductType[ProductType["Teams"] = 2] = "Teams";
    ProductType[ProductType["Enterprise"] = 3] = "Enterprise";
})(ProductType || (ProductType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/provider-type.enum.ts
var ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
})(ProviderType || (ProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/secure-note-type.enum.ts
var SecureNoteType;
(function (SecureNoteType) {
    SecureNoteType[SecureNoteType["Generic"] = 0] = "Generic";
})(SecureNoteType || (SecureNoteType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/state-version.enum.ts
var StateVersion;
(function (StateVersion) {
    StateVersion[StateVersion["One"] = 1] = "One";
    StateVersion[StateVersion["Two"] = 2] = "Two";
    StateVersion[StateVersion["Three"] = 3] = "Three";
    StateVersion[StateVersion["Four"] = 4] = "Four";
    StateVersion[StateVersion["Five"] = 5] = "Five";
    StateVersion[StateVersion["Six"] = 6] = "Six";
    StateVersion[StateVersion["Seven"] = 7] = "Seven";
    StateVersion[StateVersion["Latest"] = 7] = "Latest";
})(StateVersion || (StateVersion = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/storage-location.enum.ts
var StorageLocation;
(function (StorageLocation) {
    StorageLocation["Both"] = "both";
    StorageLocation["Disk"] = "disk";
    StorageLocation["Memory"] = "memory";
})(StorageLocation || (StorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/theme-type.enum.ts
var ThemeType;
(function (ThemeType) {
    ThemeType["System"] = "system";
    ThemeType["Light"] = "light";
    ThemeType["Dark"] = "dark";
    ThemeType["Nord"] = "nord";
    ThemeType["SolarizedDark"] = "solarizedDark";
})(ThemeType || (ThemeType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/uri-match-type.enum.ts
var UriMatchType;
(function (UriMatchType) {
    UriMatchType[UriMatchType["Domain"] = 0] = "Domain";
    UriMatchType[UriMatchType["Host"] = 1] = "Host";
    UriMatchType[UriMatchType["StartsWith"] = 2] = "StartsWith";
    UriMatchType[UriMatchType["Exact"] = 3] = "Exact";
    UriMatchType[UriMatchType["RegularExpression"] = 4] = "RegularExpression";
    UriMatchType[UriMatchType["Never"] = 5] = "Never";
})(UriMatchType || (UriMatchType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/index.ts

























;// CONCATENATED MODULE: ../../libs/common/src/models/domain/enc-string.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class EncString {
    constructor(encryptedStringOrType, data, iv, mac) {
        if (data != null) {
            this.initFromData(encryptedStringOrType, data, iv, mac);
        }
        else {
            this.initFromEncryptedString(encryptedStringOrType);
        }
    }
    get ivBytes() {
        return this.iv == null ? null : utils_Utils.fromB64ToArray(this.iv).buffer;
    }
    get macBytes() {
        return this.mac == null ? null : utils_Utils.fromB64ToArray(this.mac).buffer;
    }
    get dataBytes() {
        return this.data == null ? null : utils_Utils.fromB64ToArray(this.data).buffer;
    }
    toJSON() {
        return this.encryptedString;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return new EncString(obj);
    }
    initFromData(encType, data, iv, mac) {
        if (iv != null) {
            this.encryptedString = encType + "." + iv + "|" + data;
        }
        else {
            this.encryptedString = encType + "." + data;
        }
        // mac
        if (mac != null) {
            this.encryptedString += "|" + mac;
        }
        this.encryptionType = encType;
        this.data = data;
        this.iv = iv;
        this.mac = mac;
    }
    initFromEncryptedString(encryptedString) {
        this.encryptedString = encryptedString;
        if (!this.encryptedString) {
            return;
        }
        const { encType, encPieces } = EncString.parseEncryptedString(this.encryptedString);
        this.encryptionType = encType;
        if (encPieces.length !== EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType]) {
            return;
        }
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                this.mac = encPieces[2];
                break;
            case EncryptionType.AesCbc256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                break;
            case EncryptionType.Rsa2048_OaepSha256_B64:
            case EncryptionType.Rsa2048_OaepSha1_B64:
                this.data = encPieces[0];
                break;
            default:
                return;
        }
    }
    static parseEncryptedString(encryptedString) {
        const headerPieces = encryptedString.split(".");
        let encType;
        let encPieces = null;
        if (headerPieces.length === 2) {
            try {
                encType = parseInt(headerPieces[0], null);
                encPieces = headerPieces[1].split("|");
            }
            catch (e) {
                return;
            }
        }
        else {
            encPieces = encryptedString.split("|");
            encType =
                encPieces.length === 3
                    ? EncryptionType.AesCbc128_HmacSha256_B64
                    : EncryptionType.AesCbc256_B64;
        }
        return {
            encType,
            encPieces,
        };
    }
    static isSerializedEncString(s) {
        const { encType, encPieces } = this.parseEncryptedString(s);
        return EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType] === encPieces.length;
    }
    decrypt(orgId, key = null) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.decryptedValue != null) {
                return this.decryptedValue;
            }
            try {
                if (key == null) {
                    key = yield this.getKeyForDecryption(orgId);
                }
                if (key == null) {
                    throw new Error("No key to decrypt EncString with orgId " + orgId);
                }
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                this.decryptedValue = yield encryptService.decryptToUtf8(this, key);
            }
            catch (e) {
                this.decryptedValue = "[error: cannot decrypt]";
            }
            return this.decryptedValue;
        });
    }
    getKeyForDecryption(orgId) {
        return __awaiter(this, void 0, void 0, function* () {
            const cryptoService = utils_Utils.getContainerService().getCryptoService();
            return orgId != null
                ? yield cryptoService.getOrgKey(orgId)
                : yield cryptoService.getKeyForUserEncryption();
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/domain-base.ts
var domain_base_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// https://contributing.bitwarden.com/architecture/clients/data-model#domain
class Domain {
    buildDomainModel(domain, dataObj, map, notEncList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = dataObj[map[prop] || prop];
            if (notEncList.indexOf(prop) > -1) {
                domain[prop] = objProp ? objProp : null;
            }
            else {
                domain[prop] = objProp ? new EncString(objProp) : null;
            }
        }
    }
    buildDataModel(domain, dataObj, map, notEncStringList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = domain[map[prop] || prop];
            if (notEncStringList.indexOf(prop) > -1) {
                dataObj[prop] = objProp != null ? objProp : null;
            }
            else {
                dataObj[prop] = objProp != null ? objProp.encryptedString : null;
            }
        }
    }
    decryptObj(viewModel, map, orgId, key = null) {
        return domain_base_awaiter(this, void 0, void 0, function* () {
            const promises = [];
            const self = this;
            for (const prop in map) {
                // eslint-disable-next-line
                if (!map.hasOwnProperty(prop)) {
                    continue;
                }
                (function (theProp) {
                    const p = Promise.resolve()
                        .then(() => {
                        const mapProp = map[theProp] || theProp;
                        if (self[mapProp]) {
                            return self[mapProp].decrypt(orgId, key);
                        }
                        return null;
                    })
                        .then((val) => {
                        viewModel[theProp] = val;
                    });
                    promises.push(p);
                })(prop);
            }
            yield Promise.all(promises);
            return viewModel;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/view/collection.view.ts

const NestingDelimiter = "/";
class CollectionView {
    constructor(c) {
        this.id = null;
        this.organizationId = null;
        this.name = null;
        this.externalId = null;
        this.readOnly = null;
        this.hidePasswords = null;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.externalId = c.externalId;
        if (c instanceof Collection) {
            this.readOnly = c.readOnly;
            this.hidePasswords = c.hidePasswords;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/collection.ts


class Collection extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            name: null,
            externalId: null,
            readOnly: null,
            hidePasswords: null,
        }, ["id", "organizationId", "externalId", "readOnly", "hidePasswords"]);
    }
    decrypt() {
        return this.decryptObj(new CollectionView(this), {
            name: null,
        }, this.organizationId);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/collection.service.ts
var collection_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const collection_service_NestingDelimiter = "/";
class CollectionService {
    constructor(cryptoService, i18nService, stateService) {
        this.cryptoService = cryptoService;
        this.i18nService = i18nService;
        this.stateService = stateService;
    }
    clearCache(userId) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDecryptedCollections(null, { userId: userId });
        });
    }
    encrypt(model) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            if (model.organizationId == null) {
                throw new Error("Collection has no organization id.");
            }
            const key = yield this.cryptoService.getOrgKey(model.organizationId);
            if (key == null) {
                throw new Error("No key for this collection's organization.");
            }
            const collection = new Collection();
            collection.id = model.id;
            collection.organizationId = model.organizationId;
            collection.readOnly = model.readOnly;
            collection.name = yield this.cryptoService.encrypt(model.name, key);
            return collection;
        });
    }
    decryptMany(collections) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            if (collections == null) {
                return [];
            }
            const decCollections = [];
            const promises = [];
            collections.forEach((collection) => {
                promises.push(collection.decrypt().then((c) => decCollections.push(c)));
            });
            yield Promise.all(promises);
            return decCollections.sort(utils_Utils.getSortFunction(this.i18nService, "name"));
        });
    }
    get(id) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            const collections = yield this.stateService.getEncryptedCollections();
            // eslint-disable-next-line
            if (collections == null || !collections.hasOwnProperty(id)) {
                return null;
            }
            return new Collection(collections[id]);
        });
    }
    getAll() {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            const collections = yield this.stateService.getEncryptedCollections();
            const response = [];
            for (const id in collections) {
                // eslint-disable-next-line
                if (collections.hasOwnProperty(id)) {
                    response.push(new Collection(collections[id]));
                }
            }
            return response;
        });
    }
    getAllDecrypted() {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            let decryptedCollections = yield this.stateService.getDecryptedCollections();
            if (decryptedCollections != null) {
                return decryptedCollections;
            }
            const hasKey = yield this.cryptoService.hasKey();
            if (!hasKey) {
                throw new Error("No key.");
            }
            const collections = yield this.getAll();
            decryptedCollections = yield this.decryptMany(collections);
            yield this.stateService.setDecryptedCollections(decryptedCollections);
            return decryptedCollections;
        });
    }
    getAllNested(collections = null) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            if (collections == null) {
                collections = yield this.getAllDecrypted();
            }
            const nodes = [];
            collections.forEach((c) => {
                const collectionCopy = new CollectionView();
                collectionCopy.id = c.id;
                collectionCopy.organizationId = c.organizationId;
                const parts = c.name != null ? c.name.replace(/^\/+|\/+$/g, "").split(collection_service_NestingDelimiter) : [];
                ServiceUtils.nestedTraverse(nodes, 0, parts, collectionCopy, null, collection_service_NestingDelimiter);
            });
            return nodes;
        });
    }
    /**
     * @deprecated August 30 2022: Moved to new Vault Filter Service
     * Remove when Desktop and Browser are updated
     */
    getNested(id) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            const collections = yield this.getAllNested();
            return ServiceUtils.getTreeNodeObjectFromList(collections, id);
        });
    }
    upsert(collection) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            let collections = yield this.stateService.getEncryptedCollections();
            if (collections == null) {
                collections = {};
            }
            if (collection instanceof CollectionData) {
                const c = collection;
                collections[c.id] = c;
            }
            else {
                collection.forEach((c) => {
                    collections[c.id] = c;
                });
            }
            yield this.replace(collections);
        });
    }
    replace(collections) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearCache();
            yield this.stateService.setEncryptedCollections(collections);
        });
    }
    clear(userId) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearCache(userId);
            yield this.stateService.setEncryptedCollections(null, { userId: userId });
        });
    }
    delete(id) {
        return collection_service_awaiter(this, void 0, void 0, function* () {
            const collections = yield this.stateService.getEncryptedCollections();
            if (collections == null) {
                return;
            }
            if (typeof id === "string") {
                delete collections[id];
            }
            else {
                id.forEach((i) => {
                    delete collections[i];
                });
            }
            yield this.replace(collections);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/base.response.ts
class BaseResponse {
    constructor(response) {
        this.response = response;
    }
    getResponseProperty(propertyName, response = null, exactName = false) {
        if (propertyName == null || propertyName === "") {
            throw new Error("propertyName must not be null/empty.");
        }
        if (response == null && this.response != null) {
            response = this.response;
        }
        if (response == null) {
            return null;
        }
        if (!exactName && response[propertyName] === undefined) {
            let otherCasePropertyName = null;
            if (propertyName.charAt(0) === propertyName.charAt(0).toUpperCase()) {
                otherCasePropertyName = propertyName.charAt(0).toLowerCase();
            }
            else {
                otherCasePropertyName = propertyName.charAt(0).toUpperCase();
            }
            if (propertyName.length > 1) {
                otherCasePropertyName += propertyName.slice(1);
            }
            propertyName = otherCasePropertyName;
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toLowerCase();
            }
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toUpperCase();
            }
        }
        return response[propertyName];
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/api-key.response.ts

class ApiKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.apiKey = this.getResponseProperty("ApiKey");
        this.revisionDate = new Date(this.getResponseProperty("RevisionDate"));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/sso.ts
var SsoType;
(function (SsoType) {
    SsoType[SsoType["None"] = 0] = "None";
    SsoType[SsoType["OpenIdConnect"] = 1] = "OpenIdConnect";
    SsoType[SsoType["Saml2"] = 2] = "Saml2";
})(SsoType || (SsoType = {}));
var OpenIdConnectRedirectBehavior;
(function (OpenIdConnectRedirectBehavior) {
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["RedirectGet"] = 0] = "RedirectGet";
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["FormPost"] = 1] = "FormPost";
})(OpenIdConnectRedirectBehavior || (OpenIdConnectRedirectBehavior = {}));
var Saml2BindingType;
(function (Saml2BindingType) {
    Saml2BindingType[Saml2BindingType["HttpRedirect"] = 1] = "HttpRedirect";
    Saml2BindingType[Saml2BindingType["HttpPost"] = 2] = "HttpPost";
})(Saml2BindingType || (Saml2BindingType = {}));
var Saml2NameIdFormat;
(function (Saml2NameIdFormat) {
    Saml2NameIdFormat[Saml2NameIdFormat["NotConfigured"] = 0] = "NotConfigured";
    Saml2NameIdFormat[Saml2NameIdFormat["Unspecified"] = 1] = "Unspecified";
    Saml2NameIdFormat[Saml2NameIdFormat["EmailAddress"] = 2] = "EmailAddress";
    Saml2NameIdFormat[Saml2NameIdFormat["X509SubjectName"] = 3] = "X509SubjectName";
    Saml2NameIdFormat[Saml2NameIdFormat["WindowsDomainQualifiedName"] = 4] = "WindowsDomainQualifiedName";
    Saml2NameIdFormat[Saml2NameIdFormat["KerberosPrincipalName"] = 5] = "KerberosPrincipalName";
    Saml2NameIdFormat[Saml2NameIdFormat["EntityIdentifier"] = 6] = "EntityIdentifier";
    Saml2NameIdFormat[Saml2NameIdFormat["Persistent"] = 7] = "Persistent";
    Saml2NameIdFormat[Saml2NameIdFormat["Transient"] = 8] = "Transient";
})(Saml2NameIdFormat || (Saml2NameIdFormat = {}));
var Saml2SigningBehavior;
(function (Saml2SigningBehavior) {
    Saml2SigningBehavior[Saml2SigningBehavior["IfIdpWantAuthnRequestsSigned"] = 0] = "IfIdpWantAuthnRequestsSigned";
    Saml2SigningBehavior[Saml2SigningBehavior["Always"] = 1] = "Always";
    Saml2SigningBehavior[Saml2SigningBehavior["Never"] = 3] = "Never";
})(Saml2SigningBehavior || (Saml2SigningBehavior = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/api/sso-config.api.ts


class SsoConfigApi extends BaseResponse {
    static fromView(view, api = new SsoConfigApi()) {
        api.configType = view.configType;
        api.keyConnectorEnabled = view.keyConnectorEnabled;
        api.keyConnectorUrl = view.keyConnectorUrl;
        if (api.configType === SsoType.OpenIdConnect) {
            api.authority = view.openId.authority;
            api.clientId = view.openId.clientId;
            api.clientSecret = view.openId.clientSecret;
            api.metadataAddress = view.openId.metadataAddress;
            api.redirectBehavior = view.openId.redirectBehavior;
            api.getClaimsFromUserInfoEndpoint = view.openId.getClaimsFromUserInfoEndpoint;
            api.additionalScopes = view.openId.additionalScopes;
            api.additionalUserIdClaimTypes = view.openId.additionalUserIdClaimTypes;
            api.additionalEmailClaimTypes = view.openId.additionalEmailClaimTypes;
            api.additionalNameClaimTypes = view.openId.additionalNameClaimTypes;
            api.acrValues = view.openId.acrValues;
            api.expectedReturnAcrValue = view.openId.expectedReturnAcrValue;
        }
        else if (api.configType === SsoType.Saml2) {
            api.spNameIdFormat = view.saml.spNameIdFormat;
            api.spOutboundSigningAlgorithm = view.saml.spOutboundSigningAlgorithm;
            api.spSigningBehavior = view.saml.spSigningBehavior;
            api.spMinIncomingSigningAlgorithm = view.saml.spMinIncomingSigningAlgorithm;
            api.spWantAssertionsSigned = view.saml.spWantAssertionsSigned;
            api.spValidateCertificates = view.saml.spValidateCertificates;
            api.idpEntityId = view.saml.idpEntityId;
            api.idpBindingType = view.saml.idpBindingType;
            api.idpSingleSignOnServiceUrl = view.saml.idpSingleSignOnServiceUrl;
            api.idpSingleLogoutServiceUrl = view.saml.idpSingleLogoutServiceUrl;
            api.idpX509PublicCert = view.saml.idpX509PublicCert;
            api.idpOutboundSigningAlgorithm = view.saml.idpOutboundSigningAlgorithm;
            api.idpAllowUnsolicitedAuthnResponse = view.saml.idpAllowUnsolicitedAuthnResponse;
            api.idpWantAuthnRequestsSigned = view.saml.idpWantAuthnRequestsSigned;
            // Value is inverted in the api model (disable instead of allow)
            api.idpDisableOutboundLogoutRequests = !view.saml.idpAllowOutboundLogoutRequests;
        }
        return api;
    }
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.configType = this.getResponseProperty("ConfigType");
        this.keyConnectorEnabled = this.getResponseProperty("KeyConnectorEnabled");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.authority = this.getResponseProperty("Authority");
        this.clientId = this.getResponseProperty("ClientId");
        this.clientSecret = this.getResponseProperty("ClientSecret");
        this.metadataAddress = this.getResponseProperty("MetadataAddress");
        this.redirectBehavior = this.getResponseProperty("RedirectBehavior");
        this.getClaimsFromUserInfoEndpoint = this.getResponseProperty("GetClaimsFromUserInfoEndpoint");
        this.additionalScopes = this.getResponseProperty("AdditionalScopes");
        this.additionalUserIdClaimTypes = this.getResponseProperty("AdditionalUserIdClaimTypes");
        this.additionalEmailClaimTypes = this.getResponseProperty("AdditionalEmailClaimTypes");
        this.additionalNameClaimTypes = this.getResponseProperty("AdditionalNameClaimTypes");
        this.acrValues = this.getResponseProperty("AcrValues");
        this.expectedReturnAcrValue = this.getResponseProperty("ExpectedReturnAcrValue");
        this.spNameIdFormat = this.getResponseProperty("SpNameIdFormat");
        this.spOutboundSigningAlgorithm = this.getResponseProperty("SpOutboundSigningAlgorithm");
        this.spSigningBehavior = this.getResponseProperty("SpSigningBehavior");
        this.spMinIncomingSigningAlgorithm = this.getResponseProperty("SpMinIncomingSigningAlgorithm");
        this.spWantAssertionsSigned = this.getResponseProperty("SpWantAssertionsSigned");
        this.spValidateCertificates = this.getResponseProperty("SpValidateCertificates");
        this.idpEntityId = this.getResponseProperty("IdpEntityId");
        this.idpBindingType = this.getResponseProperty("IdpBindingType");
        this.idpSingleSignOnServiceUrl = this.getResponseProperty("IdpSingleSignOnServiceUrl");
        this.idpSingleLogoutServiceUrl = this.getResponseProperty("IdpSingleLogoutServiceUrl");
        this.idpX509PublicCert = this.getResponseProperty("IdpX509PublicCert");
        this.idpOutboundSigningAlgorithm = this.getResponseProperty("IdpOutboundSigningAlgorithm");
        this.idpAllowUnsolicitedAuthnResponse = this.getResponseProperty("IdpAllowUnsolicitedAuthnResponse");
        this.idpDisableOutboundLogoutRequests = this.getResponseProperty("IdpDisableOutboundLogoutRequests");
        this.idpWantAuthnRequestsSigned = this.getResponseProperty("IdpWantAuthnRequestsSigned");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/organization-sso.response.ts


class OrganizationSsoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.enabled = this.getResponseProperty("Enabled");
        this.identifier = this.getResponseProperty("Identifier");
        this.data =
            this.getResponseProperty("Data") != null
                ? new SsoConfigApi(this.getResponseProperty("Data"))
                : null;
        this.urls = new SsoUrls(this.getResponseProperty("Urls"));
    }
}
class SsoUrls extends BaseResponse {
    constructor(response) {
        super(response);
        this.callbackPath = this.getResponseProperty("CallbackPath");
        this.signedOutCallbackPath = this.getResponseProperty("SignedOutCallbackPath");
        this.spEntityId = this.getResponseProperty("SpEntityId");
        this.spMetadataUrl = this.getResponseProperty("SpMetadataUrl");
        this.spAcsUrl = this.getResponseProperty("SpAcsUrl");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/billing.response.ts

class BillingResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.invoices = [];
        this.transactions = [];
        this.balance = this.getResponseProperty("Balance");
        const paymentSource = this.getResponseProperty("PaymentSource");
        const transactions = this.getResponseProperty("Transactions");
        const invoices = this.getResponseProperty("Invoices");
        this.paymentSource = paymentSource == null ? null : new BillingSourceResponse(paymentSource);
        if (transactions != null) {
            this.transactions = transactions.map((t) => new BillingTransactionResponse(t));
        }
        if (invoices != null) {
            this.invoices = invoices.map((i) => new BillingInvoiceResponse(i));
        }
    }
    get hasNoHistory() {
        return this.invoices.length == 0 && this.transactions.length == 0;
    }
}
class BillingSourceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.cardBrand = this.getResponseProperty("CardBrand");
        this.description = this.getResponseProperty("Description");
        this.needsVerification = this.getResponseProperty("NeedsVerification");
    }
}
class BillingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.url = this.getResponseProperty("Url");
        this.pdfUrl = this.getResponseProperty("PdfUrl");
        this.number = this.getResponseProperty("Number");
        this.paid = this.getResponseProperty("Paid");
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}
class BillingTransactionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.createdDate = this.getResponseProperty("CreatedDate");
        this.amount = this.getResponseProperty("Amount");
        this.refunded = this.getResponseProperty("Refunded");
        this.partiallyRefunded = this.getResponseProperty("PartiallyRefunded");
        this.refundedAmount = this.getResponseProperty("RefundedAmount");
        this.type = this.getResponseProperty("Type");
        this.paymentMethodType = this.getResponseProperty("PaymentMethodType");
        this.details = this.getResponseProperty("Details");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/plan.response.ts

class PlanResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.product = this.getResponseProperty("Product");
        this.name = this.getResponseProperty("Name");
        this.isAnnual = this.getResponseProperty("IsAnnual");
        this.nameLocalizationKey = this.getResponseProperty("NameLocalizationKey");
        this.descriptionLocalizationKey = this.getResponseProperty("DescriptionLocalizationKey");
        this.canBeUsedByBusiness = this.getResponseProperty("CanBeUsedByBusiness");
        this.baseSeats = this.getResponseProperty("BaseSeats");
        this.baseStorageGb = this.getResponseProperty("BaseStorageGb");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxUsers = this.getResponseProperty("MaxUsers");
        this.hasAdditionalSeatsOption = this.getResponseProperty("HasAdditionalSeatsOption");
        this.maxAdditionalSeats = this.getResponseProperty("MaxAdditionalSeats");
        this.hasAdditionalStorageOption = this.getResponseProperty("HasAdditionalStorageOption");
        this.maxAdditionalStorage = this.getResponseProperty("MaxAdditionalStorage");
        this.hasPremiumAccessOption = this.getResponseProperty("HasPremiumAccessOption");
        this.trialPeriodDays = this.getResponseProperty("TrialPeriodDays");
        this.hasSelfHost = this.getResponseProperty("HasSelfHost");
        this.hasPolicies = this.getResponseProperty("HasPolicies");
        this.hasGroups = this.getResponseProperty("HasGroups");
        this.hasDirectory = this.getResponseProperty("HasDirectory");
        this.hasEvents = this.getResponseProperty("HasEvents");
        this.hasTotp = this.getResponseProperty("HasTotp");
        this.has2fa = this.getResponseProperty("Has2fa");
        this.hasApi = this.getResponseProperty("HasApi");
        this.hasSso = this.getResponseProperty("HasSso");
        this.hasResetPassword = this.getResponseProperty("HasResetPassword");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.upgradeSortOrder = this.getResponseProperty("UpgradeSortOrder");
        this.displaySortOrder = this.getResponseProperty("SortOrder");
        this.legacyYear = this.getResponseProperty("LegacyYear");
        this.disabled = this.getResponseProperty("Disabled");
        this.stripePlanId = this.getResponseProperty("StripePlanId");
        this.stripeSeatPlanId = this.getResponseProperty("StripeSeatPlanId");
        this.stripeStoragePlanId = this.getResponseProperty("StripeStoragePlanId");
        this.stripePremiumAccessPlanId = this.getResponseProperty("StripePremiumAccessPlanId");
        this.basePrice = this.getResponseProperty("BasePrice");
        this.seatPrice = this.getResponseProperty("SeatPrice");
        this.additionalStoragePricePerGb = this.getResponseProperty("AdditionalStoragePricePerGb");
        this.premiumAccessOptionPrice = this.getResponseProperty("PremiumAccessOptionPrice");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization.response.ts


class OrganizationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.businessName = this.getResponseProperty("BusinessName");
        this.businessAddress1 = this.getResponseProperty("BusinessAddress1");
        this.businessAddress2 = this.getResponseProperty("BusinessAddress2");
        this.businessAddress3 = this.getResponseProperty("BusinessAddress3");
        this.businessCountry = this.getResponseProperty("BusinessCountry");
        this.businessTaxNumber = this.getResponseProperty("BusinessTaxNumber");
        this.billingEmail = this.getResponseProperty("BillingEmail");
        const plan = this.getResponseProperty("Plan");
        this.plan = plan == null ? null : new PlanResponse(plan);
        this.planType = this.getResponseProperty("PlanType");
        this.seats = this.getResponseProperty("Seats");
        this.maxAutoscaleSeats = this.getResponseProperty("MaxAutoscaleSeats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/subscription.response.ts

class SubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.license = this.getResponseProperty("License");
        this.expiration = this.getResponseProperty("Expiration");
        this.usingInAppPurchase = this.getResponseProperty("UsingInAppPurchase");
        const subscription = this.getResponseProperty("Subscription");
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
    }
}
class BillingSubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.items = [];
        this.trialEndDate = this.getResponseProperty("TrialStartDate");
        this.trialEndDate = this.getResponseProperty("TrialEndDate");
        this.periodStartDate = this.getResponseProperty("PeriodStartDate");
        this.periodEndDate = this.getResponseProperty("PeriodEndDate");
        this.cancelledDate = this.getResponseProperty("CancelledDate");
        this.cancelAtEndDate = this.getResponseProperty("CancelAtEndDate");
        this.status = this.getResponseProperty("Status");
        this.cancelled = this.getResponseProperty("Cancelled");
        const items = this.getResponseProperty("Items");
        if (items != null) {
            this.items = items.map((i) => new BillingSubscriptionItemResponse(i));
        }
    }
}
class BillingSubscriptionItemResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.name = this.getResponseProperty("Name");
        this.amount = this.getResponseProperty("Amount");
        this.quantity = this.getResponseProperty("Quantity");
        this.interval = this.getResponseProperty("Interval");
        this.sponsoredSubscriptionItem = this.getResponseProperty("SponsoredSubscriptionItem");
    }
}
class BillingSubscriptionUpcomingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/organization-subscription.response.ts


class OrganizationSubscriptionResponse extends OrganizationResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        const subscription = this.getResponseProperty("Subscription");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
        this.expiration = this.getResponseProperty("Expiration");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/api/permissions.api.ts

class PermissionsApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return this;
        }
        this.accessEventLogs = this.getResponseProperty("AccessEventLogs");
        this.accessImportExport = this.getResponseProperty("AccessImportExport");
        this.accessReports = this.getResponseProperty("AccessReports");
        this.createNewCollections = this.getResponseProperty("CreateNewCollections");
        this.editAnyCollection = this.getResponseProperty("EditAnyCollection");
        this.deleteAnyCollection = this.getResponseProperty("DeleteAnyCollection");
        this.editAssignedCollections = this.getResponseProperty("EditAssignedCollections");
        this.deleteAssignedCollections = this.getResponseProperty("DeleteAssignedCollections");
        this.manageCiphers = this.getResponseProperty("ManageCiphers");
        this.manageGroups = this.getResponseProperty("ManageGroups");
        this.manageSso = this.getResponseProperty("ManageSso");
        this.managePolicies = this.getResponseProperty("ManagePolicies");
        this.manageUsers = this.getResponseProperty("ManageUsers");
        this.manageResetPassword = this.getResponseProperty("ManageResetPassword");
        this.manageScim = this.getResponseProperty("ManageScim");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-organization.response.ts


class ProfileOrganizationResponse extends BaseResponse {
    constructor(response) {
        var _a, _b, _c, _d;
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.usePolicies = this.getResponseProperty("UsePolicies");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useSso = this.getResponseProperty("UseSso");
        this.useKeyConnector = (_a = this.getResponseProperty("UseKeyConnector")) !== null && _a !== void 0 ? _a : false;
        this.useScim = (_b = this.getResponseProperty("UseScim")) !== null && _b !== void 0 ? _b : false;
        this.useCustomPermissions = (_c = this.getResponseProperty("UseCustomPermissions")) !== null && _c !== void 0 ? _c : false;
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.useActivateAutofillPolicy = this.getResponseProperty("UseActivateAutofillPolicy");
        this.selfHost = this.getResponseProperty("SelfHost");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.seats = this.getResponseProperty("Seats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.key = this.getResponseProperty("Key");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.ssoBound = this.getResponseProperty("SsoBound");
        this.identifier = this.getResponseProperty("Identifier");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.userId = this.getResponseProperty("UserId");
        this.providerId = this.getResponseProperty("ProviderId");
        this.providerName = this.getResponseProperty("ProviderName");
        this.providerType = this.getResponseProperty("ProviderType");
        this.familySponsorshipFriendlyName = this.getResponseProperty("FamilySponsorshipFriendlyName");
        this.familySponsorshipAvailable = this.getResponseProperty("FamilySponsorshipAvailable");
        this.planProductType = this.getResponseProperty("PlanProductType");
        this.keyConnectorEnabled = (_d = this.getResponseProperty("KeyConnectorEnabled")) !== null && _d !== void 0 ? _d : false;
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        const familySponsorshipLastSyncDateString = this.getResponseProperty("FamilySponsorshipLastSyncDate");
        if (familySponsorshipLastSyncDateString) {
            this.familySponsorshipLastSyncDate = new Date(familySponsorshipLastSyncDateString);
        }
        const familySponsorshipValidUntilString = this.getResponseProperty("FamilySponsorshipValidUntil");
        if (familySponsorshipValidUntilString) {
            this.familySponsorshipValidUntil = new Date(familySponsorshipValidUntilString);
        }
        this.familySponsorshipToDelete = this.getResponseProperty("FamilySponsorshipToDelete");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider-organization.response.ts

class ProfileProviderOrganizationResponse extends ProfileOrganizationResponse {
    constructor(response) {
        super(response);
        this.keyConnectorEnabled = false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider.response.ts


class ProfileProviderResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.key = this.getResponseProperty("Key");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.userId = this.getResponseProperty("UserId");
        this.useEvents = this.getResponseProperty("UseEvents");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/profile.response.ts




class ProfileResponse extends BaseResponse {
    constructor(response) {
        var _a, _b;
        super(response);
        this.organizations = [];
        this.providers = [];
        this.providerOrganizations = [];
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.emailVerified = this.getResponseProperty("EmailVerified");
        this.masterPasswordHint = this.getResponseProperty("MasterPasswordHint");
        this.premiumPersonally = this.getResponseProperty("Premium");
        this.premiumFromOrganization = this.getResponseProperty("PremiumFromOrganization");
        this.culture = this.getResponseProperty("Culture");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.key = this.getResponseProperty("Key");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.securityStamp = this.getResponseProperty("SecurityStamp");
        this.forcePasswordReset = (_a = this.getResponseProperty("ForcePasswordReset")) !== null && _a !== void 0 ? _a : false;
        this.usesKeyConnector = (_b = this.getResponseProperty("UsesKeyConnector")) !== null && _b !== void 0 ? _b : false;
        const organizations = this.getResponseProperty("Organizations");
        if (organizations != null) {
            this.organizations = organizations.map((o) => new ProfileOrganizationResponse(o));
        }
        const providers = this.getResponseProperty("Providers");
        if (providers != null) {
            this.providers = providers.map((o) => new ProfileProviderResponse(o));
        }
        const providerOrganizations = this.getResponseProperty("ProviderOrganizations");
        if (providerOrganizations != null) {
            this.providerOrganizations = providerOrganizations.map((o) => new ProfileProviderOrganizationResponse(o));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/payment.response.ts


class PaymentResponse extends BaseResponse {
    constructor(response) {
        super(response);
        const userProfile = this.getResponseProperty("UserProfile");
        if (userProfile != null) {
            this.userProfile = new ProfileResponse(userProfile);
        }
        this.paymentIntentClientSecret = this.getResponseProperty("PaymentIntentClientSecret");
        this.success = this.getResponseProperty("Success");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/tax-info.response.ts

class TaxInfoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.taxId = this.getResponseProperty("TaxIdNumber");
        this.taxIdType = this.getResponseProperty("TaxIdType");
        this.line1 = this.getResponseProperty("Line1");
        this.line2 = this.getResponseProperty("Line2");
        this.city = this.getResponseProperty("City");
        this.state = this.getResponseProperty("State");
        this.postalCode = this.getResponseProperty("PostalCode");
        this.country = this.getResponseProperty("Country");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/list.response.ts

class ListResponse extends BaseResponse {
    constructor(response, t) {
        super(response);
        const data = this.getResponseProperty("Data");
        this.data = data == null ? [] : data.map((dr) => new t(dr));
        this.continuationToken = this.getResponseProperty("ContinuationToken");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-api-key-information.response.ts

class OrganizationApiKeyInformationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyType = this.getResponseProperty("KeyType");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-auto-enroll-status.response.ts

class OrganizationAutoEnrollStatusResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.resetPasswordEnabled = this.getResponseProperty("ResetPasswordEnabled");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/keys.response.ts

class KeysResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.publicKey = this.getResponseProperty("PublicKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-keys.response.ts

class OrganizationKeysResponse extends KeysResponse {
    constructor(response) {
        super(response);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization/organization-api.service.ts
var organization_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











class OrganizationApiService {
    constructor(apiService, syncService) {
        this.apiService = apiService;
        this.syncService = syncService;
    }
    get(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id, null, true, true);
            return new OrganizationResponse(r);
        });
    }
    getBilling(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/billing", null, true, true);
            return new BillingResponse(r);
        });
    }
    getSubscription(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/subscription", null, true, true);
            return new OrganizationSubscriptionResponse(r);
        });
    }
    getLicense(id, installationId) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("GET", "/organizations/" + id + "/license?installationId=" + installationId, null, true, true);
        });
    }
    getAutoEnrollStatus(identifier) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + identifier + "/auto-enroll-status", null, true, true);
            return new OrganizationAutoEnrollStatusResponse(r);
        });
    }
    create(request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations", request, true, true);
            // Forcing a sync will notify organization service that they need to repull
            yield this.syncService.fullSync(true);
            return new OrganizationResponse(r);
        });
    }
    createLicense(data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/licenses/self-hosted", data, true, true);
            return new OrganizationResponse(r);
        });
    }
    save(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + id, request, true, true);
            const data = new OrganizationResponse(r);
            yield this.syncService.fullSync(true);
            return data;
        });
    }
    updatePayment(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/payment", request, true, false);
        });
    }
    upgrade(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/upgrade", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updateSubscription(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/subscription", request, true, false);
        });
    }
    updateSeats(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/seat", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updateStorage(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/storage", request, true, true);
            return new PaymentResponse(r);
        });
    }
    verifyBank(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/verify-bank", request, true, false);
        });
    }
    cancel(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/cancel", null, true, false);
        });
    }
    reinstate(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/reinstate", null, true, false);
        });
    }
    leave(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/leave", null, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    delete(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("DELETE", "/organizations/" + id, request, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    updateLicense(id, data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id, data, true, false);
        });
    }
    importDirectory(organizationId, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + organizationId + "/import", request, true, false);
        });
    }
    getOrCreateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getApiKeyInformation(id, organizationApiKeyType = null) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const uri = organizationApiKeyType === null
                ? "/organizations/" + id + "/api-key-information"
                : "/organizations/" + id + "/api-key-information/" + organizationApiKeyType;
            const r = yield this.apiService.send("GET", uri, null, true, true);
            return new ListResponse(r, OrganizationApiKeyInformationResponse);
        });
    }
    rotateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/rotate-api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getTaxInfo(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/tax", null, true, true);
            return new TaxInfoResponse(r);
        });
    }
    updateTaxInfo(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            // Can't broadcast anything because the response doesn't have content
            return this.apiService.send("PUT", "/organizations/" + id + "/tax", request, true, false);
        });
    }
    getKeys(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/keys", null, true, true);
            return new OrganizationKeysResponse(r);
        });
    }
    updateKeys(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/keys", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationKeysResponse(r);
        });
    }
    getSso(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/sso", null, true, true);
            return new OrganizationSsoResponse(r);
        });
    }
    updateSso(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/sso", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationSsoResponse(r);
        });
    }
    selfHostedSyncLicense(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id + "/sync/", null, true, false);
        });
    }
    updateEnrollSecretsManager(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/enroll-secrets-manager", request, true, true);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization/organization.service.abstraction.ts


function canAccessVaultTab(org) {
    return org.canViewAssignedCollections || org.canViewAllCollections || org.canManageGroups;
}
function canAccessSettingsTab(org) {
    return (org.isOwner ||
        org.canManagePolicies ||
        org.canManageSso ||
        org.canManageScim ||
        org.canAccessImportExport);
}
function canAccessMembersTab(org) {
    return org.canManageUsers || org.canManageUsersPassword;
}
function canAccessGroupsTab(org) {
    return org.canManageGroups;
}
function canAccessReportingTab(org) {
    return org.canAccessReports || org.canAccessEventLogs;
}
function canAccessBillingTab(org) {
    return org.isOwner;
}
function canAccessOrgAdmin(org) {
    return (canAccessMembersTab(org) ||
        canAccessGroupsTab(org) ||
        canAccessReportingTab(org) ||
        canAccessBillingTab(org) ||
        canAccessSettingsTab(org) ||
        canAccessVaultTab(org));
}
function getOrganizationById(id) {
    return map((orgs) => orgs.find((o) => o.id === id));
}
function canAccessAdmin(i18nService) {
    return map((orgs) => orgs.filter(canAccessOrgAdmin).sort(Utils.getSortFunction(i18nService, "name")));
}
/**
 * Returns `true` if a user is a member of an organization (rather than only being a ProviderUser)
 * @deprecated Use organizationService.memberOrganizations$ instead
 */
function isMember(org) {
    return org.isMember;
}
class OrganizationService {
}
class InternalOrganizationService extends (/* unused pure expression or super */ null && (OrganizationService)) {
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-api-key-type.enum.ts
var OrganizationApiKeyType;
(function (OrganizationApiKeyType) {
    OrganizationApiKeyType[OrganizationApiKeyType["Default"] = 0] = "Default";
    OrganizationApiKeyType[OrganizationApiKeyType["BillingSync"] = 1] = "BillingSync";
    OrganizationApiKeyType[OrganizationApiKeyType["Scim"] = 2] = "Scim";
})(OrganizationApiKeyType || (OrganizationApiKeyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-connection-type.enum.ts
var OrganizationConnectionType;
(function (OrganizationConnectionType) {
    OrganizationConnectionType[OrganizationConnectionType["CloudBillingSync"] = 1] = "CloudBillingSync";
    OrganizationConnectionType[OrganizationConnectionType["Scim"] = 2] = "Scim";
})(OrganizationConnectionType || (OrganizationConnectionType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-status-type.enum.ts
var OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(OrganizationUserStatusType || (OrganizationUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-type.enum.ts
var OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    OrganizationUserType[OrganizationUserType["Manager"] = 3] = "Manager";
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(OrganizationUserType || (OrganizationUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/policy-type.enum.ts
var PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["PersonalOwnership"] = 5] = "PersonalOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
})(PolicyType || (PolicyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-status-type.enum.ts
var ProviderUserStatusType;
(function (ProviderUserStatusType) {
    ProviderUserStatusType[ProviderUserStatusType["Invited"] = 0] = "Invited";
    ProviderUserStatusType[ProviderUserStatusType["Accepted"] = 1] = "Accepted";
    ProviderUserStatusType[ProviderUserStatusType["Confirmed"] = 2] = "Confirmed";
    ProviderUserStatusType[ProviderUserStatusType["Revoked"] = -1] = "Revoked";
})(ProviderUserStatusType || (ProviderUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-type.enum.ts
var ProviderUserType;
(function (ProviderUserType) {
    ProviderUserType[ProviderUserType["ProviderAdmin"] = 0] = "ProviderAdmin";
    ProviderUserType[ProviderUserType["ServiceUser"] = 1] = "ServiceUser";
})(ProviderUserType || (ProviderUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/scim-provider-type.enum.ts
var ScimProviderType;
(function (ScimProviderType) {
    ScimProviderType[ScimProviderType["Default"] = 0] = "Default";
    ScimProviderType[ScimProviderType["AzureAd"] = 1] = "AzureAd";
    ScimProviderType[ScimProviderType["Okta"] = 2] = "Okta";
    ScimProviderType[ScimProviderType["OneLogin"] = 3] = "OneLogin";
    ScimProviderType[ScimProviderType["JumpCloud"] = 4] = "JumpCloud";
    ScimProviderType[ScimProviderType["GoogleWorkspace"] = 5] = "GoogleWorkspace";
    ScimProviderType[ScimProviderType["Rippling"] = 6] = "Rippling";
})(ScimProviderType || (ScimProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/index.ts









;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/organization.ts


class Organization {
    constructor(obj) {
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.name = obj.name;
        this.status = obj.status;
        this.type = obj.type;
        this.enabled = obj.enabled;
        this.usePolicies = obj.usePolicies;
        this.useGroups = obj.useGroups;
        this.useDirectory = obj.useDirectory;
        this.useEvents = obj.useEvents;
        this.useTotp = obj.useTotp;
        this.use2fa = obj.use2fa;
        this.useApi = obj.useApi;
        this.useSso = obj.useSso;
        this.useKeyConnector = obj.useKeyConnector;
        this.useScim = obj.useScim;
        this.useCustomPermissions = obj.useCustomPermissions;
        this.useResetPassword = obj.useResetPassword;
        this.useSecretsManager = obj.useSecretsManager;
        this.useActivateAutofillPolicy = obj.useActivateAutofillPolicy;
        this.selfHost = obj.selfHost;
        this.usersGetPremium = obj.usersGetPremium;
        this.seats = obj.seats;
        this.maxCollections = obj.maxCollections;
        this.maxStorageGb = obj.maxStorageGb;
        this.ssoBound = obj.ssoBound;
        this.identifier = obj.identifier;
        this.permissions = obj.permissions;
        this.resetPasswordEnrolled = obj.resetPasswordEnrolled;
        this.userId = obj.userId;
        this.hasPublicAndPrivateKeys = obj.hasPublicAndPrivateKeys;
        this.providerId = obj.providerId;
        this.providerName = obj.providerName;
        this.providerType = obj.providerType;
        this.isProviderUser = obj.isProviderUser;
        this.isMember = obj.isMember;
        this.familySponsorshipFriendlyName = obj.familySponsorshipFriendlyName;
        this.familySponsorshipAvailable = obj.familySponsorshipAvailable;
        this.planProductType = obj.planProductType;
        this.keyConnectorEnabled = obj.keyConnectorEnabled;
        this.keyConnectorUrl = obj.keyConnectorUrl;
        this.familySponsorshipLastSyncDate = obj.familySponsorshipLastSyncDate;
        this.familySponsorshipValidUntil = obj.familySponsorshipValidUntil;
        this.familySponsorshipToDelete = obj.familySponsorshipToDelete;
        this.accessSecretsManager = obj.accessSecretsManager;
    }
    get canAccess() {
        if (this.isOwner) {
            return true;
        }
        return this.enabled && this.status === OrganizationUserStatusType.Confirmed;
    }
    /**
     * Whether a user has Manager permissions or greater
     */
    get isManager() {
        return this.type === OrganizationUserType.Manager || this.isAdmin;
    }
    /**
     * Whether a user has Admin permissions or greater
     */
    get isAdmin() {
        return this.type === OrganizationUserType.Admin || this.isOwner;
    }
    /**
     * Whether a user has Owner permissions (including ProviderUsers)
     */
    get isOwner() {
        return this.type === OrganizationUserType.Owner || this.isProviderUser;
    }
    get canAccessEventLogs() {
        return (this.isAdmin || this.permissions.accessEventLogs) && this.useEvents;
    }
    get canAccessImportExport() {
        return this.isAdmin || this.permissions.accessImportExport;
    }
    get canAccessReports() {
        return this.isAdmin || this.permissions.accessReports;
    }
    get canCreateNewCollections() {
        return this.isManager || this.permissions.createNewCollections;
    }
    get canEditAnyCollection() {
        return this.isAdmin || this.permissions.editAnyCollection;
    }
    get canUseAdminCollections() {
        return this.canEditAnyCollection;
    }
    get canDeleteAnyCollection() {
        return this.isAdmin || this.permissions.deleteAnyCollection;
    }
    get canViewAllCollections() {
        return this.canCreateNewCollections || this.canEditAnyCollection || this.canDeleteAnyCollection;
    }
    get canEditAssignedCollections() {
        return this.isManager || this.permissions.editAssignedCollections;
    }
    get canDeleteAssignedCollections() {
        return this.isManager || this.permissions.deleteAssignedCollections;
    }
    get canViewAssignedCollections() {
        return this.canDeleteAssignedCollections || this.canEditAssignedCollections;
    }
    get canManageGroups() {
        return (this.isAdmin || this.permissions.manageGroups) && this.useGroups;
    }
    get canManageSso() {
        return (this.isAdmin || this.permissions.manageSso) && this.useSso;
    }
    get canManageDomainVerification() {
        return (this.isAdmin || this.permissions.manageSso) && this.useSso;
    }
    get canManageScim() {
        return (this.isAdmin || this.permissions.manageScim) && this.useScim;
    }
    get canManagePolicies() {
        return (this.isAdmin || this.permissions.managePolicies) && this.usePolicies;
    }
    get canManageUsers() {
        return this.isAdmin || this.permissions.manageUsers;
    }
    get canManageUsersPassword() {
        return this.isAdmin || this.permissions.manageResetPassword;
    }
    get isExemptFromPolicies() {
        return this.canManagePolicies;
    }
    get canViewSubscription() {
        if (this.canEditSubscription) {
            return true;
        }
        return this.hasProvider && this.providerType === ProviderType.Msp
            ? this.isProviderUser
            : this.isOwner;
    }
    get canEditSubscription() {
        return this.hasProvider ? this.isProviderUser : this.isOwner;
    }
    get canEditPaymentMethods() {
        return this.canEditSubscription;
    }
    get canViewBillingHistory() {
        return this.canEditSubscription;
    }
    get hasProvider() {
        return this.providerId != null || this.providerName != null;
    }
    get canAccessSecretsManager() {
        return this.useSecretsManager && this.accessSecretsManager;
    }
    get isFreeOrg() {
        // return true if organization needs to be upgraded from a free org
        return !this.useTotp;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new Organization(), json, {
            familySponsorshipLastSyncDate: new Date(json.familySponsorshipLastSyncDate),
            familySponsorshipValidUntil: new Date(json.familySponsorshipValidUntil),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization/organization.service.ts
var organization_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class organization_service_OrganizationService {
    constructor(stateService) {
        this.stateService = stateService;
        this._organizations = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this.organizations$ = this._organizations.asObservable();
        this.memberOrganizations$ = this.organizations$.pipe((0,external_rxjs_namespaceObject.map)((orgs) => orgs.filter(isMember)));
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => organization_service_awaiter(this, void 0, void 0, function* () {
            if (!unlocked) {
                this._organizations.next([]);
                return;
            }
            const data = yield this.stateService.getOrganizations();
            this.updateObservables(data);
        })))
            .subscribe();
    }
    get$(id) {
        return this.organizations$.pipe((0,external_rxjs_namespaceObject.map)((orgs) => orgs.find((o) => o.id === id)));
    }
    getAll(userId) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizationsMap = yield this.stateService.getOrganizations({ userId: userId });
            return Object.values(organizationsMap || {}).map((o) => new Organization(o));
        });
    }
    canManageSponsorships() {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizations = this._organizations.getValue();
            return organizations.some((o) => o.familySponsorshipAvailable || o.familySponsorshipFriendlyName !== null);
        });
    }
    hasOrganizations() {
        const organizations = this._organizations.getValue();
        return organizations.length > 0;
    }
    upsert(organization) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            let organizations = yield this.stateService.getOrganizations();
            if (organizations == null) {
                organizations = {};
            }
            organizations[organization.id] = organization;
            yield this.replace(organizations);
        });
    }
    delete(id) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizations = yield this.stateService.getOrganizations();
            if (organizations == null) {
                return;
            }
            if (organizations[id] == null) {
                return;
            }
            delete organizations[id];
            yield this.replace(organizations);
        });
    }
    get(id) {
        const organizations = this._organizations.getValue();
        return organizations.find((organization) => organization.id === id);
    }
    /**
     * @deprecated For the CLI only
     * @param id id of the organization
     */
    getFromState(id) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizationsMap = yield this.stateService.getOrganizations();
            const organization = organizationsMap[id];
            if (organization == null) {
                return null;
            }
            return new Organization(organization);
        });
    }
    getByIdentifier(identifier) {
        const organizations = this._organizations.getValue();
        return organizations.find((organization) => organization.identifier === identifier);
    }
    replace(organizations) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setOrganizations(organizations);
            this.updateObservables(organizations);
        });
    }
    updateObservables(organizationsMap) {
        const organizations = Object.values(organizationsMap || {}).map((o) => new Organization(o));
        this._organizations.next(organizations);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/policy.data.ts
class PolicyData {
    constructor(response) {
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.type = response.type;
        this.data = response.data;
        this.enabled = response.enabled;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/policy.response.ts

class PolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.organizationId = this.getResponseProperty("OrganizationId");
        this.type = this.getResponseProperty("Type");
        this.data = this.getResponseProperty("Data");
        this.enabled = this.getResponseProperty("Enabled");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/policy/policy-api.service.ts
var policy_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class PolicyApiService {
    constructor(policyService, apiService, stateService) {
        this.policyService = policyService;
        this.apiService = apiService;
        this.stateService = stateService;
    }
    getPolicy(organizationId, type) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies/" + type, null, true, true);
            return new PolicyResponse(r);
        });
    }
    getPolicies(organizationId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies", null, true, true);
            return new ListResponse(r, PolicyResponse);
        });
    }
    getPoliciesByToken(organizationId, token, email, organizationUserId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" +
                organizationId +
                "/policies/token?" +
                "token=" +
                encodeURIComponent(token) +
                "&email=" +
                utils_Utils.encodeRFC3986URIComponent(email) +
                "&organizationUserId=" +
                organizationUserId, null, false, true);
            return new ListResponse(r, PolicyResponse);
        });
    }
    getPoliciesByInvitedUser(organizationId, userId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies/invited-user?" + "userId=" + userId, null, false, true);
            return new ListResponse(r, PolicyResponse);
        });
    }
    getMasterPasswordPoliciesForInvitedUsers(orgId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.stateService.getUserId();
            const response = yield this.getPoliciesByInvitedUser(orgId, userId);
            const policies = yield this.policyService.mapPoliciesFromToken(response);
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.policyService.masterPasswordPolicyOptions$(policies));
        });
    }
    putPolicy(organizationId, type, request) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/policies/" + type, request, true, true);
            const response = new PolicyResponse(r);
            const data = new PolicyData(response);
            yield this.policyService.upsert(data);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/master-password-policy-options.ts

class MasterPasswordPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.minComplexity = 0;
        this.minLength = 0;
        this.requireUpper = false;
        this.requireLower = false;
        this.requireNumbers = false;
        this.requireSpecial = false;
        /**
         * Flag to indicate if the policy should be enforced on login.
         * If true, and the user's password does not meet the policy requirements,
         * the user will be forced to update their password.
         */
        this.enforceOnLogin = false;
    }
    static fromResponse(policy) {
        if (policy == null) {
            return null;
        }
        const options = new MasterPasswordPolicyOptions();
        options.minComplexity = policy.minComplexity;
        options.minLength = policy.minLength;
        options.requireUpper = policy.requireUpper;
        options.requireLower = policy.requireLower;
        options.requireNumbers = policy.requireNumbers;
        options.requireSpecial = policy.requireSpecial;
        options.enforceOnLogin = policy.enforceOnLogin;
        return options;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/policy.ts

class Policy extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.organizationId = obj.organizationId;
        this.type = obj.type;
        this.data = obj.data;
        this.enabled = obj.enabled;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/reset-password-policy-options.ts

class ResetPasswordPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.autoEnrollEnabled = false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/policy/policy.service.ts
var policy_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class PolicyService {
    constructor(stateService, organizationService) {
        this.stateService = stateService;
        this.organizationService = organizationService;
        this._policies = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this.policies$ = this._policies.asObservable();
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => policy_service_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.global.bitwardenContainerService == null) {
                return;
            }
            if (!unlocked) {
                this._policies.next([]);
                return;
            }
            const data = yield this.stateService.getEncryptedPolicies();
            yield this.updateObservables(data);
        })))
            .subscribe();
    }
    /**
     * Returns the first policy found that applies to the active user
     * @param policyType Policy type to search for
     * @param policyFilter Additional filter to apply to the policy
     */
    get$(policyType, policyFilter) {
        return this.policies$.pipe((0,external_rxjs_namespaceObject.concatMap)((policies) => policy_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.stateService.getUserId();
            const appliesToCurrentUser = yield this.checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId);
            if (appliesToCurrentUser) {
                return policies.find((policy) => policy.type === policyType && policy.enabled);
            }
        })));
    }
    /**
     * @deprecated Do not call this, use the policies$ observable collection
     */
    getAll(type, userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            let response = [];
            const decryptedPolicies = yield this.stateService.getDecryptedPolicies({ userId: userId });
            if (decryptedPolicies != null) {
                response = decryptedPolicies;
            }
            else {
                const diskPolicies = yield this.stateService.getEncryptedPolicies({ userId: userId });
                for (const id in diskPolicies) {
                    if (Object.prototype.hasOwnProperty.call(diskPolicies, id)) {
                        response.push(new Policy(diskPolicies[id]));
                    }
                }
                yield this.stateService.setDecryptedPolicies(response, { userId: userId });
            }
            if (type != null) {
                return response.filter((policy) => policy.type === type);
            }
            else {
                return response;
            }
        });
    }
    masterPasswordPolicyOptions$(policies) {
        const observable = policies ? (0,external_rxjs_namespaceObject.of)(policies) : this.policies$;
        return observable.pipe((0,external_rxjs_namespaceObject.map)((obsPolicies) => {
            let enforcedOptions = null;
            const filteredPolicies = obsPolicies.filter((p) => p.type === PolicyType.MasterPassword);
            if (filteredPolicies == null || filteredPolicies.length === 0) {
                return enforcedOptions;
            }
            filteredPolicies.forEach((currentPolicy) => {
                if (!currentPolicy.enabled || currentPolicy.data == null) {
                    return;
                }
                if (enforcedOptions == null) {
                    enforcedOptions = new MasterPasswordPolicyOptions();
                }
                if (currentPolicy.data.minComplexity != null &&
                    currentPolicy.data.minComplexity > enforcedOptions.minComplexity) {
                    enforcedOptions.minComplexity = currentPolicy.data.minComplexity;
                }
                if (currentPolicy.data.minLength != null &&
                    currentPolicy.data.minLength > enforcedOptions.minLength) {
                    enforcedOptions.minLength = currentPolicy.data.minLength;
                }
                if (currentPolicy.data.requireUpper) {
                    enforcedOptions.requireUpper = true;
                }
                if (currentPolicy.data.requireLower) {
                    enforcedOptions.requireLower = true;
                }
                if (currentPolicy.data.requireNumbers) {
                    enforcedOptions.requireNumbers = true;
                }
                if (currentPolicy.data.requireSpecial) {
                    enforcedOptions.requireSpecial = true;
                }
                if (currentPolicy.data.enforceOnLogin) {
                    enforcedOptions.enforceOnLogin = true;
                }
            });
            return enforcedOptions;
        }));
    }
    policyAppliesToActiveUser$(policyType, policyFilter) {
        return this.policies$.pipe((0,external_rxjs_namespaceObject.concatMap)((policies) => policy_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.stateService.getUserId();
            return yield this.checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId);
        })));
    }
    evaluateMasterPassword(passwordStrength, newPassword, enforcedPolicyOptions) {
        if (enforcedPolicyOptions == null) {
            return true;
        }
        if (enforcedPolicyOptions.minComplexity > 0 &&
            enforcedPolicyOptions.minComplexity > passwordStrength) {
            return false;
        }
        if (enforcedPolicyOptions.minLength > 0 &&
            enforcedPolicyOptions.minLength > newPassword.length) {
            return false;
        }
        if (enforcedPolicyOptions.requireUpper && newPassword.toLocaleLowerCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireLower && newPassword.toLocaleUpperCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireNumbers && !/[0-9]/.test(newPassword)) {
            return false;
        }
        // eslint-disable-next-line
        if (enforcedPolicyOptions.requireSpecial && !/[!@#$%\^&*]/g.test(newPassword)) {
            return false;
        }
        return true;
    }
    getResetPasswordPolicyOptions(policies, orgId) {
        var _a, _b, _c;
        const resetPasswordPolicyOptions = new ResetPasswordPolicyOptions();
        if (policies == null || orgId == null) {
            return [resetPasswordPolicyOptions, false];
        }
        const policy = policies.find((p) => p.organizationId === orgId && p.type === PolicyType.ResetPassword && p.enabled);
        resetPasswordPolicyOptions.autoEnrollEnabled = (_b = (_a = policy === null || policy === void 0 ? void 0 : policy.data) === null || _a === void 0 ? void 0 : _a.autoEnrollEnabled) !== null && _b !== void 0 ? _b : false;
        return [resetPasswordPolicyOptions, (_c = policy === null || policy === void 0 ? void 0 : policy.enabled) !== null && _c !== void 0 ? _c : false];
    }
    mapPoliciesFromToken(policiesResponse) {
        if (policiesResponse == null || policiesResponse.data == null) {
            return null;
        }
        const policiesData = policiesResponse.data.map((p) => new PolicyData(p));
        return policiesData.map((p) => new Policy(p));
    }
    policyAppliesToUser(policyType, policyFilter, userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            const policies = yield this.getAll(policyType, userId);
            return this.checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId);
        });
    }
    upsert(policy) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            let policies = yield this.stateService.getEncryptedPolicies();
            if (policies == null) {
                policies = {};
            }
            policies[policy.id] = policy;
            yield this.updateObservables(policies);
            yield this.stateService.setDecryptedPolicies(null);
            yield this.stateService.setEncryptedPolicies(policies);
        });
    }
    replace(policies) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateObservables(policies);
            yield this.stateService.setDecryptedPolicies(null);
            yield this.stateService.setEncryptedPolicies(policies);
        });
    }
    clear(userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null || userId == (yield this.stateService.getUserId())) {
                this._policies.next([]);
            }
            yield this.stateService.setDecryptedPolicies(null, { userId: userId });
            yield this.stateService.setEncryptedPolicies(null, { userId: userId });
        });
    }
    isExemptFromPolicies(organization, policyType) {
        if (policyType === PolicyType.MaximumVaultTimeout) {
            return organization.type === OrganizationUserType.Owner;
        }
        return organization.isExemptFromPolicies;
    }
    updateObservables(policiesMap) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            const policies = Object.values(policiesMap || {}).map((f) => new Policy(f));
            this._policies.next(policies);
        });
    }
    checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            const organizations = yield this.organizationService.getAll(userId);
            const filteredPolicies = policies.filter((p) => p.type === policyType && p.enabled && (policyFilter == null || policyFilter(p)));
            const policySet = new Set(filteredPolicies.map((p) => p.organizationId));
            return organizations.some((o) => o.status >= OrganizationUserStatusType.Accepted &&
                o.usePolicies &&
                policySet.has(o.id) &&
                !this.isExemptFromPolicies(o, policyType));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/provider.ts

class Provider {
    constructor(obj) {
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.name = obj.name;
        this.status = obj.status;
        this.type = obj.type;
        this.enabled = obj.enabled;
        this.userId = obj.userId;
        this.useEvents = obj.useEvents;
    }
    get canAccess() {
        if (this.isProviderAdmin) {
            return true;
        }
        return this.enabled && this.status === ProviderUserStatusType.Confirmed;
    }
    get canCreateOrganizations() {
        return this.enabled && this.isProviderAdmin;
    }
    get canManageUsers() {
        return this.isProviderAdmin;
    }
    get canAccessEventLogs() {
        return this.isProviderAdmin;
    }
    get isProviderAdmin() {
        return this.type === ProviderUserType.ProviderAdmin;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/provider.service.ts
var provider_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class ProviderService {
    constructor(stateService) {
        this.stateService = stateService;
    }
    get(id) {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            const providers = yield this.stateService.getProviders();
            // eslint-disable-next-line
            if (providers == null || !providers.hasOwnProperty(id)) {
                return null;
            }
            return new Provider(providers[id]);
        });
    }
    getAll() {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            const providers = yield this.stateService.getProviders();
            const response = [];
            for (const id in providers) {
                // eslint-disable-next-line
                if (providers.hasOwnProperty(id)) {
                    response.push(new Provider(providers[id]));
                }
            }
            return response;
        });
    }
    save(providers) {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setProviders(providers);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/prelogin.request.ts
class PreloginRequest {
    constructor(email) {
        this.email = email;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/error.response.ts


class ErrorResponse extends BaseResponse {
    constructor(response, status, identityResponse) {
        var _a, _b;
        super(response);
        let errorModel = null;
        if (response != null) {
            const responseErrorModel = this.getResponseProperty("ErrorModel");
            if (responseErrorModel && identityResponse) {
                errorModel = responseErrorModel;
            }
            else {
                errorModel = response;
            }
        }
        if (status === 429) {
            this.message = "Rate limit exceeded. Try again later.";
        }
        else if (errorModel) {
            this.message = this.getResponseProperty("Message", errorModel);
            this.validationErrors = this.getResponseProperty("ValidationErrors", errorModel);
            this.captchaSiteKey = (_b = (_a = this.validationErrors) === null || _a === void 0 ? void 0 : _a.HCaptcha_SiteKey) === null || _b === void 0 ? void 0 : _b[0];
            this.captchaRequired = !utils_Utils.isNullOrWhitespace(this.captchaSiteKey);
        }
        this.statusCode = status;
    }
    getSingleMessage() {
        if (this.validationErrors == null) {
            return this.message;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            if (this.validationErrors[key].length) {
                return this.validationErrors[key][0];
            }
        }
        return this.message;
    }
    getAllMessages() {
        const messages = [];
        if (this.validationErrors == null) {
            return messages;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            this.validationErrors[key].forEach((item) => {
                let prefix = "";
                if (key.indexOf("[") > -1 && key.indexOf("]") > -1) {
                    const lastSep = key.lastIndexOf(".");
                    prefix = key.substr(0, lastSep > -1 ? lastSep : key.length) + ": ";
                }
                messages.push(prefix + item);
            });
        }
        return messages;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-status.ts
var AuthenticationStatus;
(function (AuthenticationStatus) {
    AuthenticationStatus[AuthenticationStatus["LoggedOut"] = 0] = "LoggedOut";
    AuthenticationStatus[AuthenticationStatus["Locked"] = 1] = "Locked";
    AuthenticationStatus[AuthenticationStatus["Unlocked"] = 2] = "Unlocked";
})(AuthenticationStatus || (AuthenticationStatus = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-type.ts
var authentication_type_AuthenticationType;
(function (AuthenticationType) {
    AuthenticationType[AuthenticationType["Password"] = 0] = "Password";
    AuthenticationType[AuthenticationType["Sso"] = 1] = "Sso";
    AuthenticationType[AuthenticationType["UserApi"] = 2] = "UserApi";
    AuthenticationType[AuthenticationType["Passwordless"] = 3] = "Passwordless";
})(authentication_type_AuthenticationType || (authentication_type_AuthenticationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/force-reset-password-reason.ts
var ForceResetPasswordReason;
(function (ForceResetPasswordReason) {
    /**
     * A password reset should not be forced.
     */
    ForceResetPasswordReason[ForceResetPasswordReason["None"] = 0] = "None";
    /**
     * Occurs when an organization admin forces a user to reset their password.
     */
    ForceResetPasswordReason[ForceResetPasswordReason["AdminForcePasswordReset"] = 1] = "AdminForcePasswordReset";
    /**
     * Occurs when a user logs in / unlocks their vault with a master password that does not meet an organization's
     * master password policy that is enforced on login/unlock.
     */
    ForceResetPasswordReason[ForceResetPasswordReason["WeakMasterPassword"] = 2] = "WeakMasterPassword";
})(ForceResetPasswordReason || (ForceResetPasswordReason = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token.request.ts
class TokenRequest {
    constructor(twoFactor, device) {
        this.twoFactor = twoFactor;
        this.device = device != null ? device : null;
    }
    // eslint-disable-next-line
    alterIdentityTokenHeaders(headers) {
        // Implemented in subclass if required
    }
    setTwoFactor(twoFactor) {
        this.twoFactor = twoFactor;
    }
    setPasswordlessAccessCode(accessCode) {
        this.passwordlessAuthRequest = accessCode;
    }
    toIdentityToken(clientId) {
        const obj = {
            scope: "api offline_access",
            client_id: clientId,
        };
        if (this.device) {
            obj.deviceType = this.device.type;
            obj.deviceIdentifier = this.device.identifier;
            obj.deviceName = this.device.name;
            // no push tokens for browser apps yet
            // obj.devicePushToken = this.device.pushToken;
        }
        //passswordless login
        if (this.passwordlessAuthRequest) {
            obj.authRequest = this.passwordlessAuthRequest;
        }
        if (this.twoFactor) {
            if (this.twoFactor.token && this.twoFactor.provider != null) {
                obj.twoFactorToken = this.twoFactor.token;
                obj.twoFactorProvider = this.twoFactor.provider;
                obj.twoFactorRemember = this.twoFactor.remember ? "1" : "0";
            }
        }
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/password-token.request.ts


class PasswordTokenRequest extends TokenRequest {
    constructor(email, masterPasswordHash, captchaResponse, twoFactor, device) {
        super(twoFactor, device);
        this.email = email;
        this.masterPasswordHash = masterPasswordHash;
        this.captchaResponse = captchaResponse;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "password";
        obj.username = this.email;
        obj.password = this.masterPasswordHash;
        if (this.captchaResponse != null) {
            obj.captchaResponse = this.captchaResponse;
        }
        return obj;
    }
    alterIdentityTokenHeaders(headers) {
        headers.set("Auth-Email", utils_Utils.fromUtf8ToUrlB64(this.email));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-captcha.response.ts

class IdentityCaptchaResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.siteKey = this.getResponseProperty("HCaptcha_SiteKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/environment-urls.ts
class EnvironmentUrls {
    constructor() {
        this.base = null;
        this.api = null;
        this.identity = null;
        this.icons = null;
        this.notifications = null;
        this.events = null;
        this.webVault = null;
        this.keyConnector = null;
    }
    static fromJSON(obj) {
        return Object.assign(new EnvironmentUrls(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/data/server-config.data.ts
class ServerConfigData {
    constructor(serverConfigResponse) {
        this.version = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.version;
        this.gitHash = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.gitHash;
        this.server = (serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.server)
            ? new ThirdPartyServerConfigData(serverConfigResponse.server)
            : null;
        this.utcDate = new Date().toISOString();
        this.environment = (serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.environment)
            ? new EnvironmentServerConfigData(serverConfigResponse.environment)
            : null;
    }
    static fromJSON(obj) {
        return Object.assign(new ServerConfigData({}), obj, {
            server: (obj === null || obj === void 0 ? void 0 : obj.server) ? ThirdPartyServerConfigData.fromJSON(obj.server) : null,
            environment: (obj === null || obj === void 0 ? void 0 : obj.environment) ? EnvironmentServerConfigData.fromJSON(obj.environment) : null,
        });
    }
}
class ThirdPartyServerConfigData {
    constructor(response) {
        this.name = response.name;
        this.url = response.url;
    }
    static fromJSON(obj) {
        return Object.assign(new ThirdPartyServerConfigData({}), obj);
    }
}
class EnvironmentServerConfigData {
    constructor(response) {
        this.vault = response.vault;
        this.api = response.api;
        this.identity = response.identity;
        this.notifications = response.notifications;
        this.sso = response.sso;
    }
    static fromJSON(obj) {
        return Object.assign(new EnvironmentServerConfigData({}), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/symmetric-crypto-key.ts


class SymmetricCryptoKey {
    constructor(key, encType) {
        if (key == null) {
            throw new Error("Must provide key");
        }
        if (encType == null) {
            if (key.byteLength === 32) {
                encType = EncryptionType.AesCbc256_B64;
            }
            else if (key.byteLength === 64) {
                encType = EncryptionType.AesCbc256_HmacSha256_B64;
            }
            else {
                throw new Error("Unable to determine encType.");
            }
        }
        this.key = key;
        this.encType = encType;
        if (encType === EncryptionType.AesCbc256_B64 && key.byteLength === 32) {
            this.encKey = key;
            this.macKey = null;
        }
        else if (encType === EncryptionType.AesCbc128_HmacSha256_B64 && key.byteLength === 32) {
            this.encKey = key.slice(0, 16);
            this.macKey = key.slice(16, 32);
        }
        else if (encType === EncryptionType.AesCbc256_HmacSha256_B64 && key.byteLength === 64) {
            this.encKey = key.slice(0, 32);
            this.macKey = key.slice(32, 64);
        }
        else {
            throw new Error("Unsupported encType/key length.");
        }
        if (this.key != null) {
            this.keyB64 = utils_Utils.fromBufferToB64(this.key);
        }
        if (this.encKey != null) {
            this.encKeyB64 = utils_Utils.fromBufferToB64(this.encKey);
        }
        if (this.macKey != null) {
            this.macKeyB64 = utils_Utils.fromBufferToB64(this.macKey);
        }
    }
    toJSON() {
        // The whole object is constructed from the initial key, so just store the B64 key
        return { keyB64: this.keyB64 };
    }
    static fromString(s) {
        if (s == null) {
            return null;
        }
        const arrayBuffer = utils_Utils.fromB64ToArray(s).buffer;
        return new SymmetricCryptoKey(arrayBuffer);
    }
    static fromJSON(obj) {
        return SymmetricCryptoKey.fromString(obj === null || obj === void 0 ? void 0 : obj.keyB64);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/account.ts





class EncryptionPair {
    toJSON() {
        return {
            encrypted: this.encrypted,
            decrypted: this.decrypted instanceof ArrayBuffer
                ? utils_Utils.fromBufferToByteString(this.decrypted)
                : this.decrypted,
        };
    }
    static fromJSON(obj, decryptedFromJson, encryptedFromJson) {
        if (obj == null) {
            return null;
        }
        const pair = new EncryptionPair();
        if ((obj === null || obj === void 0 ? void 0 : obj.encrypted) != null) {
            pair.encrypted = encryptedFromJson
                ? encryptedFromJson(obj.encrypted)
                : obj.encrypted;
        }
        if ((obj === null || obj === void 0 ? void 0 : obj.decrypted) != null) {
            pair.decrypted = decryptedFromJson
                ? decryptedFromJson(obj.decrypted)
                : obj.decrypted;
        }
        return pair;
    }
}
class DataEncryptionPair {
}
// This is a temporary structure to handle migrated `DataEncryptionPair` to
//  avoid needing a data migration at this stage. It should be replaced with
//  proper data migrations when `DataEncryptionPair` is deprecated.
class TemporaryDataEncryption {
}
class AccountData {
    constructor() {
        this.ciphers = new DataEncryptionPair();
        this.folders = new TemporaryDataEncryption();
        this.sends = new DataEncryptionPair();
        this.collections = new DataEncryptionPair();
        this.policies = new DataEncryptionPair();
        this.passwordGenerationHistory = new EncryptionPair();
    }
}
class AccountKeys {
    constructor() {
        this.cryptoSymmetricKey = new EncryptionPair();
        this.organizationKeys = new EncryptionPair();
        this.providerKeys = new EncryptionPair();
        this.privateKey = new EncryptionPair();
    }
    toJSON() {
        return utils_Utils.merge(this, {
            publicKey: utils_Utils.fromBufferToByteString(this.publicKey),
        });
    }
    static fromJSON(obj) {
        var _a;
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountKeys(), {
            cryptoMasterKey: SymmetricCryptoKey.fromJSON(obj === null || obj === void 0 ? void 0 : obj.cryptoMasterKey),
            cryptoSymmetricKey: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.cryptoSymmetricKey, SymmetricCryptoKey.fromJSON),
            organizationKeys: AccountKeys.initRecordEncryptionPairsFromJSON(obj === null || obj === void 0 ? void 0 : obj.organizationKeys),
            providerKeys: AccountKeys.initRecordEncryptionPairsFromJSON(obj === null || obj === void 0 ? void 0 : obj.providerKeys),
            privateKey: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.privateKey, (decObj) => utils_Utils.fromByteStringToArray(decObj).buffer),
            publicKey: (_a = utils_Utils.fromByteStringToArray(obj === null || obj === void 0 ? void 0 : obj.publicKey)) === null || _a === void 0 ? void 0 : _a.buffer,
        });
    }
    static initRecordEncryptionPairsFromJSON(obj) {
        return EncryptionPair.fromJSON(obj, (decObj) => {
            if (obj == null) {
                return null;
            }
            const record = {};
            for (const id in decObj) {
                record[id] = SymmetricCryptoKey.fromJSON(decObj[id]);
            }
            return record;
        });
    }
}
class AccountProfile {
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountProfile(), obj);
    }
}
class AccountSettings {
    constructor() {
        this.environmentUrls = new EnvironmentUrls();
        this.pinProtected = new EncryptionPair();
        this.vaultTimeoutAction = "lock";
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountSettings(), obj, {
            environmentUrls: EnvironmentUrls.fromJSON(obj === null || obj === void 0 ? void 0 : obj.environmentUrls),
            pinProtected: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.pinProtected, EncString.fromJSON),
            serverConfig: ServerConfigData.fromJSON(obj === null || obj === void 0 ? void 0 : obj.serverConfig),
        });
    }
}
class AccountTokens {
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountTokens(), obj);
    }
}
class Account {
    constructor(init) {
        this.data = new AccountData();
        this.keys = new AccountKeys();
        this.profile = new AccountProfile();
        this.settings = new AccountSettings();
        this.tokens = new AccountTokens();
        Object.assign(this, {
            data: Object.assign(Object.assign({}, new AccountData()), init === null || init === void 0 ? void 0 : init.data),
            keys: Object.assign(Object.assign({}, new AccountKeys()), init === null || init === void 0 ? void 0 : init.keys),
            profile: Object.assign(Object.assign({}, new AccountProfile()), init === null || init === void 0 ? void 0 : init.profile),
            settings: Object.assign(Object.assign({}, new AccountSettings()), init === null || init === void 0 ? void 0 : init.settings),
            tokens: Object.assign(Object.assign({}, new AccountTokens()), init === null || init === void 0 ? void 0 : init.tokens),
        });
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new Account({}), json, {
            keys: AccountKeys.fromJSON(json === null || json === void 0 ? void 0 : json.keys),
            profile: AccountProfile.fromJSON(json === null || json === void 0 ? void 0 : json.profile),
            settings: AccountSettings.fromJSON(json === null || json === void 0 ? void 0 : json.settings),
            tokens: AccountTokens.fromJSON(json === null || json === void 0 ? void 0 : json.tokens),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/keys.request.ts
class KeysRequest {
    constructor(publicKey, encryptedPrivateKey) {
        this.publicKey = publicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/two-factor-provider-type.ts
var TwoFactorProviderType;
(function (TwoFactorProviderType) {
    TwoFactorProviderType[TwoFactorProviderType["Authenticator"] = 0] = "Authenticator";
    TwoFactorProviderType[TwoFactorProviderType["Email"] = 1] = "Email";
    TwoFactorProviderType[TwoFactorProviderType["Duo"] = 2] = "Duo";
    TwoFactorProviderType[TwoFactorProviderType["Yubikey"] = 3] = "Yubikey";
    TwoFactorProviderType[TwoFactorProviderType["U2f"] = 4] = "U2f";
    TwoFactorProviderType[TwoFactorProviderType["Remember"] = 5] = "Remember";
    TwoFactorProviderType[TwoFactorProviderType["OrganizationDuo"] = 6] = "OrganizationDuo";
    TwoFactorProviderType[TwoFactorProviderType["WebAuthn"] = 7] = "WebAuthn";
})(TwoFactorProviderType || (TwoFactorProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/auth-result.ts


class AuthResult {
    constructor() {
        this.captchaSiteKey = "";
        this.resetMasterPassword = false;
        this.forcePasswordReset = ForceResetPasswordReason.None;
        this.twoFactorProviders = null;
    }
    get requiresCaptcha() {
        return !utils_Utils.isNullOrWhitespace(this.captchaSiteKey);
    }
    get requiresTwoFactor() {
        return this.twoFactorProviders != null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/device.request.ts
class DeviceRequest {
    constructor(appId, platformUtilsService) {
        this.type = platformUtilsService.getDevice();
        this.name = platformUtilsService.getDeviceString();
        this.identifier = appId;
        this.pushToken = null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token-two-factor.request.ts
class TokenTwoFactorRequest {
    constructor(provider = null, token = null, remember = false) {
        this.provider = provider;
        this.token = token;
        this.remember = remember;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/master-password-policy.response.ts

class MasterPasswordPolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.minComplexity = this.getResponseProperty("MinComplexity");
        this.minLength = this.getResponseProperty("MinLength");
        this.requireUpper = this.getResponseProperty("RequireUpper");
        this.requireLower = this.getResponseProperty("RequireLower");
        this.requireNumbers = this.getResponseProperty("RequireNumbers");
        this.requireSpecial = this.getResponseProperty("RequireSpecial");
        this.enforceOnLogin = this.getResponseProperty("EnforceOnLogin");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-token.response.ts


class IdentityTokenResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.accessToken = response.access_token;
        this.expiresIn = response.expires_in;
        this.refreshToken = response.refresh_token;
        this.tokenType = response.token_type;
        this.resetMasterPassword = this.getResponseProperty("ResetMasterPassword");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.key = this.getResponseProperty("Key");
        this.twoFactorToken = this.getResponseProperty("TwoFactorToken");
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.forcePasswordReset = this.getResponseProperty("ForcePasswordReset");
        this.apiUseKeyConnector = this.getResponseProperty("ApiUseKeyConnector");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-two-factor.response.ts


class IdentityTwoFactorResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.twoFactorProviders2 = new Map();
        this.captchaToken = this.getResponseProperty("CaptchaBypassToken");
        this.twoFactorProviders = this.getResponseProperty("TwoFactorProviders");
        const twoFactorProviders2 = this.getResponseProperty("TwoFactorProviders2");
        if (twoFactorProviders2 != null) {
            for (const prop in twoFactorProviders2) {
                // eslint-disable-next-line
                if (twoFactorProviders2.hasOwnProperty(prop)) {
                    this.twoFactorProviders2.set(parseInt(prop, null), twoFactorProviders2[prop]);
                }
            }
        }
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/login.strategy.ts
var login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};










class LogInStrategy {
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService) {
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.captchaBypassToken = null;
    }
    logInTwoFactor(twoFactor, captchaResponse = null) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest.setTwoFactor(twoFactor);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    startLogIn() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            this.twoFactorService.clearSelectedProvider();
            const response = yield this.apiService.postIdentityToken(this.tokenRequest);
            if (response instanceof IdentityTwoFactorResponse) {
                return [yield this.processTwoFactorResponse(response), response];
            }
            else if (response instanceof IdentityCaptchaResponse) {
                return [yield this.processCaptchaResponse(response), response];
            }
            else if (response instanceof IdentityTokenResponse) {
                return [yield this.processTokenResponse(response), response];
            }
            throw new Error("Invalid response object.");
        });
    }
    buildDeviceRequest() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const appId = yield this.appIdService.getAppId();
            return new DeviceRequest(appId, this.platformUtilsService);
        });
    }
    buildTwoFactor(userProvidedTwoFactor) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            if (userProvidedTwoFactor != null) {
                return userProvidedTwoFactor;
            }
            const storedTwoFactorToken = yield this.tokenService.getTwoFactorToken();
            if (storedTwoFactorToken != null) {
                return new TokenTwoFactorRequest(TwoFactorProviderType.Remember, storedTwoFactorToken, false);
            }
            return new TokenTwoFactorRequest();
        });
    }
    saveAccountInformation(tokenResponse) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const accountInformation = yield this.tokenService.decodeToken(tokenResponse.accessToken);
            yield this.stateService.addAccount(new Account({
                profile: Object.assign(Object.assign({}, new AccountProfile()), {
                    userId: accountInformation.sub,
                    name: accountInformation.name,
                    email: accountInformation.email,
                    hasPremiumPersonally: accountInformation.premium,
                    kdfIterations: tokenResponse.kdfIterations,
                    kdfMemory: tokenResponse.kdfMemory,
                    kdfParallelism: tokenResponse.kdfParallelism,
                    kdfType: tokenResponse.kdf,
                }),
                tokens: Object.assign(Object.assign({}, new AccountTokens()), {
                    accessToken: tokenResponse.accessToken,
                    refreshToken: tokenResponse.refreshToken,
                }),
            }));
        });
    }
    processTokenResponse(response) {
        var _a;
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.resetMasterPassword = response.resetMasterPassword;
            if (response.forcePasswordReset) {
                result.forcePasswordReset = ForceResetPasswordReason.AdminForcePasswordReset;
            }
            yield this.saveAccountInformation(response);
            if (response.twoFactorToken != null) {
                yield this.tokenService.setTwoFactorToken(response);
            }
            yield this.setUserKey(response);
            // Must come after the user Key is set, otherwise createKeyPairForOldAccount will fail
            const newSsoUser = response.key == null;
            if (!newSsoUser) {
                yield this.cryptoService.setEncKey(response.key);
                yield this.cryptoService.setEncPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
            }
            this.messagingService.send("loggedIn");
            return result;
        });
    }
    processTwoFactorResponse(response) {
        var _a;
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.twoFactorProviders = response.twoFactorProviders2;
            this.twoFactorService.setProviders(response);
            this.captchaBypassToken = (_a = response.captchaToken) !== null && _a !== void 0 ? _a : null;
            return result;
        });
    }
    processCaptchaResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.captchaSiteKey = response.siteKey;
            return result;
        });
    }
    createKeyPairForOldAccount() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            try {
                const [publicKey, privateKey] = yield this.cryptoService.makeKeyPair();
                yield this.apiService.postAccountKeys(new KeysRequest(publicKey, privateKey.encryptedString));
                return privateKey.encryptedString;
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/password-login.strategy.ts
var password_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class PasswordLogInStrategy extends LogInStrategy {
    get email() {
        return this.tokenRequest.email;
    }
    get masterPasswordHash() {
        return this.tokenRequest.masterPasswordHash;
    }
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, passwordGenerationService, policyService, authService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.stateService = stateService;
        this.passwordGenerationService = passwordGenerationService;
        this.policyService = policyService;
        this.authService = authService;
        /**
         * Options to track if the user needs to update their password due to a password that does not meet an organization's
         * master password policy.
         */
        this.forcePasswordResetReason = ForceResetPasswordReason.None;
    }
    setUserKey() {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setKey(this.key);
            yield this.cryptoService.setKeyHash(this.localHashedPassword);
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : this.captchaBypassToken;
            const result = yield _super.logInTwoFactor.call(this, twoFactor);
            // 2FA was successful, save the force update password options with the state service if defined
            if (!result.requiresTwoFactor &&
                !result.requiresCaptcha &&
                this.forcePasswordResetReason != ForceResetPasswordReason.None) {
                yield this.stateService.setForcePasswordResetReason(this.forcePasswordResetReason);
                result.forcePasswordReset = this.forcePasswordResetReason;
            }
            return result;
        });
    }
    logIn(credentials) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { email, masterPassword, captchaToken, twoFactor } = credentials;
            this.key = yield this.authService.makePreloginKey(masterPassword, email);
            // Hash the password early (before authentication) so we don't persist it in memory in plaintext
            this.localHashedPassword = yield this.cryptoService.hashPassword(masterPassword, this.key, HashPurpose.LocalAuthorization);
            const hashedPassword = yield this.cryptoService.hashPassword(masterPassword, this.key);
            this.tokenRequest = new PasswordTokenRequest(email, hashedPassword, captchaToken, yield this.buildTwoFactor(twoFactor), yield this.buildDeviceRequest());
            const [authResult, identityResponse] = yield this.startLogIn();
            const masterPasswordPolicyOptions = this.getMasterPasswordPolicyOptionsFromResponse(identityResponse);
            // The identity result can contain master password policies for the user's organizations
            if (masterPasswordPolicyOptions === null || masterPasswordPolicyOptions === void 0 ? void 0 : masterPasswordPolicyOptions.enforceOnLogin) {
                // If there is a policy active, evaluate the supplied password before its no longer in memory
                const meetsRequirements = this.evaluateMasterPassword(credentials, masterPasswordPolicyOptions);
                if (!meetsRequirements) {
                    if (authResult.requiresCaptcha || authResult.requiresTwoFactor) {
                        // Save the flag to this strategy for later use as the master password is about to pass out of scope
                        this.forcePasswordResetReason = ForceResetPasswordReason.WeakMasterPassword;
                    }
                    else {
                        // Authentication was successful, save the force update password options with the state service
                        yield this.stateService.setForcePasswordResetReason(ForceResetPasswordReason.WeakMasterPassword);
                        authResult.forcePasswordReset = ForceResetPasswordReason.WeakMasterPassword;
                    }
                }
            }
            return authResult;
        });
    }
    getMasterPasswordPolicyOptionsFromResponse(response) {
        if (response == null || response instanceof IdentityCaptchaResponse) {
            return null;
        }
        return MasterPasswordPolicyOptions.fromResponse(response.masterPasswordPolicy);
    }
    evaluateMasterPassword({ masterPassword, email }, options) {
        var _a;
        const passwordStrength = (_a = this.passwordGenerationService.passwordStrength(masterPassword, email)) === null || _a === void 0 ? void 0 : _a.score;
        return this.policyService.evaluateMasterPassword(passwordStrength, masterPassword, options);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/passwordless-login.strategy.ts
var passwordless_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class PasswordlessLogInStrategy extends LogInStrategy {
    get email() {
        return this.tokenRequest.email;
    }
    get accessCode() {
        return this.passwordlessCredentials.accessCode;
    }
    get authRequestId() {
        return this.passwordlessCredentials.authRequestId;
    }
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, authService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.authService = authService;
    }
    setUserKey() {
        return passwordless_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setKey(this.passwordlessCredentials.decKey);
            yield this.cryptoService.setKeyHash(this.passwordlessCredentials.localPasswordHash);
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return passwordless_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : this.captchaBypassToken;
            return _super.logInTwoFactor.call(this, twoFactor);
        });
    }
    logIn(credentials) {
        return passwordless_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.passwordlessCredentials = credentials;
            this.tokenRequest = new PasswordTokenRequest(credentials.email, credentials.accessCode, null, yield this.buildTwoFactor(credentials.twoFactor), yield this.buildDeviceRequest());
            this.tokenRequest.setPasswordlessAccessCode(credentials.authRequestId);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/sso-token.request.ts

class SsoTokenRequest extends TokenRequest {
    constructor(code, codeVerifier, redirectUri, twoFactor, device) {
        super(twoFactor, device);
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUri = redirectUri;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "authorization_code";
        obj.code = this.code;
        obj.code_verifier = this.codeVerifier;
        obj.redirect_uri = this.redirectUri;
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/sso-login.strategy.ts
var sso_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class SsoLogInStrategy extends LogInStrategy {
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, keyConnectorService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.keyConnectorService = keyConnectorService;
    }
    setUserKey(tokenResponse) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const newSsoUser = tokenResponse.key == null;
            if (tokenResponse.keyConnectorUrl != null) {
                if (!newSsoUser) {
                    yield this.keyConnectorService.getAndSetKey(tokenResponse.keyConnectorUrl);
                }
                else {
                    yield this.keyConnectorService.convertNewSsoUserToKeyConnector(tokenResponse, this.orgId);
                }
            }
        });
    }
    logIn(credentials) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.orgId = credentials.orgId;
            this.tokenRequest = new SsoTokenRequest(credentials.code, credentials.codeVerifier, credentials.redirectUrl, yield this.buildTwoFactor(credentials.twoFactor), yield this.buildDeviceRequest());
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/user-api-token.request.ts

class UserApiTokenRequest extends TokenRequest {
    constructor(clientId, clientSecret, twoFactor, device) {
        super(twoFactor, device);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.twoFactor = twoFactor;
    }
    toIdentityToken() {
        const obj = super.toIdentityToken(this.clientId);
        obj.scope = this.clientId.startsWith("organization") ? "api.organization" : "api";
        obj.grant_type = "client_credentials";
        obj.client_secret = this.clientSecret;
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/user-api-login.strategy.ts
var user_api_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class UserApiLogInStrategy extends LogInStrategy {
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, environmentService, keyConnectorService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.environmentService = environmentService;
        this.keyConnectorService = keyConnectorService;
    }
    setUserKey(tokenResponse) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            if (tokenResponse.apiUseKeyConnector) {
                const keyConnectorUrl = this.environmentService.getKeyConnectorUrl();
                yield this.keyConnectorService.getAndSetKey(keyConnectorUrl);
            }
        });
    }
    logIn(credentials) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest = new UserApiTokenRequest(credentials.clientId, credentials.clientSecret, yield this.buildTwoFactor(), yield this.buildDeviceRequest());
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    saveAccountInformation(tokenResponse) {
        const _super = Object.create(null, {
            saveAccountInformation: { get: () => super.saveAccountInformation }
        });
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield _super.saveAccountInformation.call(this, tokenResponse);
            yield this.stateService.setApiKeyClientId(this.tokenRequest.clientId);
            yield this.stateService.setApiKeyClientSecret(this.tokenRequest.clientSecret);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/passwordless-auth.request.ts
class PasswordlessAuthRequest {
    constructor(key, masterPasswordHash, deviceIdentifier, requestApproved) {
        this.key = key;
        this.masterPasswordHash = masterPasswordHash;
        this.deviceIdentifier = deviceIdentifier;
        this.requestApproved = requestApproved;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/auth.service.ts
var auth_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













const sessionTimeoutLength = 2 * 60 * 1000; // 2 minutes
class AuthService {
    get email() {
        if (this.logInStrategy instanceof PasswordLogInStrategy ||
            this.logInStrategy instanceof PasswordlessLogInStrategy) {
            return this.logInStrategy.email;
        }
        return null;
    }
    get masterPasswordHash() {
        return this.logInStrategy instanceof PasswordLogInStrategy
            ? this.logInStrategy.masterPasswordHash
            : null;
    }
    get accessCode() {
        return this.logInStrategy instanceof PasswordlessLogInStrategy
            ? this.logInStrategy.accessCode
            : null;
    }
    get authRequestId() {
        return this.logInStrategy instanceof PasswordlessLogInStrategy
            ? this.logInStrategy.authRequestId
            : null;
    }
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, keyConnectorService, environmentService, stateService, twoFactorService, i18nService, encryptService, passwordGenerationService, policyService) {
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.i18nService = i18nService;
        this.encryptService = encryptService;
        this.passwordGenerationService = passwordGenerationService;
        this.policyService = policyService;
        this.pushNotificationSubject = new external_rxjs_namespaceObject.Subject();
    }
    logIn(credentials) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            this.clearState();
            let strategy;
            switch (credentials.type) {
                case authentication_type_AuthenticationType.Password:
                    strategy = new PasswordLogInStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.passwordGenerationService, this.policyService, this);
                    break;
                case authentication_type_AuthenticationType.Sso:
                    strategy = new SsoLogInStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.keyConnectorService);
                    break;
                case authentication_type_AuthenticationType.UserApi:
                    strategy = new UserApiLogInStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.environmentService, this.keyConnectorService);
                    break;
                case authentication_type_AuthenticationType.Passwordless:
                    strategy = new PasswordlessLogInStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this);
                    break;
            }
            const result = yield strategy.logIn(credentials);
            if (result === null || result === void 0 ? void 0 : result.requiresTwoFactor) {
                this.saveState(strategy);
            }
            return result;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            if (this.logInStrategy == null) {
                throw new Error(this.i18nService.t("sessionTimeout"));
            }
            try {
                const result = yield this.logInStrategy.logInTwoFactor(twoFactor, captchaResponse);
                // Only clear state if 2FA token has been accepted, otherwise we need to be able to try again
                if (!result.requiresTwoFactor && !result.requiresCaptcha) {
                    this.clearState();
                }
                return result;
            }
            catch (e) {
                // API exceptions are okay, but if there are any unhandled client-side errors then clear state to be safe
                if (!(e instanceof ErrorResponse)) {
                    this.clearState();
                }
                throw e;
            }
        });
    }
    logOut(callback) {
        callback();
        this.messagingService.send("loggedOut");
    }
    authingWithUserApiKey() {
        return this.logInStrategy instanceof UserApiLogInStrategy;
    }
    authingWithSso() {
        return this.logInStrategy instanceof SsoLogInStrategy;
    }
    authingWithPassword() {
        return this.logInStrategy instanceof PasswordLogInStrategy;
    }
    authingWithPasswordless() {
        return this.logInStrategy instanceof PasswordlessLogInStrategy;
    }
    getAuthStatus(userId) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            const isAuthenticated = yield this.stateService.getIsAuthenticated({ userId: userId });
            if (!isAuthenticated) {
                return AuthenticationStatus.LoggedOut;
            }
            // Keys aren't stored for a device that is locked or logged out
            // Make sure we're logged in before checking this, otherwise we could mix up those states
            const neverLock = (yield this.cryptoService.hasKeyStored(KeySuffixOptions.Auto, userId)) &&
                !(yield this.stateService.getEverBeenUnlocked({ userId: userId }));
            if (neverLock) {
                // TODO: This also _sets_ the key so when we check memory in the next line it finds a key.
                // We should refactor here.
                yield this.cryptoService.getKey(KeySuffixOptions.Auto, userId);
            }
            const hasKeyInMemory = yield this.cryptoService.hasKeyInMemory(userId);
            if (!hasKeyInMemory) {
                return AuthenticationStatus.Locked;
            }
            return AuthenticationStatus.Unlocked;
        });
    }
    makePreloginKey(masterPassword, email) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            email = email.trim().toLowerCase();
            let kdf = null;
            let kdfConfig = null;
            try {
                const preloginResponse = yield this.apiService.postPrelogin(new PreloginRequest(email));
                if (preloginResponse != null) {
                    kdf = preloginResponse.kdf;
                    kdfConfig = new KdfConfig(preloginResponse.kdfIterations, preloginResponse.kdfMemory, preloginResponse.kdfParallelism);
                }
            }
            catch (e) {
                if (e == null || e.statusCode !== 404) {
                    throw e;
                }
            }
            return this.cryptoService.makeKey(masterPassword, email, kdf, kdfConfig);
        });
    }
    authResponsePushNotifiction(notification) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            this.pushNotificationSubject.next(notification.id);
        });
    }
    getPushNotifcationObs$() {
        return this.pushNotificationSubject.asObservable();
    }
    passwordlessLogin(id, key, requestApproved) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            const pubKey = utils_Utils.fromB64ToArray(key);
            const encryptedKey = yield this.cryptoService.rsaEncrypt((yield this.cryptoService.getKey()).encKey, pubKey.buffer);
            const encryptedMasterPassword = yield this.cryptoService.rsaEncrypt(utils_Utils.fromUtf8ToArray(yield this.stateService.getKeyHash()), pubKey.buffer);
            const request = new PasswordlessAuthRequest(encryptedKey.encryptedString, encryptedMasterPassword.encryptedString, yield this.appIdService.getAppId(), requestApproved);
            return yield this.apiService.putAuthRequest(id, request);
        });
    }
    saveState(strategy) {
        this.logInStrategy = strategy;
        this.startSessionTimeout();
    }
    clearState() {
        this.logInStrategy = null;
        this.clearSessionTimeout();
    }
    startSessionTimeout() {
        this.clearSessionTimeout();
        this.sessionTimeout = setTimeout(() => this.clearState(), sessionTimeoutLength);
    }
    clearSessionTimeout() {
        if (this.sessionTimeout != null) {
            clearTimeout(this.sessionTimeout);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/key-connector-user-key.request.ts
class KeyConnectorUserKeyRequest {
    constructor(key) {
        this.key = key;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/set-key-connector-key.request.ts
class SetKeyConnectorKeyRequest {
    constructor(key, kdf, kdfConfig, orgIdentifier, keys) {
        this.key = key;
        this.kdf = kdf;
        this.kdfIterations = kdfConfig.iterations;
        this.kdfMemory = kdfConfig.memory;
        this.kdfParallelism = kdfConfig.parallelism;
        this.orgIdentifier = orgIdentifier;
        this.keys = keys;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/key-connector.service.ts
var key_connector_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class KeyConnectorService {
    constructor(stateService, cryptoService, apiService, tokenService, logService, organizationService, cryptoFunctionService, logoutCallback) {
        this.stateService = stateService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.logService = logService;
        this.organizationService = organizationService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.logoutCallback = logoutCallback;
    }
    setUsesKeyConnector(usesKeyConnector) {
        return this.stateService.setUsesKeyConnector(usesKeyConnector);
    }
    getUsesKeyConnector() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getUsesKeyConnector();
        });
    }
    userNeedsMigration() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const loggedInUsingSso = yield this.tokenService.getIsExternal();
            const requiredByOrganization = (yield this.getManagingOrganization()) != null;
            const userIsNotUsingKeyConnector = !(yield this.getUsesKeyConnector());
            return loggedInUsingSso && requiredByOrganization && userIsNotUsingKeyConnector;
        });
    }
    migrateUser() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const organization = yield this.getManagingOrganization();
            const key = yield this.cryptoService.getKey();
            const keyConnectorRequest = new KeyConnectorUserKeyRequest(key.encKeyB64);
            try {
                yield this.apiService.postUserKeyToKeyConnector(organization.keyConnectorUrl, keyConnectorRequest);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
            yield this.apiService.postConvertToKeyConnector();
        });
    }
    getAndSetKey(url) {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            try {
                const userKeyResponse = yield this.apiService.getUserKeyFromKeyConnector(url);
                const keyArr = utils_Utils.fromB64ToArray(userKeyResponse.key);
                const k = new SymmetricCryptoKey(keyArr);
                yield this.cryptoService.setKey(k);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
        });
    }
    getManagingOrganization() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const orgs = yield this.organizationService.getAll();
            return orgs.find((o) => o.keyConnectorEnabled &&
                o.type !== OrganizationUserType.Admin &&
                o.type !== OrganizationUserType.Owner &&
                !o.isProviderUser);
        });
    }
    convertNewSsoUserToKeyConnector(tokenResponse, orgId) {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const { kdf, kdfIterations, kdfMemory, kdfParallelism, keyConnectorUrl } = tokenResponse;
            const password = yield this.cryptoFunctionService.randomBytes(64);
            const kdfConfig = new KdfConfig(kdfIterations, kdfMemory, kdfParallelism);
            const k = yield this.cryptoService.makeKey(utils_Utils.fromBufferToB64(password), yield this.tokenService.getEmail(), kdf, kdfConfig);
            const keyConnectorRequest = new KeyConnectorUserKeyRequest(k.encKeyB64);
            yield this.cryptoService.setKey(k);
            const encKey = yield this.cryptoService.makeEncKey(k);
            yield this.cryptoService.setEncKey(encKey[1].encryptedString);
            const [pubKey, privKey] = yield this.cryptoService.makeKeyPair();
            try {
                yield this.apiService.postUserKeyToKeyConnector(keyConnectorUrl, keyConnectorRequest);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
            const keys = new KeysRequest(pubKey, privKey.encryptedString);
            const setPasswordRequest = new SetKeyConnectorKeyRequest(encKey[1].encryptedString, kdf, kdfConfig, orgId, keys);
            yield this.apiService.postSetKeyConnectorKey(setPasswordRequest);
        });
    }
    setConvertAccountRequired(status) {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setConvertAccountToKeyConnector(status);
        });
    }
    getConvertAccountRequired() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getConvertAccountToKeyConnector();
        });
    }
    removeConvertAccountRequired() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setConvertAccountToKeyConnector(null);
        });
    }
    clear() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.removeConvertAccountRequired();
        });
    }
    handleKeyConnectorError(e) {
        this.logService.error(e);
        if (this.logoutCallback != null) {
            this.logoutCallback(false);
        }
        throw new Error("Key Connector error");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/token.service.ts
var token_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class TokenService {
    static decodeToken(token) {
        if (token == null) {
            throw new Error("Token not provided.");
        }
        const parts = token.split(".");
        if (parts.length !== 3) {
            throw new Error("JWT must have 3 parts");
        }
        const decoded = utils_Utils.fromUrlB64ToUtf8(parts[1]);
        if (decoded == null) {
            throw new Error("Cannot decode the token");
        }
        const decodedToken = JSON.parse(decoded);
        return decodedToken;
    }
    constructor(stateService) {
        this.stateService = stateService;
    }
    setTokens(accessToken, refreshToken, clientIdClientSecret) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.setToken(accessToken);
            yield this.setRefreshToken(refreshToken);
            if (clientIdClientSecret != null) {
                yield this.setClientId(clientIdClientSecret[0]);
                yield this.setClientSecret(clientIdClientSecret[1]);
            }
        });
    }
    setClientId(clientId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setApiKeyClientId(clientId);
        });
    }
    getClientId() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getApiKeyClientId();
        });
    }
    setClientSecret(clientSecret) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setApiKeyClientSecret(clientSecret);
        });
    }
    getClientSecret() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getApiKeyClientSecret();
        });
    }
    setToken(token) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setAccessToken(token);
        });
    }
    getToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getAccessToken();
        });
    }
    setRefreshToken(refreshToken) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setRefreshToken(refreshToken);
        });
    }
    getRefreshToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getRefreshToken();
        });
    }
    setTwoFactorToken(tokenResponse) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setTwoFactorToken(tokenResponse.twoFactorToken);
        });
    }
    getTwoFactorToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getTwoFactorToken();
        });
    }
    clearTwoFactorToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setTwoFactorToken(null);
        });
    }
    clearToken(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setAccessToken(null, { userId: userId });
            yield this.stateService.setRefreshToken(null, { userId: userId });
            yield this.stateService.setApiKeyClientId(null, { userId: userId });
            yield this.stateService.setApiKeyClientSecret(null, { userId: userId });
        });
    }
    // jwthelper methods
    // ref https://github.com/auth0/angular-jwt/blob/master/src/angularJwt/services/jwt.js
    decodeToken(token) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            token = token !== null && token !== void 0 ? token : (yield this.stateService.getAccessToken());
            if (token == null) {
                throw new Error("Token not found.");
            }
            return TokenService.decodeToken(token);
        });
    }
    getTokenExpirationDate() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.exp === "undefined") {
                return null;
            }
            const d = new Date(0); // The 0 here is the key, which sets the date to the epoch
            d.setUTCSeconds(decoded.exp);
            return d;
        });
    }
    tokenSecondsRemaining(offsetSeconds = 0) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const d = yield this.getTokenExpirationDate();
            if (d == null) {
                return 0;
            }
            const msRemaining = d.valueOf() - (new Date().valueOf() + offsetSeconds * 1000);
            return Math.round(msRemaining / 1000);
        });
    }
    tokenNeedsRefresh(minutes = 5) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const sRemaining = yield this.tokenSecondsRemaining();
            return sRemaining < 60 * minutes;
        });
    }
    getUserId() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.sub === "undefined") {
                throw new Error("No user id found");
            }
            return decoded.sub;
        });
    }
    getEmail() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.email === "undefined") {
                throw new Error("No email found");
            }
            return decoded.email;
        });
    }
    getEmailVerified() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.email_verified === "undefined") {
                throw new Error("No email verification found");
            }
            return decoded.email_verified;
        });
    }
    getName() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.name === "undefined") {
                return null;
            }
            return decoded.name;
        });
    }
    getIssuer() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.iss === "undefined") {
                throw new Error("No issuer found");
            }
            return decoded.iss;
        });
    }
    getIsExternal() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            return Array.isArray(decoded.amr) && decoded.amr.includes("external");
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/two-factor.service.ts

const TwoFactorProviders = {
    [TwoFactorProviderType.Authenticator]: {
        type: TwoFactorProviderType.Authenticator,
        name: null,
        description: null,
        priority: 1,
        sort: 1,
        premium: false,
    },
    [TwoFactorProviderType.Yubikey]: {
        type: TwoFactorProviderType.Yubikey,
        name: null,
        description: null,
        priority: 3,
        sort: 2,
        premium: true,
    },
    [TwoFactorProviderType.Duo]: {
        type: TwoFactorProviderType.Duo,
        name: "Duo",
        description: null,
        priority: 2,
        sort: 3,
        premium: true,
    },
    [TwoFactorProviderType.OrganizationDuo]: {
        type: TwoFactorProviderType.OrganizationDuo,
        name: "Duo (Organization)",
        description: null,
        priority: 10,
        sort: 4,
        premium: false,
    },
    [TwoFactorProviderType.Email]: {
        type: TwoFactorProviderType.Email,
        name: null,
        description: null,
        priority: 0,
        sort: 6,
        premium: false,
    },
    [TwoFactorProviderType.WebAuthn]: {
        type: TwoFactorProviderType.WebAuthn,
        name: null,
        description: null,
        priority: 4,
        sort: 5,
        premium: true,
    },
};
class TwoFactorService {
    constructor(i18nService, platformUtilsService) {
        this.i18nService = i18nService;
        this.platformUtilsService = platformUtilsService;
        this.selectedTwoFactorProviderType = null;
    }
    init() {
        TwoFactorProviders[TwoFactorProviderType.Email].name = this.i18nService.t("emailTitle");
        TwoFactorProviders[TwoFactorProviderType.Email].description = this.i18nService.t("emailDesc");
        TwoFactorProviders[TwoFactorProviderType.Authenticator].name =
            this.i18nService.t("authenticatorAppTitle");
        TwoFactorProviders[TwoFactorProviderType.Authenticator].description =
            this.i18nService.t("authenticatorAppDesc");
        TwoFactorProviders[TwoFactorProviderType.Duo].description = this.i18nService.t("duoDesc");
        TwoFactorProviders[TwoFactorProviderType.OrganizationDuo].name =
            "Duo (" + this.i18nService.t("organization") + ")";
        TwoFactorProviders[TwoFactorProviderType.OrganizationDuo].description =
            this.i18nService.t("duoOrganizationDesc");
        TwoFactorProviders[TwoFactorProviderType.WebAuthn].name = this.i18nService.t("webAuthnTitle");
        TwoFactorProviders[TwoFactorProviderType.WebAuthn].description =
            this.i18nService.t("webAuthnDesc");
        TwoFactorProviders[TwoFactorProviderType.Yubikey].name = this.i18nService.t("yubiKeyTitle");
        TwoFactorProviders[TwoFactorProviderType.Yubikey].description =
            this.i18nService.t("yubiKeyDesc");
    }
    getSupportedProviders(win) {
        const providers = [];
        if (this.twoFactorProvidersData == null) {
            return providers;
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.OrganizationDuo) &&
            this.platformUtilsService.supportsDuo()) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.OrganizationDuo]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Authenticator)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Authenticator]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Yubikey)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Yubikey]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Duo) &&
            this.platformUtilsService.supportsDuo()) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Duo]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.WebAuthn) &&
            this.platformUtilsService.supportsWebAuthn(win)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.WebAuthn]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Email)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Email]);
        }
        return providers;
    }
    getDefaultProvider(webAuthnSupported) {
        if (this.twoFactorProvidersData == null) {
            return null;
        }
        if (this.selectedTwoFactorProviderType != null &&
            this.twoFactorProvidersData.has(this.selectedTwoFactorProviderType)) {
            return this.selectedTwoFactorProviderType;
        }
        let providerType = null;
        let providerPriority = -1;
        this.twoFactorProvidersData.forEach((_value, type) => {
            const provider = TwoFactorProviders[type];
            if (provider != null && provider.priority > providerPriority) {
                if (type === TwoFactorProviderType.WebAuthn && !webAuthnSupported) {
                    return;
                }
                providerType = type;
                providerPriority = provider.priority;
            }
        });
        return providerType;
    }
    setSelectedProvider(type) {
        this.selectedTwoFactorProviderType = type;
    }
    clearSelectedProvider() {
        this.selectedTwoFactorProviderType = null;
    }
    setProviders(response) {
        this.twoFactorProvidersData = response.twoFactorProviders2;
    }
    clearProviders() {
        this.twoFactorProvidersData = null;
    }
    getProviders() {
        return this.twoFactorProvidersData;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/user-verification/user-verification-api.service.ts
var user_verification_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class UserVerificationApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    postAccountVerifyOTP(request) {
        return this.apiService.send("POST", "/accounts/verify-otp", request, true, false);
    }
    postAccountRequestOTP() {
        return user_verification_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/accounts/request-otp", null, true, false);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/verification-type.ts
var VerificationType;
(function (VerificationType) {
    VerificationType[VerificationType["MasterPassword"] = 0] = "MasterPassword";
    VerificationType[VerificationType["OTP"] = 1] = "OTP";
})(VerificationType || (VerificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/secret-verification.request.ts
class SecretVerificationRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/verify-otp.request.ts
class VerifyOTPRequest {
    constructor(OTP) {
        this.OTP = OTP;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/user-verification/user-verification.service.ts
var user_verification_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/**
 * Used for general-purpose user verification throughout the app.
 * Use it to verify the input collected by UserVerificationComponent.
 */
class UserVerificationService {
    constructor(cryptoService, i18nService, userVerificationApiService) {
        this.cryptoService = cryptoService;
        this.i18nService = i18nService;
        this.userVerificationApiService = userVerificationApiService;
    }
    /**
     * Create a new request model to be used for server-side verification
     * @param verification User-supplied verification data (Master Password or OTP)
     * @param requestClass The request model to create
     * @param alreadyHashed Whether the master password is already hashed
     */
    buildRequest(verification, requestClass, alreadyHashed) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            this.validateInput(verification);
            const request = requestClass != null ? new requestClass() : new SecretVerificationRequest();
            if (verification.type === VerificationType.OTP) {
                request.otp = verification.secret;
            }
            else {
                request.masterPasswordHash = alreadyHashed
                    ? verification.secret
                    : yield this.cryptoService.hashPassword(verification.secret, null);
            }
            return request;
        });
    }
    /**
     * Used to verify the Master Password client-side, or send the OTP to the server for verification (with no other data)
     * Generally used for client-side verification only.
     * @param verification User-supplied verification data (Master Password or OTP)
     */
    verifyUser(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            this.validateInput(verification);
            if (verification.type === VerificationType.OTP) {
                const request = new VerifyOTPRequest(verification.secret);
                try {
                    yield this.userVerificationApiService.postAccountVerifyOTP(request);
                }
                catch (e) {
                    throw new Error(this.i18nService.t("invalidVerificationCode"));
                }
            }
            else {
                const passwordValid = yield this.cryptoService.compareAndUpdateKeyHash(verification.secret, null);
                if (!passwordValid) {
                    throw new Error(this.i18nService.t("invalidMasterPassword"));
                }
            }
            return true;
        });
    }
    requestOTP() {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            yield this.userVerificationApiService.postAccountRequestOTP();
        });
    }
    validateInput(verification) {
        if ((verification === null || verification === void 0 ? void 0 : verification.secret) == null || verification.secret === "") {
            if (verification.type === VerificationType.OTP) {
                throw new Error(this.i18nService.t("verificationCodeRequired"));
            }
            else {
                throw new Error(this.i18nService.t("masterPasswordRequired"));
            }
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/factories/accountFactory.ts
class AccountFactory {
    constructor(accountConstructor) {
        this.accountConstructor = accountConstructor;
    }
    create(args) {
        return new this.accountConstructor(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/factories/globalStateFactory.ts
class GlobalStateFactory {
    constructor(globalStateConstructor) {
        this.globalStateConstructor = globalStateConstructor;
    }
    create(args) {
        return new this.globalStateConstructor(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/factories/stateFactory.ts


class StateFactory {
    constructor(globalStateConstructor, accountConstructor) {
        this.globalStateFactory = new GlobalStateFactory(globalStateConstructor);
        this.accountFactory = new AccountFactory(accountConstructor);
    }
    createGlobal(args) {
        return this.globalStateFactory.create(args);
    }
    createAccount(args) {
        return this.accountFactory.create(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/window-state.ts
class WindowState {
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/global-state.ts



class GlobalState {
    constructor() {
        this.theme = ThemeType.System;
        this.window = new WindowState();
        this.stateVersion = StateVersion.One;
        this.environmentUrls = new EnvironmentUrls();
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/appId.service.ts
var appId_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class AppIdService {
    constructor(storageService) {
        this.storageService = storageService;
    }
    getAppId() {
        return this.makeAndGetAppId("appId");
    }
    getAnonymousAppId() {
        return this.makeAndGetAppId("anonymousAppId");
    }
    makeAndGetAppId(key) {
        return appId_service_awaiter(this, void 0, void 0, function* () {
            const existingId = yield this.storageService.get(key, {
                htmlStorageLocation: HtmlStorageLocation.Local,
            });
            if (existingId != null) {
                return existingId;
            }
            const guid = utils_Utils.newGuid();
            yield this.storageService.save(key, guid, {
                htmlStorageLocation: HtmlStorageLocation.Local,
            });
            return guid;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/misc/throttle.ts
/**
 * Use as a Decorator on async functions, it will limit how many times the function can be
 * in-flight at a time.
 *
 * Calls beyond the limit will be queued, and run when one of the active calls finishes
 */
function throttle(limit, throttleKey) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        const allThrottles = new Map();
        const getThrottles = (obj) => {
            let throttles = allThrottles.get(obj);
            if (throttles != null) {
                return throttles;
            }
            throttles = new Map();
            allThrottles.set(obj, throttles);
            return throttles;
        };
        return {
            value: function (...args) {
                const throttles = getThrottles(this);
                const argsThrottleKey = throttleKey(args);
                let queue = throttles.get(argsThrottleKey);
                if (queue == null) {
                    queue = [];
                    throttles.set(argsThrottleKey, queue);
                }
                return new Promise((resolve, reject) => {
                    const exec = () => {
                        const onFinally = () => {
                            queue.splice(queue.indexOf(exec), 1);
                            if (queue.length >= limit) {
                                queue[limit - 1]();
                            }
                            else if (queue.length === 0) {
                                throttles.delete(argsThrottleKey);
                                if (throttles.size === 0) {
                                    allThrottles.delete(this);
                                }
                            }
                        };
                        originalMethod
                            .apply(this, args)
                            .then((val) => {
                            onFinally();
                            return val;
                        })
                            .catch((err) => {
                            onFinally();
                            throw err;
                        })
                            .then(resolve, reject);
                    };
                    queue.push(exec);
                    if (queue.length <= limit) {
                        exec();
                    }
                });
            },
        };
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/services/audit.service.ts
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var audit_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const PwnedPasswordsApi = "https://api.pwnedpasswords.com/range/";
class AuditService {
    constructor(cryptoFunctionService, apiService) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.apiService = apiService;
    }
    passwordLeaked(password) {
        return audit_service_awaiter(this, void 0, void 0, function* () {
            const hashBytes = yield this.cryptoFunctionService.hash(password, "sha1");
            const hash = utils_Utils.fromBufferToHex(hashBytes).toUpperCase();
            const hashStart = hash.substr(0, 5);
            const hashEnding = hash.substr(5);
            const response = yield this.apiService.nativeFetch(new Request(PwnedPasswordsApi + hashStart));
            const leakedHashes = yield response.text();
            const match = leakedHashes.split(/\r?\n/).find((v) => {
                return v.split(":")[0] === hashEnding;
            });
            return match != null ? parseInt(match.split(":")[1], 10) : 0;
        });
    }
    breachedAccounts(username) {
        return audit_service_awaiter(this, void 0, void 0, function* () {
            try {
                return yield this.apiService.getHibpBreach(username);
            }
            catch (e) {
                const error = e;
                if (error.statusCode === 404) {
                    return [];
                }
                throw new Error();
            }
        });
    }
}
__decorate([
    throttle(100, () => "passwordLeaked"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AuditService.prototype, "passwordLeaked", null);

;// CONCATENATED MODULE: ../../libs/common/src/services/broadcaster.service.ts
class BroadcasterService {
    constructor() {
        this.subscribers = new Map();
    }
    send(message, id) {
        if (id != null) {
            if (this.subscribers.has(id)) {
                this.subscribers.get(id)(message);
            }
            return;
        }
        this.subscribers.forEach((value) => {
            value(message);
        });
    }
    subscribe(id, messageCallback) {
        this.subscribers.set(id, messageCallback);
    }
    unsubscribe(id) {
        if (this.subscribers.has(id)) {
            this.subscribers.delete(id);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/container.service.ts
class ContainerService {
    constructor(cryptoService, encryptService) {
        this.cryptoService = cryptoService;
        this.encryptService = encryptService;
    }
    attachToGlobal(global) {
        if (!global.bitwardenContainerService) {
            global.bitwardenContainerService = this;
        }
    }
    /**
     * @throws Will throw if CryptoService was not instantiated and provided to the ContainerService constructor
     */
    getCryptoService() {
        if (this.cryptoService == null) {
            throw new Error("ContainerService.cryptoService not initialized.");
        }
        return this.cryptoService;
    }
    /**
     * @throws Will throw if EncryptService was not instantiated and provided to the ContainerService constructor
     */
    getEncryptService() {
        if (this.encryptService == null) {
            throw new Error("ContainerService.encryptService not initialized.");
        }
        return this.encryptService;
    }
}

;// CONCATENATED MODULE: external "big-integer"
const external_big_integer_namespaceObject = require("big-integer");
;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/encrypted-organization-key.ts
var encrypted_organization_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class BaseEncryptedOrganizationKey {
    static fromData(data) {
        switch (data.type) {
            case "organization":
                return new EncryptedOrganizationKey(data.key);
            case "provider":
                return new ProviderEncryptedOrganizationKey(data.key, data.providerId);
            default:
                return null;
        }
    }
}
class EncryptedOrganizationKey {
    constructor(key) {
        this.key = key;
    }
    decrypt(cryptoService) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            const decValue = yield cryptoService.rsaDecrypt(this.key);
            return new SymmetricCryptoKey(decValue);
        });
    }
    toData() {
        return {
            type: "organization",
            key: this.key,
        };
    }
}
class ProviderEncryptedOrganizationKey {
    constructor(key, providerId) {
        this.key = key;
        this.providerId = providerId;
    }
    decrypt(cryptoService) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            const providerKey = yield cryptoService.getProviderKey(this.providerId);
            const decValue = yield cryptoService.decryptToBytes(new EncString(this.key), providerKey);
            return new SymmetricCryptoKey(decValue);
        });
    }
    toData() {
        return {
            type: "provider",
            key: this.key,
            providerId: this.providerId,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/misc/sequentialize.ts
/**
 * Use as a Decorator on async functions, it will prevent multiple 'active' calls as the same time
 *
 * If a promise was returned from a previous call to this function, that hasn't yet resolved it will
 * be returned, instead of calling the original function again
 *
 * Results are not cached, once the promise has returned, the next call will result in a fresh call
 *
 * Read more at https://github.com/bitwarden/jslib/pull/7
 */
function sequentialize(cacheKey) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        const caches = new Map();
        const getCache = (obj) => {
            let cache = caches.get(obj);
            if (cache != null) {
                return cache;
            }
            cache = new Map();
            caches.set(obj, cache);
            return cache;
        };
        return {
            value: function (...args) {
                const cache = getCache(this);
                const argsCacheKey = cacheKey(args);
                let response = cache.get(argsCacheKey);
                if (response != null) {
                    return response;
                }
                const onFinally = () => {
                    cache.delete(argsCacheKey);
                    if (cache.size === 0) {
                        caches.delete(this);
                    }
                };
                response = originalMethod
                    .apply(this, args)
                    .then((val) => {
                    onFinally();
                    return val;
                })
                    .catch((err) => {
                    onFinally();
                    throw err;
                });
                cache.set(argsCacheKey, response);
                return response;
            },
        };
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/misc/wordlist.ts
// EFF's Long Wordlist from https://www.eff.org/dice
const EFFLongWordList = [
    "abacus",
    "abdomen",
    "abdominal",
    "abide",
    "abiding",
    "ability",
    "ablaze",
    "able",
    "abnormal",
    "abrasion",
    "abrasive",
    "abreast",
    "abridge",
    "abroad",
    "abruptly",
    "absence",
    "absentee",
    "absently",
    "absinthe",
    "absolute",
    "absolve",
    "abstain",
    "abstract",
    "absurd",
    "accent",
    "acclaim",
    "acclimate",
    "accompany",
    "account",
    "accuracy",
    "accurate",
    "accustom",
    "acetone",
    "achiness",
    "aching",
    "acid",
    "acorn",
    "acquaint",
    "acquire",
    "acre",
    "acrobat",
    "acronym",
    "acting",
    "action",
    "activate",
    "activator",
    "active",
    "activism",
    "activist",
    "activity",
    "actress",
    "acts",
    "acutely",
    "acuteness",
    "aeration",
    "aerobics",
    "aerosol",
    "aerospace",
    "afar",
    "affair",
    "affected",
    "affecting",
    "affection",
    "affidavit",
    "affiliate",
    "affirm",
    "affix",
    "afflicted",
    "affluent",
    "afford",
    "affront",
    "aflame",
    "afloat",
    "aflutter",
    "afoot",
    "afraid",
    "afterglow",
    "afterlife",
    "aftermath",
    "aftermost",
    "afternoon",
    "aged",
    "ageless",
    "agency",
    "agenda",
    "agent",
    "aggregate",
    "aghast",
    "agile",
    "agility",
    "aging",
    "agnostic",
    "agonize",
    "agonizing",
    "agony",
    "agreeable",
    "agreeably",
    "agreed",
    "agreeing",
    "agreement",
    "aground",
    "ahead",
    "ahoy",
    "aide",
    "aids",
    "aim",
    "ajar",
    "alabaster",
    "alarm",
    "albatross",
    "album",
    "alfalfa",
    "algebra",
    "algorithm",
    "alias",
    "alibi",
    "alienable",
    "alienate",
    "aliens",
    "alike",
    "alive",
    "alkaline",
    "alkalize",
    "almanac",
    "almighty",
    "almost",
    "aloe",
    "aloft",
    "aloha",
    "alone",
    "alongside",
    "aloof",
    "alphabet",
    "alright",
    "although",
    "altitude",
    "alto",
    "aluminum",
    "alumni",
    "always",
    "amaretto",
    "amaze",
    "amazingly",
    "amber",
    "ambiance",
    "ambiguity",
    "ambiguous",
    "ambition",
    "ambitious",
    "ambulance",
    "ambush",
    "amendable",
    "amendment",
    "amends",
    "amenity",
    "amiable",
    "amicably",
    "amid",
    "amigo",
    "amino",
    "amiss",
    "ammonia",
    "ammonium",
    "amnesty",
    "amniotic",
    "among",
    "amount",
    "amperage",
    "ample",
    "amplifier",
    "amplify",
    "amply",
    "amuck",
    "amulet",
    "amusable",
    "amused",
    "amusement",
    "amuser",
    "amusing",
    "anaconda",
    "anaerobic",
    "anagram",
    "anatomist",
    "anatomy",
    "anchor",
    "anchovy",
    "ancient",
    "android",
    "anemia",
    "anemic",
    "aneurism",
    "anew",
    "angelfish",
    "angelic",
    "anger",
    "angled",
    "angler",
    "angles",
    "angling",
    "angrily",
    "angriness",
    "anguished",
    "angular",
    "animal",
    "animate",
    "animating",
    "animation",
    "animator",
    "anime",
    "animosity",
    "ankle",
    "annex",
    "annotate",
    "announcer",
    "annoying",
    "annually",
    "annuity",
    "anointer",
    "another",
    "answering",
    "antacid",
    "antarctic",
    "anteater",
    "antelope",
    "antennae",
    "anthem",
    "anthill",
    "anthology",
    "antibody",
    "antics",
    "antidote",
    "antihero",
    "antiquely",
    "antiques",
    "antiquity",
    "antirust",
    "antitoxic",
    "antitrust",
    "antiviral",
    "antivirus",
    "antler",
    "antonym",
    "antsy",
    "anvil",
    "anybody",
    "anyhow",
    "anymore",
    "anyone",
    "anyplace",
    "anything",
    "anytime",
    "anyway",
    "anywhere",
    "aorta",
    "apache",
    "apostle",
    "appealing",
    "appear",
    "appease",
    "appeasing",
    "appendage",
    "appendix",
    "appetite",
    "appetizer",
    "applaud",
    "applause",
    "apple",
    "appliance",
    "applicant",
    "applied",
    "apply",
    "appointee",
    "appraisal",
    "appraiser",
    "apprehend",
    "approach",
    "approval",
    "approve",
    "apricot",
    "april",
    "apron",
    "aptitude",
    "aptly",
    "aqua",
    "aqueduct",
    "arbitrary",
    "arbitrate",
    "ardently",
    "area",
    "arena",
    "arguable",
    "arguably",
    "argue",
    "arise",
    "armadillo",
    "armband",
    "armchair",
    "armed",
    "armful",
    "armhole",
    "arming",
    "armless",
    "armoire",
    "armored",
    "armory",
    "armrest",
    "army",
    "aroma",
    "arose",
    "around",
    "arousal",
    "arrange",
    "array",
    "arrest",
    "arrival",
    "arrive",
    "arrogance",
    "arrogant",
    "arson",
    "art",
    "ascend",
    "ascension",
    "ascent",
    "ascertain",
    "ashamed",
    "ashen",
    "ashes",
    "ashy",
    "aside",
    "askew",
    "asleep",
    "asparagus",
    "aspect",
    "aspirate",
    "aspire",
    "aspirin",
    "astonish",
    "astound",
    "astride",
    "astrology",
    "astronaut",
    "astronomy",
    "astute",
    "atlantic",
    "atlas",
    "atom",
    "atonable",
    "atop",
    "atrium",
    "atrocious",
    "atrophy",
    "attach",
    "attain",
    "attempt",
    "attendant",
    "attendee",
    "attention",
    "attentive",
    "attest",
    "attic",
    "attire",
    "attitude",
    "attractor",
    "attribute",
    "atypical",
    "auction",
    "audacious",
    "audacity",
    "audible",
    "audibly",
    "audience",
    "audio",
    "audition",
    "augmented",
    "august",
    "authentic",
    "author",
    "autism",
    "autistic",
    "autograph",
    "automaker",
    "automated",
    "automatic",
    "autopilot",
    "available",
    "avalanche",
    "avatar",
    "avenge",
    "avenging",
    "avenue",
    "average",
    "aversion",
    "avert",
    "aviation",
    "aviator",
    "avid",
    "avoid",
    "await",
    "awaken",
    "award",
    "aware",
    "awhile",
    "awkward",
    "awning",
    "awoke",
    "awry",
    "axis",
    "babble",
    "babbling",
    "babied",
    "baboon",
    "backache",
    "backboard",
    "backboned",
    "backdrop",
    "backed",
    "backer",
    "backfield",
    "backfire",
    "backhand",
    "backing",
    "backlands",
    "backlash",
    "backless",
    "backlight",
    "backlit",
    "backlog",
    "backpack",
    "backpedal",
    "backrest",
    "backroom",
    "backshift",
    "backside",
    "backslid",
    "backspace",
    "backspin",
    "backstab",
    "backstage",
    "backtalk",
    "backtrack",
    "backup",
    "backward",
    "backwash",
    "backwater",
    "backyard",
    "bacon",
    "bacteria",
    "bacterium",
    "badass",
    "badge",
    "badland",
    "badly",
    "badness",
    "baffle",
    "baffling",
    "bagel",
    "bagful",
    "baggage",
    "bagged",
    "baggie",
    "bagginess",
    "bagging",
    "baggy",
    "bagpipe",
    "baguette",
    "baked",
    "bakery",
    "bakeshop",
    "baking",
    "balance",
    "balancing",
    "balcony",
    "balmy",
    "balsamic",
    "bamboo",
    "banana",
    "banish",
    "banister",
    "banjo",
    "bankable",
    "bankbook",
    "banked",
    "banker",
    "banking",
    "banknote",
    "bankroll",
    "banner",
    "bannister",
    "banshee",
    "banter",
    "barbecue",
    "barbed",
    "barbell",
    "barber",
    "barcode",
    "barge",
    "bargraph",
    "barista",
    "baritone",
    "barley",
    "barmaid",
    "barman",
    "barn",
    "barometer",
    "barrack",
    "barracuda",
    "barrel",
    "barrette",
    "barricade",
    "barrier",
    "barstool",
    "bartender",
    "barterer",
    "bash",
    "basically",
    "basics",
    "basil",
    "basin",
    "basis",
    "basket",
    "batboy",
    "batch",
    "bath",
    "baton",
    "bats",
    "battalion",
    "battered",
    "battering",
    "battery",
    "batting",
    "battle",
    "bauble",
    "bazooka",
    "blabber",
    "bladder",
    "blade",
    "blah",
    "blame",
    "blaming",
    "blanching",
    "blandness",
    "blank",
    "blaspheme",
    "blasphemy",
    "blast",
    "blatancy",
    "blatantly",
    "blazer",
    "blazing",
    "bleach",
    "bleak",
    "bleep",
    "blemish",
    "blend",
    "bless",
    "blighted",
    "blimp",
    "bling",
    "blinked",
    "blinker",
    "blinking",
    "blinks",
    "blip",
    "blissful",
    "blitz",
    "blizzard",
    "bloated",
    "bloating",
    "blob",
    "blog",
    "bloomers",
    "blooming",
    "blooper",
    "blot",
    "blouse",
    "blubber",
    "bluff",
    "bluish",
    "blunderer",
    "blunt",
    "blurb",
    "blurred",
    "blurry",
    "blurt",
    "blush",
    "blustery",
    "boaster",
    "boastful",
    "boasting",
    "boat",
    "bobbed",
    "bobbing",
    "bobble",
    "bobcat",
    "bobsled",
    "bobtail",
    "bodacious",
    "body",
    "bogged",
    "boggle",
    "bogus",
    "boil",
    "bok",
    "bolster",
    "bolt",
    "bonanza",
    "bonded",
    "bonding",
    "bondless",
    "boned",
    "bonehead",
    "boneless",
    "bonelike",
    "boney",
    "bonfire",
    "bonnet",
    "bonsai",
    "bonus",
    "bony",
    "boogeyman",
    "boogieman",
    "book",
    "boondocks",
    "booted",
    "booth",
    "bootie",
    "booting",
    "bootlace",
    "bootleg",
    "boots",
    "boozy",
    "borax",
    "boring",
    "borough",
    "borrower",
    "borrowing",
    "boss",
    "botanical",
    "botanist",
    "botany",
    "botch",
    "both",
    "bottle",
    "bottling",
    "bottom",
    "bounce",
    "bouncing",
    "bouncy",
    "bounding",
    "boundless",
    "bountiful",
    "bovine",
    "boxcar",
    "boxer",
    "boxing",
    "boxlike",
    "boxy",
    "breach",
    "breath",
    "breeches",
    "breeching",
    "breeder",
    "breeding",
    "breeze",
    "breezy",
    "brethren",
    "brewery",
    "brewing",
    "briar",
    "bribe",
    "brick",
    "bride",
    "bridged",
    "brigade",
    "bright",
    "brilliant",
    "brim",
    "bring",
    "brink",
    "brisket",
    "briskly",
    "briskness",
    "bristle",
    "brittle",
    "broadband",
    "broadcast",
    "broaden",
    "broadly",
    "broadness",
    "broadside",
    "broadways",
    "broiler",
    "broiling",
    "broken",
    "broker",
    "bronchial",
    "bronco",
    "bronze",
    "bronzing",
    "brook",
    "broom",
    "brought",
    "browbeat",
    "brownnose",
    "browse",
    "browsing",
    "bruising",
    "brunch",
    "brunette",
    "brunt",
    "brush",
    "brussels",
    "brute",
    "brutishly",
    "bubble",
    "bubbling",
    "bubbly",
    "buccaneer",
    "bucked",
    "bucket",
    "buckle",
    "buckshot",
    "buckskin",
    "bucktooth",
    "buckwheat",
    "buddhism",
    "buddhist",
    "budding",
    "buddy",
    "budget",
    "buffalo",
    "buffed",
    "buffer",
    "buffing",
    "buffoon",
    "buggy",
    "bulb",
    "bulge",
    "bulginess",
    "bulgur",
    "bulk",
    "bulldog",
    "bulldozer",
    "bullfight",
    "bullfrog",
    "bullhorn",
    "bullion",
    "bullish",
    "bullpen",
    "bullring",
    "bullseye",
    "bullwhip",
    "bully",
    "bunch",
    "bundle",
    "bungee",
    "bunion",
    "bunkbed",
    "bunkhouse",
    "bunkmate",
    "bunny",
    "bunt",
    "busboy",
    "bush",
    "busily",
    "busload",
    "bust",
    "busybody",
    "buzz",
    "cabana",
    "cabbage",
    "cabbie",
    "cabdriver",
    "cable",
    "caboose",
    "cache",
    "cackle",
    "cacti",
    "cactus",
    "caddie",
    "caddy",
    "cadet",
    "cadillac",
    "cadmium",
    "cage",
    "cahoots",
    "cake",
    "calamari",
    "calamity",
    "calcium",
    "calculate",
    "calculus",
    "caliber",
    "calibrate",
    "calm",
    "caloric",
    "calorie",
    "calzone",
    "camcorder",
    "cameo",
    "camera",
    "camisole",
    "camper",
    "campfire",
    "camping",
    "campsite",
    "campus",
    "canal",
    "canary",
    "cancel",
    "candied",
    "candle",
    "candy",
    "cane",
    "canine",
    "canister",
    "cannabis",
    "canned",
    "canning",
    "cannon",
    "cannot",
    "canola",
    "canon",
    "canopener",
    "canopy",
    "canteen",
    "canyon",
    "capable",
    "capably",
    "capacity",
    "cape",
    "capillary",
    "capital",
    "capitol",
    "capped",
    "capricorn",
    "capsize",
    "capsule",
    "caption",
    "captivate",
    "captive",
    "captivity",
    "capture",
    "caramel",
    "carat",
    "caravan",
    "carbon",
    "cardboard",
    "carded",
    "cardiac",
    "cardigan",
    "cardinal",
    "cardstock",
    "carefully",
    "caregiver",
    "careless",
    "caress",
    "caretaker",
    "cargo",
    "caring",
    "carless",
    "carload",
    "carmaker",
    "carnage",
    "carnation",
    "carnival",
    "carnivore",
    "carol",
    "carpenter",
    "carpentry",
    "carpool",
    "carport",
    "carried",
    "carrot",
    "carrousel",
    "carry",
    "cartel",
    "cartload",
    "carton",
    "cartoon",
    "cartridge",
    "cartwheel",
    "carve",
    "carving",
    "carwash",
    "cascade",
    "case",
    "cash",
    "casing",
    "casino",
    "casket",
    "cassette",
    "casually",
    "casualty",
    "catacomb",
    "catalog",
    "catalyst",
    "catalyze",
    "catapult",
    "cataract",
    "catatonic",
    "catcall",
    "catchable",
    "catcher",
    "catching",
    "catchy",
    "caterer",
    "catering",
    "catfight",
    "catfish",
    "cathedral",
    "cathouse",
    "catlike",
    "catnap",
    "catnip",
    "catsup",
    "cattail",
    "cattishly",
    "cattle",
    "catty",
    "catwalk",
    "caucasian",
    "caucus",
    "causal",
    "causation",
    "cause",
    "causing",
    "cauterize",
    "caution",
    "cautious",
    "cavalier",
    "cavalry",
    "caviar",
    "cavity",
    "cedar",
    "celery",
    "celestial",
    "celibacy",
    "celibate",
    "celtic",
    "cement",
    "census",
    "ceramics",
    "ceremony",
    "certainly",
    "certainty",
    "certified",
    "certify",
    "cesarean",
    "cesspool",
    "chafe",
    "chaffing",
    "chain",
    "chair",
    "chalice",
    "challenge",
    "chamber",
    "chamomile",
    "champion",
    "chance",
    "change",
    "channel",
    "chant",
    "chaos",
    "chaperone",
    "chaplain",
    "chapped",
    "chaps",
    "chapter",
    "character",
    "charbroil",
    "charcoal",
    "charger",
    "charging",
    "chariot",
    "charity",
    "charm",
    "charred",
    "charter",
    "charting",
    "chase",
    "chasing",
    "chaste",
    "chastise",
    "chastity",
    "chatroom",
    "chatter",
    "chatting",
    "chatty",
    "cheating",
    "cheddar",
    "cheek",
    "cheer",
    "cheese",
    "cheesy",
    "chef",
    "chemicals",
    "chemist",
    "chemo",
    "cherisher",
    "cherub",
    "chess",
    "chest",
    "chevron",
    "chevy",
    "chewable",
    "chewer",
    "chewing",
    "chewy",
    "chief",
    "chihuahua",
    "childcare",
    "childhood",
    "childish",
    "childless",
    "childlike",
    "chili",
    "chill",
    "chimp",
    "chip",
    "chirping",
    "chirpy",
    "chitchat",
    "chivalry",
    "chive",
    "chloride",
    "chlorine",
    "choice",
    "chokehold",
    "choking",
    "chomp",
    "chooser",
    "choosing",
    "choosy",
    "chop",
    "chosen",
    "chowder",
    "chowtime",
    "chrome",
    "chubby",
    "chuck",
    "chug",
    "chummy",
    "chump",
    "chunk",
    "churn",
    "chute",
    "cider",
    "cilantro",
    "cinch",
    "cinema",
    "cinnamon",
    "circle",
    "circling",
    "circular",
    "circulate",
    "circus",
    "citable",
    "citadel",
    "citation",
    "citizen",
    "citric",
    "citrus",
    "city",
    "civic",
    "civil",
    "clad",
    "claim",
    "clambake",
    "clammy",
    "clamor",
    "clamp",
    "clamshell",
    "clang",
    "clanking",
    "clapped",
    "clapper",
    "clapping",
    "clarify",
    "clarinet",
    "clarity",
    "clash",
    "clasp",
    "class",
    "clatter",
    "clause",
    "clavicle",
    "claw",
    "clay",
    "clean",
    "clear",
    "cleat",
    "cleaver",
    "cleft",
    "clench",
    "clergyman",
    "clerical",
    "clerk",
    "clever",
    "clicker",
    "client",
    "climate",
    "climatic",
    "cling",
    "clinic",
    "clinking",
    "clip",
    "clique",
    "cloak",
    "clobber",
    "clock",
    "clone",
    "cloning",
    "closable",
    "closure",
    "clothes",
    "clothing",
    "cloud",
    "clover",
    "clubbed",
    "clubbing",
    "clubhouse",
    "clump",
    "clumsily",
    "clumsy",
    "clunky",
    "clustered",
    "clutch",
    "clutter",
    "coach",
    "coagulant",
    "coastal",
    "coaster",
    "coasting",
    "coastland",
    "coastline",
    "coat",
    "coauthor",
    "cobalt",
    "cobbler",
    "cobweb",
    "cocoa",
    "coconut",
    "cod",
    "coeditor",
    "coerce",
    "coexist",
    "coffee",
    "cofounder",
    "cognition",
    "cognitive",
    "cogwheel",
    "coherence",
    "coherent",
    "cohesive",
    "coil",
    "coke",
    "cola",
    "cold",
    "coleslaw",
    "coliseum",
    "collage",
    "collapse",
    "collar",
    "collected",
    "collector",
    "collide",
    "collie",
    "collision",
    "colonial",
    "colonist",
    "colonize",
    "colony",
    "colossal",
    "colt",
    "coma",
    "come",
    "comfort",
    "comfy",
    "comic",
    "coming",
    "comma",
    "commence",
    "commend",
    "comment",
    "commerce",
    "commode",
    "commodity",
    "commodore",
    "common",
    "commotion",
    "commute",
    "commuting",
    "compacted",
    "compacter",
    "compactly",
    "compactor",
    "companion",
    "company",
    "compare",
    "compel",
    "compile",
    "comply",
    "component",
    "composed",
    "composer",
    "composite",
    "compost",
    "composure",
    "compound",
    "compress",
    "comprised",
    "computer",
    "computing",
    "comrade",
    "concave",
    "conceal",
    "conceded",
    "concept",
    "concerned",
    "concert",
    "conch",
    "concierge",
    "concise",
    "conclude",
    "concrete",
    "concur",
    "condense",
    "condiment",
    "condition",
    "condone",
    "conducive",
    "conductor",
    "conduit",
    "cone",
    "confess",
    "confetti",
    "confidant",
    "confident",
    "confider",
    "confiding",
    "configure",
    "confined",
    "confining",
    "confirm",
    "conflict",
    "conform",
    "confound",
    "confront",
    "confused",
    "confusing",
    "confusion",
    "congenial",
    "congested",
    "congrats",
    "congress",
    "conical",
    "conjoined",
    "conjure",
    "conjuror",
    "connected",
    "connector",
    "consensus",
    "consent",
    "console",
    "consoling",
    "consonant",
    "constable",
    "constant",
    "constrain",
    "constrict",
    "construct",
    "consult",
    "consumer",
    "consuming",
    "contact",
    "container",
    "contempt",
    "contend",
    "contented",
    "contently",
    "contents",
    "contest",
    "context",
    "contort",
    "contour",
    "contrite",
    "control",
    "contusion",
    "convene",
    "convent",
    "copartner",
    "cope",
    "copied",
    "copier",
    "copilot",
    "coping",
    "copious",
    "copper",
    "copy",
    "coral",
    "cork",
    "cornball",
    "cornbread",
    "corncob",
    "cornea",
    "corned",
    "corner",
    "cornfield",
    "cornflake",
    "cornhusk",
    "cornmeal",
    "cornstalk",
    "corny",
    "coronary",
    "coroner",
    "corporal",
    "corporate",
    "corral",
    "correct",
    "corridor",
    "corrode",
    "corroding",
    "corrosive",
    "corsage",
    "corset",
    "cortex",
    "cosigner",
    "cosmetics",
    "cosmic",
    "cosmos",
    "cosponsor",
    "cost",
    "cottage",
    "cotton",
    "couch",
    "cough",
    "could",
    "countable",
    "countdown",
    "counting",
    "countless",
    "country",
    "county",
    "courier",
    "covenant",
    "cover",
    "coveted",
    "coveting",
    "coyness",
    "cozily",
    "coziness",
    "cozy",
    "crabbing",
    "crabgrass",
    "crablike",
    "crabmeat",
    "cradle",
    "cradling",
    "crafter",
    "craftily",
    "craftsman",
    "craftwork",
    "crafty",
    "cramp",
    "cranberry",
    "crane",
    "cranial",
    "cranium",
    "crank",
    "crate",
    "crave",
    "craving",
    "crawfish",
    "crawlers",
    "crawling",
    "crayfish",
    "crayon",
    "crazed",
    "crazily",
    "craziness",
    "crazy",
    "creamed",
    "creamer",
    "creamlike",
    "crease",
    "creasing",
    "creatable",
    "create",
    "creation",
    "creative",
    "creature",
    "credible",
    "credibly",
    "credit",
    "creed",
    "creme",
    "creole",
    "crepe",
    "crept",
    "crescent",
    "crested",
    "cresting",
    "crestless",
    "crevice",
    "crewless",
    "crewman",
    "crewmate",
    "crib",
    "cricket",
    "cried",
    "crier",
    "crimp",
    "crimson",
    "cringe",
    "cringing",
    "crinkle",
    "crinkly",
    "crisped",
    "crisping",
    "crisply",
    "crispness",
    "crispy",
    "criteria",
    "critter",
    "croak",
    "crock",
    "crook",
    "croon",
    "crop",
    "cross",
    "crouch",
    "crouton",
    "crowbar",
    "crowd",
    "crown",
    "crucial",
    "crudely",
    "crudeness",
    "cruelly",
    "cruelness",
    "cruelty",
    "crumb",
    "crummiest",
    "crummy",
    "crumpet",
    "crumpled",
    "cruncher",
    "crunching",
    "crunchy",
    "crusader",
    "crushable",
    "crushed",
    "crusher",
    "crushing",
    "crust",
    "crux",
    "crying",
    "cryptic",
    "crystal",
    "cubbyhole",
    "cube",
    "cubical",
    "cubicle",
    "cucumber",
    "cuddle",
    "cuddly",
    "cufflink",
    "culinary",
    "culminate",
    "culpable",
    "culprit",
    "cultivate",
    "cultural",
    "culture",
    "cupbearer",
    "cupcake",
    "cupid",
    "cupped",
    "cupping",
    "curable",
    "curator",
    "curdle",
    "cure",
    "curfew",
    "curing",
    "curled",
    "curler",
    "curliness",
    "curling",
    "curly",
    "curry",
    "curse",
    "cursive",
    "cursor",
    "curtain",
    "curtly",
    "curtsy",
    "curvature",
    "curve",
    "curvy",
    "cushy",
    "cusp",
    "cussed",
    "custard",
    "custodian",
    "custody",
    "customary",
    "customer",
    "customize",
    "customs",
    "cut",
    "cycle",
    "cyclic",
    "cycling",
    "cyclist",
    "cylinder",
    "cymbal",
    "cytoplasm",
    "cytoplast",
    "dab",
    "dad",
    "daffodil",
    "dagger",
    "daily",
    "daintily",
    "dainty",
    "dairy",
    "daisy",
    "dallying",
    "dance",
    "dancing",
    "dandelion",
    "dander",
    "dandruff",
    "dandy",
    "danger",
    "dangle",
    "dangling",
    "daredevil",
    "dares",
    "daringly",
    "darkened",
    "darkening",
    "darkish",
    "darkness",
    "darkroom",
    "darling",
    "darn",
    "dart",
    "darwinism",
    "dash",
    "dastardly",
    "data",
    "datebook",
    "dating",
    "daughter",
    "daunting",
    "dawdler",
    "dawn",
    "daybed",
    "daybreak",
    "daycare",
    "daydream",
    "daylight",
    "daylong",
    "dayroom",
    "daytime",
    "dazzler",
    "dazzling",
    "deacon",
    "deafening",
    "deafness",
    "dealer",
    "dealing",
    "dealmaker",
    "dealt",
    "dean",
    "debatable",
    "debate",
    "debating",
    "debit",
    "debrief",
    "debtless",
    "debtor",
    "debug",
    "debunk",
    "decade",
    "decaf",
    "decal",
    "decathlon",
    "decay",
    "deceased",
    "deceit",
    "deceiver",
    "deceiving",
    "december",
    "decency",
    "decent",
    "deception",
    "deceptive",
    "decibel",
    "decidable",
    "decimal",
    "decimeter",
    "decipher",
    "deck",
    "declared",
    "decline",
    "decode",
    "decompose",
    "decorated",
    "decorator",
    "decoy",
    "decrease",
    "decree",
    "dedicate",
    "dedicator",
    "deduce",
    "deduct",
    "deed",
    "deem",
    "deepen",
    "deeply",
    "deepness",
    "deface",
    "defacing",
    "defame",
    "default",
    "defeat",
    "defection",
    "defective",
    "defendant",
    "defender",
    "defense",
    "defensive",
    "deferral",
    "deferred",
    "defiance",
    "defiant",
    "defile",
    "defiling",
    "define",
    "definite",
    "deflate",
    "deflation",
    "deflator",
    "deflected",
    "deflector",
    "defog",
    "deforest",
    "defraud",
    "defrost",
    "deftly",
    "defuse",
    "defy",
    "degraded",
    "degrading",
    "degrease",
    "degree",
    "dehydrate",
    "deity",
    "dejected",
    "delay",
    "delegate",
    "delegator",
    "delete",
    "deletion",
    "delicacy",
    "delicate",
    "delicious",
    "delighted",
    "delirious",
    "delirium",
    "deliverer",
    "delivery",
    "delouse",
    "delta",
    "deluge",
    "delusion",
    "deluxe",
    "demanding",
    "demeaning",
    "demeanor",
    "demise",
    "democracy",
    "democrat",
    "demote",
    "demotion",
    "demystify",
    "denatured",
    "deniable",
    "denial",
    "denim",
    "denote",
    "dense",
    "density",
    "dental",
    "dentist",
    "denture",
    "deny",
    "deodorant",
    "deodorize",
    "departed",
    "departure",
    "depict",
    "deplete",
    "depletion",
    "deplored",
    "deploy",
    "deport",
    "depose",
    "depraved",
    "depravity",
    "deprecate",
    "depress",
    "deprive",
    "depth",
    "deputize",
    "deputy",
    "derail",
    "deranged",
    "derby",
    "derived",
    "desecrate",
    "deserve",
    "deserving",
    "designate",
    "designed",
    "designer",
    "designing",
    "deskbound",
    "desktop",
    "deskwork",
    "desolate",
    "despair",
    "despise",
    "despite",
    "destiny",
    "destitute",
    "destruct",
    "detached",
    "detail",
    "detection",
    "detective",
    "detector",
    "detention",
    "detergent",
    "detest",
    "detonate",
    "detonator",
    "detoxify",
    "detract",
    "deuce",
    "devalue",
    "deviancy",
    "deviant",
    "deviate",
    "deviation",
    "deviator",
    "device",
    "devious",
    "devotedly",
    "devotee",
    "devotion",
    "devourer",
    "devouring",
    "devoutly",
    "dexterity",
    "dexterous",
    "diabetes",
    "diabetic",
    "diabolic",
    "diagnoses",
    "diagnosis",
    "diagram",
    "dial",
    "diameter",
    "diaper",
    "diaphragm",
    "diary",
    "dice",
    "dicing",
    "dictate",
    "dictation",
    "dictator",
    "difficult",
    "diffused",
    "diffuser",
    "diffusion",
    "diffusive",
    "dig",
    "dilation",
    "diligence",
    "diligent",
    "dill",
    "dilute",
    "dime",
    "diminish",
    "dimly",
    "dimmed",
    "dimmer",
    "dimness",
    "dimple",
    "diner",
    "dingbat",
    "dinghy",
    "dinginess",
    "dingo",
    "dingy",
    "dining",
    "dinner",
    "diocese",
    "dioxide",
    "diploma",
    "dipped",
    "dipper",
    "dipping",
    "directed",
    "direction",
    "directive",
    "directly",
    "directory",
    "direness",
    "dirtiness",
    "disabled",
    "disagree",
    "disallow",
    "disarm",
    "disarray",
    "disaster",
    "disband",
    "disbelief",
    "disburse",
    "discard",
    "discern",
    "discharge",
    "disclose",
    "discolor",
    "discount",
    "discourse",
    "discover",
    "discuss",
    "disdain",
    "disengage",
    "disfigure",
    "disgrace",
    "dish",
    "disinfect",
    "disjoin",
    "disk",
    "dislike",
    "disliking",
    "dislocate",
    "dislodge",
    "disloyal",
    "dismantle",
    "dismay",
    "dismiss",
    "dismount",
    "disobey",
    "disorder",
    "disown",
    "disparate",
    "disparity",
    "dispatch",
    "dispense",
    "dispersal",
    "dispersed",
    "disperser",
    "displace",
    "display",
    "displease",
    "disposal",
    "dispose",
    "disprove",
    "dispute",
    "disregard",
    "disrupt",
    "dissuade",
    "distance",
    "distant",
    "distaste",
    "distill",
    "distinct",
    "distort",
    "distract",
    "distress",
    "district",
    "distrust",
    "ditch",
    "ditto",
    "ditzy",
    "dividable",
    "divided",
    "dividend",
    "dividers",
    "dividing",
    "divinely",
    "diving",
    "divinity",
    "divisible",
    "divisibly",
    "division",
    "divisive",
    "divorcee",
    "dizziness",
    "dizzy",
    "doable",
    "docile",
    "dock",
    "doctrine",
    "document",
    "dodge",
    "dodgy",
    "doily",
    "doing",
    "dole",
    "dollar",
    "dollhouse",
    "dollop",
    "dolly",
    "dolphin",
    "domain",
    "domelike",
    "domestic",
    "dominion",
    "dominoes",
    "donated",
    "donation",
    "donator",
    "donor",
    "donut",
    "doodle",
    "doorbell",
    "doorframe",
    "doorknob",
    "doorman",
    "doormat",
    "doornail",
    "doorpost",
    "doorstep",
    "doorstop",
    "doorway",
    "doozy",
    "dork",
    "dormitory",
    "dorsal",
    "dosage",
    "dose",
    "dotted",
    "doubling",
    "douche",
    "dove",
    "down",
    "dowry",
    "doze",
    "drab",
    "dragging",
    "dragonfly",
    "dragonish",
    "dragster",
    "drainable",
    "drainage",
    "drained",
    "drainer",
    "drainpipe",
    "dramatic",
    "dramatize",
    "drank",
    "drapery",
    "drastic",
    "draw",
    "dreaded",
    "dreadful",
    "dreadlock",
    "dreamboat",
    "dreamily",
    "dreamland",
    "dreamless",
    "dreamlike",
    "dreamt",
    "dreamy",
    "drearily",
    "dreary",
    "drench",
    "dress",
    "drew",
    "dribble",
    "dried",
    "drier",
    "drift",
    "driller",
    "drilling",
    "drinkable",
    "drinking",
    "dripping",
    "drippy",
    "drivable",
    "driven",
    "driver",
    "driveway",
    "driving",
    "drizzle",
    "drizzly",
    "drone",
    "drool",
    "droop",
    "drop-down",
    "dropbox",
    "dropkick",
    "droplet",
    "dropout",
    "dropper",
    "drove",
    "drown",
    "drowsily",
    "drudge",
    "drum",
    "dry",
    "dubbed",
    "dubiously",
    "duchess",
    "duckbill",
    "ducking",
    "duckling",
    "ducktail",
    "ducky",
    "duct",
    "dude",
    "duffel",
    "dugout",
    "duh",
    "duke",
    "duller",
    "dullness",
    "duly",
    "dumping",
    "dumpling",
    "dumpster",
    "duo",
    "dupe",
    "duplex",
    "duplicate",
    "duplicity",
    "durable",
    "durably",
    "duration",
    "duress",
    "during",
    "dusk",
    "dust",
    "dutiful",
    "duty",
    "duvet",
    "dwarf",
    "dweeb",
    "dwelled",
    "dweller",
    "dwelling",
    "dwindle",
    "dwindling",
    "dynamic",
    "dynamite",
    "dynasty",
    "dyslexia",
    "dyslexic",
    "each",
    "eagle",
    "earache",
    "eardrum",
    "earflap",
    "earful",
    "earlobe",
    "early",
    "earmark",
    "earmuff",
    "earphone",
    "earpiece",
    "earplugs",
    "earring",
    "earshot",
    "earthen",
    "earthlike",
    "earthling",
    "earthly",
    "earthworm",
    "earthy",
    "earwig",
    "easeful",
    "easel",
    "easiest",
    "easily",
    "easiness",
    "easing",
    "eastbound",
    "eastcoast",
    "easter",
    "eastward",
    "eatable",
    "eaten",
    "eatery",
    "eating",
    "eats",
    "ebay",
    "ebony",
    "ebook",
    "ecard",
    "eccentric",
    "echo",
    "eclair",
    "eclipse",
    "ecologist",
    "ecology",
    "economic",
    "economist",
    "economy",
    "ecosphere",
    "ecosystem",
    "edge",
    "edginess",
    "edging",
    "edgy",
    "edition",
    "editor",
    "educated",
    "education",
    "educator",
    "eel",
    "effective",
    "effects",
    "efficient",
    "effort",
    "eggbeater",
    "egging",
    "eggnog",
    "eggplant",
    "eggshell",
    "egomaniac",
    "egotism",
    "egotistic",
    "either",
    "eject",
    "elaborate",
    "elastic",
    "elated",
    "elbow",
    "eldercare",
    "elderly",
    "eldest",
    "electable",
    "election",
    "elective",
    "elephant",
    "elevate",
    "elevating",
    "elevation",
    "elevator",
    "eleven",
    "elf",
    "eligible",
    "eligibly",
    "eliminate",
    "elite",
    "elitism",
    "elixir",
    "elk",
    "ellipse",
    "elliptic",
    "elm",
    "elongated",
    "elope",
    "eloquence",
    "eloquent",
    "elsewhere",
    "elude",
    "elusive",
    "elves",
    "email",
    "embargo",
    "embark",
    "embassy",
    "embattled",
    "embellish",
    "ember",
    "embezzle",
    "emblaze",
    "emblem",
    "embody",
    "embolism",
    "emboss",
    "embroider",
    "emcee",
    "emerald",
    "emergency",
    "emission",
    "emit",
    "emote",
    "emoticon",
    "emotion",
    "empathic",
    "empathy",
    "emperor",
    "emphases",
    "emphasis",
    "emphasize",
    "emphatic",
    "empirical",
    "employed",
    "employee",
    "employer",
    "emporium",
    "empower",
    "emptier",
    "emptiness",
    "empty",
    "emu",
    "enable",
    "enactment",
    "enamel",
    "enchanted",
    "enchilada",
    "encircle",
    "enclose",
    "enclosure",
    "encode",
    "encore",
    "encounter",
    "encourage",
    "encroach",
    "encrust",
    "encrypt",
    "endanger",
    "endeared",
    "endearing",
    "ended",
    "ending",
    "endless",
    "endnote",
    "endocrine",
    "endorphin",
    "endorse",
    "endowment",
    "endpoint",
    "endurable",
    "endurance",
    "enduring",
    "energetic",
    "energize",
    "energy",
    "enforced",
    "enforcer",
    "engaged",
    "engaging",
    "engine",
    "engorge",
    "engraved",
    "engraver",
    "engraving",
    "engross",
    "engulf",
    "enhance",
    "enigmatic",
    "enjoyable",
    "enjoyably",
    "enjoyer",
    "enjoying",
    "enjoyment",
    "enlarged",
    "enlarging",
    "enlighten",
    "enlisted",
    "enquirer",
    "enrage",
    "enrich",
    "enroll",
    "enslave",
    "ensnare",
    "ensure",
    "entail",
    "entangled",
    "entering",
    "entertain",
    "enticing",
    "entire",
    "entitle",
    "entity",
    "entomb",
    "entourage",
    "entrap",
    "entree",
    "entrench",
    "entrust",
    "entryway",
    "entwine",
    "enunciate",
    "envelope",
    "enviable",
    "enviably",
    "envious",
    "envision",
    "envoy",
    "envy",
    "enzyme",
    "epic",
    "epidemic",
    "epidermal",
    "epidermis",
    "epidural",
    "epilepsy",
    "epileptic",
    "epilogue",
    "epiphany",
    "episode",
    "equal",
    "equate",
    "equation",
    "equator",
    "equinox",
    "equipment",
    "equity",
    "equivocal",
    "eradicate",
    "erasable",
    "erased",
    "eraser",
    "erasure",
    "ergonomic",
    "errand",
    "errant",
    "erratic",
    "error",
    "erupt",
    "escalate",
    "escalator",
    "escapable",
    "escapade",
    "escapist",
    "escargot",
    "eskimo",
    "esophagus",
    "espionage",
    "espresso",
    "esquire",
    "essay",
    "essence",
    "essential",
    "establish",
    "estate",
    "esteemed",
    "estimate",
    "estimator",
    "estranged",
    "estrogen",
    "etching",
    "eternal",
    "eternity",
    "ethanol",
    "ether",
    "ethically",
    "ethics",
    "euphemism",
    "evacuate",
    "evacuee",
    "evade",
    "evaluate",
    "evaluator",
    "evaporate",
    "evasion",
    "evasive",
    "even",
    "everglade",
    "evergreen",
    "everybody",
    "everyday",
    "everyone",
    "evict",
    "evidence",
    "evident",
    "evil",
    "evoke",
    "evolution",
    "evolve",
    "exact",
    "exalted",
    "example",
    "excavate",
    "excavator",
    "exceeding",
    "exception",
    "excess",
    "exchange",
    "excitable",
    "exciting",
    "exclaim",
    "exclude",
    "excluding",
    "exclusion",
    "exclusive",
    "excretion",
    "excretory",
    "excursion",
    "excusable",
    "excusably",
    "excuse",
    "exemplary",
    "exemplify",
    "exemption",
    "exerciser",
    "exert",
    "exes",
    "exfoliate",
    "exhale",
    "exhaust",
    "exhume",
    "exile",
    "existing",
    "exit",
    "exodus",
    "exonerate",
    "exorcism",
    "exorcist",
    "expand",
    "expanse",
    "expansion",
    "expansive",
    "expectant",
    "expedited",
    "expediter",
    "expel",
    "expend",
    "expenses",
    "expensive",
    "expert",
    "expire",
    "expiring",
    "explain",
    "expletive",
    "explicit",
    "explode",
    "exploit",
    "explore",
    "exploring",
    "exponent",
    "exporter",
    "exposable",
    "expose",
    "exposure",
    "express",
    "expulsion",
    "exquisite",
    "extended",
    "extending",
    "extent",
    "extenuate",
    "exterior",
    "external",
    "extinct",
    "extortion",
    "extradite",
    "extras",
    "extrovert",
    "extrude",
    "extruding",
    "exuberant",
    "fable",
    "fabric",
    "fabulous",
    "facebook",
    "facecloth",
    "facedown",
    "faceless",
    "facelift",
    "faceplate",
    "faceted",
    "facial",
    "facility",
    "facing",
    "facsimile",
    "faction",
    "factoid",
    "factor",
    "factsheet",
    "factual",
    "faculty",
    "fade",
    "fading",
    "failing",
    "falcon",
    "fall",
    "false",
    "falsify",
    "fame",
    "familiar",
    "family",
    "famine",
    "famished",
    "fanatic",
    "fancied",
    "fanciness",
    "fancy",
    "fanfare",
    "fang",
    "fanning",
    "fantasize",
    "fantastic",
    "fantasy",
    "fascism",
    "fastball",
    "faster",
    "fasting",
    "fastness",
    "faucet",
    "favorable",
    "favorably",
    "favored",
    "favoring",
    "favorite",
    "fax",
    "feast",
    "federal",
    "fedora",
    "feeble",
    "feed",
    "feel",
    "feisty",
    "feline",
    "felt-tip",
    "feminine",
    "feminism",
    "feminist",
    "feminize",
    "femur",
    "fence",
    "fencing",
    "fender",
    "ferment",
    "fernlike",
    "ferocious",
    "ferocity",
    "ferret",
    "ferris",
    "ferry",
    "fervor",
    "fester",
    "festival",
    "festive",
    "festivity",
    "fetal",
    "fetch",
    "fever",
    "fiber",
    "fiction",
    "fiddle",
    "fiddling",
    "fidelity",
    "fidgeting",
    "fidgety",
    "fifteen",
    "fifth",
    "fiftieth",
    "fifty",
    "figment",
    "figure",
    "figurine",
    "filing",
    "filled",
    "filler",
    "filling",
    "film",
    "filter",
    "filth",
    "filtrate",
    "finale",
    "finalist",
    "finalize",
    "finally",
    "finance",
    "financial",
    "finch",
    "fineness",
    "finer",
    "finicky",
    "finished",
    "finisher",
    "finishing",
    "finite",
    "finless",
    "finlike",
    "fiscally",
    "fit",
    "five",
    "flaccid",
    "flagman",
    "flagpole",
    "flagship",
    "flagstick",
    "flagstone",
    "flail",
    "flakily",
    "flaky",
    "flame",
    "flammable",
    "flanked",
    "flanking",
    "flannels",
    "flap",
    "flaring",
    "flashback",
    "flashbulb",
    "flashcard",
    "flashily",
    "flashing",
    "flashy",
    "flask",
    "flatbed",
    "flatfoot",
    "flatly",
    "flatness",
    "flatten",
    "flattered",
    "flatterer",
    "flattery",
    "flattop",
    "flatware",
    "flatworm",
    "flavored",
    "flavorful",
    "flavoring",
    "flaxseed",
    "fled",
    "fleshed",
    "fleshy",
    "flick",
    "flier",
    "flight",
    "flinch",
    "fling",
    "flint",
    "flip",
    "flirt",
    "float",
    "flock",
    "flogging",
    "flop",
    "floral",
    "florist",
    "floss",
    "flounder",
    "flyable",
    "flyaway",
    "flyer",
    "flying",
    "flyover",
    "flypaper",
    "foam",
    "foe",
    "fog",
    "foil",
    "folic",
    "folk",
    "follicle",
    "follow",
    "fondling",
    "fondly",
    "fondness",
    "fondue",
    "font",
    "food",
    "fool",
    "footage",
    "football",
    "footbath",
    "footboard",
    "footer",
    "footgear",
    "foothill",
    "foothold",
    "footing",
    "footless",
    "footman",
    "footnote",
    "footpad",
    "footpath",
    "footprint",
    "footrest",
    "footsie",
    "footsore",
    "footwear",
    "footwork",
    "fossil",
    "foster",
    "founder",
    "founding",
    "fountain",
    "fox",
    "foyer",
    "fraction",
    "fracture",
    "fragile",
    "fragility",
    "fragment",
    "fragrance",
    "fragrant",
    "frail",
    "frame",
    "framing",
    "frantic",
    "fraternal",
    "frayed",
    "fraying",
    "frays",
    "freckled",
    "freckles",
    "freebase",
    "freebee",
    "freebie",
    "freedom",
    "freefall",
    "freehand",
    "freeing",
    "freeload",
    "freely",
    "freemason",
    "freeness",
    "freestyle",
    "freeware",
    "freeway",
    "freewill",
    "freezable",
    "freezing",
    "freight",
    "french",
    "frenzied",
    "frenzy",
    "frequency",
    "frequent",
    "fresh",
    "fretful",
    "fretted",
    "friction",
    "friday",
    "fridge",
    "fried",
    "friend",
    "frighten",
    "frightful",
    "frigidity",
    "frigidly",
    "frill",
    "fringe",
    "frisbee",
    "frisk",
    "fritter",
    "frivolous",
    "frolic",
    "from",
    "front",
    "frostbite",
    "frosted",
    "frostily",
    "frosting",
    "frostlike",
    "frosty",
    "froth",
    "frown",
    "frozen",
    "fructose",
    "frugality",
    "frugally",
    "fruit",
    "frustrate",
    "frying",
    "gab",
    "gaffe",
    "gag",
    "gainfully",
    "gaining",
    "gains",
    "gala",
    "gallantly",
    "galleria",
    "gallery",
    "galley",
    "gallon",
    "gallows",
    "gallstone",
    "galore",
    "galvanize",
    "gambling",
    "game",
    "gaming",
    "gamma",
    "gander",
    "gangly",
    "gangrene",
    "gangway",
    "gap",
    "garage",
    "garbage",
    "garden",
    "gargle",
    "garland",
    "garlic",
    "garment",
    "garnet",
    "garnish",
    "garter",
    "gas",
    "gatherer",
    "gathering",
    "gating",
    "gauging",
    "gauntlet",
    "gauze",
    "gave",
    "gawk",
    "gazing",
    "gear",
    "gecko",
    "geek",
    "geiger",
    "gem",
    "gender",
    "generic",
    "generous",
    "genetics",
    "genre",
    "gentile",
    "gentleman",
    "gently",
    "gents",
    "geography",
    "geologic",
    "geologist",
    "geology",
    "geometric",
    "geometry",
    "geranium",
    "gerbil",
    "geriatric",
    "germicide",
    "germinate",
    "germless",
    "germproof",
    "gestate",
    "gestation",
    "gesture",
    "getaway",
    "getting",
    "getup",
    "giant",
    "gibberish",
    "giblet",
    "giddily",
    "giddiness",
    "giddy",
    "gift",
    "gigabyte",
    "gigahertz",
    "gigantic",
    "giggle",
    "giggling",
    "giggly",
    "gigolo",
    "gilled",
    "gills",
    "gimmick",
    "girdle",
    "giveaway",
    "given",
    "giver",
    "giving",
    "gizmo",
    "gizzard",
    "glacial",
    "glacier",
    "glade",
    "gladiator",
    "gladly",
    "glamorous",
    "glamour",
    "glance",
    "glancing",
    "glandular",
    "glare",
    "glaring",
    "glass",
    "glaucoma",
    "glazing",
    "gleaming",
    "gleeful",
    "glider",
    "gliding",
    "glimmer",
    "glimpse",
    "glisten",
    "glitch",
    "glitter",
    "glitzy",
    "gloater",
    "gloating",
    "gloomily",
    "gloomy",
    "glorified",
    "glorifier",
    "glorify",
    "glorious",
    "glory",
    "gloss",
    "glove",
    "glowing",
    "glowworm",
    "glucose",
    "glue",
    "gluten",
    "glutinous",
    "glutton",
    "gnarly",
    "gnat",
    "goal",
    "goatskin",
    "goes",
    "goggles",
    "going",
    "goldfish",
    "goldmine",
    "goldsmith",
    "golf",
    "goliath",
    "gonad",
    "gondola",
    "gone",
    "gong",
    "good",
    "gooey",
    "goofball",
    "goofiness",
    "goofy",
    "google",
    "goon",
    "gopher",
    "gore",
    "gorged",
    "gorgeous",
    "gory",
    "gosling",
    "gossip",
    "gothic",
    "gotten",
    "gout",
    "gown",
    "grab",
    "graceful",
    "graceless",
    "gracious",
    "gradation",
    "graded",
    "grader",
    "gradient",
    "grading",
    "gradually",
    "graduate",
    "graffiti",
    "grafted",
    "grafting",
    "grain",
    "granddad",
    "grandkid",
    "grandly",
    "grandma",
    "grandpa",
    "grandson",
    "granite",
    "granny",
    "granola",
    "grant",
    "granular",
    "grape",
    "graph",
    "grapple",
    "grappling",
    "grasp",
    "grass",
    "gratified",
    "gratify",
    "grating",
    "gratitude",
    "gratuity",
    "gravel",
    "graveness",
    "graves",
    "graveyard",
    "gravitate",
    "gravity",
    "gravy",
    "gray",
    "grazing",
    "greasily",
    "greedily",
    "greedless",
    "greedy",
    "green",
    "greeter",
    "greeting",
    "grew",
    "greyhound",
    "grid",
    "grief",
    "grievance",
    "grieving",
    "grievous",
    "grill",
    "grimace",
    "grimacing",
    "grime",
    "griminess",
    "grimy",
    "grinch",
    "grinning",
    "grip",
    "gristle",
    "grit",
    "groggily",
    "groggy",
    "groin",
    "groom",
    "groove",
    "grooving",
    "groovy",
    "grope",
    "ground",
    "grouped",
    "grout",
    "grove",
    "grower",
    "growing",
    "growl",
    "grub",
    "grudge",
    "grudging",
    "grueling",
    "gruffly",
    "grumble",
    "grumbling",
    "grumbly",
    "grumpily",
    "grunge",
    "grunt",
    "guacamole",
    "guidable",
    "guidance",
    "guide",
    "guiding",
    "guileless",
    "guise",
    "gulf",
    "gullible",
    "gully",
    "gulp",
    "gumball",
    "gumdrop",
    "gumminess",
    "gumming",
    "gummy",
    "gurgle",
    "gurgling",
    "guru",
    "gush",
    "gusto",
    "gusty",
    "gutless",
    "guts",
    "gutter",
    "guy",
    "guzzler",
    "gyration",
    "habitable",
    "habitant",
    "habitat",
    "habitual",
    "hacked",
    "hacker",
    "hacking",
    "hacksaw",
    "had",
    "haggler",
    "haiku",
    "half",
    "halogen",
    "halt",
    "halved",
    "halves",
    "hamburger",
    "hamlet",
    "hammock",
    "hamper",
    "hamster",
    "hamstring",
    "handbag",
    "handball",
    "handbook",
    "handbrake",
    "handcart",
    "handclap",
    "handclasp",
    "handcraft",
    "handcuff",
    "handed",
    "handful",
    "handgrip",
    "handgun",
    "handheld",
    "handiness",
    "handiwork",
    "handlebar",
    "handled",
    "handler",
    "handling",
    "handmade",
    "handoff",
    "handpick",
    "handprint",
    "handrail",
    "handsaw",
    "handset",
    "handsfree",
    "handshake",
    "handstand",
    "handwash",
    "handwork",
    "handwoven",
    "handwrite",
    "handyman",
    "hangnail",
    "hangout",
    "hangover",
    "hangup",
    "hankering",
    "hankie",
    "hanky",
    "haphazard",
    "happening",
    "happier",
    "happiest",
    "happily",
    "happiness",
    "happy",
    "harbor",
    "hardcopy",
    "hardcore",
    "hardcover",
    "harddisk",
    "hardened",
    "hardener",
    "hardening",
    "hardhat",
    "hardhead",
    "hardiness",
    "hardly",
    "hardness",
    "hardship",
    "hardware",
    "hardwired",
    "hardwood",
    "hardy",
    "harmful",
    "harmless",
    "harmonica",
    "harmonics",
    "harmonize",
    "harmony",
    "harness",
    "harpist",
    "harsh",
    "harvest",
    "hash",
    "hassle",
    "haste",
    "hastily",
    "hastiness",
    "hasty",
    "hatbox",
    "hatchback",
    "hatchery",
    "hatchet",
    "hatching",
    "hatchling",
    "hate",
    "hatless",
    "hatred",
    "haunt",
    "haven",
    "hazard",
    "hazelnut",
    "hazily",
    "haziness",
    "hazing",
    "hazy",
    "headache",
    "headband",
    "headboard",
    "headcount",
    "headdress",
    "headed",
    "header",
    "headfirst",
    "headgear",
    "heading",
    "headlamp",
    "headless",
    "headlock",
    "headphone",
    "headpiece",
    "headrest",
    "headroom",
    "headscarf",
    "headset",
    "headsman",
    "headstand",
    "headstone",
    "headway",
    "headwear",
    "heap",
    "heat",
    "heave",
    "heavily",
    "heaviness",
    "heaving",
    "hedge",
    "hedging",
    "heftiness",
    "hefty",
    "helium",
    "helmet",
    "helper",
    "helpful",
    "helping",
    "helpless",
    "helpline",
    "hemlock",
    "hemstitch",
    "hence",
    "henchman",
    "henna",
    "herald",
    "herbal",
    "herbicide",
    "herbs",
    "heritage",
    "hermit",
    "heroics",
    "heroism",
    "herring",
    "herself",
    "hertz",
    "hesitancy",
    "hesitant",
    "hesitate",
    "hexagon",
    "hexagram",
    "hubcap",
    "huddle",
    "huddling",
    "huff",
    "hug",
    "hula",
    "hulk",
    "hull",
    "human",
    "humble",
    "humbling",
    "humbly",
    "humid",
    "humiliate",
    "humility",
    "humming",
    "hummus",
    "humongous",
    "humorist",
    "humorless",
    "humorous",
    "humpback",
    "humped",
    "humvee",
    "hunchback",
    "hundredth",
    "hunger",
    "hungrily",
    "hungry",
    "hunk",
    "hunter",
    "hunting",
    "huntress",
    "huntsman",
    "hurdle",
    "hurled",
    "hurler",
    "hurling",
    "hurray",
    "hurricane",
    "hurried",
    "hurry",
    "hurt",
    "husband",
    "hush",
    "husked",
    "huskiness",
    "hut",
    "hybrid",
    "hydrant",
    "hydrated",
    "hydration",
    "hydrogen",
    "hydroxide",
    "hyperlink",
    "hypertext",
    "hyphen",
    "hypnoses",
    "hypnosis",
    "hypnotic",
    "hypnotism",
    "hypnotist",
    "hypnotize",
    "hypocrisy",
    "hypocrite",
    "ibuprofen",
    "ice",
    "iciness",
    "icing",
    "icky",
    "icon",
    "icy",
    "idealism",
    "idealist",
    "idealize",
    "ideally",
    "idealness",
    "identical",
    "identify",
    "identity",
    "ideology",
    "idiocy",
    "idiom",
    "idly",
    "igloo",
    "ignition",
    "ignore",
    "iguana",
    "illicitly",
    "illusion",
    "illusive",
    "image",
    "imaginary",
    "imagines",
    "imaging",
    "imbecile",
    "imitate",
    "imitation",
    "immature",
    "immerse",
    "immersion",
    "imminent",
    "immobile",
    "immodest",
    "immorally",
    "immortal",
    "immovable",
    "immovably",
    "immunity",
    "immunize",
    "impaired",
    "impale",
    "impart",
    "impatient",
    "impeach",
    "impeding",
    "impending",
    "imperfect",
    "imperial",
    "impish",
    "implant",
    "implement",
    "implicate",
    "implicit",
    "implode",
    "implosion",
    "implosive",
    "imply",
    "impolite",
    "important",
    "importer",
    "impose",
    "imposing",
    "impotence",
    "impotency",
    "impotent",
    "impound",
    "imprecise",
    "imprint",
    "imprison",
    "impromptu",
    "improper",
    "improve",
    "improving",
    "improvise",
    "imprudent",
    "impulse",
    "impulsive",
    "impure",
    "impurity",
    "iodine",
    "iodize",
    "ion",
    "ipad",
    "iphone",
    "ipod",
    "irate",
    "irk",
    "iron",
    "irregular",
    "irrigate",
    "irritable",
    "irritably",
    "irritant",
    "irritate",
    "islamic",
    "islamist",
    "isolated",
    "isolating",
    "isolation",
    "isotope",
    "issue",
    "issuing",
    "italicize",
    "italics",
    "item",
    "itinerary",
    "itunes",
    "ivory",
    "ivy",
    "jab",
    "jackal",
    "jacket",
    "jackknife",
    "jackpot",
    "jailbird",
    "jailbreak",
    "jailer",
    "jailhouse",
    "jalapeno",
    "jam",
    "janitor",
    "january",
    "jargon",
    "jarring",
    "jasmine",
    "jaundice",
    "jaunt",
    "java",
    "jawed",
    "jawless",
    "jawline",
    "jaws",
    "jaybird",
    "jaywalker",
    "jazz",
    "jeep",
    "jeeringly",
    "jellied",
    "jelly",
    "jersey",
    "jester",
    "jet",
    "jiffy",
    "jigsaw",
    "jimmy",
    "jingle",
    "jingling",
    "jinx",
    "jitters",
    "jittery",
    "job",
    "jockey",
    "jockstrap",
    "jogger",
    "jogging",
    "john",
    "joining",
    "jokester",
    "jokingly",
    "jolliness",
    "jolly",
    "jolt",
    "jot",
    "jovial",
    "joyfully",
    "joylessly",
    "joyous",
    "joyride",
    "joystick",
    "jubilance",
    "jubilant",
    "judge",
    "judgingly",
    "judicial",
    "judiciary",
    "judo",
    "juggle",
    "juggling",
    "jugular",
    "juice",
    "juiciness",
    "juicy",
    "jujitsu",
    "jukebox",
    "july",
    "jumble",
    "jumbo",
    "jump",
    "junction",
    "juncture",
    "june",
    "junior",
    "juniper",
    "junkie",
    "junkman",
    "junkyard",
    "jurist",
    "juror",
    "jury",
    "justice",
    "justifier",
    "justify",
    "justly",
    "justness",
    "juvenile",
    "kabob",
    "kangaroo",
    "karaoke",
    "karate",
    "karma",
    "kebab",
    "keenly",
    "keenness",
    "keep",
    "keg",
    "kelp",
    "kennel",
    "kept",
    "kerchief",
    "kerosene",
    "kettle",
    "kick",
    "kiln",
    "kilobyte",
    "kilogram",
    "kilometer",
    "kilowatt",
    "kilt",
    "kimono",
    "kindle",
    "kindling",
    "kindly",
    "kindness",
    "kindred",
    "kinetic",
    "kinfolk",
    "king",
    "kinship",
    "kinsman",
    "kinswoman",
    "kissable",
    "kisser",
    "kissing",
    "kitchen",
    "kite",
    "kitten",
    "kitty",
    "kiwi",
    "kleenex",
    "knapsack",
    "knee",
    "knelt",
    "knickers",
    "knoll",
    "koala",
    "kooky",
    "kosher",
    "krypton",
    "kudos",
    "kung",
    "labored",
    "laborer",
    "laboring",
    "laborious",
    "labrador",
    "ladder",
    "ladies",
    "ladle",
    "ladybug",
    "ladylike",
    "lagged",
    "lagging",
    "lagoon",
    "lair",
    "lake",
    "lance",
    "landed",
    "landfall",
    "landfill",
    "landing",
    "landlady",
    "landless",
    "landline",
    "landlord",
    "landmark",
    "landmass",
    "landmine",
    "landowner",
    "landscape",
    "landside",
    "landslide",
    "language",
    "lankiness",
    "lanky",
    "lantern",
    "lapdog",
    "lapel",
    "lapped",
    "lapping",
    "laptop",
    "lard",
    "large",
    "lark",
    "lash",
    "lasso",
    "last",
    "latch",
    "late",
    "lather",
    "latitude",
    "latrine",
    "latter",
    "latticed",
    "launch",
    "launder",
    "laundry",
    "laurel",
    "lavender",
    "lavish",
    "laxative",
    "lazily",
    "laziness",
    "lazy",
    "lecturer",
    "left",
    "legacy",
    "legal",
    "legend",
    "legged",
    "leggings",
    "legible",
    "legibly",
    "legislate",
    "lego",
    "legroom",
    "legume",
    "legwarmer",
    "legwork",
    "lemon",
    "lend",
    "length",
    "lens",
    "lent",
    "leotard",
    "lesser",
    "letdown",
    "lethargic",
    "lethargy",
    "letter",
    "lettuce",
    "level",
    "leverage",
    "levers",
    "levitate",
    "levitator",
    "liability",
    "liable",
    "liberty",
    "librarian",
    "library",
    "licking",
    "licorice",
    "lid",
    "life",
    "lifter",
    "lifting",
    "liftoff",
    "ligament",
    "likely",
    "likeness",
    "likewise",
    "liking",
    "lilac",
    "lilly",
    "lily",
    "limb",
    "limeade",
    "limelight",
    "limes",
    "limit",
    "limping",
    "limpness",
    "line",
    "lingo",
    "linguini",
    "linguist",
    "lining",
    "linked",
    "linoleum",
    "linseed",
    "lint",
    "lion",
    "lip",
    "liquefy",
    "liqueur",
    "liquid",
    "lisp",
    "list",
    "litigate",
    "litigator",
    "litmus",
    "litter",
    "little",
    "livable",
    "lived",
    "lively",
    "liver",
    "livestock",
    "lividly",
    "living",
    "lizard",
    "lubricant",
    "lubricate",
    "lucid",
    "luckily",
    "luckiness",
    "luckless",
    "lucrative",
    "ludicrous",
    "lugged",
    "lukewarm",
    "lullaby",
    "lumber",
    "luminance",
    "luminous",
    "lumpiness",
    "lumping",
    "lumpish",
    "lunacy",
    "lunar",
    "lunchbox",
    "luncheon",
    "lunchroom",
    "lunchtime",
    "lung",
    "lurch",
    "lure",
    "luridness",
    "lurk",
    "lushly",
    "lushness",
    "luster",
    "lustfully",
    "lustily",
    "lustiness",
    "lustrous",
    "lusty",
    "luxurious",
    "luxury",
    "lying",
    "lyrically",
    "lyricism",
    "lyricist",
    "lyrics",
    "macarena",
    "macaroni",
    "macaw",
    "mace",
    "machine",
    "machinist",
    "magazine",
    "magenta",
    "maggot",
    "magical",
    "magician",
    "magma",
    "magnesium",
    "magnetic",
    "magnetism",
    "magnetize",
    "magnifier",
    "magnify",
    "magnitude",
    "magnolia",
    "mahogany",
    "maimed",
    "majestic",
    "majesty",
    "majorette",
    "majority",
    "makeover",
    "maker",
    "makeshift",
    "making",
    "malformed",
    "malt",
    "mama",
    "mammal",
    "mammary",
    "mammogram",
    "manager",
    "managing",
    "manatee",
    "mandarin",
    "mandate",
    "mandatory",
    "mandolin",
    "manger",
    "mangle",
    "mango",
    "mangy",
    "manhandle",
    "manhole",
    "manhood",
    "manhunt",
    "manicotti",
    "manicure",
    "manifesto",
    "manila",
    "mankind",
    "manlike",
    "manliness",
    "manly",
    "manmade",
    "manned",
    "mannish",
    "manor",
    "manpower",
    "mantis",
    "mantra",
    "manual",
    "many",
    "map",
    "marathon",
    "marauding",
    "marbled",
    "marbles",
    "marbling",
    "march",
    "mardi",
    "margarine",
    "margarita",
    "margin",
    "marigold",
    "marina",
    "marine",
    "marital",
    "maritime",
    "marlin",
    "marmalade",
    "maroon",
    "married",
    "marrow",
    "marry",
    "marshland",
    "marshy",
    "marsupial",
    "marvelous",
    "marxism",
    "mascot",
    "masculine",
    "mashed",
    "mashing",
    "massager",
    "masses",
    "massive",
    "mastiff",
    "matador",
    "matchbook",
    "matchbox",
    "matcher",
    "matching",
    "matchless",
    "material",
    "maternal",
    "maternity",
    "math",
    "mating",
    "matriarch",
    "matrimony",
    "matrix",
    "matron",
    "matted",
    "matter",
    "maturely",
    "maturing",
    "maturity",
    "mauve",
    "maverick",
    "maximize",
    "maximum",
    "maybe",
    "mayday",
    "mayflower",
    "moaner",
    "moaning",
    "mobile",
    "mobility",
    "mobilize",
    "mobster",
    "mocha",
    "mocker",
    "mockup",
    "modified",
    "modify",
    "modular",
    "modulator",
    "module",
    "moisten",
    "moistness",
    "moisture",
    "molar",
    "molasses",
    "mold",
    "molecular",
    "molecule",
    "molehill",
    "mollusk",
    "mom",
    "monastery",
    "monday",
    "monetary",
    "monetize",
    "moneybags",
    "moneyless",
    "moneywise",
    "mongoose",
    "mongrel",
    "monitor",
    "monkhood",
    "monogamy",
    "monogram",
    "monologue",
    "monopoly",
    "monorail",
    "monotone",
    "monotype",
    "monoxide",
    "monsieur",
    "monsoon",
    "monstrous",
    "monthly",
    "monument",
    "moocher",
    "moodiness",
    "moody",
    "mooing",
    "moonbeam",
    "mooned",
    "moonlight",
    "moonlike",
    "moonlit",
    "moonrise",
    "moonscape",
    "moonshine",
    "moonstone",
    "moonwalk",
    "mop",
    "morale",
    "morality",
    "morally",
    "morbidity",
    "morbidly",
    "morphine",
    "morphing",
    "morse",
    "mortality",
    "mortally",
    "mortician",
    "mortified",
    "mortify",
    "mortuary",
    "mosaic",
    "mossy",
    "most",
    "mothball",
    "mothproof",
    "motion",
    "motivate",
    "motivator",
    "motive",
    "motocross",
    "motor",
    "motto",
    "mountable",
    "mountain",
    "mounted",
    "mounting",
    "mourner",
    "mournful",
    "mouse",
    "mousiness",
    "moustache",
    "mousy",
    "mouth",
    "movable",
    "move",
    "movie",
    "moving",
    "mower",
    "mowing",
    "much",
    "muck",
    "mud",
    "mug",
    "mulberry",
    "mulch",
    "mule",
    "mulled",
    "mullets",
    "multiple",
    "multiply",
    "multitask",
    "multitude",
    "mumble",
    "mumbling",
    "mumbo",
    "mummified",
    "mummify",
    "mummy",
    "mumps",
    "munchkin",
    "mundane",
    "municipal",
    "muppet",
    "mural",
    "murkiness",
    "murky",
    "murmuring",
    "muscular",
    "museum",
    "mushily",
    "mushiness",
    "mushroom",
    "mushy",
    "music",
    "musket",
    "muskiness",
    "musky",
    "mustang",
    "mustard",
    "muster",
    "mustiness",
    "musty",
    "mutable",
    "mutate",
    "mutation",
    "mute",
    "mutilated",
    "mutilator",
    "mutiny",
    "mutt",
    "mutual",
    "muzzle",
    "myself",
    "myspace",
    "mystified",
    "mystify",
    "myth",
    "nacho",
    "nag",
    "nail",
    "name",
    "naming",
    "nanny",
    "nanometer",
    "nape",
    "napkin",
    "napped",
    "napping",
    "nappy",
    "narrow",
    "nastily",
    "nastiness",
    "national",
    "native",
    "nativity",
    "natural",
    "nature",
    "naturist",
    "nautical",
    "navigate",
    "navigator",
    "navy",
    "nearby",
    "nearest",
    "nearly",
    "nearness",
    "neatly",
    "neatness",
    "nebula",
    "nebulizer",
    "nectar",
    "negate",
    "negation",
    "negative",
    "neglector",
    "negligee",
    "negligent",
    "negotiate",
    "nemeses",
    "nemesis",
    "neon",
    "nephew",
    "nerd",
    "nervous",
    "nervy",
    "nest",
    "net",
    "neurology",
    "neuron",
    "neurosis",
    "neurotic",
    "neuter",
    "neutron",
    "never",
    "next",
    "nibble",
    "nickname",
    "nicotine",
    "niece",
    "nifty",
    "nimble",
    "nimbly",
    "nineteen",
    "ninetieth",
    "ninja",
    "nintendo",
    "ninth",
    "nuclear",
    "nuclei",
    "nucleus",
    "nugget",
    "nullify",
    "number",
    "numbing",
    "numbly",
    "numbness",
    "numeral",
    "numerate",
    "numerator",
    "numeric",
    "numerous",
    "nuptials",
    "nursery",
    "nursing",
    "nurture",
    "nutcase",
    "nutlike",
    "nutmeg",
    "nutrient",
    "nutshell",
    "nuttiness",
    "nutty",
    "nuzzle",
    "nylon",
    "oaf",
    "oak",
    "oasis",
    "oat",
    "obedience",
    "obedient",
    "obituary",
    "object",
    "obligate",
    "obliged",
    "oblivion",
    "oblivious",
    "oblong",
    "obnoxious",
    "oboe",
    "obscure",
    "obscurity",
    "observant",
    "observer",
    "observing",
    "obsessed",
    "obsession",
    "obsessive",
    "obsolete",
    "obstacle",
    "obstinate",
    "obstruct",
    "obtain",
    "obtrusive",
    "obtuse",
    "obvious",
    "occultist",
    "occupancy",
    "occupant",
    "occupier",
    "occupy",
    "ocean",
    "ocelot",
    "octagon",
    "octane",
    "october",
    "octopus",
    "ogle",
    "oil",
    "oink",
    "ointment",
    "okay",
    "old",
    "olive",
    "olympics",
    "omega",
    "omen",
    "ominous",
    "omission",
    "omit",
    "omnivore",
    "onboard",
    "oncoming",
    "ongoing",
    "onion",
    "online",
    "onlooker",
    "only",
    "onscreen",
    "onset",
    "onshore",
    "onslaught",
    "onstage",
    "onto",
    "onward",
    "onyx",
    "oops",
    "ooze",
    "oozy",
    "opacity",
    "opal",
    "open",
    "operable",
    "operate",
    "operating",
    "operation",
    "operative",
    "operator",
    "opium",
    "opossum",
    "opponent",
    "oppose",
    "opposing",
    "opposite",
    "oppressed",
    "oppressor",
    "opt",
    "opulently",
    "osmosis",
    "other",
    "otter",
    "ouch",
    "ought",
    "ounce",
    "outage",
    "outback",
    "outbid",
    "outboard",
    "outbound",
    "outbreak",
    "outburst",
    "outcast",
    "outclass",
    "outcome",
    "outdated",
    "outdoors",
    "outer",
    "outfield",
    "outfit",
    "outflank",
    "outgoing",
    "outgrow",
    "outhouse",
    "outing",
    "outlast",
    "outlet",
    "outline",
    "outlook",
    "outlying",
    "outmatch",
    "outmost",
    "outnumber",
    "outplayed",
    "outpost",
    "outpour",
    "output",
    "outrage",
    "outrank",
    "outreach",
    "outright",
    "outscore",
    "outsell",
    "outshine",
    "outshoot",
    "outsider",
    "outskirts",
    "outsmart",
    "outsource",
    "outspoken",
    "outtakes",
    "outthink",
    "outward",
    "outweigh",
    "outwit",
    "oval",
    "ovary",
    "oven",
    "overact",
    "overall",
    "overarch",
    "overbid",
    "overbill",
    "overbite",
    "overblown",
    "overboard",
    "overbook",
    "overbuilt",
    "overcast",
    "overcoat",
    "overcome",
    "overcook",
    "overcrowd",
    "overdraft",
    "overdrawn",
    "overdress",
    "overdrive",
    "overdue",
    "overeager",
    "overeater",
    "overexert",
    "overfed",
    "overfeed",
    "overfill",
    "overflow",
    "overfull",
    "overgrown",
    "overhand",
    "overhang",
    "overhaul",
    "overhead",
    "overhear",
    "overheat",
    "overhung",
    "overjoyed",
    "overkill",
    "overlabor",
    "overlaid",
    "overlap",
    "overlay",
    "overload",
    "overlook",
    "overlord",
    "overlying",
    "overnight",
    "overpass",
    "overpay",
    "overplant",
    "overplay",
    "overpower",
    "overprice",
    "overrate",
    "overreach",
    "overreact",
    "override",
    "overripe",
    "overrule",
    "overrun",
    "overshoot",
    "overshot",
    "oversight",
    "oversized",
    "oversleep",
    "oversold",
    "overspend",
    "overstate",
    "overstay",
    "overstep",
    "overstock",
    "overstuff",
    "oversweet",
    "overtake",
    "overthrow",
    "overtime",
    "overtly",
    "overtone",
    "overture",
    "overturn",
    "overuse",
    "overvalue",
    "overview",
    "overwrite",
    "owl",
    "oxford",
    "oxidant",
    "oxidation",
    "oxidize",
    "oxidizing",
    "oxygen",
    "oxymoron",
    "oyster",
    "ozone",
    "paced",
    "pacemaker",
    "pacific",
    "pacifier",
    "pacifism",
    "pacifist",
    "pacify",
    "padded",
    "padding",
    "paddle",
    "paddling",
    "padlock",
    "pagan",
    "pager",
    "paging",
    "pajamas",
    "palace",
    "palatable",
    "palm",
    "palpable",
    "palpitate",
    "paltry",
    "pampered",
    "pamperer",
    "pampers",
    "pamphlet",
    "panama",
    "pancake",
    "pancreas",
    "panda",
    "pandemic",
    "pang",
    "panhandle",
    "panic",
    "panning",
    "panorama",
    "panoramic",
    "panther",
    "pantomime",
    "pantry",
    "pants",
    "pantyhose",
    "paparazzi",
    "papaya",
    "paper",
    "paprika",
    "papyrus",
    "parabola",
    "parachute",
    "parade",
    "paradox",
    "paragraph",
    "parakeet",
    "paralegal",
    "paralyses",
    "paralysis",
    "paralyze",
    "paramedic",
    "parameter",
    "paramount",
    "parasail",
    "parasite",
    "parasitic",
    "parcel",
    "parched",
    "parchment",
    "pardon",
    "parish",
    "parka",
    "parking",
    "parkway",
    "parlor",
    "parmesan",
    "parole",
    "parrot",
    "parsley",
    "parsnip",
    "partake",
    "parted",
    "parting",
    "partition",
    "partly",
    "partner",
    "partridge",
    "party",
    "passable",
    "passably",
    "passage",
    "passcode",
    "passenger",
    "passerby",
    "passing",
    "passion",
    "passive",
    "passivism",
    "passover",
    "passport",
    "password",
    "pasta",
    "pasted",
    "pastel",
    "pastime",
    "pastor",
    "pastrami",
    "pasture",
    "pasty",
    "patchwork",
    "patchy",
    "paternal",
    "paternity",
    "path",
    "patience",
    "patient",
    "patio",
    "patriarch",
    "patriot",
    "patrol",
    "patronage",
    "patronize",
    "pauper",
    "pavement",
    "paver",
    "pavestone",
    "pavilion",
    "paving",
    "pawing",
    "payable",
    "payback",
    "paycheck",
    "payday",
    "payee",
    "payer",
    "paying",
    "payment",
    "payphone",
    "payroll",
    "pebble",
    "pebbly",
    "pecan",
    "pectin",
    "peculiar",
    "peddling",
    "pediatric",
    "pedicure",
    "pedigree",
    "pedometer",
    "pegboard",
    "pelican",
    "pellet",
    "pelt",
    "pelvis",
    "penalize",
    "penalty",
    "pencil",
    "pendant",
    "pending",
    "penholder",
    "penknife",
    "pennant",
    "penniless",
    "penny",
    "penpal",
    "pension",
    "pentagon",
    "pentagram",
    "pep",
    "perceive",
    "percent",
    "perch",
    "percolate",
    "perennial",
    "perfected",
    "perfectly",
    "perfume",
    "periscope",
    "perish",
    "perjurer",
    "perjury",
    "perkiness",
    "perky",
    "perm",
    "peroxide",
    "perpetual",
    "perplexed",
    "persecute",
    "persevere",
    "persuaded",
    "persuader",
    "pesky",
    "peso",
    "pessimism",
    "pessimist",
    "pester",
    "pesticide",
    "petal",
    "petite",
    "petition",
    "petri",
    "petroleum",
    "petted",
    "petticoat",
    "pettiness",
    "petty",
    "petunia",
    "phantom",
    "phobia",
    "phoenix",
    "phonebook",
    "phoney",
    "phonics",
    "phoniness",
    "phony",
    "phosphate",
    "photo",
    "phrase",
    "phrasing",
    "placard",
    "placate",
    "placidly",
    "plank",
    "planner",
    "plant",
    "plasma",
    "plaster",
    "plastic",
    "plated",
    "platform",
    "plating",
    "platinum",
    "platonic",
    "platter",
    "platypus",
    "plausible",
    "plausibly",
    "playable",
    "playback",
    "player",
    "playful",
    "playgroup",
    "playhouse",
    "playing",
    "playlist",
    "playmaker",
    "playmate",
    "playoff",
    "playpen",
    "playroom",
    "playset",
    "plaything",
    "playtime",
    "plaza",
    "pleading",
    "pleat",
    "pledge",
    "plentiful",
    "plenty",
    "plethora",
    "plexiglas",
    "pliable",
    "plod",
    "plop",
    "plot",
    "plow",
    "ploy",
    "pluck",
    "plug",
    "plunder",
    "plunging",
    "plural",
    "plus",
    "plutonium",
    "plywood",
    "poach",
    "pod",
    "poem",
    "poet",
    "pogo",
    "pointed",
    "pointer",
    "pointing",
    "pointless",
    "pointy",
    "poise",
    "poison",
    "poker",
    "poking",
    "polar",
    "police",
    "policy",
    "polio",
    "polish",
    "politely",
    "polka",
    "polo",
    "polyester",
    "polygon",
    "polygraph",
    "polymer",
    "poncho",
    "pond",
    "pony",
    "popcorn",
    "pope",
    "poplar",
    "popper",
    "poppy",
    "popsicle",
    "populace",
    "popular",
    "populate",
    "porcupine",
    "pork",
    "porous",
    "porridge",
    "portable",
    "portal",
    "portfolio",
    "porthole",
    "portion",
    "portly",
    "portside",
    "poser",
    "posh",
    "posing",
    "possible",
    "possibly",
    "possum",
    "postage",
    "postal",
    "postbox",
    "postcard",
    "posted",
    "poster",
    "posting",
    "postnasal",
    "posture",
    "postwar",
    "pouch",
    "pounce",
    "pouncing",
    "pound",
    "pouring",
    "pout",
    "powdered",
    "powdering",
    "powdery",
    "power",
    "powwow",
    "pox",
    "praising",
    "prance",
    "prancing",
    "pranker",
    "prankish",
    "prankster",
    "prayer",
    "praying",
    "preacher",
    "preaching",
    "preachy",
    "preamble",
    "precinct",
    "precise",
    "precision",
    "precook",
    "precut",
    "predator",
    "predefine",
    "predict",
    "preface",
    "prefix",
    "preflight",
    "preformed",
    "pregame",
    "pregnancy",
    "pregnant",
    "preheated",
    "prelaunch",
    "prelaw",
    "prelude",
    "premiere",
    "premises",
    "premium",
    "prenatal",
    "preoccupy",
    "preorder",
    "prepaid",
    "prepay",
    "preplan",
    "preppy",
    "preschool",
    "prescribe",
    "preseason",
    "preset",
    "preshow",
    "president",
    "presoak",
    "press",
    "presume",
    "presuming",
    "preteen",
    "pretended",
    "pretender",
    "pretense",
    "pretext",
    "pretty",
    "pretzel",
    "prevail",
    "prevalent",
    "prevent",
    "preview",
    "previous",
    "prewar",
    "prewashed",
    "prideful",
    "pried",
    "primal",
    "primarily",
    "primary",
    "primate",
    "primer",
    "primp",
    "princess",
    "print",
    "prior",
    "prism",
    "prison",
    "prissy",
    "pristine",
    "privacy",
    "private",
    "privatize",
    "prize",
    "proactive",
    "probable",
    "probably",
    "probation",
    "probe",
    "probing",
    "probiotic",
    "problem",
    "procedure",
    "process",
    "proclaim",
    "procreate",
    "procurer",
    "prodigal",
    "prodigy",
    "produce",
    "product",
    "profane",
    "profanity",
    "professed",
    "professor",
    "profile",
    "profound",
    "profusely",
    "progeny",
    "prognosis",
    "program",
    "progress",
    "projector",
    "prologue",
    "prolonged",
    "promenade",
    "prominent",
    "promoter",
    "promotion",
    "prompter",
    "promptly",
    "prone",
    "prong",
    "pronounce",
    "pronto",
    "proofing",
    "proofread",
    "proofs",
    "propeller",
    "properly",
    "property",
    "proponent",
    "proposal",
    "propose",
    "props",
    "prorate",
    "protector",
    "protegee",
    "proton",
    "prototype",
    "protozoan",
    "protract",
    "protrude",
    "proud",
    "provable",
    "proved",
    "proven",
    "provided",
    "provider",
    "providing",
    "province",
    "proving",
    "provoke",
    "provoking",
    "provolone",
    "prowess",
    "prowler",
    "prowling",
    "proximity",
    "proxy",
    "prozac",
    "prude",
    "prudishly",
    "prune",
    "pruning",
    "pry",
    "psychic",
    "public",
    "publisher",
    "pucker",
    "pueblo",
    "pug",
    "pull",
    "pulmonary",
    "pulp",
    "pulsate",
    "pulse",
    "pulverize",
    "puma",
    "pumice",
    "pummel",
    "punch",
    "punctual",
    "punctuate",
    "punctured",
    "pungent",
    "punisher",
    "punk",
    "pupil",
    "puppet",
    "puppy",
    "purchase",
    "pureblood",
    "purebred",
    "purely",
    "pureness",
    "purgatory",
    "purge",
    "purging",
    "purifier",
    "purify",
    "purist",
    "puritan",
    "purity",
    "purple",
    "purplish",
    "purposely",
    "purr",
    "purse",
    "pursuable",
    "pursuant",
    "pursuit",
    "purveyor",
    "pushcart",
    "pushchair",
    "pusher",
    "pushiness",
    "pushing",
    "pushover",
    "pushpin",
    "pushup",
    "pushy",
    "putdown",
    "putt",
    "puzzle",
    "puzzling",
    "pyramid",
    "pyromania",
    "python",
    "quack",
    "quadrant",
    "quail",
    "quaintly",
    "quake",
    "quaking",
    "qualified",
    "qualifier",
    "qualify",
    "quality",
    "qualm",
    "quantum",
    "quarrel",
    "quarry",
    "quartered",
    "quarterly",
    "quarters",
    "quartet",
    "quench",
    "query",
    "quicken",
    "quickly",
    "quickness",
    "quicksand",
    "quickstep",
    "quiet",
    "quill",
    "quilt",
    "quintet",
    "quintuple",
    "quirk",
    "quit",
    "quiver",
    "quizzical",
    "quotable",
    "quotation",
    "quote",
    "rabid",
    "race",
    "racing",
    "racism",
    "rack",
    "racoon",
    "radar",
    "radial",
    "radiance",
    "radiantly",
    "radiated",
    "radiation",
    "radiator",
    "radio",
    "radish",
    "raffle",
    "raft",
    "rage",
    "ragged",
    "raging",
    "ragweed",
    "raider",
    "railcar",
    "railing",
    "railroad",
    "railway",
    "raisin",
    "rake",
    "raking",
    "rally",
    "ramble",
    "rambling",
    "ramp",
    "ramrod",
    "ranch",
    "rancidity",
    "random",
    "ranged",
    "ranger",
    "ranging",
    "ranked",
    "ranking",
    "ransack",
    "ranting",
    "rants",
    "rare",
    "rarity",
    "rascal",
    "rash",
    "rasping",
    "ravage",
    "raven",
    "ravine",
    "raving",
    "ravioli",
    "ravishing",
    "reabsorb",
    "reach",
    "reacquire",
    "reaction",
    "reactive",
    "reactor",
    "reaffirm",
    "ream",
    "reanalyze",
    "reappear",
    "reapply",
    "reappoint",
    "reapprove",
    "rearrange",
    "rearview",
    "reason",
    "reassign",
    "reassure",
    "reattach",
    "reawake",
    "rebalance",
    "rebate",
    "rebel",
    "rebirth",
    "reboot",
    "reborn",
    "rebound",
    "rebuff",
    "rebuild",
    "rebuilt",
    "reburial",
    "rebuttal",
    "recall",
    "recant",
    "recapture",
    "recast",
    "recede",
    "recent",
    "recess",
    "recharger",
    "recipient",
    "recital",
    "recite",
    "reckless",
    "reclaim",
    "recliner",
    "reclining",
    "recluse",
    "reclusive",
    "recognize",
    "recoil",
    "recollect",
    "recolor",
    "reconcile",
    "reconfirm",
    "reconvene",
    "recopy",
    "record",
    "recount",
    "recoup",
    "recovery",
    "recreate",
    "rectal",
    "rectangle",
    "rectified",
    "rectify",
    "recycled",
    "recycler",
    "recycling",
    "reemerge",
    "reenact",
    "reenter",
    "reentry",
    "reexamine",
    "referable",
    "referee",
    "reference",
    "refill",
    "refinance",
    "refined",
    "refinery",
    "refining",
    "refinish",
    "reflected",
    "reflector",
    "reflex",
    "reflux",
    "refocus",
    "refold",
    "reforest",
    "reformat",
    "reformed",
    "reformer",
    "reformist",
    "refract",
    "refrain",
    "refreeze",
    "refresh",
    "refried",
    "refueling",
    "refund",
    "refurbish",
    "refurnish",
    "refusal",
    "refuse",
    "refusing",
    "refutable",
    "refute",
    "regain",
    "regalia",
    "regally",
    "reggae",
    "regime",
    "region",
    "register",
    "registrar",
    "registry",
    "regress",
    "regretful",
    "regroup",
    "regular",
    "regulate",
    "regulator",
    "rehab",
    "reheat",
    "rehire",
    "rehydrate",
    "reimburse",
    "reissue",
    "reiterate",
    "rejoice",
    "rejoicing",
    "rejoin",
    "rekindle",
    "relapse",
    "relapsing",
    "relatable",
    "related",
    "relation",
    "relative",
    "relax",
    "relay",
    "relearn",
    "release",
    "relenting",
    "reliable",
    "reliably",
    "reliance",
    "reliant",
    "relic",
    "relieve",
    "relieving",
    "relight",
    "relish",
    "relive",
    "reload",
    "relocate",
    "relock",
    "reluctant",
    "rely",
    "remake",
    "remark",
    "remarry",
    "rematch",
    "remedial",
    "remedy",
    "remember",
    "reminder",
    "remindful",
    "remission",
    "remix",
    "remnant",
    "remodeler",
    "remold",
    "remorse",
    "remote",
    "removable",
    "removal",
    "removed",
    "remover",
    "removing",
    "rename",
    "renderer",
    "rendering",
    "rendition",
    "renegade",
    "renewable",
    "renewably",
    "renewal",
    "renewed",
    "renounce",
    "renovate",
    "renovator",
    "rentable",
    "rental",
    "rented",
    "renter",
    "reoccupy",
    "reoccur",
    "reopen",
    "reorder",
    "repackage",
    "repacking",
    "repaint",
    "repair",
    "repave",
    "repaying",
    "repayment",
    "repeal",
    "repeated",
    "repeater",
    "repent",
    "rephrase",
    "replace",
    "replay",
    "replica",
    "reply",
    "reporter",
    "repose",
    "repossess",
    "repost",
    "repressed",
    "reprimand",
    "reprint",
    "reprise",
    "reproach",
    "reprocess",
    "reproduce",
    "reprogram",
    "reps",
    "reptile",
    "reptilian",
    "repugnant",
    "repulsion",
    "repulsive",
    "repurpose",
    "reputable",
    "reputably",
    "request",
    "require",
    "requisite",
    "reroute",
    "rerun",
    "resale",
    "resample",
    "rescuer",
    "reseal",
    "research",
    "reselect",
    "reseller",
    "resemble",
    "resend",
    "resent",
    "reset",
    "reshape",
    "reshoot",
    "reshuffle",
    "residence",
    "residency",
    "resident",
    "residual",
    "residue",
    "resigned",
    "resilient",
    "resistant",
    "resisting",
    "resize",
    "resolute",
    "resolved",
    "resonant",
    "resonate",
    "resort",
    "resource",
    "respect",
    "resubmit",
    "result",
    "resume",
    "resupply",
    "resurface",
    "resurrect",
    "retail",
    "retainer",
    "retaining",
    "retake",
    "retaliate",
    "retention",
    "rethink",
    "retinal",
    "retired",
    "retiree",
    "retiring",
    "retold",
    "retool",
    "retorted",
    "retouch",
    "retrace",
    "retract",
    "retrain",
    "retread",
    "retreat",
    "retrial",
    "retrieval",
    "retriever",
    "retry",
    "return",
    "retying",
    "retype",
    "reunion",
    "reunite",
    "reusable",
    "reuse",
    "reveal",
    "reveler",
    "revenge",
    "revenue",
    "reverb",
    "revered",
    "reverence",
    "reverend",
    "reversal",
    "reverse",
    "reversing",
    "reversion",
    "revert",
    "revisable",
    "revise",
    "revision",
    "revisit",
    "revivable",
    "revival",
    "reviver",
    "reviving",
    "revocable",
    "revoke",
    "revolt",
    "revolver",
    "revolving",
    "reward",
    "rewash",
    "rewind",
    "rewire",
    "reword",
    "rework",
    "rewrap",
    "rewrite",
    "rhyme",
    "ribbon",
    "ribcage",
    "rice",
    "riches",
    "richly",
    "richness",
    "rickety",
    "ricotta",
    "riddance",
    "ridden",
    "ride",
    "riding",
    "rifling",
    "rift",
    "rigging",
    "rigid",
    "rigor",
    "rimless",
    "rimmed",
    "rind",
    "rink",
    "rinse",
    "rinsing",
    "riot",
    "ripcord",
    "ripeness",
    "ripening",
    "ripping",
    "ripple",
    "rippling",
    "riptide",
    "rise",
    "rising",
    "risk",
    "risotto",
    "ritalin",
    "ritzy",
    "rival",
    "riverbank",
    "riverbed",
    "riverboat",
    "riverside",
    "riveter",
    "riveting",
    "roamer",
    "roaming",
    "roast",
    "robbing",
    "robe",
    "robin",
    "robotics",
    "robust",
    "rockband",
    "rocker",
    "rocket",
    "rockfish",
    "rockiness",
    "rocking",
    "rocklike",
    "rockslide",
    "rockstar",
    "rocky",
    "rogue",
    "roman",
    "romp",
    "rope",
    "roping",
    "roster",
    "rosy",
    "rotten",
    "rotting",
    "rotunda",
    "roulette",
    "rounding",
    "roundish",
    "roundness",
    "roundup",
    "roundworm",
    "routine",
    "routing",
    "rover",
    "roving",
    "royal",
    "rubbed",
    "rubber",
    "rubbing",
    "rubble",
    "rubdown",
    "ruby",
    "ruckus",
    "rudder",
    "rug",
    "ruined",
    "rule",
    "rumble",
    "rumbling",
    "rummage",
    "rumor",
    "runaround",
    "rundown",
    "runner",
    "running",
    "runny",
    "runt",
    "runway",
    "rupture",
    "rural",
    "ruse",
    "rush",
    "rust",
    "rut",
    "sabbath",
    "sabotage",
    "sacrament",
    "sacred",
    "sacrifice",
    "sadden",
    "saddlebag",
    "saddled",
    "saddling",
    "sadly",
    "sadness",
    "safari",
    "safeguard",
    "safehouse",
    "safely",
    "safeness",
    "saffron",
    "saga",
    "sage",
    "sagging",
    "saggy",
    "said",
    "saint",
    "sake",
    "salad",
    "salami",
    "salaried",
    "salary",
    "saline",
    "salon",
    "saloon",
    "salsa",
    "salt",
    "salutary",
    "salute",
    "salvage",
    "salvaging",
    "salvation",
    "same",
    "sample",
    "sampling",
    "sanction",
    "sanctity",
    "sanctuary",
    "sandal",
    "sandbag",
    "sandbank",
    "sandbar",
    "sandblast",
    "sandbox",
    "sanded",
    "sandfish",
    "sanding",
    "sandlot",
    "sandpaper",
    "sandpit",
    "sandstone",
    "sandstorm",
    "sandworm",
    "sandy",
    "sanitary",
    "sanitizer",
    "sank",
    "santa",
    "sapling",
    "sappiness",
    "sappy",
    "sarcasm",
    "sarcastic",
    "sardine",
    "sash",
    "sasquatch",
    "sassy",
    "satchel",
    "satiable",
    "satin",
    "satirical",
    "satisfied",
    "satisfy",
    "saturate",
    "saturday",
    "sauciness",
    "saucy",
    "sauna",
    "savage",
    "savanna",
    "saved",
    "savings",
    "savior",
    "savor",
    "saxophone",
    "say",
    "scabbed",
    "scabby",
    "scalded",
    "scalding",
    "scale",
    "scaling",
    "scallion",
    "scallop",
    "scalping",
    "scam",
    "scandal",
    "scanner",
    "scanning",
    "scant",
    "scapegoat",
    "scarce",
    "scarcity",
    "scarecrow",
    "scared",
    "scarf",
    "scarily",
    "scariness",
    "scarring",
    "scary",
    "scavenger",
    "scenic",
    "schedule",
    "schematic",
    "scheme",
    "scheming",
    "schilling",
    "schnapps",
    "scholar",
    "science",
    "scientist",
    "scion",
    "scoff",
    "scolding",
    "scone",
    "scoop",
    "scooter",
    "scope",
    "scorch",
    "scorebook",
    "scorecard",
    "scored",
    "scoreless",
    "scorer",
    "scoring",
    "scorn",
    "scorpion",
    "scotch",
    "scoundrel",
    "scoured",
    "scouring",
    "scouting",
    "scouts",
    "scowling",
    "scrabble",
    "scraggly",
    "scrambled",
    "scrambler",
    "scrap",
    "scratch",
    "scrawny",
    "screen",
    "scribble",
    "scribe",
    "scribing",
    "scrimmage",
    "script",
    "scroll",
    "scrooge",
    "scrounger",
    "scrubbed",
    "scrubber",
    "scruffy",
    "scrunch",
    "scrutiny",
    "scuba",
    "scuff",
    "sculptor",
    "sculpture",
    "scurvy",
    "scuttle",
    "secluded",
    "secluding",
    "seclusion",
    "second",
    "secrecy",
    "secret",
    "sectional",
    "sector",
    "secular",
    "securely",
    "security",
    "sedan",
    "sedate",
    "sedation",
    "sedative",
    "sediment",
    "seduce",
    "seducing",
    "segment",
    "seismic",
    "seizing",
    "seldom",
    "selected",
    "selection",
    "selective",
    "selector",
    "self",
    "seltzer",
    "semantic",
    "semester",
    "semicolon",
    "semifinal",
    "seminar",
    "semisoft",
    "semisweet",
    "senate",
    "senator",
    "send",
    "senior",
    "senorita",
    "sensation",
    "sensitive",
    "sensitize",
    "sensually",
    "sensuous",
    "sepia",
    "september",
    "septic",
    "septum",
    "sequel",
    "sequence",
    "sequester",
    "series",
    "sermon",
    "serotonin",
    "serpent",
    "serrated",
    "serve",
    "service",
    "serving",
    "sesame",
    "sessions",
    "setback",
    "setting",
    "settle",
    "settling",
    "setup",
    "sevenfold",
    "seventeen",
    "seventh",
    "seventy",
    "severity",
    "shabby",
    "shack",
    "shaded",
    "shadily",
    "shadiness",
    "shading",
    "shadow",
    "shady",
    "shaft",
    "shakable",
    "shakily",
    "shakiness",
    "shaking",
    "shaky",
    "shale",
    "shallot",
    "shallow",
    "shame",
    "shampoo",
    "shamrock",
    "shank",
    "shanty",
    "shape",
    "shaping",
    "share",
    "sharpener",
    "sharper",
    "sharpie",
    "sharply",
    "sharpness",
    "shawl",
    "sheath",
    "shed",
    "sheep",
    "sheet",
    "shelf",
    "shell",
    "shelter",
    "shelve",
    "shelving",
    "sherry",
    "shield",
    "shifter",
    "shifting",
    "shiftless",
    "shifty",
    "shimmer",
    "shimmy",
    "shindig",
    "shine",
    "shingle",
    "shininess",
    "shining",
    "shiny",
    "ship",
    "shirt",
    "shivering",
    "shock",
    "shone",
    "shoplift",
    "shopper",
    "shopping",
    "shoptalk",
    "shore",
    "shortage",
    "shortcake",
    "shortcut",
    "shorten",
    "shorter",
    "shorthand",
    "shortlist",
    "shortly",
    "shortness",
    "shorts",
    "shortwave",
    "shorty",
    "shout",
    "shove",
    "showbiz",
    "showcase",
    "showdown",
    "shower",
    "showgirl",
    "showing",
    "showman",
    "shown",
    "showoff",
    "showpiece",
    "showplace",
    "showroom",
    "showy",
    "shrank",
    "shrapnel",
    "shredder",
    "shredding",
    "shrewdly",
    "shriek",
    "shrill",
    "shrimp",
    "shrine",
    "shrink",
    "shrivel",
    "shrouded",
    "shrubbery",
    "shrubs",
    "shrug",
    "shrunk",
    "shucking",
    "shudder",
    "shuffle",
    "shuffling",
    "shun",
    "shush",
    "shut",
    "shy",
    "siamese",
    "siberian",
    "sibling",
    "siding",
    "sierra",
    "siesta",
    "sift",
    "sighing",
    "silenced",
    "silencer",
    "silent",
    "silica",
    "silicon",
    "silk",
    "silliness",
    "silly",
    "silo",
    "silt",
    "silver",
    "similarly",
    "simile",
    "simmering",
    "simple",
    "simplify",
    "simply",
    "sincere",
    "sincerity",
    "singer",
    "singing",
    "single",
    "singular",
    "sinister",
    "sinless",
    "sinner",
    "sinuous",
    "sip",
    "siren",
    "sister",
    "sitcom",
    "sitter",
    "sitting",
    "situated",
    "situation",
    "sixfold",
    "sixteen",
    "sixth",
    "sixties",
    "sixtieth",
    "sixtyfold",
    "sizable",
    "sizably",
    "size",
    "sizing",
    "sizzle",
    "sizzling",
    "skater",
    "skating",
    "skedaddle",
    "skeletal",
    "skeleton",
    "skeptic",
    "sketch",
    "skewed",
    "skewer",
    "skid",
    "skied",
    "skier",
    "skies",
    "skiing",
    "skilled",
    "skillet",
    "skillful",
    "skimmed",
    "skimmer",
    "skimming",
    "skimpily",
    "skincare",
    "skinhead",
    "skinless",
    "skinning",
    "skinny",
    "skintight",
    "skipper",
    "skipping",
    "skirmish",
    "skirt",
    "skittle",
    "skydiver",
    "skylight",
    "skyline",
    "skype",
    "skyrocket",
    "skyward",
    "slab",
    "slacked",
    "slacker",
    "slacking",
    "slackness",
    "slacks",
    "slain",
    "slam",
    "slander",
    "slang",
    "slapping",
    "slapstick",
    "slashed",
    "slashing",
    "slate",
    "slather",
    "slaw",
    "sled",
    "sleek",
    "sleep",
    "sleet",
    "sleeve",
    "slept",
    "sliceable",
    "sliced",
    "slicer",
    "slicing",
    "slick",
    "slider",
    "slideshow",
    "sliding",
    "slighted",
    "slighting",
    "slightly",
    "slimness",
    "slimy",
    "slinging",
    "slingshot",
    "slinky",
    "slip",
    "slit",
    "sliver",
    "slobbery",
    "slogan",
    "sloped",
    "sloping",
    "sloppily",
    "sloppy",
    "slot",
    "slouching",
    "slouchy",
    "sludge",
    "slug",
    "slum",
    "slurp",
    "slush",
    "sly",
    "small",
    "smartly",
    "smartness",
    "smasher",
    "smashing",
    "smashup",
    "smell",
    "smelting",
    "smile",
    "smilingly",
    "smirk",
    "smite",
    "smith",
    "smitten",
    "smock",
    "smog",
    "smoked",
    "smokeless",
    "smokiness",
    "smoking",
    "smoky",
    "smolder",
    "smooth",
    "smother",
    "smudge",
    "smudgy",
    "smuggler",
    "smuggling",
    "smugly",
    "smugness",
    "snack",
    "snagged",
    "snaking",
    "snap",
    "snare",
    "snarl",
    "snazzy",
    "sneak",
    "sneer",
    "sneeze",
    "sneezing",
    "snide",
    "sniff",
    "snippet",
    "snipping",
    "snitch",
    "snooper",
    "snooze",
    "snore",
    "snoring",
    "snorkel",
    "snort",
    "snout",
    "snowbird",
    "snowboard",
    "snowbound",
    "snowcap",
    "snowdrift",
    "snowdrop",
    "snowfall",
    "snowfield",
    "snowflake",
    "snowiness",
    "snowless",
    "snowman",
    "snowplow",
    "snowshoe",
    "snowstorm",
    "snowsuit",
    "snowy",
    "snub",
    "snuff",
    "snuggle",
    "snugly",
    "snugness",
    "speak",
    "spearfish",
    "spearhead",
    "spearman",
    "spearmint",
    "species",
    "specimen",
    "specked",
    "speckled",
    "specks",
    "spectacle",
    "spectator",
    "spectrum",
    "speculate",
    "speech",
    "speed",
    "spellbind",
    "speller",
    "spelling",
    "spendable",
    "spender",
    "spending",
    "spent",
    "spew",
    "sphere",
    "spherical",
    "sphinx",
    "spider",
    "spied",
    "spiffy",
    "spill",
    "spilt",
    "spinach",
    "spinal",
    "spindle",
    "spinner",
    "spinning",
    "spinout",
    "spinster",
    "spiny",
    "spiral",
    "spirited",
    "spiritism",
    "spirits",
    "spiritual",
    "splashed",
    "splashing",
    "splashy",
    "splatter",
    "spleen",
    "splendid",
    "splendor",
    "splice",
    "splicing",
    "splinter",
    "splotchy",
    "splurge",
    "spoilage",
    "spoiled",
    "spoiler",
    "spoiling",
    "spoils",
    "spoken",
    "spokesman",
    "sponge",
    "spongy",
    "sponsor",
    "spoof",
    "spookily",
    "spooky",
    "spool",
    "spoon",
    "spore",
    "sporting",
    "sports",
    "sporty",
    "spotless",
    "spotlight",
    "spotted",
    "spotter",
    "spotting",
    "spotty",
    "spousal",
    "spouse",
    "spout",
    "sprain",
    "sprang",
    "sprawl",
    "spray",
    "spree",
    "sprig",
    "spring",
    "sprinkled",
    "sprinkler",
    "sprint",
    "sprite",
    "sprout",
    "spruce",
    "sprung",
    "spry",
    "spud",
    "spur",
    "sputter",
    "spyglass",
    "squabble",
    "squad",
    "squall",
    "squander",
    "squash",
    "squatted",
    "squatter",
    "squatting",
    "squeak",
    "squealer",
    "squealing",
    "squeamish",
    "squeegee",
    "squeeze",
    "squeezing",
    "squid",
    "squiggle",
    "squiggly",
    "squint",
    "squire",
    "squirt",
    "squishier",
    "squishy",
    "stability",
    "stabilize",
    "stable",
    "stack",
    "stadium",
    "staff",
    "stage",
    "staging",
    "stagnant",
    "stagnate",
    "stainable",
    "stained",
    "staining",
    "stainless",
    "stalemate",
    "staleness",
    "stalling",
    "stallion",
    "stamina",
    "stammer",
    "stamp",
    "stand",
    "stank",
    "staple",
    "stapling",
    "starboard",
    "starch",
    "stardom",
    "stardust",
    "starfish",
    "stargazer",
    "staring",
    "stark",
    "starless",
    "starlet",
    "starlight",
    "starlit",
    "starring",
    "starry",
    "starship",
    "starter",
    "starting",
    "startle",
    "startling",
    "startup",
    "starved",
    "starving",
    "stash",
    "state",
    "static",
    "statistic",
    "statue",
    "stature",
    "status",
    "statute",
    "statutory",
    "staunch",
    "stays",
    "steadfast",
    "steadier",
    "steadily",
    "steadying",
    "steam",
    "steed",
    "steep",
    "steerable",
    "steering",
    "steersman",
    "stegosaur",
    "stellar",
    "stem",
    "stench",
    "stencil",
    "step",
    "stereo",
    "sterile",
    "sterility",
    "sterilize",
    "sterling",
    "sternness",
    "sternum",
    "stew",
    "stick",
    "stiffen",
    "stiffly",
    "stiffness",
    "stifle",
    "stifling",
    "stillness",
    "stilt",
    "stimulant",
    "stimulate",
    "stimuli",
    "stimulus",
    "stinger",
    "stingily",
    "stinging",
    "stingray",
    "stingy",
    "stinking",
    "stinky",
    "stipend",
    "stipulate",
    "stir",
    "stitch",
    "stock",
    "stoic",
    "stoke",
    "stole",
    "stomp",
    "stonewall",
    "stoneware",
    "stonework",
    "stoning",
    "stony",
    "stood",
    "stooge",
    "stool",
    "stoop",
    "stoplight",
    "stoppable",
    "stoppage",
    "stopped",
    "stopper",
    "stopping",
    "stopwatch",
    "storable",
    "storage",
    "storeroom",
    "storewide",
    "storm",
    "stout",
    "stove",
    "stowaway",
    "stowing",
    "straddle",
    "straggler",
    "strained",
    "strainer",
    "straining",
    "strangely",
    "stranger",
    "strangle",
    "strategic",
    "strategy",
    "stratus",
    "straw",
    "stray",
    "streak",
    "stream",
    "street",
    "strength",
    "strenuous",
    "strep",
    "stress",
    "stretch",
    "strewn",
    "stricken",
    "strict",
    "stride",
    "strife",
    "strike",
    "striking",
    "strive",
    "striving",
    "strobe",
    "strode",
    "stroller",
    "strongbox",
    "strongly",
    "strongman",
    "struck",
    "structure",
    "strudel",
    "struggle",
    "strum",
    "strung",
    "strut",
    "stubbed",
    "stubble",
    "stubbly",
    "stubborn",
    "stucco",
    "stuck",
    "student",
    "studied",
    "studio",
    "study",
    "stuffed",
    "stuffing",
    "stuffy",
    "stumble",
    "stumbling",
    "stump",
    "stung",
    "stunned",
    "stunner",
    "stunning",
    "stunt",
    "stupor",
    "sturdily",
    "sturdy",
    "styling",
    "stylishly",
    "stylist",
    "stylized",
    "stylus",
    "suave",
    "subarctic",
    "subatomic",
    "subdivide",
    "subdued",
    "subduing",
    "subfloor",
    "subgroup",
    "subheader",
    "subject",
    "sublease",
    "sublet",
    "sublevel",
    "sublime",
    "submarine",
    "submerge",
    "submersed",
    "submitter",
    "subpanel",
    "subpar",
    "subplot",
    "subprime",
    "subscribe",
    "subscript",
    "subsector",
    "subside",
    "subsiding",
    "subsidize",
    "subsidy",
    "subsoil",
    "subsonic",
    "substance",
    "subsystem",
    "subtext",
    "subtitle",
    "subtly",
    "subtotal",
    "subtract",
    "subtype",
    "suburb",
    "subway",
    "subwoofer",
    "subzero",
    "succulent",
    "such",
    "suction",
    "sudden",
    "sudoku",
    "suds",
    "sufferer",
    "suffering",
    "suffice",
    "suffix",
    "suffocate",
    "suffrage",
    "sugar",
    "suggest",
    "suing",
    "suitable",
    "suitably",
    "suitcase",
    "suitor",
    "sulfate",
    "sulfide",
    "sulfite",
    "sulfur",
    "sulk",
    "sullen",
    "sulphate",
    "sulphuric",
    "sultry",
    "superbowl",
    "superglue",
    "superhero",
    "superior",
    "superjet",
    "superman",
    "supermom",
    "supernova",
    "supervise",
    "supper",
    "supplier",
    "supply",
    "support",
    "supremacy",
    "supreme",
    "surcharge",
    "surely",
    "sureness",
    "surface",
    "surfacing",
    "surfboard",
    "surfer",
    "surgery",
    "surgical",
    "surging",
    "surname",
    "surpass",
    "surplus",
    "surprise",
    "surreal",
    "surrender",
    "surrogate",
    "surround",
    "survey",
    "survival",
    "survive",
    "surviving",
    "survivor",
    "sushi",
    "suspect",
    "suspend",
    "suspense",
    "sustained",
    "sustainer",
    "swab",
    "swaddling",
    "swagger",
    "swampland",
    "swan",
    "swapping",
    "swarm",
    "sway",
    "swear",
    "sweat",
    "sweep",
    "swell",
    "swept",
    "swerve",
    "swifter",
    "swiftly",
    "swiftness",
    "swimmable",
    "swimmer",
    "swimming",
    "swimsuit",
    "swimwear",
    "swinger",
    "swinging",
    "swipe",
    "swirl",
    "switch",
    "swivel",
    "swizzle",
    "swooned",
    "swoop",
    "swoosh",
    "swore",
    "sworn",
    "swung",
    "sycamore",
    "sympathy",
    "symphonic",
    "symphony",
    "symptom",
    "synapse",
    "syndrome",
    "synergy",
    "synopses",
    "synopsis",
    "synthesis",
    "synthetic",
    "syrup",
    "system",
    "t-shirt",
    "tabasco",
    "tabby",
    "tableful",
    "tables",
    "tablet",
    "tableware",
    "tabloid",
    "tackiness",
    "tacking",
    "tackle",
    "tackling",
    "tacky",
    "taco",
    "tactful",
    "tactical",
    "tactics",
    "tactile",
    "tactless",
    "tadpole",
    "taekwondo",
    "tag",
    "tainted",
    "take",
    "taking",
    "talcum",
    "talisman",
    "tall",
    "talon",
    "tamale",
    "tameness",
    "tamer",
    "tamper",
    "tank",
    "tanned",
    "tannery",
    "tanning",
    "tantrum",
    "tapeless",
    "tapered",
    "tapering",
    "tapestry",
    "tapioca",
    "tapping",
    "taps",
    "tarantula",
    "target",
    "tarmac",
    "tarnish",
    "tarot",
    "tartar",
    "tartly",
    "tartness",
    "task",
    "tassel",
    "taste",
    "tastiness",
    "tasting",
    "tasty",
    "tattered",
    "tattle",
    "tattling",
    "tattoo",
    "taunt",
    "tavern",
    "thank",
    "that",
    "thaw",
    "theater",
    "theatrics",
    "thee",
    "theft",
    "theme",
    "theology",
    "theorize",
    "thermal",
    "thermos",
    "thesaurus",
    "these",
    "thesis",
    "thespian",
    "thicken",
    "thicket",
    "thickness",
    "thieving",
    "thievish",
    "thigh",
    "thimble",
    "thing",
    "think",
    "thinly",
    "thinner",
    "thinness",
    "thinning",
    "thirstily",
    "thirsting",
    "thirsty",
    "thirteen",
    "thirty",
    "thong",
    "thorn",
    "those",
    "thousand",
    "thrash",
    "thread",
    "threaten",
    "threefold",
    "thrift",
    "thrill",
    "thrive",
    "thriving",
    "throat",
    "throbbing",
    "throng",
    "throttle",
    "throwaway",
    "throwback",
    "thrower",
    "throwing",
    "thud",
    "thumb",
    "thumping",
    "thursday",
    "thus",
    "thwarting",
    "thyself",
    "tiara",
    "tibia",
    "tidal",
    "tidbit",
    "tidiness",
    "tidings",
    "tidy",
    "tiger",
    "tighten",
    "tightly",
    "tightness",
    "tightrope",
    "tightwad",
    "tigress",
    "tile",
    "tiling",
    "till",
    "tilt",
    "timid",
    "timing",
    "timothy",
    "tinderbox",
    "tinfoil",
    "tingle",
    "tingling",
    "tingly",
    "tinker",
    "tinkling",
    "tinsel",
    "tinsmith",
    "tint",
    "tinwork",
    "tiny",
    "tipoff",
    "tipped",
    "tipper",
    "tipping",
    "tiptoeing",
    "tiptop",
    "tiring",
    "tissue",
    "trace",
    "tracing",
    "track",
    "traction",
    "tractor",
    "trade",
    "trading",
    "tradition",
    "traffic",
    "tragedy",
    "trailing",
    "trailside",
    "train",
    "traitor",
    "trance",
    "tranquil",
    "transfer",
    "transform",
    "translate",
    "transpire",
    "transport",
    "transpose",
    "trapdoor",
    "trapeze",
    "trapezoid",
    "trapped",
    "trapper",
    "trapping",
    "traps",
    "trash",
    "travel",
    "traverse",
    "travesty",
    "tray",
    "treachery",
    "treading",
    "treadmill",
    "treason",
    "treat",
    "treble",
    "tree",
    "trekker",
    "tremble",
    "trembling",
    "tremor",
    "trench",
    "trend",
    "trespass",
    "triage",
    "trial",
    "triangle",
    "tribesman",
    "tribunal",
    "tribune",
    "tributary",
    "tribute",
    "triceps",
    "trickery",
    "trickily",
    "tricking",
    "trickle",
    "trickster",
    "tricky",
    "tricolor",
    "tricycle",
    "trident",
    "tried",
    "trifle",
    "trifocals",
    "trillion",
    "trilogy",
    "trimester",
    "trimmer",
    "trimming",
    "trimness",
    "trinity",
    "trio",
    "tripod",
    "tripping",
    "triumph",
    "trivial",
    "trodden",
    "trolling",
    "trombone",
    "trophy",
    "tropical",
    "tropics",
    "trouble",
    "troubling",
    "trough",
    "trousers",
    "trout",
    "trowel",
    "truce",
    "truck",
    "truffle",
    "trump",
    "trunks",
    "trustable",
    "trustee",
    "trustful",
    "trusting",
    "trustless",
    "truth",
    "try",
    "tubby",
    "tubeless",
    "tubular",
    "tucking",
    "tuesday",
    "tug",
    "tuition",
    "tulip",
    "tumble",
    "tumbling",
    "tummy",
    "turban",
    "turbine",
    "turbofan",
    "turbojet",
    "turbulent",
    "turf",
    "turkey",
    "turmoil",
    "turret",
    "turtle",
    "tusk",
    "tutor",
    "tutu",
    "tux",
    "tweak",
    "tweed",
    "tweet",
    "tweezers",
    "twelve",
    "twentieth",
    "twenty",
    "twerp",
    "twice",
    "twiddle",
    "twiddling",
    "twig",
    "twilight",
    "twine",
    "twins",
    "twirl",
    "twistable",
    "twisted",
    "twister",
    "twisting",
    "twisty",
    "twitch",
    "twitter",
    "tycoon",
    "tying",
    "tyke",
    "udder",
    "ultimate",
    "ultimatum",
    "ultra",
    "umbilical",
    "umbrella",
    "umpire",
    "unabashed",
    "unable",
    "unadorned",
    "unadvised",
    "unafraid",
    "unaired",
    "unaligned",
    "unaltered",
    "unarmored",
    "unashamed",
    "unaudited",
    "unawake",
    "unaware",
    "unbaked",
    "unbalance",
    "unbeaten",
    "unbend",
    "unbent",
    "unbiased",
    "unbitten",
    "unblended",
    "unblessed",
    "unblock",
    "unbolted",
    "unbounded",
    "unboxed",
    "unbraided",
    "unbridle",
    "unbroken",
    "unbuckled",
    "unbundle",
    "unburned",
    "unbutton",
    "uncanny",
    "uncapped",
    "uncaring",
    "uncertain",
    "unchain",
    "unchanged",
    "uncharted",
    "uncheck",
    "uncivil",
    "unclad",
    "unclaimed",
    "unclamped",
    "unclasp",
    "uncle",
    "unclip",
    "uncloak",
    "unclog",
    "unclothed",
    "uncoated",
    "uncoiled",
    "uncolored",
    "uncombed",
    "uncommon",
    "uncooked",
    "uncork",
    "uncorrupt",
    "uncounted",
    "uncouple",
    "uncouth",
    "uncover",
    "uncross",
    "uncrown",
    "uncrushed",
    "uncured",
    "uncurious",
    "uncurled",
    "uncut",
    "undamaged",
    "undated",
    "undaunted",
    "undead",
    "undecided",
    "undefined",
    "underage",
    "underarm",
    "undercoat",
    "undercook",
    "undercut",
    "underdog",
    "underdone",
    "underfed",
    "underfeed",
    "underfoot",
    "undergo",
    "undergrad",
    "underhand",
    "underline",
    "underling",
    "undermine",
    "undermost",
    "underpaid",
    "underpass",
    "underpay",
    "underrate",
    "undertake",
    "undertone",
    "undertook",
    "undertow",
    "underuse",
    "underwear",
    "underwent",
    "underwire",
    "undesired",
    "undiluted",
    "undivided",
    "undocked",
    "undoing",
    "undone",
    "undrafted",
    "undress",
    "undrilled",
    "undusted",
    "undying",
    "unearned",
    "unearth",
    "unease",
    "uneasily",
    "uneasy",
    "uneatable",
    "uneaten",
    "unedited",
    "unelected",
    "unending",
    "unengaged",
    "unenvied",
    "unequal",
    "unethical",
    "uneven",
    "unexpired",
    "unexposed",
    "unfailing",
    "unfair",
    "unfasten",
    "unfazed",
    "unfeeling",
    "unfiled",
    "unfilled",
    "unfitted",
    "unfitting",
    "unfixable",
    "unfixed",
    "unflawed",
    "unfocused",
    "unfold",
    "unfounded",
    "unframed",
    "unfreeze",
    "unfrosted",
    "unfrozen",
    "unfunded",
    "unglazed",
    "ungloved",
    "unglue",
    "ungodly",
    "ungraded",
    "ungreased",
    "unguarded",
    "unguided",
    "unhappily",
    "unhappy",
    "unharmed",
    "unhealthy",
    "unheard",
    "unhearing",
    "unheated",
    "unhelpful",
    "unhidden",
    "unhinge",
    "unhitched",
    "unholy",
    "unhook",
    "unicorn",
    "unicycle",
    "unified",
    "unifier",
    "uniformed",
    "uniformly",
    "unify",
    "unimpeded",
    "uninjured",
    "uninstall",
    "uninsured",
    "uninvited",
    "union",
    "uniquely",
    "unisexual",
    "unison",
    "unissued",
    "unit",
    "universal",
    "universe",
    "unjustly",
    "unkempt",
    "unkind",
    "unknotted",
    "unknowing",
    "unknown",
    "unlaced",
    "unlatch",
    "unlawful",
    "unleaded",
    "unlearned",
    "unleash",
    "unless",
    "unleveled",
    "unlighted",
    "unlikable",
    "unlimited",
    "unlined",
    "unlinked",
    "unlisted",
    "unlit",
    "unlivable",
    "unloaded",
    "unloader",
    "unlocked",
    "unlocking",
    "unlovable",
    "unloved",
    "unlovely",
    "unloving",
    "unluckily",
    "unlucky",
    "unmade",
    "unmanaged",
    "unmanned",
    "unmapped",
    "unmarked",
    "unmasked",
    "unmasking",
    "unmatched",
    "unmindful",
    "unmixable",
    "unmixed",
    "unmolded",
    "unmoral",
    "unmovable",
    "unmoved",
    "unmoving",
    "unnamable",
    "unnamed",
    "unnatural",
    "unneeded",
    "unnerve",
    "unnerving",
    "unnoticed",
    "unopened",
    "unopposed",
    "unpack",
    "unpadded",
    "unpaid",
    "unpainted",
    "unpaired",
    "unpaved",
    "unpeeled",
    "unpicked",
    "unpiloted",
    "unpinned",
    "unplanned",
    "unplanted",
    "unpleased",
    "unpledged",
    "unplowed",
    "unplug",
    "unpopular",
    "unproven",
    "unquote",
    "unranked",
    "unrated",
    "unraveled",
    "unreached",
    "unread",
    "unreal",
    "unreeling",
    "unrefined",
    "unrelated",
    "unrented",
    "unrest",
    "unretired",
    "unrevised",
    "unrigged",
    "unripe",
    "unrivaled",
    "unroasted",
    "unrobed",
    "unroll",
    "unruffled",
    "unruly",
    "unrushed",
    "unsaddle",
    "unsafe",
    "unsaid",
    "unsalted",
    "unsaved",
    "unsavory",
    "unscathed",
    "unscented",
    "unscrew",
    "unsealed",
    "unseated",
    "unsecured",
    "unseeing",
    "unseemly",
    "unseen",
    "unselect",
    "unselfish",
    "unsent",
    "unsettled",
    "unshackle",
    "unshaken",
    "unshaved",
    "unshaven",
    "unsheathe",
    "unshipped",
    "unsightly",
    "unsigned",
    "unskilled",
    "unsliced",
    "unsmooth",
    "unsnap",
    "unsocial",
    "unsoiled",
    "unsold",
    "unsolved",
    "unsorted",
    "unspoiled",
    "unspoken",
    "unstable",
    "unstaffed",
    "unstamped",
    "unsteady",
    "unsterile",
    "unstirred",
    "unstitch",
    "unstopped",
    "unstuck",
    "unstuffed",
    "unstylish",
    "unsubtle",
    "unsubtly",
    "unsuited",
    "unsure",
    "unsworn",
    "untagged",
    "untainted",
    "untaken",
    "untamed",
    "untangled",
    "untapped",
    "untaxed",
    "unthawed",
    "unthread",
    "untidy",
    "untie",
    "until",
    "untimed",
    "untimely",
    "untitled",
    "untoasted",
    "untold",
    "untouched",
    "untracked",
    "untrained",
    "untreated",
    "untried",
    "untrimmed",
    "untrue",
    "untruth",
    "unturned",
    "untwist",
    "untying",
    "unusable",
    "unused",
    "unusual",
    "unvalued",
    "unvaried",
    "unvarying",
    "unveiled",
    "unveiling",
    "unvented",
    "unviable",
    "unvisited",
    "unvocal",
    "unwanted",
    "unwarlike",
    "unwary",
    "unwashed",
    "unwatched",
    "unweave",
    "unwed",
    "unwelcome",
    "unwell",
    "unwieldy",
    "unwilling",
    "unwind",
    "unwired",
    "unwitting",
    "unwomanly",
    "unworldly",
    "unworn",
    "unworried",
    "unworthy",
    "unwound",
    "unwoven",
    "unwrapped",
    "unwritten",
    "unzip",
    "upbeat",
    "upchuck",
    "upcoming",
    "upcountry",
    "update",
    "upfront",
    "upgrade",
    "upheaval",
    "upheld",
    "uphill",
    "uphold",
    "uplifted",
    "uplifting",
    "upload",
    "upon",
    "upper",
    "upright",
    "uprising",
    "upriver",
    "uproar",
    "uproot",
    "upscale",
    "upside",
    "upstage",
    "upstairs",
    "upstart",
    "upstate",
    "upstream",
    "upstroke",
    "upswing",
    "uptake",
    "uptight",
    "uptown",
    "upturned",
    "upward",
    "upwind",
    "uranium",
    "urban",
    "urchin",
    "urethane",
    "urgency",
    "urgent",
    "urging",
    "urologist",
    "urology",
    "usable",
    "usage",
    "useable",
    "used",
    "uselessly",
    "user",
    "usher",
    "usual",
    "utensil",
    "utility",
    "utilize",
    "utmost",
    "utopia",
    "utter",
    "vacancy",
    "vacant",
    "vacate",
    "vacation",
    "vagabond",
    "vagrancy",
    "vagrantly",
    "vaguely",
    "vagueness",
    "valiant",
    "valid",
    "valium",
    "valley",
    "valuables",
    "value",
    "vanilla",
    "vanish",
    "vanity",
    "vanquish",
    "vantage",
    "vaporizer",
    "variable",
    "variably",
    "varied",
    "variety",
    "various",
    "varmint",
    "varnish",
    "varsity",
    "varying",
    "vascular",
    "vaseline",
    "vastly",
    "vastness",
    "veal",
    "vegan",
    "veggie",
    "vehicular",
    "velcro",
    "velocity",
    "velvet",
    "vendetta",
    "vending",
    "vendor",
    "veneering",
    "vengeful",
    "venomous",
    "ventricle",
    "venture",
    "venue",
    "venus",
    "verbalize",
    "verbally",
    "verbose",
    "verdict",
    "verify",
    "verse",
    "version",
    "versus",
    "vertebrae",
    "vertical",
    "vertigo",
    "very",
    "vessel",
    "vest",
    "veteran",
    "veto",
    "vexingly",
    "viability",
    "viable",
    "vibes",
    "vice",
    "vicinity",
    "victory",
    "video",
    "viewable",
    "viewer",
    "viewing",
    "viewless",
    "viewpoint",
    "vigorous",
    "village",
    "villain",
    "vindicate",
    "vineyard",
    "vintage",
    "violate",
    "violation",
    "violator",
    "violet",
    "violin",
    "viper",
    "viral",
    "virtual",
    "virtuous",
    "virus",
    "visa",
    "viscosity",
    "viscous",
    "viselike",
    "visible",
    "visibly",
    "vision",
    "visiting",
    "visitor",
    "visor",
    "vista",
    "vitality",
    "vitalize",
    "vitally",
    "vitamins",
    "vivacious",
    "vividly",
    "vividness",
    "vixen",
    "vocalist",
    "vocalize",
    "vocally",
    "vocation",
    "voice",
    "voicing",
    "void",
    "volatile",
    "volley",
    "voltage",
    "volumes",
    "voter",
    "voting",
    "voucher",
    "vowed",
    "vowel",
    "voyage",
    "wackiness",
    "wad",
    "wafer",
    "waffle",
    "waged",
    "wager",
    "wages",
    "waggle",
    "wagon",
    "wake",
    "waking",
    "walk",
    "walmart",
    "walnut",
    "walrus",
    "waltz",
    "wand",
    "wannabe",
    "wanted",
    "wanting",
    "wasabi",
    "washable",
    "washbasin",
    "washboard",
    "washbowl",
    "washcloth",
    "washday",
    "washed",
    "washer",
    "washhouse",
    "washing",
    "washout",
    "washroom",
    "washstand",
    "washtub",
    "wasp",
    "wasting",
    "watch",
    "water",
    "waviness",
    "waving",
    "wavy",
    "whacking",
    "whacky",
    "wham",
    "wharf",
    "wheat",
    "whenever",
    "whiff",
    "whimsical",
    "whinny",
    "whiny",
    "whisking",
    "whoever",
    "whole",
    "whomever",
    "whoopee",
    "whooping",
    "whoops",
    "why",
    "wick",
    "widely",
    "widen",
    "widget",
    "widow",
    "width",
    "wieldable",
    "wielder",
    "wife",
    "wifi",
    "wikipedia",
    "wildcard",
    "wildcat",
    "wilder",
    "wildfire",
    "wildfowl",
    "wildland",
    "wildlife",
    "wildly",
    "wildness",
    "willed",
    "willfully",
    "willing",
    "willow",
    "willpower",
    "wilt",
    "wimp",
    "wince",
    "wincing",
    "wind",
    "wing",
    "winking",
    "winner",
    "winnings",
    "winter",
    "wipe",
    "wired",
    "wireless",
    "wiring",
    "wiry",
    "wisdom",
    "wise",
    "wish",
    "wisplike",
    "wispy",
    "wistful",
    "wizard",
    "wobble",
    "wobbling",
    "wobbly",
    "wok",
    "wolf",
    "wolverine",
    "womanhood",
    "womankind",
    "womanless",
    "womanlike",
    "womanly",
    "womb",
    "woof",
    "wooing",
    "wool",
    "woozy",
    "word",
    "work",
    "worried",
    "worrier",
    "worrisome",
    "worry",
    "worsening",
    "worshiper",
    "worst",
    "wound",
    "woven",
    "wow",
    "wrangle",
    "wrath",
    "wreath",
    "wreckage",
    "wrecker",
    "wrecking",
    "wrench",
    "wriggle",
    "wriggly",
    "wrinkle",
    "wrinkly",
    "wrist",
    "writing",
    "written",
    "wrongdoer",
    "wronged",
    "wrongful",
    "wrongly",
    "wrongness",
    "wrought",
    "xbox",
    "xerox",
    "yahoo",
    "yam",
    "yanking",
    "yapping",
    "yard",
    "yarn",
    "yeah",
    "yearbook",
    "yearling",
    "yearly",
    "yearning",
    "yeast",
    "yelling",
    "yelp",
    "yen",
    "yesterday",
    "yiddish",
    "yield",
    "yin",
    "yippee",
    "yo-yo",
    "yodel",
    "yoga",
    "yogurt",
    "yonder",
    "yoyo",
    "yummy",
    "zap",
    "zealous",
    "zebra",
    "zen",
    "zeppelin",
    "zero",
    "zestfully",
    "zesty",
    "zigzagged",
    "zipfile",
    "zipping",
    "zippy",
    "zips",
    "zit",
    "zodiac",
    "zombie",
    "zone",
    "zoning",
    "zookeeper",
    "zoologist",
    "zoology",
    "zoom",
];

;// CONCATENATED MODULE: ../../libs/common/src/services/crypto.service.ts
var crypto_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var crypto_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var crypto_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








class CryptoService {
    constructor(cryptoFunctionService, encryptService, platformUtilService, logService, stateService) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.encryptService = encryptService;
        this.platformUtilService = platformUtilService;
        this.logService = logService;
        this.stateService = stateService;
    }
    setKey(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setCryptoMasterKey(key, { userId: userId });
            yield this.storeKey(key, userId);
        });
    }
    setKeyHash(keyHash) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setKeyHash(keyHash);
        });
    }
    setEncKey(encKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encKey == null) {
                return;
            }
            yield this.stateService.setDecryptedCryptoSymmetricKey(null);
            yield this.stateService.setEncryptedCryptoSymmetricKey(encKey);
        });
    }
    setEncPrivateKey(encPrivateKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encPrivateKey == null) {
                return;
            }
            yield this.stateService.setDecryptedPrivateKey(null);
            yield this.stateService.setEncryptedPrivateKey(encPrivateKey);
        });
    }
    setOrgKeys(orgs = [], providerOrgs = []) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const encOrgKeyData = {};
            orgs.forEach((org) => {
                encOrgKeyData[org.id] = {
                    type: "organization",
                    key: org.key,
                };
            });
            providerOrgs.forEach((org) => {
                encOrgKeyData[org.id] = {
                    type: "provider",
                    providerId: org.providerId,
                    key: org.key,
                };
            });
            yield this.stateService.setDecryptedOrganizationKeys(null);
            return yield this.stateService.setEncryptedOrganizationKeys(encOrgKeyData);
        });
    }
    setProviderKeys(providers) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const providerKeys = {};
            providers.forEach((provider) => {
                providerKeys[provider.id] = provider.key;
            });
            yield this.stateService.setDecryptedProviderKeys(null);
            return yield this.stateService.setEncryptedProviderKeys(providerKeys);
        });
    }
    getKey(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const inMemoryKey = yield this.stateService.getCryptoMasterKey({ userId: userId });
            if (inMemoryKey != null) {
                return inMemoryKey;
            }
            keySuffix || (keySuffix = KeySuffixOptions.Auto);
            const symmetricKey = yield this.getKeyFromStorage(keySuffix, userId);
            if (symmetricKey != null) {
                // TODO: Refactor here so get key doesn't also set key
                this.setKey(symmetricKey, userId);
            }
            return symmetricKey;
        });
    }
    getKeyFromStorage(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const key = yield this.retrieveKeyFromStorage(keySuffix, userId);
            if (key != null) {
                const symmetricKey = new SymmetricCryptoKey(utils_Utils.fromB64ToArray(key).buffer);
                if (!(yield this.validateKey(symmetricKey))) {
                    this.logService.warning("Wrong key, throwing away stored key");
                    yield this.clearSecretKeyStore(userId);
                    return null;
                }
                return symmetricKey;
            }
            return null;
        });
    }
    getKeyHash() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getKeyHash();
        });
    }
    compareAndUpdateKeyHash(masterPassword, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const storedKeyHash = yield this.getKeyHash();
            if (masterPassword != null && storedKeyHash != null) {
                const localKeyHash = yield this.hashPassword(masterPassword, key, HashPurpose.LocalAuthorization);
                if (localKeyHash != null && storedKeyHash === localKeyHash) {
                    return true;
                }
                // TODO: remove serverKeyHash check in 1-2 releases after everyone's keyHash has been updated
                const serverKeyHash = yield this.hashPassword(masterPassword, key, HashPurpose.ServerAuthorization);
                if (serverKeyHash != null && storedKeyHash === serverKeyHash) {
                    yield this.setKeyHash(localKeyHash);
                    return true;
                }
            }
            return false;
        });
    }
    getEncKey(key = null) {
        return this.getEncKeyHelper(key);
    }
    getPublicKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const inMemoryPublicKey = yield this.stateService.getPublicKey();
            if (inMemoryPublicKey != null) {
                return inMemoryPublicKey;
            }
            const privateKey = yield this.getPrivateKey();
            if (privateKey == null) {
                return null;
            }
            const publicKey = yield this.cryptoFunctionService.rsaExtractPublicKey(privateKey);
            yield this.stateService.setPublicKey(publicKey);
            return publicKey;
        });
    }
    getPrivateKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const decryptedPrivateKey = yield this.stateService.getDecryptedPrivateKey();
            if (decryptedPrivateKey != null) {
                return decryptedPrivateKey;
            }
            const encPrivateKey = yield this.stateService.getEncryptedPrivateKey();
            if (encPrivateKey == null) {
                return null;
            }
            const privateKey = yield this.decryptToBytes(new EncString(encPrivateKey), null);
            yield this.stateService.setDecryptedPrivateKey(privateKey);
            return privateKey;
        });
    }
    getFingerprint(userId, publicKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (publicKey == null) {
                publicKey = yield this.getPublicKey();
            }
            if (publicKey === null) {
                throw new Error("No public key available.");
            }
            const keyFingerprint = yield this.cryptoFunctionService.hash(publicKey, "sha256");
            const userFingerprint = yield this.cryptoFunctionService.hkdfExpand(keyFingerprint, userId, 32, "sha256");
            return this.hashPhrase(userFingerprint);
        });
    }
    getOrgKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const result = new Map();
            const decryptedOrganizationKeys = yield this.stateService.getDecryptedOrganizationKeys();
            if (decryptedOrganizationKeys != null && decryptedOrganizationKeys.size > 0) {
                return decryptedOrganizationKeys;
            }
            const encOrgKeyData = yield this.stateService.getEncryptedOrganizationKeys();
            if (encOrgKeyData == null) {
                return null;
            }
            let setKey = false;
            for (const orgId of Object.keys(encOrgKeyData)) {
                if (result.has(orgId)) {
                    continue;
                }
                const encOrgKey = BaseEncryptedOrganizationKey.fromData(encOrgKeyData[orgId]);
                const decOrgKey = yield encOrgKey.decrypt(this);
                result.set(orgId, decOrgKey);
                setKey = true;
            }
            if (setKey) {
                yield this.stateService.setDecryptedOrganizationKeys(result);
            }
            return result;
        });
    }
    getOrgKey(orgId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (orgId == null) {
                return null;
            }
            const orgKeys = yield this.getOrgKeys();
            if (orgKeys == null || !orgKeys.has(orgId)) {
                return null;
            }
            return orgKeys.get(orgId);
        });
    }
    getProviderKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const providerKeys = new Map();
            const decryptedProviderKeys = yield this.stateService.getDecryptedProviderKeys();
            if (decryptedProviderKeys != null && decryptedProviderKeys.size > 0) {
                return decryptedProviderKeys;
            }
            const encProviderKeys = yield this.stateService.getEncryptedProviderKeys();
            if (encProviderKeys == null) {
                return null;
            }
            let setKey = false;
            for (const orgId in encProviderKeys) {
                // eslint-disable-next-line
                if (!encProviderKeys.hasOwnProperty(orgId)) {
                    continue;
                }
                const decValue = yield this.rsaDecrypt(encProviderKeys[orgId]);
                providerKeys.set(orgId, new SymmetricCryptoKey(decValue));
                setKey = true;
            }
            if (setKey) {
                yield this.stateService.setDecryptedProviderKeys(providerKeys);
            }
            return providerKeys;
        });
    }
    getProviderKey(providerId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (providerId == null) {
                return null;
            }
            const providerKeys = yield this.getProviderKeys();
            if (providerKeys == null || !providerKeys.has(providerId)) {
                return null;
            }
            return providerKeys.get(providerId);
        });
    }
    hasKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return ((yield this.hasKeyInMemory()) ||
                (yield this.hasKeyStored(KeySuffixOptions.Auto)) ||
                (yield this.hasKeyStored(KeySuffixOptions.Biometric)));
        });
    }
    hasKeyInMemory(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.stateService.getCryptoMasterKey({ userId: userId })) != null;
        });
    }
    hasKeyStored(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            switch (keySuffix) {
                case KeySuffixOptions.Auto:
                    return (yield this.stateService.getCryptoMasterKeyAuto({ userId: userId })) != null;
                case KeySuffixOptions.Biometric:
                    return (yield this.stateService.hasCryptoMasterKeyBiometric({ userId: userId })) === true;
                default:
                    return false;
            }
        });
    }
    hasEncKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.stateService.getEncryptedCryptoSymmetricKey()) != null;
        });
    }
    clearKey(clearSecretStorage = true, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setCryptoMasterKey(null, { userId: userId });
            if (clearSecretStorage) {
                yield this.clearSecretKeyStore(userId);
            }
        });
    }
    clearStoredKey(keySuffix) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            keySuffix === KeySuffixOptions.Auto
                ? yield this.stateService.setCryptoMasterKeyAuto(null)
                : yield this.stateService.setCryptoMasterKeyBiometric(null);
        });
    }
    clearKeyHash(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setKeyHash(null, { userId: userId });
        });
    }
    clearEncKey(memoryOnly, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDecryptedCryptoSymmetricKey(null, { userId: userId });
            if (!memoryOnly) {
                yield this.stateService.setEncryptedCryptoSymmetricKey(null, { userId: userId });
            }
        });
    }
    clearKeyPair(memoryOnly, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const keysToClear = [
                this.stateService.setDecryptedPrivateKey(null, { userId: userId }),
                this.stateService.setPublicKey(null, { userId: userId }),
            ];
            if (!memoryOnly) {
                keysToClear.push(this.stateService.setEncryptedPrivateKey(null, { userId: userId }));
            }
            return Promise.all(keysToClear);
        });
    }
    clearOrgKeys(memoryOnly, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDecryptedOrganizationKeys(null, { userId: userId });
            if (!memoryOnly) {
                yield this.stateService.setEncryptedOrganizationKeys(null, { userId: userId });
            }
        });
    }
    clearProviderKeys(memoryOnly, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDecryptedProviderKeys(null, { userId: userId });
            if (!memoryOnly) {
                yield this.stateService.setEncryptedProviderKeys(null, { userId: userId });
            }
        });
    }
    clearPinProtectedKey(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setEncryptedPinProtected(null, { userId: userId });
        });
    }
    clearKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearKey(true, userId);
            yield this.clearKeyHash(userId);
            yield this.clearOrgKeys(false, userId);
            yield this.clearProviderKeys(false, userId);
            yield this.clearEncKey(false, userId);
            yield this.clearKeyPair(false, userId);
            yield this.clearPinProtectedKey(userId);
        });
    }
    toggleKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const key = yield this.getKey();
            yield this.setKey(key);
        });
    }
    makeKey(password, salt, kdf, kdfConfig) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let key = null;
            if (kdf == null || kdf === KdfType.PBKDF2_SHA256) {
                if (kdfConfig.iterations == null) {
                    kdfConfig.iterations = 5000;
                }
                else if (kdfConfig.iterations < 5000) {
                    throw new Error("PBKDF2 iteration minimum is 5000.");
                }
                key = yield this.cryptoFunctionService.pbkdf2(password, salt, "sha256", kdfConfig.iterations);
            }
            else if (kdf == KdfType.Argon2id) {
                if (kdfConfig.iterations == null) {
                    kdfConfig.iterations = DEFAULT_ARGON2_ITERATIONS;
                }
                else if (kdfConfig.iterations < 2) {
                    throw new Error("Argon2 iteration minimum is 2.");
                }
                if (kdfConfig.memory == null) {
                    kdfConfig.memory = DEFAULT_ARGON2_MEMORY;
                }
                else if (kdfConfig.memory < 16) {
                    throw new Error("Argon2 memory minimum is 16 MB");
                }
                else if (kdfConfig.memory > 1024) {
                    throw new Error("Argon2 memory maximum is 1024 MB");
                }
                if (kdfConfig.parallelism == null) {
                    kdfConfig.parallelism = DEFAULT_ARGON2_PARALLELISM;
                }
                else if (kdfConfig.parallelism < 1) {
                    throw new Error("Argon2 parallelism minimum is 1.");
                }
                const saltHash = yield this.cryptoFunctionService.hash(salt, "sha256");
                key = yield this.cryptoFunctionService.argon2(password, saltHash, kdfConfig.iterations, kdfConfig.memory * 1024, // convert to KiB from MiB
                kdfConfig.parallelism);
            }
            else {
                throw new Error("Unknown Kdf.");
            }
            return new SymmetricCryptoKey(key);
        });
    }
    makeKeyFromPin(pin, salt, kdf, kdfConfig, protectedKeyCs = null) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (protectedKeyCs == null) {
                const pinProtectedKey = yield this.stateService.getEncryptedPinProtected();
                if (pinProtectedKey == null) {
                    throw new Error("No PIN protected key found.");
                }
                protectedKeyCs = new EncString(pinProtectedKey);
            }
            const pinKey = yield this.makePinKey(pin, salt, kdf, kdfConfig);
            const decKey = yield this.decryptToBytes(protectedKeyCs, pinKey);
            return new SymmetricCryptoKey(decKey);
        });
    }
    makeShareKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const shareKey = yield this.cryptoFunctionService.randomBytes(64);
            const publicKey = yield this.getPublicKey();
            const encShareKey = yield this.rsaEncrypt(shareKey, publicKey);
            return [encShareKey, new SymmetricCryptoKey(shareKey)];
        });
    }
    makeKeyPair(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const keyPair = yield this.cryptoFunctionService.rsaGenerateKeyPair(2048);
            const publicB64 = utils_Utils.fromBufferToB64(keyPair[0]);
            const privateEnc = yield this.encrypt(keyPair[1], key);
            return [publicB64, privateEnc];
        });
    }
    makePinKey(pin, salt, kdf, kdfConfig) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const pinKey = yield this.makeKey(pin, salt, kdf, kdfConfig);
            return yield this.stretchKey(pinKey);
        });
    }
    makeSendKey(keyMaterial) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const sendKey = yield this.cryptoFunctionService.hkdf(keyMaterial, "bitwarden-send", "send", 64, "sha256");
            return new SymmetricCryptoKey(sendKey);
        });
    }
    hashPassword(password, key, hashPurpose) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                key = yield this.getKey();
            }
            if (password == null || key == null) {
                throw new Error("Invalid parameters.");
            }
            const iterations = hashPurpose === HashPurpose.LocalAuthorization ? 2 : 1;
            const hash = yield this.cryptoFunctionService.pbkdf2(key.key, password, "sha256", iterations);
            return utils_Utils.fromBufferToB64(hash);
        });
    }
    makeEncKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const theKey = yield this.getKeyForUserEncryption(key);
            const encKey = yield this.cryptoFunctionService.randomBytes(64);
            return this.buildEncKey(theKey, encKey);
        });
    }
    remakeEncKey(key, encKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encKey == null) {
                encKey = yield this.getEncKey();
            }
            return this.buildEncKey(key, encKey.key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.encrypt
     */
    encrypt(plainValue, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key = yield this.getKeyForUserEncryption(key);
            return yield this.encryptService.encrypt(plainValue, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.encryptToBytes
     */
    encryptToBytes(plainValue, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key = yield this.getKeyForUserEncryption(key);
            return this.encryptService.encryptToBytes(plainValue, key);
        });
    }
    rsaEncrypt(data, publicKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (publicKey == null) {
                publicKey = yield this.getPublicKey();
            }
            if (publicKey == null) {
                throw new Error("Public key unavailable.");
            }
            const encBytes = yield this.cryptoFunctionService.rsaEncrypt(data, publicKey, "sha1");
            return new EncString(EncryptionType.Rsa2048_OaepSha1_B64, utils_Utils.fromBufferToB64(encBytes));
        });
    }
    rsaDecrypt(encValue, privateKeyValue) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const headerPieces = encValue.split(".");
            let encType = null;
            let encPieces;
            if (headerPieces.length === 1) {
                encType = EncryptionType.Rsa2048_OaepSha256_B64;
                encPieces = [headerPieces[0]];
            }
            else if (headerPieces.length === 2) {
                try {
                    encType = parseInt(headerPieces[0], null);
                    encPieces = headerPieces[1].split("|");
                }
                catch (e) {
                    this.logService.error(e);
                }
            }
            switch (encType) {
                case EncryptionType.Rsa2048_OaepSha256_B64:
                case EncryptionType.Rsa2048_OaepSha1_B64:
                case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64: // HmacSha256 types are deprecated
                case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                    break;
                default:
                    throw new Error("encType unavailable.");
            }
            if (encPieces == null || encPieces.length <= 0) {
                throw new Error("encPieces unavailable.");
            }
            const data = utils_Utils.fromB64ToArray(encPieces[0]).buffer;
            const privateKey = privateKeyValue !== null && privateKeyValue !== void 0 ? privateKeyValue : (yield this.getPrivateKey());
            if (privateKey == null) {
                throw new Error("No private key.");
            }
            let alg = "sha1";
            switch (encType) {
                case EncryptionType.Rsa2048_OaepSha256_B64:
                case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64:
                    alg = "sha256";
                    break;
                case EncryptionType.Rsa2048_OaepSha1_B64:
                case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                    break;
                default:
                    throw new Error("encType unavailable.");
            }
            return this.cryptoFunctionService.rsaDecrypt(data, privateKey, alg);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToBytes
     */
    decryptToBytes(encString, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const keyForEnc = yield this.getKeyForUserEncryption(key);
            return this.encryptService.decryptToBytes(encString, keyForEnc);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToUtf8
     */
    decryptToUtf8(encString, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key = yield this.getKeyForUserEncryption(key);
            return yield this.encryptService.decryptToUtf8(encString, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToBytes
     */
    decryptFromBytes(encBuffer, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encBuffer == null) {
                throw new Error("No buffer provided for decryption.");
            }
            key = yield this.getKeyForUserEncryption(key);
            return this.encryptService.decryptToBytes(encBuffer, key);
        });
    }
    // EFForg/OpenWireless
    // ref https://github.com/EFForg/OpenWireless/blob/master/app/js/diceware.js
    randomNumber(min, max) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let rval = 0;
            const range = max - min + 1;
            const bitsNeeded = Math.ceil(Math.log2(range));
            if (bitsNeeded > 53) {
                throw new Error("We cannot generate numbers larger than 53 bits.");
            }
            const bytesNeeded = Math.ceil(bitsNeeded / 8);
            const mask = Math.pow(2, bitsNeeded) - 1;
            // 7776 -> (2^13 = 8192) -1 == 8191 or 0x00001111 11111111
            // Fill a byte array with N random numbers
            const byteArray = new Uint8Array(yield this.cryptoFunctionService.randomBytes(bytesNeeded));
            let p = (bytesNeeded - 1) * 8;
            for (let i = 0; i < bytesNeeded; i++) {
                rval += byteArray[i] * Math.pow(2, p);
                p -= 8;
            }
            // Use & to apply the mask and reduce the number of recursive lookups
            rval = rval & mask;
            if (rval >= range) {
                // Integer out of acceptable range
                return this.randomNumber(min, max);
            }
            // Return an integer that falls within the range
            return min + rval;
        });
    }
    validateKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            try {
                const encPrivateKey = yield this.stateService.getEncryptedPrivateKey();
                const encKey = yield this.getEncKeyHelper(key);
                if (encPrivateKey == null || encKey == null) {
                    return false;
                }
                const privateKey = yield this.decryptToBytes(new EncString(encPrivateKey), encKey);
                yield this.cryptoFunctionService.rsaExtractPublicKey(privateKey);
            }
            catch (e) {
                return false;
            }
            return true;
        });
    }
    // ---HELPERS---
    storeKey(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const storeAuto = yield this.shouldStoreKey(KeySuffixOptions.Auto, userId);
            if (storeAuto) {
                yield this.storeAutoKey(key, userId);
            }
            else {
                yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            }
        });
    }
    storeAutoKey(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setCryptoMasterKeyAuto(key.keyB64, { userId: userId });
        });
    }
    shouldStoreKey(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let shouldStoreKey = false;
            if (keySuffix === KeySuffixOptions.Auto) {
                const vaultTimeout = yield this.stateService.getVaultTimeout({ userId: userId });
                shouldStoreKey = vaultTimeout == null;
            }
            else if (keySuffix === KeySuffixOptions.Biometric) {
                const biometricUnlock = yield this.stateService.getBiometricUnlock({ userId: userId });
                shouldStoreKey = biometricUnlock && this.platformUtilService.supportsSecureStorage();
            }
            return shouldStoreKey;
        });
    }
    retrieveKeyFromStorage(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return keySuffix === KeySuffixOptions.Auto
                ? yield this.stateService.getCryptoMasterKeyAuto({ userId: userId })
                : yield this.stateService.getCryptoMasterKeyBiometric({ userId: userId });
        });
    }
    getKeyForUserEncryption(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (key != null) {
                return key;
            }
            const encKey = yield this.getEncKey();
            if (encKey != null) {
                return encKey;
            }
            // Legacy support: encryption used to be done with the user key (derived from master password).
            // Users who have not migrated will have a null encKey and must use the user key instead.
            return yield this.getKey();
        });
    }
    stretchKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const newKey = new Uint8Array(64);
            const encKey = yield this.cryptoFunctionService.hkdfExpand(key.key, "enc", 32, "sha256");
            const macKey = yield this.cryptoFunctionService.hkdfExpand(key.key, "mac", 32, "sha256");
            newKey.set(new Uint8Array(encKey));
            newKey.set(new Uint8Array(macKey), 32);
            return new SymmetricCryptoKey(newKey.buffer);
        });
    }
    hashPhrase(hash, minimumEntropy = 64) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const entropyPerWord = Math.log(EFFLongWordList.length) / Math.log(2);
            let numWords = Math.ceil(minimumEntropy / entropyPerWord);
            const hashArr = Array.from(new Uint8Array(hash));
            const entropyAvailable = hashArr.length * 4;
            if (numWords * entropyPerWord > entropyAvailable) {
                throw new Error("Output entropy of hash function is too small");
            }
            const phrase = [];
            let hashNumber = external_big_integer_namespaceObject.fromArray(hashArr, 256);
            while (numWords--) {
                const remainder = hashNumber.mod(EFFLongWordList.length);
                hashNumber = hashNumber.divide(EFFLongWordList.length);
                phrase.push(EFFLongWordList[remainder]);
            }
            return phrase;
        });
    }
    buildEncKey(key, encKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let encKeyEnc = null;
            if (key.key.byteLength === 32) {
                const newKey = yield this.stretchKey(key);
                encKeyEnc = yield this.encrypt(encKey, newKey);
            }
            else if (key.key.byteLength === 64) {
                encKeyEnc = yield this.encrypt(encKey, key);
            }
            else {
                throw new Error("Invalid key size.");
            }
            return [new SymmetricCryptoKey(encKey), encKeyEnc];
        });
    }
    clearSecretKeyStore(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            yield this.stateService.setCryptoMasterKeyBiometric(null, { userId: userId });
        });
    }
    getEncKeyHelper(key = null) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const inMemoryKey = yield this.stateService.getDecryptedCryptoSymmetricKey();
            if (inMemoryKey != null) {
                return inMemoryKey;
            }
            const encKey = yield this.stateService.getEncryptedCryptoSymmetricKey();
            if (encKey == null) {
                return null;
            }
            if (key == null) {
                key = yield this.getKey();
            }
            if (key == null) {
                return null;
            }
            let decEncKey;
            const encKeyCipher = new EncString(encKey);
            if (encKeyCipher.encryptionType === EncryptionType.AesCbc256_B64) {
                decEncKey = yield this.decryptToBytes(encKeyCipher, key);
            }
            else if (encKeyCipher.encryptionType === EncryptionType.AesCbc256_HmacSha256_B64) {
                const newKey = yield this.stretchKey(key);
                decEncKey = yield this.decryptToBytes(encKeyCipher, newKey);
            }
            else {
                throw new Error("Unsupported encKey type.");
            }
            if (decEncKey == null) {
                return null;
            }
            const symmetricCryptoKey = new SymmetricCryptoKey(decEncKey);
            yield this.stateService.setDecryptedCryptoSymmetricKey(symmetricCryptoKey);
            return symmetricCryptoKey;
        });
    }
}
crypto_service_decorate([
    sequentialize(() => "getEncKey"),
    crypto_service_metadata("design:type", Function),
    crypto_service_metadata("design:paramtypes", [SymmetricCryptoKey]),
    crypto_service_metadata("design:returntype", Promise)
], CryptoService.prototype, "getEncKey", null);
crypto_service_decorate([
    sequentialize(() => "getOrgKeys"),
    crypto_service_metadata("design:type", Function),
    crypto_service_metadata("design:paramtypes", []),
    crypto_service_metadata("design:returntype", Promise)
], CryptoService.prototype, "getOrgKeys", null);
crypto_service_decorate([
    sequentialize(() => "getProviderKeys"),
    crypto_service_metadata("design:type", Function),
    crypto_service_metadata("design:paramtypes", []),
    crypto_service_metadata("design:returntype", Promise)
], CryptoService.prototype, "getProviderKeys", null);

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/enc-array-buffer.ts
var enc_array_buffer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const ENC_TYPE_LENGTH = 1;
const IV_LENGTH = 16;
const MAC_LENGTH = 32;
const MIN_DATA_LENGTH = 1;
class EncArrayBuffer {
    constructor(buffer) {
        this.buffer = buffer;
        this.encryptionType = null;
        this.dataBytes = null;
        this.ivBytes = null;
        this.macBytes = null;
        const encBytes = new Uint8Array(buffer);
        const encType = encBytes[0];
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH).buffer;
                this.macBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH).buffer;
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH).buffer;
                break;
            }
            case EncryptionType.AesCbc256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH).buffer;
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH).buffer;
                break;
            }
            default:
                this.throwDecryptionError();
        }
        this.encryptionType = encType;
    }
    throwDecryptionError() {
        throw new Error("Error parsing encrypted ArrayBuffer: data is corrupted or has an invalid format.");
    }
    static fromResponse(response) {
        return enc_array_buffer_awaiter(this, void 0, void 0, function* () {
            const buffer = yield response.arrayBuffer();
            if (buffer == null) {
                throw new Error("Cannot create EncArrayBuffer from Response - Response is empty");
            }
            return new EncArrayBuffer(buffer);
        });
    }
    static fromB64(b64) {
        const buffer = utils_Utils.fromB64ToArray(b64).buffer;
        return new EncArrayBuffer(buffer);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/encrypted-object.ts
class EncryptedObject {
}

;// CONCATENATED MODULE: ../../libs/common/src/services/cryptography/encrypt.service.implementation.ts
var encrypt_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class EncryptServiceImplementation {
    constructor(cryptoFunctionService, logService, logMacFailures) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.logService = logService;
        this.logMacFailures = logMacFailures;
    }
    encrypt(plainValue, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            if (plainValue == null) {
                return Promise.resolve(null);
            }
            let plainBuf;
            if (typeof plainValue === "string") {
                plainBuf = utils_Utils.fromUtf8ToArray(plainValue).buffer;
            }
            else {
                plainBuf = plainValue;
            }
            const encObj = yield this.aesEncrypt(plainBuf, key);
            const iv = utils_Utils.fromBufferToB64(encObj.iv);
            const data = utils_Utils.fromBufferToB64(encObj.data);
            const mac = encObj.mac != null ? utils_Utils.fromBufferToB64(encObj.mac) : null;
            return new EncString(encObj.key.encType, data, iv, mac);
        });
    }
    encryptToBytes(plainValue, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            const encValue = yield this.aesEncrypt(plainValue, key);
            let macLen = 0;
            if (encValue.mac != null) {
                macLen = encValue.mac.byteLength;
            }
            const encBytes = new Uint8Array(1 + encValue.iv.byteLength + macLen + encValue.data.byteLength);
            encBytes.set([encValue.key.encType]);
            encBytes.set(new Uint8Array(encValue.iv), 1);
            if (encValue.mac != null) {
                encBytes.set(new Uint8Array(encValue.mac), 1 + encValue.iv.byteLength);
            }
            encBytes.set(new Uint8Array(encValue.data), 1 + encValue.iv.byteLength + macLen);
            return new EncArrayBuffer(encBytes.buffer);
        });
    }
    decryptToUtf8(encString, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided for decryption.");
            }
            key = this.resolveLegacyKey(key, encString);
            if (key.macKey != null && (encString === null || encString === void 0 ? void 0 : encString.mac) == null) {
                this.logService.error("mac required.");
                return null;
            }
            if (key.encType !== encString.encryptionType) {
                this.logService.error("encType unavailable.");
                return null;
            }
            const fastParams = this.cryptoFunctionService.aesDecryptFastParameters(encString.data, encString.iv, encString.mac, key);
            if (fastParams.macKey != null && fastParams.mac != null) {
                const computedMac = yield this.cryptoFunctionService.hmacFast(fastParams.macData, fastParams.macKey, "sha256");
                const macsEqual = yield this.cryptoFunctionService.compareFast(fastParams.mac, computedMac);
                if (!macsEqual) {
                    this.logMacFailed("mac failed.");
                    return null;
                }
            }
            return yield this.cryptoFunctionService.aesDecryptFast(fastParams);
        });
    }
    decryptToBytes(encThing, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            if (encThing == null) {
                throw new Error("Nothing provided for decryption.");
            }
            key = this.resolveLegacyKey(key, encThing);
            if (key.macKey != null && encThing.macBytes == null) {
                return null;
            }
            if (key.encType !== encThing.encryptionType) {
                return null;
            }
            if (key.macKey != null && encThing.macBytes != null) {
                const macData = new Uint8Array(encThing.ivBytes.byteLength + encThing.dataBytes.byteLength);
                macData.set(new Uint8Array(encThing.ivBytes), 0);
                macData.set(new Uint8Array(encThing.dataBytes), encThing.ivBytes.byteLength);
                const computedMac = yield this.cryptoFunctionService.hmac(macData.buffer, key.macKey, "sha256");
                if (computedMac === null) {
                    return null;
                }
                const macsMatch = yield this.cryptoFunctionService.compare(encThing.macBytes, computedMac);
                if (!macsMatch) {
                    this.logMacFailed("mac failed.");
                    return null;
                }
            }
            const result = yield this.cryptoFunctionService.aesDecrypt(encThing.dataBytes, encThing.ivBytes, key.encKey);
            return result !== null && result !== void 0 ? result : null;
        });
    }
    decryptItems(items, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (items == null || items.length < 1) {
                return [];
            }
            return yield Promise.all(items.map((item) => item.decrypt(key)));
        });
    }
    aesEncrypt(data, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            const obj = new EncryptedObject();
            obj.key = key;
            obj.iv = yield this.cryptoFunctionService.randomBytes(16);
            obj.data = yield this.cryptoFunctionService.aesEncrypt(data, obj.iv, obj.key.encKey);
            if (obj.key.macKey != null) {
                const macData = new Uint8Array(obj.iv.byteLength + obj.data.byteLength);
                macData.set(new Uint8Array(obj.iv), 0);
                macData.set(new Uint8Array(obj.data), obj.iv.byteLength);
                obj.mac = yield this.cryptoFunctionService.hmac(macData.buffer, obj.key.macKey, "sha256");
            }
            return obj;
        });
    }
    logMacFailed(msg) {
        if (this.logMacFailures) {
            this.logService.error(msg);
        }
    }
    /**
     * Transform into new key for the old encrypt-then-mac scheme if required, otherwise return the current key unchanged
     * @param encThing The encrypted object (e.g. encString or encArrayBuffer) that you want to decrypt
     */
    resolveLegacyKey(key, encThing) {
        if (encThing.encryptionType === EncryptionType.AesCbc128_HmacSha256_B64 &&
            key.encType === EncryptionType.AesCbc256_B64) {
            return new SymmetricCryptoKey(key.key, EncryptionType.AesCbc128_HmacSha256_B64);
        }
        return key;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/environment.service.ts
var environment_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class EnvironmentService {
    constructor(stateService) {
        this.stateService = stateService;
        this.urlsSubject = new external_rxjs_namespaceObject.Subject();
        this.urls = this.urlsSubject;
        this.scimUrl = null;
        this.stateService.activeAccount$
            .pipe((0,external_rxjs_namespaceObject.concatMap)(() => environment_service_awaiter(this, void 0, void 0, function* () {
            yield this.setUrlsFromStorage();
        })))
            .subscribe();
    }
    hasBaseUrl() {
        return this.baseUrl != null;
    }
    getNotificationsUrl() {
        if (this.notificationsUrl != null) {
            return this.notificationsUrl;
        }
        if (this.baseUrl != null) {
            return this.baseUrl + "/notifications";
        }
        return "https://notifications.bitwarden.com";
    }
    getWebVaultUrl() {
        if (this.webVaultUrl != null) {
            return this.webVaultUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl;
        }
        return "https://vault.bitwarden.com";
    }
    getSendUrl() {
        return this.getWebVaultUrl() === "https://vault.bitwarden.com"
            ? "https://send.bitwarden.com/#"
            : this.getWebVaultUrl() + "/#/send/";
    }
    getIconsUrl() {
        if (this.iconsUrl != null) {
            return this.iconsUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/icons";
        }
        return "https://icons.bitwarden.net";
    }
    getApiUrl() {
        if (this.apiUrl != null) {
            return this.apiUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/api";
        }
        return "https://api.bitwarden.com";
    }
    getIdentityUrl() {
        if (this.identityUrl != null) {
            return this.identityUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/identity";
        }
        return "https://identity.bitwarden.com";
    }
    getEventsUrl() {
        if (this.eventsUrl != null) {
            return this.eventsUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/events";
        }
        return "https://events.bitwarden.com";
    }
    getKeyConnectorUrl() {
        return this.keyConnectorUrl;
    }
    getScimUrl() {
        if (this.scimUrl != null) {
            return this.scimUrl + "/v2";
        }
        return this.getWebVaultUrl() === "https://vault.bitwarden.com"
            ? "https://scim.bitwarden.com/v2"
            : this.getWebVaultUrl() + "/scim/v2";
    }
    setUrlsFromStorage() {
        return environment_service_awaiter(this, void 0, void 0, function* () {
            const urls = yield this.stateService.getEnvironmentUrls();
            const envUrls = new EnvironmentUrls();
            this.baseUrl = envUrls.base = urls.base;
            this.webVaultUrl = urls.webVault;
            this.apiUrl = envUrls.api = urls.api;
            this.identityUrl = envUrls.identity = urls.identity;
            this.iconsUrl = urls.icons;
            this.notificationsUrl = urls.notifications;
            this.eventsUrl = envUrls.events = urls.events;
            this.keyConnectorUrl = urls.keyConnector;
            // scimUrl is not saved to storage
        });
    }
    setUrls(urls) {
        var _a;
        return environment_service_awaiter(this, void 0, void 0, function* () {
            urls.base = this.formatUrl(urls.base);
            urls.webVault = this.formatUrl(urls.webVault);
            urls.api = this.formatUrl(urls.api);
            urls.identity = this.formatUrl(urls.identity);
            urls.icons = this.formatUrl(urls.icons);
            urls.notifications = this.formatUrl(urls.notifications);
            urls.events = this.formatUrl(urls.events);
            urls.keyConnector = this.formatUrl(urls.keyConnector);
            // scimUrl cannot be cleared
            urls.scim = (_a = this.formatUrl(urls.scim)) !== null && _a !== void 0 ? _a : this.scimUrl;
            yield this.stateService.setEnvironmentUrls({
                base: urls.base,
                api: urls.api,
                identity: urls.identity,
                webVault: urls.webVault,
                icons: urls.icons,
                notifications: urls.notifications,
                events: urls.events,
                keyConnector: urls.keyConnector,
                // scimUrl is not saved to storage
            });
            this.baseUrl = urls.base;
            this.webVaultUrl = urls.webVault;
            this.apiUrl = urls.api;
            this.identityUrl = urls.identity;
            this.iconsUrl = urls.icons;
            this.notificationsUrl = urls.notifications;
            this.eventsUrl = urls.events;
            this.keyConnectorUrl = urls.keyConnector;
            this.scimUrl = urls.scim;
            this.urlsSubject.next(urls);
            return urls;
        });
    }
    getUrls() {
        return {
            base: this.baseUrl,
            webVault: this.webVaultUrl,
            api: this.apiUrl,
            identity: this.identityUrl,
            icons: this.iconsUrl,
            notifications: this.notificationsUrl,
            events: this.eventsUrl,
            keyConnector: this.keyConnectorUrl,
            scim: this.scimUrl,
        };
    }
    formatUrl(url) {
        if (url == null || url === "") {
            return null;
        }
        url = url.replace(/\/+$/g, "");
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "https://" + url;
        }
        return url.trim();
    }
    isCloud() {
        return ["https://api.bitwarden.com", "https://vault.bitwarden.com/api"].includes(this.getApiUrl());
    }
    isSelfHosted() {
        return ![
            "http://vault.bitwarden.com",
            "https://vault.bitwarden.com",
            "http://vault.qa.bitwarden.pw",
            "https://vault.qa.bitwarden.pw",
        ].includes(this.getWebVaultUrl());
    }
}

;// CONCATENATED MODULE: external "papaparse"
const external_papaparse_namespaceObject = require("papaparse");
;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/cipher-reprompt-type.ts
var CipherRepromptType;
(function (CipherRepromptType) {
    CipherRepromptType[CipherRepromptType["None"] = 0] = "None";
    CipherRepromptType[CipherRepromptType["Password"] = 1] = "Password";
})(CipherRepromptType || (CipherRepromptType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/cipher-type.ts
var CipherType;
(function (CipherType) {
    CipherType[CipherType["Login"] = 1] = "Login";
    CipherType[CipherType["SecureNote"] = 2] = "SecureNote";
    CipherType[CipherType["Card"] = 3] = "Card";
    CipherType[CipherType["Identity"] = 4] = "Identity";
})(CipherType || (CipherType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/services/cryptography/initializer-key.ts
var InitializerKey;
(function (InitializerKey) {
    InitializerKey[InitializerKey["Cipher"] = 0] = "Cipher";
    InitializerKey[InitializerKey["CipherView"] = 1] = "CipherView";
})(InitializerKey || (InitializerKey = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/attachment.data.ts
class AttachmentData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.url = response.url;
        this.fileName = response.fileName;
        this.key = response.key;
        this.size = response.size;
        this.sizeName = response.sizeName;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/card.data.ts
class CardData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.cardholderName = data.cardholderName;
        this.brand = data.brand;
        this.number = data.number;
        this.expMonth = data.expMonth;
        this.expYear = data.expYear;
        this.code = data.code;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/field.data.ts
class FieldData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.type = response.type;
        this.name = response.name;
        this.value = response.value;
        this.linkedId = response.linkedId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/identity.data.ts
class IdentityData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.title = data.title;
        this.firstName = data.firstName;
        this.middleName = data.middleName;
        this.lastName = data.lastName;
        this.address1 = data.address1;
        this.address2 = data.address2;
        this.address3 = data.address3;
        this.city = data.city;
        this.state = data.state;
        this.postalCode = data.postalCode;
        this.country = data.country;
        this.company = data.company;
        this.email = data.email;
        this.phone = data.phone;
        this.ssn = data.ssn;
        this.username = data.username;
        this.passportNumber = data.passportNumber;
        this.licenseNumber = data.licenseNumber;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/login-uri.data.ts
class LoginUriData {
    constructor(data) {
        this.match = null;
        if (data == null) {
            return;
        }
        this.uri = data.uri;
        this.match = data.match;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/login.data.ts

class LoginData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.username = data.username;
        this.password = data.password;
        this.passwordRevisionDate = data.passwordRevisionDate;
        this.totp = data.totp;
        this.autofillOnPageLoad = data.autofillOnPageLoad;
        if (data.uris) {
            this.uris = data.uris.map((u) => new LoginUriData(u));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/password-history.data.ts
class PasswordHistoryData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.password = response.password;
        this.lastUsedDate = response.lastUsedDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/secure-note.data.ts
class SecureNoteData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.type = data.type;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/cipher.data.ts








class CipherData {
    constructor(response, collectionIds) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.folderId = response.folderId;
        this.edit = response.edit;
        this.viewPassword = response.viewPassword;
        this.organizationUseTotp = response.organizationUseTotp;
        this.favorite = response.favorite;
        this.revisionDate = response.revisionDate;
        this.type = response.type;
        this.name = response.name;
        this.notes = response.notes;
        this.collectionIds = collectionIds != null ? collectionIds : response.collectionIds;
        this.creationDate = response.creationDate;
        this.deletedDate = response.deletedDate;
        this.reprompt = response.reprompt;
        switch (this.type) {
            case CipherType.Login:
                this.login = new LoginData(response.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteData(response.secureNote);
                break;
            case CipherType.Card:
                this.card = new CardData(response.card);
                break;
            case CipherType.Identity:
                this.identity = new IdentityData(response.identity);
                break;
            default:
                break;
        }
        if (response.fields != null) {
            this.fields = response.fields.map((f) => new FieldData(f));
        }
        if (response.attachments != null) {
            this.attachments = response.attachments.map((a) => new AttachmentData(a));
        }
        if (response.passwordHistory != null) {
            this.passwordHistory = response.passwordHistory.map((ph) => new PasswordHistoryData(ph));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/attachment.view.ts

class AttachmentView {
    constructor(a) {
        this.id = null;
        this.url = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        this.key = null;
        if (!a) {
            return;
        }
        this.id = a.id;
        this.url = a.url;
        this.size = a.size;
        this.sizeName = a.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(obj) {
        const key = obj.key == null ? null : SymmetricCryptoKey.fromJSON(obj.key);
        return Object.assign(new AttachmentView(), obj, { key: key });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/misc/linkedFieldOption.decorator.ts
class LinkedMetadata {
    constructor(propertyKey, _i18nKey) {
        this.propertyKey = propertyKey;
        this._i18nKey = _i18nKey;
    }
    get i18nKey() {
        var _a;
        return (_a = this._i18nKey) !== null && _a !== void 0 ? _a : this.propertyKey;
    }
}
/**
 * A decorator used to set metadata used by Linked custom fields. Apply it to a class property or getter to make it
 *    available as a Linked custom field option.
 * @param id - A unique value that is saved in the Field model. It is used to look up the decorated class property.
 * @param i18nKey - The i18n key used to describe the decorated class property in the UI. If it is null, then the name
 *    of the class property will be used as the i18n key.
 */
function linkedFieldOption(id, i18nKey) {
    return (prototype, propertyKey) => {
        if (prototype.linkedFieldOptions == null) {
            prototype.linkedFieldOptions = new Map();
        }
        prototype.linkedFieldOptions.set(id, new LinkedMetadata(propertyKey, i18nKey));
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/item.view.ts
class ItemView {
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/card.view.ts
var card_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var card_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



class CardView extends ItemView {
    constructor() {
        super(...arguments);
        this.cardholderName = null;
        this.expMonth = null;
        this.expYear = null;
        this.code = null;
        this._brand = null;
        this._number = null;
        this._subTitle = null;
    }
    get maskedCode() {
        return this.code != null ? "•".repeat(this.code.length) : null;
    }
    get maskedNumber() {
        return this.number != null ? "•".repeat(this.number.length) : null;
    }
    get brand() {
        return this._brand;
    }
    set brand(value) {
        this._brand = value;
        this._subTitle = null;
    }
    get number() {
        return this._number;
    }
    set number(value) {
        this._number = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null) {
            this._subTitle = this.brand;
            if (this.number != null && this.number.length >= 4) {
                if (this._subTitle != null && this._subTitle !== "") {
                    this._subTitle += ", ";
                }
                else {
                    this._subTitle = "";
                }
                // Show last 5 on amex, last 4 for all others
                const count = this.number.length >= 5 && this.number.match(new RegExp("^3[47]")) != null ? 5 : 4;
                this._subTitle += "*" + this.number.substr(this.number.length - count);
            }
        }
        return this._subTitle;
    }
    get expiration() {
        if (!this.expMonth && !this.expYear) {
            return null;
        }
        let exp = this.expMonth != null ? ("0" + this.expMonth).slice(-2) : "__";
        exp += " / " + (this.expYear != null ? this.formatYear(this.expYear) : "____");
        return exp;
    }
    formatYear(year) {
        return year.length === 2 ? "20" + year : year;
    }
    static fromJSON(obj) {
        return Object.assign(new CardView(), obj);
    }
}
card_view_decorate([
    linkedFieldOption(CardLinkedId.CardholderName),
    card_view_metadata("design:type", String)
], CardView.prototype, "cardholderName", void 0);
card_view_decorate([
    linkedFieldOption(CardLinkedId.ExpMonth, "expirationMonth"),
    card_view_metadata("design:type", String)
], CardView.prototype, "expMonth", void 0);
card_view_decorate([
    linkedFieldOption(CardLinkedId.ExpYear, "expirationYear"),
    card_view_metadata("design:type", String)
], CardView.prototype, "expYear", void 0);
card_view_decorate([
    linkedFieldOption(CardLinkedId.Code, "securityCode"),
    card_view_metadata("design:type", String)
], CardView.prototype, "code", void 0);
card_view_decorate([
    linkedFieldOption(CardLinkedId.Brand),
    card_view_metadata("design:type", String),
    card_view_metadata("design:paramtypes", [String])
], CardView.prototype, "brand", null);
card_view_decorate([
    linkedFieldOption(CardLinkedId.Number),
    card_view_metadata("design:type", String),
    card_view_metadata("design:paramtypes", [String])
], CardView.prototype, "number", null);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/field.view.ts
class FieldView {
    constructor(f) {
        this.name = null;
        this.value = null;
        this.type = null;
        this.newField = false; // Marks if the field is new and hasn't been saved
        this.showValue = false;
        this.showCount = false;
        this.linkedId = null;
        if (!f) {
            return;
        }
        this.type = f.type;
        this.linkedId = f.linkedId;
    }
    get maskedValue() {
        return this.value != null ? "••••••••" : null;
    }
    static fromJSON(obj) {
        return Object.assign(new FieldView(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/identity.view.ts
var identity_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var identity_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




class IdentityView extends ItemView {
    constructor() {
        super();
        this.title = null;
        this.middleName = null;
        this.address1 = null;
        this.address2 = null;
        this.address3 = null;
        this.city = null;
        this.state = null;
        this.postalCode = null;
        this.country = null;
        this.company = null;
        this.email = null;
        this.phone = null;
        this.ssn = null;
        this.username = null;
        this.passportNumber = null;
        this.licenseNumber = null;
        this._firstName = null;
        this._lastName = null;
        this._subTitle = null;
    }
    get firstName() {
        return this._firstName;
    }
    set firstName(value) {
        this._firstName = value;
        this._subTitle = null;
    }
    get lastName() {
        return this._lastName;
    }
    set lastName(value) {
        this._lastName = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null && (this.firstName != null || this.lastName != null)) {
            this._subTitle = "";
            if (this.firstName != null) {
                this._subTitle = this.firstName;
            }
            if (this.lastName != null) {
                if (this._subTitle !== "") {
                    this._subTitle += " ";
                }
                this._subTitle += this.lastName;
            }
        }
        return this._subTitle;
    }
    get fullName() {
        if (this.title != null ||
            this.firstName != null ||
            this.middleName != null ||
            this.lastName != null) {
            let name = "";
            if (this.title != null) {
                name += this.title + " ";
            }
            if (this.firstName != null) {
                name += this.firstName + " ";
            }
            if (this.middleName != null) {
                name += this.middleName + " ";
            }
            if (this.lastName != null) {
                name += this.lastName;
            }
            return name.trim();
        }
        return null;
    }
    get fullAddress() {
        let address = this.address1;
        if (!utils_Utils.isNullOrWhitespace(this.address2)) {
            if (!utils_Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address2;
        }
        if (!utils_Utils.isNullOrWhitespace(this.address3)) {
            if (!utils_Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address3;
        }
        return address;
    }
    get fullAddressPart2() {
        if (this.city == null && this.state == null && this.postalCode == null) {
            return null;
        }
        const city = this.city || "-";
        const state = this.state;
        const postalCode = this.postalCode || "-";
        let addressPart2 = city;
        if (!utils_Utils.isNullOrWhitespace(state)) {
            addressPart2 += ", " + state;
        }
        addressPart2 += ", " + postalCode;
        return addressPart2;
    }
    static fromJSON(obj) {
        return Object.assign(new IdentityView(), obj);
    }
}
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Title),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "title", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.MiddleName),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "middleName", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address1),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address1", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address2),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address2", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address3),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address3", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.City, "cityTown"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "city", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.State, "stateProvince"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "state", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PostalCode, "zipPostalCode"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "postalCode", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Country),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "country", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Company),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "company", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Email),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "email", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Phone),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "phone", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Ssn),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "ssn", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Username),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "username", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PassportNumber),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "passportNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LicenseNumber),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "licenseNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FirstName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "firstName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LastName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "lastName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FullName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [])
], IdentityView.prototype, "fullName", null);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/login-uri.view.ts


const CanLaunchWhitelist = [
    "https://",
    "http://",
    "ssh://",
    "ftp://",
    "sftp://",
    "irc://",
    "vnc://",
    // https://docs.microsoft.com/en-us/windows-server/remote/remote-desktop-services/clients/remote-desktop-uri
    "rdp://",
    "ms-rd:",
    "chrome://",
    "iosapp://",
    "androidapp://",
];
class LoginUriView {
    constructor(u) {
        this.match = null;
        this._uri = null;
        this._domain = null;
        this._hostname = null;
        this._host = null;
        this._canLaunch = null;
        if (!u) {
            return;
        }
        this.match = u.match;
    }
    get uri() {
        return this._uri;
    }
    set uri(value) {
        this._uri = value;
        this._domain = null;
        this._canLaunch = null;
    }
    get domain() {
        if (this._domain == null && this.uri != null) {
            this._domain = utils_Utils.getDomain(this.uri);
            if (this._domain === "") {
                this._domain = null;
            }
        }
        return this._domain;
    }
    get hostname() {
        if (this.match === UriMatchType.RegularExpression) {
            return null;
        }
        if (this._hostname == null && this.uri != null) {
            this._hostname = utils_Utils.getHostname(this.uri);
            if (this._hostname === "") {
                this._hostname = null;
            }
        }
        return this._hostname;
    }
    get host() {
        if (this.match === UriMatchType.RegularExpression) {
            return null;
        }
        if (this._host == null && this.uri != null) {
            this._host = utils_Utils.getHost(this.uri);
            if (this._host === "") {
                this._host = null;
            }
        }
        return this._host;
    }
    get hostnameOrUri() {
        return this.hostname != null ? this.hostname : this.uri;
    }
    get hostOrUri() {
        return this.host != null ? this.host : this.uri;
    }
    get isWebsite() {
        return (this.uri != null &&
            (this.uri.indexOf("http://") === 0 ||
                this.uri.indexOf("https://") === 0 ||
                (this.uri.indexOf("://") < 0 && !utils_Utils.isNullOrWhitespace(utils_Utils.getDomain(this.uri)))));
    }
    get canLaunch() {
        if (this._canLaunch != null) {
            return this._canLaunch;
        }
        if (this.uri != null && this.match !== UriMatchType.RegularExpression) {
            const uri = this.launchUri;
            for (let i = 0; i < CanLaunchWhitelist.length; i++) {
                if (uri.indexOf(CanLaunchWhitelist[i]) === 0) {
                    this._canLaunch = true;
                    return this._canLaunch;
                }
            }
        }
        this._canLaunch = false;
        return this._canLaunch;
    }
    get launchUri() {
        return this.uri.indexOf("://") < 0 && !utils_Utils.isNullOrWhitespace(utils_Utils.getDomain(this.uri))
            ? "http://" + this.uri
            : this.uri;
    }
    static fromJSON(obj) {
        return Object.assign(new LoginUriView(), obj);
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        var _a;
        if (!this.uri || !targetUri) {
            return false;
        }
        let matchType = (_a = this.match) !== null && _a !== void 0 ? _a : defaultUriMatch;
        matchType !== null && matchType !== void 0 ? matchType : (matchType = UriMatchType.Domain);
        const targetDomain = utils_Utils.getDomain(targetUri);
        const matchDomains = equivalentDomains.add(targetDomain);
        switch (matchType) {
            case UriMatchType.Domain:
                return this.matchesDomain(targetUri, matchDomains);
            case UriMatchType.Host: {
                const urlHost = utils_Utils.getHost(targetUri);
                return urlHost != null && urlHost === utils_Utils.getHost(this.uri);
            }
            case UriMatchType.Exact:
                return targetUri === this.uri;
            case UriMatchType.StartsWith:
                return targetUri.startsWith(this.uri);
            case UriMatchType.RegularExpression:
                try {
                    const regex = new RegExp(this.uri, "i");
                    return regex.test(targetUri);
                }
                catch (e) {
                    // Invalid regex
                    return false;
                }
            case UriMatchType.Never:
                return false;
            default:
                break;
        }
        return false;
    }
    matchesDomain(targetUri, matchDomains) {
        if (targetUri == null || this.domain == null || !matchDomains.has(this.domain)) {
            return false;
        }
        if (utils_Utils.DomainMatchBlacklist.has(this.domain)) {
            const domainUrlHost = utils_Utils.getHost(targetUri);
            return !utils_Utils.DomainMatchBlacklist.get(this.domain).has(domainUrlHost);
        }
        return true;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/login.view.ts
var login_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var login_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





class LoginView extends ItemView {
    constructor(l) {
        super();
        this.username = null;
        this.password = null;
        this.passwordRevisionDate = null;
        this.totp = null;
        this.uris = null;
        this.autofillOnPageLoad = null;
        if (!l) {
            return;
        }
        this.passwordRevisionDate = l.passwordRevisionDate;
        this.autofillOnPageLoad = l.autofillOnPageLoad;
    }
    get uri() {
        return this.hasUris ? this.uris[0].uri : null;
    }
    get maskedPassword() {
        return this.password != null ? "••••••••" : null;
    }
    get subTitle() {
        return this.username;
    }
    get canLaunch() {
        return this.hasUris && this.uris.some((u) => u.canLaunch);
    }
    get hasTotp() {
        return !utils_Utils.isNullOrWhitespace(this.totp);
    }
    get launchUri() {
        if (this.hasUris) {
            const uri = this.uris.find((u) => u.canLaunch);
            if (uri != null) {
                return uri.launchUri;
            }
        }
        return null;
    }
    get hasUris() {
        return this.uris != null && this.uris.length > 0;
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        if (this.uris == null) {
            return false;
        }
        return this.uris.some((uri) => uri.matchesUri(targetUri, equivalentDomains, defaultUriMatch));
    }
    static fromJSON(obj) {
        var _a;
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = (_a = obj.uris) === null || _a === void 0 ? void 0 : _a.map((uri) => LoginUriView.fromJSON(uri));
        return Object.assign(new LoginView(), obj, {
            passwordRevisionDate: passwordRevisionDate,
            uris: uris,
        });
    }
}
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Username),
    login_view_metadata("design:type", String)
], LoginView.prototype, "username", void 0);
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Password),
    login_view_metadata("design:type", String)
], LoginView.prototype, "password", void 0);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/password-history.view.ts
class PasswordHistoryView {
    constructor(ph) {
        this.password = null;
        this.lastUsedDate = null;
        if (!ph) {
            return;
        }
        this.lastUsedDate = ph.lastUsedDate;
    }
    static fromJSON(obj) {
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new PasswordHistoryView(), obj, {
            lastUsedDate: lastUsedDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/secure-note.view.ts

class SecureNoteView extends ItemView {
    constructor(n) {
        super();
        this.type = null;
        if (!n) {
            return;
        }
        this.type = n.type;
    }
    get subTitle() {
        return null;
    }
    static fromJSON(obj) {
        return Object.assign(new SecureNoteView(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/cipher.view.ts










class CipherView {
    constructor(c) {
        var _a;
        this.initializerKey = InitializerKey.CipherView;
        this.id = null;
        this.organizationId = null;
        this.folderId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.favorite = false;
        this.organizationUseTotp = false;
        this.edit = false;
        this.viewPassword = true;
        this.login = new LoginView();
        this.identity = new IdentityView();
        this.card = new CardView();
        this.secureNote = new SecureNoteView();
        this.attachments = null;
        this.fields = null;
        this.passwordHistory = null;
        this.collectionIds = null;
        this.revisionDate = null;
        this.creationDate = null;
        this.deletedDate = null;
        this.reprompt = CipherRepromptType.None;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.folderId = c.folderId;
        this.favorite = c.favorite;
        this.organizationUseTotp = c.organizationUseTotp;
        this.edit = c.edit;
        this.viewPassword = c.viewPassword;
        this.type = c.type;
        this.localData = c.localData;
        this.collectionIds = c.collectionIds;
        this.revisionDate = c.revisionDate;
        this.creationDate = c.creationDate;
        this.deletedDate = c.deletedDate;
        // Old locally stored ciphers might have reprompt == null. If so set it to None.
        this.reprompt = (_a = c.reprompt) !== null && _a !== void 0 ? _a : CipherRepromptType.None;
    }
    get item() {
        switch (this.type) {
            case CipherType.Login:
                return this.login;
            case CipherType.SecureNote:
                return this.secureNote;
            case CipherType.Card:
                return this.card;
            case CipherType.Identity:
                return this.identity;
            default:
                break;
        }
        return null;
    }
    get subTitle() {
        return this.item.subTitle;
    }
    get hasPasswordHistory() {
        return this.passwordHistory && this.passwordHistory.length > 0;
    }
    get hasAttachments() {
        return this.attachments && this.attachments.length > 0;
    }
    get hasOldAttachments() {
        if (this.hasAttachments) {
            for (let i = 0; i < this.attachments.length; i++) {
                if (this.attachments[i].key == null) {
                    return true;
                }
            }
        }
        return false;
    }
    get hasFields() {
        return this.fields && this.fields.length > 0;
    }
    get passwordRevisionDisplayDate() {
        if (this.type !== CipherType.Login || this.login == null) {
            return null;
        }
        else if (this.login.password == null || this.login.password === "") {
            return null;
        }
        return this.login.passwordRevisionDate;
    }
    get isDeleted() {
        return this.deletedDate != null;
    }
    get linkedFieldOptions() {
        return this.item.linkedFieldOptions;
    }
    linkedFieldValue(id) {
        var _a;
        const linkedFieldOption = (_a = this.linkedFieldOptions) === null || _a === void 0 ? void 0 : _a.get(id);
        if (linkedFieldOption == null) {
            return null;
        }
        const item = this.item;
        return this.item[linkedFieldOption.propertyKey];
    }
    linkedFieldI18nKey(id) {
        var _a;
        return (_a = this.linkedFieldOptions.get(id)) === null || _a === void 0 ? void 0 : _a.i18nKey;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        const view = new CipherView();
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => AttachmentView.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => FieldView.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => PasswordHistoryView.fromJSON(ph));
        Object.assign(view, obj, {
            revisionDate: revisionDate,
            deletedDate: deletedDate,
            attachments: attachments,
            fields: fields,
            passwordHistory: passwordHistory,
        });
        switch (obj.type) {
            case CipherType.Card:
                view.card = CardView.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                view.identity = IdentityView.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                view.login = LoginView.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                view.secureNote = SecureNoteView.fromJSON(obj.secureNote);
                break;
            default:
                break;
        }
        return view;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/attachment.ts
var attachment_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class Attachment extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
    }
    decrypt(orgId, encKey) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new AttachmentView(this), {
                fileName: null,
            }, orgId, encKey);
            if (this.key != null) {
                view.key = yield this.decryptAttachmentKey(orgId, encKey);
            }
            return view;
        });
    }
    decryptAttachmentKey(orgId, encKey) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            try {
                if (encKey == null) {
                    encKey = yield this.getKeyForDecryption(orgId);
                }
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                const decValue = yield encryptService.decryptToBytes(this.key, encKey);
                return new SymmetricCryptoKey(decValue);
            }
            catch (e) {
                // TODO: error?
            }
        });
    }
    getKeyForDecryption(orgId) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            const cryptoService = utils_Utils.getContainerService().getCryptoService();
            return orgId != null
                ? yield cryptoService.getOrgKey(orgId)
                : yield cryptoService.getKeyForUserEncryption();
        });
    }
    toAttachmentData() {
        const a = new AttachmentData();
        a.size = this.size;
        this.buildDataModel(this, a, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
        return a;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const key = EncString.fromJSON(obj.key);
        const fileName = EncString.fromJSON(obj.fileName);
        return Object.assign(new Attachment(), obj, {
            key,
            fileName,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/card.ts




class Card extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new CardView(), {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        }, orgId, encKey);
    }
    toCardData() {
        const c = new CardData();
        this.buildDataModel(this, c, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        });
        return c;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const cardholderName = EncString.fromJSON(obj.cardholderName);
        const brand = EncString.fromJSON(obj.brand);
        const number = EncString.fromJSON(obj.number);
        const expMonth = EncString.fromJSON(obj.expMonth);
        const expYear = EncString.fromJSON(obj.expYear);
        const code = EncString.fromJSON(obj.code);
        return Object.assign(new Card(), obj, {
            cardholderName,
            brand,
            number,
            expMonth,
            expYear,
            code,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/field.ts




class Field extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
        this.linkedId = obj.linkedId;
        this.buildDomainModel(this, obj, {
            name: null,
            value: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new FieldView(this), {
            name: null,
            value: null,
        }, orgId, encKey);
    }
    toFieldData() {
        const f = new FieldData();
        this.buildDataModel(this, f, {
            name: null,
            value: null,
            type: null,
            linkedId: null,
        }, ["type", "linkedId"]);
        return f;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const name = EncString.fromJSON(obj.name);
        const value = EncString.fromJSON(obj.value);
        return Object.assign(new Field(), obj, {
            name,
            value,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/identity.ts




class Identity extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new IdentityView(), {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        }, orgId, encKey);
    }
    toIdentityData() {
        const i = new IdentityData();
        this.buildDataModel(this, i, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        });
        return i;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const title = EncString.fromJSON(obj.title);
        const firstName = EncString.fromJSON(obj.firstName);
        const middleName = EncString.fromJSON(obj.middleName);
        const lastName = EncString.fromJSON(obj.lastName);
        const address1 = EncString.fromJSON(obj.address1);
        const address2 = EncString.fromJSON(obj.address2);
        const address3 = EncString.fromJSON(obj.address3);
        const city = EncString.fromJSON(obj.city);
        const state = EncString.fromJSON(obj.state);
        const postalCode = EncString.fromJSON(obj.postalCode);
        const country = EncString.fromJSON(obj.country);
        const company = EncString.fromJSON(obj.company);
        const email = EncString.fromJSON(obj.email);
        const phone = EncString.fromJSON(obj.phone);
        const ssn = EncString.fromJSON(obj.ssn);
        const username = EncString.fromJSON(obj.username);
        const passportNumber = EncString.fromJSON(obj.passportNumber);
        const licenseNumber = EncString.fromJSON(obj.licenseNumber);
        return Object.assign(new Identity(), obj, {
            title,
            firstName,
            middleName,
            lastName,
            address1,
            address2,
            address3,
            city,
            state,
            postalCode,
            country,
            company,
            email,
            phone,
            ssn,
            username,
            passportNumber,
            licenseNumber,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/login-uri.ts




class LoginUri extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.match = obj.match;
        this.buildDomainModel(this, obj, {
            uri: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new LoginUriView(this), {
            uri: null,
        }, orgId, encKey);
    }
    toLoginUriData() {
        const u = new LoginUriData();
        this.buildDataModel(this, u, {
            uri: null,
            match: null,
        }, ["match"]);
        return u;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const uri = EncString.fromJSON(obj.uri);
        return Object.assign(new LoginUri(), obj, {
            uri,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/login.ts
var login_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class Login extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.passwordRevisionDate =
            obj.passwordRevisionDate != null ? new Date(obj.passwordRevisionDate) : null;
        this.autofillOnPageLoad = obj.autofillOnPageLoad;
        this.buildDomainModel(this, obj, {
            username: null,
            password: null,
            totp: null,
        }, []);
        if (obj.uris) {
            this.uris = [];
            obj.uris.forEach((u) => {
                this.uris.push(new LoginUri(u));
            });
        }
    }
    decrypt(orgId, encKey) {
        return login_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new LoginView(this), {
                username: null,
                password: null,
                totp: null,
            }, orgId, encKey);
            if (this.uris != null) {
                view.uris = [];
                for (let i = 0; i < this.uris.length; i++) {
                    const uri = yield this.uris[i].decrypt(orgId, encKey);
                    view.uris.push(uri);
                }
            }
            return view;
        });
    }
    toLoginData() {
        const l = new LoginData();
        l.passwordRevisionDate =
            this.passwordRevisionDate != null ? this.passwordRevisionDate.toISOString() : null;
        l.autofillOnPageLoad = this.autofillOnPageLoad;
        this.buildDataModel(this, l, {
            username: null,
            password: null,
            totp: null,
        });
        if (this.uris != null && this.uris.length > 0) {
            l.uris = [];
            this.uris.forEach((u) => {
                l.uris.push(u.toLoginUriData());
            });
        }
        return l;
    }
    static fromJSON(obj) {
        var _a;
        if (obj == null) {
            return null;
        }
        const username = EncString.fromJSON(obj.username);
        const password = EncString.fromJSON(obj.password);
        const totp = EncString.fromJSON(obj.totp);
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = (_a = obj.uris) === null || _a === void 0 ? void 0 : _a.map((uri) => LoginUri.fromJSON(uri));
        return Object.assign(new Login(), obj, {
            username,
            password,
            totp,
            passwordRevisionDate: passwordRevisionDate,
            uris: uris,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/password.ts




class Password extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            password: null,
        });
        this.lastUsedDate = new Date(obj.lastUsedDate);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new PasswordHistoryView(this), {
            password: null,
        }, orgId, encKey);
    }
    toPasswordHistoryData() {
        const ph = new PasswordHistoryData();
        ph.lastUsedDate = this.lastUsedDate.toISOString();
        this.buildDataModel(this, ph, {
            password: null,
        });
        return ph;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const password = EncString.fromJSON(obj.password);
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new Password(), obj, {
            password,
            lastUsedDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/secure-note.ts



class SecureNote extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
    }
    decrypt(orgId, encKey) {
        return Promise.resolve(new SecureNoteView(this));
    }
    toSecureNoteData() {
        const n = new SecureNoteData();
        n.type = this.type;
        return n;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SecureNote(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/cipher.ts
var cipher_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













class Cipher extends Domain {
    constructor(obj, localData = null) {
        super();
        this.initializerKey = InitializerKey.Cipher;
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            folderId: null,
            name: null,
            notes: null,
        }, ["id", "organizationId", "folderId"]);
        this.type = obj.type;
        this.favorite = obj.favorite;
        this.organizationUseTotp = obj.organizationUseTotp;
        this.edit = obj.edit;
        if (obj.viewPassword != null) {
            this.viewPassword = obj.viewPassword;
        }
        else {
            this.viewPassword = true; // Default for already synced Ciphers without viewPassword
        }
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
        this.collectionIds = obj.collectionIds;
        this.localData = localData;
        this.creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        this.deletedDate = obj.deletedDate != null ? new Date(obj.deletedDate) : null;
        this.reprompt = obj.reprompt;
        switch (this.type) {
            case CipherType.Login:
                this.login = new Login(obj.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNote(obj.secureNote);
                break;
            case CipherType.Card:
                this.card = new Card(obj.card);
                break;
            case CipherType.Identity:
                this.identity = new Identity(obj.identity);
                break;
            default:
                break;
        }
        if (obj.attachments != null) {
            this.attachments = obj.attachments.map((a) => new Attachment(a));
        }
        else {
            this.attachments = null;
        }
        if (obj.fields != null) {
            this.fields = obj.fields.map((f) => new Field(f));
        }
        else {
            this.fields = null;
        }
        if (obj.passwordHistory != null) {
            this.passwordHistory = obj.passwordHistory.map((ph) => new Password(ph));
        }
        else {
            this.passwordHistory = null;
        }
    }
    decrypt(encKey) {
        return cipher_awaiter(this, void 0, void 0, function* () {
            const model = new CipherView(this);
            yield this.decryptObj(model, {
                name: null,
                notes: null,
            }, this.organizationId, encKey);
            switch (this.type) {
                case CipherType.Login:
                    model.login = yield this.login.decrypt(this.organizationId, encKey);
                    break;
                case CipherType.SecureNote:
                    model.secureNote = yield this.secureNote.decrypt(this.organizationId, encKey);
                    break;
                case CipherType.Card:
                    model.card = yield this.card.decrypt(this.organizationId, encKey);
                    break;
                case CipherType.Identity:
                    model.identity = yield this.identity.decrypt(this.organizationId, encKey);
                    break;
                default:
                    break;
            }
            const orgId = this.organizationId;
            if (this.attachments != null && this.attachments.length > 0) {
                const attachments = [];
                yield this.attachments.reduce((promise, attachment) => {
                    return promise
                        .then(() => {
                        return attachment.decrypt(orgId, encKey);
                    })
                        .then((decAttachment) => {
                        attachments.push(decAttachment);
                    });
                }, Promise.resolve());
                model.attachments = attachments;
            }
            if (this.fields != null && this.fields.length > 0) {
                const fields = [];
                yield this.fields.reduce((promise, field) => {
                    return promise
                        .then(() => {
                        return field.decrypt(orgId, encKey);
                    })
                        .then((decField) => {
                        fields.push(decField);
                    });
                }, Promise.resolve());
                model.fields = fields;
            }
            if (this.passwordHistory != null && this.passwordHistory.length > 0) {
                const passwordHistory = [];
                yield this.passwordHistory.reduce((promise, ph) => {
                    return promise
                        .then(() => {
                        return ph.decrypt(orgId, encKey);
                    })
                        .then((decPh) => {
                        passwordHistory.push(decPh);
                    });
                }, Promise.resolve());
                model.passwordHistory = passwordHistory;
            }
            return model;
        });
    }
    toCipherData() {
        const c = new CipherData();
        c.id = this.id;
        c.organizationId = this.organizationId;
        c.folderId = this.folderId;
        c.edit = this.edit;
        c.viewPassword = this.viewPassword;
        c.organizationUseTotp = this.organizationUseTotp;
        c.favorite = this.favorite;
        c.revisionDate = this.revisionDate != null ? this.revisionDate.toISOString() : null;
        c.type = this.type;
        c.collectionIds = this.collectionIds;
        c.creationDate = this.creationDate != null ? this.creationDate.toISOString() : null;
        c.deletedDate = this.deletedDate != null ? this.deletedDate.toISOString() : null;
        c.reprompt = this.reprompt;
        this.buildDataModel(this, c, {
            name: null,
            notes: null,
        });
        switch (c.type) {
            case CipherType.Login:
                c.login = this.login.toLoginData();
                break;
            case CipherType.SecureNote:
                c.secureNote = this.secureNote.toSecureNoteData();
                break;
            case CipherType.Card:
                c.card = this.card.toCardData();
                break;
            case CipherType.Identity:
                c.identity = this.identity.toIdentityData();
                break;
            default:
                break;
        }
        if (this.fields != null) {
            c.fields = this.fields.map((f) => f.toFieldData());
        }
        if (this.attachments != null) {
            c.attachments = this.attachments.map((a) => a.toAttachmentData());
        }
        if (this.passwordHistory != null) {
            c.passwordHistory = this.passwordHistory.map((ph) => ph.toPasswordHistoryData());
        }
        return c;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const domain = new Cipher();
        const name = EncString.fromJSON(obj.name);
        const notes = EncString.fromJSON(obj.notes);
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => Attachment.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => Field.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => Password.fromJSON(ph));
        Object.assign(domain, obj, {
            name,
            notes,
            revisionDate,
            deletedDate,
            attachments,
            fields,
            passwordHistory,
        });
        switch (obj.type) {
            case CipherType.Card:
                domain.card = Card.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                domain.identity = Identity.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                domain.login = Login.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                domain.secureNote = SecureNote.fromJSON(obj.secureNote);
                break;
            default:
                break;
        }
        return domain;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/card.export.ts



class CardExport {
    static template() {
        const req = new CardExport();
        req.cardholderName = "John Doe";
        req.brand = "visa";
        req.number = "4242424242424242";
        req.expMonth = "04";
        req.expYear = "2023";
        req.code = "123";
        return req;
    }
    static toView(req, view = new CardView()) {
        view.cardholderName = req.cardholderName;
        view.brand = req.brand;
        view.number = req.number;
        view.expMonth = req.expMonth;
        view.expYear = req.expYear;
        view.code = req.code;
        return view;
    }
    static toDomain(req, domain = new Card()) {
        domain.cardholderName = req.cardholderName != null ? new EncString(req.cardholderName) : null;
        domain.brand = req.brand != null ? new EncString(req.brand) : null;
        domain.number = req.number != null ? new EncString(req.number) : null;
        domain.expMonth = req.expMonth != null ? new EncString(req.expMonth) : null;
        domain.expYear = req.expYear != null ? new EncString(req.expYear) : null;
        domain.code = req.code != null ? new EncString(req.code) : null;
        return domain;
    }
    constructor(o) {
        var _a, _b, _c, _d, _e, _f;
        if (o == null) {
            return;
        }
        if (o instanceof CardView) {
            this.cardholderName = o.cardholderName;
            this.brand = o.brand;
            this.number = o.number;
            this.expMonth = o.expMonth;
            this.expYear = o.expYear;
            this.code = o.code;
        }
        else {
            this.cardholderName = (_a = o.cardholderName) === null || _a === void 0 ? void 0 : _a.encryptedString;
            this.brand = (_b = o.brand) === null || _b === void 0 ? void 0 : _b.encryptedString;
            this.number = (_c = o.number) === null || _c === void 0 ? void 0 : _c.encryptedString;
            this.expMonth = (_d = o.expMonth) === null || _d === void 0 ? void 0 : _d.encryptedString;
            this.expYear = (_e = o.expYear) === null || _e === void 0 ? void 0 : _e.encryptedString;
            this.code = (_f = o.code) === null || _f === void 0 ? void 0 : _f.encryptedString;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/field.export.ts




class FieldExport {
    static template() {
        const req = new FieldExport();
        req.name = "Field name";
        req.value = "Some value";
        req.type = FieldType.Text;
        return req;
    }
    static toView(req, view = new FieldView()) {
        view.type = req.type;
        view.value = req.value;
        view.name = req.name;
        view.linkedId = req.linkedId;
        return view;
    }
    static toDomain(req, domain = new Field()) {
        domain.type = req.type;
        domain.value = req.value != null ? new EncString(req.value) : null;
        domain.name = req.name != null ? new EncString(req.name) : null;
        domain.linkedId = req.linkedId;
        return domain;
    }
    constructor(o) {
        var _a, _b;
        if (o == null) {
            return;
        }
        if (o instanceof FieldView) {
            this.name = o.name;
            this.value = o.value;
        }
        else {
            this.name = (_a = o.name) === null || _a === void 0 ? void 0 : _a.encryptedString;
            this.value = (_b = o.value) === null || _b === void 0 ? void 0 : _b.encryptedString;
        }
        this.type = o.type;
        this.linkedId = o.linkedId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/identity.export.ts



class IdentityExport {
    static template() {
        const req = new IdentityExport();
        req.title = "Mr";
        req.firstName = "John";
        req.middleName = "William";
        req.lastName = "Doe";
        req.address1 = "123 Any St";
        req.address2 = "Apt #123";
        req.address3 = null;
        req.city = "New York";
        req.state = "NY";
        req.postalCode = "10001";
        req.country = "US";
        req.company = "Acme Inc.";
        req.email = "john@company.com";
        req.phone = "5555551234";
        req.ssn = "000-123-4567";
        req.username = "jdoe";
        req.passportNumber = "US-123456789";
        req.licenseNumber = "D123-12-123-12333";
        return req;
    }
    static toView(req, view = new IdentityView()) {
        view.title = req.title;
        view.firstName = req.firstName;
        view.middleName = req.middleName;
        view.lastName = req.lastName;
        view.address1 = req.address1;
        view.address2 = req.address2;
        view.address3 = req.address3;
        view.city = req.city;
        view.state = req.state;
        view.postalCode = req.postalCode;
        view.country = req.country;
        view.company = req.company;
        view.email = req.email;
        view.phone = req.phone;
        view.ssn = req.ssn;
        view.username = req.username;
        view.passportNumber = req.passportNumber;
        view.licenseNumber = req.licenseNumber;
        return view;
    }
    static toDomain(req, domain = new Identity()) {
        domain.title = req.title != null ? new EncString(req.title) : null;
        domain.firstName = req.firstName != null ? new EncString(req.firstName) : null;
        domain.middleName = req.middleName != null ? new EncString(req.middleName) : null;
        domain.lastName = req.lastName != null ? new EncString(req.lastName) : null;
        domain.address1 = req.address1 != null ? new EncString(req.address1) : null;
        domain.address2 = req.address2 != null ? new EncString(req.address2) : null;
        domain.address3 = req.address3 != null ? new EncString(req.address3) : null;
        domain.city = req.city != null ? new EncString(req.city) : null;
        domain.state = req.state != null ? new EncString(req.state) : null;
        domain.postalCode = req.postalCode != null ? new EncString(req.postalCode) : null;
        domain.country = req.country != null ? new EncString(req.country) : null;
        domain.company = req.company != null ? new EncString(req.company) : null;
        domain.email = req.email != null ? new EncString(req.email) : null;
        domain.phone = req.phone != null ? new EncString(req.phone) : null;
        domain.ssn = req.ssn != null ? new EncString(req.ssn) : null;
        domain.username = req.username != null ? new EncString(req.username) : null;
        domain.passportNumber = req.passportNumber != null ? new EncString(req.passportNumber) : null;
        domain.licenseNumber = req.licenseNumber != null ? new EncString(req.licenseNumber) : null;
        return domain;
    }
    constructor(o) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
        if (o == null) {
            return;
        }
        if (o instanceof IdentityView) {
            this.title = o.title;
            this.firstName = o.firstName;
            this.middleName = o.middleName;
            this.lastName = o.lastName;
            this.address1 = o.address1;
            this.address2 = o.address2;
            this.address3 = o.address3;
            this.city = o.city;
            this.state = o.state;
            this.postalCode = o.postalCode;
            this.country = o.country;
            this.company = o.company;
            this.email = o.email;
            this.phone = o.phone;
            this.ssn = o.ssn;
            this.username = o.username;
            this.passportNumber = o.passportNumber;
            this.licenseNumber = o.licenseNumber;
        }
        else {
            this.title = (_a = o.title) === null || _a === void 0 ? void 0 : _a.encryptedString;
            this.firstName = (_b = o.firstName) === null || _b === void 0 ? void 0 : _b.encryptedString;
            this.middleName = (_c = o.middleName) === null || _c === void 0 ? void 0 : _c.encryptedString;
            this.lastName = (_d = o.lastName) === null || _d === void 0 ? void 0 : _d.encryptedString;
            this.address1 = (_e = o.address1) === null || _e === void 0 ? void 0 : _e.encryptedString;
            this.address2 = (_f = o.address2) === null || _f === void 0 ? void 0 : _f.encryptedString;
            this.address3 = (_g = o.address3) === null || _g === void 0 ? void 0 : _g.encryptedString;
            this.city = (_h = o.city) === null || _h === void 0 ? void 0 : _h.encryptedString;
            this.state = (_j = o.state) === null || _j === void 0 ? void 0 : _j.encryptedString;
            this.postalCode = (_k = o.postalCode) === null || _k === void 0 ? void 0 : _k.encryptedString;
            this.country = (_l = o.country) === null || _l === void 0 ? void 0 : _l.encryptedString;
            this.company = (_m = o.company) === null || _m === void 0 ? void 0 : _m.encryptedString;
            this.email = (_o = o.email) === null || _o === void 0 ? void 0 : _o.encryptedString;
            this.phone = (_p = o.phone) === null || _p === void 0 ? void 0 : _p.encryptedString;
            this.ssn = (_q = o.ssn) === null || _q === void 0 ? void 0 : _q.encryptedString;
            this.username = (_r = o.username) === null || _r === void 0 ? void 0 : _r.encryptedString;
            this.passportNumber = (_s = o.passportNumber) === null || _s === void 0 ? void 0 : _s.encryptedString;
            this.licenseNumber = (_t = o.licenseNumber) === null || _t === void 0 ? void 0 : _t.encryptedString;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/login-uri.export.ts



class LoginUriExport {
    static template() {
        const req = new LoginUriExport();
        req.uri = "https://google.com";
        req.match = null;
        return req;
    }
    static toView(req, view = new LoginUriView()) {
        view.uri = req.uri;
        view.match = req.match;
        return view;
    }
    static toDomain(req, domain = new LoginUri()) {
        domain.uri = req.uri != null ? new EncString(req.uri) : null;
        domain.match = req.match;
        return domain;
    }
    constructor(o) {
        var _a;
        this.match = null;
        if (o == null) {
            return;
        }
        if (o instanceof LoginUriView) {
            this.uri = o.uri;
        }
        else {
            this.uri = (_a = o.uri) === null || _a === void 0 ? void 0 : _a.encryptedString;
        }
        this.match = o.match;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/login.export.ts




class LoginExport {
    static template() {
        const req = new LoginExport();
        req.uris = [];
        req.username = "jdoe";
        req.password = "myp@ssword123";
        req.totp = "JBSWY3DPEHPK3PXP";
        return req;
    }
    static toView(req, view = new LoginView()) {
        if (req.uris != null) {
            view.uris = req.uris.map((u) => LoginUriExport.toView(u));
        }
        view.username = req.username;
        view.password = req.password;
        view.totp = req.totp;
        return view;
    }
    static toDomain(req, domain = new Login()) {
        if (req.uris != null) {
            domain.uris = req.uris.map((u) => LoginUriExport.toDomain(u));
        }
        domain.username = req.username != null ? new EncString(req.username) : null;
        domain.password = req.password != null ? new EncString(req.password) : null;
        domain.totp = req.totp != null ? new EncString(req.totp) : null;
        return domain;
    }
    constructor(o) {
        var _a, _b, _c;
        if (o == null) {
            return;
        }
        if (o.uris != null) {
            if (o instanceof LoginView) {
                this.uris = o.uris.map((u) => new LoginUriExport(u));
            }
            else {
                this.uris = o.uris.map((u) => new LoginUriExport(u));
            }
        }
        if (o instanceof LoginView) {
            this.username = o.username;
            this.password = o.password;
            this.totp = o.totp;
        }
        else {
            this.username = (_a = o.username) === null || _a === void 0 ? void 0 : _a.encryptedString;
            this.password = (_b = o.password) === null || _b === void 0 ? void 0 : _b.encryptedString;
            this.totp = (_c = o.totp) === null || _c === void 0 ? void 0 : _c.encryptedString;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/secure-note.export.ts



class SecureNoteExport {
    static template() {
        const req = new SecureNoteExport();
        req.type = SecureNoteType.Generic;
        return req;
    }
    static toView(req, view = new SecureNoteView()) {
        view.type = req.type;
        return view;
    }
    static toDomain(req, view = new SecureNote()) {
        view.type = req.type;
        return view;
    }
    constructor(o) {
        if (o == null) {
            return;
        }
        this.type = o.type;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/cipher.export.ts










class CipherExport {
    static template() {
        const req = new CipherExport();
        req.organizationId = null;
        req.collectionIds = null;
        req.folderId = null;
        req.type = CipherType.Login;
        req.name = "Item name";
        req.notes = "Some notes about this item.";
        req.favorite = false;
        req.fields = [];
        req.login = null;
        req.secureNote = null;
        req.card = null;
        req.identity = null;
        req.reprompt = CipherRepromptType.None;
        return req;
    }
    static toView(req, view = new CipherView()) {
        var _a, _b, _c;
        view.type = req.type;
        view.folderId = req.folderId;
        if (view.organizationId == null) {
            view.organizationId = req.organizationId;
        }
        if (view.collectionIds || req.collectionIds) {
            const set = new Set(((_a = view.collectionIds) !== null && _a !== void 0 ? _a : []).concat((_b = req.collectionIds) !== null && _b !== void 0 ? _b : []));
            view.collectionIds = Array.from(set.values());
        }
        view.name = req.name;
        view.notes = req.notes;
        view.favorite = req.favorite;
        view.reprompt = (_c = req.reprompt) !== null && _c !== void 0 ? _c : CipherRepromptType.None;
        if (req.fields != null) {
            view.fields = req.fields.map((f) => FieldExport.toView(f));
        }
        switch (req.type) {
            case CipherType.Login:
                view.login = LoginExport.toView(req.login);
                break;
            case CipherType.SecureNote:
                view.secureNote = SecureNoteExport.toView(req.secureNote);
                break;
            case CipherType.Card:
                view.card = CardExport.toView(req.card);
                break;
            case CipherType.Identity:
                view.identity = IdentityExport.toView(req.identity);
                break;
        }
        return view;
    }
    static toDomain(req, domain = new Cipher()) {
        var _a;
        domain.type = req.type;
        domain.folderId = req.folderId;
        if (domain.organizationId == null) {
            domain.organizationId = req.organizationId;
        }
        domain.name = req.name != null ? new EncString(req.name) : null;
        domain.notes = req.notes != null ? new EncString(req.notes) : null;
        domain.favorite = req.favorite;
        domain.reprompt = (_a = req.reprompt) !== null && _a !== void 0 ? _a : CipherRepromptType.None;
        if (req.fields != null) {
            domain.fields = req.fields.map((f) => FieldExport.toDomain(f));
        }
        switch (req.type) {
            case CipherType.Login:
                domain.login = LoginExport.toDomain(req.login);
                break;
            case CipherType.SecureNote:
                domain.secureNote = SecureNoteExport.toDomain(req.secureNote);
                break;
            case CipherType.Card:
                domain.card = CardExport.toDomain(req.card);
                break;
            case CipherType.Identity:
                domain.identity = IdentityExport.toDomain(req.identity);
                break;
        }
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        var _a, _b;
        this.organizationId = o.organizationId;
        this.folderId = o.folderId;
        this.type = o.type;
        this.reprompt = o.reprompt;
        if (o instanceof CipherView) {
            this.name = o.name;
            this.notes = o.notes;
        }
        else {
            this.name = (_a = o.name) === null || _a === void 0 ? void 0 : _a.encryptedString;
            this.notes = (_b = o.notes) === null || _b === void 0 ? void 0 : _b.encryptedString;
        }
        this.favorite = o.favorite;
        if (o.fields != null) {
            if (o instanceof CipherView) {
                this.fields = o.fields.map((f) => new FieldExport(f));
            }
            else {
                this.fields = o.fields.map((f) => new FieldExport(f));
            }
        }
        switch (o.type) {
            case CipherType.Login:
                this.login = new LoginExport(o.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteExport(o.secureNote);
                break;
            case CipherType.Card:
                this.card = new CardExport(o.card);
                break;
            case CipherType.Identity:
                this.identity = new IdentityExport(o.identity);
                break;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/cipher-with-ids.export.ts

class CipherWithIdExport extends CipherExport {
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
        this.collectionIds = o.collectionIds;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/collection.export.ts



class CollectionExport {
    static template() {
        const req = new CollectionExport();
        req.organizationId = "00000000-0000-0000-0000-000000000000";
        req.name = "Collection name";
        req.externalId = null;
        return req;
    }
    static toView(req, view = new CollectionView()) {
        view.name = req.name;
        view.externalId = req.externalId;
        if (view.organizationId == null) {
            view.organizationId = req.organizationId;
        }
        return view;
    }
    static toDomain(req, domain = new Collection()) {
        domain.name = req.name != null ? new EncString(req.name) : null;
        domain.externalId = req.externalId;
        if (domain.organizationId == null) {
            domain.organizationId = req.organizationId;
        }
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        var _a;
        this.organizationId = o.organizationId;
        if (o instanceof CollectionView) {
            this.name = o.name;
        }
        else {
            this.name = (_a = o.name) === null || _a === void 0 ? void 0 : _a.encryptedString;
        }
        this.externalId = o.externalId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/collection-with-id.export.ts



class CollectionWithIdExport extends CollectionExport {
    static toView(req, view = new CollectionView()) {
        view.id = req.id;
        return super.toView(req, view);
    }
    static toDomain(req, domain = new Collection()) {
        domain.id = req.id;
        return super.toDomain(req, domain);
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/event.export.ts

class EventExport {
    constructor(event) {
        this.message = event.humanReadableMessage;
        this.appIcon = event.appIcon;
        this.appName = event.appName;
        this.userId = event.userId;
        this.userName = event.userName;
        this.userEmail = event.userEmail;
        this.date = event.date;
        this.ip = event.ip;
        this.type = EventType[event.type];
        this.installationId = event.installationId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/folder.view.ts
class FolderView {
    constructor(f) {
        this.id = null;
        this.name = null;
        this.revisionDate = null;
        if (!f) {
            return;
        }
        this.id = f.id;
        this.revisionDate = f.revisionDate;
    }
    static fromJSON(obj) {
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        return Object.assign(new FolderView(), obj, { revisionDate });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/folder.ts



class Folder extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            name: null,
        }, ["id"]);
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
    }
    decrypt() {
        return this.decryptObj(new FolderView(this), {
            name: null,
        }, null);
    }
    static fromJSON(obj) {
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        return Object.assign(new Folder(), obj, { name: EncString.fromJSON(obj.name), revisionDate });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/folder.export.ts



class FolderExport {
    static template() {
        const req = new FolderExport();
        req.name = "Folder name";
        return req;
    }
    static toView(req, view = new FolderView()) {
        view.name = req.name;
        return view;
    }
    static toDomain(req, domain = new Folder()) {
        domain.name = req.name != null ? new EncString(req.name) : null;
        return domain;
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        var _a;
        if (o instanceof FolderView) {
            this.name = o.name;
        }
        else {
            this.name = (_a = o.name) === null || _a === void 0 ? void 0 : _a.encryptedString;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/export/folder-with-id.export.ts



class FolderWithIdExport extends FolderExport {
    static toView(req, view = new FolderView()) {
        view.id = req.id;
        return super.toView(req, view);
    }
    static toDomain(req, domain = new Folder()) {
        domain.id = req.id;
        return super.toDomain(req, domain);
    }
    // Use build method instead of ctor so that we can control order of JSON stringify for pretty print
    build(o) {
        this.id = o.id;
        super.build(o);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/export.service.ts
var export_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











class ExportService {
    constructor(folderService, cipherService, apiService, cryptoService, cryptoFunctionService, stateService) {
        this.folderService = folderService;
        this.cipherService = cipherService;
        this.apiService = apiService;
        this.cryptoService = cryptoService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.stateService = stateService;
    }
    getExport(format = "csv", organizationId) {
        return export_service_awaiter(this, void 0, void 0, function* () {
            if (organizationId) {
                return yield this.getOrganizationExport(organizationId, format);
            }
            if (format === "encrypted_json") {
                return this.getEncryptedExport();
            }
            else {
                return this.getDecryptedExport(format);
            }
        });
    }
    getPasswordProtectedExport(password, organizationId) {
        return export_service_awaiter(this, void 0, void 0, function* () {
            const clearText = organizationId
                ? yield this.getOrganizationExport(organizationId, "json")
                : yield this.getExport("json");
            const kdfType = yield this.stateService.getKdfType();
            const kdfConfig = yield this.stateService.getKdfConfig();
            const salt = utils_Utils.fromBufferToB64(yield this.cryptoFunctionService.randomBytes(16));
            const key = yield this.cryptoService.makePinKey(password, salt, kdfType, kdfConfig);
            const encKeyValidation = yield this.cryptoService.encrypt(utils_Utils.newGuid(), key);
            const encText = yield this.cryptoService.encrypt(clearText, key);
            const jsonDoc = {
                encrypted: true,
                passwordProtected: true,
                salt: salt,
                kdfType: kdfType,
                kdfIterations: kdfConfig.iterations,
                kdfMemory: kdfConfig.memory,
                kdfParallelism: kdfConfig.parallelism,
                encKeyValidation_DO_NOT_EDIT: encKeyValidation.encryptedString,
                data: encText.encryptedString,
            };
            return JSON.stringify(jsonDoc, null, "  ");
        });
    }
    getOrganizationExport(organizationId, format = "csv") {
        return export_service_awaiter(this, void 0, void 0, function* () {
            if (format === "encrypted_json") {
                return this.getOrganizationEncryptedExport(organizationId);
            }
            else {
                return this.getOrganizationDecryptedExport(organizationId, format);
            }
        });
    }
    getEventExport(events) {
        return export_service_awaiter(this, void 0, void 0, function* () {
            return external_papaparse_namespaceObject.unparse(events.map((e) => new EventExport(e)));
        });
    }
    getFileName(prefix = null, extension = "csv") {
        const now = new Date();
        const dateString = now.getFullYear() +
            "" +
            this.padNumber(now.getMonth() + 1, 2) +
            "" +
            this.padNumber(now.getDate(), 2) +
            this.padNumber(now.getHours(), 2) +
            "" +
            this.padNumber(now.getMinutes(), 2) +
            this.padNumber(now.getSeconds(), 2);
        return "bitwarden" + (prefix ? "_" + prefix : "") + "_export_" + dateString + "." + extension;
    }
    getDecryptedExport(format) {
        return export_service_awaiter(this, void 0, void 0, function* () {
            let decFolders = [];
            let decCiphers = [];
            const promises = [];
            promises.push(this.folderService.getAllDecryptedFromState().then((folders) => {
                decFolders = folders;
            }));
            promises.push(this.cipherService.getAllDecrypted().then((ciphers) => {
                decCiphers = ciphers.filter((f) => f.deletedDate == null);
            }));
            yield Promise.all(promises);
            if (format === "csv") {
                const foldersMap = new Map();
                decFolders.forEach((f) => {
                    if (f.id != null) {
                        foldersMap.set(f.id, f);
                    }
                });
                const exportCiphers = [];
                decCiphers.forEach((c) => {
                    // only export logins and secure notes
                    if (c.type !== CipherType.Login && c.type !== CipherType.SecureNote) {
                        return;
                    }
                    if (c.organizationId != null) {
                        return;
                    }
                    const cipher = {};
                    cipher.folder =
                        c.folderId != null && foldersMap.has(c.folderId) ? foldersMap.get(c.folderId).name : null;
                    cipher.favorite = c.favorite ? 1 : null;
                    this.buildCommonCipher(cipher, c);
                    exportCiphers.push(cipher);
                });
                return external_papaparse_namespaceObject.unparse(exportCiphers);
            }
            else {
                const jsonDoc = {
                    encrypted: false,
                    folders: [],
                    items: [],
                };
                decFolders.forEach((f) => {
                    if (f.id == null) {
                        return;
                    }
                    const folder = new FolderWithIdExport();
                    folder.build(f);
                    jsonDoc.folders.push(folder);
                });
                decCiphers.forEach((c) => {
                    if (c.organizationId != null) {
                        return;
                    }
                    const cipher = new CipherWithIdExport();
                    cipher.build(c);
                    cipher.collectionIds = null;
                    jsonDoc.items.push(cipher);
                });
                return JSON.stringify(jsonDoc, null, "  ");
            }
        });
    }
    getEncryptedExport() {
        return export_service_awaiter(this, void 0, void 0, function* () {
            let folders = [];
            let ciphers = [];
            const promises = [];
            promises.push(this.folderService.getAllFromState().then((f) => {
                folders = f;
            }));
            promises.push(this.cipherService.getAll().then((c) => {
                ciphers = c.filter((f) => f.deletedDate == null);
            }));
            yield Promise.all(promises);
            const encKeyValidation = yield this.cryptoService.encrypt(utils_Utils.newGuid());
            const jsonDoc = {
                encrypted: true,
                encKeyValidation_DO_NOT_EDIT: encKeyValidation.encryptedString,
                folders: [],
                items: [],
            };
            folders.forEach((f) => {
                if (f.id == null) {
                    return;
                }
                const folder = new FolderWithIdExport();
                folder.build(f);
                jsonDoc.folders.push(folder);
            });
            ciphers.forEach((c) => {
                if (c.organizationId != null) {
                    return;
                }
                const cipher = new CipherWithIdExport();
                cipher.build(c);
                cipher.collectionIds = null;
                jsonDoc.items.push(cipher);
            });
            return JSON.stringify(jsonDoc, null, "  ");
        });
    }
    getOrganizationDecryptedExport(organizationId, format) {
        return export_service_awaiter(this, void 0, void 0, function* () {
            const decCollections = [];
            const decCiphers = [];
            const promises = [];
            promises.push(this.apiService.getOrganizationExport(organizationId).then((exportData) => {
                const exportPromises = [];
                if (exportData != null) {
                    if (exportData.collections != null && exportData.collections.length > 0) {
                        exportData.collections.forEach((c) => {
                            const collection = new Collection(new CollectionData(c));
                            exportPromises.push(collection.decrypt().then((decCol) => {
                                decCollections.push(decCol);
                            }));
                        });
                    }
                    if (exportData.ciphers != null && exportData.ciphers.length > 0) {
                        exportData.ciphers
                            .filter((c) => c.deletedDate === null)
                            .forEach((c) => {
                            const cipher = new Cipher(new CipherData(c));
                            exportPromises.push(cipher.decrypt().then((decCipher) => {
                                decCiphers.push(decCipher);
                            }));
                        });
                    }
                }
                return Promise.all(exportPromises);
            }));
            yield Promise.all(promises);
            if (format === "csv") {
                const collectionsMap = new Map();
                decCollections.forEach((c) => {
                    collectionsMap.set(c.id, c);
                });
                const exportCiphers = [];
                decCiphers.forEach((c) => {
                    // only export logins and secure notes
                    if (c.type !== CipherType.Login && c.type !== CipherType.SecureNote) {
                        return;
                    }
                    const cipher = {};
                    cipher.collections = [];
                    if (c.collectionIds != null) {
                        cipher.collections = c.collectionIds
                            .filter((id) => collectionsMap.has(id))
                            .map((id) => collectionsMap.get(id).name);
                    }
                    this.buildCommonCipher(cipher, c);
                    exportCiphers.push(cipher);
                });
                return external_papaparse_namespaceObject.unparse(exportCiphers);
            }
            else {
                const jsonDoc = {
                    encrypted: false,
                    collections: [],
                    items: [],
                };
                decCollections.forEach((c) => {
                    const collection = new CollectionWithIdExport();
                    collection.build(c);
                    jsonDoc.collections.push(collection);
                });
                decCiphers.forEach((c) => {
                    const cipher = new CipherWithIdExport();
                    cipher.build(c);
                    jsonDoc.items.push(cipher);
                });
                return JSON.stringify(jsonDoc, null, "  ");
            }
        });
    }
    getOrganizationEncryptedExport(organizationId) {
        return export_service_awaiter(this, void 0, void 0, function* () {
            const collections = [];
            const ciphers = [];
            const promises = [];
            promises.push(this.apiService.getCollections(organizationId).then((c) => {
                const collectionPromises = [];
                if (c != null && c.data != null && c.data.length > 0) {
                    c.data.forEach((r) => {
                        const collection = new Collection(new CollectionData(r));
                        collections.push(collection);
                    });
                }
                return Promise.all(collectionPromises);
            }));
            promises.push(this.apiService.getCiphersOrganization(organizationId).then((c) => {
                const cipherPromises = [];
                if (c != null && c.data != null && c.data.length > 0) {
                    c.data
                        .filter((item) => item.deletedDate === null)
                        .forEach((item) => {
                        const cipher = new Cipher(new CipherData(item));
                        ciphers.push(cipher);
                    });
                }
                return Promise.all(cipherPromises);
            }));
            yield Promise.all(promises);
            const orgKey = yield this.cryptoService.getOrgKey(organizationId);
            const encKeyValidation = yield this.cryptoService.encrypt(utils_Utils.newGuid(), orgKey);
            const jsonDoc = {
                encrypted: true,
                encKeyValidation_DO_NOT_EDIT: encKeyValidation.encryptedString,
                collections: [],
                items: [],
            };
            collections.forEach((c) => {
                const collection = new CollectionWithIdExport();
                collection.build(c);
                jsonDoc.collections.push(collection);
            });
            ciphers.forEach((c) => {
                const cipher = new CipherWithIdExport();
                cipher.build(c);
                jsonDoc.items.push(cipher);
            });
            return JSON.stringify(jsonDoc, null, "  ");
        });
    }
    padNumber(num, width, padCharacter = "0") {
        const numString = num.toString();
        return numString.length >= width
            ? numString
            : new Array(width - numString.length + 1).join(padCharacter) + numString;
    }
    buildCommonCipher(cipher, c) {
        cipher.type = null;
        cipher.name = c.name;
        cipher.notes = c.notes;
        cipher.fields = null;
        cipher.reprompt = c.reprompt;
        // Login props
        cipher.login_uri = null;
        cipher.login_username = null;
        cipher.login_password = null;
        cipher.login_totp = null;
        if (c.fields) {
            c.fields.forEach((f) => {
                if (!cipher.fields) {
                    cipher.fields = "";
                }
                else {
                    cipher.fields += "\n";
                }
                cipher.fields += (f.name || "") + ": " + f.value;
            });
        }
        switch (c.type) {
            case CipherType.Login:
                cipher.type = "login";
                cipher.login_username = c.login.username;
                cipher.login_password = c.login.password;
                cipher.login_totp = c.login.totp;
                if (c.login.uris) {
                    cipher.login_uri = [];
                    c.login.uris.forEach((u) => {
                        cipher.login_uri.push(u.uri);
                    });
                }
                break;
            case CipherType.SecureNote:
                cipher.type = "note";
                break;
            default:
                return;
        }
        return cipher;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/azureFileUpload.service.ts
var azureFileUpload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const MAX_SINGLE_BLOB_UPLOAD_SIZE = 256 * 1024 * 1024; // 256 MiB
const MAX_BLOCKS_PER_BLOB = 50000;
class AzureFileUploadService {
    constructor(logService) {
        this.logService = logService;
    }
    upload(url, data, renewalCallback) {
        return azureFileUpload_service_awaiter(this, void 0, void 0, function* () {
            if (data.buffer.byteLength <= MAX_SINGLE_BLOB_UPLOAD_SIZE) {
                return yield this.azureUploadBlob(url, data);
            }
            else {
                return yield this.azureUploadBlocks(url, data, renewalCallback);
            }
        });
    }
    azureUploadBlob(url, data) {
        return azureFileUpload_service_awaiter(this, void 0, void 0, function* () {
            const urlObject = utils_Utils.getUrl(url);
            const headers = new Headers({
                "x-ms-date": new Date().toUTCString(),
                "x-ms-version": urlObject.searchParams.get("sv"),
                "Content-Length": data.buffer.byteLength.toString(),
                "x-ms-blob-type": "BlockBlob",
            });
            const request = new Request(url, {
                body: data.buffer,
                cache: "no-store",
                method: "PUT",
                headers: headers,
            });
            const blobResponse = yield fetch(request);
            if (blobResponse.status !== 201) {
                throw new Error(`Failed to create Azure blob: ${blobResponse.status}`);
            }
        });
    }
    azureUploadBlocks(url, data, renewalCallback) {
        return azureFileUpload_service_awaiter(this, void 0, void 0, function* () {
            const baseUrl = utils_Utils.getUrl(url);
            const blockSize = this.getMaxBlockSize(baseUrl.searchParams.get("sv"));
            let blockIndex = 0;
            const numBlocks = Math.ceil(data.buffer.byteLength / blockSize);
            const blocksStaged = [];
            if (numBlocks > MAX_BLOCKS_PER_BLOB) {
                throw new Error(`Cannot upload file, exceeds maximum size of ${blockSize * MAX_BLOCKS_PER_BLOB}`);
            }
            // eslint-disable-next-line
            try {
                while (blockIndex < numBlocks) {
                    url = yield this.renewUrlIfNecessary(url, renewalCallback);
                    const blockUrl = utils_Utils.getUrl(url);
                    const blockId = this.encodedBlockId(blockIndex);
                    blockUrl.searchParams.append("comp", "block");
                    blockUrl.searchParams.append("blockid", blockId);
                    const start = blockIndex * blockSize;
                    const blockData = data.buffer.slice(start, start + blockSize);
                    const blockHeaders = new Headers({
                        "x-ms-date": new Date().toUTCString(),
                        "x-ms-version": blockUrl.searchParams.get("sv"),
                        "Content-Length": blockData.byteLength.toString(),
                    });
                    const blockRequest = new Request(blockUrl.toString(), {
                        body: blockData,
                        cache: "no-store",
                        method: "PUT",
                        headers: blockHeaders,
                    });
                    const blockResponse = yield fetch(blockRequest);
                    if (blockResponse.status !== 201) {
                        const message = `Unsuccessful block PUT. Received status ${blockResponse.status}`;
                        this.logService.error(message + "\n" + (yield blockResponse.json()));
                        throw new Error(message);
                    }
                    blocksStaged.push(blockId);
                    blockIndex++;
                }
                url = yield this.renewUrlIfNecessary(url, renewalCallback);
                const blockListUrl = utils_Utils.getUrl(url);
                const blockListXml = this.blockListXml(blocksStaged);
                blockListUrl.searchParams.append("comp", "blocklist");
                const headers = new Headers({
                    "x-ms-date": new Date().toUTCString(),
                    "x-ms-version": blockListUrl.searchParams.get("sv"),
                    "Content-Length": blockListXml.length.toString(),
                });
                const request = new Request(blockListUrl.toString(), {
                    body: blockListXml,
                    cache: "no-store",
                    method: "PUT",
                    headers: headers,
                });
                const response = yield fetch(request);
                if (response.status !== 201) {
                    const message = `Unsuccessful block list PUT. Received status ${response.status}`;
                    this.logService.error(message + "\n" + (yield response.json()));
                    throw new Error(message);
                }
            }
            catch (e) {
                throw e;
            }
        });
    }
    renewUrlIfNecessary(url, renewalCallback) {
        var _a;
        return azureFileUpload_service_awaiter(this, void 0, void 0, function* () {
            const urlObject = utils_Utils.getUrl(url);
            const expiry = new Date((_a = urlObject.searchParams.get("se")) !== null && _a !== void 0 ? _a : "");
            if (isNaN(expiry.getTime())) {
                expiry.setTime(Date.now() + 3600000);
            }
            if (expiry.getTime() < Date.now() + 1000) {
                return yield renewalCallback();
            }
            return url;
        });
    }
    encodedBlockId(blockIndex) {
        // Encoded blockId max size is 64, so pre-encoding max size is 48
        const utfBlockId = ("000000000000000000000000000000000000000000000000" + blockIndex.toString()).slice(-48);
        return utils_Utils.fromUtf8ToB64(utfBlockId);
    }
    blockListXml(blockIdList) {
        let xml = '<?xml version="1.0" encoding="utf-8"?><BlockList>';
        blockIdList.forEach((blockId) => {
            xml += `<Latest>${blockId}</Latest>`;
        });
        xml += "</BlockList>";
        return xml;
    }
    getMaxBlockSize(version) {
        if (Version.compare(version, "2019-12-12") >= 0) {
            return 4000 * 1024 * 1024; // 4000 MiB
        }
        else if (Version.compare(version, "2016-05-31") >= 0) {
            return 100 * 1024 * 1024; // 100 MiB
        }
        else {
            return 4 * 1024 * 1024; // 4 MiB
        }
    }
}
class Version {
    /**
     * Compares two Azure Versions against each other
     * @param a Version to compare
     * @param b Version to compare
     * @returns a number less than zero if b is newer than a, 0 if equal,
     * and greater than zero if a is newer than b
     */
    static compare(a, b) {
        if (typeof a === "string") {
            a = new Version(a);
        }
        if (typeof b === "string") {
            b = new Version(b);
        }
        return a.year !== b.year
            ? a.year - b.year
            : a.month !== b.month
                ? a.month - b.month
                : a.day !== b.day
                    ? a.day - b.day
                    : 0;
    }
    constructor(version) {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        try {
            const parts = version.split("-").map((v) => Number.parseInt(v, 10));
            this.year = parts[0];
            this.month = parts[1];
            this.day = parts[2];
        }
        catch (_a) {
            // Ignore error
        }
    }
    /**
     * Compares two Azure Versions against each other
     * @param compareTo Version to compare against
     * @returns a number less than zero if compareTo is newer, 0 if equal,
     * and greater than zero if this is greater than compareTo
     */
    compare(compareTo) {
        return Version.compare(this, compareTo);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/bitwardenFileUpload.service.ts
var bitwardenFileUpload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class BitwardenFileUploadService {
    upload(encryptedFileName, encryptedFileData, apiCall) {
        return bitwardenFileUpload_service_awaiter(this, void 0, void 0, function* () {
            const fd = new FormData();
            try {
                const blob = new Blob([encryptedFileData.buffer], { type: "application/octet-stream" });
                fd.append("data", blob, encryptedFileName);
            }
            catch (e) {
                if (utils_Utils.isNode && !utils_Utils.isBrowser) {
                    fd.append("data", Buffer.from(encryptedFileData.buffer), {
                        filepath: encryptedFileName,
                        contentType: "application/octet-stream",
                    });
                }
                else {
                    throw e;
                }
            }
            yield apiCall(fd);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/file-upload/file-upload.service.ts
var file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class FileUploadService {
    constructor(logService) {
        this.logService = logService;
        this.azureFileUploadService = new AzureFileUploadService(logService);
        this.bitwardenFileUploadService = new BitwardenFileUploadService();
    }
    upload(uploadData, fileName, encryptedFileData, fileUploadMethods) {
        return file_upload_service_awaiter(this, void 0, void 0, function* () {
            try {
                switch (uploadData.fileUploadType) {
                    case FileUploadType.Direct:
                        yield this.bitwardenFileUploadService.upload(fileName.encryptedString, encryptedFileData, (fd) => fileUploadMethods.postDirect(fd));
                        break;
                    case FileUploadType.Azure: {
                        yield this.azureFileUploadService.upload(uploadData.url, encryptedFileData, fileUploadMethods.renewFileUploadUrl);
                        break;
                    }
                    default:
                        throw new Error("Unknown file upload type");
                }
            }
            catch (e) {
                yield fileUploadMethods.rollback();
                throw e;
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/abstractions/storage.service.ts
class AbstractStorageService {
}
class AbstractMemoryStorageService extends AbstractStorageService {
    constructor() {
        super(...arguments);
        this.type = AbstractMemoryStorageService.TYPE;
    }
}
// Used to identify the service in the session sync decorator framework
AbstractMemoryStorageService.TYPE = "MemoryStorageService";

;// CONCATENATED MODULE: ../../libs/common/src/services/memoryStorage.service.ts
var memoryStorage_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MemoryStorageService extends AbstractMemoryStorageService {
    constructor() {
        super(...arguments);
        this.store = new Map();
    }
    get(key) {
        if (this.store.has(key)) {
            const obj = this.store.get(key);
            return Promise.resolve(obj);
        }
        return Promise.resolve(null);
    }
    has(key) {
        return memoryStorage_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.get(key)) != null;
        });
    }
    save(key, obj) {
        if (obj == null) {
            return this.remove(key);
        }
        this.store.set(key, obj);
        return Promise.resolve();
    }
    remove(key) {
        this.store.delete(key);
        return Promise.resolve();
    }
    getBypassCache(key) {
        return this.get(key);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/noopMessaging.service.ts
class NoopMessagingService {
    send(subscriber, arg = {}) {
        // Do nothing...
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/selection-read-only.response.ts

class SelectionReadOnlyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.readOnly = this.getResponseProperty("ReadOnly");
        this.hidePasswords = this.getResponseProperty("HidePasswords");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/abstractions/organization-user/responses/organization-user.response.ts



class OrganizationUserResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.collections = [];
        this.groups = [];
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.type = this.getResponseProperty("Type");
        this.status = this.getResponseProperty("Status");
        this.permissions = new PermissionsApi(this.getResponseProperty("Permissions"));
        this.externalId = this.getResponseProperty("ExternalId");
        this.accessAll = this.getResponseProperty("AccessAll");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        const collections = this.getResponseProperty("Collections");
        if (collections != null) {
            this.collections = collections.map((c) => new SelectionReadOnlyResponse(c));
        }
        const groups = this.getResponseProperty("Groups");
        if (groups != null) {
            this.groups = groups;
        }
    }
}
class OrganizationUserUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        var _a;
        super(response);
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.usesKeyConnector = (_a = this.getResponseProperty("UsesKeyConnector")) !== null && _a !== void 0 ? _a : false;
    }
}
class OrganizationUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        super(response);
    }
}
class OrganizationUserResetPasswordDetailsReponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.resetPasswordKey = this.getResponseProperty("ResetPasswordKey");
        this.encryptedPrivateKey = this.getResponseProperty("EncryptedPrivateKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/abstractions/organization-user/responses/organization-user-bulk.response.ts

class OrganizationUserBulkResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.error = this.getResponseProperty("Error");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/abstractions/organization-user/responses/organization-user-bulk-public-key.response.ts

class OrganizationUserBulkPublicKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.key = this.getResponseProperty("Key");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/organization-user/requests/organization-user-bulk.request.ts
class OrganizationUserBulkRequest {
    constructor(ids) {
        this.ids = ids == null ? [] : ids;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/organization-user/organization-user.service.implementation.ts
var organization_user_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class OrganizationUserServiceImplementation {
    constructor(apiService) {
        this.apiService = apiService;
    }
    getOrganizationUser(organizationId, id, options) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users/${id}?${params.toString()}`, null, true, true);
            return new OrganizationUserDetailsResponse(r);
        });
    }
    getOrganizationUserGroups(organizationId, id) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/groups", null, true, true);
            return r;
        });
    }
    getAllUsers(organizationId, options) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeCollections) {
                params.set("includeCollections", "true");
            }
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users?${params.toString()}`, null, true, true);
            return new ListResponse(r, OrganizationUserUserDetailsResponse);
        });
    }
    getOrganizationUserResetPasswordDetails(organizationId, id) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/reset-password-details", null, true, true);
            return new OrganizationUserResetPasswordDetailsReponse(r);
        });
    }
    postOrganizationUserInvite(organizationId, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/invite", request, true, false);
    }
    postOrganizationUserReinvite(organizationId, id) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/reinvite", null, true, false);
    }
    postManyOrganizationUserReinvite(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/reinvite", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    postOrganizationUserAcceptInit(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept-init", request, true, false);
    }
    postOrganizationUserAccept(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept", request, true, false);
    }
    postOrganizationUserConfirm(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/confirm", request, true, false);
    }
    postOrganizationUsersPublicKey(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/public-keys", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkPublicKeyResponse);
        });
    }
    postOrganizationUserBulkConfirm(organizationId, request) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/confirm", request, true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    putOrganizationUser(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id, request, true, false);
    }
    putOrganizationUserGroups(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/groups", request, true, false);
    }
    putOrganizationUserResetPasswordEnrollment(organizationId, userId, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + userId + "/reset-password-enrollment", request, true, false);
    }
    putOrganizationUserResetPassword(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/reset-password", request, true, false);
    }
    deleteOrganizationUser(organizationId, id) {
        return this.apiService.send("DELETE", "/organizations/" + organizationId + "/users/" + id, null, true, false);
    }
    deleteManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("DELETE", "/organizations/" + organizationId + "/users", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    revokeOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/revoke", null, true, false);
    }
    revokeManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/revoke", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    restoreOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/restore", null, true, false);
    }
    restoreManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/restore", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
}

;// CONCATENATED MODULE: external "lunr"
const external_lunr_namespaceObject = require("lunr");
;// CONCATENATED MODULE: ../../libs/common/src/services/search.service.ts
var search_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SearchService {
    constructor(logService, i18nService) {
        this.logService = logService;
        this.i18nService = i18nService;
        this.indexedEntityId = null;
        this.indexing = false;
        this.index = null;
        this.immediateSearchLocales = ["zh-CN", "zh-TW", "ja", "ko", "vi"];
        this.defaultSearchableMinLength = 2;
        this.searchableMinLength = this.defaultSearchableMinLength;
        this.i18nService.locale$.subscribe((locale) => {
            if (this.immediateSearchLocales.indexOf(locale) !== -1) {
                this.searchableMinLength = 1;
            }
            else {
                this.searchableMinLength = this.defaultSearchableMinLength;
            }
        });
        // Currently have to ensure this is only done a single time. Lunr allows you to register a function
        // multiple times but they will add a warning message to the console. The way they do that breaks when ran on a service worker.
        if (!SearchService.registeredPipeline) {
            SearchService.registeredPipeline = true;
            //register lunr pipeline function
            external_lunr_namespaceObject.Pipeline.registerFunction(this.normalizeAccentsPipelineFunction, "normalizeAccents");
        }
    }
    clearIndex() {
        this.indexedEntityId = null;
        this.index = null;
    }
    isSearchable(query) {
        query = SearchService.normalizeSearchQuery(query);
        const notSearchable = query == null ||
            (this.index == null && query.length < this.searchableMinLength) ||
            (this.index != null && query.length < this.searchableMinLength && query.indexOf(">") !== 0);
        return !notSearchable;
    }
    indexCiphers(ciphers, indexedEntityId) {
        if (this.indexing) {
            return;
        }
        this.indexing = true;
        this.indexedEntityId = indexedEntityId;
        this.index = null;
        const builder = new external_lunr_namespaceObject.Builder();
        builder.pipeline.add(this.normalizeAccentsPipelineFunction);
        builder.ref("id");
        builder.field("shortid", { boost: 100, extractor: (c) => c.id.substr(0, 8) });
        builder.field("name", {
            boost: 10,
        });
        builder.field("subtitle", {
            boost: 5,
            extractor: (c) => {
                if (c.subTitle != null && c.type === CipherType.Card) {
                    return c.subTitle.replace(/\*/g, "");
                }
                return c.subTitle;
            },
        });
        builder.field("notes");
        builder.field("login.username", {
            extractor: (c) => c.type === CipherType.Login && c.login != null ? c.login.username : null,
        });
        builder.field("login.uris", { boost: 2, extractor: (c) => this.uriExtractor(c) });
        builder.field("fields", { extractor: (c) => this.fieldExtractor(c, false) });
        builder.field("fields_joined", { extractor: (c) => this.fieldExtractor(c, true) });
        builder.field("attachments", {
            extractor: (c) => this.attachmentExtractor(c, false),
        });
        builder.field("attachments_joined", {
            extractor: (c) => this.attachmentExtractor(c, true),
        });
        builder.field("organizationid", { extractor: (c) => c.organizationId });
        ciphers = ciphers || [];
        ciphers.forEach((c) => builder.add(c));
        this.index = builder.build();
        this.indexing = false;
        this.logService.info("Finished search indexing");
    }
    searchCiphers(query, filter = null, ciphers) {
        return search_service_awaiter(this, void 0, void 0, function* () {
            const results = [];
            if (query != null) {
                query = SearchService.normalizeSearchQuery(query.trim().toLowerCase());
            }
            if (query === "") {
                query = null;
            }
            if (ciphers == null) {
                ciphers = [];
            }
            if (filter != null && Array.isArray(filter) && filter.length > 0) {
                ciphers = ciphers.filter((c) => filter.every((f) => f == null || f(c)));
            }
            else if (filter != null) {
                ciphers = ciphers.filter(filter);
            }
            if (!this.isSearchable(query)) {
                return ciphers;
            }
            if (this.indexing) {
                yield new Promise((r) => setTimeout(r, 250));
                if (this.indexing) {
                    yield new Promise((r) => setTimeout(r, 500));
                }
            }
            const index = this.getIndexForSearch();
            if (index == null) {
                // Fall back to basic search if index is not available
                return this.searchCiphersBasic(ciphers, query);
            }
            const ciphersMap = new Map();
            ciphers.forEach((c) => ciphersMap.set(c.id, c));
            let searchResults = null;
            const isQueryString = query != null && query.length > 1 && query.indexOf(">") === 0;
            if (isQueryString) {
                try {
                    searchResults = index.search(query.substr(1).trim());
                }
                catch (e) {
                    this.logService.error(e);
                }
            }
            else {
                const soWild = external_lunr_namespaceObject.Query.wildcard.LEADING | external_lunr_namespaceObject.Query.wildcard.TRAILING;
                searchResults = index.query((q) => {
                    external_lunr_namespaceObject.tokenizer(query).forEach((token) => {
                        const t = token.toString();
                        q.term(t, { fields: ["name"], wildcard: soWild });
                        q.term(t, { fields: ["subtitle"], wildcard: soWild });
                        q.term(t, { fields: ["login.uris"], wildcard: soWild });
                        q.term(t, {});
                    });
                });
            }
            if (searchResults != null) {
                searchResults.forEach((r) => {
                    if (ciphersMap.has(r.ref)) {
                        results.push(ciphersMap.get(r.ref));
                    }
                });
            }
            return results;
        });
    }
    searchCiphersBasic(ciphers, query, deleted = false) {
        query = SearchService.normalizeSearchQuery(query.trim().toLowerCase());
        return ciphers.filter((c) => {
            if (deleted !== c.isDeleted) {
                return false;
            }
            if (c.name != null && c.name.toLowerCase().indexOf(query) > -1) {
                return true;
            }
            if (query.length >= 8 && c.id.startsWith(query)) {
                return true;
            }
            if (c.subTitle != null && c.subTitle.toLowerCase().indexOf(query) > -1) {
                return true;
            }
            if (c.login &&
                c.login.hasUris &&
                c.login.uris.some((loginUri) => { var _a; return ((_a = loginUri === null || loginUri === void 0 ? void 0 : loginUri.uri) === null || _a === void 0 ? void 0 : _a.toLowerCase().indexOf(query)) > -1; })) {
                return true;
            }
            return false;
        });
    }
    searchSends(sends, query) {
        query = SearchService.normalizeSearchQuery(query.trim().toLocaleLowerCase());
        if (query === null) {
            return sends;
        }
        const sendsMatched = [];
        const lowPriorityMatched = [];
        sends.forEach((s) => {
            var _a, _b, _c;
            if (s.name != null && s.name.toLowerCase().indexOf(query) > -1) {
                sendsMatched.push(s);
            }
            else if (query.length >= 8 &&
                (s.id.startsWith(query) ||
                    s.accessId.toLocaleLowerCase().startsWith(query) ||
                    (((_a = s.file) === null || _a === void 0 ? void 0 : _a.id) != null && s.file.id.startsWith(query)))) {
                lowPriorityMatched.push(s);
            }
            else if (s.notes != null && s.notes.toLowerCase().indexOf(query) > -1) {
                lowPriorityMatched.push(s);
            }
            else if (((_b = s.text) === null || _b === void 0 ? void 0 : _b.text) != null && s.text.text.toLowerCase().indexOf(query) > -1) {
                lowPriorityMatched.push(s);
            }
            else if (((_c = s.file) === null || _c === void 0 ? void 0 : _c.fileName) != null && s.file.fileName.toLowerCase().indexOf(query) > -1) {
                lowPriorityMatched.push(s);
            }
        });
        return sendsMatched.concat(lowPriorityMatched);
    }
    getIndexForSearch() {
        return this.index;
    }
    fieldExtractor(c, joined) {
        if (!c.hasFields) {
            return null;
        }
        let fields = [];
        c.fields.forEach((f) => {
            if (f.name != null) {
                fields.push(f.name);
            }
            if (f.type === FieldType.Text && f.value != null) {
                fields.push(f.value);
            }
        });
        fields = fields.filter((f) => f.trim() !== "");
        if (fields.length === 0) {
            return null;
        }
        return joined ? fields.join(" ") : fields;
    }
    attachmentExtractor(c, joined) {
        if (!c.hasAttachments) {
            return null;
        }
        let attachments = [];
        c.attachments.forEach((a) => {
            if (a != null && a.fileName != null) {
                if (joined && a.fileName.indexOf(".") > -1) {
                    attachments.push(a.fileName.substr(0, a.fileName.lastIndexOf(".")));
                }
                else {
                    attachments.push(a.fileName);
                }
            }
        });
        attachments = attachments.filter((f) => f.trim() !== "");
        if (attachments.length === 0) {
            return null;
        }
        return joined ? attachments.join(" ") : attachments;
    }
    uriExtractor(c) {
        if (c.type !== CipherType.Login || c.login == null || !c.login.hasUris) {
            return null;
        }
        const uris = [];
        c.login.uris.forEach((u) => {
            if (u.uri == null || u.uri === "") {
                return;
            }
            if (u.hostname != null) {
                uris.push(u.hostname);
                return;
            }
            let uri = u.uri;
            if (u.match !== UriMatchType.RegularExpression) {
                const protocolIndex = uri.indexOf("://");
                if (protocolIndex > -1) {
                    uri = uri.substr(protocolIndex + 3);
                }
                const queryIndex = uri.search(/\?|&|#/);
                if (queryIndex > -1) {
                    uri = uri.substring(0, queryIndex);
                }
            }
            uris.push(uri);
        });
        return uris.length > 0 ? uris : null;
    }
    normalizeAccentsPipelineFunction(token) {
        const searchableFields = ["name", "login.username", "subtitle", "notes"];
        const fields = token.metadata["fields"];
        const checkFields = fields.every((i) => searchableFields.includes(i));
        if (checkFields) {
            return SearchService.normalizeSearchQuery(token.toString());
        }
        return token;
    }
    // Remove accents/diacritics characters from text. This regex is equivalent to the Diacritic unicode property escape, i.e. it will match all diacritic characters.
    static normalizeSearchQuery(query) {
        return query === null || query === void 0 ? void 0 : query.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    }
}
SearchService.registeredPipeline = false;

;// CONCATENATED MODULE: ../../libs/common/src/services/settings.service.ts
var settings_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class SettingsService {
    constructor(stateService) {
        this.stateService = stateService;
        this._settings = new external_rxjs_namespaceObject.BehaviorSubject({});
        this.settings$ = this._settings.asObservable();
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => settings_service_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.global.bitwardenContainerService == null) {
                return;
            }
            if (!unlocked) {
                this._settings.next({});
                return;
            }
            const data = yield this.stateService.getSettings();
            this._settings.next(data);
        })))
            .subscribe();
    }
    setEquivalentDomains(equivalentDomains) {
        var _a;
        return settings_service_awaiter(this, void 0, void 0, function* () {
            const settings = (_a = this._settings.getValue()) !== null && _a !== void 0 ? _a : {};
            settings.equivalentDomains = equivalentDomains;
            this._settings.next(settings);
            yield this.stateService.setSettings(settings);
        });
    }
    getEquivalentDomains(url) {
        const domain = utils_Utils.getDomain(url);
        if (domain == null) {
            return new Set();
        }
        const settings = this._settings.getValue();
        let result = [];
        if ((settings === null || settings === void 0 ? void 0 : settings.equivalentDomains) != null) {
            settings.equivalentDomains
                .filter((ed) => ed.length > 0 && ed.includes(domain))
                .forEach((ed) => {
                result = result.concat(ed);
            });
        }
        return new Set(result);
    }
    clear(userId) {
        return settings_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null || userId == (yield this.stateService.getUserId())) {
                this._settings.next({});
            }
            yield this.stateService.setSettings(null, { userId: userId });
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/provider.data.ts
class ProviderData {
    constructor(response) {
        this.id = response.id;
        this.name = response.name;
        this.status = response.status;
        this.type = response.type;
        this.enabled = response.enabled;
        this.userId = response.userId;
        this.useEvents = response.useEvents;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/vault-timeout-action.enum.ts
var VaultTimeoutAction;
(function (VaultTimeoutAction) {
    VaultTimeoutAction["Lock"] = "lock";
    VaultTimeoutAction["LogOut"] = "logOut";
})(VaultTimeoutAction || (VaultTimeoutAction = {}));

;// CONCATENATED MODULE: ../../libs/common/src/models/data/event.data.ts
class EventData {
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/state.ts
class State {
    constructor(globals) {
        this.accounts = {};
        this.authenticatedAccounts = [];
        this.accountActivity = {};
        this.globals = globals;
    }
    // TODO, make Jsonify<State,TGlobalState,TAccount> work. It currently doesn't because Globals doesn't implement Jsonify.
    static fromJSON(obj, accountDeserializer) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new State(null), obj, {
            accounts: State.buildAccountMapFromJSON(obj === null || obj === void 0 ? void 0 : obj.accounts, accountDeserializer),
        });
    }
    static buildAccountMapFromJSON(jsonAccounts, accountDeserializer) {
        if (!jsonAccounts) {
            return {};
        }
        const accounts = {};
        for (const userId in jsonAccounts) {
            accounts[userId] = accountDeserializer(jsonAccounts[userId]);
        }
        return accounts;
    }
}

;// CONCATENATED MODULE: external "zxcvbn"
const external_zxcvbn_namespaceObject = require("zxcvbn");
;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/password-generator-policy-options.ts

class PasswordGeneratorPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.defaultType = "";
        this.minLength = 0;
        this.useUppercase = false;
        this.useLowercase = false;
        this.useNumbers = false;
        this.numberCount = 0;
        this.useSpecial = false;
        this.specialCount = 0;
        this.minNumberWords = 0;
        this.capitalize = false;
        this.includeNumber = false;
    }
    inEffect() {
        return (this.defaultType !== "" ||
            this.minLength > 0 ||
            this.numberCount > 0 ||
            this.specialCount > 0 ||
            this.useUppercase ||
            this.useLowercase ||
            this.useNumbers ||
            this.useSpecial ||
            this.minNumberWords > 0 ||
            this.capitalize ||
            this.includeNumber);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/generated-password-history.ts
class GeneratedPasswordHistory {
    constructor(password, date) {
        this.password = password;
        this.date = date;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generation.service.ts
var password_generation_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






const DefaultOptions = {
    length: 14,
    ambiguous: false,
    number: true,
    minNumber: 1,
    uppercase: true,
    minUppercase: 0,
    lowercase: true,
    minLowercase: 0,
    special: false,
    minSpecial: 1,
    type: "password",
    numWords: 3,
    wordSeparator: "-",
    capitalize: false,
    includeNumber: false,
};
const MaxPasswordsInHistory = 100;
class PasswordGenerationService {
    constructor(cryptoService, policyService, stateService) {
        this.cryptoService = cryptoService;
        this.policyService = policyService;
        this.stateService = stateService;
    }
    generatePassword(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            // overload defaults with given options
            const o = Object.assign({}, DefaultOptions, options);
            if (o.type === "passphrase") {
                return this.generatePassphrase(options);
            }
            // sanitize
            this.sanitizePasswordLength(o, true);
            const minLength = o.minUppercase + o.minLowercase + o.minNumber + o.minSpecial;
            if (o.length < minLength) {
                o.length = minLength;
            }
            const positions = [];
            if (o.lowercase && o.minLowercase > 0) {
                for (let i = 0; i < o.minLowercase; i++) {
                    positions.push("l");
                }
            }
            if (o.uppercase && o.minUppercase > 0) {
                for (let i = 0; i < o.minUppercase; i++) {
                    positions.push("u");
                }
            }
            if (o.number && o.minNumber > 0) {
                for (let i = 0; i < o.minNumber; i++) {
                    positions.push("n");
                }
            }
            if (o.special && o.minSpecial > 0) {
                for (let i = 0; i < o.minSpecial; i++) {
                    positions.push("s");
                }
            }
            while (positions.length < o.length) {
                positions.push("a");
            }
            // shuffle
            yield this.shuffleArray(positions);
            // build out the char sets
            let allCharSet = "";
            let lowercaseCharSet = "abcdefghijkmnopqrstuvwxyz";
            if (o.ambiguous) {
                lowercaseCharSet += "l";
            }
            if (o.lowercase) {
                allCharSet += lowercaseCharSet;
            }
            let uppercaseCharSet = "ABCDEFGHJKLMNPQRSTUVWXYZ";
            if (o.ambiguous) {
                uppercaseCharSet += "IO";
            }
            if (o.uppercase) {
                allCharSet += uppercaseCharSet;
            }
            let numberCharSet = "23456789";
            if (o.ambiguous) {
                numberCharSet += "01";
            }
            if (o.number) {
                allCharSet += numberCharSet;
            }
            const specialCharSet = "!@#$%^&*";
            if (o.special) {
                allCharSet += specialCharSet;
            }
            let password = "";
            for (let i = 0; i < o.length; i++) {
                let positionChars;
                switch (positions[i]) {
                    case "l":
                        positionChars = lowercaseCharSet;
                        break;
                    case "u":
                        positionChars = uppercaseCharSet;
                        break;
                    case "n":
                        positionChars = numberCharSet;
                        break;
                    case "s":
                        positionChars = specialCharSet;
                        break;
                    case "a":
                        positionChars = allCharSet;
                        break;
                    default:
                        break;
                }
                const randomCharIndex = yield this.cryptoService.randomNumber(0, positionChars.length - 1);
                password += positionChars.charAt(randomCharIndex);
            }
            return password;
        });
    }
    generatePassphrase(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const o = Object.assign({}, DefaultOptions, options);
            if (o.numWords == null || o.numWords <= 2) {
                o.numWords = DefaultOptions.numWords;
            }
            if (o.wordSeparator == null || o.wordSeparator.length === 0 || o.wordSeparator.length > 1) {
                o.wordSeparator = " ";
            }
            if (o.capitalize == null) {
                o.capitalize = false;
            }
            if (o.includeNumber == null) {
                o.includeNumber = false;
            }
            const listLength = EFFLongWordList.length - 1;
            const wordList = new Array(o.numWords);
            for (let i = 0; i < o.numWords; i++) {
                const wordIndex = yield this.cryptoService.randomNumber(0, listLength);
                if (o.capitalize) {
                    wordList[i] = this.capitalize(EFFLongWordList[wordIndex]);
                }
                else {
                    wordList[i] = EFFLongWordList[wordIndex];
                }
            }
            if (o.includeNumber) {
                yield this.appendRandomNumberToRandomWord(wordList);
            }
            return wordList.join(o.wordSeparator);
        });
    }
    getOptions() {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            let options = yield this.stateService.getPasswordGenerationOptions();
            if (options == null) {
                options = Object.assign({}, DefaultOptions);
            }
            else {
                options = Object.assign({}, DefaultOptions, options);
            }
            yield this.stateService.setPasswordGenerationOptions(options);
            const enforcedOptions = yield this.enforcePasswordGeneratorPoliciesOnOptions(options);
            options = enforcedOptions[0];
            return [options, enforcedOptions[1]];
        });
    }
    enforcePasswordGeneratorPoliciesOnOptions(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            let enforcedPolicyOptions = yield this.getPasswordGeneratorPolicyOptions();
            if (enforcedPolicyOptions != null) {
                if (options.length < enforcedPolicyOptions.minLength) {
                    options.length = enforcedPolicyOptions.minLength;
                }
                if (enforcedPolicyOptions.useUppercase) {
                    options.uppercase = true;
                }
                if (enforcedPolicyOptions.useLowercase) {
                    options.lowercase = true;
                }
                if (enforcedPolicyOptions.useNumbers) {
                    options.number = true;
                }
                if (options.minNumber < enforcedPolicyOptions.numberCount) {
                    options.minNumber = enforcedPolicyOptions.numberCount;
                }
                if (enforcedPolicyOptions.useSpecial) {
                    options.special = true;
                }
                if (options.minSpecial < enforcedPolicyOptions.specialCount) {
                    options.minSpecial = enforcedPolicyOptions.specialCount;
                }
                // Must normalize these fields because the receiving call expects all options to pass the current rules
                if (options.minSpecial + options.minNumber > options.length) {
                    options.minSpecial = options.length - options.minNumber;
                }
                if (options.numWords < enforcedPolicyOptions.minNumberWords) {
                    options.numWords = enforcedPolicyOptions.minNumberWords;
                }
                if (enforcedPolicyOptions.capitalize) {
                    options.capitalize = true;
                }
                if (enforcedPolicyOptions.includeNumber) {
                    options.includeNumber = true;
                }
                // Force default type if password/passphrase selected via policy
                if (enforcedPolicyOptions.defaultType === "password" ||
                    enforcedPolicyOptions.defaultType === "passphrase") {
                    options.type = enforcedPolicyOptions.defaultType;
                }
            }
            else {
                // UI layer expects an instantiated object to prevent more explicit null checks
                enforcedPolicyOptions = new PasswordGeneratorPolicyOptions();
            }
            return [options, enforcedPolicyOptions];
        });
    }
    getPasswordGeneratorPolicyOptions() {
        var _a;
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const policies = yield ((_a = this.policyService) === null || _a === void 0 ? void 0 : _a.getAll(PolicyType.PasswordGenerator));
            let enforcedOptions = null;
            if (policies == null || policies.length === 0) {
                return enforcedOptions;
            }
            policies.forEach((currentPolicy) => {
                if (!currentPolicy.enabled || currentPolicy.data == null) {
                    return;
                }
                if (enforcedOptions == null) {
                    enforcedOptions = new PasswordGeneratorPolicyOptions();
                }
                // Password wins in multi-org collisions
                if (currentPolicy.data.defaultType != null && enforcedOptions.defaultType !== "password") {
                    enforcedOptions.defaultType = currentPolicy.data.defaultType;
                }
                if (currentPolicy.data.minLength != null &&
                    currentPolicy.data.minLength > enforcedOptions.minLength) {
                    enforcedOptions.minLength = currentPolicy.data.minLength;
                }
                if (currentPolicy.data.useUpper) {
                    enforcedOptions.useUppercase = true;
                }
                if (currentPolicy.data.useLower) {
                    enforcedOptions.useLowercase = true;
                }
                if (currentPolicy.data.useNumbers) {
                    enforcedOptions.useNumbers = true;
                }
                if (currentPolicy.data.minNumbers != null &&
                    currentPolicy.data.minNumbers > enforcedOptions.numberCount) {
                    enforcedOptions.numberCount = currentPolicy.data.minNumbers;
                }
                if (currentPolicy.data.useSpecial) {
                    enforcedOptions.useSpecial = true;
                }
                if (currentPolicy.data.minSpecial != null &&
                    currentPolicy.data.minSpecial > enforcedOptions.specialCount) {
                    enforcedOptions.specialCount = currentPolicy.data.minSpecial;
                }
                if (currentPolicy.data.minNumberWords != null &&
                    currentPolicy.data.minNumberWords > enforcedOptions.minNumberWords) {
                    enforcedOptions.minNumberWords = currentPolicy.data.minNumberWords;
                }
                if (currentPolicy.data.capitalize) {
                    enforcedOptions.capitalize = true;
                }
                if (currentPolicy.data.includeNumber) {
                    enforcedOptions.includeNumber = true;
                }
            });
            return enforcedOptions;
        });
    }
    saveOptions(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setPasswordGenerationOptions(options);
        });
    }
    getHistory() {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const hasKey = yield this.cryptoService.hasKey();
            if (!hasKey) {
                return new Array();
            }
            if ((yield this.stateService.getDecryptedPasswordGenerationHistory()) == null) {
                const encrypted = yield this.stateService.getEncryptedPasswordGenerationHistory();
                const decrypted = yield this.decryptHistory(encrypted);
                yield this.stateService.setDecryptedPasswordGenerationHistory(decrypted);
            }
            const passwordGenerationHistory = yield this.stateService.getDecryptedPasswordGenerationHistory();
            return passwordGenerationHistory != null
                ? passwordGenerationHistory
                : new Array();
        });
    }
    addHistory(password) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            // Cannot add new history if no key is available
            const hasKey = yield this.cryptoService.hasKey();
            if (!hasKey) {
                return;
            }
            const currentHistory = yield this.getHistory();
            // Prevent duplicates
            if (this.matchesPrevious(password, currentHistory)) {
                return;
            }
            currentHistory.unshift(new GeneratedPasswordHistory(password, Date.now()));
            // Remove old items.
            if (currentHistory.length > MaxPasswordsInHistory) {
                currentHistory.pop();
            }
            const newHistory = yield this.encryptHistory(currentHistory);
            yield this.stateService.setDecryptedPasswordGenerationHistory(currentHistory);
            return yield this.stateService.setEncryptedPasswordGenerationHistory(newHistory);
        });
    }
    clear(userId) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setEncryptedPasswordGenerationHistory(null, { userId: userId });
            yield this.stateService.setDecryptedPasswordGenerationHistory(null, { userId: userId });
        });
    }
    /**
     * Calculates a password strength score using zxcvbn.
     * @param password The password to calculate the strength of.
     * @param emailInput An unparsed email address to use as user input.
     * @param userInputs An array of additional user inputs to use when calculating the strength.
     */
    passwordStrength(password, emailInput = null, userInputs = null) {
        if (password == null || password.length === 0) {
            return null;
        }
        const globalUserInputs = [
            "bitwarden",
            "bit",
            "warden",
            ...(userInputs !== null && userInputs !== void 0 ? userInputs : []),
            ...this.emailToUserInputs(emailInput),
        ];
        // Use a hash set to get rid of any duplicate user inputs
        const finalUserInputs = Array.from(new Set(globalUserInputs));
        const result = external_zxcvbn_namespaceObject(password, finalUserInputs);
        return result;
    }
    normalizeOptions(options, enforcedPolicyOptions) {
        options.minLowercase = 0;
        options.minUppercase = 0;
        if (!options.length || options.length < 5) {
            options.length = 5;
        }
        else if (options.length > 128) {
            options.length = 128;
        }
        if (options.length < enforcedPolicyOptions.minLength) {
            options.length = enforcedPolicyOptions.minLength;
        }
        if (!options.minNumber) {
            options.minNumber = 0;
        }
        else if (options.minNumber > options.length) {
            options.minNumber = options.length;
        }
        else if (options.minNumber > 9) {
            options.minNumber = 9;
        }
        if (options.minNumber < enforcedPolicyOptions.numberCount) {
            options.minNumber = enforcedPolicyOptions.numberCount;
        }
        if (!options.minSpecial) {
            options.minSpecial = 0;
        }
        else if (options.minSpecial > options.length) {
            options.minSpecial = options.length;
        }
        else if (options.minSpecial > 9) {
            options.minSpecial = 9;
        }
        if (options.minSpecial < enforcedPolicyOptions.specialCount) {
            options.minSpecial = enforcedPolicyOptions.specialCount;
        }
        if (options.minSpecial + options.minNumber > options.length) {
            options.minSpecial = options.length - options.minNumber;
        }
        if (options.numWords == null || options.length < 3) {
            options.numWords = 3;
        }
        else if (options.numWords > 20) {
            options.numWords = 20;
        }
        if (options.numWords < enforcedPolicyOptions.minNumberWords) {
            options.numWords = enforcedPolicyOptions.minNumberWords;
        }
        if (options.wordSeparator != null && options.wordSeparator.length > 1) {
            options.wordSeparator = options.wordSeparator[0];
        }
        this.sanitizePasswordLength(options, false);
    }
    /**
     * Convert an email address into a list of user inputs for zxcvbn by
     * taking the local part of the email address and splitting it into words.
     * @param email
     * @private
     */
    emailToUserInputs(email) {
        if (email == null || email.length === 0) {
            return [];
        }
        const atPosition = email.indexOf("@");
        if (atPosition < 0) {
            return [];
        }
        return email
            .substring(0, atPosition)
            .trim()
            .toLowerCase()
            .split(/[^A-Za-z0-9]/);
    }
    capitalize(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    }
    appendRandomNumberToRandomWord(wordList) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (wordList == null || wordList.length <= 0) {
                return;
            }
            const index = yield this.cryptoService.randomNumber(0, wordList.length - 1);
            const num = yield this.cryptoService.randomNumber(0, 9);
            wordList[index] = wordList[index] + num;
        });
    }
    encryptHistory(history) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (history == null || history.length === 0) {
                return Promise.resolve([]);
            }
            const promises = history.map((item) => password_generation_service_awaiter(this, void 0, void 0, function* () {
                const encrypted = yield this.cryptoService.encrypt(item.password);
                return new GeneratedPasswordHistory(encrypted.encryptedString, item.date);
            }));
            return yield Promise.all(promises);
        });
    }
    decryptHistory(history) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (history == null || history.length === 0) {
                return Promise.resolve([]);
            }
            const promises = history.map((item) => password_generation_service_awaiter(this, void 0, void 0, function* () {
                const decrypted = yield this.cryptoService.decryptToUtf8(new EncString(item.password));
                return new GeneratedPasswordHistory(decrypted, item.date);
            }));
            return yield Promise.all(promises);
        });
    }
    matchesPrevious(password, history) {
        if (history == null || history.length === 0) {
            return false;
        }
        return history[history.length - 1].password === password;
    }
    // ref: https://stackoverflow.com/a/12646864/1090359
    shuffleArray(array) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            for (let i = array.length - 1; i > 0; i--) {
                const j = yield this.cryptoService.randomNumber(0, i);
                [array[i], array[j]] = [array[j], array[i]];
            }
        });
    }
    sanitizePasswordLength(options, forGeneration) {
        let minUppercaseCalc = 0;
        let minLowercaseCalc = 0;
        let minNumberCalc = options.minNumber;
        let minSpecialCalc = options.minSpecial;
        if (options.uppercase && options.minUppercase <= 0) {
            minUppercaseCalc = 1;
        }
        else if (!options.uppercase) {
            minUppercaseCalc = 0;
        }
        if (options.lowercase && options.minLowercase <= 0) {
            minLowercaseCalc = 1;
        }
        else if (!options.lowercase) {
            minLowercaseCalc = 0;
        }
        if (options.number && options.minNumber <= 0) {
            minNumberCalc = 1;
        }
        else if (!options.number) {
            minNumberCalc = 0;
        }
        if (options.special && options.minSpecial <= 0) {
            minSpecialCalc = 1;
        }
        else if (!options.special) {
            minSpecialCalc = 0;
        }
        // This should never happen but is a final safety net
        if (!options.length || options.length < 1) {
            options.length = 10;
        }
        const minLength = minUppercaseCalc + minLowercaseCalc + minNumberCalc + minSpecialCalc;
        // Normalize and Generation both require this modification
        if (options.length < minLength) {
            options.length = minLength;
        }
        // Apply other changes if the options object passed in is for generation
        if (forGeneration) {
            options.minUppercase = minUppercaseCalc;
            options.minLowercase = minLowercaseCalc;
            options.minNumber = minNumberCalc;
            options.minSpecial = minSpecialCalc;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/index.ts




;// CONCATENATED MODULE: ../../libs/common/src/tools/send/enums/send-type.ts
var SendType;
(function (SendType) {
    SendType[SendType["Text"] = 0] = "Text";
    SendType[SendType["File"] = 1] = "File";
})(SendType || (SendType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/data/send-file.data.ts
class SendFileData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.id = data.id;
        this.fileName = data.fileName;
        this.size = data.size;
        this.sizeName = data.sizeName;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/data/send-text.data.ts
class SendTextData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.text = data.text;
        this.hidden = data.hidden;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/data/send.data.ts



class SendData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.accessId = response.accessId;
        this.type = response.type;
        this.name = response.name;
        this.notes = response.notes;
        this.key = response.key;
        this.maxAccessCount = response.maxAccessCount;
        this.accessCount = response.accessCount;
        this.revisionDate = response.revisionDate;
        this.expirationDate = response.expirationDate;
        this.deletionDate = response.deletionDate;
        this.password = response.password;
        this.disabled = response.disable;
        this.hideEmail = response.hideEmail;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendTextData(response.text);
                break;
            case SendType.File:
                this.file = new SendFileData(response.file);
                break;
            default:
                break;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send-file.view.ts
class SendFileView {
    constructor(f) {
        this.id = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        if (!f) {
            return;
        }
        this.id = f.id;
        this.size = f.size;
        this.sizeName = f.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendFileView(), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send-text.view.ts
class SendTextView {
    constructor(t) {
        this.text = null;
        if (!t) {
            return;
        }
        this.hidden = t.hidden;
    }
    get maskedText() {
        return this.text != null ? "••••••••" : null;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendTextView(), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send.view.ts




class SendView {
    constructor(s) {
        this.id = null;
        this.accessId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.text = new SendTextView();
        this.file = new SendFileView();
        this.maxAccessCount = null;
        this.accessCount = 0;
        this.revisionDate = null;
        this.deletionDate = null;
        this.expirationDate = null;
        this.password = null;
        this.disabled = false;
        this.hideEmail = false;
        if (!s) {
            return;
        }
        this.id = s.id;
        this.accessId = s.accessId;
        this.type = s.type;
        this.maxAccessCount = s.maxAccessCount;
        this.accessCount = s.accessCount;
        this.revisionDate = s.revisionDate;
        this.deletionDate = s.deletionDate;
        this.expirationDate = s.expirationDate;
        this.disabled = s.disabled;
        this.password = s.password;
        this.hideEmail = s.hideEmail;
    }
    get urlB64Key() {
        return utils_Utils.fromBufferToUrlB64(this.key);
    }
    get maxAccessCountReached() {
        if (this.maxAccessCount == null) {
            return false;
        }
        return this.accessCount >= this.maxAccessCount;
    }
    get expired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate <= new Date();
    }
    get pendingDelete() {
        return this.deletionDate <= new Date();
    }
    toJSON() {
        return utils_Utils.merge(Object.assign({}, this), {
            key: utils_Utils.fromBufferToB64(this.key),
        });
    }
    static fromJSON(json) {
        var _a;
        if (json == null) {
            return null;
        }
        return Object.assign(new SendView(), json, {
            key: (_a = utils_Utils.fromB64ToArray(json.key)) === null || _a === void 0 ? void 0 : _a.buffer,
            cryptoKey: SymmetricCryptoKey.fromJSON(json.cryptoKey),
            text: SendTextView.fromJSON(json.text),
            file: SendFileView.fromJSON(json.file),
            revisionDate: json.revisionDate == null ? null : new Date(json.revisionDate),
            deletionDate: json.deletionDate == null ? null : new Date(json.deletionDate),
            expirationDate: json.expirationDate == null ? null : new Date(json.expirationDate),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/folder.data.ts
class FolderData {
    constructor(response) {
        this.name = response.name;
        this.id = response.id;
        this.revisionDate = response.revisionDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/state.service.ts
var state_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var state_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






















const keys = {
    state: "state",
    global: "global",
    authenticatedAccounts: "authenticatedAccounts",
    activeUserId: "activeUserId",
    tempAccountSettings: "tempAccountSettings",
    accountActivity: "accountActivity",
};
const partialKeys = {
    autoKey: "_masterkey_auto",
    biometricKey: "_masterkey_biometric",
    masterKey: "_masterkey",
};
const DDG_SHARED_KEY = "DuckDuckGoSharedKey";
class StateService {
    constructor(storageService, secureStorageService, memoryStorageService, logService, stateMigrationService, stateFactory, useAccountCache = true) {
        this.storageService = storageService;
        this.secureStorageService = secureStorageService;
        this.memoryStorageService = memoryStorageService;
        this.logService = logService;
        this.stateMigrationService = stateMigrationService;
        this.stateFactory = stateFactory;
        this.useAccountCache = useAccountCache;
        this.accountsSubject = new external_rxjs_namespaceObject.BehaviorSubject({});
        this.accounts$ = this.accountsSubject.asObservable();
        this.activeAccountSubject = new external_rxjs_namespaceObject.BehaviorSubject(null);
        this.activeAccount$ = this.activeAccountSubject.asObservable();
        this.activeAccountUnlockedSubject = new external_rxjs_namespaceObject.BehaviorSubject(false);
        this.activeAccountUnlocked$ = this.activeAccountUnlockedSubject.asObservable();
        this.hasBeenInited = false;
        this.isRecoveredSession = false;
        this.accountDiskCache = new external_rxjs_namespaceObject.BehaviorSubject({});
        // default account serializer, must be overridden by child class
        this.accountDeserializer = Account.fromJSON;
        // If the account gets changed, verify the new account is unlocked
        this.activeAccountSubject
            .pipe((0,external_rxjs_namespaceObject.concatMap)((userId) => state_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null && this.activeAccountUnlockedSubject.getValue() == false) {
                return;
            }
            else if (userId == null) {
                this.activeAccountUnlockedSubject.next(false);
            }
            // FIXME: This should be refactored into AuthService or a similar service,
            //  as checking for the existance of the crypto key is a low level
            //  implementation detail.
            this.activeAccountUnlockedSubject.next((yield this.getCryptoMasterKey()) != null);
        })))
            .subscribe();
    }
    init() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (this.hasBeenInited) {
                return;
            }
            if (yield this.stateMigrationService.needsMigration()) {
                yield this.stateMigrationService.migrate();
            }
            yield this.state().then((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state == null) {
                    yield this.setState(new State(this.createGlobals()));
                }
                else {
                    this.isRecoveredSession = true;
                }
            }));
            yield this.initAccountState();
            this.hasBeenInited = true;
        });
    }
    initAccountState() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (this.isRecoveredSession) {
                return;
            }
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                var _a;
                state.authenticatedAccounts =
                    (_a = (yield this.storageService.get(keys.authenticatedAccounts))) !== null && _a !== void 0 ? _a : [];
                for (const i in state.authenticatedAccounts) {
                    if (i != null) {
                        yield this.syncAccountFromDisk(state.authenticatedAccounts[i]);
                    }
                }
                const storedActiveUser = yield this.storageService.get(keys.activeUserId);
                if (storedActiveUser != null) {
                    state.activeUserId = storedActiveUser;
                }
                yield this.pushAccounts();
                this.activeAccountSubject.next(state.activeUserId);
                return state;
            }));
        });
    }
    syncAccountFromDisk(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                return;
            }
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state.accounts == null) {
                    state.accounts = {};
                }
                state.accounts[userId] = this.createAccount();
                const diskAccount = yield this.getAccountFromDisk({ userId: userId });
                state.accounts[userId].profile = diskAccount.profile;
                return state;
            }));
        });
    }
    addAccount(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            account = yield this.setAccountEnvironmentUrls(account);
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.authenticatedAccounts.push(account.profile.userId);
                yield this.storageService.save(keys.authenticatedAccounts, state.authenticatedAccounts);
                state.accounts[account.profile.userId] = account;
                return state;
            }));
            yield this.scaffoldNewAccountStorage(account);
            yield this.setLastActive(new Date().getTime(), { userId: account.profile.userId });
            yield this.setActiveUser(account.profile.userId);
            this.activeAccountSubject.next(account.profile.userId);
        });
    }
    setActiveUser(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            this.clearDecryptedDataForActiveUser();
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.activeUserId = userId;
                yield this.storageService.save(keys.activeUserId, userId);
                this.activeAccountSubject.next(state.activeUserId);
                return state;
            }));
            yield this.pushAccounts();
        });
    }
    clean(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultInMemoryOptions());
            yield this.deAuthenticateAccount(options.userId);
            if (options.userId === ((_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId)) {
                yield this.dynamicallySetActiveUser();
            }
            yield this.removeAccountFromDisk(options === null || options === void 0 ? void 0 : options.userId);
            this.removeAccountFromMemory(options === null || options === void 0 ? void 0 : options.userId);
            yield this.pushAccounts();
        });
    }
    getAccessToken(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.tokens) === null || _b === void 0 ? void 0 : _b.accessToken;
        });
    }
    setAccessToken(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.tokens.accessToken = value;
            yield this.saveAccount(account, options);
        });
    }
    getAddEditCipherInfo(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.addEditCipherInfo;
        });
    }
    setAddEditCipherInfo(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.addEditCipherInfo = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getAlwaysShowDock(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.alwaysShowDock) !== null && _b !== void 0 ? _b : false);
        });
    }
    setAlwaysShowDock(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.alwaysShowDock = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getApiKeyClientId(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.apiKeyClientId;
        });
    }
    setApiKeyClientId(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.profile.apiKeyClientId = value;
            yield this.saveAccount(account, options);
        });
    }
    getApiKeyClientSecret(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.keys) === null || _b === void 0 ? void 0 : _b.apiKeyClientSecret;
        });
    }
    setApiKeyClientSecret(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.keys.apiKeyClientSecret = value;
            yield this.saveAccount(account, options);
        });
    }
    getAutoConfirmFingerPrints(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.autoConfirmFingerPrints) !== null && _c !== void 0 ? _c : false);
        });
    }
    setAutoConfirmFingerprints(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.autoConfirmFingerPrints = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getAutoFillOnPageLoadDefault(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.autoFillOnPageLoadDefault) !== null && _c !== void 0 ? _c : true);
        });
    }
    setAutoFillOnPageLoadDefault(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.autoFillOnPageLoadDefault = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricAwaitingAcceptance(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.biometricAwaitingAcceptance) !== null && _b !== void 0 ? _b : false);
        });
    }
    setBiometricAwaitingAcceptance(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.biometricAwaitingAcceptance = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricFingerprintValidated(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.biometricFingerprintValidated) !== null && _b !== void 0 ? _b : false);
        });
    }
    setBiometricFingerprintValidated(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.biometricFingerprintValidated = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricText(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.biometricText;
        });
    }
    setBiometricText(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.biometricText = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricUnlock(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.biometricUnlock) !== null && _c !== void 0 ? _c : false);
        });
    }
    setBiometricUnlock(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.biometricUnlock = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getCanAccessPremium(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (!(yield this.getIsAuthenticated(options))) {
                return false;
            }
            return ((yield this.getHasPremiumPersonally(options)) ||
                (yield this.getHasPremiumFromOrganization(options)));
        });
    }
    getHasPremiumPersonally(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            return (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumPersonally;
        });
    }
    setHasPremiumPersonally(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.hasPremiumPersonally = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getHasPremiumFromOrganization(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            if ((_a = account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumFromOrganization) {
                return true;
            }
            // TODO: older server versions won't send the hasPremiumFromOrganization flag, so we're keeping the old logic
            // for backwards compatibility. It can be removed after everyone has upgraded.
            const organizations = yield this.getOrganizations(options);
            if (organizations == null) {
                return false;
            }
            for (const id of Object.keys(organizations)) {
                const o = organizations[id];
                if (o.enabled && o.usersGetPremium && !o.isProviderUser) {
                    return true;
                }
            }
            return false;
        });
    }
    setHasPremiumFromOrganization(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.hasPremiumFromOrganization = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getClearClipboard(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.clearClipboard) !== null && _c !== void 0 ? _c : null);
        });
    }
    setClearClipboard(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.clearClipboard = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getCollapsedGroupings(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.collapsedGroupings;
        });
    }
    setCollapsedGroupings(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.collapsedGroupings = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getConvertAccountToKeyConnector(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.convertAccountToKeyConnector;
        });
    }
    setConvertAccountToKeyConnector(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.convertAccountToKeyConnector = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getCryptoMasterKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.cryptoMasterKey;
        });
    }
    setCryptoMasterKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.cryptoMasterKey = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            if (options.userId == this.activeAccountSubject.getValue()) {
                const nextValue = value != null;
                // Avoid emitting if we are already unlocked
                if (this.activeAccountUnlockedSubject.getValue() != nextValue) {
                    this.activeAccountUnlockedSubject.next(nextValue);
                }
            }
        });
    }
    getCryptoMasterKeyAuto(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.autoKey}`, options);
        });
    }
    setCryptoMasterKeyAuto(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.autoKey, value, options);
        });
    }
    getCryptoMasterKeyB64(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options === null || options === void 0 ? void 0 : options.userId}${partialKeys.masterKey}`, options);
        });
    }
    setCryptoMasterKeyB64(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.masterKey, value, options);
        });
    }
    getCryptoMasterKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.biometricKey}`, options);
        });
    }
    hasCryptoMasterKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return false;
            }
            return yield this.secureStorageService.has(`${options.userId}${partialKeys.biometricKey}`, options);
        });
    }
    setCryptoMasterKeyBiometric(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.biometricKey, value, options);
        });
    }
    getDecryptedCiphers(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.ciphers) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedCiphers(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.ciphers.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedCollections(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.collections) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedCollections(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.collections.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedCryptoSymmetricKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.cryptoSymmetricKey) === null || _b === void 0 ? void 0 : _b.decrypted;
        });
    }
    setDecryptedCryptoSymmetricKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.cryptoSymmetricKey.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedOrganizationKeys(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return utils_Utils.recordToMap((_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.decrypted);
        });
    }
    setDecryptedOrganizationKeys(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.organizationKeys.decrypted = utils_Utils.mapToRecord(value);
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedPasswordGenerationHistory(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.passwordGenerationHistory) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedPasswordGenerationHistory(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.passwordGenerationHistory.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedPinProtected(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinProtected) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedPinProtected(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.settings.pinProtected.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedPolicies(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.policies) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedPolicies(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.policies.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedPrivateKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.keys) === null || _b === void 0 ? void 0 : _b.privateKey.decrypted;
        });
    }
    setDecryptedPrivateKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.privateKey.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedProviderKeys(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return utils_Utils.recordToMap((_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.providerKeys) === null || _b === void 0 ? void 0 : _b.decrypted);
        });
    }
    setDecryptedProviderKeys(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.providerKeys.decrypted = utils_Utils.mapToRecord(value);
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedSends(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.sends) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedSends(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.sends.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDefaultUriMatch(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.defaultUriMatch;
        });
    }
    setDefaultUriMatch(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.defaultUriMatch = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableAddLoginNotification(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableAddLoginNotification) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableAddLoginNotification(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableAddLoginNotification = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableAutoBiometricsPrompt(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableAutoBiometricsPrompt) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableAutoBiometricsPrompt(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableAutoBiometricsPrompt = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableAutoTotpCopy(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableAutoTotpCopy) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableAutoTotpCopy(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableAutoTotpCopy = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableBadgeCounter(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableBadgeCounter) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableBadgeCounter(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableBadgeCounter = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableChangedPasswordNotification(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableChangedPasswordNotification) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableChangedPasswordNotification(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableChangedPasswordNotification = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableContextMenuItem(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableContextMenuItem) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableContextMenuItem(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableContextMenuItem = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableFavicon(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.disableFavicon) !== null && _b !== void 0 ? _b : false);
        });
    }
    setDisableFavicon(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.disableFavicon = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getDisableGa(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableGa) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableGa(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableGa = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDismissedAutofillCallout(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dismissedAutoFillOnPageLoadCallout) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDismissedAutofillCallout(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.dismissedAutoFillOnPageLoadCallout = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDontShowCardsCurrentTab(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dontShowCardsCurrentTab) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDontShowCardsCurrentTab(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.dontShowCardsCurrentTab = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDontShowIdentitiesCurrentTab(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dontShowIdentitiesCurrentTab) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDontShowIdentitiesCurrentTab(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.dontShowIdentitiesCurrentTab = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDuckDuckGoSharedKey(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(DDG_SHARED_KEY, options);
        });
    }
    setDuckDuckGoSharedKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            value == null
                ? yield this.secureStorageService.remove(DDG_SHARED_KEY, options)
                : yield this.secureStorageService.save(DDG_SHARED_KEY, value, options);
        });
    }
    getEmail(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.email;
        });
    }
    setEmail(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.profile.email = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getEmailVerified(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile.emailVerified) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEmailVerified(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.emailVerified = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableAlwaysOnTop(options) {
        var _a, _b, _c, _d;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accountPreference = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.enableAlwaysOnTop;
            const globalPreference = (_c = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _c === void 0 ? void 0 : _c.enableAlwaysOnTop;
            return (_d = accountPreference !== null && accountPreference !== void 0 ? accountPreference : globalPreference) !== null && _d !== void 0 ? _d : false;
        });
    }
    setEnableAlwaysOnTop(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.enableAlwaysOnTop = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableAlwaysOnTop = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableAutoFillOnPageLoad(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.enableAutoFillOnPageLoad) !== null && _c !== void 0 ? _c : false);
        });
    }
    setEnableAutoFillOnPageLoad(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.enableAutoFillOnPageLoad = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableBrowserIntegration(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableBrowserIntegration) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableBrowserIntegration(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableBrowserIntegration = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableBrowserIntegrationFingerprint(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableBrowserIntegrationFingerprint) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableBrowserIntegrationFingerprint(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableBrowserIntegrationFingerprint = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableCloseToTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableCloseToTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableCloseToTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableCloseToTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableDuckDuckGoBrowserIntegration(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableDuckDuckGoBrowserIntegration) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableDuckDuckGoBrowserIntegration(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableDuckDuckGoBrowserIntegration = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableFullWidth(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.enableFullWidth) !== null && _c !== void 0 ? _c : false);
        });
    }
    setEnableFullWidth(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.enableFullWidth = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getEnableMinimizeToTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableMinimizeToTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableMinimizeToTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableMinimizeToTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableStartToTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableStartToTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableStartToTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableStartToTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedCiphers(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.ciphers) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedCiphers(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.ciphers.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getEncryptedCollections(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.collections) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedCollections(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.collections.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getEncryptedCryptoSymmetricKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.keys.cryptoSymmetricKey.encrypted;
        });
    }
    setEncryptedCryptoSymmetricKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.cryptoSymmetricKey.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedFolders(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.folders) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedFolders(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.folders.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getEncryptedOrganizationKeys(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.keys) === null || _b === void 0 ? void 0 : _b.organizationKeys.encrypted;
        });
    }
    setEncryptedOrganizationKeys(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.organizationKeys.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedPasswordGenerationHistory(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.passwordGenerationHistory) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedPasswordGenerationHistory(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.passwordGenerationHistory.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedPinProtected(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinProtected) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedPinProtected(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.pinProtected.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedPolicies(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.policies) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedPolicies(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.policies.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedPrivateKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            return (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.privateKey) === null || _b === void 0 ? void 0 : _b.encrypted;
        });
    }
    setEncryptedPrivateKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.privateKey.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedProviderKeys(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.keys) === null || _b === void 0 ? void 0 : _b.providerKeys) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedProviderKeys(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.providerKeys.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedSends(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.sends.encrypted;
        });
    }
    setEncryptedSends(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.sends.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getEntityId(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.entityId;
        });
    }
    setEntityId(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.profile.entityId = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getEntityType(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.entityType;
        });
    }
    setEntityType(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.profile.entityType = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getEnvironmentUrls(options) {
        var _a, _b, _c, _d;
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (((_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) == null) {
                return yield this.getGlobalEnvironmentUrls(options);
            }
            options = this.reconcileOptions(options, yield this.defaultOnDiskOptions());
            return (_d = (_c = (_b = (yield this.getAccount(options))) === null || _b === void 0 ? void 0 : _b.settings) === null || _c === void 0 ? void 0 : _c.environmentUrls) !== null && _d !== void 0 ? _d : new EnvironmentUrls();
        });
    }
    setEnvironmentUrls(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            // Global values are set on each change and the current global settings are passed to any newly authed accounts.
            // This is to allow setting environement values before an account is active, while still allowing individual accounts to have their own environments.
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.environmentUrls = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEquivalentDomains(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.equivalentDomains;
        });
    }
    setEquivalentDomains(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.equivalentDomains = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEventCollection(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.eventCollection;
        });
    }
    setEventCollection(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.eventCollection = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEverBeenUnlocked(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.everBeenUnlocked) !== null && _c !== void 0 ? _c : false);
        });
    }
    setEverBeenUnlocked(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.profile.everBeenUnlocked = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getForcePasswordResetReason(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.forcePasswordResetReason) !== null && _c !== void 0 ? _c : ForceResetPasswordReason.None);
        });
    }
    setForcePasswordResetReason(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.profile.forcePasswordResetReason = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getInstalledVersion(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.installedVersion;
        });
    }
    setInstalledVersion(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.installedVersion = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getIsAuthenticated(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.getAccessToken(options)) != null && (yield this.getUserId(options)) != null;
        });
    }
    getKdfConfig(options) {
        var _a, _b, _c, _d, _e, _f;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const iterations = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.kdfIterations;
            const memory = (_d = (_c = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _c === void 0 ? void 0 : _c.profile) === null || _d === void 0 ? void 0 : _d.kdfMemory;
            const parallelism = (_f = (_e = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _e === void 0 ? void 0 : _e.profile) === null || _f === void 0 ? void 0 : _f.kdfParallelism;
            return new KdfConfig(iterations, memory, parallelism);
        });
    }
    setKdfConfig(config, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.kdfIterations = config.iterations;
            account.profile.kdfMemory = config.memory;
            account.profile.kdfParallelism = config.parallelism;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getKdfType(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.kdfType;
        });
    }
    setKdfType(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.kdfType = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getKeyHash(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.keyHash;
        });
    }
    setKeyHash(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.keyHash = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getLastActive(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskOptions());
            const accountActivity = yield this.storageService.get(keys.accountActivity, options);
            if (accountActivity == null || Object.keys(accountActivity).length < 1) {
                return null;
            }
            return accountActivity[options.userId];
        });
    }
    setLastActive(value, options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskOptions());
            if (options.userId == null) {
                return;
            }
            const accountActivity = (_a = (yield this.storageService.get(keys.accountActivity, options))) !== null && _a !== void 0 ? _a : {};
            accountActivity[options.userId] = value;
            yield this.storageService.save(keys.accountActivity, accountActivity, options);
        });
    }
    getLastSync(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.lastSync;
        });
    }
    setLastSync(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.profile.lastSync = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getLocalData(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.localData;
        });
    }
    setLocalData(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.data.localData = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getLocale(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.locale;
        });
    }
    setLocale(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.locale = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getMainWindowSize(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.mainWindowSize;
        });
    }
    setMainWindowSize(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            globals.mainWindowSize = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getMinimizeOnCopyToClipboard(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.minimizeOnCopyToClipboard) !== null && _c !== void 0 ? _c : false);
        });
    }
    setMinimizeOnCopyToClipboard(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.minimizeOnCopyToClipboard = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getNeverDomains(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.neverDomains;
        });
    }
    setNeverDomains(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.neverDomains = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getNoAutoPromptBiometricsText(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.noAutoPromptBiometricsText;
        });
    }
    setNoAutoPromptBiometricsText(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.noAutoPromptBiometricsText = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getOpenAtLogin(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.openAtLogin) !== null && _b !== void 0 ? _b : false);
        });
    }
    setOpenAtLogin(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.openAtLogin = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getOrganizationInvitation(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.organizationInvitation;
        });
    }
    setOrganizationInvitation(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            globals.organizationInvitation = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * @deprecated Do not call this directly, use OrganizationService
     */
    getOrganizations(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.organizations;
        });
    }
    /**
     * @deprecated Do not call this directly, use OrganizationService
     */
    setOrganizations(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.organizations = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getPasswordGenerationOptions(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.passwordGenerationOptions;
        });
    }
    setPasswordGenerationOptions(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.passwordGenerationOptions = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getUsernameGenerationOptions(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.usernameGenerationOptions;
        });
    }
    setUsernameGenerationOptions(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.usernameGenerationOptions = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getGeneratorOptions(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.generatorOptions;
        });
    }
    setGeneratorOptions(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.generatorOptions = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getProtectedPin(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.protectedPin;
        });
    }
    setProtectedPin(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.protectedPin = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getProviders(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.providers;
        });
    }
    setProviders(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.providers = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getPublicKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const keys = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.keys;
            return keys === null || keys === void 0 ? void 0 : keys.publicKey;
        });
    }
    setPublicKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.publicKey = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getRefreshToken(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.tokens) === null || _b === void 0 ? void 0 : _b.refreshToken;
        });
    }
    setRefreshToken(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.tokens.refreshToken = value;
            yield this.saveAccount(account, options);
        });
    }
    getRememberedEmail(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.rememberedEmail;
        });
    }
    setRememberedEmail(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.rememberedEmail = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getSecurityStamp(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.tokens) === null || _b === void 0 ? void 0 : _b.securityStamp;
        });
    }
    setSecurityStamp(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.tokens.securityStamp = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getSettings(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.settings;
        });
    }
    setSettings(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.settings.settings = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getSsoCodeVerifier(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.ssoCodeVerifier;
        });
    }
    setSsoCodeVerifier(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.ssoCodeVerifier = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getSsoOrgIdentifier(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.ssoOrganizationIdentifier;
        });
    }
    setSsoOrganizationIdentifier(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.ssoOrganizationIdentifier = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getSsoState(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.ssoState;
        });
    }
    setSsoState(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.ssoState = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getTheme(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.theme;
        });
    }
    setTheme(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.theme = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getTwoFactorToken(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.twoFactorToken;
        });
    }
    setTwoFactorToken(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.twoFactorToken = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getUserId(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.userId;
        });
    }
    getUsesKeyConnector(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.usesKeyConnector;
        });
    }
    setUsesKeyConnector(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.usesKeyConnector = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getVaultTimeout(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accountVaultTimeout = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.vaultTimeout;
            return accountVaultTimeout;
        });
    }
    setVaultTimeout(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.vaultTimeout = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getVaultTimeoutAction(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accountVaultTimeoutAction = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.vaultTimeoutAction;
            const globalVaultTimeoutAction = (_c = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _c === void 0 ? void 0 : _c.vaultTimeoutAction;
            return accountVaultTimeoutAction !== null && accountVaultTimeoutAction !== void 0 ? accountVaultTimeoutAction : globalVaultTimeoutAction;
        });
    }
    setVaultTimeoutAction(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.vaultTimeoutAction = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getApproveLoginRequests(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const approveLoginRequests = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.approveLoginRequests;
            return approveLoginRequests;
        });
    }
    setApproveLoginRequests(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.approveLoginRequests = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getStateVersion() {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(yield this.defaultOnDiskLocalOptions())).stateVersion) !== null && _a !== void 0 ? _a : 1;
        });
    }
    setStateVersion(value) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(yield this.defaultOnDiskOptions());
            globals.stateVersion = value;
            yield this.saveGlobals(globals, yield this.defaultOnDiskOptions());
        });
    }
    getWindow() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(yield this.defaultOnDiskOptions());
            return (globals === null || globals === void 0 ? void 0 : globals.window) != null && Object.keys(globals.window).length > 0
                ? globals.window
                : new WindowState();
        });
    }
    setWindow(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.window = value;
            return yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    setServerConfig(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.serverConfig = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getServerConfig(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.serverConfig;
        });
    }
    getAvatarColor(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.avatarColor;
        });
    }
    setAvatarColor(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.avatarColor = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getActivateAutoFillOnPageLoadFromPolicy(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.activateAutoFillOnPageLoadFromPolicy;
        });
    }
    setActivateAutoFillOnPageLoadFromPolicy(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.activateAutoFillOnPageLoadFromPolicy = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getSMOnboardingTasks(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.smOnboardingTasks;
        });
    }
    setSMOnboardingTasks(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.smOnboardingTasks = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getGlobals(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            let globals;
            if (this.useMemory(options.storageLocation)) {
                globals = yield this.getGlobalsFromMemory();
            }
            if (this.useDisk && globals == null) {
                globals = yield this.getGlobalsFromDisk(options);
            }
            return globals !== null && globals !== void 0 ? globals : this.createGlobals();
        });
    }
    saveGlobals(globals, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return this.useMemory(options.storageLocation)
                ? this.saveGlobalsToMemory(globals)
                : yield this.saveGlobalsToDisk(globals, options);
        });
    }
    getGlobalsFromMemory() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.state()).globals;
        });
    }
    getGlobalsFromDisk(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.storageService.get(keys.global, options);
        });
    }
    saveGlobalsToMemory(globals) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.globals = globals;
                return state;
            }));
        });
    }
    saveGlobalsToDisk(globals, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (options.useSecureStorage) {
                yield this.secureStorageService.save(keys.global, globals, options);
            }
            else {
                yield this.storageService.save(keys.global, globals, options);
            }
        });
    }
    getAccount(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            try {
                let account;
                if (this.useMemory(options.storageLocation)) {
                    account = yield this.getAccountFromMemory(options);
                }
                if (this.useDisk(options.storageLocation) && account == null) {
                    account = yield this.getAccountFromDisk(options);
                }
                return account;
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
    getAccountFromMemory(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.state().then((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state.accounts == null) {
                    return null;
                }
                return state.accounts[yield this.getUserIdFromMemory(options)];
            }));
        });
    }
    getUserIdFromMemory(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.state().then((state) => {
                var _a, _b;
                return (options === null || options === void 0 ? void 0 : options.userId) != null
                    ? (_b = (_a = state.accounts[options.userId]) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.userId
                    : state.activeUserId;
            });
        });
    }
    getAccountFromDisk(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            if ((options === null || options === void 0 ? void 0 : options.userId) == null && ((_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) == null) {
                return null;
            }
            if (this.useAccountCache) {
                const cachedAccount = this.accountDiskCache.value[options.userId];
                if (cachedAccount != null) {
                    return cachedAccount;
                }
            }
            const account = (options === null || options === void 0 ? void 0 : options.useSecureStorage)
                ? (_b = (yield this.secureStorageService.get(options.userId, options))) !== null && _b !== void 0 ? _b : (yield this.storageService.get(options.userId, this.reconcileOptions(options, { htmlStorageLocation: HtmlStorageLocation.Local })))
                : yield this.storageService.get(options.userId, options);
            this.setDiskCache(options.userId, account);
            return account;
        });
    }
    useMemory(storageLocation) {
        return storageLocation === StorageLocation.Memory || storageLocation === StorageLocation.Both;
    }
    useDisk(storageLocation) {
        return storageLocation === StorageLocation.Disk || storageLocation === StorageLocation.Both;
    }
    saveAccount(account, options = {
        storageLocation: StorageLocation.Both,
        useSecureStorage: false,
    }) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return this.useMemory(options.storageLocation)
                ? yield this.saveAccountToMemory(account)
                : yield this.saveAccountToDisk(account, options);
        });
    }
    saveAccountToDisk(account, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storageLocation = options.useSecureStorage
                ? this.secureStorageService
                : this.storageService;
            yield storageLocation.save(`${options.userId}`, account, options);
            this.deleteDiskCache(options.userId);
        });
    }
    saveAccountToMemory(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (this.getAccountFromMemory({ userId: account.profile.userId }) !== null) {
                yield this.updateState((state) => {
                    return new Promise((resolve) => {
                        state.accounts[account.profile.userId] = account;
                        resolve(state);
                    });
                });
            }
            yield this.pushAccounts();
        });
    }
    scaffoldNewAccountStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            // We don't want to manipulate the referenced in memory account
            const deepClone = JSON.parse(JSON.stringify(account));
            yield this.scaffoldNewAccountLocalStorage(deepClone);
            yield this.scaffoldNewAccountSessionStorage(deepClone);
            yield this.scaffoldNewAccountMemoryStorage(deepClone);
        });
    }
    // TODO: There is a tech debt item for splitting up these methods - only Web uses multiple storage locations in its storageService.
    // For now these methods exist with some redundancy to facilitate this special web requirement.
    scaffoldNewAccountLocalStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskLocalOptions()));
            // EnvironmentUrls are set before authenticating and should override whatever is stored from any previous session
            const environmentUrls = account.settings.environmentUrls;
            if ((storedAccount === null || storedAccount === void 0 ? void 0 : storedAccount.settings) != null) {
                account.settings = storedAccount.settings;
            }
            else if (yield this.storageService.has(keys.tempAccountSettings)) {
                account.settings = yield this.storageService.get(keys.tempAccountSettings);
                yield this.storageService.remove(keys.tempAccountSettings);
            }
            account.settings.environmentUrls = environmentUrls;
            if (account.settings.vaultTimeoutAction === VaultTimeoutAction.LogOut &&
                account.settings.vaultTimeout != null) {
                account.tokens.accessToken = null;
                account.tokens.refreshToken = null;
                account.profile.apiKeyClientId = null;
                account.keys.apiKeyClientSecret = null;
            }
            yield this.saveAccount(account, this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskLocalOptions()));
        });
    }
    scaffoldNewAccountMemoryStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskMemoryOptions()));
            if ((storedAccount === null || storedAccount === void 0 ? void 0 : storedAccount.settings) != null) {
                storedAccount.settings.environmentUrls = account.settings.environmentUrls;
                account.settings = storedAccount.settings;
            }
            yield this.storageService.save(account.profile.userId, account, yield this.defaultOnDiskMemoryOptions());
            yield this.saveAccount(account, this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    scaffoldNewAccountSessionStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskOptions()));
            if ((storedAccount === null || storedAccount === void 0 ? void 0 : storedAccount.settings) != null) {
                storedAccount.settings.environmentUrls = account.settings.environmentUrls;
                account.settings = storedAccount.settings;
            }
            yield this.storageService.save(account.profile.userId, account, yield this.defaultOnDiskMemoryOptions());
            yield this.saveAccount(account, this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskOptions()));
        });
    }
    //
    pushAccounts() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.pruneInMemoryAccounts();
            yield this.state().then((state) => {
                if (state.accounts == null || Object.keys(state.accounts).length < 1) {
                    this.accountsSubject.next({});
                    return;
                }
                this.accountsSubject.next(state.accounts);
            });
        });
    }
    reconcileOptions(requestedOptions, defaultOptions) {
        var _a, _b, _c, _d, _e;
        if (requestedOptions == null) {
            return defaultOptions;
        }
        requestedOptions.userId = (_a = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.userId) !== null && _a !== void 0 ? _a : defaultOptions.userId;
        requestedOptions.storageLocation =
            (_b = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.storageLocation) !== null && _b !== void 0 ? _b : defaultOptions.storageLocation;
        requestedOptions.useSecureStorage =
            (_c = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.useSecureStorage) !== null && _c !== void 0 ? _c : defaultOptions.useSecureStorage;
        requestedOptions.htmlStorageLocation =
            (_d = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.htmlStorageLocation) !== null && _d !== void 0 ? _d : defaultOptions.htmlStorageLocation;
        requestedOptions.keySuffix = (_e = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.keySuffix) !== null && _e !== void 0 ? _e : defaultOptions.keySuffix;
        return requestedOptions;
    }
    defaultInMemoryOptions() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Memory,
                userId: (yield this.state()).activeUserId,
            };
        });
    }
    defaultOnDiskOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                htmlStorageLocation: HtmlStorageLocation.Session,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getActiveUserIdFromStorage()),
                useSecureStorage: false,
            };
        });
    }
    defaultOnDiskLocalOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                htmlStorageLocation: HtmlStorageLocation.Local,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getActiveUserIdFromStorage()),
                useSecureStorage: false,
            };
        });
    }
    defaultOnDiskMemoryOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                htmlStorageLocation: HtmlStorageLocation.Memory,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getUserId()),
                useSecureStorage: false,
            };
        });
    }
    defaultSecureStorageOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                useSecureStorage: true,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getActiveUserIdFromStorage()),
            };
        });
    }
    getActiveUserIdFromStorage() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.storageService.get(keys.activeUserId);
        });
    }
    removeAccountFromLocalStorage(userId = null) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            userId = userId !== null && userId !== void 0 ? userId : (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskLocalOptions()));
            yield this.saveAccount(this.resetAccount(storedAccount), this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskLocalOptions()));
        });
    }
    removeAccountFromSessionStorage(userId = null) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            userId = userId !== null && userId !== void 0 ? userId : (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskOptions()));
            yield this.saveAccount(this.resetAccount(storedAccount), this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskOptions()));
        });
    }
    removeAccountFromSecureStorage(userId = null) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            userId = userId !== null && userId !== void 0 ? userId : (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            yield this.setCryptoMasterKeyAuto(null, { userId: userId });
            yield this.setCryptoMasterKeyBiometric(null, { userId: userId });
            yield this.setCryptoMasterKeyB64(null, { userId: userId });
        });
    }
    removeAccountFromMemory(userId = null) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                userId = userId !== null && userId !== void 0 ? userId : state.activeUserId;
                delete state.accounts[userId];
                this.deleteDiskCache(userId);
                return state;
            }));
        });
    }
    pruneInMemoryAccounts() {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            // We preserve settings for logged out accounts, but we don't want to consider them when thinking about active account state
            for (const userId in (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.accounts) {
                if (!(yield this.getIsAuthenticated({ userId: userId }))) {
                    yield this.removeAccountFromMemory(userId);
                }
            }
        });
    }
    // settings persist even on reset, and are not effected by this method
    resetAccount(account) {
        const persistentAccountInformation = { settings: account.settings };
        return Object.assign(this.createAccount(), persistentAccountInformation);
    }
    setAccountEnvironmentUrls(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            account.settings.environmentUrls = yield this.getGlobalEnvironmentUrls();
            return account;
        });
    }
    getGlobalEnvironmentUrls(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskOptions());
            return (_a = (yield this.getGlobals(options)).environmentUrls) !== null && _a !== void 0 ? _a : new EnvironmentUrls();
        });
    }
    clearDecryptedDataForActiveUser() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                var _a;
                const userId = state === null || state === void 0 ? void 0 : state.activeUserId;
                if (userId != null && ((_a = state === null || state === void 0 ? void 0 : state.accounts[userId]) === null || _a === void 0 ? void 0 : _a.data) != null) {
                    state.accounts[userId].data = new AccountData();
                }
                return state;
            }));
        });
    }
    createAccount(init = null) {
        return this.stateFactory.createAccount(init);
    }
    createGlobals(init = null) {
        return this.stateFactory.createGlobal(init);
    }
    deAuthenticateAccount(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccessToken(null, { userId: userId });
            yield this.setLastActive(null, { userId: userId });
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.authenticatedAccounts = state.authenticatedAccounts.filter((id) => id !== userId);
                yield this.storageService.save(keys.authenticatedAccounts, state.authenticatedAccounts);
                return state;
            }));
        });
    }
    removeAccountFromDisk(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.removeAccountFromSessionStorage(userId);
            yield this.removeAccountFromLocalStorage(userId);
            yield this.removeAccountFromSecureStorage(userId);
        });
    }
    dynamicallySetActiveUser() {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accounts = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.accounts;
            if (accounts == null || Object.keys(accounts).length < 1) {
                yield this.setActiveUser(null);
                return;
            }
            for (const userId in accounts) {
                if (userId == null) {
                    continue;
                }
                if (yield this.getIsAuthenticated({ userId: userId })) {
                    yield this.setActiveUser(userId);
                    break;
                }
                yield this.setActiveUser(null);
            }
        });
    }
    getTimeoutBasedStorageOptions(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const timeoutAction = yield this.getVaultTimeoutAction({ userId: options === null || options === void 0 ? void 0 : options.userId });
            const timeout = yield this.getVaultTimeout({ userId: options === null || options === void 0 ? void 0 : options.userId });
            const defaultOptions = timeoutAction === VaultTimeoutAction.LogOut && timeout != null
                ? yield this.defaultInMemoryOptions()
                : yield this.defaultOnDiskOptions();
            return this.reconcileOptions(options, defaultOptions);
        });
    }
    saveSecureStorageKey(key, value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return value == null
                ? yield this.secureStorageService.remove(`${options.userId}${key}`, options)
                : yield this.secureStorageService.save(`${options.userId}${key}`, value, options);
        });
    }
    state() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const state = yield this.memoryStorageService.get(keys.state, {
                deserializer: (s) => State.fromJSON(s, this.accountDeserializer),
            });
            return state;
        });
    }
    setState(state) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.memoryStorageService.save(keys.state, state);
        });
    }
    updateState(stateUpdater) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.state().then((state) => state_service_awaiter(this, void 0, void 0, function* () {
                const updatedState = yield stateUpdater(state);
                if (updatedState == null) {
                    throw new Error("Attempted to update state to null value");
                }
                yield this.setState(updatedState);
            }));
        });
    }
    setDiskCache(key, value, options) {
        if (this.useAccountCache) {
            this.accountDiskCache.value[key] = value;
            this.accountDiskCache.next(this.accountDiskCache.value);
        }
    }
    deleteDiskCache(key) {
        if (this.useAccountCache) {
            delete this.accountDiskCache.value[key];
            this.accountDiskCache.next(this.accountDiskCache.value);
        }
    }
}
state_service_decorate([
    withPrototypeForArrayMembers(CipherView, CipherView.fromJSON),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedCiphers", null);
state_service_decorate([
    withPrototypeForArrayMembers(CollectionView),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedCollections", null);
state_service_decorate([
    withPrototypeForArrayMembers(GeneratedPasswordHistory),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedPasswordGenerationHistory", null);
state_service_decorate([
    withPrototypeForArrayMembers(Policy),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedPolicies", null);
state_service_decorate([
    withPrototypeForArrayMembers(SendView),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedSends", null);
state_service_decorate([
    withPrototypeForObjectValues(CipherData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedCiphers", null);
state_service_decorate([
    withPrototypeForObjectValues(CollectionData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedCollections", null);
state_service_decorate([
    withPrototypeForObjectValues(FolderData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedFolders", null);
state_service_decorate([
    withPrototypeForArrayMembers(GeneratedPasswordHistory),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedPasswordGenerationHistory", null);
state_service_decorate([
    withPrototypeForObjectValues(PolicyData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedPolicies", null);
state_service_decorate([
    withPrototypeForObjectValues(SendData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedSends", null);
state_service_decorate([
    withPrototypeForArrayMembers(EventData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEventCollection", null);
state_service_decorate([
    withPrototypeForObjectValues(ProviderData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getProviders", null);
function withPrototypeForArrayMembers(memberConstructor, memberConverter = (i) => i) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        return {
            value: function (...args) {
                const originalResult = originalMethod.apply(this, args);
                if (!utils_Utils.isPromise(originalResult)) {
                    throw new Error(`Error applying prototype to stored value -- result is not a promise for method ${String(propertyKey)}`);
                }
                return originalResult.then((result) => {
                    if (result == null) {
                        return null;
                    }
                    else if (!(result instanceof Array)) {
                        throw new Error(`Attempted to retrieve non array type from state as an array for method ${String(propertyKey)}`);
                    }
                    else {
                        return result.map((r) => {
                            return r == null ||
                                r.constructor.name === memberConstructor.prototype.constructor.name
                                ? r
                                : memberConverter(Object.create(memberConstructor.prototype, Object.getOwnPropertyDescriptors(r)));
                        });
                    }
                });
            },
        };
    };
}
function withPrototypeForObjectValues(valuesConstructor, valuesConverter = (i) => i) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        return {
            value: function (...args) {
                const originalResult = originalMethod.apply(this, args);
                if (!utils_Utils.isPromise(originalResult)) {
                    throw new Error(`Error applying prototype to stored value -- result is not a promise for method ${String(propertyKey)}`);
                }
                return originalResult.then((result) => {
                    if (result == null) {
                        return null;
                    }
                    else {
                        for (const [key, val] of Object.entries(result)) {
                            result[key] =
                                val == null || val.constructor.name === valuesConstructor.prototype.constructor.name
                                    ? valuesConverter(val)
                                    : valuesConverter(Object.create(valuesConstructor.prototype, Object.getOwnPropertyDescriptors(val)));
                        }
                        return result;
                    }
                });
            },
        };
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/services/stateMigration.service.ts
var stateMigration_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



// Originally (before January 2022) storage was handled as a flat key/value pair store.
// With the move to a typed object for state storage these keys should no longer be in use anywhere outside of this migration.
const v1Keys = {
    accessToken: "accessToken",
    alwaysShowDock: "alwaysShowDock",
    autoConfirmFingerprints: "autoConfirmFingerprints",
    autoFillOnPageLoadDefault: "autoFillOnPageLoadDefault",
    biometricAwaitingAcceptance: "biometricAwaitingAcceptance",
    biometricFingerprintValidated: "biometricFingerprintValidated",
    biometricText: "biometricText",
    biometricUnlock: "biometric",
    clearClipboard: "clearClipboardKey",
    clientId: "apikey_clientId",
    clientSecret: "apikey_clientSecret",
    collapsedGroupings: "collapsedGroupings",
    convertAccountToKeyConnector: "convertAccountToKeyConnector",
    defaultUriMatch: "defaultUriMatch",
    disableAddLoginNotification: "disableAddLoginNotification",
    disableAutoBiometricsPrompt: "noAutoPromptBiometrics",
    disableAutoTotpCopy: "disableAutoTotpCopy",
    disableBadgeCounter: "disableBadgeCounter",
    disableChangedPasswordNotification: "disableChangedPasswordNotification",
    disableContextMenuItem: "disableContextMenuItem",
    disableFavicon: "disableFavicon",
    disableGa: "disableGa",
    dontShowCardsCurrentTab: "dontShowCardsCurrentTab",
    dontShowIdentitiesCurrentTab: "dontShowIdentitiesCurrentTab",
    emailVerified: "emailVerified",
    enableAlwaysOnTop: "enableAlwaysOnTopKey",
    enableAutoFillOnPageLoad: "enableAutoFillOnPageLoad",
    enableBiometric: "enabledBiometric",
    enableBrowserIntegration: "enableBrowserIntegration",
    enableBrowserIntegrationFingerprint: "enableBrowserIntegrationFingerprint",
    enableCloseToTray: "enableCloseToTray",
    enableFullWidth: "enableFullWidth",
    enableMinimizeToTray: "enableMinimizeToTray",
    enableStartToTray: "enableStartToTrayKey",
    enableTray: "enableTray",
    encKey: "encKey",
    encOrgKeys: "encOrgKeys",
    encPrivate: "encPrivateKey",
    encProviderKeys: "encProviderKeys",
    entityId: "entityId",
    entityType: "entityType",
    environmentUrls: "environmentUrls",
    equivalentDomains: "equivalentDomains",
    eventCollection: "eventCollection",
    forcePasswordReset: "forcePasswordReset",
    history: "generatedPasswordHistory",
    installedVersion: "installedVersion",
    kdf: "kdf",
    kdfIterations: "kdfIterations",
    key: "key",
    keyHash: "keyHash",
    lastActive: "lastActive",
    localData: "sitesLocalData",
    locale: "locale",
    mainWindowSize: "mainWindowSize",
    minimizeOnCopyToClipboard: "minimizeOnCopyToClipboardKey",
    neverDomains: "neverDomains",
    noAutoPromptBiometricsText: "noAutoPromptBiometricsText",
    openAtLogin: "openAtLogin",
    passwordGenerationOptions: "passwordGenerationOptions",
    pinProtected: "pinProtectedKey",
    protectedPin: "protectedPin",
    refreshToken: "refreshToken",
    ssoCodeVerifier: "ssoCodeVerifier",
    ssoIdentifier: "ssoOrgIdentifier",
    ssoState: "ssoState",
    stamp: "securityStamp",
    theme: "theme",
    userEmail: "userEmail",
    userId: "userId",
    usesConnector: "usesKeyConnector",
    vaultTimeoutAction: "vaultTimeoutAction",
    vaultTimeout: "lockOption",
    rememberedEmail: "rememberedEmail",
};
const v1KeyPrefixes = {
    ciphers: "ciphers_",
    collections: "collections_",
    folders: "folders_",
    lastSync: "lastSync_",
    policies: "policies_",
    twoFactorToken: "twoFactorToken_",
    organizations: "organizations_",
    providers: "providers_",
    sends: "sends_",
    settings: "settings_",
};
const stateMigration_service_keys = {
    global: "global",
    authenticatedAccounts: "authenticatedAccounts",
    activeUserId: "activeUserId",
    tempAccountSettings: "tempAccountSettings",
    accountActivity: "accountActivity",
};
const stateMigration_service_partialKeys = {
    autoKey: "_masterkey_auto",
    biometricKey: "_masterkey_biometric",
    masterKey: "_masterkey",
};
class StateMigrationService {
    constructor(storageService, secureStorageService, stateFactory) {
        this.storageService = storageService;
        this.secureStorageService = secureStorageService;
        this.stateFactory = stateFactory;
    }
    needsMigration() {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            const currentStateVersion = yield this.getCurrentStateVersion();
            return currentStateVersion == null || currentStateVersion < StateVersion.Latest;
        });
    }
    migrate() {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            let currentStateVersion = yield this.getCurrentStateVersion();
            while (currentStateVersion < StateVersion.Latest) {
                switch (currentStateVersion) {
                    case StateVersion.One:
                        yield this.migrateStateFrom1To2();
                        break;
                    case StateVersion.Two:
                        yield this.migrateStateFrom2To3();
                        break;
                    case StateVersion.Three:
                        yield this.migrateStateFrom3To4();
                        break;
                    case StateVersion.Four: {
                        const authenticatedAccounts = yield this.getAuthenticatedAccounts();
                        for (const account of authenticatedAccounts) {
                            const migratedAccount = yield this.migrateAccountFrom4To5(account);
                            yield this.set(account.profile.userId, migratedAccount);
                        }
                        yield this.setCurrentStateVersion(StateVersion.Five);
                        break;
                    }
                    case StateVersion.Five: {
                        const authenticatedAccounts = yield this.getAuthenticatedAccounts();
                        for (const account of authenticatedAccounts) {
                            const migratedAccount = yield this.migrateAccountFrom5To6(account);
                            yield this.set(account.profile.userId, migratedAccount);
                        }
                        yield this.setCurrentStateVersion(StateVersion.Six);
                        break;
                    }
                    case StateVersion.Six: {
                        const authenticatedAccounts = yield this.getAuthenticatedAccounts();
                        const globals = (yield this.getGlobals());
                        for (const account of authenticatedAccounts) {
                            const migratedAccount = yield this.migrateAccountFrom6To7(globals === null || globals === void 0 ? void 0 : globals.noAutoPromptBiometrics, account);
                            yield this.set(account.profile.userId, migratedAccount);
                        }
                        if (globals) {
                            delete globals.noAutoPromptBiometrics;
                        }
                        yield this.set(stateMigration_service_keys.global, globals);
                        yield this.setCurrentStateVersion(StateVersion.Seven);
                    }
                }
                currentStateVersion += 1;
            }
        });
    }
    migrateStateFrom1To2() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22;
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            const clearV1Keys = (clearingUserId) => stateMigration_service_awaiter(this, void 0, void 0, function* () {
                for (const key in v1Keys) {
                    if (key == null) {
                        continue;
                    }
                    yield this.set(v1Keys[key], null);
                }
                if (clearingUserId != null) {
                    for (const keyPrefix in v1KeyPrefixes) {
                        if (keyPrefix == null) {
                            continue;
                        }
                        yield this.set(v1KeyPrefixes[keyPrefix] + userId, null);
                    }
                }
            });
            // Some processes, like biometrics, may have already defined a value before migrations are run.
            // We don't want to null out those values if they don't exist in the old storage scheme (like for new installs)
            // So, the OOO for migration is that we:
            // 1. Check for an existing storage value from the old storage structure OR
            // 2. Check for a value already set by processes that run before migration OR
            // 3. Assign the default value
            const globals = (_a = (yield this.get(stateMigration_service_keys.global))) !== null && _a !== void 0 ? _a : this.stateFactory.createGlobal(null);
            globals.stateVersion = StateVersion.Two;
            globals.environmentUrls =
                (_b = (yield this.get(v1Keys.environmentUrls))) !== null && _b !== void 0 ? _b : globals.environmentUrls;
            globals.locale = (_c = (yield this.get(v1Keys.locale))) !== null && _c !== void 0 ? _c : globals.locale;
            globals.noAutoPromptBiometrics =
                (_d = (yield this.get(v1Keys.disableAutoBiometricsPrompt))) !== null && _d !== void 0 ? _d : globals.noAutoPromptBiometrics;
            globals.noAutoPromptBiometricsText =
                (_e = (yield this.get(v1Keys.noAutoPromptBiometricsText))) !== null && _e !== void 0 ? _e : globals.noAutoPromptBiometricsText;
            globals.ssoCodeVerifier =
                (_f = (yield this.get(v1Keys.ssoCodeVerifier))) !== null && _f !== void 0 ? _f : globals.ssoCodeVerifier;
            globals.ssoOrganizationIdentifier =
                (_g = (yield this.get(v1Keys.ssoIdentifier))) !== null && _g !== void 0 ? _g : globals.ssoOrganizationIdentifier;
            globals.ssoState = (_h = (yield this.get(v1Keys.ssoState))) !== null && _h !== void 0 ? _h : globals.ssoState;
            globals.rememberedEmail =
                (_j = (yield this.get(v1Keys.rememberedEmail))) !== null && _j !== void 0 ? _j : globals.rememberedEmail;
            globals.theme = (_k = (yield this.get(v1Keys.theme))) !== null && _k !== void 0 ? _k : globals.theme;
            globals.vaultTimeout = (_l = (yield this.get(v1Keys.vaultTimeout))) !== null && _l !== void 0 ? _l : globals.vaultTimeout;
            globals.vaultTimeoutAction =
                (_m = (yield this.get(v1Keys.vaultTimeoutAction))) !== null && _m !== void 0 ? _m : globals.vaultTimeoutAction;
            globals.window = (_o = (yield this.get(v1Keys.mainWindowSize))) !== null && _o !== void 0 ? _o : globals.window;
            globals.enableTray = (_p = (yield this.get(v1Keys.enableTray))) !== null && _p !== void 0 ? _p : globals.enableTray;
            globals.enableMinimizeToTray =
                (_q = (yield this.get(v1Keys.enableMinimizeToTray))) !== null && _q !== void 0 ? _q : globals.enableMinimizeToTray;
            globals.enableCloseToTray =
                (_r = (yield this.get(v1Keys.enableCloseToTray))) !== null && _r !== void 0 ? _r : globals.enableCloseToTray;
            globals.enableStartToTray =
                (_s = (yield this.get(v1Keys.enableStartToTray))) !== null && _s !== void 0 ? _s : globals.enableStartToTray;
            globals.openAtLogin = (_t = (yield this.get(v1Keys.openAtLogin))) !== null && _t !== void 0 ? _t : globals.openAtLogin;
            globals.alwaysShowDock =
                (_u = (yield this.get(v1Keys.alwaysShowDock))) !== null && _u !== void 0 ? _u : globals.alwaysShowDock;
            globals.enableBrowserIntegration =
                (_v = (yield this.get(v1Keys.enableBrowserIntegration))) !== null && _v !== void 0 ? _v : globals.enableBrowserIntegration;
            globals.enableBrowserIntegrationFingerprint =
                (_w = (yield this.get(v1Keys.enableBrowserIntegrationFingerprint))) !== null && _w !== void 0 ? _w : globals.enableBrowserIntegrationFingerprint;
            const userId = (_x = (yield this.get(v1Keys.userId))) !== null && _x !== void 0 ? _x : (yield this.get(v1Keys.entityId));
            const defaultAccount = this.stateFactory.createAccount(null);
            const accountSettings = {
                autoConfirmFingerPrints: (_y = (yield this.get(v1Keys.autoConfirmFingerprints))) !== null && _y !== void 0 ? _y : defaultAccount.settings.autoConfirmFingerPrints,
                autoFillOnPageLoadDefault: (_z = (yield this.get(v1Keys.autoFillOnPageLoadDefault))) !== null && _z !== void 0 ? _z : defaultAccount.settings.autoFillOnPageLoadDefault,
                biometricUnlock: (_0 = (yield this.get(v1Keys.biometricUnlock))) !== null && _0 !== void 0 ? _0 : defaultAccount.settings.biometricUnlock,
                clearClipboard: (_1 = (yield this.get(v1Keys.clearClipboard))) !== null && _1 !== void 0 ? _1 : defaultAccount.settings.clearClipboard,
                defaultUriMatch: (_2 = (yield this.get(v1Keys.defaultUriMatch))) !== null && _2 !== void 0 ? _2 : defaultAccount.settings.defaultUriMatch,
                disableAddLoginNotification: (_3 = (yield this.get(v1Keys.disableAddLoginNotification))) !== null && _3 !== void 0 ? _3 : defaultAccount.settings.disableAddLoginNotification,
                disableAutoBiometricsPrompt: (_4 = (yield this.get(v1Keys.disableAutoBiometricsPrompt))) !== null && _4 !== void 0 ? _4 : defaultAccount.settings.disableAutoBiometricsPrompt,
                disableAutoTotpCopy: (_5 = (yield this.get(v1Keys.disableAutoTotpCopy))) !== null && _5 !== void 0 ? _5 : defaultAccount.settings.disableAutoTotpCopy,
                disableBadgeCounter: (_6 = (yield this.get(v1Keys.disableBadgeCounter))) !== null && _6 !== void 0 ? _6 : defaultAccount.settings.disableBadgeCounter,
                disableChangedPasswordNotification: (_7 = (yield this.get(v1Keys.disableChangedPasswordNotification))) !== null && _7 !== void 0 ? _7 : defaultAccount.settings.disableChangedPasswordNotification,
                disableContextMenuItem: (_8 = (yield this.get(v1Keys.disableContextMenuItem))) !== null && _8 !== void 0 ? _8 : defaultAccount.settings.disableContextMenuItem,
                disableGa: (_9 = (yield this.get(v1Keys.disableGa))) !== null && _9 !== void 0 ? _9 : defaultAccount.settings.disableGa,
                dontShowCardsCurrentTab: (_10 = (yield this.get(v1Keys.dontShowCardsCurrentTab))) !== null && _10 !== void 0 ? _10 : defaultAccount.settings.dontShowCardsCurrentTab,
                dontShowIdentitiesCurrentTab: (_11 = (yield this.get(v1Keys.dontShowIdentitiesCurrentTab))) !== null && _11 !== void 0 ? _11 : defaultAccount.settings.dontShowIdentitiesCurrentTab,
                enableAlwaysOnTop: (_12 = (yield this.get(v1Keys.enableAlwaysOnTop))) !== null && _12 !== void 0 ? _12 : defaultAccount.settings.enableAlwaysOnTop,
                enableAutoFillOnPageLoad: (_13 = (yield this.get(v1Keys.enableAutoFillOnPageLoad))) !== null && _13 !== void 0 ? _13 : defaultAccount.settings.enableAutoFillOnPageLoad,
                enableBiometric: (_14 = (yield this.get(v1Keys.enableBiometric))) !== null && _14 !== void 0 ? _14 : defaultAccount.settings.enableBiometric,
                enableFullWidth: (_15 = (yield this.get(v1Keys.enableFullWidth))) !== null && _15 !== void 0 ? _15 : defaultAccount.settings.enableFullWidth,
                environmentUrls: (_16 = globals.environmentUrls) !== null && _16 !== void 0 ? _16 : defaultAccount.settings.environmentUrls,
                equivalentDomains: (_17 = (yield this.get(v1Keys.equivalentDomains))) !== null && _17 !== void 0 ? _17 : defaultAccount.settings.equivalentDomains,
                minimizeOnCopyToClipboard: (_18 = (yield this.get(v1Keys.minimizeOnCopyToClipboard))) !== null && _18 !== void 0 ? _18 : defaultAccount.settings.minimizeOnCopyToClipboard,
                neverDomains: (_19 = (yield this.get(v1Keys.neverDomains))) !== null && _19 !== void 0 ? _19 : defaultAccount.settings.neverDomains,
                passwordGenerationOptions: (_20 = (yield this.get(v1Keys.passwordGenerationOptions))) !== null && _20 !== void 0 ? _20 : defaultAccount.settings.passwordGenerationOptions,
                pinProtected: Object.assign(new EncryptionPair(), {
                    decrypted: null,
                    encrypted: yield this.get(v1Keys.pinProtected),
                }),
                protectedPin: yield this.get(v1Keys.protectedPin),
                settings: userId == null
                    ? null
                    : yield this.get(v1KeyPrefixes.settings + userId),
                vaultTimeout: (_21 = (yield this.get(v1Keys.vaultTimeout))) !== null && _21 !== void 0 ? _21 : defaultAccount.settings.vaultTimeout,
                vaultTimeoutAction: (_22 = (yield this.get(v1Keys.vaultTimeoutAction))) !== null && _22 !== void 0 ? _22 : defaultAccount.settings.vaultTimeoutAction,
            };
            // (userId == null) = no logged in user (so no known userId) and we need to temporarily store account specific settings in state to migrate on first auth
            // (userId != null) = we have a currently authed user (so known userId) with encrypted data and other key settings we can move, no need to temporarily store account settings
            if (userId == null) {
                yield this.set(stateMigration_service_keys.tempAccountSettings, accountSettings);
                yield this.set(stateMigration_service_keys.global, globals);
                yield this.set(stateMigration_service_keys.authenticatedAccounts, []);
                yield this.set(stateMigration_service_keys.activeUserId, null);
                yield clearV1Keys();
                return;
            }
            globals.twoFactorToken = yield this.get(v1KeyPrefixes.twoFactorToken + userId);
            yield this.set(stateMigration_service_keys.global, globals);
            yield this.set(userId, {
                data: {
                    addEditCipherInfo: null,
                    ciphers: {
                        decrypted: null,
                        encrypted: yield this.get(v1KeyPrefixes.ciphers + userId),
                    },
                    collapsedGroupings: null,
                    collections: {
                        decrypted: null,
                        encrypted: yield this.get(v1KeyPrefixes.collections + userId),
                    },
                    eventCollection: yield this.get(v1Keys.eventCollection),
                    folders: {
                        decrypted: null,
                        encrypted: yield this.get(v1KeyPrefixes.folders + userId),
                    },
                    localData: null,
                    organizations: yield this.get(v1KeyPrefixes.organizations + userId),
                    passwordGenerationHistory: {
                        decrypted: null,
                        encrypted: yield this.get(v1Keys.history),
                    },
                    policies: {
                        decrypted: null,
                        encrypted: yield this.get(v1KeyPrefixes.policies + userId),
                    },
                    providers: yield this.get(v1KeyPrefixes.providers + userId),
                    sends: {
                        decrypted: null,
                        encrypted: yield this.get(v1KeyPrefixes.sends + userId),
                    },
                },
                keys: {
                    apiKeyClientSecret: yield this.get(v1Keys.clientSecret),
                    cryptoMasterKey: null,
                    cryptoMasterKeyAuto: null,
                    cryptoMasterKeyB64: null,
                    cryptoMasterKeyBiometric: null,
                    cryptoSymmetricKey: {
                        encrypted: yield this.get(v1Keys.encKey),
                        decrypted: null,
                    },
                    legacyEtmKey: null,
                    organizationKeys: {
                        decrypted: null,
                        encrypted: yield this.get(v1Keys.encOrgKeys),
                    },
                    privateKey: {
                        decrypted: null,
                        encrypted: yield this.get(v1Keys.encPrivate),
                    },
                    providerKeys: {
                        decrypted: null,
                        encrypted: yield this.get(v1Keys.encProviderKeys),
                    },
                    publicKey: null,
                },
                profile: {
                    apiKeyClientId: yield this.get(v1Keys.clientId),
                    authenticationStatus: null,
                    convertAccountToKeyConnector: yield this.get(v1Keys.convertAccountToKeyConnector),
                    email: yield this.get(v1Keys.userEmail),
                    emailVerified: yield this.get(v1Keys.emailVerified),
                    entityId: null,
                    entityType: null,
                    everBeenUnlocked: null,
                    forcePasswordReset: null,
                    hasPremiumPersonally: null,
                    kdfIterations: yield this.get(v1Keys.kdfIterations),
                    kdfType: yield this.get(v1Keys.kdf),
                    keyHash: yield this.get(v1Keys.keyHash),
                    lastSync: null,
                    userId: userId,
                    usesKeyConnector: null,
                },
                settings: accountSettings,
                tokens: {
                    accessToken: yield this.get(v1Keys.accessToken),
                    decodedToken: null,
                    refreshToken: yield this.get(v1Keys.refreshToken),
                    securityStamp: null,
                },
            });
            yield this.set(stateMigration_service_keys.authenticatedAccounts, [userId]);
            yield this.set(stateMigration_service_keys.activeUserId, userId);
            const accountActivity = {
                [userId]: yield this.get(v1Keys.lastActive),
            };
            accountActivity[userId] = yield this.get(v1Keys.lastActive);
            yield this.set(stateMigration_service_keys.accountActivity, accountActivity);
            yield clearV1Keys(userId);
            if (yield this.secureStorageService.has(v1Keys.key, { keySuffix: "biometric" })) {
                yield this.secureStorageService.save(`${userId}${stateMigration_service_partialKeys.biometricKey}`, yield this.secureStorageService.get(v1Keys.key, { keySuffix: "biometric" }), { keySuffix: "biometric" });
                yield this.secureStorageService.remove(v1Keys.key, { keySuffix: "biometric" });
            }
            if (yield this.secureStorageService.has(v1Keys.key, { keySuffix: "auto" })) {
                yield this.secureStorageService.save(`${userId}${stateMigration_service_partialKeys.autoKey}`, yield this.secureStorageService.get(v1Keys.key, { keySuffix: "auto" }), { keySuffix: "auto" });
                yield this.secureStorageService.remove(v1Keys.key, { keySuffix: "auto" });
            }
            if (yield this.secureStorageService.has(v1Keys.key)) {
                yield this.secureStorageService.save(`${userId}${stateMigration_service_partialKeys.masterKey}`, yield this.secureStorageService.get(v1Keys.key));
                yield this.secureStorageService.remove(v1Keys.key);
            }
        });
    }
    migrateStateFrom2To3() {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            const authenticatedUserIds = yield this.get(stateMigration_service_keys.authenticatedAccounts);
            yield Promise.all(authenticatedUserIds.map((userId) => stateMigration_service_awaiter(this, void 0, void 0, function* () {
                var _a, _b;
                const account = yield this.get(userId);
                if (((_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumPersonally) === null &&
                    ((_b = account.tokens) === null || _b === void 0 ? void 0 : _b.accessToken) != null) {
                    const decodedToken = yield TokenService.decodeToken(account.tokens.accessToken);
                    account.profile.hasPremiumPersonally = decodedToken.premium;
                    yield this.set(userId, account);
                }
            })));
            const globals = yield this.getGlobals();
            globals.stateVersion = StateVersion.Three;
            yield this.set(stateMigration_service_keys.global, globals);
        });
    }
    migrateStateFrom3To4() {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            const authenticatedUserIds = yield this.get(stateMigration_service_keys.authenticatedAccounts);
            yield Promise.all(authenticatedUserIds.map((userId) => stateMigration_service_awaiter(this, void 0, void 0, function* () {
                var _a;
                const account = yield this.get(userId);
                if (((_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.everBeenUnlocked) != null) {
                    delete account.profile.everBeenUnlocked;
                    return this.set(userId, account);
                }
            })));
            const globals = yield this.getGlobals();
            globals.stateVersion = StateVersion.Four;
            yield this.set(stateMigration_service_keys.global, globals);
        });
    }
    migrateAccountFrom4To5(account) {
        var _a, _b;
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            const encryptedOrgKeys = (_b = (_a = account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
            if (encryptedOrgKeys != null) {
                for (const [orgId, encKey] of Object.entries(encryptedOrgKeys)) {
                    encryptedOrgKeys[orgId] = {
                        type: "organization",
                        key: encKey, // Account v4 does not reflect the current account model so we have to cast
                    };
                }
            }
            return account;
        });
    }
    migrateAccountFrom5To6(account) {
        var _a;
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            (_a = account.keys) === null || _a === void 0 ? true : delete _a.legacyEtmKey;
            return account;
        });
    }
    migrateAccountFrom6To7(globalSetting, account) {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            if (globalSetting) {
                account.settings = Object.assign({}, account.settings, { disableAutoBiometricsPrompt: true });
            }
            return account;
        });
    }
    get options() {
        return { htmlStorageLocation: HtmlStorageLocation.Local };
    }
    get(key) {
        return this.storageService.get(key, this.options);
    }
    set(key, value) {
        if (value == null) {
            return this.storageService.remove(key, this.options);
        }
        return this.storageService.save(key, value, this.options);
    }
    getGlobals() {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            return yield this.get(stateMigration_service_keys.global);
        });
    }
    getCurrentStateVersion() {
        var _a, _b;
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getGlobals())) === null || _a === void 0 ? void 0 : _a.stateVersion) !== null && _b !== void 0 ? _b : StateVersion.One;
        });
    }
    setCurrentStateVersion(newVersion) {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals();
            globals.stateVersion = newVersion;
            yield this.set(stateMigration_service_keys.global, globals);
        });
    }
    getAuthenticatedAccounts() {
        return stateMigration_service_awaiter(this, void 0, void 0, function* () {
            const authenticatedUserIds = yield this.get(stateMigration_service_keys.authenticatedAccounts);
            return Promise.all(authenticatedUserIds.map((id) => this.get(id)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/totp.service.ts
var totp_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const B32Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
const SteamChars = "23456789BCDFGHJKMNPQRTVWXY";
class TotpService {
    constructor(cryptoFunctionService, logService) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.logService = logService;
    }
    getCode(key) {
        return totp_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                return null;
            }
            let period = 30;
            let alg = "sha1";
            let digits = 6;
            let keyB32 = key;
            const isOtpAuth = key.toLowerCase().indexOf("otpauth://") === 0;
            const isSteamAuth = !isOtpAuth && key.toLowerCase().indexOf("steam://") === 0;
            if (isOtpAuth) {
                const params = utils_Utils.getQueryParams(key);
                if (params.has("digits") && params.get("digits") != null) {
                    try {
                        const digitParams = parseInt(params.get("digits").trim(), null);
                        if (digitParams > 10) {
                            digits = 10;
                        }
                        else if (digitParams > 0) {
                            digits = digitParams;
                        }
                    }
                    catch (_a) {
                        this.logService.error("Invalid digits param.");
                    }
                }
                if (params.has("period") && params.get("period") != null) {
                    try {
                        const periodParam = parseInt(params.get("period").trim(), null);
                        if (periodParam > 0) {
                            period = periodParam;
                        }
                    }
                    catch (_b) {
                        this.logService.error("Invalid period param.");
                    }
                }
                if (params.has("secret") && params.get("secret") != null) {
                    keyB32 = params.get("secret");
                }
                if (params.has("algorithm") && params.get("algorithm") != null) {
                    const algParam = params.get("algorithm").toLowerCase();
                    if (algParam === "sha1" || algParam === "sha256" || algParam === "sha512") {
                        alg = algParam;
                    }
                }
            }
            else if (isSteamAuth) {
                keyB32 = key.substr("steam://".length);
                digits = 5;
            }
            const epoch = Math.round(new Date().getTime() / 1000.0);
            const timeHex = this.leftPad(this.decToHex(Math.floor(epoch / period)), 16, "0");
            const timeBytes = utils_Utils.fromHexToArray(timeHex);
            const keyBytes = this.b32ToBytes(keyB32);
            if (!keyBytes.length || !timeBytes.length) {
                return null;
            }
            const hash = yield this.sign(keyBytes, timeBytes, alg);
            if (hash.length === 0) {
                return null;
            }
            const offset = hash[hash.length - 1] & 0xf;
            const binary = ((hash[offset] & 0x7f) << 24) |
                ((hash[offset + 1] & 0xff) << 16) |
                ((hash[offset + 2] & 0xff) << 8) |
                (hash[offset + 3] & 0xff);
            let otp = "";
            if (isSteamAuth) {
                let fullCode = binary & 0x7fffffff;
                for (let i = 0; i < digits; i++) {
                    otp += SteamChars[fullCode % SteamChars.length];
                    fullCode = Math.trunc(fullCode / SteamChars.length);
                }
            }
            else {
                otp = (binary % Math.pow(10, digits)).toString();
                otp = this.leftPad(otp, digits, "0");
            }
            return otp;
        });
    }
    getTimeInterval(key) {
        let period = 30;
        if (key != null && key.toLowerCase().indexOf("otpauth://") === 0) {
            const params = utils_Utils.getQueryParams(key);
            if (params.has("period") && params.get("period") != null) {
                try {
                    period = parseInt(params.get("period").trim(), null);
                }
                catch (_a) {
                    this.logService.error("Invalid period param.");
                }
            }
        }
        return period;
    }
    // Helpers
    leftPad(s, l, p) {
        if (l + 1 >= s.length) {
            s = Array(l + 1 - s.length).join(p) + s;
        }
        return s;
    }
    decToHex(d) {
        return (d < 15.5 ? "0" : "") + Math.round(d).toString(16);
    }
    b32ToHex(s) {
        s = s.toUpperCase();
        let cleanedInput = "";
        for (let i = 0; i < s.length; i++) {
            if (B32Chars.indexOf(s[i]) < 0) {
                continue;
            }
            cleanedInput += s[i];
        }
        s = cleanedInput;
        let bits = "";
        let hex = "";
        for (let i = 0; i < s.length; i++) {
            const byteIndex = B32Chars.indexOf(s.charAt(i));
            if (byteIndex < 0) {
                continue;
            }
            bits += this.leftPad(byteIndex.toString(2), 5, "0");
        }
        for (let i = 0; i + 4 <= bits.length; i += 4) {
            const chunk = bits.substr(i, 4);
            hex = hex + parseInt(chunk, 2).toString(16);
        }
        return hex;
    }
    b32ToBytes(s) {
        return utils_Utils.fromHexToArray(this.b32ToHex(s));
    }
    sign(keyBytes, timeBytes, alg) {
        return totp_service_awaiter(this, void 0, void 0, function* () {
            const signature = yield this.cryptoFunctionService.hmac(timeBytes.buffer, keyBytes.buffer, alg);
            return new Uint8Array(signature);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/vaultTimeout/vaultTimeout.service.ts
var vaultTimeout_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class VaultTimeoutService {
    constructor(cipherService, folderService, collectionService, cryptoService, platformUtilsService, messagingService, searchService, keyConnectorService, stateService, authService, vaultTimeoutSettingsService, lockedCallback = null, loggedOutCallback = null) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.collectionService = collectionService;
        this.cryptoService = cryptoService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.searchService = searchService;
        this.keyConnectorService = keyConnectorService;
        this.stateService = stateService;
        this.authService = authService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.lockedCallback = lockedCallback;
        this.loggedOutCallback = loggedOutCallback;
        this.inited = false;
    }
    init(checkOnInterval) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        if (checkOnInterval) {
            this.startCheck();
        }
    }
    startCheck() {
        this.checkVaultTimeout();
        setInterval(() => this.checkVaultTimeout(), 10 * 1000); // check every 10 seconds
    }
    checkVaultTimeout() {
        return vaultTimeout_service_awaiter(this, void 0, void 0, function* () {
            if (yield this.platformUtilsService.isViewOpen()) {
                return;
            }
            const accounts = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateService.accounts$);
            for (const userId in accounts) {
                if (userId != null && (yield this.shouldLock(userId))) {
                    yield this.executeTimeoutAction(userId);
                }
            }
        });
    }
    lock(userId) {
        return vaultTimeout_service_awaiter(this, void 0, void 0, function* () {
            const authed = yield this.stateService.getIsAuthenticated({ userId: userId });
            if (!authed) {
                return;
            }
            if (yield this.keyConnectorService.getUsesKeyConnector()) {
                const pinSet = yield this.vaultTimeoutSettingsService.isPinLockSet();
                const pinLock = (pinSet[0] && (yield this.stateService.getDecryptedPinProtected()) != null) || pinSet[1];
                if (!pinLock && !(yield this.vaultTimeoutSettingsService.isBiometricLockSet())) {
                    yield this.logOut(userId);
                }
            }
            if (userId == null || userId === (yield this.stateService.getUserId())) {
                this.searchService.clearIndex();
                yield this.folderService.clearCache();
            }
            yield this.stateService.setEverBeenUnlocked(true, { userId: userId });
            yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            yield this.cryptoService.clearKey(false, userId);
            yield this.cryptoService.clearOrgKeys(true, userId);
            yield this.cryptoService.clearKeyPair(true, userId);
            yield this.cryptoService.clearEncKey(true, userId);
            yield this.cipherService.clearCache(userId);
            yield this.collectionService.clearCache(userId);
            this.messagingService.send("locked", { userId: userId });
            if (this.lockedCallback != null) {
                yield this.lockedCallback(userId);
            }
        });
    }
    logOut(userId) {
        return vaultTimeout_service_awaiter(this, void 0, void 0, function* () {
            if (this.loggedOutCallback != null) {
                yield this.loggedOutCallback(false, userId);
            }
        });
    }
    shouldLock(userId) {
        return vaultTimeout_service_awaiter(this, void 0, void 0, function* () {
            const authStatus = yield this.authService.getAuthStatus(userId);
            if (authStatus === AuthenticationStatus.Locked ||
                authStatus === AuthenticationStatus.LoggedOut) {
                return false;
            }
            const vaultTimeout = yield this.vaultTimeoutSettingsService.getVaultTimeout(userId);
            if (vaultTimeout == null || vaultTimeout < 0) {
                return false;
            }
            const lastActive = yield this.stateService.getLastActive({ userId: userId });
            if (lastActive == null) {
                return false;
            }
            const vaultTimeoutSeconds = vaultTimeout * 60;
            const diffSeconds = (new Date().getTime() - lastActive) / 1000;
            return diffSeconds >= vaultTimeoutSeconds;
        });
    }
    executeTimeoutAction(userId) {
        return vaultTimeout_service_awaiter(this, void 0, void 0, function* () {
            const timeoutAction = yield this.vaultTimeoutSettingsService.getVaultTimeoutAction(userId);
            timeoutAction === VaultTimeoutAction.LogOut
                ? yield this.logOut(userId)
                : yield this.lock(userId);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/vaultTimeout/vaultTimeoutSettings.service.ts
var vaultTimeoutSettings_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class VaultTimeoutSettingsService {
    constructor(cryptoService, tokenService, policyService, stateService) {
        this.cryptoService = cryptoService;
        this.tokenService = tokenService;
        this.policyService = policyService;
        this.stateService = stateService;
    }
    setVaultTimeoutOptions(timeout, action) {
        return vaultTimeoutSettings_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setVaultTimeout(timeout);
            // We swap these tokens from being on disk for lock actions, and in memory for logout actions
            // Get them here to set them to their new location after changing the timeout action and clearing if needed
            const token = yield this.tokenService.getToken();
            const refreshToken = yield this.tokenService.getRefreshToken();
            const clientId = yield this.tokenService.getClientId();
            const clientSecret = yield this.tokenService.getClientSecret();
            const currentAction = yield this.stateService.getVaultTimeoutAction();
            if ((timeout != null || timeout === 0) &&
                action === VaultTimeoutAction.LogOut &&
                action !== currentAction) {
                // if we have a vault timeout and the action is log out, reset tokens
                yield this.tokenService.clearToken();
            }
            yield this.stateService.setVaultTimeoutAction(action);
            yield this.tokenService.setToken(token);
            yield this.tokenService.setRefreshToken(refreshToken);
            yield this.tokenService.setClientId(clientId);
            yield this.tokenService.setClientSecret(clientSecret);
            yield this.cryptoService.toggleKey();
        });
    }
    isPinLockSet() {
        return vaultTimeoutSettings_service_awaiter(this, void 0, void 0, function* () {
            const protectedPin = yield this.stateService.getProtectedPin();
            const pinProtectedKey = yield this.stateService.getEncryptedPinProtected();
            return [protectedPin != null, pinProtectedKey != null];
        });
    }
    isBiometricLockSet() {
        return vaultTimeoutSettings_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getBiometricUnlock();
        });
    }
    getVaultTimeout(userId) {
        return vaultTimeoutSettings_service_awaiter(this, void 0, void 0, function* () {
            const vaultTimeout = yield this.stateService.getVaultTimeout({ userId: userId });
            if (yield this.policyService.policyAppliesToUser(PolicyType.MaximumVaultTimeout, null, userId)) {
                const policy = yield this.policyService.getAll(PolicyType.MaximumVaultTimeout, userId);
                // Remove negative values, and ensure it's smaller than maximum allowed value according to policy
                let timeout = Math.min(vaultTimeout, policy[0].data.minutes);
                if (vaultTimeout == null || timeout < 0) {
                    timeout = policy[0].data.minutes;
                }
                // We really shouldn't need to set the value here, but multiple services relies on this value being correct.
                if (vaultTimeout !== timeout) {
                    yield this.stateService.setVaultTimeout(timeout, { userId: userId });
                }
                return timeout;
            }
            return vaultTimeout;
        });
    }
    getVaultTimeoutAction(userId) {
        return vaultTimeoutSettings_service_awaiter(this, void 0, void 0, function* () {
            let vaultTimeoutAction = yield this.stateService.getVaultTimeoutAction({ userId: userId });
            if (yield this.policyService.policyAppliesToUser(PolicyType.MaximumVaultTimeout, null, userId)) {
                const policy = yield this.policyService.getAll(PolicyType.MaximumVaultTimeout, userId);
                const action = policy[0].data.action;
                if (action) {
                    // We really shouldn't need to set the value here, but multiple services relies on this value being correct.
                    if (action && vaultTimeoutAction !== action) {
                        yield this.stateService.setVaultTimeoutAction(action, { userId: userId });
                    }
                    vaultTimeoutAction = action;
                }
            }
            return vaultTimeoutAction === VaultTimeoutAction.LogOut
                ? VaultTimeoutAction.LogOut
                : VaultTimeoutAction.Lock;
        });
    }
    clear(userId) {
        return vaultTimeoutSettings_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setEverBeenUnlocked(false, { userId: userId });
            yield this.stateService.setDecryptedPinProtected(null, { userId: userId });
            yield this.stateService.setProtectedPin(null, { userId: userId });
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/api/send-file.api.ts

class SendFileApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.id = this.getResponseProperty("Id");
        this.fileName = this.getResponseProperty("FileName");
        this.size = this.getResponseProperty("Size");
        this.sizeName = this.getResponseProperty("SizeName");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/api/send-text.api.ts

class SendTextApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.text = this.getResponseProperty("Text");
        this.hidden = this.getResponseProperty("Hidden") || false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/request/send.request.ts



class SendRequest {
    constructor(send, fileLength) {
        this.type = send.type;
        this.fileLength = fileLength;
        this.name = send.name ? send.name.encryptedString : null;
        this.notes = send.notes ? send.notes.encryptedString : null;
        this.maxAccessCount = send.maxAccessCount;
        this.expirationDate = send.expirationDate != null ? send.expirationDate.toISOString() : null;
        this.deletionDate = send.deletionDate != null ? send.deletionDate.toISOString() : null;
        this.key = send.key != null ? send.key.encryptedString : null;
        this.password = send.password;
        this.disabled = send.disabled;
        this.hideEmail = send.hideEmail;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendTextApi();
                this.text.text = send.text.text != null ? send.text.text.encryptedString : null;
                this.text.hidden = send.text.hidden;
                break;
            case SendType.File:
                this.file = new SendFileApi();
                this.file.fileName = send.file.fileName != null ? send.file.fileName.encryptedString : null;
                break;
            default:
                break;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send-access.response.ts



class SendAccessResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.type = this.getResponseProperty("Type");
        this.name = this.getResponseProperty("Name");
        const text = this.getResponseProperty("Text");
        if (text != null) {
            this.text = new SendTextApi(text);
        }
        const file = this.getResponseProperty("File");
        if (file != null) {
            this.file = new SendFileApi(file);
        }
        this.expirationDate = this.getResponseProperty("ExpirationDate");
        this.creatorIdentifier = this.getResponseProperty("CreatorIdentifier");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send-file-download-data.response.ts

class SendFileDownloadDataResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = null;
        this.url = null;
        this.id = this.getResponseProperty("Id");
        this.url = this.getResponseProperty("Url");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send.response.ts



class SendResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.accessId = this.getResponseProperty("AccessId");
        this.type = this.getResponseProperty("Type");
        this.name = this.getResponseProperty("Name");
        this.notes = this.getResponseProperty("Notes");
        this.key = this.getResponseProperty("Key");
        this.maxAccessCount = this.getResponseProperty("MaxAccessCount");
        this.accessCount = this.getResponseProperty("AccessCount");
        this.revisionDate = this.getResponseProperty("RevisionDate");
        this.expirationDate = this.getResponseProperty("ExpirationDate");
        this.deletionDate = this.getResponseProperty("DeletionDate");
        this.password = this.getResponseProperty("Password");
        this.disable = this.getResponseProperty("Disabled") || false;
        this.hideEmail = this.getResponseProperty("HideEmail") || false;
        const text = this.getResponseProperty("Text");
        if (text != null) {
            this.text = new SendTextApi(text);
        }
        const file = this.getResponseProperty("File");
        if (file != null) {
            this.file = new SendFileApi(file);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send-file-upload-data.response.ts


class SendFileUploadDataResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.url = null;
        this.fileUploadType = this.getResponseProperty("FileUploadType");
        const sendResponse = this.getResponseProperty("SendResponse");
        this.sendResponse = sendResponse == null ? null : new SendResponse(sendResponse);
        this.url = this.getResponseProperty("Url");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/services/send-api.service.ts
var send_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};










class SendApiService {
    constructor(apiService, fileUploadService, sendService) {
        this.apiService = apiService;
        this.fileUploadService = fileUploadService;
        this.sendService = sendService;
    }
    getSend(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/sends/" + id, null, true, true);
            return new SendResponse(r);
        });
    }
    postSendAccess(id, request, apiUrl) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const addSendIdHeader = (headers) => {
                headers.set("Send-Id", id);
            };
            const r = yield this.apiService.send("POST", "/sends/access/" + id, request, false, true, apiUrl, addSendIdHeader);
            return new SendAccessResponse(r);
        });
    }
    getSendFileDownloadData(send, request, apiUrl) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const addSendIdHeader = (headers) => {
                headers.set("Send-Id", send.id);
            };
            const r = yield this.apiService.send("POST", "/sends/" + send.id + "/access/file/" + send.file.id, request, false, true, apiUrl, addSendIdHeader);
            return new SendFileDownloadDataResponse(r);
        });
    }
    getSends() {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/sends", null, true, true);
            return new ListResponse(r, SendResponse);
        });
    }
    postSend(request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/sends", request, true, true);
            return new SendResponse(r);
        });
    }
    postFileTypeSend(request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/sends/file/v2", request, true, true);
            return new SendFileUploadDataResponse(r);
        });
    }
    renewSendFileUploadUrl(sendId, fileId) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/sends/" + sendId + "/file/" + fileId, null, true, true);
            return new SendFileUploadDataResponse(r);
        });
    }
    postSendFile(sendId, fileId, data) {
        return this.apiService.send("POST", "/sends/" + sendId + "/file/" + fileId, data, true, false);
    }
    /**
     * @deprecated Mar 25 2021: This method has been deprecated in favor of direct uploads.
     * This method still exists for backward compatibility with old server versions.
     */
    postSendFileLegacy(data) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/sends/file", data, true, true);
            return new SendResponse(r);
        });
    }
    putSend(id, request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/sends/" + id, request, true, true);
            return new SendResponse(r);
        });
    }
    putSendRemovePassword(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/sends/" + id + "/remove-password", null, true, true);
            return new SendResponse(r);
        });
    }
    deleteSend(id) {
        return this.apiService.send("DELETE", "/sends/" + id, null, true, false);
    }
    save(sendData) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.upload(sendData);
            const data = new SendData(response);
            yield this.sendService.upsert(data);
        });
    }
    delete(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.deleteSend(id);
            yield this.sendService.delete(id);
        });
    }
    removePassword(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.putSendRemovePassword(id);
            const data = new SendData(response);
            yield this.sendService.upsert(data);
        });
    }
    // Send File Upload methoids
    upload(sendData) {
        var _a;
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const request = new SendRequest(sendData[0], (_a = sendData[1]) === null || _a === void 0 ? void 0 : _a.buffer.byteLength);
            let response;
            if (sendData[0].id == null) {
                if (sendData[0].type === SendType.Text) {
                    response = yield this.postSend(request);
                }
                else {
                    try {
                        const uploadDataResponse = yield this.postFileTypeSend(request);
                        response = uploadDataResponse.sendResponse;
                        yield this.fileUploadService.upload(uploadDataResponse, sendData[0].file.fileName, sendData[1], this.generateMethods(uploadDataResponse, response));
                    }
                    catch (e) {
                        if (e instanceof ErrorResponse && e.statusCode === 404) {
                            response = yield this.legacyServerSendFileUpload(sendData, request);
                        }
                        else if (e instanceof ErrorResponse) {
                            throw new Error(e.getSingleMessage());
                        }
                        else {
                            throw e;
                        }
                    }
                }
                sendData[0].id = response.id;
                sendData[0].accessId = response.accessId;
            }
            else {
                response = yield this.putSend(sendData[0].id, request);
            }
            return response;
        });
    }
    generateMethods(uploadData, response) {
        return {
            postDirect: this.generatePostDirectCallback(response),
            renewFileUploadUrl: this.generateRenewFileUploadUrlCallback(response.id, response.file.id),
            rollback: this.generateRollbackCallback(response.id),
        };
    }
    generatePostDirectCallback(sendResponse) {
        return (data) => {
            return this.postSendFile(sendResponse.id, sendResponse.file.id, data);
        };
    }
    generateRenewFileUploadUrlCallback(sendId, fileId) {
        return () => send_api_service_awaiter(this, void 0, void 0, function* () {
            const renewResponse = yield this.renewSendFileUploadUrl(sendId, fileId);
            return renewResponse === null || renewResponse === void 0 ? void 0 : renewResponse.url;
        });
    }
    generateRollbackCallback(sendId) {
        return () => {
            return this.deleteSend(sendId);
        };
    }
    /**
     * @deprecated Mar 25 2021: This method has been deprecated in favor of direct uploads.
     * This method still exists for backward compatibility with old server versions.
     */
    legacyServerSendFileUpload(sendData, request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const fd = new FormData();
            try {
                const blob = new Blob([sendData[1].buffer], { type: "application/octet-stream" });
                fd.append("model", JSON.stringify(request));
                fd.append("data", blob, sendData[0].file.fileName.encryptedString);
            }
            catch (e) {
                if (utils_Utils.isNode && !utils_Utils.isBrowser) {
                    fd.append("model", JSON.stringify(request));
                    fd.append("data", Buffer.from(sendData[1].buffer), {
                        filepath: sendData[0].file.fileName.encryptedString,
                        contentType: "application/octet-stream",
                    });
                }
                else {
                    throw e;
                }
            }
            return yield this.postSendFileLegacy(fd);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send-file.ts
var send_file_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SendFile extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            sizeName: null,
            fileName: null,
        }, ["id", "sizeName"]);
    }
    decrypt(key) {
        return send_file_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new SendFileView(this), {
                fileName: null,
            }, null, key);
            return view;
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendFile(), obj, {
            fileName: EncString.fromJSON(obj.fileName),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send-text.ts



class SendText extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.hidden = obj.hidden;
        this.buildDomainModel(this, obj, {
            text: null,
        }, []);
    }
    decrypt(key) {
        return this.decryptObj(new SendTextView(this), {
            text: null,
        }, null, key);
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendText(), obj, {
            text: EncString.fromJSON(obj.text),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send.ts
var send_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class Send extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            accessId: null,
            name: null,
            notes: null,
            key: null,
        }, ["id", "accessId"]);
        this.type = obj.type;
        this.maxAccessCount = obj.maxAccessCount;
        this.accessCount = obj.accessCount;
        this.password = obj.password;
        this.disabled = obj.disabled;
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
        this.deletionDate = obj.deletionDate != null ? new Date(obj.deletionDate) : null;
        this.expirationDate = obj.expirationDate != null ? new Date(obj.expirationDate) : null;
        this.hideEmail = obj.hideEmail;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendText(obj.text);
                break;
            case SendType.File:
                this.file = new SendFile(obj.file);
                break;
            default:
                break;
        }
    }
    decrypt() {
        return send_awaiter(this, void 0, void 0, function* () {
            const model = new SendView(this);
            const cryptoService = utils_Utils.getContainerService().getCryptoService();
            try {
                model.key = yield cryptoService.decryptToBytes(this.key, null);
                model.cryptoKey = yield cryptoService.makeSendKey(model.key);
            }
            catch (e) {
                // TODO: error?
            }
            yield this.decryptObj(model, {
                name: null,
                notes: null,
            }, null, model.cryptoKey);
            switch (this.type) {
                case SendType.File:
                    model.file = yield this.file.decrypt(model.cryptoKey);
                    break;
                case SendType.Text:
                    model.text = yield this.text.decrypt(model.cryptoKey);
                    break;
                default:
                    break;
            }
            return model;
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const expirationDate = obj.expirationDate == null ? null : new Date(obj.expirationDate);
        const deletionDate = obj.deletionDate == null ? null : new Date(obj.deletionDate);
        return Object.assign(new Send(), obj, {
            key: EncString.fromJSON(obj.key),
            name: EncString.fromJSON(obj.name),
            notes: EncString.fromJSON(obj.notes),
            text: SendText.fromJSON(obj.text),
            file: SendFile.fromJSON(obj.file),
            revisionDate,
            expirationDate,
            deletionDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/services/send.service.ts
var send_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








class SendService {
    constructor(cryptoService, i18nService, cryptoFunctionService, stateService) {
        this.cryptoService = cryptoService;
        this.i18nService = i18nService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.stateService = stateService;
        this._sends = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this._sendViews = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this.sends$ = this._sends.asObservable();
        this.sendViews$ = this._sendViews.asObservable();
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => send_service_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.global.bitwardenContainerService == null) {
                return;
            }
            if (!unlocked) {
                this._sends.next([]);
                this._sendViews.next([]);
                return;
            }
            const data = yield this.stateService.getEncryptedSends();
            yield this.updateObservables(data);
        })))
            .subscribe();
    }
    clearCache() {
        return send_service_awaiter(this, void 0, void 0, function* () {
            yield this._sendViews.next([]);
        });
    }
    encrypt(model, file, password, key) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            let fileData = null;
            const send = new Send();
            send.id = model.id;
            send.type = model.type;
            send.disabled = model.disabled;
            send.hideEmail = model.hideEmail;
            send.maxAccessCount = model.maxAccessCount;
            if (model.key == null) {
                model.key = yield this.cryptoFunctionService.randomBytes(16);
                model.cryptoKey = yield this.cryptoService.makeSendKey(model.key);
            }
            if (password != null) {
                const passwordHash = yield this.cryptoFunctionService.pbkdf2(password, model.key, "sha256", SEND_KDF_ITERATIONS);
                send.password = utils_Utils.fromBufferToB64(passwordHash);
            }
            send.key = yield this.cryptoService.encrypt(model.key, key);
            send.name = yield this.cryptoService.encrypt(model.name, model.cryptoKey);
            send.notes = yield this.cryptoService.encrypt(model.notes, model.cryptoKey);
            if (send.type === SendType.Text) {
                send.text = new SendText();
                send.text.text = yield this.cryptoService.encrypt(model.text.text, model.cryptoKey);
                send.text.hidden = model.text.hidden;
            }
            else if (send.type === SendType.File) {
                send.file = new SendFile();
                if (file != null) {
                    if (file instanceof ArrayBuffer) {
                        const [name, data] = yield this.encryptFileData(model.file.fileName, file, model.cryptoKey);
                        send.file.fileName = name;
                        fileData = data;
                    }
                    else {
                        fileData = yield this.parseFile(send, file, model.cryptoKey);
                    }
                }
            }
            return [send, fileData];
        });
    }
    get(id) {
        const sends = this._sends.getValue();
        return sends.find((send) => send.id === id);
    }
    getFromState(id) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = yield this.stateService.getEncryptedSends();
            // eslint-disable-next-line
            if (sends == null || !sends.hasOwnProperty(id)) {
                return null;
            }
            return new Send(sends[id]);
        });
    }
    getAll() {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = yield this.stateService.getEncryptedSends();
            const response = [];
            for (const id in sends) {
                // eslint-disable-next-line
                if (sends.hasOwnProperty(id)) {
                    response.push(new Send(sends[id]));
                }
            }
            return response;
        });
    }
    getAllDecryptedFromState() {
        return send_service_awaiter(this, void 0, void 0, function* () {
            let decSends = yield this.stateService.getDecryptedSends();
            if (decSends != null) {
                return decSends;
            }
            decSends = [];
            const hasKey = yield this.cryptoService.hasKey();
            if (!hasKey) {
                throw new Error("No key.");
            }
            const promises = [];
            const sends = yield this.getAll();
            sends.forEach((send) => {
                promises.push(send.decrypt().then((f) => decSends.push(f)));
            });
            yield Promise.all(promises);
            decSends.sort(utils_Utils.getSortFunction(this.i18nService, "name"));
            yield this.stateService.setDecryptedSends(decSends);
            return decSends;
        });
    }
    upsert(send) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            let sends = yield this.stateService.getEncryptedSends();
            if (sends == null) {
                sends = {};
            }
            if (send instanceof SendData) {
                const s = send;
                sends[s.id] = s;
            }
            else {
                send.forEach((s) => {
                    sends[s.id] = s;
                });
            }
            yield this.replace(sends);
        });
    }
    clear(userId) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null || userId == (yield this.stateService.getUserId())) {
                this._sends.next([]);
                this._sendViews.next([]);
            }
            yield this.stateService.setDecryptedSends(null, { userId: userId });
            yield this.stateService.setEncryptedSends(null, { userId: userId });
        });
    }
    delete(id) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = yield this.stateService.getEncryptedSends();
            if (sends == null) {
                return;
            }
            if (typeof id === "string") {
                if (sends[id] == null) {
                    return;
                }
                delete sends[id];
            }
            else {
                id.forEach((i) => {
                    delete sends[i];
                });
            }
            yield this.replace(sends);
        });
    }
    replace(sends) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateObservables(sends);
            yield this.stateService.setEncryptedSends(sends);
        });
    }
    parseFile(send, file, key) {
        return new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.readAsArrayBuffer(file);
            reader.onload = (evt) => send_service_awaiter(this, void 0, void 0, function* () {
                try {
                    const [name, data] = yield this.encryptFileData(file.name, evt.target.result, key);
                    send.file.fileName = name;
                    resolve(data);
                }
                catch (e) {
                    reject(e);
                }
            });
            reader.onerror = () => {
                reject("Error reading file.");
            };
        });
    }
    encryptFileData(fileName, data, key) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const encFileName = yield this.cryptoService.encrypt(fileName, key);
            const encFileData = yield this.cryptoService.encryptToBytes(data, key);
            return [encFileName, encFileData];
        });
    }
    updateObservables(sendsMap) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = Object.values(sendsMap || {}).map((f) => new Send(f));
            this._sends.next(sends);
            if (yield this.cryptoService.hasKey()) {
                this._sendViews.next(yield this.decryptSends(sends));
            }
        });
    }
    decryptSends(sends) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const decryptSendPromises = sends.map((s) => s.decrypt());
            const decryptedSends = yield Promise.all(decryptSendPromises);
            decryptedSends.sort(utils_Utils.getSortFunction(this.i18nService, "name"));
            return decryptedSends;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/sorted-ciphers-cache.ts
const CacheTTL = 3000;
class SortedCiphersCache {
    constructor(comparator) {
        this.comparator = comparator;
        this.sortedCiphersByUrl = new Map();
        this.timeouts = new Map();
    }
    isCached(url) {
        return this.sortedCiphersByUrl.has(url);
    }
    addCiphers(url, ciphers) {
        ciphers.sort(this.comparator);
        this.sortedCiphersByUrl.set(url, new Ciphers(ciphers));
        this.resetTimer(url);
    }
    getLastUsed(url) {
        this.resetTimer(url);
        return this.isCached(url) ? this.sortedCiphersByUrl.get(url).getLastUsed() : null;
    }
    getLastLaunched(url) {
        return this.isCached(url) ? this.sortedCiphersByUrl.get(url).getLastLaunched() : null;
    }
    getNext(url) {
        this.resetTimer(url);
        return this.isCached(url) ? this.sortedCiphersByUrl.get(url).getNext() : null;
    }
    updateLastUsedIndex(url) {
        if (this.isCached(url)) {
            this.sortedCiphersByUrl.get(url).updateLastUsedIndex();
        }
    }
    clear() {
        this.sortedCiphersByUrl.clear();
        this.timeouts.clear();
    }
    resetTimer(url) {
        clearTimeout(this.timeouts.get(url));
        this.timeouts.set(url, setTimeout(() => {
            this.sortedCiphersByUrl.delete(url);
            this.timeouts.delete(url);
        }, CacheTTL));
    }
}
class Ciphers {
    constructor(ciphers) {
        this.ciphers = ciphers;
        this.lastUsedIndex = -1;
    }
    getLastUsed() {
        this.lastUsedIndex = Math.max(this.lastUsedIndex, 0);
        return this.ciphers[this.lastUsedIndex];
    }
    getLastLaunched() {
        const usedCiphers = this.ciphers.filter((cipher) => { var _a; return (_a = cipher.localData) === null || _a === void 0 ? void 0 : _a.lastLaunched; });
        const sortedCiphers = usedCiphers.sort((x, y) => y.localData.lastLaunched.valueOf() - x.localData.lastLaunched.valueOf());
        return sortedCiphers[0];
    }
    getNextIndex() {
        return (this.lastUsedIndex + 1) % this.ciphers.length;
    }
    getNext() {
        return this.ciphers[this.getNextIndex()];
    }
    updateLastUsedIndex() {
        this.lastUsedIndex = this.getNextIndex();
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-bulk-delete.request.ts
class CipherBulkDeleteRequest {
    constructor(ids, organizationId) {
        this.ids = ids == null ? [] : ids;
        this.organizationId = organizationId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-bulk-move.request.ts
class CipherBulkMoveRequest {
    constructor(ids, folderId) {
        this.ids = ids == null ? [] : ids;
        this.folderId = folderId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-bulk-restore.request.ts
class CipherBulkRestoreRequest {
    constructor(ids) {
        this.ids = ids == null ? [] : ids;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/api/card.api.ts

class CardApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.cardholderName = this.getResponseProperty("CardholderName");
        this.brand = this.getResponseProperty("Brand");
        this.number = this.getResponseProperty("Number");
        this.expMonth = this.getResponseProperty("ExpMonth");
        this.expYear = this.getResponseProperty("ExpYear");
        this.code = this.getResponseProperty("Code");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/api/field.api.ts

class FieldApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.type = this.getResponseProperty("Type");
        this.name = this.getResponseProperty("Name");
        this.value = this.getResponseProperty("Value");
        this.linkedId = this.getResponseProperty("linkedId");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/api/identity.api.ts

class IdentityApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.title = this.getResponseProperty("Title");
        this.firstName = this.getResponseProperty("FirstName");
        this.middleName = this.getResponseProperty("MiddleName");
        this.lastName = this.getResponseProperty("LastName");
        this.address1 = this.getResponseProperty("Address1");
        this.address2 = this.getResponseProperty("Address2");
        this.address3 = this.getResponseProperty("Address3");
        this.city = this.getResponseProperty("City");
        this.state = this.getResponseProperty("State");
        this.postalCode = this.getResponseProperty("PostalCode");
        this.country = this.getResponseProperty("Country");
        this.company = this.getResponseProperty("Company");
        this.email = this.getResponseProperty("Email");
        this.phone = this.getResponseProperty("Phone");
        this.ssn = this.getResponseProperty("SSN");
        this.username = this.getResponseProperty("Username");
        this.passportNumber = this.getResponseProperty("PassportNumber");
        this.licenseNumber = this.getResponseProperty("LicenseNumber");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/api/login-uri.api.ts

class LoginUriApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        this.match = null;
        if (data == null) {
            return;
        }
        this.uri = this.getResponseProperty("Uri");
        const match = this.getResponseProperty("Match");
        this.match = match != null ? match : null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/api/login.api.ts


class LoginApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.username = this.getResponseProperty("Username");
        this.password = this.getResponseProperty("Password");
        this.passwordRevisionDate = this.getResponseProperty("PasswordRevisionDate");
        this.totp = this.getResponseProperty("Totp");
        this.autofillOnPageLoad = this.getResponseProperty("AutofillOnPageLoad");
        const uris = this.getResponseProperty("Uris");
        if (uris != null) {
            this.uris = uris.map((u) => new LoginUriApi(u));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/api/secure-note.api.ts

class SecureNoteApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.type = this.getResponseProperty("Type");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/attachment.request.ts
class AttachmentRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher.request.ts








class CipherRequest {
    constructor(cipher) {
        this.type = cipher.type;
        this.folderId = cipher.folderId;
        this.organizationId = cipher.organizationId;
        this.name = cipher.name ? cipher.name.encryptedString : null;
        this.notes = cipher.notes ? cipher.notes.encryptedString : null;
        this.favorite = cipher.favorite;
        this.lastKnownRevisionDate = cipher.revisionDate;
        this.reprompt = cipher.reprompt;
        switch (this.type) {
            case CipherType.Login:
                this.login = new LoginApi();
                this.login.uris = null;
                this.login.username = cipher.login.username ? cipher.login.username.encryptedString : null;
                this.login.password = cipher.login.password ? cipher.login.password.encryptedString : null;
                this.login.passwordRevisionDate =
                    cipher.login.passwordRevisionDate != null
                        ? cipher.login.passwordRevisionDate.toISOString()
                        : null;
                this.login.totp = cipher.login.totp ? cipher.login.totp.encryptedString : null;
                this.login.autofillOnPageLoad = cipher.login.autofillOnPageLoad;
                if (cipher.login.uris != null) {
                    this.login.uris = cipher.login.uris.map((u) => {
                        const uri = new LoginUriApi();
                        uri.uri = u.uri != null ? u.uri.encryptedString : null;
                        uri.match = u.match != null ? u.match : null;
                        return uri;
                    });
                }
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteApi();
                this.secureNote.type = cipher.secureNote.type;
                break;
            case CipherType.Card:
                this.card = new CardApi();
                this.card.cardholderName =
                    cipher.card.cardholderName != null ? cipher.card.cardholderName.encryptedString : null;
                this.card.brand = cipher.card.brand != null ? cipher.card.brand.encryptedString : null;
                this.card.number = cipher.card.number != null ? cipher.card.number.encryptedString : null;
                this.card.expMonth =
                    cipher.card.expMonth != null ? cipher.card.expMonth.encryptedString : null;
                this.card.expYear =
                    cipher.card.expYear != null ? cipher.card.expYear.encryptedString : null;
                this.card.code = cipher.card.code != null ? cipher.card.code.encryptedString : null;
                break;
            case CipherType.Identity:
                this.identity = new IdentityApi();
                this.identity.title =
                    cipher.identity.title != null ? cipher.identity.title.encryptedString : null;
                this.identity.firstName =
                    cipher.identity.firstName != null ? cipher.identity.firstName.encryptedString : null;
                this.identity.middleName =
                    cipher.identity.middleName != null ? cipher.identity.middleName.encryptedString : null;
                this.identity.lastName =
                    cipher.identity.lastName != null ? cipher.identity.lastName.encryptedString : null;
                this.identity.address1 =
                    cipher.identity.address1 != null ? cipher.identity.address1.encryptedString : null;
                this.identity.address2 =
                    cipher.identity.address2 != null ? cipher.identity.address2.encryptedString : null;
                this.identity.address3 =
                    cipher.identity.address3 != null ? cipher.identity.address3.encryptedString : null;
                this.identity.city =
                    cipher.identity.city != null ? cipher.identity.city.encryptedString : null;
                this.identity.state =
                    cipher.identity.state != null ? cipher.identity.state.encryptedString : null;
                this.identity.postalCode =
                    cipher.identity.postalCode != null ? cipher.identity.postalCode.encryptedString : null;
                this.identity.country =
                    cipher.identity.country != null ? cipher.identity.country.encryptedString : null;
                this.identity.company =
                    cipher.identity.company != null ? cipher.identity.company.encryptedString : null;
                this.identity.email =
                    cipher.identity.email != null ? cipher.identity.email.encryptedString : null;
                this.identity.phone =
                    cipher.identity.phone != null ? cipher.identity.phone.encryptedString : null;
                this.identity.ssn =
                    cipher.identity.ssn != null ? cipher.identity.ssn.encryptedString : null;
                this.identity.username =
                    cipher.identity.username != null ? cipher.identity.username.encryptedString : null;
                this.identity.passportNumber =
                    cipher.identity.passportNumber != null
                        ? cipher.identity.passportNumber.encryptedString
                        : null;
                this.identity.licenseNumber =
                    cipher.identity.licenseNumber != null
                        ? cipher.identity.licenseNumber.encryptedString
                        : null;
                break;
            default:
                break;
        }
        if (cipher.fields != null) {
            this.fields = cipher.fields.map((f) => {
                const field = new FieldApi();
                field.type = f.type;
                field.name = f.name ? f.name.encryptedString : null;
                field.value = f.value ? f.value.encryptedString : null;
                field.linkedId = f.linkedId;
                return field;
            });
        }
        if (cipher.passwordHistory != null) {
            this.passwordHistory = [];
            cipher.passwordHistory.forEach((ph) => {
                this.passwordHistory.push({
                    lastUsedDate: ph.lastUsedDate,
                    password: ph.password ? ph.password.encryptedString : null,
                });
            });
        }
        if (cipher.attachments != null) {
            this.attachments = {};
            this.attachments2 = {};
            cipher.attachments.forEach((attachment) => {
                const fileName = attachment.fileName ? attachment.fileName.encryptedString : null;
                this.attachments[attachment.id] = fileName;
                const attachmentRequest = new AttachmentRequest();
                attachmentRequest.fileName = fileName;
                if (attachment.key != null) {
                    attachmentRequest.key = attachment.key.encryptedString;
                }
                this.attachments2[attachment.id] = attachmentRequest;
            });
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-with-id.request.ts

class CipherWithIdRequest extends CipherRequest {
    constructor(cipher) {
        super(cipher);
        this.id = cipher.id;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-bulk-share.request.ts

class CipherBulkShareRequest {
    constructor(ciphers, collectionIds) {
        if (ciphers != null) {
            this.ciphers = [];
            ciphers.forEach((c) => {
                this.ciphers.push(new CipherWithIdRequest(c));
            });
        }
        this.collectionIds = collectionIds;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-collections.request.ts
class CipherCollectionsRequest {
    constructor(collectionIds) {
        this.collectionIds = collectionIds == null ? [] : collectionIds;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-create.request.ts

class CipherCreateRequest {
    constructor(cipher) {
        this.cipher = new CipherRequest(cipher);
        this.collectionIds = cipher.collectionIds;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-partial.request.ts
class CipherPartialRequest {
    constructor(cipher) {
        this.folderId = cipher.folderId;
        this.favorite = cipher.favorite;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-share.request.ts

class CipherShareRequest {
    constructor(cipher) {
        this.cipher = new CipherRequest(cipher);
        this.collectionIds = cipher.collectionIds;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/services/cipher.service.ts
var cipher_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var cipher_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var cipher_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


























class CipherService {
    constructor(cryptoService, settingsService, apiService, i18nService, searchService, stateService, encryptService, cipherFileUploadService) {
        this.cryptoService = cryptoService;
        this.settingsService = settingsService;
        this.apiService = apiService;
        this.i18nService = i18nService;
        this.searchService = searchService;
        this.stateService = stateService;
        this.encryptService = encryptService;
        this.cipherFileUploadService = cipherFileUploadService;
        this.sortedCiphersCache = new SortedCiphersCache(this.sortCiphersByLastUsed);
    }
    getDecryptedCipherCache() {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const decryptedCiphers = yield this.stateService.getDecryptedCiphers();
            return decryptedCiphers;
        });
    }
    setDecryptedCipherCache(value) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDecryptedCiphers(value);
            if (this.searchService != null) {
                if (value == null) {
                    this.searchService.clearIndex();
                }
                else {
                    this.searchService.indexCiphers(value);
                }
            }
        });
    }
    clearCache(userId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearDecryptedCiphersState(userId);
        });
    }
    encrypt(model, key, originalCipher = null) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            // Adjust password history
            if (model.id != null) {
                if (originalCipher == null) {
                    originalCipher = yield this.get(model.id);
                }
                if (originalCipher != null) {
                    const existingCipher = yield originalCipher.decrypt();
                    model.passwordHistory = existingCipher.passwordHistory || [];
                    if (model.type === CipherType.Login && existingCipher.type === CipherType.Login) {
                        if (existingCipher.login.password != null &&
                            existingCipher.login.password !== "" &&
                            existingCipher.login.password !== model.login.password) {
                            const ph = new PasswordHistoryView();
                            ph.password = existingCipher.login.password;
                            ph.lastUsedDate = model.login.passwordRevisionDate = new Date();
                            model.passwordHistory.splice(0, 0, ph);
                        }
                        else {
                            model.login.passwordRevisionDate = existingCipher.login.passwordRevisionDate;
                        }
                    }
                    if (existingCipher.hasFields) {
                        const existingHiddenFields = existingCipher.fields.filter((f) => f.type === FieldType.Hidden &&
                            f.name != null &&
                            f.name !== "" &&
                            f.value != null &&
                            f.value !== "");
                        const hiddenFields = model.fields == null
                            ? []
                            : model.fields.filter((f) => f.type === FieldType.Hidden && f.name != null && f.name !== "");
                        existingHiddenFields.forEach((ef) => {
                            const matchedField = hiddenFields.find((f) => f.name === ef.name);
                            if (matchedField == null || matchedField.value !== ef.value) {
                                const ph = new PasswordHistoryView();
                                ph.password = ef.name + ": " + ef.value;
                                ph.lastUsedDate = new Date();
                                model.passwordHistory.splice(0, 0, ph);
                            }
                        });
                    }
                }
                if (model.passwordHistory != null && model.passwordHistory.length === 0) {
                    model.passwordHistory = null;
                }
                else if (model.passwordHistory != null && model.passwordHistory.length > 5) {
                    // only save last 5 history
                    model.passwordHistory = model.passwordHistory.slice(0, 5);
                }
            }
            const cipher = new Cipher();
            cipher.id = model.id;
            cipher.folderId = model.folderId;
            cipher.favorite = model.favorite;
            cipher.organizationId = model.organizationId;
            cipher.type = model.type;
            cipher.collectionIds = model.collectionIds;
            cipher.revisionDate = model.revisionDate;
            cipher.reprompt = model.reprompt;
            cipher.edit = model.edit;
            if (key == null && cipher.organizationId != null) {
                key = yield this.cryptoService.getOrgKey(cipher.organizationId);
                if (key == null) {
                    throw new Error("Cannot encrypt cipher for organization. No key.");
                }
            }
            yield Promise.all([
                this.encryptObjProperty(model, cipher, {
                    name: null,
                    notes: null,
                }, key),
                this.encryptCipherData(cipher, model, key),
                this.encryptFields(model.fields, key).then((fields) => {
                    cipher.fields = fields;
                }),
                this.encryptPasswordHistories(model.passwordHistory, key).then((ph) => {
                    cipher.passwordHistory = ph;
                }),
                this.encryptAttachments(model.attachments, key).then((attachments) => {
                    cipher.attachments = attachments;
                }),
            ]);
            return cipher;
        });
    }
    encryptAttachments(attachmentsModel, key) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (attachmentsModel == null || attachmentsModel.length === 0) {
                return null;
            }
            const promises = [];
            const encAttachments = [];
            attachmentsModel.forEach((model) => cipher_service_awaiter(this, void 0, void 0, function* () {
                const attachment = new Attachment();
                attachment.id = model.id;
                attachment.size = model.size;
                attachment.sizeName = model.sizeName;
                attachment.url = model.url;
                const promise = this.encryptObjProperty(model, attachment, {
                    fileName: null,
                }, key).then(() => cipher_service_awaiter(this, void 0, void 0, function* () {
                    if (model.key != null) {
                        attachment.key = yield this.cryptoService.encrypt(model.key.key, key);
                    }
                    encAttachments.push(attachment);
                }));
                promises.push(promise);
            }));
            yield Promise.all(promises);
            return encAttachments;
        });
    }
    encryptFields(fieldsModel, key) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (!fieldsModel || !fieldsModel.length) {
                return null;
            }
            const self = this;
            const encFields = [];
            yield fieldsModel.reduce((promise, field) => cipher_service_awaiter(this, void 0, void 0, function* () {
                yield promise;
                const encField = yield self.encryptField(field, key);
                encFields.push(encField);
            }), Promise.resolve());
            return encFields;
        });
    }
    encryptField(fieldModel, key) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const field = new Field();
            field.type = fieldModel.type;
            field.linkedId = fieldModel.linkedId;
            // normalize boolean type field values
            if (fieldModel.type === FieldType.Boolean && fieldModel.value !== "true") {
                fieldModel.value = "false";
            }
            yield this.encryptObjProperty(fieldModel, field, {
                name: null,
                value: null,
            }, key);
            return field;
        });
    }
    encryptPasswordHistories(phModels, key) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (!phModels || !phModels.length) {
                return null;
            }
            const self = this;
            const encPhs = [];
            yield phModels.reduce((promise, ph) => cipher_service_awaiter(this, void 0, void 0, function* () {
                yield promise;
                const encPh = yield self.encryptPasswordHistory(ph, key);
                encPhs.push(encPh);
            }), Promise.resolve());
            return encPhs;
        });
    }
    encryptPasswordHistory(phModel, key) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const ph = new Password();
            ph.lastUsedDate = phModel.lastUsedDate;
            yield this.encryptObjProperty(phModel, ph, {
                password: null,
            }, key);
            return ph;
        });
    }
    get(id) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = yield this.stateService.getEncryptedCiphers();
            // eslint-disable-next-line
            if (ciphers == null || !ciphers.hasOwnProperty(id)) {
                return null;
            }
            const localData = yield this.stateService.getLocalData();
            return new Cipher(ciphers[id], localData ? localData[id] : null);
        });
    }
    getAll() {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const localData = yield this.stateService.getLocalData();
            const ciphers = yield this.stateService.getEncryptedCiphers();
            const response = [];
            for (const id in ciphers) {
                // eslint-disable-next-line
                if (ciphers.hasOwnProperty(id)) {
                    response.push(new Cipher(ciphers[id], localData ? localData[id] : null));
                }
            }
            return response;
        });
    }
    getAllDecrypted() {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if ((yield this.getDecryptedCipherCache()) != null) {
                yield this.reindexCiphers();
                return yield this.getDecryptedCipherCache();
            }
            const hasKey = yield this.cryptoService.hasKey();
            if (!hasKey) {
                throw new Error("No key.");
            }
            const ciphers = yield this.getAll();
            const orgKeys = yield this.cryptoService.getOrgKeys();
            const userKey = yield this.cryptoService.getKeyForUserEncryption();
            // Group ciphers by orgId or under 'null' for the user's ciphers
            const grouped = ciphers.reduce((agg, c) => {
                var _a;
                var _b;
                (_a = agg[_b = c.organizationId]) !== null && _a !== void 0 ? _a : (agg[_b] = []);
                agg[c.organizationId].push(c);
                return agg;
            }, {});
            const decCiphers = (yield Promise.all(Object.entries(grouped).map(([orgId, groupedCiphers]) => { var _a; return this.encryptService.decryptItems(groupedCiphers, (_a = orgKeys.get(orgId)) !== null && _a !== void 0 ? _a : userKey); })))
                .flat()
                .sort(this.getLocaleSortingFunction());
            yield this.setDecryptedCipherCache(decCiphers);
            return decCiphers;
        });
    }
    reindexCiphers() {
        var _a;
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.stateService.getUserId();
            const reindexRequired = this.searchService != null && ((_a = this.searchService.indexedEntityId) !== null && _a !== void 0 ? _a : userId) !== userId;
            if (reindexRequired) {
                this.searchService.indexCiphers(yield this.getDecryptedCipherCache(), userId);
            }
        });
    }
    getAllDecryptedForGrouping(groupingId, folder = true) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = yield this.getAllDecrypted();
            return ciphers.filter((cipher) => {
                if (cipher.isDeleted) {
                    return false;
                }
                if (folder && cipher.folderId === groupingId) {
                    return true;
                }
                else if (!folder &&
                    cipher.collectionIds != null &&
                    cipher.collectionIds.indexOf(groupingId) > -1) {
                    return true;
                }
                return false;
            });
        });
    }
    getAllDecryptedForUrl(url, includeOtherTypes, defaultMatch = null) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (url == null && includeOtherTypes == null) {
                return Promise.resolve([]);
            }
            const equivalentDomains = this.settingsService.getEquivalentDomains(url);
            const ciphers = yield this.getAllDecrypted();
            defaultMatch !== null && defaultMatch !== void 0 ? defaultMatch : (defaultMatch = yield this.stateService.getDefaultUriMatch());
            return ciphers.filter((cipher) => {
                if (cipher.deletedDate != null) {
                    return false;
                }
                if (includeOtherTypes != null && includeOtherTypes.indexOf(cipher.type) > -1) {
                    return true;
                }
                if (cipher.type === CipherType.Login && cipher.login !== null) {
                    return cipher.login.matchesUri(url, equivalentDomains, defaultMatch);
                }
                return false;
            });
        });
    }
    getAllFromApiForOrganization(organizationId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.apiService.getCiphersOrganization(organizationId);
            if ((response === null || response === void 0 ? void 0 : response.data) == null || response.data.length < 1) {
                return [];
            }
            const ciphers = response.data.map((cr) => new Cipher(new CipherData(cr)));
            const key = yield this.cryptoService.getOrgKey(organizationId);
            const decCiphers = yield this.encryptService.decryptItems(ciphers, key);
            decCiphers.sort(this.getLocaleSortingFunction());
            return decCiphers;
        });
    }
    getLastUsedForUrl(url, autofillOnPageLoad = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            return this.getCipherForUrl(url, true, false, autofillOnPageLoad);
        });
    }
    getLastLaunchedForUrl(url, autofillOnPageLoad = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            return this.getCipherForUrl(url, false, true, autofillOnPageLoad);
        });
    }
    getNextCipherForUrl(url) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            return this.getCipherForUrl(url, false, false, false);
        });
    }
    updateLastUsedIndexForUrl(url) {
        this.sortedCiphersCache.updateLastUsedIndex(url);
    }
    updateLastUsedDate(id) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            let ciphersLocalData = yield this.stateService.getLocalData();
            if (!ciphersLocalData) {
                ciphersLocalData = {};
            }
            if (ciphersLocalData[id]) {
                ciphersLocalData[id].lastUsedDate = new Date().getTime();
            }
            else {
                ciphersLocalData[id] = {
                    lastUsedDate: new Date().getTime(),
                };
            }
            yield this.stateService.setLocalData(ciphersLocalData);
            const decryptedCipherCache = yield this.stateService.getDecryptedCiphers();
            if (!decryptedCipherCache) {
                return;
            }
            for (let i = 0; i < decryptedCipherCache.length; i++) {
                const cached = decryptedCipherCache[i];
                if (cached.id === id) {
                    cached.localData = ciphersLocalData[id];
                    break;
                }
            }
            yield this.stateService.setDecryptedCiphers(decryptedCipherCache);
        });
    }
    updateLastLaunchedDate(id) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            let ciphersLocalData = yield this.stateService.getLocalData();
            if (!ciphersLocalData) {
                ciphersLocalData = {};
            }
            if (ciphersLocalData[id]) {
                ciphersLocalData[id].lastLaunched = new Date().getTime();
            }
            else {
                ciphersLocalData[id] = {
                    lastUsedDate: new Date().getTime(),
                };
            }
            yield this.stateService.setLocalData(ciphersLocalData);
            const decryptedCipherCache = yield this.stateService.getDecryptedCiphers();
            if (!decryptedCipherCache) {
                return;
            }
            for (let i = 0; i < decryptedCipherCache.length; i++) {
                const cached = decryptedCipherCache[i];
                if (cached.id === id) {
                    cached.localData = ciphersLocalData[id];
                    break;
                }
            }
            yield this.stateService.setDecryptedCiphers(decryptedCipherCache);
        });
    }
    saveNeverDomain(domain) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (domain == null) {
                return;
            }
            let domains = yield this.stateService.getNeverDomains();
            if (!domains) {
                domains = {};
            }
            domains[domain] = null;
            yield this.stateService.setNeverDomains(domains);
        });
    }
    createWithServer(cipher) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            let response;
            if (cipher.collectionIds != null) {
                const request = new CipherCreateRequest(cipher);
                response = yield this.apiService.postCipherCreate(request);
            }
            else {
                const request = new CipherRequest(cipher);
                response = yield this.apiService.postCipher(request);
            }
            cipher.id = response.id;
            const data = new CipherData(response, cipher.collectionIds);
            yield this.upsert(data);
        });
    }
    updateWithServer(cipher) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            let response;
            if (cipher.edit) {
                const request = new CipherRequest(cipher);
                response = yield this.apiService.putCipher(cipher.id, request);
            }
            else {
                const request = new CipherPartialRequest(cipher);
                response = yield this.apiService.putPartialCipher(cipher.id, request);
            }
            const data = new CipherData(response, cipher.collectionIds);
            yield this.upsert(data);
        });
    }
    shareWithServer(cipher, organizationId, collectionIds) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const attachmentPromises = [];
            if (cipher.attachments != null) {
                cipher.attachments.forEach((attachment) => {
                    if (attachment.key == null) {
                        attachmentPromises.push(this.shareAttachmentWithServer(attachment, cipher.id, organizationId));
                    }
                });
            }
            yield Promise.all(attachmentPromises);
            cipher.organizationId = organizationId;
            cipher.collectionIds = collectionIds;
            const encCipher = yield this.encrypt(cipher);
            const request = new CipherShareRequest(encCipher);
            const response = yield this.apiService.putShareCipher(cipher.id, request);
            const data = new CipherData(response, collectionIds);
            yield this.upsert(data);
        });
    }
    shareManyWithServer(ciphers, organizationId, collectionIds) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const promises = [];
            const encCiphers = [];
            for (const cipher of ciphers) {
                cipher.organizationId = organizationId;
                cipher.collectionIds = collectionIds;
                promises.push(this.encrypt(cipher).then((c) => {
                    encCiphers.push(c);
                }));
            }
            yield Promise.all(promises);
            const request = new CipherBulkShareRequest(encCiphers, collectionIds);
            try {
                yield this.apiService.putShareCiphers(request);
            }
            catch (e) {
                for (const cipher of ciphers) {
                    cipher.organizationId = null;
                    cipher.collectionIds = null;
                }
                throw e;
            }
            yield this.upsert(encCiphers.map((c) => c.toCipherData()));
        });
    }
    saveAttachmentWithServer(cipher, unencryptedFile, admin = false) {
        return new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.readAsArrayBuffer(unencryptedFile);
            reader.onload = (evt) => cipher_service_awaiter(this, void 0, void 0, function* () {
                try {
                    const cData = yield this.saveAttachmentRawWithServer(cipher, unencryptedFile.name, evt.target.result, admin);
                    resolve(cData);
                }
                catch (e) {
                    reject(e);
                }
            });
            reader.onerror = () => {
                reject("Error reading file.");
            };
        });
    }
    saveAttachmentRawWithServer(cipher, filename, data, admin = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const key = yield this.cryptoService.getOrgKey(cipher.organizationId);
            const encFileName = yield this.cryptoService.encrypt(filename, key);
            const dataEncKey = yield this.cryptoService.makeEncKey(key);
            const encData = yield this.cryptoService.encryptToBytes(data, dataEncKey[0]);
            const response = yield this.cipherFileUploadService.upload(cipher, encFileName, encData, admin, dataEncKey);
            const cData = new CipherData(response, cipher.collectionIds);
            if (!admin) {
                yield this.upsert(cData);
            }
            return new Cipher(cData);
        });
    }
    saveCollectionsWithServer(cipher) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const request = new CipherCollectionsRequest(cipher.collectionIds);
            yield this.apiService.putCipherCollections(cipher.id, request);
            const data = cipher.toCipherData();
            yield this.upsert(data);
        });
    }
    upsert(cipher) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            let ciphers = yield this.stateService.getEncryptedCiphers();
            if (ciphers == null) {
                ciphers = {};
            }
            if (cipher instanceof CipherData) {
                const c = cipher;
                ciphers[c.id] = c;
            }
            else {
                cipher.forEach((c) => {
                    ciphers[c.id] = c;
                });
            }
            yield this.replace(ciphers);
        });
    }
    replace(ciphers) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearDecryptedCiphersState();
            yield this.stateService.setEncryptedCiphers(ciphers);
        });
    }
    clear(userId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearEncryptedCiphersState(userId);
            yield this.clearCache(userId);
        });
    }
    moveManyWithServer(ids, folderId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.putMoveCiphers(new CipherBulkMoveRequest(ids, folderId));
            let ciphers = yield this.stateService.getEncryptedCiphers();
            if (ciphers == null) {
                ciphers = {};
            }
            ids.forEach((id) => {
                // eslint-disable-next-line
                if (ciphers.hasOwnProperty(id)) {
                    ciphers[id].folderId = folderId;
                }
            });
            yield this.clearCache();
            yield this.stateService.setEncryptedCiphers(ciphers);
        });
    }
    delete(id) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = yield this.stateService.getEncryptedCiphers();
            if (ciphers == null) {
                return;
            }
            if (typeof id === "string") {
                if (ciphers[id] == null) {
                    return;
                }
                delete ciphers[id];
            }
            else {
                id.forEach((i) => {
                    delete ciphers[i];
                });
            }
            yield this.clearCache();
            yield this.stateService.setEncryptedCiphers(ciphers);
        });
    }
    deleteWithServer(id, asAdmin = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (asAdmin) {
                yield this.apiService.deleteCipherAdmin(id);
            }
            else {
                yield this.apiService.deleteCipher(id);
            }
            yield this.delete(id);
        });
    }
    deleteManyWithServer(ids, asAdmin = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (asAdmin) {
                yield this.apiService.deleteManyCiphersAdmin(new CipherBulkDeleteRequest(ids));
            }
            else {
                yield this.apiService.deleteManyCiphers(new CipherBulkDeleteRequest(ids));
            }
            yield this.delete(ids);
        });
    }
    deleteAttachment(id, attachmentId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = yield this.stateService.getEncryptedCiphers();
            // eslint-disable-next-line
            if (ciphers == null || !ciphers.hasOwnProperty(id) || ciphers[id].attachments == null) {
                return;
            }
            for (let i = 0; i < ciphers[id].attachments.length; i++) {
                if (ciphers[id].attachments[i].id === attachmentId) {
                    ciphers[id].attachments.splice(i, 1);
                }
            }
            yield this.clearCache();
            yield this.stateService.setEncryptedCiphers(ciphers);
        });
    }
    deleteAttachmentWithServer(id, attachmentId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            try {
                yield this.apiService.deleteCipherAttachment(id, attachmentId);
            }
            catch (e) {
                return Promise.reject(e.getSingleMessage());
            }
            yield this.deleteAttachment(id, attachmentId);
        });
    }
    sortCiphersByLastUsed(a, b) {
        const aLastUsed = a.localData && a.localData.lastUsedDate ? a.localData.lastUsedDate : null;
        const bLastUsed = b.localData && b.localData.lastUsedDate ? b.localData.lastUsedDate : null;
        const bothNotNull = aLastUsed != null && bLastUsed != null;
        if (bothNotNull && aLastUsed < bLastUsed) {
            return 1;
        }
        if (aLastUsed != null && bLastUsed == null) {
            return -1;
        }
        if (bothNotNull && aLastUsed > bLastUsed) {
            return -1;
        }
        if (bLastUsed != null && aLastUsed == null) {
            return 1;
        }
        return 0;
    }
    sortCiphersByLastUsedThenName(a, b) {
        const result = this.sortCiphersByLastUsed(a, b);
        if (result !== 0) {
            return result;
        }
        return this.getLocaleSortingFunction()(a, b);
    }
    getLocaleSortingFunction() {
        return (a, b) => {
            let aName = a.name;
            let bName = b.name;
            if (aName == null && bName != null) {
                return -1;
            }
            if (aName != null && bName == null) {
                return 1;
            }
            if (aName == null && bName == null) {
                return 0;
            }
            const result = this.i18nService.collator
                ? this.i18nService.collator.compare(aName, bName)
                : aName.localeCompare(bName);
            if (result !== 0 || a.type !== CipherType.Login || b.type !== CipherType.Login) {
                return result;
            }
            if (a.login.username != null) {
                aName += a.login.username;
            }
            if (b.login.username != null) {
                bName += b.login.username;
            }
            return this.i18nService.collator
                ? this.i18nService.collator.compare(aName, bName)
                : aName.localeCompare(bName);
        };
    }
    softDelete(id) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = yield this.stateService.getEncryptedCiphers();
            if (ciphers == null) {
                return;
            }
            const setDeletedDate = (cipherId) => {
                if (ciphers[cipherId] == null) {
                    return;
                }
                ciphers[cipherId].deletedDate = new Date().toISOString();
            };
            if (typeof id === "string") {
                setDeletedDate(id);
            }
            else {
                id.forEach(setDeletedDate);
            }
            yield this.clearCache();
            yield this.stateService.setEncryptedCiphers(ciphers);
        });
    }
    softDeleteWithServer(id, asAdmin = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (asAdmin) {
                yield this.apiService.putDeleteCipherAdmin(id);
            }
            else {
                yield this.apiService.putDeleteCipher(id);
            }
            yield this.softDelete(id);
        });
    }
    softDeleteManyWithServer(ids, asAdmin = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            if (asAdmin) {
                yield this.apiService.putDeleteManyCiphersAdmin(new CipherBulkDeleteRequest(ids));
            }
            else {
                yield this.apiService.putDeleteManyCiphers(new CipherBulkDeleteRequest(ids));
            }
            yield this.softDelete(ids);
        });
    }
    restore(cipher) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = yield this.stateService.getEncryptedCiphers();
            if (ciphers == null) {
                return;
            }
            const clearDeletedDate = (c) => {
                if (ciphers[c.id] == null) {
                    return;
                }
                ciphers[c.id].deletedDate = null;
                ciphers[c.id].revisionDate = c.revisionDate;
            };
            if (cipher.constructor.name === Array.name) {
                cipher.forEach(clearDeletedDate);
            }
            else {
                clearDeletedDate(cipher);
            }
            yield this.clearCache();
            yield this.stateService.setEncryptedCiphers(ciphers);
        });
    }
    restoreWithServer(id, asAdmin = false) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const response = asAdmin
                ? yield this.apiService.putRestoreCipherAdmin(id)
                : yield this.apiService.putRestoreCipher(id);
            yield this.restore({ id: id, revisionDate: response.revisionDate });
        });
    }
    restoreManyWithServer(ids) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.apiService.putRestoreManyCiphers(new CipherBulkRestoreRequest(ids));
            const restores = [];
            for (const cipher of response.data) {
                restores.push({ id: cipher.id, revisionDate: cipher.revisionDate });
            }
            yield this.restore(restores);
        });
    }
    // Helpers
    shareAttachmentWithServer(attachmentView, cipherId, organizationId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const attachmentResponse = yield this.apiService.nativeFetch(new Request(attachmentView.url, { cache: "no-store" }));
            if (attachmentResponse.status !== 200) {
                throw Error("Failed to download attachment: " + attachmentResponse.status.toString());
            }
            const encBuf = yield EncArrayBuffer.fromResponse(attachmentResponse);
            const decBuf = yield this.cryptoService.decryptFromBytes(encBuf, null);
            const key = yield this.cryptoService.getOrgKey(organizationId);
            const encFileName = yield this.cryptoService.encrypt(attachmentView.fileName, key);
            const dataEncKey = yield this.cryptoService.makeEncKey(key);
            const encData = yield this.cryptoService.encryptToBytes(decBuf, dataEncKey[0]);
            const fd = new FormData();
            try {
                const blob = new Blob([encData.buffer], { type: "application/octet-stream" });
                fd.append("key", dataEncKey[1].encryptedString);
                fd.append("data", blob, encFileName.encryptedString);
            }
            catch (e) {
                if (utils_Utils.isNode && !utils_Utils.isBrowser) {
                    fd.append("key", dataEncKey[1].encryptedString);
                    fd.append("data", Buffer.from(encData.buffer), {
                        filepath: encFileName.encryptedString,
                        contentType: "application/octet-stream",
                    });
                }
                else {
                    throw e;
                }
            }
            try {
                yield this.apiService.postShareCipherAttachment(cipherId, attachmentView.id, fd, organizationId);
            }
            catch (e) {
                throw new Error(e.getSingleMessage());
            }
        });
    }
    encryptObjProperty(model, obj, map, key) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const promises = [];
            const self = this;
            for (const prop in map) {
                // eslint-disable-next-line
                if (!map.hasOwnProperty(prop)) {
                    continue;
                }
                (function (theProp, theObj) {
                    const p = Promise.resolve()
                        .then(() => {
                        const modelProp = model[map[theProp] || theProp];
                        if (modelProp && modelProp !== "") {
                            return self.cryptoService.encrypt(modelProp, key);
                        }
                        return null;
                    })
                        .then((val) => {
                        theObj[theProp] = val;
                    });
                    promises.push(p);
                })(prop, obj);
            }
            yield Promise.all(promises);
        });
    }
    encryptCipherData(cipher, model, key) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            switch (cipher.type) {
                case CipherType.Login:
                    cipher.login = new Login();
                    cipher.login.passwordRevisionDate = model.login.passwordRevisionDate;
                    cipher.login.autofillOnPageLoad = model.login.autofillOnPageLoad;
                    yield this.encryptObjProperty(model.login, cipher.login, {
                        username: null,
                        password: null,
                        totp: null,
                    }, key);
                    if (model.login.uris != null) {
                        cipher.login.uris = [];
                        for (let i = 0; i < model.login.uris.length; i++) {
                            const loginUri = new LoginUri();
                            loginUri.match = model.login.uris[i].match;
                            yield this.encryptObjProperty(model.login.uris[i], loginUri, {
                                uri: null,
                            }, key);
                            cipher.login.uris.push(loginUri);
                        }
                    }
                    return;
                case CipherType.SecureNote:
                    cipher.secureNote = new SecureNote();
                    cipher.secureNote.type = model.secureNote.type;
                    return;
                case CipherType.Card:
                    cipher.card = new Card();
                    yield this.encryptObjProperty(model.card, cipher.card, {
                        cardholderName: null,
                        brand: null,
                        number: null,
                        expMonth: null,
                        expYear: null,
                        code: null,
                    }, key);
                    return;
                case CipherType.Identity:
                    cipher.identity = new Identity();
                    yield this.encryptObjProperty(model.identity, cipher.identity, {
                        title: null,
                        firstName: null,
                        middleName: null,
                        lastName: null,
                        address1: null,
                        address2: null,
                        address3: null,
                        city: null,
                        state: null,
                        postalCode: null,
                        country: null,
                        company: null,
                        email: null,
                        phone: null,
                        ssn: null,
                        username: null,
                        passportNumber: null,
                        licenseNumber: null,
                    }, key);
                    return;
                default:
                    throw new Error("Unknown cipher type.");
            }
        });
    }
    getCipherForUrl(url, lastUsed, lastLaunched, autofillOnPageLoad) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            const cacheKey = autofillOnPageLoad ? "autofillOnPageLoad-" + url : url;
            if (!this.sortedCiphersCache.isCached(cacheKey)) {
                let ciphers = yield this.getAllDecryptedForUrl(url);
                if (!ciphers) {
                    return null;
                }
                if (autofillOnPageLoad) {
                    const autofillOnPageLoadDefault = yield this.stateService.getAutoFillOnPageLoadDefault();
                    ciphers = ciphers.filter((cipher) => cipher.login.autofillOnPageLoad ||
                        (cipher.login.autofillOnPageLoad == null && autofillOnPageLoadDefault !== false));
                    if (ciphers.length === 0) {
                        return null;
                    }
                }
                this.sortedCiphersCache.addCiphers(cacheKey, ciphers);
            }
            if (lastLaunched) {
                return this.sortedCiphersCache.getLastLaunched(cacheKey);
            }
            else if (lastUsed) {
                return this.sortedCiphersCache.getLastUsed(cacheKey);
            }
            else {
                return this.sortedCiphersCache.getNext(cacheKey);
            }
        });
    }
    clearEncryptedCiphersState(userId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setEncryptedCiphers(null, { userId: userId });
        });
    }
    clearDecryptedCiphersState(userId) {
        return cipher_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDecryptedCiphers(null, { userId: userId });
            this.clearSortedCiphers();
        });
    }
    clearSortedCiphers() {
        this.sortedCiphersCache.clear();
    }
}
cipher_service_decorate([
    sequentialize(() => "getAllDecrypted"),
    cipher_service_metadata("design:type", Function),
    cipher_service_metadata("design:paramtypes", []),
    cipher_service_metadata("design:returntype", Promise)
], CipherService.prototype, "getAllDecrypted", null);

;// CONCATENATED MODULE: ../../libs/common/src/vault/services/file-upload/cipher-file-upload.service.ts
var cipher_file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class CipherFileUploadService {
    constructor(apiService, fileUploadService) {
        this.apiService = apiService;
        this.fileUploadService = fileUploadService;
    }
    upload(cipher, encFileName, encData, admin, dataEncKey) {
        return cipher_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const request = {
                key: dataEncKey[1].encryptedString,
                fileName: encFileName.encryptedString,
                fileSize: encData.buffer.byteLength,
                adminRequest: admin,
            };
            let response;
            try {
                const uploadDataResponse = yield this.apiService.postCipherAttachment(cipher.id, request);
                response = admin ? uploadDataResponse.cipherMiniResponse : uploadDataResponse.cipherResponse;
                yield this.fileUploadService.upload(uploadDataResponse, encFileName, encData, this.generateMethods(uploadDataResponse, response, request.adminRequest));
            }
            catch (e) {
                if ((e instanceof ErrorResponse && e.statusCode === 404) ||
                    e.statusCode === 405) {
                    response = yield this.legacyServerAttachmentFileUpload(request.adminRequest, cipher.id, encFileName, encData, dataEncKey[1]);
                }
                else if (e instanceof ErrorResponse) {
                    throw new Error(e.getSingleMessage());
                }
                else {
                    throw e;
                }
            }
            return response;
        });
    }
    generateMethods(uploadData, response, isAdmin) {
        return {
            postDirect: this.generatePostDirectCallback(uploadData, isAdmin),
            renewFileUploadUrl: this.generateRenewFileUploadUrlCallback(uploadData, response, isAdmin),
            rollback: this.generateRollbackCallback(response, uploadData, isAdmin),
        };
    }
    generatePostDirectCallback(uploadData, isAdmin) {
        return (data) => {
            const response = isAdmin ? uploadData.cipherMiniResponse : uploadData.cipherResponse;
            return this.apiService.postAttachmentFile(response.id, uploadData.attachmentId, data);
        };
    }
    generateRenewFileUploadUrlCallback(uploadData, response, isAdmin) {
        return () => cipher_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const renewResponse = yield this.apiService.renewAttachmentUploadUrl(response.id, uploadData.attachmentId);
            return renewResponse === null || renewResponse === void 0 ? void 0 : renewResponse.url;
        });
    }
    generateRollbackCallback(response, uploadData, isAdmin) {
        return () => {
            if (isAdmin) {
                return this.apiService.deleteCipherAttachmentAdmin(response.id, uploadData.attachmentId);
            }
            else {
                return this.apiService.deleteCipherAttachment(response.id, uploadData.attachmentId);
            }
        };
    }
    /**
     * @deprecated Mar 25 2021: This method has been deprecated in favor of direct uploads.
     * This method still exists for backward compatibility with old server versions.
     */
    legacyServerAttachmentFileUpload(admin, cipherId, encFileName, encData, key) {
        return cipher_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const fd = new FormData();
            try {
                const blob = new Blob([encData.buffer], { type: "application/octet-stream" });
                fd.append("key", key.encryptedString);
                fd.append("data", blob, encFileName.encryptedString);
            }
            catch (e) {
                if (utils_Utils.isNode && !utils_Utils.isBrowser) {
                    fd.append("key", key.encryptedString);
                    fd.append("data", Buffer.from(encData.buffer), {
                        filepath: encFileName.encryptedString,
                        contentType: "application/octet-stream",
                    });
                }
                else {
                    throw e;
                }
            }
            let response;
            try {
                if (admin) {
                    response = yield this.apiService.postCipherAttachmentAdminLegacy(cipherId, fd);
                }
                else {
                    response = yield this.apiService.postCipherAttachmentLegacy(cipherId, fd);
                }
            }
            catch (e) {
                throw new Error(e.getSingleMessage());
            }
            return response;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/folder.request.ts
class FolderRequest {
    constructor(folder) {
        this.name = folder.name ? folder.name.encryptedString : null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/response/folder.response.ts

class FolderResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.revisionDate = this.getResponseProperty("RevisionDate");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/services/folder/folder-api.service.ts
var folder_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class FolderApiService {
    constructor(folderService, apiService) {
        this.folderService = folderService;
        this.apiService = apiService;
    }
    save(folder) {
        return folder_api_service_awaiter(this, void 0, void 0, function* () {
            const request = new FolderRequest(folder);
            let response;
            if (folder.id == null) {
                response = yield this.postFolder(request);
                folder.id = response.id;
            }
            else {
                response = yield this.putFolder(folder.id, request);
            }
            const data = new FolderData(response);
            yield this.folderService.upsert(data);
        });
    }
    delete(id) {
        return folder_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.deleteFolder(id);
            yield this.folderService.delete(id);
        });
    }
    get(id) {
        return folder_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/folders/" + id, null, true, true);
            return new FolderResponse(r);
        });
    }
    postFolder(request) {
        return folder_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/folders", request, true, true);
            return new FolderResponse(r);
        });
    }
    putFolder(id, request) {
        return folder_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/folders/" + id, request, true, true);
            return new FolderResponse(r);
        });
    }
    deleteFolder(id) {
        return this.apiService.send("DELETE", "/folders/" + id, null, true, false);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/services/folder/folder.service.ts
var folder_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class FolderService {
    constructor(cryptoService, i18nService, cipherService, stateService) {
        this.cryptoService = cryptoService;
        this.i18nService = i18nService;
        this.cipherService = cipherService;
        this.stateService = stateService;
        this._folders = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this._folderViews = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this.folders$ = this._folders.asObservable();
        this.folderViews$ = this._folderViews.asObservable();
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => folder_service_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.global.bitwardenContainerService == null) {
                return;
            }
            if (!unlocked) {
                this._folders.next([]);
                this._folderViews.next([]);
                return;
            }
            const data = yield this.stateService.getEncryptedFolders();
            yield this.updateObservables(data);
        })))
            .subscribe();
    }
    clearCache() {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            this._folderViews.next([]);
        });
    }
    // TODO: This should be moved to EncryptService or something
    encrypt(model, key) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const folder = new Folder();
            folder.id = model.id;
            folder.name = yield this.cryptoService.encrypt(model.name, key);
            return folder;
        });
    }
    get(id) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const folders = this._folders.getValue();
            return folders.find((folder) => folder.id === id);
        });
    }
    getAllFromState() {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const folders = yield this.stateService.getEncryptedFolders();
            const response = [];
            for (const id in folders) {
                // eslint-disable-next-line
                if (folders.hasOwnProperty(id)) {
                    response.push(new Folder(folders[id]));
                }
            }
            return response;
        });
    }
    /**
     * @deprecated For the CLI only
     * @param id id of the folder
     */
    getFromState(id) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const foldersMap = yield this.stateService.getEncryptedFolders();
            const folder = foldersMap[id];
            if (folder == null) {
                return null;
            }
            return new Folder(folder);
        });
    }
    /**
     * @deprecated Only use in CLI!
     */
    getAllDecryptedFromState() {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const data = yield this.stateService.getEncryptedFolders();
            const folders = Object.values(data || {}).map((f) => new Folder(f));
            return this.decryptFolders(folders);
        });
    }
    upsert(folder) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            let folders = yield this.stateService.getEncryptedFolders();
            if (folders == null) {
                folders = {};
            }
            if (folder instanceof FolderData) {
                const f = folder;
                folders[f.id] = f;
            }
            else {
                folder.forEach((f) => {
                    folders[f.id] = f;
                });
            }
            yield this.updateObservables(folders);
            yield this.stateService.setEncryptedFolders(folders);
        });
    }
    replace(folders) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateObservables(folders);
            yield this.stateService.setEncryptedFolders(folders);
        });
    }
    clear(userId) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null || userId == (yield this.stateService.getUserId())) {
                this._folders.next([]);
                this._folderViews.next([]);
            }
            yield this.stateService.setEncryptedFolders(null, { userId: userId });
        });
    }
    delete(id) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const folders = yield this.stateService.getEncryptedFolders();
            if (folders == null) {
                return;
            }
            if (typeof id === "string") {
                if (folders[id] == null) {
                    return;
                }
                delete folders[id];
            }
            else {
                id.forEach((i) => {
                    delete folders[i];
                });
            }
            yield this.updateObservables(folders);
            yield this.stateService.setEncryptedFolders(folders);
            // Items in a deleted folder are re-assigned to "No Folder"
            const ciphers = yield this.stateService.getEncryptedCiphers();
            if (ciphers != null) {
                const updates = [];
                for (const cId in ciphers) {
                    if (ciphers[cId].folderId === id) {
                        ciphers[cId].folderId = null;
                        updates.push(ciphers[cId]);
                    }
                }
                if (updates.length > 0) {
                    this.cipherService.upsert(updates);
                }
            }
        });
    }
    updateObservables(foldersMap) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const folders = Object.values(foldersMap || {}).map((f) => new Folder(f));
            this._folders.next(folders);
            if (yield this.cryptoService.hasKey()) {
                this._folderViews.next(yield this.decryptFolders(folders));
            }
        });
    }
    decryptFolders(folders) {
        return folder_service_awaiter(this, void 0, void 0, function* () {
            const decryptFolderPromises = folders.map((f) => f.decrypt());
            const decryptedFolders = yield Promise.all(decryptFolderPromises);
            decryptedFolders.sort(utils_Utils.getSortFunction(this.i18nService, "name"));
            const noneFolder = new FolderView();
            noneFolder.name = this.i18nService.t("noneFolder");
            decryptedFolders.push(noneFolder);
            return decryptedFolders;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/services/sync/sync-notifier.service.ts

/**
 * This class should most likely have 0 dependencies because it will hopefully
 * be rolled into SyncService once upon a time.
 */
class SyncNotifierService {
    constructor() {
        this._sync = new external_rxjs_namespaceObject.Subject();
        this.sync$ = this._sync.asObservable();
    }
    next(event) {
        this._sync.next(event);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/organization.data.ts
class OrganizationData {
    constructor(response, options) {
        this.id = response.id;
        this.name = response.name;
        this.status = response.status;
        this.type = response.type;
        this.enabled = response.enabled;
        this.usePolicies = response.usePolicies;
        this.useGroups = response.useGroups;
        this.useDirectory = response.useDirectory;
        this.useEvents = response.useEvents;
        this.useTotp = response.useTotp;
        this.use2fa = response.use2fa;
        this.useApi = response.useApi;
        this.useSso = response.useSso;
        this.useKeyConnector = response.useKeyConnector;
        this.useScim = response.useScim;
        this.useCustomPermissions = response.useCustomPermissions;
        this.useResetPassword = response.useResetPassword;
        this.useSecretsManager = response.useSecretsManager;
        this.useActivateAutofillPolicy = response.useActivateAutofillPolicy;
        this.selfHost = response.selfHost;
        this.usersGetPremium = response.usersGetPremium;
        this.seats = response.seats;
        this.maxCollections = response.maxCollections;
        this.maxStorageGb = response.maxStorageGb;
        this.ssoBound = response.ssoBound;
        this.identifier = response.identifier;
        this.permissions = response.permissions;
        this.resetPasswordEnrolled = response.resetPasswordEnrolled;
        this.userId = response.userId;
        this.hasPublicAndPrivateKeys = response.hasPublicAndPrivateKeys;
        this.providerId = response.providerId;
        this.providerName = response.providerName;
        this.providerType = response.providerType;
        this.familySponsorshipFriendlyName = response.familySponsorshipFriendlyName;
        this.familySponsorshipAvailable = response.familySponsorshipAvailable;
        this.planProductType = response.planProductType;
        this.keyConnectorEnabled = response.keyConnectorEnabled;
        this.keyConnectorUrl = response.keyConnectorUrl;
        this.familySponsorshipLastSyncDate = response.familySponsorshipLastSyncDate;
        this.familySponsorshipValidUntil = response.familySponsorshipValidUntil;
        this.familySponsorshipToDelete = response.familySponsorshipToDelete;
        this.accessSecretsManager = response.accessSecretsManager;
        this.isMember = options.isMember;
        this.isProviderUser = options.isProviderUser;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/services/sync/sync.service.ts
var sync_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var sync_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var sync_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









class SyncService {
    constructor(apiService, settingsService, folderService, cipherService, cryptoService, collectionService, messagingService, policyService, sendService, logService, keyConnectorService, stateService, providerService, folderApiService, organizationService, sendApiService, logoutCallback) {
        this.apiService = apiService;
        this.settingsService = settingsService;
        this.folderService = folderService;
        this.cipherService = cipherService;
        this.cryptoService = cryptoService;
        this.collectionService = collectionService;
        this.messagingService = messagingService;
        this.policyService = policyService;
        this.sendService = sendService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.stateService = stateService;
        this.providerService = providerService;
        this.folderApiService = folderApiService;
        this.organizationService = organizationService;
        this.sendApiService = sendApiService;
        this.logoutCallback = logoutCallback;
        this.syncInProgress = false;
    }
    getLastSync() {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            if ((yield this.stateService.getUserId()) == null) {
                return null;
            }
            const lastSync = yield this.stateService.getLastSync();
            if (lastSync) {
                return new Date(lastSync);
            }
            return null;
        });
    }
    setLastSync(date, userId) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setLastSync(date.toJSON(), { userId: userId });
        });
    }
    fullSync(forceSync, allowThrowOnError = false) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            this.syncStarted();
            const isAuthenticated = yield this.stateService.getIsAuthenticated();
            if (!isAuthenticated) {
                return this.syncCompleted(false);
            }
            const now = new Date();
            let needsSync = false;
            try {
                needsSync = yield this.needsSyncing(forceSync);
            }
            catch (e) {
                if (allowThrowOnError) {
                    throw e;
                }
            }
            if (!needsSync) {
                yield this.setLastSync(now);
                return this.syncCompleted(false);
            }
            try {
                yield this.apiService.refreshIdentityToken();
                const response = yield this.apiService.getSync();
                yield this.syncProfile(response.profile);
                yield this.syncFolders(response.folders);
                yield this.syncCollections(response.collections);
                yield this.syncCiphers(response.ciphers);
                yield this.syncSends(response.sends);
                yield this.syncSettings(response.domains);
                yield this.syncPolicies(response.policies);
                yield this.setLastSync(now);
                return this.syncCompleted(true);
            }
            catch (e) {
                if (allowThrowOnError) {
                    throw e;
                }
                else {
                    return this.syncCompleted(false);
                }
            }
        });
    }
    syncUpsertFolder(notification, isEdit) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            this.syncStarted();
            if (yield this.stateService.getIsAuthenticated()) {
                try {
                    const localFolder = yield this.folderService.get(notification.id);
                    if ((!isEdit && localFolder == null) ||
                        (isEdit && localFolder != null && localFolder.revisionDate < notification.revisionDate)) {
                        const remoteFolder = yield this.folderApiService.get(notification.id);
                        if (remoteFolder != null) {
                            yield this.folderService.upsert(new FolderData(remoteFolder));
                            this.messagingService.send("syncedUpsertedFolder", { folderId: notification.id });
                            return this.syncCompleted(true);
                        }
                    }
                }
                catch (e) {
                    this.logService.error(e);
                }
            }
            return this.syncCompleted(false);
        });
    }
    syncDeleteFolder(notification) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            this.syncStarted();
            if (yield this.stateService.getIsAuthenticated()) {
                yield this.folderService.delete(notification.id);
                this.messagingService.send("syncedDeletedFolder", { folderId: notification.id });
                this.syncCompleted(true);
                return true;
            }
            return this.syncCompleted(false);
        });
    }
    syncUpsertCipher(notification, isEdit) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            this.syncStarted();
            if (yield this.stateService.getIsAuthenticated()) {
                try {
                    let shouldUpdate = true;
                    const localCipher = yield this.cipherService.get(notification.id);
                    if (localCipher != null && localCipher.revisionDate >= notification.revisionDate) {
                        shouldUpdate = false;
                    }
                    let checkCollections = false;
                    if (shouldUpdate) {
                        if (isEdit) {
                            shouldUpdate = localCipher != null;
                            checkCollections = true;
                        }
                        else {
                            if (notification.collectionIds == null || notification.organizationId == null) {
                                shouldUpdate = localCipher == null;
                            }
                            else {
                                shouldUpdate = false;
                                checkCollections = true;
                            }
                        }
                    }
                    if (!shouldUpdate &&
                        checkCollections &&
                        notification.organizationId != null &&
                        notification.collectionIds != null &&
                        notification.collectionIds.length > 0) {
                        const collections = yield this.collectionService.getAll();
                        if (collections != null) {
                            for (let i = 0; i < collections.length; i++) {
                                if (notification.collectionIds.indexOf(collections[i].id) > -1) {
                                    shouldUpdate = true;
                                    break;
                                }
                            }
                        }
                    }
                    if (shouldUpdate) {
                        const remoteCipher = yield this.apiService.getFullCipherDetails(notification.id);
                        if (remoteCipher != null) {
                            yield this.cipherService.upsert(new CipherData(remoteCipher));
                            this.messagingService.send("syncedUpsertedCipher", { cipherId: notification.id });
                            return this.syncCompleted(true);
                        }
                    }
                }
                catch (e) {
                    if (e != null && e.statusCode === 404 && isEdit) {
                        yield this.cipherService.delete(notification.id);
                        this.messagingService.send("syncedDeletedCipher", { cipherId: notification.id });
                        return this.syncCompleted(true);
                    }
                }
            }
            return this.syncCompleted(false);
        });
    }
    syncDeleteCipher(notification) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            this.syncStarted();
            if (yield this.stateService.getIsAuthenticated()) {
                yield this.cipherService.delete(notification.id);
                this.messagingService.send("syncedDeletedCipher", { cipherId: notification.id });
                return this.syncCompleted(true);
            }
            return this.syncCompleted(false);
        });
    }
    syncUpsertSend(notification, isEdit) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            this.syncStarted();
            if (yield this.stateService.getIsAuthenticated()) {
                try {
                    const localSend = this.sendService.get(notification.id);
                    if ((!isEdit && localSend == null) ||
                        (isEdit && localSend != null && localSend.revisionDate < notification.revisionDate)) {
                        const remoteSend = yield this.sendApiService.getSend(notification.id);
                        if (remoteSend != null) {
                            yield this.sendService.upsert(new SendData(remoteSend));
                            this.messagingService.send("syncedUpsertedSend", { sendId: notification.id });
                            return this.syncCompleted(true);
                        }
                    }
                }
                catch (e) {
                    this.logService.error(e);
                }
            }
            return this.syncCompleted(false);
        });
    }
    syncDeleteSend(notification) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            this.syncStarted();
            if (yield this.stateService.getIsAuthenticated()) {
                yield this.sendService.delete(notification.id);
                this.messagingService.send("syncedDeletedSend", { sendId: notification.id });
                this.syncCompleted(true);
                return true;
            }
            return this.syncCompleted(false);
        });
    }
    // Helpers
    syncStarted() {
        this.syncInProgress = true;
        this.messagingService.send("syncStarted");
    }
    syncCompleted(successfully) {
        this.syncInProgress = false;
        this.messagingService.send("syncCompleted", { successfully: successfully });
        return successfully;
    }
    needsSyncing(forceSync) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            if (forceSync) {
                return true;
            }
            const lastSync = yield this.getLastSync();
            if (lastSync == null || lastSync.getTime() === 0) {
                return true;
            }
            const response = yield this.apiService.getAccountRevisionDate();
            if (new Date(response) <= lastSync) {
                return false;
            }
            return true;
        });
    }
    syncProfile(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            const stamp = yield this.stateService.getSecurityStamp();
            if (stamp != null && stamp !== response.securityStamp) {
                if (this.logoutCallback != null) {
                    yield this.logoutCallback(true);
                }
                throw new Error("Stamp has changed");
            }
            yield this.cryptoService.setEncKey(response.key);
            yield this.cryptoService.setEncPrivateKey(response.privateKey);
            yield this.cryptoService.setProviderKeys(response.providers);
            yield this.cryptoService.setOrgKeys(response.organizations, response.providerOrganizations);
            yield this.stateService.setAvatarColor(response.avatarColor);
            yield this.stateService.setSecurityStamp(response.securityStamp);
            yield this.stateService.setEmailVerified(response.emailVerified);
            yield this.stateService.setHasPremiumPersonally(response.premiumPersonally);
            yield this.stateService.setHasPremiumFromOrganization(response.premiumFromOrganization);
            yield this.keyConnectorService.setUsesKeyConnector(response.usesKeyConnector);
            // The `forcePasswordReset` flag indicates an admin has reset the user's password and must be updated
            if (response.forcePasswordReset) {
                yield this.stateService.setForcePasswordResetReason(ForceResetPasswordReason.AdminForcePasswordReset);
            }
            yield this.syncProfileOrganizations(response);
            const providers = {};
            response.providers.forEach((p) => {
                providers[p.id] = new ProviderData(p);
            });
            yield this.providerService.save(providers);
            if (yield this.keyConnectorService.userNeedsMigration()) {
                yield this.keyConnectorService.setConvertAccountRequired(true);
                this.messagingService.send("convertAccountToKeyConnector");
            }
            else {
                this.keyConnectorService.removeConvertAccountRequired();
            }
        });
    }
    syncProfileOrganizations(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            const organizations = {};
            response.organizations.forEach((o) => {
                organizations[o.id] = new OrganizationData(o, {
                    isMember: true,
                    isProviderUser: false,
                });
            });
            response.providerOrganizations.forEach((o) => {
                if (organizations[o.id] == null) {
                    organizations[o.id] = new OrganizationData(o, {
                        isMember: false,
                        isProviderUser: true,
                    });
                }
                else {
                    organizations[o.id].isProviderUser = true;
                }
            });
            yield this.organizationService.replace(organizations);
        });
    }
    syncFolders(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            const folders = {};
            response.forEach((f) => {
                folders[f.id] = new FolderData(f);
            });
            return yield this.folderService.replace(folders);
        });
    }
    syncCollections(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            const collections = {};
            response.forEach((c) => {
                collections[c.id] = new CollectionData(c);
            });
            return yield this.collectionService.replace(collections);
        });
    }
    syncCiphers(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            const ciphers = {};
            response.forEach((c) => {
                ciphers[c.id] = new CipherData(c);
            });
            return yield this.cipherService.replace(ciphers);
        });
    }
    syncSends(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            const sends = {};
            response.forEach((s) => {
                sends[s.id] = new SendData(s);
            });
            return yield this.sendService.replace(sends);
        });
    }
    syncSettings(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            let eqDomains = [];
            if (response != null && response.equivalentDomains != null) {
                eqDomains = eqDomains.concat(response.equivalentDomains);
            }
            if (response != null && response.globalEquivalentDomains != null) {
                response.globalEquivalentDomains.forEach((global) => {
                    if (global.domains.length > 0) {
                        eqDomains.push(global.domains);
                    }
                });
            }
            return this.settingsService.setEquivalentDomains(eqDomains);
        });
    }
    syncPolicies(response) {
        return sync_service_awaiter(this, void 0, void 0, function* () {
            const policies = {};
            if (response != null) {
                response.forEach((p) => {
                    policies[p.id] = new PolicyData(p);
                });
            }
            return yield this.policyService.replace(policies);
        });
    }
}
sync_service_decorate([
    sequentialize(() => "fullSync"),
    sync_service_metadata("design:type", Function),
    sync_service_metadata("design:paramtypes", [Boolean, Object]),
    sync_service_metadata("design:returntype", Promise)
], SyncService.prototype, "fullSync", null);

;// CONCATENATED MODULE: ../../libs/importer/src/services/import-api.service.ts
var import_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class ImportApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    postImportCiphers(request) {
        return import_api_service_awaiter(this, void 0, void 0, function* () {
            return yield this.apiService.send("POST", "/ciphers/import", request, true, false);
        });
    }
    postImportOrganizationCiphers(organizationId, request) {
        return import_api_service_awaiter(this, void 0, void 0, function* () {
            return yield this.apiService.send("POST", "/ciphers/import-organization?organizationId=" + organizationId, request, true, false);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/request/collection.request.ts
class CollectionRequest {
    constructor(collection) {
        this.groups = [];
        this.users = [];
        if (collection == null) {
            return;
        }
        this.name = collection.name ? collection.name.encryptedString : null;
        this.externalId = collection.externalId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/request/collection-with-id.request.ts

class CollectionWithIdRequest extends CollectionRequest {
    constructor(collection) {
        if (collection == null) {
            return;
        }
        super(collection);
        this.id = collection.id;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/import-ciphers.request.ts
class ImportCiphersRequest {
    constructor() {
        this.ciphers = [];
        this.folders = [];
        this.folderRelationships = [];
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/import-organization-ciphers.request.ts
class ImportOrganizationCiphersRequest {
    constructor() {
        this.ciphers = [];
        this.collections = [];
        this.collectionRelationships = [];
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/kvp.request.ts
class KvpRequest {
    constructor(key, value) {
        this.key = key;
        this.value = value;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/folder-with-id.request.ts

class FolderWithIdRequest extends FolderRequest {
    constructor(folder) {
        super(folder);
        this.id = folder.id;
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/models/import-result.ts
class import_result_ImportResult {
    constructor() {
        this.success = false;
        this.ciphers = [];
        this.folders = [];
        this.folderRelationships = [];
        this.collections = [];
        this.collectionRelationships = [];
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/consoleLog.service.ts

class consoleLog_service_ConsoleLogService {
    constructor(isDev, filter = null) {
        this.isDev = isDev;
        this.filter = filter;
        this.timersMap = new Map();
    }
    debug(message) {
        if (!this.isDev) {
            return;
        }
        this.write(LogLevelType.Debug, message);
    }
    info(message) {
        this.write(LogLevelType.Info, message);
    }
    warning(message) {
        this.write(LogLevelType.Warning, message);
    }
    error(message) {
        this.write(LogLevelType.Error, message);
    }
    write(level, message) {
        if (this.filter != null && this.filter(level)) {
            return;
        }
        switch (level) {
            case LogLevelType.Debug:
                // eslint-disable-next-line
                console.log(message);
                break;
            case LogLevelType.Info:
                // eslint-disable-next-line
                console.log(message);
                break;
            case LogLevelType.Warning:
                // eslint-disable-next-line
                console.warn(message);
                break;
            case LogLevelType.Error:
                // eslint-disable-next-line
                console.error(message);
                break;
            default:
                break;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/base-importer.ts












class base_importer_BaseImporter {
    constructor() {
        this.organizationId = null;
        this.logService = new consoleLog_service_ConsoleLogService(false);
        this.newLineRegex = /(?:\r\n|\r|\n)/;
        this.passwordFieldNames = [
            "password",
            "pass word",
            "passphrase",
            "pass phrase",
            "pass",
            "code",
            "code word",
            "codeword",
            "secret",
            "secret word",
            "personpwd",
            "key",
            "keyword",
            "key word",
            "keyphrase",
            "key phrase",
            "form_pw",
            "wppassword",
            "pin",
            "pwd",
            "pw",
            "pword",
            "passwd",
            "p",
            "serial",
            "serial#",
            "license key",
            "reg #",
            // Non-English names
            "passwort",
        ];
        this.usernameFieldNames = [
            "user",
            "name",
            "user name",
            "username",
            "login name",
            "email",
            "e-mail",
            "id",
            "userid",
            "user id",
            "login",
            "form_loginname",
            "wpname",
            "mail",
            "loginid",
            "login id",
            "log",
            "personlogin",
            "first name",
            "last name",
            "card#",
            "account #",
            "member",
            "member #",
            // Non-English names
            "nom",
            "benutzername",
        ];
        this.notesFieldNames = [
            "note",
            "notes",
            "comment",
            "comments",
            "memo",
            "description",
            "free form",
            "freeform",
            "free text",
            "freetext",
            "free",
            // Non-English names
            "kommentar",
        ];
        this.uriFieldNames = [
            "url",
            "hyper link",
            "hyperlink",
            "link",
            "host",
            "hostname",
            "host name",
            "server",
            "address",
            "hyper ref",
            "href",
            "web",
            "website",
            "web site",
            "site",
            "web-site",
            "uri",
            // Non-English names
            "ort",
            "adresse",
        ];
        this.parseCsvOptions = {
            encoding: "UTF-8",
            skipEmptyLines: false,
        };
    }
    get organization() {
        return this.organizationId != null;
    }
    parseXml(data) {
        const parser = new DOMParser();
        const doc = parser.parseFromString(data, "application/xml");
        return doc != null && doc.querySelector("parsererror") == null ? doc : null;
    }
    parseCsv(data, header, options = {}) {
        const parseOptions = Object.assign({ header: header }, this.parseCsvOptions, options);
        data = this.splitNewLine(data).join("\n").trim();
        const result = external_papaparse_namespaceObject.parse(data, parseOptions);
        if (result.errors != null && result.errors.length > 0) {
            result.errors.forEach((e) => {
                if (e.row != null) {
                    this.logService.warning("Error parsing row " + e.row + ": " + e.message);
                }
            });
        }
        return result.data && result.data.length > 0 ? result.data : null;
    }
    parseSingleRowCsv(rowData) {
        if (this.isNullOrWhitespace(rowData)) {
            return null;
        }
        const parsedRow = this.parseCsv(rowData, false);
        if (parsedRow != null && parsedRow.length > 0 && parsedRow[0].length > 0) {
            return parsedRow[0];
        }
        return null;
    }
    makeUriArray(uri) {
        if (uri == null) {
            return null;
        }
        if (typeof uri === "string") {
            const loginUri = new LoginUriView();
            loginUri.uri = this.fixUri(uri);
            if (this.isNullOrWhitespace(loginUri.uri)) {
                return null;
            }
            loginUri.match = null;
            return [loginUri];
        }
        if (uri.length > 0) {
            const returnArr = [];
            uri.forEach((u) => {
                const loginUri = new LoginUriView();
                loginUri.uri = this.fixUri(u);
                if (this.isNullOrWhitespace(loginUri.uri)) {
                    return;
                }
                loginUri.match = null;
                returnArr.push(loginUri);
            });
            return returnArr.length === 0 ? null : returnArr;
        }
        return null;
    }
    fixUri(uri) {
        if (uri == null) {
            return null;
        }
        uri = uri.trim();
        if (uri.indexOf("://") === -1 && uri.indexOf(".") >= 0) {
            uri = "http://" + uri;
        }
        if (uri.length > 1000) {
            return uri.substring(0, 1000);
        }
        return uri;
    }
    nameFromUrl(url) {
        const hostname = utils_Utils.getHostname(url);
        if (this.isNullOrWhitespace(hostname)) {
            return null;
        }
        return hostname.startsWith("www.") ? hostname.replace("www.", "") : hostname;
    }
    isNullOrWhitespace(str) {
        return utils_Utils.isNullOrWhitespace(str);
    }
    getValueOrDefault(str, defaultValue = null) {
        if (this.isNullOrWhitespace(str)) {
            return defaultValue;
        }
        return str;
    }
    splitNewLine(str) {
        return str.split(this.newLineRegex);
    }
    // ref https://stackoverflow.com/a/5911300
    getCardBrand(cardNum) {
        if (this.isNullOrWhitespace(cardNum)) {
            return null;
        }
        // Visa
        let re = new RegExp("^4");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        // Mastercard
        // Updated for Mastercard 2017 BINs expansion
        if (/^(5[1-5][0-9]{14}|2(22[1-9][0-9]{12}|2[3-9][0-9]{13}|[3-6][0-9]{14}|7[0-1][0-9]{13}|720[0-9]{12}))$/.test(cardNum)) {
            return "Mastercard";
        }
        // AMEX
        re = new RegExp("^3[47]");
        if (cardNum.match(re) != null) {
            return "Amex";
        }
        // Discover
        re = new RegExp("^(6011|622(12[6-9]|1[3-9][0-9]|[2-8][0-9]{2}|9[0-1][0-9]|92[0-5]|64[4-9])|65)");
        if (cardNum.match(re) != null) {
            return "Discover";
        }
        // Diners
        re = new RegExp("^36");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // Diners - Carte Blanche
        re = new RegExp("^30[0-5]");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // JCB
        re = new RegExp("^35(2[89]|[3-8][0-9])");
        if (cardNum.match(re) != null) {
            return "JCB";
        }
        // Visa Electron
        re = new RegExp("^(4026|417500|4508|4844|491(3|7))");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        return null;
    }
    setCardExpiration(cipher, expiration) {
        if (!this.isNullOrWhitespace(expiration)) {
            expiration = expiration.replace(/\s/g, "");
            const parts = expiration.split("/");
            if (parts.length === 2) {
                let month = null;
                let year = null;
                if (parts[0].length === 1 || parts[0].length === 2) {
                    month = parts[0];
                    if (month.length === 2 && month[0] === "0") {
                        month = month.substr(1, 1);
                    }
                }
                if (parts[1].length === 2 || parts[1].length === 4) {
                    year = month.length === 2 ? "20" + parts[1] : parts[1];
                }
                if (month != null && year != null) {
                    cipher.card.expMonth = month;
                    cipher.card.expYear = year;
                    return true;
                }
            }
        }
        return false;
    }
    moveFoldersToCollections(result) {
        result.folderRelationships.forEach((r) => result.collectionRelationships.push(r));
        result.collections = result.folders.map((f) => {
            const collection = new CollectionView();
            collection.name = f.name;
            collection.id = f.id;
            return collection;
        });
        result.folderRelationships = [];
        result.folders = [];
    }
    querySelectorDirectChild(parentEl, query) {
        const els = this.querySelectorAllDirectChild(parentEl, query);
        return els.length === 0 ? null : els[0];
    }
    querySelectorAllDirectChild(parentEl, query) {
        return Array.from(parentEl.querySelectorAll(query)).filter((el) => el.parentNode === parentEl);
    }
    initLoginCipher() {
        const cipher = new CipherView();
        cipher.favorite = false;
        cipher.notes = "";
        cipher.fields = [];
        cipher.login = new LoginView();
        cipher.type = CipherType.Login;
        return cipher;
    }
    cleanupCipher(cipher) {
        if (cipher == null) {
            return;
        }
        if (cipher.type !== CipherType.Login) {
            cipher.login = null;
        }
        if (this.isNullOrWhitespace(cipher.name)) {
            cipher.name = "--";
        }
        if (this.isNullOrWhitespace(cipher.notes)) {
            cipher.notes = null;
        }
        else {
            cipher.notes = cipher.notes.trim();
        }
        if (cipher.fields != null && cipher.fields.length === 0) {
            cipher.fields = null;
        }
    }
    processKvp(cipher, key, value, type = FieldType.Text) {
        if (this.isNullOrWhitespace(value)) {
            return;
        }
        if (this.isNullOrWhitespace(key)) {
            key = "";
        }
        if (value.length > 200 || value.trim().search(this.newLineRegex) > -1) {
            if (cipher.notes == null) {
                cipher.notes = "";
            }
            cipher.notes += key + ": " + this.splitNewLine(value).join("\n") + "\n";
        }
        else {
            if (cipher.fields == null) {
                cipher.fields = [];
            }
            const field = new FieldView();
            field.type = type;
            field.name = key;
            field.value = value;
            cipher.fields.push(field);
        }
    }
    processFolder(result, folderName) {
        if (this.isNullOrWhitespace(folderName)) {
            return;
        }
        let folderIndex = result.folders.length;
        // Replace backslashes with forward slashes, ensuring we create sub-folders
        folderName = folderName.replace("\\", "/");
        let addFolder = true;
        for (let i = 0; i < result.folders.length; i++) {
            if (result.folders[i].name === folderName) {
                addFolder = false;
                folderIndex = i;
                break;
            }
        }
        if (addFolder) {
            const f = new FolderView();
            f.name = folderName;
            result.folders.push(f);
        }
        result.folderRelationships.push([result.ciphers.length, folderIndex]);
    }
    convertToNoteIfNeeded(cipher) {
        if (cipher.type === CipherType.Login &&
            this.isNullOrWhitespace(cipher.login.username) &&
            this.isNullOrWhitespace(cipher.login.password) &&
            (cipher.login.uris == null || cipher.login.uris.length === 0)) {
            cipher.type = CipherType.SecureNote;
            cipher.secureNote = new SecureNoteView();
            cipher.secureNote.type = SecureNoteType.Generic;
        }
    }
    processFullName(cipher, fullName) {
        if (this.isNullOrWhitespace(fullName)) {
            return;
        }
        const nameParts = fullName.split(" ");
        if (nameParts.length > 0) {
            cipher.identity.firstName = this.getValueOrDefault(nameParts[0]);
        }
        if (nameParts.length === 2) {
            cipher.identity.lastName = this.getValueOrDefault(nameParts[1]);
        }
        else if (nameParts.length >= 3) {
            cipher.identity.middleName = this.getValueOrDefault(nameParts[1]);
            cipher.identity.lastName = nameParts.slice(2, nameParts.length).join(" ");
        }
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/ascendo-csv-importer.ts


class AscendoCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, false);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            if (value.length < 2) {
                return;
            }
            const cipher = this.initLoginCipher();
            cipher.notes = this.getValueOrDefault(value[value.length - 1]);
            cipher.name = this.getValueOrDefault(value[0], "--");
            if (value.length > 2 && value.length % 2 === 0) {
                for (let i = 0; i < value.length - 2; i += 2) {
                    const val = value[i + 2];
                    const field = value[i + 1];
                    if (this.isNullOrWhitespace(val) || this.isNullOrWhitespace(field)) {
                        continue;
                    }
                    const fieldLower = field.toLowerCase();
                    if (cipher.login.password == null && this.passwordFieldNames.indexOf(fieldLower) > -1) {
                        cipher.login.password = this.getValueOrDefault(val);
                    }
                    else if (cipher.login.username == null &&
                        this.usernameFieldNames.indexOf(fieldLower) > -1) {
                        cipher.login.username = this.getValueOrDefault(val);
                    }
                    else if ((cipher.login.uris == null || cipher.login.uris.length === 0) &&
                        this.uriFieldNames.indexOf(fieldLower) > -1) {
                        cipher.login.uris = this.makeUriArray(val);
                    }
                    else {
                        this.processKvp(cipher, field, val);
                    }
                }
            }
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/avast/avast-csv-importer.ts


class AvastCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            const cipher = this.initLoginCipher();
            cipher.name = this.getValueOrDefault(value.name);
            cipher.login.uris = this.makeUriArray(value.web);
            cipher.login.password = this.getValueOrDefault(value.password);
            cipher.login.username = this.getValueOrDefault(value.login);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/avast/avast-json-importer.ts




class AvastJsonImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = JSON.parse(data);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        if (results.logins != null) {
            results.logins.forEach((value) => {
                const cipher = this.initLoginCipher();
                cipher.name = this.getValueOrDefault(value.custName);
                cipher.notes = this.getValueOrDefault(value.note);
                cipher.login.uris = this.makeUriArray(value.url);
                cipher.login.password = this.getValueOrDefault(value.pwd);
                cipher.login.username = this.getValueOrDefault(value.loginName);
                this.cleanupCipher(cipher);
                result.ciphers.push(cipher);
            });
        }
        if (results.notes != null) {
            results.notes.forEach((value) => {
                const cipher = this.initLoginCipher();
                cipher.type = CipherType.SecureNote;
                cipher.secureNote.type = SecureNoteType.Generic;
                cipher.name = this.getValueOrDefault(value.label);
                cipher.notes = this.getValueOrDefault(value.text);
                this.cleanupCipher(cipher);
                result.ciphers.push(cipher);
            });
        }
        if (results.cards != null) {
            results.cards.forEach((value) => {
                const cipher = this.initLoginCipher();
                cipher.type = CipherType.Card;
                cipher.name = this.getValueOrDefault(value.custName);
                cipher.notes = this.getValueOrDefault(value.note);
                cipher.card.cardholderName = this.getValueOrDefault(value.holderName);
                cipher.card.number = this.getValueOrDefault(value.cardNumber);
                cipher.card.code = this.getValueOrDefault(value.cvv);
                cipher.card.brand = this.getCardBrand(cipher.card.number);
                if (value.expirationDate != null) {
                    if (value.expirationDate.month != null) {
                        cipher.card.expMonth = value.expirationDate.month + "";
                    }
                    if (value.expirationDate.year != null) {
                        cipher.card.expYear = value.expirationDate.year + "";
                    }
                }
                this.cleanupCipher(cipher);
                result.ciphers.push(cipher);
            });
        }
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/avast/index.ts



;// CONCATENATED MODULE: ../../libs/importer/src/importers/avira-csv-importer.ts


class AviraCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            const cipher = this.initLoginCipher();
            cipher.name = this.getValueOrDefault(value.name, this.getValueOrDefault(this.nameFromUrl(value.website), "--"));
            cipher.login.uris = this.makeUriArray(value.website);
            cipher.login.password = this.getValueOrDefault(value.password);
            if (this.isNullOrWhitespace(value.username) &&
                !this.isNullOrWhitespace(value.secondary_username)) {
                cipher.login.username = value.secondary_username;
            }
            else {
                cipher.login.username = this.getValueOrDefault(value.username);
                cipher.notes = this.getValueOrDefault(value.secondary_username);
            }
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/blackberry-csv-importer.ts


class BlackBerryCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            if (value.grouping === "list") {
                return;
            }
            const cipher = this.initLoginCipher();
            cipher.favorite = value.fav === "1";
            cipher.name = this.getValueOrDefault(value.name);
            cipher.notes = this.getValueOrDefault(value.extra);
            if (value.grouping !== "note") {
                cipher.login.uris = this.makeUriArray(value.url);
                cipher.login.password = this.getValueOrDefault(value.password);
                cipher.login.username = this.getValueOrDefault(value.username);
            }
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/chrome-csv-importer.ts


class ChromeCsvImporter extends base_importer_BaseImporter {
    constructor() {
        super(...arguments);
        this.androidPatternRegex = new RegExp("^android:\\/\\/.*(?<=@)(.*)(?=\\/)");
    }
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            const cipher = this.initLoginCipher();
            let name = value.name;
            if (!name && this.androidPatternRegex.test(value.url)) {
                name = value.url.match(this.androidPatternRegex)[1];
            }
            cipher.name = this.getValueOrDefault(name, "--");
            cipher.login.username = this.getValueOrDefault(value.username);
            cipher.login.password = this.getValueOrDefault(value.password);
            cipher.login.uris = this.makeUriArray(value.url);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/bitwarden/bitwarden-csv-importer.ts










class BitwardenCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            if (this.organization && !this.isNullOrWhitespace(value.collections)) {
                const collections = value.collections.split(",");
                collections.forEach((col) => {
                    let addCollection = true;
                    let collectionIndex = result.collections.length;
                    for (let i = 0; i < result.collections.length; i++) {
                        if (result.collections[i].name === col) {
                            addCollection = false;
                            collectionIndex = i;
                            break;
                        }
                    }
                    if (addCollection) {
                        const collection = new CollectionView();
                        collection.name = col;
                        result.collections.push(collection);
                    }
                    result.collectionRelationships.push([result.ciphers.length, collectionIndex]);
                });
            }
            else if (!this.organization) {
                this.processFolder(result, value.folder);
            }
            const cipher = new CipherView();
            cipher.favorite =
                !this.organization && this.getValueOrDefault(value.favorite, "0") !== "0" ? true : false;
            cipher.type = CipherType.Login;
            cipher.notes = this.getValueOrDefault(value.notes);
            cipher.name = this.getValueOrDefault(value.name, "--");
            try {
                cipher.reprompt = parseInt(this.getValueOrDefault(value.reprompt, CipherRepromptType.None.toString()), 10);
            }
            catch (e) {
                // eslint-disable-next-line
                console.error("Unable to parse reprompt value", e);
                cipher.reprompt = CipherRepromptType.None;
            }
            if (!this.isNullOrWhitespace(value.fields)) {
                const fields = this.splitNewLine(value.fields);
                for (let i = 0; i < fields.length; i++) {
                    if (this.isNullOrWhitespace(fields[i])) {
                        continue;
                    }
                    const delimPosition = fields[i].lastIndexOf(": ");
                    if (delimPosition === -1) {
                        continue;
                    }
                    if (cipher.fields == null) {
                        cipher.fields = [];
                    }
                    const field = new FieldView();
                    field.name = fields[i].substr(0, delimPosition);
                    field.value = null;
                    field.type = FieldType.Text;
                    if (fields[i].length > delimPosition + 2) {
                        field.value = fields[i].substr(delimPosition + 2);
                    }
                    cipher.fields.push(field);
                }
            }
            const valueType = value.type != null ? value.type.toLowerCase() : null;
            switch (valueType) {
                case "note":
                    cipher.type = CipherType.SecureNote;
                    cipher.secureNote = new SecureNoteView();
                    cipher.secureNote.type = SecureNoteType.Generic;
                    break;
                default: {
                    cipher.type = CipherType.Login;
                    cipher.login = new LoginView();
                    cipher.login.totp = this.getValueOrDefault(value.login_totp || value.totp);
                    cipher.login.username = this.getValueOrDefault(value.login_username || value.username);
                    cipher.login.password = this.getValueOrDefault(value.login_password || value.password);
                    const uris = this.parseSingleRowCsv(value.login_uri || value.uri);
                    cipher.login.uris = this.makeUriArray(uris);
                    break;
                }
            }
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/bitwarden/bitwarden-json-importer.ts
var bitwarden_json_importer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class BitwardenJsonImporter extends base_importer_BaseImporter {
    constructor(cryptoService, i18nService) {
        super();
        this.cryptoService = cryptoService;
        this.i18nService = i18nService;
    }
    parse(data) {
        return bitwarden_json_importer_awaiter(this, void 0, void 0, function* () {
            this.result = new import_result_ImportResult();
            this.results = JSON.parse(data);
            if (this.results == null || this.results.items == null) {
                this.result.success = false;
                return this.result;
            }
            if (this.results.encrypted) {
                yield this.parseEncrypted();
            }
            else {
                this.parseDecrypted();
            }
            return this.result;
        });
    }
    parseEncrypted() {
        return bitwarden_json_importer_awaiter(this, void 0, void 0, function* () {
            if (this.results.encKeyValidation_DO_NOT_EDIT != null) {
                const orgKey = yield this.cryptoService.getOrgKey(this.organizationId);
                const encKeyValidation = new EncString(this.results.encKeyValidation_DO_NOT_EDIT);
                const encKeyValidationDecrypt = yield this.cryptoService.decryptToUtf8(encKeyValidation, orgKey);
                if (encKeyValidationDecrypt === null) {
                    this.result.success = false;
                    this.result.errorMessage = this.i18nService.t("importEncKeyError");
                    return;
                }
            }
            const groupingsMap = new Map();
            if (this.organization && this.results.collections != null) {
                for (const c of this.results.collections) {
                    const collection = CollectionWithIdExport.toDomain(c);
                    if (collection != null) {
                        collection.organizationId = this.organizationId;
                        const view = yield collection.decrypt();
                        groupingsMap.set(c.id, this.result.collections.length);
                        this.result.collections.push(view);
                    }
                }
            }
            else if (!this.organization && this.results.folders != null) {
                for (const f of this.results.folders) {
                    const folder = FolderWithIdExport.toDomain(f);
                    if (folder != null) {
                        const view = yield folder.decrypt();
                        groupingsMap.set(f.id, this.result.folders.length);
                        this.result.folders.push(view);
                    }
                }
            }
            for (const c of this.results.items) {
                const cipher = CipherWithIdExport.toDomain(c);
                // reset ids incase they were set for some reason
                cipher.id = null;
                cipher.organizationId = this.organizationId;
                cipher.collectionIds = null;
                // make sure password history is limited
                if (cipher.passwordHistory != null && cipher.passwordHistory.length > 5) {
                    cipher.passwordHistory = cipher.passwordHistory.slice(0, 5);
                }
                if (!this.organization && c.folderId != null && groupingsMap.has(c.folderId)) {
                    this.result.folderRelationships.push([
                        this.result.ciphers.length,
                        groupingsMap.get(c.folderId),
                    ]);
                }
                else if (this.organization && c.collectionIds != null) {
                    c.collectionIds.forEach((cId) => {
                        if (groupingsMap.has(cId)) {
                            this.result.collectionRelationships.push([
                                this.result.ciphers.length,
                                groupingsMap.get(cId),
                            ]);
                        }
                    });
                }
                const view = yield cipher.decrypt();
                this.cleanupCipher(view);
                this.result.ciphers.push(view);
            }
            this.result.success = true;
        });
    }
    parseDecrypted() {
        const groupingsMap = new Map();
        if (this.organization && this.results.collections != null) {
            this.results.collections.forEach((c) => {
                const collection = CollectionWithIdExport.toView(c);
                if (collection != null) {
                    collection.organizationId = null;
                    groupingsMap.set(c.id, this.result.collections.length);
                    this.result.collections.push(collection);
                }
            });
        }
        else if (!this.organization && this.results.folders != null) {
            this.results.folders.forEach((f) => {
                const folder = FolderWithIdExport.toView(f);
                if (folder != null) {
                    groupingsMap.set(f.id, this.result.folders.length);
                    this.result.folders.push(folder);
                }
            });
        }
        this.results.items.forEach((c) => {
            const cipher = CipherWithIdExport.toView(c);
            // reset ids incase they were set for some reason
            cipher.id = null;
            cipher.organizationId = null;
            cipher.collectionIds = null;
            // make sure password history is limited
            if (cipher.passwordHistory != null && cipher.passwordHistory.length > 5) {
                cipher.passwordHistory = cipher.passwordHistory.slice(0, 5);
            }
            if (!this.organization && c.folderId != null && groupingsMap.has(c.folderId)) {
                this.result.folderRelationships.push([
                    this.result.ciphers.length,
                    groupingsMap.get(c.folderId),
                ]);
            }
            else if (this.organization && c.collectionIds != null) {
                c.collectionIds.forEach((cId) => {
                    if (groupingsMap.has(cId)) {
                        this.result.collectionRelationships.push([
                            this.result.ciphers.length,
                            groupingsMap.get(cId),
                        ]);
                    }
                });
            }
            this.cleanupCipher(cipher);
            this.result.ciphers.push(cipher);
        });
        this.result.success = true;
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/bitwarden/bitwarden-password-protected-importer.ts
var bitwarden_password_protected_importer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class BitwardenPasswordProtectedImporter extends BitwardenJsonImporter {
    constructor(cryptoService, i18nService, promptForPassword_callback) {
        super(cryptoService, i18nService);
        this.promptForPassword_callback = promptForPassword_callback;
    }
    parse(data) {
        const _super = Object.create(null, {
            parse: { get: () => super.parse }
        });
        return bitwarden_password_protected_importer_awaiter(this, void 0, void 0, function* () {
            const result = new import_result_ImportResult();
            const parsedData = JSON.parse(data);
            if (!parsedData) {
                result.success = false;
                return result;
            }
            // File is unencrypted
            if (!(parsedData === null || parsedData === void 0 ? void 0 : parsedData.encrypted)) {
                return yield _super.parse.call(this, data);
            }
            // File is account-encrypted
            if (!(parsedData === null || parsedData === void 0 ? void 0 : parsedData.passwordProtected)) {
                return yield _super.parse.call(this, data);
            }
            if (this.cannotParseFile(parsedData)) {
                result.success = false;
                return result;
            }
            // File is password-protected
            const password = yield this.promptForPassword_callback();
            if (!(yield this.checkPassword(parsedData, password))) {
                result.success = false;
                result.errorMessage = this.i18nService.t("invalidFilePassword");
                return result;
            }
            const encData = new EncString(parsedData.data);
            const clearTextData = yield this.cryptoService.decryptToUtf8(encData, this.key);
            return yield _super.parse.call(this, clearTextData);
        });
    }
    checkPassword(jdoc, password) {
        return bitwarden_password_protected_importer_awaiter(this, void 0, void 0, function* () {
            this.key = yield this.cryptoService.makePinKey(password, jdoc.salt, jdoc.kdfType, new KdfConfig(jdoc.kdfIterations, jdoc.kdfMemory, jdoc.kdfParallelism));
            const encKeyValidation = new EncString(jdoc.encKeyValidation_DO_NOT_EDIT);
            const encKeyValidationDecrypt = yield this.cryptoService.decryptToUtf8(encKeyValidation, this.key);
            if (encKeyValidationDecrypt === null) {
                return false;
            }
            return true;
        });
    }
    cannotParseFile(jdoc) {
        return (!jdoc ||
            !jdoc.encrypted ||
            !jdoc.passwordProtected ||
            !jdoc.salt ||
            !jdoc.kdfIterations ||
            typeof jdoc.kdfIterations !== "number" ||
            jdoc.kdfType == null ||
            KdfType[jdoc.kdfType] == null ||
            !jdoc.encKeyValidation_DO_NOT_EDIT ||
            !jdoc.data);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/bitwarden/index.ts




;// CONCATENATED MODULE: ../../libs/importer/src/importers/blur-csv-importer.ts


class BlurCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            if (value.label === "null") {
                value.label = null;
            }
            const cipher = this.initLoginCipher();
            cipher.name = this.getValueOrDefault(value.label, this.getValueOrDefault(this.nameFromUrl(value.domain), "--"));
            cipher.login.uris = this.makeUriArray(value.domain);
            cipher.login.password = this.getValueOrDefault(value.password);
            if (this.isNullOrWhitespace(value.email) && !this.isNullOrWhitespace(value.username)) {
                cipher.login.username = value.username;
            }
            else {
                cipher.login.username = this.getValueOrDefault(value.email);
                cipher.notes = this.getValueOrDefault(value.username);
            }
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/buttercup-csv-importer.ts


const OfficialProps = ["!group_id", "!group_name", "title", "username", "password", "URL", "id"];
class ButtercupCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            this.processFolder(result, this.getValueOrDefault(value["!group_name"]));
            const cipher = this.initLoginCipher();
            cipher.name = this.getValueOrDefault(value.title, "--");
            cipher.login.username = this.getValueOrDefault(value.username);
            cipher.login.password = this.getValueOrDefault(value.password);
            cipher.login.uris = this.makeUriArray(value.URL);
            let processingCustomFields = false;
            for (const prop in value) {
                // eslint-disable-next-line
                if (value.hasOwnProperty(prop)) {
                    if (!processingCustomFields && OfficialProps.indexOf(prop) === -1) {
                        processingCustomFields = true;
                    }
                    if (processingCustomFields) {
                        this.processKvp(cipher, prop, value[prop]);
                    }
                }
            }
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        if (this.organization) {
            this.moveFoldersToCollections(result);
        }
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/clipperz-html-importer.ts


class ClipperzHtmlImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const doc = this.parseXml(data);
        if (doc == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        const textarea = doc.querySelector("textarea");
        if (textarea == null || this.isNullOrWhitespace(textarea.textContent)) {
            result.errorMessage = "Missing textarea.";
            result.success = false;
            return Promise.resolve(result);
        }
        const entries = JSON.parse(textarea.textContent);
        entries.forEach((entry) => {
            const cipher = this.initLoginCipher();
            if (!this.isNullOrWhitespace(entry.label)) {
                cipher.name = entry.label.split(" ")[0];
            }
            if (entry.data != null && !this.isNullOrWhitespace(entry.data.notes)) {
                cipher.notes = entry.data.notes.split("\\n").join("\n");
            }
            if (entry.currentVersion != null && entry.currentVersion.fields != null) {
                for (const property in entry.currentVersion.fields) {
                    // eslint-disable-next-line
                    if (!entry.currentVersion.fields.hasOwnProperty(property)) {
                        continue;
                    }
                    const field = entry.currentVersion.fields[property];
                    const actionType = field.actionType != null ? field.actionType.toLowerCase() : null;
                    switch (actionType) {
                        case "password":
                            cipher.login.password = this.getValueOrDefault(field.value);
                            break;
                        case "email":
                        case "username":
                        case "user":
                        case "name":
                            cipher.login.username = this.getValueOrDefault(field.value);
                            break;
                        case "url":
                            cipher.login.uris = this.makeUriArray(field.value);
                            break;
                        default: {
                            const labelLower = field.label != null ? field.label.toLowerCase() : null;
                            if (cipher.login.password == null &&
                                this.passwordFieldNames.indexOf(labelLower) > -1) {
                                cipher.login.password = this.getValueOrDefault(field.value);
                            }
                            else if (cipher.login.username == null &&
                                this.usernameFieldNames.indexOf(labelLower) > -1) {
                                cipher.login.username = this.getValueOrDefault(field.value);
                            }
                            else if ((cipher.login.uris == null || cipher.login.uris.length === 0) &&
                                this.uriFieldNames.indexOf(labelLower) > -1) {
                                cipher.login.uris = this.makeUriArray(field.value);
                            }
                            else {
                                this.processKvp(cipher, field.label, field.value);
                            }
                            break;
                        }
                    }
                }
            }
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/codebook-csv-importer.ts


class CodebookCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            this.processFolder(result, this.getValueOrDefault(value.Category));
            const cipher = this.initLoginCipher();
            cipher.favorite = this.getValueOrDefault(value.Favorite) === "True";
            cipher.name = this.getValueOrDefault(value.Entry, "--");
            cipher.notes = this.getValueOrDefault(value.Note);
            cipher.login.username = this.getValueOrDefault(value.Username, value.Email);
            cipher.login.password = this.getValueOrDefault(value.Password);
            cipher.login.totp = this.getValueOrDefault(value.TOTP);
            cipher.login.uris = this.makeUriArray(value.Website);
            if (!this.isNullOrWhitespace(value.Username)) {
                this.processKvp(cipher, "Email", value.Email);
            }
            this.processKvp(cipher, "Phone", value.Phone);
            this.processKvp(cipher, "PIN", value.PIN);
            this.processKvp(cipher, "Account", value.Account);
            this.processKvp(cipher, "Date", value.Date);
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        if (this.organization) {
            this.moveFoldersToCollections(result);
        }
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/dashlane/dashlane-csv-importer.ts







const _mappedCredentialsColums = new Set([
    "title",
    "note",
    "username",
    "password",
    "url",
    "otpSecret",
    "category",
]);
const _mappedPersonalInfoAsIdentiyColumns = new Set([
    "type",
    "title",
    "first_name",
    "middle_name",
    "last_name",
    "login",
    "email",
    "phone_number",
    "address",
    "country",
    "state",
    "city",
    "zip",
    // Skip item_name as we already have set a combined name
    "item_name",
]);
const _mappedSecureNoteColumns = new Set(["title", "note"]);
class DashlaneCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        if (results[0].type != null && results[0].title != null) {
            const personalRecords = results;
            // If personalRecords has only one "name" then create an Identity-Cipher
            if (personalRecords.filter((x) => x.type === "name").length === 1) {
                const cipher = this.initLoginCipher();
                cipher.type = CipherType.Identity;
                cipher.identity = new IdentityView();
                results.forEach((row) => {
                    this.parsePersonalInformationRecordAsIdentity(cipher, row);
                });
                this.cleanupCipher(cipher);
                result.ciphers.push(cipher);
                result.success = true;
                return Promise.resolve(result);
            }
        }
        results.forEach((row) => {
            const cipher = this.initLoginCipher();
            const rowKeys = Object.keys(row);
            if (rowKeys[0] === "username") {
                this.processFolder(result, row.category);
                this.parseCredentialsRecord(cipher, row);
            }
            if (rowKeys[0] === "type" && rowKeys[1] === "account_name") {
                this.parsePaymentRecord(cipher, row);
            }
            if (rowKeys[0] === "type" && rowKeys[1] === "number") {
                this.parseIdRecord(cipher, row);
            }
            if ((rowKeys[0] === "type") != null && rowKeys[1] === "title") {
                this.parsePersonalInformationRecord(cipher, row);
            }
            if (rowKeys[0] === "title" && rowKeys[1] === "note") {
                this.parseSecureNoteRecords(cipher, row);
            }
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        if (this.organization) {
            this.moveFoldersToCollections(result);
        }
        result.success = true;
        return Promise.resolve(result);
    }
    parseCredentialsRecord(cipher, row) {
        cipher.type = CipherType.Login;
        cipher.login = new LoginView();
        cipher.name = row.title;
        cipher.notes = row.note;
        cipher.login.username = row.username;
        cipher.login.password = row.password;
        cipher.login.totp = row.otpSecret;
        cipher.login.uris = this.makeUriArray(row.url);
        this.importUnmappedFields(cipher, row, _mappedCredentialsColums);
    }
    parsePaymentRecord(cipher, row) {
        cipher.type = CipherType.Card;
        cipher.card = new CardView();
        cipher.name = row.account_name;
        let mappedValues = [];
        switch (row.type) {
            case "credit_card":
                cipher.card.cardholderName = row.account_name;
                cipher.card.number = row.cc_number;
                cipher.card.brand = this.getCardBrand(cipher.card.number);
                cipher.card.code = row.code;
                this.setCardExpiration(cipher, `${row.expiration_month}/${row.expiration_year}`);
                // If you add more mapped fields please extend this
                mappedValues = [
                    "account_name",
                    "account_holder",
                    "cc_number",
                    "code",
                    "expiration_month",
                    "expiration_year",
                ];
                break;
            case "bank":
                cipher.card.cardholderName = row.account_holder;
                cipher.card.number = row.account_number;
                // If you add more mapped fields please extend this
                mappedValues = ["account_name", "account_holder", "account_number"];
                break;
            default:
                break;
        }
        this.importUnmappedFields(cipher, row, new Set(mappedValues));
    }
    parseIdRecord(cipher, row) {
        cipher.type = CipherType.Identity;
        cipher.identity = new IdentityView();
        const mappedValues = ["name", "number"];
        switch (row.type) {
            case "card":
                cipher.name = `${row.name} ${row.type}`;
                this.processFullName(cipher, row.name);
                cipher.identity.licenseNumber = row.number;
                break;
            case "passport":
                cipher.name = `${row.name} ${row.type}`;
                this.processFullName(cipher, row.name);
                cipher.identity.passportNumber = row.number;
                break;
            case "license":
                cipher.name = `${row.name} ${row.type}`;
                this.processFullName(cipher, row.name);
                cipher.identity.licenseNumber = row.number;
                cipher.identity.state = row.state;
                mappedValues.push("state");
                break;
            case "social_security":
                cipher.name = `${row.name} ${row.type}`;
                this.processFullName(cipher, row.name);
                cipher.identity.ssn = row.number;
                break;
            case "tax_number":
                cipher.name = row.type;
                cipher.identity.licenseNumber = row.number;
                break;
            default:
                break;
        }
        // If you add more mapped fields please extend this
        this.importUnmappedFields(cipher, row, new Set(mappedValues));
    }
    parsePersonalInformationRecord(cipher, row) {
        cipher.type = CipherType.SecureNote;
        cipher.secureNote.type = SecureNoteType.Generic;
        if (row.type === "name") {
            cipher.name = `${row.title} ${row.first_name} ${row.middle_name} ${row.last_name}`
                .replace("  ", " ")
                .trim();
        }
        else {
            cipher.name = row.item_name;
        }
        const dataRow = row;
        Object.keys(row).forEach((key) => {
            this.processKvp(cipher, key, dataRow[key]);
        });
    }
    parsePersonalInformationRecordAsIdentity(cipher, row) {
        switch (row.type) {
            case "name":
                this.processFullName(cipher, `${row.first_name} ${row.middle_name} ${row.last_name}`);
                cipher.identity.title = row.title;
                cipher.name = cipher.identity.fullName;
                cipher.identity.username = row.login;
                break;
            case "email":
                cipher.identity.email = row.email;
                break;
            case "number":
                cipher.identity.phone = row.phone_number;
                break;
            case "address":
                cipher.identity.address1 = row.address;
                cipher.identity.city = row.city;
                cipher.identity.postalCode = row.zip;
                cipher.identity.state = row.state;
                cipher.identity.country = row.country;
                break;
            default:
                break;
        }
        this.importUnmappedFields(cipher, row, _mappedPersonalInfoAsIdentiyColumns);
    }
    parseSecureNoteRecords(cipher, row) {
        cipher.type = CipherType.SecureNote;
        cipher.secureNote.type = SecureNoteType.Generic;
        cipher.name = row.title;
        cipher.notes = row.note;
        this.importUnmappedFields(cipher, row, _mappedSecureNoteColumns);
    }
    importUnmappedFields(cipher, row, mappedValues) {
        const unmappedFields = Object.keys(row).filter((x) => !mappedValues.has(x));
        unmappedFields.forEach((key) => {
            const item = row;
            this.processKvp(cipher, key, item[key]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/dashlane/dashlane-json-importer.ts








const HandledResults = new Set([
    "ADDRESS",
    "AUTHENTIFIANT",
    "BANKSTATEMENT",
    "IDCARD",
    "IDENTITY",
    "PAYMENTMEANS_CREDITCARD",
    "PAYMENTMEAN_PAYPAL",
    "EMAIL",
]);
class DashlaneJsonImporter extends base_importer_BaseImporter {
    parse(data) {
        this.result = new import_result_ImportResult();
        const results = JSON.parse(data);
        if (results == null || results.length === 0) {
            this.result.success = false;
            return Promise.resolve(this.result);
        }
        if (results.ADDRESS != null) {
            this.processAddress(results.ADDRESS);
        }
        if (results.AUTHENTIFIANT != null) {
            this.processAuth(results.AUTHENTIFIANT);
        }
        if (results.BANKSTATEMENT != null) {
            this.processNote(results.BANKSTATEMENT, "BankAccountName");
        }
        if (results.IDCARD != null) {
            this.processNote(results.IDCARD, "Fullname");
        }
        if (results.PAYMENTMEANS_CREDITCARD != null) {
            this.processCard(results.PAYMENTMEANS_CREDITCARD);
        }
        if (results.IDENTITY != null) {
            this.processIdentity(results.IDENTITY);
        }
        for (const key in results) {
            // eslint-disable-next-line
            if (results.hasOwnProperty(key) && !HandledResults.has(key)) {
                this.processNote(results[key], null, "Generic Note");
            }
        }
        this.result.success = true;
        return Promise.resolve(this.result);
    }
    processAuth(results) {
        results.forEach((credential) => {
            const cipher = this.initLoginCipher();
            cipher.name = this.getValueOrDefault(credential.title);
            cipher.login.username = this.getValueOrDefault(credential.login, this.getValueOrDefault(credential.secondaryLogin));
            if (this.isNullOrWhitespace(cipher.login.username)) {
                cipher.login.username = this.getValueOrDefault(credential.email);
            }
            else if (!this.isNullOrWhitespace(credential.email)) {
                cipher.notes = "Email: " + credential.email + "\n";
            }
            cipher.login.password = this.getValueOrDefault(credential.password);
            cipher.login.uris = this.makeUriArray(credential.domain);
            cipher.notes += this.getValueOrDefault(credential.note, "");
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            this.result.ciphers.push(cipher);
        });
    }
    processIdentity(results) {
        results.forEach((obj) => {
            const cipher = new CipherView();
            cipher.identity = new IdentityView();
            cipher.type = CipherType.Identity;
            cipher.name = this.getValueOrDefault(obj.fullName, "");
            const nameParts = cipher.name.split(" ");
            if (nameParts.length > 0) {
                cipher.identity.firstName = this.getValueOrDefault(nameParts[0]);
            }
            if (nameParts.length === 2) {
                cipher.identity.lastName = this.getValueOrDefault(nameParts[1]);
            }
            else if (nameParts.length === 3) {
                cipher.identity.middleName = this.getValueOrDefault(nameParts[1]);
                cipher.identity.lastName = this.getValueOrDefault(nameParts[2]);
            }
            cipher.identity.username = this.getValueOrDefault(obj.pseudo);
            this.cleanupCipher(cipher);
            this.result.ciphers.push(cipher);
        });
    }
    processAddress(results) {
        results.forEach((obj) => {
            const cipher = new CipherView();
            cipher.identity = new IdentityView();
            cipher.type = CipherType.Identity;
            cipher.name = this.getValueOrDefault(obj.addressName);
            cipher.identity.address1 = this.getValueOrDefault(obj.addressFull);
            cipher.identity.city = this.getValueOrDefault(obj.city);
            cipher.identity.state = this.getValueOrDefault(obj.state);
            cipher.identity.postalCode = this.getValueOrDefault(obj.zipcode);
            cipher.identity.country = this.getValueOrDefault(obj.country);
            if (cipher.identity.country != null) {
                cipher.identity.country = cipher.identity.country.toUpperCase();
            }
            this.cleanupCipher(cipher);
            this.result.ciphers.push(cipher);
        });
    }
    processCard(results) {
        results.forEach((obj) => {
            const cipher = new CipherView();
            cipher.card = new CardView();
            cipher.type = CipherType.Card;
            cipher.name = this.getValueOrDefault(obj.bank);
            cipher.card.number = this.getValueOrDefault(obj.cardNumber);
            cipher.card.brand = this.getCardBrand(cipher.card.number);
            cipher.card.cardholderName = this.getValueOrDefault(obj.owner);
            if (!this.isNullOrWhitespace(cipher.card.brand)) {
                if (this.isNullOrWhitespace(cipher.name)) {
                    cipher.name = cipher.card.brand;
                }
                else {
                    cipher.name += " - " + cipher.card.brand;
                }
            }
            this.cleanupCipher(cipher);
            this.result.ciphers.push(cipher);
        });
    }
    processNote(results, nameProperty, name = null) {
        results.forEach((obj) => {
            const cipher = new CipherView();
            cipher.secureNote = new SecureNoteView();
            cipher.type = CipherType.SecureNote;
            cipher.secureNote.type = SecureNoteType.Generic;
            if (name != null) {
                cipher.name = name;
            }
            else {
                cipher.name = this.getValueOrDefault(obj[nameProperty]);
            }
            for (const key in obj) {
                // eslint-disable-next-line
                if (obj.hasOwnProperty(key) && key !== nameProperty) {
                    this.processKvp(cipher, key, obj[key].toString());
                }
            }
            this.cleanupCipher(cipher);
            this.result.ciphers.push(cipher);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/dashlane/index.ts



;// CONCATENATED MODULE: ../../libs/importer/src/importers/encryptr-csv-importer.ts




class EncryptrCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results.forEach((value) => {
            const cipher = this.initLoginCipher();
            cipher.name = this.getValueOrDefault(value.Label, "--");
            cipher.notes = this.getValueOrDefault(value.Notes);
            const text = this.getValueOrDefault(value.Text);
            if (!this.isNullOrWhitespace(text)) {
                if (this.isNullOrWhitespace(cipher.notes)) {
                    cipher.notes = text;
                }
                else {
                    cipher.notes += "\n\n" + text;
                }
            }
            const type = value["Entry Type"];
            if (type === "Password") {
                cipher.login.username = this.getValueOrDefault(value.Username);
                cipher.login.password = this.getValueOrDefault(value.Password);
                cipher.login.uris = this.makeUriArray(value["Site URL"]);
            }
            else if (type === "Credit Card") {
                cipher.type = CipherType.Card;
                cipher.card = new CardView();
                cipher.card.cardholderName = this.getValueOrDefault(value["Name on card"]);
                cipher.card.number = this.getValueOrDefault(value["Card Number"]);
                cipher.card.brand = this.getCardBrand(cipher.card.number);
                cipher.card.code = this.getValueOrDefault(value.CVV);
                const expiry = this.getValueOrDefault(value.Expiry);
                if (!this.isNullOrWhitespace(expiry)) {
                    const expParts = expiry.split("/");
                    if (expParts.length > 1) {
                        cipher.card.expMonth = parseInt(expParts[0], null).toString();
                        cipher.card.expYear = (2000 + parseInt(expParts[1], null)).toString();
                    }
                }
            }
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/enpass/enpass-csv-importer.ts






class EnpassCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, false);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        let firstRow = true;
        results.forEach((value) => {
            if (value.length < 2 || (firstRow && (value[0] === "Title" || value[0] === "title"))) {
                firstRow = false;
                return;
            }
            const cipher = this.initLoginCipher();
            cipher.notes = this.getValueOrDefault(value[value.length - 1]);
            cipher.name = this.getValueOrDefault(value[0], "--");
            if (value.length === 2 ||
                (!this.containsField(value, "username") &&
                    !this.containsField(value, "password") &&
                    !this.containsField(value, "email") &&
                    !this.containsField(value, "url"))) {
                cipher.type = CipherType.SecureNote;
                cipher.secureNote = new SecureNoteView();
                cipher.secureNote.type = SecureNoteType.Generic;
            }
            if (this.containsField(value, "cardholder") &&
                this.containsField(value, "number") &&
                this.containsField(value, "expiry date")) {
                cipher.type = CipherType.Card;
                cipher.card = new CardView();
            }
            if (value.length > 2 && value.length % 2 === 0) {
                for (let i = 0; i < value.length - 2; i += 2) {
                    const fieldValue = value[i + 2];
                    if (this.isNullOrWhitespace(fieldValue)) {
                        continue;
                    }
                    const fieldName = value[i + 1];
                    const fieldNameLower = fieldName.toLowerCase();
                    if (cipher.type === CipherType.Login) {
                        if (fieldNameLower === "url" &&
                            (cipher.login.uris == null || cipher.login.uris.length === 0)) {
                            cipher.login.uris = this.makeUriArray(fieldValue);
                            continue;
                        }
                        else if ((fieldNameLower === "username" || fieldNameLower === "email") &&
                            this.isNullOrWhitespace(cipher.login.username)) {
                            cipher.login.username = fieldValue;
                            continue;
                        }
                        else if (fieldNameLower === "password" &&
                            this.isNullOrWhitespace(cipher.login.password)) {
                            cipher.login.password = fieldValue;
                            continue;
                        }
                        else if (fieldNameLower === "totp" && this.isNullOrWhitespace(cipher.login.totp)) {
                            cipher.login.totp = fieldValue;
                            continue;
                        }
                    }
                    else if (cipher.type === CipherType.Card) {
                        if (fieldNameLower === "cardholder" &&
                            this.isNullOrWhitespace(cipher.card.cardholderName)) {
                            cipher.card.cardholderName = fieldValue;
                            continue;
                        }
                        else if (fieldNameLower === "number" && this.isNullOrWhitespace(cipher.card.number)) {
                            cipher.card.number = fieldValue;
                            cipher.card.brand = this.getCardBrand(fieldValue);
                            continue;
                        }
                        else if (fieldNameLower === "cvc" && this.isNullOrWhitespace(cipher.card.code)) {
                            cipher.card.code = fieldValue;
                            continue;
                        }
                        else if (fieldNameLower === "expiry date" &&
                            this.isNullOrWhitespace(cipher.card.expMonth) &&
                            this.isNullOrWhitespace(cipher.card.expYear)) {
                            if (this.setCardExpiration(cipher, fieldValue)) {
                                continue;
                            }
                        }
                        else if (fieldNameLower === "type") {
                            // Skip since brand was determined from number above
                            continue;
                        }
                    }
                    this.processKvp(cipher, fieldName, fieldValue);
                }
            }
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
    containsField(fields, name) {
        if (fields == null || name == null) {
            return false;
        }
        return (fields.filter((f) => !this.isNullOrWhitespace(f) && f.toLowerCase() === name.toLowerCase())
            .length > 0);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/enpass/enpass-json-importer.ts






const androidUrlRegex = new RegExp("androidapp://.*==@", "g");
class EnpassJsonImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = JSON.parse(data);
        if (results == null || results.items == null || results.items.length === 0) {
            result.success = false;
            return Promise.resolve(result);
        }
        const foldersMap = new Map();
        const foldersIndexMap = new Map();
        const folderTree = this.buildFolderTree(results.folders);
        this.flattenFolderTree(null, folderTree, foldersMap);
        foldersMap.forEach((val, key) => {
            foldersIndexMap.set(key, result.folders.length);
            const f = new FolderView();
            f.name = val;
            result.folders.push(f);
        });
        results.items.forEach((item) => {
            if (item.folders != null && item.folders.length > 0 && foldersIndexMap.has(item.folders[0])) {
                result.folderRelationships.push([
                    result.ciphers.length,
                    foldersIndexMap.get(item.folders[0]),
                ]);
            }
            const cipher = this.initLoginCipher();
            cipher.name = this.getValueOrDefault(item.title);
            cipher.favorite = item.favorite > 0;
            if (item.template_type != null && item.fields != null && item.fields.length > 0) {
                if (item.template_type.indexOf("login.") === 0 ||
                    item.template_type.indexOf("password.") === 0) {
                    this.processLogin(cipher, item.fields);
                }
                else if (item.template_type.indexOf("creditcard.") === 0) {
                    this.processCard(cipher, item.fields);
                }
                else if (item.template_type.indexOf("identity.") < 0 &&
                    item.fields.some((f) => f.type === "password" && !this.isNullOrWhitespace(f.value))) {
                    this.processLogin(cipher, item.fields);
                }
                else {
                    this.processNote(cipher, item.fields);
                }
            }
            cipher.notes += "\n" + this.getValueOrDefault(item.note, "");
            this.convertToNoteIfNeeded(cipher);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
    processLogin(cipher, fields) {
        const urls = [];
        fields.forEach((field) => {
            if (this.isNullOrWhitespace(field.value) || field.type === "section") {
                return;
            }
            if ((field.type === "username" || field.type === "email") &&
                this.isNullOrWhitespace(cipher.login.username)) {
                cipher.login.username = field.value;
            }
            else if (field.type === "password" && this.isNullOrWhitespace(cipher.login.password)) {
                cipher.login.password = field.value;
            }
            else if (field.type === "totp" && this.isNullOrWhitespace(cipher.login.totp)) {
                cipher.login.totp = field.value;
            }
            else if (field.type === "url") {
                urls.push(field.value);
            }
            else if (field.type === ".Android#") {
                let cleanedValue = field.value.startsWith("androidapp://")
                    ? field.value
                    : "androidapp://" + field.value;
                cleanedValue = cleanedValue.replace("android://", "");
                cleanedValue = cleanedValue.replace(androidUrlRegex, "androidapp://");
                urls.push(cleanedValue);
            }
            else {
                this.processKvp(cipher, field.label, field.value, field.sensitive === 1 ? FieldType.Hidden : FieldType.Text);
            }
        });
        cipher.login.uris = this.makeUriArray(urls);
    }
    processCard(cipher, fields) {
        cipher.card = new CardView();
        cipher.type = CipherType.Card;
        fields.forEach((field) => {
            if (this.isNullOrWhitespace(field.value) ||
                field.type === "section" ||
                field.type === "ccType") {
                return;
            }
            if (field.type === "ccName" && this.isNullOrWhitespace(cipher.card.cardholderName)) {
                cipher.card.cardholderName = field.value;
            }
            else if (field.type === "ccNumber" && this.isNullOrWhitespace(cipher.card.number)) {
                cipher.card.number = field.value;
                cipher.card.brand = this.getCardBrand(cipher.card.number);
            }
            else if (field.type === "ccCvc" && this.isNullOrWhitespace(cipher.card.code)) {
                cipher.card.code = field.value;
            }
            else if (field.type === "ccExpiry" && this.isNullOrWhitespace(cipher.card.expYear)) {
                if (!this.setCardExpiration(cipher, field.value)) {
                    this.processKvp(cipher, field.label, field.value, field.sensitive === 1 ? FieldType.Hidden : FieldType.Text);
                }
            }
            else {
                this.processKvp(cipher, field.label, field.value, field.sensitive === 1 ? FieldType.Hidden : FieldType.Text);
            }
        });
    }
    processNote(cipher, fields) {
        fields.forEach((field) => {
            if (this.isNullOrWhitespace(field.value) || field.type === "section") {
                return;
            }
            this.processKvp(cipher, field.label, field.value, field.sensitive === 1 ? FieldType.Hidden : FieldType.Text);
        });
    }
    buildFolderTree(folders) {
        if (folders == null) {
            return [];
        }
        const folderTree = [];
        const map = new Map([]);
        folders.forEach((obj) => {
            map.set(obj.uuid, obj);
            obj.children = [];
        });
        folders.forEach((obj) => {
            if (obj.parent_uuid != null && obj.parent_uuid !== "" && map.has(obj.parent_uuid)) {
                map.get(obj.parent_uuid).children.push(obj);
            }
            else {
                folderTree.push(obj);
            }
        });
        return folderTree;
    }
    flattenFolderTree(titlePrefix, tree, map) {
        if (tree == null) {
            return;
        }
        tree.forEach((f) => {
            if (f.title != null && f.title.trim() !== "") {
                let title = f.title.trim();
                if (titlePrefix != null && titlePrefix.trim() !== "") {
                    title = titlePrefix + "/" + title;
                }
                map.set(f.uuid, title);
                if (f.children != null && f.children.length !== 0) {
                    this.flattenFolderTree(title, f.children, map);
                }
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/enpass/index.ts



;// CONCATENATED MODULE: ../../libs/importer/src/importers/firefox-csv-importer.ts


class FirefoxCsvImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = this.parseCsv(data, true);
        if (results == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        results
            .filter((value) => {
            return value.url !== "chrome://FirefoxAccounts";
        })
            .forEach((value) => {
            const cipher = this.initLoginCipher();
            const url = this.getValueOrDefault(value.url, this.getValueOrDefault(value.hostname));
            cipher.name = this.getValueOrDefault(this.nameFromUrl(url), "--");
            cipher.login.username = this.getValueOrDefault(value.username);
            cipher.login.password = this.getValueOrDefault(value.password);
            cipher.login.uris = this.makeUriArray(url);
            this.cleanupCipher(cipher);
            result.ciphers.push(cipher);
        });
        result.success = true;
        return Promise.resolve(result);
    }
}

;// CONCATENATED MODULE: ../../libs/importer/src/importers/fsecure/fsecure-fsk-types.ts
var FskEntryTypesEnum;
(function (FskEntryTypesEnum) {
    FskEntryTypesEnum[FskEntryTypesEnum["Login"] = 1] = "Login";
    FskEntryTypesEnum[FskEntryTypesEnum["CreditCard"] = 2] = "CreditCard";
})(FskEntryTypesEnum || (FskEntryTypesEnum = {}));

;// CONCATENATED MODULE: ../../libs/importer/src/importers/fsecure/fsecure-fsk-importer.ts





class FSecureFskImporter extends base_importer_BaseImporter {
    parse(data) {
        const result = new import_result_ImportResult();
        const results = JSON.parse(data);
        if (results == null || results.data == null) {
            result.success = false;
            return Promise.resolve(result);
        }
        for (const key in results.data) {
            // eslint-disable-next-line
            if (!results.data.hasOwnProperty(key)) {
                continue;
            }
            const value = results.data[key];
            const cipher = this.parseEntry(value);
            result.ciphers.push(cipher);
        }
        result.success = true;
        return Promise.resolve(result);
    }
    parseEntry(entry) {
        const cipher = this.initLoginCipher();
        ciph