/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.security.MessageDigest;
import org.jruby.ext.openssl.impl.BIOFilter;

public class MessageDigestBIOFilter
extends BIOFilter {
    private MessageDigest md;

    public MessageDigestBIOFilter(MessageDigest md) {
        this.md = md;
    }

    @Override
    public int gets(byte[] in, int len) throws IOException {
        int read2 = this.next().gets(in, len);
        if (read2 > 0) {
            this.md.update(in, 0, read2);
        }
        return read2;
    }

    @Override
    public int read(byte[] into, int offset, int len) throws IOException {
        int read2 = this.next().read(into, offset, len);
        if (read2 > 0) {
            this.md.update(into, offset, read2);
        }
        return read2;
    }

    @Override
    public int write(byte[] out, int offset, int len) throws IOException {
        int written = this.next().write(out, offset, len);
        this.md.update(out, offset, written);
        return written;
    }

    @Override
    public int getType() {
        return 520;
    }

    public MessageDigest getMessageDigest() {
        return this.md;
    }
}

