/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.JIT;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class DynamicScope
implements Cloneable {
    protected final StaticScope staticScope;
    protected final DynamicScope parent;
    private EvalType evalType;
    private boolean lambda;

    protected DynamicScope(StaticScope staticScope, DynamicScope parent) {
        this.staticScope = staticScope;
        this.parent = parent;
        this.evalType = EvalType.NONE;
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent) {
        return staticScope.construct(parent);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent, EvalType evalType) {
        DynamicScope newScope = DynamicScope.newDynamicScope(staticScope, parent);
        newScope.setEvalType(evalType);
        return newScope;
    }

    public static DynamicScope newDummyScope(StaticScope staticScope, DynamicScope parent) {
        return DynamicScope.newDynamicScope(staticScope, parent);
    }

    public final DynamicScope getParentScope() {
        return this.parent;
    }

    @Deprecated
    public DynamicScope getNextCapturedScope() {
        return this.getParentScope();
    }

    public DynamicScope getNthParentScope(int n) {
        DynamicScope scope = this;
        for (int i2 = 0; i2 < n && scope != null; scope = scope.getParentScope(), ++i2) {
        }
        return scope;
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope) {
        return DynamicScope.newDynamicScope(staticScope, null);
    }

    public final StaticScope getStaticScope() {
        return this.staticScope;
    }

    public final String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope();
    }

    public void growIfNeeded() {
        throw new RuntimeException("BUG: scopes of type " + this.getClass().getName() + " cannot grow");
    }

    public IRubyObject[] getValues() {
        int numberOfVariables = this.staticScope.getNumberOfVariables();
        IRubyObject[] values2 = new IRubyObject[numberOfVariables];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            values2[i2] = this.getValueDepthZero(i2);
        }
        return values2;
    }

    @JIT
    public abstract IRubyObject getValue(int var1, int var2);

    @JIT
    public IRubyObject getValueDepthZero(int offset2) {
        return this.getValue(offset2, 0);
    }

    @JIT
    public IRubyObject getValueZeroDepthZero() {
        return this.getValueDepthZero(0);
    }

    @JIT
    public IRubyObject getValueOneDepthZero() {
        return this.getValueDepthZero(1);
    }

    @JIT
    public IRubyObject getValueTwoDepthZero() {
        return this.getValueDepthZero(2);
    }

    @JIT
    public IRubyObject getValueThreeDepthZero() {
        return this.getValueDepthZero(3);
    }

    @JIT
    public IRubyObject getValueFourDepthZero() {
        return this.getValueDepthZero(4);
    }

    @JIT
    public IRubyObject getValueFiveDepthZero() {
        return this.getValueDepthZero(5);
    }

    @JIT
    public IRubyObject getValueSixDepthZero() {
        return this.getValueDepthZero(6);
    }

    @JIT
    public IRubyObject getValueSevenDepthZero() {
        return this.getValueDepthZero(7);
    }

    @JIT
    public IRubyObject getValueEightDepthZero() {
        return this.getValueDepthZero(8);
    }

    @JIT
    public IRubyObject getValueNineDepthZero() {
        return this.getValueDepthZero(9);
    }

    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        IRubyObject value2 = this.getValueDepthZero(offset2);
        return value2 == null ? this.setValueDepthZero(nil, offset2) : value2;
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueZeroDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 0) : value2;
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueOneDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 1) : value2;
    }

    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueTwoDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 2) : value2;
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueThreeDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 3) : value2;
    }

    public IRubyObject getValueFourDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueFourDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 4) : value2;
    }

    public IRubyObject getValueFiveDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueFiveDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 5) : value2;
    }

    public IRubyObject getValueSixDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueSixDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 6) : value2;
    }

    public IRubyObject getValueSevenDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueSevenDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 7) : value2;
    }

    public IRubyObject getValueEightDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueEightDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 8) : value2;
    }

    public IRubyObject getValueNineDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.getValueNineDepthZero();
        return value2 == null ? this.setValueDepthZero(nil, 9) : value2;
    }

    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        this.setValueVoid(value2, offset2, depth);
        return value2;
    }

    public IRubyObject setValue(IRubyObject value2, int offset2, int depth) {
        this.setValueVoid(value2, offset2, depth);
        return value2;
    }

    @JIT
    public abstract void setValueVoid(IRubyObject var1, int var2, int var3);

    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        this.setValueDepthZeroVoid(value2, offset2);
        return value2;
    }

    @JIT
    public void setValueDepthZeroVoid(IRubyObject value2, int offset2) {
        this.setValueVoid(value2, offset2, 0);
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject value2) {
        this.setValueZeroDepthZeroVoid(value2);
        return value2;
    }

    @JIT
    public void setValueZeroDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 0);
    }

    public IRubyObject setValueOneDepthZero(IRubyObject value2) {
        this.setValueOneDepthZeroVoid(value2);
        return value2;
    }

    @JIT
    public void setValueOneDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 1);
    }

    public IRubyObject setValueTwoDepthZero(IRubyObject value2) {
        this.setValueTwoDepthZeroVoid(value2);
        return value2;
    }

    @JIT
    public void setValueTwoDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 2);
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject value2) {
        this.setValueThreeDepthZeroVoid(value2);
        return value2;
    }

    @JIT
    public void setValueThreeDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 3);
    }

    @JIT
    public void setValueFourDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 4);
    }

    @JIT
    public void setValueFiveDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 5);
    }

    @JIT
    public void setValueSixDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 6);
    }

    @JIT
    public void setValueSevenDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 7);
    }

    @JIT
    public void setValueEightDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 8);
    }

    @JIT
    public void setValueNineDepthZeroVoid(IRubyObject value2) {
        this.setValueDepthZeroVoid(value2, 9);
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope.isBlockScope() ? "block" : "local") + " [");
        int size2 = this.staticScope.getNumberOfVariables();
        IRubyObject[] variableValues = this.getValues();
        if (size2 != 0) {
            String[] names2 = this.staticScope.getVariables();
            for (int i2 = 0; i2 < size2 - 1; ++i2) {
                buf.append(names2[i2]).append("=");
                if (variableValues[i2] == null) {
                    buf.append("null");
                } else {
                    buf.append(variableValues[i2]);
                }
                buf.append(",");
            }
            buf.append(names2[size2 - 1]).append("=");
            assert (variableValues.length == names2.length) : "V: " + variableValues.length + " != N: " + names2.length + " for " + buf;
            if (variableValues[size2 - 1] == null) {
                buf.append("null");
            } else {
                buf.append(variableValues[size2 - 1]);
            }
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }

    public boolean inInstanceEval() {
        return this.evalType == EvalType.INSTANCE_EVAL;
    }

    public boolean inModuleEval() {
        return this.evalType == EvalType.MODULE_EVAL;
    }

    public boolean inBindingEval() {
        return this.evalType == EvalType.BINDING_EVAL;
    }

    public void setEvalType(EvalType evalType) {
        this.evalType = evalType == null ? EvalType.NONE : evalType;
    }

    public EvalType getEvalType() {
        return this.evalType;
    }

    public void clearEvalType() {
        this.evalType = EvalType.NONE;
    }

    public void setLambda(boolean lambda2) {
        this.lambda = lambda2;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    public boolean isReturnTarget() {
        StaticScope staticScope = this.staticScope;
        IRScopeType scopeType = staticScope.getScopeType();
        return scopeType.isMethodType() || scopeType == IRScopeType.SCRIPT_BODY || scopeType.isBlock() && (staticScope.isArgumentScope() || this.lambda);
    }

    @Deprecated
    public DynamicScope cloneScope() {
        try {
            return (DynamicScope)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("BUG: failed to clone scope type " + this.getClass().getName());
        }
    }
}

