/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Window;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.Permission;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.swing.SwingUtils;
import sun.awt.AppContext;

class JNLPSecurityManager
extends SecurityManager {
    private Object exitClass = null;
    private SecurityException closeAppEx = new SecurityException(Translator.R("RShutdown"));
    private WeakList<Window> weakWindows = new WeakList();
    private WeakList<ApplicationInstance> weakApplications = new WeakList();
    private boolean exitAllowed = true;
    private AppContext mainAppContext;

    JNLPSecurityManager() {
        if (!JNLPRuntime.isHeadless()) {
            SwingUtils.getOrCreateWindowOwner();
        }
        this.mainAppContext = AppContext.getAppContext();
    }

    public boolean isExitClass() {
        return this.isExitClass(this.getClassContext());
    }

    private boolean isExitClass(Class[] stack) {
        if (this.exitClass == null) {
            return true;
        }
        for (int i = 0; i < stack.length; ++i) {
            if (stack[i] != this.exitClass) continue;
            return true;
        }
        return false;
    }

    public void setExitClass(Class<?> exitClass) throws IllegalStateException {
        if (this.exitClass != null) {
            throw new IllegalStateException(Translator.R("RExitTaken"));
        }
        this.exitClass = exitClass;
    }

    protected ApplicationInstance getApplication() {
        return this.getApplication(Thread.currentThread(), this.getClassContext(), 0);
    }

    protected ApplicationInstance getApplication(Window window) {
        int i = this.weakWindows.size();
        while (i-- > 0) {
            Window w = this.weakWindows.get(i);
            if (w == null) {
                this.weakWindows.remove(i);
                this.weakApplications.remove(i);
            }
            if (w != window) continue;
            return this.weakApplications.get(i);
        }
        return null;
    }

    protected ApplicationInstance getApplication(Thread thread, Class<?>[] stack, int maxDepth) {
        JNLPClassLoader jnlpCl;
        ClassLoader cl;
        for (cl = thread.getContextClassLoader(); cl != null; cl = cl.getParent()) {
            jnlpCl = this.getJnlpClassLoader(cl);
            if (jnlpCl == null || jnlpCl.getApplication() == null) continue;
            return jnlpCl.getApplication();
        }
        if (maxDepth <= 0) {
            maxDepth = stack.length;
        }
        for (int i = 0; i < stack.length && i < maxDepth; ++i) {
            for (cl = stack[i].getClassLoader(); cl != null; cl = cl.getParent()) {
                jnlpCl = this.getJnlpClassLoader(cl);
                if (jnlpCl == null || jnlpCl.getApplication() == null) continue;
                return jnlpCl.getApplication();
            }
        }
        return null;
    }

    private JNLPClassLoader getJnlpClassLoader(ClassLoader cl) {
        if (cl instanceof JNLPClassLoader.CodeBaseClassLoader) {
            cl = ((JNLPClassLoader.CodeBaseClassLoader)cl).getParentJNLPClassLoader();
        }
        if (cl instanceof JNLPClassLoader) {
            JNLPClassLoader loader = (JNLPClassLoader)cl;
            return loader;
        }
        return null;
    }

    @Override
    public ThreadGroup getThreadGroup() {
        ApplicationInstance app = this.getApplication();
        if (app == null) {
            return super.getThreadGroup();
        }
        return app.getThreadGroup();
    }

    @Override
    public void checkPermission(Permission perm) {
        String name = perm.getName();
        if (!JNLPRuntime.isWebstartApplication() && ("setPolicy".equals(name) || "setSecurityManager".equals(name))) {
            throw new SecurityException(Translator.R("RCantReplaceSM"));
        }
        try {
            super.checkPermission(perm);
        }
        catch (SecurityException ex) {
            OutputController.getLogger().log("Denying permission: " + perm);
            throw ex;
        }
    }

    private boolean askPermission(Permission perm) {
        ApplicationInstance app = this.getApplication();
        return app != null && !app.isSigned() && perm instanceof SocketPermission && ServiceUtil.checkAccess(SecurityDialogs.AccessType.NETWORK, perm.getName());
    }

    private void addPermission(Permission perm) {
        if (JNLPRuntime.getApplication().getClassLoader() instanceof JNLPClassLoader) {
            JNLPClassLoader cl = (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
            cl.addPermission(perm);
            if (JNLPRuntime.isDebug()) {
                if (cl.getSecurity() == null) {
                    if (cl.getPermissions(null).implies(perm)) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Added permission: " + perm.toString());
                    } else {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to add permission: " + perm.toString());
                    }
                } else {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Cannot get permissions for null codesource when classloader security is not null");
                }
            }
        } else {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Unable to add permission: " + perm + ", classloader not JNLP.");
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        ApplicationInstance app = this.getApplication();
        if (app != null && window instanceof Window) {
            Window w = (Window)window;
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "SM: app: " + app.getTitle() + " is adding a window: " + window + " with appContext " + AppContext.getAppContext());
            this.weakWindows.add(w);
            this.weakApplications.add(app);
            app.addWindow(w);
        }
        return super.checkTopLevelWindow(window);
    }

    @Override
    public void checkExit(int status) {
        boolean realCall;
        Class[] stack = this.getClassContext();
        if (!this.exitAllowed) {
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i].getClassLoader() == null) continue;
                throw new AccessControlException("Applets may not call System.exit()");
            }
        }
        super.checkExit(status);
        boolean bl = realCall = stack[1] == Runtime.class;
        if (this.isExitClass(stack)) {
            return;
        }
        if (!realCall) {
            super.checkExit(status);
            return;
        }
        ApplicationInstance app = this.getApplication(Thread.currentThread(), stack, 0);
        if (app == null) {
            throw new SecurityException(Translator.R("RExitNoApp"));
        }
        app.destroy();
        throw this.closeAppEx;
    }

    protected void disableExit() {
        this.exitAllowed = false;
    }

    public void checkAwtEventQueueAccess() {
        super.checkAwtEventQueueAccess();
    }
}

