/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 25 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qjsonobject.sip"
#include <qjsonobject.h>
#line 29 "/build/pyqt6/src/PyQt6-6.3.1/build/QtCore/sipQtCoreQJsonObject.cpp"



extern "C" {static void assign_QJsonObject(void *, Py_ssize_t, void *);}
static void assign_QJsonObject(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QJsonObject *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QJsonObject *>(sipSrc);
}


extern "C" {static void *array_QJsonObject(Py_ssize_t);}
static void *array_QJsonObject(Py_ssize_t sipNrElem)
{
    return new  ::QJsonObject[sipNrElem];
}


extern "C" {static void *copy_QJsonObject(const void *, Py_ssize_t);}
static void *copy_QJsonObject(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QJsonObject(reinterpret_cast<const  ::QJsonObject *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QJsonObject(void *, int, void *);}
static void release_QJsonObject(void *sipCppV, int, void *)
{
     ::QJsonObject *sipCpp = reinterpret_cast< ::QJsonObject *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QJsonObject(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QJsonObject(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QJsonObject **sipCppPtr = reinterpret_cast< ::QJsonObject **>(sipCppPtrV);

#line 83 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qjsonobject.sip"
    if (!sipIsErr)
        return PyDict_Check(sipPy);

    QJsonObject *jo = new QJsonObject;

    Py_ssize_t pos = 0;
    PyObject *kobj, *vobj;
 
    while (PyDict_Next(sipPy, &pos, &kobj, &vobj))
    {
        int kstate;
        QString *k = reinterpret_cast<QString *>(
                sipForceConvertToType(kobj, sipType_QString, sipTransferObj,
                        SIP_NOT_NONE, &kstate, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "a key has type '%s' but 'str' is expected",
                    sipPyTypeName(Py_TYPE(kobj)));

            delete jo;

            return 0;
        }

        int vstate;
        QJsonValue *v = reinterpret_cast<QJsonValue *>(
                sipForceConvertToType(vobj, sipType_QJsonValue, sipTransferObj,
                        SIP_NOT_NONE, &vstate, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "a value has type '%s' but 'QJsonValue' is expected",
                    sipPyTypeName(Py_TYPE(vobj)));

            sipReleaseType(k, sipType_QString, kstate);
            delete jo;

            return 0;
        }

        jo->insert(*k, *v);

        sipReleaseType(v, sipType_QJsonValue, vstate);
        sipReleaseType(k, sipType_QString, kstate);
    }
 
    *sipCppPtr = jo;
 
    return sipGetState(sipTransferObj);
#line 122 "/build/pyqt6/src/PyQt6-6.3.1/build/QtCore/sipQtCoreQJsonObject.cpp"
}


extern "C" {static PyObject *convertFrom_QJsonObject(void *, PyObject *);}
static PyObject *convertFrom_QJsonObject(void *sipCppV, PyObject *sipTransferObj)
{
    ::QJsonObject *sipCpp = reinterpret_cast< ::QJsonObject *>(sipCppV);

#line 29 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qjsonobject.sip"
    PyObject *d = PyDict_New();

    if (!d)
        return 0;

    QJsonObject::const_iterator it = sipCpp->constBegin();
    QJsonObject::const_iterator end = sipCpp->constEnd();

    while (it != end)
    {
        QString *k = new QString(it.key());
        PyObject *kobj = sipConvertFromNewType(k, sipType_QString,
                sipTransferObj);

        if (!kobj)
        {
            delete k;
            Py_DECREF(d);

            return 0;
        }

        QJsonValue *v = new QJsonValue(it.value());
        PyObject *vobj = sipConvertFromNewType(v, sipType_QJsonValue,
                sipTransferObj);

        if (!vobj)
        {
            delete v;
            Py_DECREF(kobj);
            Py_DECREF(d);

            return 0;
        }

        int rc = PyDict_SetItem(d, kobj, vobj);

        Py_DECREF(vobj);
        Py_DECREF(kobj);

        if (rc < 0)
        {
            Py_DECREF(d);

            return 0;
        }

        ++it;
    }

    return d;
#line 183 "/build/pyqt6/src/PyQt6-6.3.1/build/QtCore/sipQtCoreQJsonObject.cpp"
}


sipMappedTypeDef sipTypeDef_QtCore_QJsonObject = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_QJsonObject,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_QJsonObject,
    array_QJsonObject,
    copy_QJsonObject,
    release_QJsonObject,
    convertTo_QJsonObject,
    convertFrom_QJsonObject
};
