/* tracker-main.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-main.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-data/tracker-data-manager.h"
#include <gio/gio.h>
#include "tracker-store/tracker-config.h"
#include <signal.h>
#include <glib-unix.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <locale.h>
#include <time.h>
#include "libtracker-data/tracker-db-config.h"
#include "libtracker-common/tracker-domain-ontology.h"
#include "libtracker-data/tracker-db-manager.h"
#include "tracker-store/tracker-events.h"
#include "tracker-store/tracker-writeback.h"
#include <gobject/gvaluecollector.h>

#define TRACKER_MAIN_LICENSE "This program is free software and comes without any warranty.\n" \
"It is licensed under version 2 or later of the General Public\n" \
"License which can be viewed at:\n" \
"  http://www.gnu.org/licenses/gpl.txt\n"
#define TRACKER_MAIN_SELECT_CACHE_SIZE 100
#define TRACKER_MAIN_UPDATE_CACHE_SIZE 100
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TRACKER_TYPE_MAIN (tracker_main_get_type ())
#define TRACKER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_MAIN, TrackerMain))
#define TRACKER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_MAIN, TrackerMainClass))
#define TRACKER_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_MAIN))
#define TRACKER_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_MAIN))
#define TRACKER_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_MAIN, TrackerMainClass))

typedef struct _TrackerMain TrackerMain;
typedef struct _TrackerMainClass TrackerMainClass;
typedef struct _TrackerMainPrivate TrackerMainPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _tracker_domain_ontology_unref0(var) ((var == NULL) ? NULL : (var = (tracker_domain_ontology_unref (var), NULL)))

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
typedef void (*TrackerStoreStateCallback) (gpointer user_data);
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _TrackerParamSpecMain TrackerParamSpecMain;

struct _TrackerMain {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerMainPrivate * priv;
};

struct _TrackerMainClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerMain *self);
};

struct _TrackerParamSpecMain {
	GParamSpec parent_instance;
};

static gpointer tracker_main_parent_class = NULL;
static gboolean tracker_main_version;
static gint tracker_main_verbosity;
static gboolean tracker_main_disable_shutdown;
static gboolean tracker_main_force_reindex;
static gboolean tracker_main_readonly_mode;
static gchar* tracker_main_domain_ontology;
static GMainLoop* tracker_main_main_loop;
static GMainLoop* tracker_main_main_loop = NULL;
static gchar* tracker_main_log_filename;
static gchar* tracker_main_log_filename = NULL;
static guint tracker_main_shutdown_timeout_id;
static guint tracker_main_shutdown_timeout_id = 0U;
static gboolean tracker_main_shutdown;
static gboolean tracker_main_shutdown = FALSE;
static TrackerDirectConnection* tracker_main_connection;
static TrackerDirectConnection* tracker_main_connection = NULL;
static TrackerDataManager* tracker_main_data_manager;
static TrackerDataManager* tracker_main_data_manager = NULL;
static gboolean tracker_main_version = FALSE;
static gint tracker_main_verbosity = 0;
static gboolean tracker_main_force_reindex = FALSE;
static gboolean tracker_main_readonly_mode = FALSE;
static gchar* tracker_main_domain_ontology = NULL;
static GFile* tracker_main_cache_location;
static GFile* tracker_main_cache_location = NULL;
static GFile* tracker_main_data_location;
static GFile* tracker_main_data_location = NULL;
static GFile* tracker_main_ontology_location;
static GFile* tracker_main_ontology_location = NULL;
static gchar* tracker_main_domain;
static gchar* tracker_main_domain = NULL;
static gboolean tracker_main_disable_shutdown = FALSE;
static gboolean tracker_main_in_loop;
static gboolean tracker_main_in_loop = FALSE;

VALA_EXTERN gpointer tracker_main_ref (gpointer instance);
VALA_EXTERN void tracker_main_unref (gpointer instance);
VALA_EXTERN GParamSpec* tracker_param_spec_main (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void tracker_value_set_main (GValue* value,
                             gpointer v_object);
VALA_EXTERN void tracker_value_take_main (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer tracker_value_get_main (const GValue* value);
VALA_EXTERN GType tracker_main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerMain, tracker_main_unref)
static void tracker_main_sanity_check_option_values (TrackerConfig* config);
static void tracker_main_do_shutdown (void);
static gboolean tracker_main_shutdown_timeout_cb (void);
static gboolean tracker_main_signal_handler (gint signo);
static void tracker_main_initialize_signal_handler (void);
static gboolean __lambda4_ (void);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (void);
static gboolean ___lambda5__gsource_func (gpointer self);
static void tracker_main_initialize_priority (void);
static gchar** tracker_main_get_writeback_predicates (void);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void tracker_main_config_verbosity_changed_cb (GObject* object,
                                               GParamSpec* spec);
VALA_EXTERN TrackerDataManager* tracker_main_get_data_manager (void);
VALA_EXTERN TrackerDirectConnection* tracker_main_get_sparql_connection (void);
static gboolean tracker_main_shutdown_timeout (void);
static void tracker_main_idle_cb (void);
static gboolean _tracker_main_shutdown_timeout_gsource_func (gpointer self);
static void tracker_main_busy_cb (void);
static gint tracker_main_main (gchar** args,
                        gint args_length1);
VALA_EXTERN gboolean tracker_dbus_init (void);
static void _tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
VALA_EXTERN GType tracker_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStatus, g_object_unref)
VALA_EXTERN guint tracker_status_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN TrackerStatus* tracker_dbus_register_notifier (void);
VALA_EXTERN void tracker_store_init (TrackerConfig* config_p,
                         TrackerStoreStateCallback idle,
                         gpointer idle_target,
                         TrackerStoreStateCallback busy,
                         gpointer busy_target);
static void _tracker_main_idle_cb_tracker_store_state_callback (gpointer self);
static void _tracker_main_busy_cb_tracker_store_state_callback (gpointer self);
VALA_EXTERN gboolean tracker_dbus_register_objects (void);
VALA_EXTERN gboolean tracker_dbus_register_names (const gchar* domain);
VALA_EXTERN gboolean tracker_dbus_register_prepare_class_signal (void);
static gchar** _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (gint* result_length1);
VALA_EXTERN void tracker_store_resume (void);
VALA_EXTERN void tracker_dbus_watch_domain (const gchar* domain,
                                GMainLoop* main_loop);
VALA_EXTERN void tracker_store_shutdown (void);
static gboolean _tracker_main_shutdown_timeout_cb_gsource_func (gpointer self);
VALA_EXTERN void tracker_dbus_shutdown (void);
VALA_EXTERN TrackerMain* tracker_main_new (void);
VALA_EXTERN TrackerMain* tracker_main_construct (GType object_type);
static void tracker_main_finalize (TrackerMain * obj);
static GType tracker_main_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry TRACKER_MAIN_entries[7] = {{"version", 'V', (gint) 0, G_OPTION_ARG_NONE, &tracker_main_version, N_ ("Displays version information"), NULL}, {"verbosity", 'v', (gint) 0, G_OPTION_ARG_INT, &tracker_main_verbosity, N_ ("Logging, 0 = errors only, 1 = minimal, 2 = detailed and 3 = debug (def" \
"ault = 0)"), NULL}, {"disable-shutdown", 's', (gint) 0, G_OPTION_ARG_NONE, &tracker_main_disable_shutdown, N_ ("Disable automatic shutdown"), NULL}, {"force-reindex", 'r', (gint) 0, G_OPTION_ARG_NONE, &tracker_main_force_reindex, N_ ("Force a re-index of all content"), NULL}, {"readonly-mode", 'n', (gint) 0, G_OPTION_ARG_NONE, &tracker_main_readonly_mode, N_ ("Only allow read based actions on the database"), NULL}, {"domain-ontology", 'd', (gint) 0, G_OPTION_ARG_STRING, &tracker_main_domain_ontology, N_ ("Load a specified domain ontology"), NULL}, {NULL}};

static void
tracker_main_sanity_check_option_values (TrackerConfig* config)
{
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp7_;
	GFile* _tmp9_;
	GFile* _tmp13_;
	GFile* _tmp17_;
	g_return_if_fail (config != NULL);
	g_message ("General options:");
	_tmp0_ = tracker_config_get_verbosity (config);
	_tmp1_ = _tmp0_;
	g_message ("  Verbosity  ............................  %d", _tmp1_);
	g_message ("Store options:");
	if (tracker_main_readonly_mode) {
		_tmp2_ = "yes";
	} else {
		_tmp2_ = "no";
	}
	g_message ("  Readonly mode  ........................  %s", _tmp2_);
	_tmp3_ = tracker_config_get_graphupdated_delay (config);
	_tmp4_ = _tmp3_;
	g_message ("  GraphUpdated Delay ....................  %d", _tmp4_);
	_tmp5_ = tracker_main_domain_ontology;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = tracker_main_domain_ontology;
		g_message ("  Domain ontology........................  %s", _tmp6_);
	}
	_tmp7_ = tracker_main_domain;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = tracker_main_domain;
		g_message ("  Domain.................................  %s", _tmp8_);
	}
	_tmp9_ = tracker_main_cache_location;
	if (_tmp9_ != NULL) {
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = tracker_main_cache_location;
		_tmp11_ = g_file_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		g_message ("  Cache location.........................  %s", _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = tracker_main_data_location;
	if (_tmp13_ != NULL) {
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = tracker_main_data_location;
		_tmp15_ = g_file_get_uri (_tmp14_);
		_tmp16_ = _tmp15_;
		g_message ("  Data location..........................  %s", _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = tracker_main_ontology_location;
	if (_tmp17_ != NULL) {
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = tracker_main_ontology_location;
		_tmp19_ = g_file_get_uri (_tmp18_);
		_tmp20_ = _tmp19_;
		g_message ("  Ontology location......................  %s", _tmp20_);
		_g_free0 (_tmp20_);
	}
}

static void
tracker_main_do_shutdown (void)
{
	GMainLoop* _tmp0_;
	_tmp0_ = tracker_main_main_loop;
	if (_tmp0_ != NULL) {
		GMainLoop* _tmp1_;
		_tmp1_ = tracker_main_main_loop;
		g_main_loop_quit (_tmp1_);
	}
	tracker_main_shutdown = TRUE;
}

static gboolean
tracker_main_shutdown_timeout_cb (void)
{
	g_critical ("Could not exit in a timely fashion - terminating...");
	exit (1);
}

static gboolean
tracker_main_signal_handler (gint signo)
{
	gboolean result;
	if (tracker_main_in_loop) {
		exit (1);
	}
	switch (signo) {
		case SIGTERM:
		case SIGINT:
		{
			const gchar* _tmp0_;
			tracker_main_in_loop = TRUE;
			tracker_main_do_shutdown ();
			_tmp0_ = g_strsignal (signo);
			if (_tmp0_ != NULL) {
				const gchar* _tmp1_;
				g_print ("\n");
				_tmp1_ = g_strsignal (signo);
				g_print ("Received signal:%d->'%s'", signo, _tmp1_);
			}
			break;
		}
		default:
		{
			const gchar* _tmp2_;
			_tmp2_ = g_strsignal (signo);
			if (_tmp2_ != NULL) {
				const gchar* _tmp3_;
				g_print ("\n");
				_tmp3_ = g_strsignal (signo);
				g_print ("Received signal:%d->'%s'", signo, _tmp3_);
			}
			break;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
__lambda4_ (void)
{
	gboolean result;
	result = tracker_main_signal_handler ((gint) SIGTERM);
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ();
	return result;
}

static gboolean
__lambda5_ (void)
{
	gboolean result;
	result = tracker_main_signal_handler ((gint) SIGINT);
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ();
	return result;
}

static void
tracker_main_initialize_signal_handler (void)
{
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGTERM, ___lambda4__gsource_func, NULL, NULL);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGINT, ___lambda5__gsource_func, NULL, NULL);
}

static void
tracker_main_initialize_priority (void)
{
	tracker_ioprio_init ();
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
tracker_main_get_writeback_predicates (void)
{
	gchar** predicates_to_signal = NULL;
	gint predicates_to_signal_length1;
	gint _predicates_to_signal_size_;
	GError* _inner_error0_ = NULL;
	gchar** result;
	predicates_to_signal = NULL;
	predicates_to_signal_length1 = 0;
	_predicates_to_signal_size_ = predicates_to_signal_length1;
	{
		TrackerDBCursor* cursor = NULL;
		TrackerDataManager* _tmp0_;
		TrackerDBCursor* _tmp1_;
		_tmp0_ = tracker_main_data_manager;
		_tmp1_ = tracker_data_query_sparql_cursor (_tmp0_, "SELECT ?predicate WHERE { ?predicate tracker:writeback true }", &_inner_error0_);
		cursor = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			TrackerDBCursor* _tmp3_;
			TrackerDBCursor* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp3_ = cursor;
			_tmp2_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (cursor);
				goto __catch0_g_error;
			}
			if (!_tmp2_) {
				break;
			}
			_tmp4_ = cursor;
			_tmp5_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp4_, 0, NULL);
			_tmp6_ = g_strdup (_tmp5_);
			_vala_array_add1 (&predicates_to_signal, &predicates_to_signal_length1, &_predicates_to_signal_size_, _tmp6_);
		}
		_g_object_unref0 (cursor);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("Unable to retrieve tracker:writeback properties: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		predicates_to_signal = (_vala_array_free (predicates_to_signal, predicates_to_signal_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = predicates_to_signal;
	return result;
}

static void
tracker_main_config_verbosity_changed_cb (GObject* object,
                                          GParamSpec* spec)
{
	gint verbosity = 0;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (object != NULL);
	_tmp0_ = tracker_config_get_verbosity (G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_CONFIG, TrackerConfig));
	_tmp1_ = _tmp0_;
	verbosity = _tmp1_;
	if (verbosity > 0) {
		_tmp2_ = "enabling";
	} else {
		_tmp2_ = "disabling";
	}
	g_message ("Log verbosity is set to %d, %s D-Bus client lookup", verbosity, _tmp2_);
	tracker_dbus_enable_client_lookup (verbosity > 0);
}

TrackerDataManager*
tracker_main_get_data_manager (void)
{
	TrackerDataManager* _tmp0_;
	TrackerDataManager* result;
	_tmp0_ = tracker_main_data_manager;
	result = _tmp0_;
	return result;
}

TrackerDirectConnection*
tracker_main_get_sparql_connection (void)
{
	TrackerDirectConnection* _tmp0_;
	TrackerDirectConnection* result;
	_tmp0_ = tracker_main_connection;
	result = _tmp0_;
	return result;
}

static gboolean
tracker_main_shutdown_timeout (void)
{
	gboolean result;
	g_message ("Store shutting down after timeout");
	tracker_main_do_shutdown ();
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_tracker_main_shutdown_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_main_shutdown_timeout ();
	return result;
}

static void
tracker_main_idle_cb (void)
{
	if (tracker_ipc_bus () != G_BUS_TYPE_SESSION) {
		return;
	}
	if (tracker_main_shutdown_timeout_id != ((guint) 0)) {
		return;
	}
	if (tracker_main_disable_shutdown) {
		return;
	}
	g_message ("Store is idle, setting shutdown timeout");
	tracker_main_shutdown_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, _tracker_main_shutdown_timeout_gsource_func, NULL, NULL);
}

static void
tracker_main_busy_cb (void)
{
	if (tracker_main_shutdown_timeout_id == ((guint) 0)) {
		return;
	}
	g_message ("Store is busy, removing shutdown timeout");
	g_source_remove (tracker_main_shutdown_timeout_id);
	tracker_main_shutdown_timeout_id = (guint) 0;
}

static void
_tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	tracker_main_config_verbosity_changed_cb (_sender, pspec);
}

static void
_tracker_main_idle_cb_tracker_store_state_callback (gpointer self)
{
	tracker_main_idle_cb ();
}

static void
_tracker_main_busy_cb_tracker_store_state_callback (gpointer self)
{
	tracker_main_busy_cb ();
}

static gchar**
_tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (gint* result_length1)
{
	gchar** result;
	result = tracker_main_get_writeback_predicates ();
	return result;
}

static gboolean
_tracker_main_shutdown_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_main_shutdown_timeout_cb ();
	return result;
}

static gint
tracker_main_main (gchar** args,
                   gint args_length1)
{
	TrackerConfig* config = NULL;
	TrackerConfig* _tmp6_;
	TrackerDBConfig* db_config = NULL;
	TrackerDBConfig* _tmp7_;
	TrackerConfig* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	TrackerDomainOntology* domain_ontology_config = NULL;
	TrackerDomainOntology* _tmp23_;
	GFile* _tmp24_;
	TrackerDomainOntology* _tmp25_;
	GFile* _tmp26_;
	TrackerDomainOntology* _tmp27_;
	GFile* _tmp28_;
	TrackerDomainOntology* _tmp29_;
	gchar* _tmp30_;
	TrackerConfig* _tmp31_;
	TrackerConfig* _tmp32_;
	gulong config_verbosity_id = 0UL;
	TrackerConfig* _tmp33_;
	gulong _tmp34_;
	TrackerDBManagerFlags flags = 0;
	TrackerStatus* notifier = NULL;
	TrackerStatus* _tmp35_;
	TrackerConfig* _tmp36_;
	const gchar* _tmp37_;
	gint chunk_size_mb = 0;
	TrackerDBConfig* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gsize chunk_size = 0UL;
	gchar* rotate_to = NULL;
	TrackerDBConfig* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gboolean do_rotating = FALSE;
	const gchar* _tmp45_;
	TrackerDirectConnection* _tmp56_;
	TrackerDataManager* _tmp57_;
	TrackerConfig* _tmp66_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	tzset ();
	tracker_main_verbosity = -1;
	{
		GOptionContext* context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		_tmp0_ = g_option_context_new (_ ("— start the tracker daemon"));
		context = _tmp0_;
		_tmp1_ = context;
		g_option_context_add_main_entries (_tmp1_, TRACKER_MAIN_entries, NULL);
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_option_context_free0 (context);
			goto __catch0_g_error;
		}
		_g_option_context_free0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_printerr ("Invalid arguments, %s\n", _tmp4_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp5_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	if (tracker_main_version) {
		g_print ("%s", "\nTracker " PACKAGE_VERSION "\n\n" TRACKER_MAIN_LICENSE "\n");
		result = 0;
		return result;
	}
	tracker_main_initialize_priority ();
	_tmp6_ = tracker_config_new ();
	config = _tmp6_;
	_tmp7_ = tracker_db_config_new ();
	db_config = _tmp7_;
	if (tracker_main_verbosity > -1) {
		TrackerConfig* _tmp8_;
		_tmp8_ = config;
		tracker_config_set_verbosity (_tmp8_, tracker_main_verbosity);
	}
	_tmp9_ = config;
	_tmp10_ = tracker_config_get_verbosity (_tmp9_);
	_tmp11_ = _tmp10_;
	tracker_log_init (_tmp11_, &_tmp12_);
	_g_free0 (tracker_main_log_filename);
	tracker_main_log_filename = _tmp12_;
	_tmp13_ = tracker_main_log_filename;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = tracker_main_log_filename;
		g_message ("Using log file:'%s'", _tmp14_);
	}
	{
		TrackerDomainOntology* _tmp15_ = NULL;
		const gchar* _tmp16_;
		TrackerDomainOntology* _tmp17_;
		TrackerDomainOntology* _tmp18_;
		_tmp16_ = tracker_main_domain_ontology;
		_tmp17_ = tracker_domain_ontology_new (_tmp16_, NULL, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		domain_ontology_config = _tmp18_;
		_tracker_domain_ontology_unref0 (_tmp15_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = tracker_main_domain_ontology;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_critical ("Could not load domain ontology definition '%s': %s", _tmp19_, _tmp21_);
		result = -1;
		_g_error_free0 (e);
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		_g_object_unref0 (db_config);
		_g_object_unref0 (config);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp22_ = -1;
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		_g_object_unref0 (db_config);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp22_;
	}
	_tmp23_ = domain_ontology_config;
	_tmp24_ = tracker_domain_ontology_get_cache (_tmp23_);
	_g_object_unref0 (tracker_main_cache_location);
	tracker_main_cache_location = _tmp24_;
	_tmp25_ = domain_ontology_config;
	_tmp26_ = tracker_domain_ontology_get_journal (_tmp25_);
	_g_object_unref0 (tracker_main_data_location);
	tracker_main_data_location = _tmp26_;
	_tmp27_ = domain_ontology_config;
	_tmp28_ = tracker_domain_ontology_get_ontology (_tmp27_);
	_g_object_unref0 (tracker_main_ontology_location);
	tracker_main_ontology_location = _tmp28_;
	_tmp29_ = domain_ontology_config;
	_tmp30_ = tracker_domain_ontology_get_domain (_tmp29_, "Tracker1");
	_g_free0 (tracker_main_domain);
	tracker_main_domain = _tmp30_;
	_tmp31_ = config;
	tracker_main_sanity_check_option_values (_tmp31_);
	if (!tracker_dbus_init ()) {
		result = 1;
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		_g_object_unref0 (db_config);
		_g_object_unref0 (config);
		return result;
	}
	_tmp32_ = config;
	tracker_main_config_verbosity_changed_cb ((GObject*) _tmp32_, NULL);
	_tmp33_ = config;
	_tmp34_ = g_signal_connect ((GObject*) _tmp33_, "notify::verbosity", (GCallback) _tracker_main_config_verbosity_changed_cb_g_object_notify, NULL);
	config_verbosity_id = _tmp34_;
	flags = 0;
	if (tracker_main_force_reindex) {
		flags |= TRACKER_DB_MANAGER_FORCE_REINDEX;
	}
	tracker_direct_connection_set_default_flags (flags);
	_tmp35_ = tracker_dbus_register_notifier ();
	notifier = _tmp35_;
	_tmp36_ = config;
	tracker_store_init (_tmp36_, _tracker_main_idle_cb_tracker_store_state_callback, NULL, _tracker_main_busy_cb_tracker_store_state_callback, NULL);
	if (!tracker_dbus_register_objects ()) {
		result = 1;
		_g_object_unref0 (notifier);
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		_g_object_unref0 (db_config);
		_g_object_unref0 (config);
		return result;
	}
	_tmp37_ = tracker_main_domain;
	if (!tracker_dbus_register_names (_tmp37_)) {
		result = 1;
		_g_object_unref0 (notifier);
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		_g_object_unref0 (db_config);
		_g_object_unref0 (config);
		return result;
	}
	_tmp38_ = db_config;
	_tmp39_ = tracker_db_config_get_journal_chunk_size (_tmp38_);
	_tmp40_ = _tmp39_;
	chunk_size_mb = _tmp40_;
	chunk_size = (gsize) ((((gsize) chunk_size_mb) * ((gsize) 1024)) * ((gsize) 1024));
	_tmp41_ = db_config;
	_tmp42_ = tracker_db_config_get_journal_rotate_destination (_tmp41_);
	_tmp43_ = _tmp42_;
	rotate_to = _tmp43_;
	_tmp44_ = rotate_to;
	if (g_strcmp0 (_tmp44_, "") == 0) {
		_g_free0 (rotate_to);
		rotate_to = NULL;
	}
	do_rotating = chunk_size_mb != -1;
	_tmp45_ = rotate_to;
	tracker_db_journal_set_rotating (do_rotating, chunk_size, _tmp45_);
	{
		TrackerDirectConnection* _tmp46_ = NULL;
		GFile* _tmp47_;
		GFile* _tmp48_;
		GFile* _tmp49_;
		TrackerDirectConnection* _tmp50_;
		TrackerDirectConnection* _tmp51_;
		TrackerDirectConnection* _tmp52_;
		_tmp47_ = tracker_main_cache_location;
		_tmp48_ = tracker_main_data_location;
		_tmp49_ = tracker_main_ontology_location;
		_tmp50_ = tracker_direct_connection_new (TRACKER_SPARQL_CONNECTION_FLAGS_NONE, _tmp47_, _tmp48_, _tmp49_, &_inner_error0_);
		_tmp46_ = _tmp50_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp51_ = _tmp46_;
		_tmp46_ = NULL;
		_g_object_unref0 (tracker_main_connection);
		tracker_main_connection = _tmp51_;
		_tmp52_ = tracker_main_connection;
		g_initable_init ((GInitable*) _tmp52_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp46_);
			goto __catch2_g_error;
		}
		_g_object_unref0 (_tmp46_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp53_;
		const gchar* _tmp54_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp53_ = e;
		_tmp54_ = _tmp53_->message;
		g_critical ("Cannot initialize database: %s", _tmp54_);
		result = 1;
		_g_error_free0 (e);
		_g_free0 (rotate_to);
		_g_object_unref0 (notifier);
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		_g_object_unref0 (db_config);
		_g_object_unref0 (config);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp55_ = -1;
		_g_free0 (rotate_to);
		_g_object_unref0 (notifier);
		_tracker_domain_ontology_unref0 (domain_ontology_config);
		_g_object_unref0 (db_config);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp55_;
	}
	_tmp56_ = tracker_main_connection;
	_tmp57_ = tracker_direct_connection_get_data_manager (_tmp56_);
	_g_object_unref0 (tracker_main_data_manager);
	tracker_main_data_manager = _tmp57_;
	_g_object_unref0 (db_config);
	db_config = NULL;
	_g_object_unref0 (notifier);
	notifier = NULL;
	if (!tracker_main_shutdown) {
		TrackerDataManager* _tmp58_;
		tracker_dbus_register_prepare_class_signal ();
		tracker_events_init ();
		_tmp58_ = tracker_main_data_manager;
		tracker_writeback_init (_tmp58_, _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func);
		tracker_store_resume ();
		g_message ("Waiting for D-Bus requests...");
	}
	if (!tracker_main_shutdown) {
		GMainLoop* _tmp59_;
		const gchar* _tmp60_;
		GMainLoop* _tmp65_;
		_tmp59_ = g_main_loop_new (NULL, FALSE);
		_g_main_loop_unref0 (tracker_main_main_loop);
		tracker_main_main_loop = _tmp59_;
		_tmp60_ = tracker_main_domain_ontology;
		if (_tmp60_ != NULL) {
			TrackerDomainOntology* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			GMainLoop* _tmp64_;
			_tmp61_ = domain_ontology_config;
			_tmp62_ = tracker_domain_ontology_get_domain (_tmp61_, NULL);
			_tmp63_ = _tmp62_;
			_tmp64_ = tracker_main_main_loop;
			tracker_dbus_watch_domain (_tmp63_, _tmp64_);
			_g_free0 (_tmp63_);
		}
		tracker_main_initialize_signal_handler ();
		_tmp65_ = tracker_main_main_loop;
		g_main_loop_run (_tmp65_);
	}
	g_message ("Shutdown started");
	tracker_store_shutdown ();
	g_timeout_add_full (G_PRIORITY_LOW, (guint) 5000, _tracker_main_shutdown_timeout_cb_gsource_func, NULL, NULL);
	g_message ("Cleaning up");
	_g_object_unref0 (tracker_main_data_manager);
	tracker_main_data_manager = NULL;
	_g_object_unref0 (tracker_main_connection);
	tracker_main_connection = NULL;
	tracker_writeback_shutdown ();
	tracker_events_shutdown ();
	tracker_dbus_shutdown ();
	tracker_log_shutdown ();
	_tmp66_ = config;
	g_signal_handler_disconnect ((GObject*) _tmp66_, config_verbosity_id);
	_g_object_unref0 (config);
	config = NULL;
	tracker_db_journal_set_rotating (chunk_size_mb != -1, chunk_size, NULL);
	g_print ("\nOK\n\n");
	_g_free0 (tracker_main_log_filename);
	tracker_main_log_filename = NULL;
	_g_main_loop_unref0 (tracker_main_main_loop);
	tracker_main_main_loop = NULL;
	result = 0;
	_g_free0 (rotate_to);
	_g_object_unref0 (notifier);
	_tracker_domain_ontology_unref0 (domain_ontology_config);
	_g_object_unref0 (db_config);
	_g_object_unref0 (config);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return tracker_main_main (argv, argc);
}

TrackerMain*
tracker_main_construct (GType object_type)
{
	TrackerMain* self = NULL;
	self = (TrackerMain*) g_type_create_instance (object_type);
	return self;
}

TrackerMain*
tracker_main_new (void)
{
	return tracker_main_construct (TRACKER_TYPE_MAIN);
}

static void
tracker_value_main_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tracker_value_main_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tracker_main_unref (value->data[0].v_pointer);
	}
}

static void
tracker_value_main_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_main_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tracker_value_main_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tracker_value_main_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TrackerMain * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_main_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tracker_value_main_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	TrackerMain ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_main_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tracker_param_spec_main (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	TrackerParamSpecMain* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_MAIN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tracker_value_get_main (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN), NULL);
	return value->data[0].v_pointer;
}

void
tracker_value_set_main (GValue* value,
                        gpointer v_object)
{
	TrackerMain * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_main_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_main_unref (old);
	}
}

void
tracker_value_take_main (GValue* value,
                         gpointer v_object)
{
	TrackerMain * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_main_unref (old);
	}
}

static void
tracker_main_class_init (TrackerMainClass * klass,
                         gpointer klass_data)
{
	tracker_main_parent_class = g_type_class_peek_parent (klass);
	((TrackerMainClass *) klass)->finalize = tracker_main_finalize;
}

static void
tracker_main_instance_init (TrackerMain * self,
                            gpointer klass)
{
	self->ref_count = 1;
}

static void
tracker_main_finalize (TrackerMain * obj)
{
	TrackerMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_MAIN, TrackerMain);
	g_signal_handlers_destroy (self);
}

static GType
tracker_main_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tracker_value_main_init, tracker_value_main_free_value, tracker_value_main_copy_value, tracker_value_main_peek_pointer, "p", tracker_value_main_collect_value, "p", tracker_value_main_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TrackerMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMain), 0, (GInstanceInitFunc) tracker_main_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tracker_main_type_id;
	tracker_main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerMain", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tracker_main_type_id;
}

GType
tracker_main_get_type (void)
{
	static volatile gsize tracker_main_type_id__once = 0;
	if (g_once_init_enter (&tracker_main_type_id__once)) {
		GType tracker_main_type_id;
		tracker_main_type_id = tracker_main_get_type_once ();
		g_once_init_leave (&tracker_main_type_id__once, tracker_main_type_id);
	}
	return tracker_main_type_id__once;
}

gpointer
tracker_main_ref (gpointer instance)
{
	TrackerMain * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tracker_main_unref (gpointer instance)
{
	TrackerMain * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_MAIN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

