/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.text;

import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TextProperties;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.text.ColorMode;
import org.gephi.visualization.text.FixedSizeMode;
import org.gephi.visualization.text.ObjectColorMode;
import org.gephi.visualization.text.ProportionalSizeMode;
import org.gephi.visualization.text.ScaledSizeMode;
import org.gephi.visualization.text.SizeMode;
import org.gephi.visualization.text.TextColorMode;
import org.gephi.visualization.text.TextModelImpl;
import org.gephi.visualization.text.UniqueColorMode;

public class TextManager
implements VizArchitecture {
    private final SizeMode[] sizeModes = new SizeMode[3];
    private final ColorMode[] colorModes;
    private VizConfig vizConfig;
    private GraphDrawable drawable;
    private Renderer nodeRenderer;
    private Renderer edgeRenderer;
    private TextModelImpl model;
    private boolean nodeRefresh = true;
    private boolean edgeRefresh = true;
    private float cachedCameraLocationZ;
    private boolean mipmap;
    private boolean fractionalMetrics;
    private boolean antialised;

    public TextManager() {
        this.sizeModes[0] = new FixedSizeMode();
        this.sizeModes[1] = new ScaledSizeMode();
        this.sizeModes[2] = new ProportionalSizeMode();
        this.colorModes = new ColorMode[3];
        this.colorModes[0] = new UniqueColorMode();
        this.colorModes[1] = new ObjectColorMode();
        this.colorModes[2] = new TextColorMode();
    }

    @Override
    public void initArchitecture() {
        this.model = VizController.getInstance().getVizModel().getTextModel();
        this.vizConfig = VizController.getInstance().getVizConfig();
        this.drawable = VizController.getInstance().getDrawable();
        this.antialised = this.vizConfig.isLabelAntialiased();
        this.mipmap = this.vizConfig.isLabelMipMap();
        this.fractionalMetrics = this.vizConfig.isLabelFractionalMetrics();
        this.initRenderer();
        for (SizeMode s : this.sizeModes) {
            s.init();
        }
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!TextManager.this.nodeRenderer.getFont().equals(TextManager.this.model.getNodeFont())) {
                    TextManager.this.nodeRenderer.setFont(TextManager.this.model.getNodeFont());
                }
                if (!TextManager.this.edgeRenderer.getFont().equals(TextManager.this.model.getEdgeFont())) {
                    TextManager.this.edgeRenderer.setFont(TextManager.this.model.getEdgeFont());
                }
                TextManager.this.nodeRefresh = true;
                TextManager.this.edgeRefresh = true;
            }
        });
        VizController.getInstance().getVizModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("init")) {
                    TextManager.this.model = VizController.getInstance().getVizModel().getTextModel();
                    if (TextManager.this.model.getNodeTextColumns() == null || TextManager.this.model.getNodeTextColumns().length == 0) {
                        TextManager.this.model.setTextColumns(new Column[0], new Column[0]);
                    }
                }
            }
        });
    }

    public void reinitRenderers() {
        this.nodeRenderer.reinitRenderer();
        this.edgeRenderer.reinitRenderer();
        this.nodeRefresh = true;
        this.edgeRefresh = true;
    }

    private void initRenderer() {
        this.nodeRenderer = new Renderer3D();
        this.edgeRenderer = new Renderer3D();
        this.nodeRenderer.initRenderer(this.model.getNodeFont());
        this.edgeRenderer.initRenderer(this.model.getEdgeFont());
    }

    public void defaultNodeColor() {
        this.model.colorMode.defaultNodeColor(this.nodeRenderer);
    }

    public void defaultEdgeColor() {
        this.model.colorMode.defaultEdgeColor(this.edgeRenderer);
    }

    public boolean isSelectedOnly() {
        return this.model.selectedOnly;
    }

    public TextModelImpl getModel() {
        return this.model;
    }

    public void setModel(TextModelImpl model) {
        this.model = model;
    }

    public SizeMode[] getSizeModes() {
        return this.sizeModes;
    }

    public ColorMode[] getColorModes() {
        return this.colorModes;
    }

    public Renderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public Renderer getEdgeRenderer() {
        return this.edgeRenderer;
    }

    public boolean refreshNode(Graph graph, NodeModel node, TextModelImpl modelImpl) {
        TextProperties textData = node.getNode().getTextProperties();
        if (textData != null) {
            String txt = textData.getText();
            String newTxt = this.buildText(graph, (Element)node.getNode(), modelImpl.getNodeTextColumns());
            if (txt == null && newTxt != null || txt != null && newTxt == null || txt != null && newTxt != null && !txt.equals(newTxt)) {
                node.setText(newTxt);
                return true;
            }
        }
        this.nodeRefresh = true;
        return false;
    }

    public boolean refreshEdge(Graph graph, EdgeModel edge, TextModelImpl modelImpl) {
        TextProperties textData = edge.getEdge().getTextProperties();
        if (textData != null) {
            String txt = textData.getText();
            String newTxt = this.buildText(graph, (Element)edge.getEdge(), modelImpl.getEdgeTextColumns());
            if (txt == null && newTxt != null || txt != null && newTxt == null || txt != null && newTxt != null && !txt.equals(newTxt)) {
                edge.setText(newTxt);
                return true;
            }
        }
        this.edgeRefresh = true;
        return false;
    }

    private String buildText(Graph graph, Element element, Column[] selectedColumns) {
        String txt;
        if (selectedColumns == null || selectedColumns.length == 0) {
            txt = element.getLabel();
        } else {
            if (selectedColumns.length == 1) {
                return this.buildText(graph, element, selectedColumns[0]);
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Column c : selectedColumns) {
                if (i++ > 0) {
                    sb.append(" - ");
                }
                sb.append(this.buildText(graph, element, c));
            }
            txt = sb.toString();
        }
        return txt != null && !txt.isEmpty() ? txt : null;
    }

    private String buildText(Graph graph, Element element, Column column) {
        Object val = element.getAttribute(column, graph.getView());
        if (val == null) {
            return "";
        }
        if (column.isArray()) {
            return AttributeUtils.printArray((Object)val);
        }
        return val.toString();
    }

    private class Renderer3D
    implements Renderer {
        private TextRenderer renderer;

        private Renderer3D() {
        }

        @Override
        public void initRenderer(Font font) {
            this.renderer = new TextRenderer(font, TextManager.this.antialised, TextManager.this.fractionalMetrics, null, this.shouldUseMipmapGeneration());
        }

        @Override
        public void reinitRenderer() {
            this.renderer = new TextRenderer(this.renderer.getFont(), TextManager.this.antialised, TextManager.this.fractionalMetrics, null, this.shouldUseMipmapGeneration());
        }

        private boolean shouldUseMipmapGeneration() {
            boolean doMipmap = TextManager.this.mipmap;
            if (TextManager.this.drawable.getGraphicalConfiguration() != null && TextManager.this.drawable.getGraphicalConfiguration().isIntelVendor()) {
                doMipmap = false;
            }
            return doMipmap;
        }

        @Override
        public void disposeRenderer() {
            this.renderer.flush();
            this.renderer.dispose();
        }

        @Override
        public Font getFont() {
            return this.renderer.getFont();
        }

        @Override
        public void setFont(Font font) {
            this.initRenderer(font);
        }

        @Override
        public void beginRendering() {
            this.renderer.begin3DRendering();
            float cameraLocation = TextManager.this.drawable.getCameraLocation()[2];
            if (TextManager.this.cachedCameraLocationZ != cameraLocation && TextManager.this.model.sizeMode == TextManager.this.sizeModes[0]) {
                TextManager.this.nodeRefresh = true;
                TextManager.this.edgeRefresh = true;
            }
            TextManager.this.cachedCameraLocationZ = cameraLocation;
        }

        @Override
        public void endRendering() {
            this.renderer.end3DRendering();
            TextManager.this.nodeRefresh = false;
            TextManager.this.edgeRefresh = false;
        }

        @Override
        public void drawTextNode(NodeModel objectModel) {
            Node node = objectModel.getNode();
            TextProperties textData = node.getTextProperties();
            if (textData != null) {
                float posY;
                float posX;
                String txt = textData.getText();
                if (txt == null || txt.isEmpty()) {
                    return;
                }
                float sizeFactor = TextManager.this.drawable.getGlobalScale() * textData.getSize() * TextManager.this.model.sizeMode.getSizeFactor3d(TextManager.this.model.nodeSizeFactor, objectModel);
                if (TextManager.this.nodeRefresh || objectModel.getTextWidth() == 0.0f && objectModel.getTextHeight() == 0.0f) {
                    Rectangle2D r = this.renderer.getBounds(txt);
                    float width = (float)((double)sizeFactor * r.getWidth());
                    float height = (float)((double)sizeFactor * r.getHeight());
                    posX = node.x() + width / -2.0f;
                    posY = node.y() + height / -2.0f;
                    textData.setDimensions(width, height);
                } else {
                    float width = textData.getWidth();
                    float height = textData.getHeight();
                    posX = node.x() + width / -2.0f;
                    posY = node.y() + height / -2.0f;
                }
                TextManager.this.model.colorMode.textNodeColor(this, objectModel);
                this.renderer.draw3D(txt, posX, posY, node.z(), sizeFactor);
            }
        }

        @Override
        public void drawTextEdge(EdgeModel objectModel) {
            Edge edge = objectModel.getEdge();
            TextProperties textData = edge.getTextProperties();
            if (textData != null) {
                float y;
                float x;
                float height;
                float width;
                String txt = textData.getText();
                if (txt == null || txt.isEmpty()) {
                    return;
                }
                float sizeFactor = TextManager.this.drawable.getGlobalScale() * textData.getSize() * TextManager.this.model.edgeSizeFactor;
                if (TextManager.this.edgeRefresh || objectModel.getTextWidth() == 0.0f && objectModel.getTextHeight() == 0.0f) {
                    Rectangle2D r = this.renderer.getBounds(txt);
                    width = (float)((double)sizeFactor * r.getWidth());
                    height = (float)((double)sizeFactor * r.getHeight());
                    textData.setDimensions(width, height);
                } else {
                    width = textData.getWidth();
                    height = textData.getHeight();
                }
                TextManager.this.model.colorMode.textEdgeColor(this, objectModel);
                if (edge.isDirected()) {
                    x = (objectModel.getSourceModel().getNode().x() + 2.0f * objectModel.getTargetModel().getNode().x()) / 3.0f;
                    y = (objectModel.getSourceModel().getNode().y() + 2.0f * objectModel.getTargetModel().getNode().y()) / 3.0f;
                } else {
                    x = (objectModel.getSourceModel().getNode().x() + objectModel.getTargetModel().getNode().x()) / 2.0f;
                    y = (objectModel.getSourceModel().getNode().y() + objectModel.getTargetModel().getNode().y()) / 2.0f;
                }
                float posX = x + width / -2.0f;
                float posY = y + height / -2.0f;
                float posZ = 0.0f;
                this.renderer.draw3D(txt, posX, posY, posZ, sizeFactor);
            }
        }

        @Override
        public void setColor(float r, float g, float b, float a) {
            this.renderer.setColor(r, g, b, a);
        }

        @Override
        public TextRenderer getJOGLRenderer() {
            return this.renderer;
        }
    }

    public static interface Renderer {
        public void initRenderer(Font var1);

        public void reinitRenderer();

        public void disposeRenderer();

        public void beginRendering();

        public void endRendering();

        public void drawTextNode(NodeModel var1);

        public void drawTextEdge(EdgeModel var1);

        public Font getFont();

        public void setFont(Font var1);

        public void setColor(float var1, float var2, float var3, float var4);

        public TextRenderer getJOGLRenderer();
    }
}

