/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.stats;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.index.IndexService;
import org.opensearch.index.seqno.RetentionLease;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.IndicesService;
import org.opensearch.replication.action.stats.LeaderNodeStatsResponse;
import org.opensearch.replication.action.stats.LeaderStatsRequest;
import org.opensearch.replication.action.stats.LeaderStatsResponse;
import org.opensearch.replication.action.stats.NodeStatsRequest;
import org.opensearch.replication.seqno.RemoteClusterStats;
import org.opensearch.replication.seqno.RemoteShardMetric;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0006:\u0001*B?\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0014J2\u0010#\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010%2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010%H\u0014J\u0012\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0014R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/opensearch/replication/action/stats/TransportLeaderStatsAction;", "Lorg/opensearch/action/support/nodes/TransportNodesAction;", "Lorg/opensearch/replication/action/stats/LeaderStatsRequest;", "Lorg/opensearch/replication/action/stats/LeaderStatsResponse;", "Lorg/opensearch/replication/action/stats/NodeStatsRequest;", "Lorg/opensearch/replication/action/stats/LeaderNodeStatsResponse;", "Lkotlinx/coroutines/CoroutineScope;", "transportService", "Lorg/opensearch/transport/TransportService;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "remoteStats", "Lorg/opensearch/replication/seqno/RemoteClusterStats;", "indicesService", "Lorg/opensearch/indices/IndicesService;", "client", "Lorg/opensearch/client/node/NodeClient;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/replication/seqno/RemoteClusterStats;Lorg/opensearch/indices/IndicesService;Lorg/opensearch/client/node/NodeClient;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "isShardReplicationActive", "", "shardId", "Lorg/opensearch/index/shard/ShardId;", "newNodeRequest", "request", "newNodeResponse", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "newResponse", "responses", "", "failures", "Lorg/opensearch/action/FailedNodeException;", "nodeOperation", "nodeStatRequest", "Companion", "opensearch-cross-cluster-replication"})
public final class TransportLeaderStatsAction
extends TransportNodesAction<LeaderStatsRequest, LeaderStatsResponse, NodeStatsRequest, LeaderNodeStatsResponse>
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteClusterStats remoteStats;
    @NotNull
    private final IndicesService indicesService;
    @NotNull
    private final NodeClient client;
    private final /* synthetic */ GlobalScope $$delegate_0;
    private static final Logger log = LogManager.getLogger(TransportLeaderStatsAction.class);
    private static final long durationThresholdActiveReplication = TimeUnit.SECONDS.toMillis(300L);

    @Inject
    public TransportLeaderStatsAction(@NotNull TransportService transportService, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ActionFilters actionFilters, @NotNull RemoteClusterStats remoteStats, @NotNull IndicesService indicesService, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)((Object)remoteStats), (String)"remoteStats");
        Intrinsics.checkNotNullParameter((Object)indicesService, (String)"indicesService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super("indices:admin/plugins/replication/index/stats", threadPool, clusterService, transportService, actionFilters, LeaderStatsRequest::new, NodeStatsRequest::new, "management", LeaderNodeStatsResponse.class);
        this.remoteStats = remoteStats;
        this.indicesService = indicesService;
        this.client = client;
        this.$$delegate_0 = GlobalScope.INSTANCE;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    @NotNull
    protected NodeStatsRequest newNodeRequest(@NotNull LeaderStatsRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return new NodeStatsRequest();
    }

    @NotNull
    protected LeaderNodeStatsResponse newNodeResponse(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new LeaderNodeStatsResponse(input);
    }

    @NotNull
    protected LeaderStatsResponse newResponse(@Nullable LeaderStatsRequest request, @Nullable List<LeaderNodeStatsResponse> responses, @Nullable List<FailedNodeException> failures) {
        return new LeaderStatsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    private final boolean isShardReplicationActive(ShardId shardId) {
        ImmutableOpenMap indicesRouting = this.clusterService.state().getRoutingTable().getIndicesRouting();
        if (!indicesRouting.containsKey((Object)shardId.getIndexName())) {
            return false;
        }
        IndexService indexService = this.indicesService.indexService(shardId.getIndex());
        if (indexService == null) {
            return false;
        }
        IndexService indexService2 = indexService;
        IndexShard indexShard = indexService2.getShard(shardId.getId());
        if (indexShard == null) {
            return false;
        }
        IndexShard indexShard2 = indexShard;
        Collection retentionLeases = indexShard2.getRetentionLeases().leases();
        for (RetentionLease retentionLease : retentionLeases) {
            String string = retentionLease.id();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"retentionLease.id()");
            if (!StringsKt.startsWith$default((String)string, (String)"replication:", (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected LeaderNodeStatsResponse nodeOperation(@Nullable NodeStatsRequest nodeStatRequest) {
        void $this$filterTo$iv$iv;
        Map<ShardId, RemoteShardMetric> $this$filter$iv = this.remoteStats.getStats();
        boolean $i$f$filter = false;
        Map<ShardId, RemoteShardMetric> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$k$v = element$iv$iv = iterator.next();
            boolean bl = false;
            ShardId k = (ShardId)$dstr$k$v.getKey();
            RemoteShardMetric v = (RemoteShardMetric)$dstr$k$v.getValue();
            boolean indexExists = this.isShardReplicationActive(k);
            long timeSinceLastFetch = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - v.getLastFetchTime().get());
            if (!(timeSinceLastFetch < durationThresholdActiveReplication && indexExists)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map activeStats = destination$iv$iv;
        DiscoveryNode discoveryNode = this.clusterService.localNode();
        Intrinsics.checkNotNullExpressionValue((Object)discoveryNode, (String)"this.clusterService.localNode()");
        return new LeaderNodeStatsResponse(discoveryNode, activeStats);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/replication/action/stats/TransportLeaderStatsAction$Companion;", "", "()V", "durationThresholdActiveReplication", "", "getDurationThresholdActiveReplication", "()J", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDurationThresholdActiveReplication() {
            return durationThresholdActiveReplication;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

