


















































.file "ghash-update.asm"
.arch armv8-a+crypto

.text





















































	
	
	

.globl _nettle_ghash_update_arm64
.type _nettle_ghash_update_arm64,%function
_nettle_ghash_update_arm64: 
    mov            x4,#0xC200000000000000
    mov            v6.d[0],x4

    ld1            {v0.2d},[x1]

    rev64          v0.16b,v0.16b


    ands           x4,x2,#-4
    b.eq           L1_block

    add            x5,x0,#64
    ld1            {v24.2d,v25.2d,v26.2d,v27.2d},[x0]
    ld1            {v28.2d,v29.2d,v30.2d,v31.2d},[x5]

L4_blocks_loop:
    ld1            {v1.2d,v2.2d,v3.2d,v4.2d},[x3],#64

    rev64          v1.16b,v1.16b
    rev64          v2.16b,v2.16b
    rev64          v3.16b,v3.16b
    rev64          v4.16b,v4.16b


    eor            v1.16b,v1.16b,v0.16b

        pmull          v16.1q,v29.1d,v2.1d
    pmull2         v17.1q,v29.2d,v2.2d
    pmull          v18.1q,v28.1d,v2.1d
    pmull2         v19.1q,v28.2d,v2.2d
    eor            v16.16b,v16.16b,v17.16b
    eor            v18.16b,v18.16b,v19.16b

        pmull          v21.1q,v27.1d,v3.1d
    pmull2         v23.1q,v27.2d,v3.2d
    pmull          v20.1q,v26.1d,v3.1d
    pmull2         v22.1q,v26.2d,v3.2d
    eor            v21.16b,v21.16b,v23.16b
    eor            v20.16b,v20.16b,v22.16b
    eor            v16.16b,v16.16b,v21.16b
    eor            v18.16b,v18.16b,v20.16b

        pmull          v21.1q,v25.1d,v4.1d
    pmull2         v23.1q,v25.2d,v4.2d
    pmull          v20.1q,v24.1d,v4.1d
    pmull2         v22.1q,v24.2d,v4.2d
    eor            v21.16b,v21.16b,v23.16b
    eor            v20.16b,v20.16b,v22.16b
    eor            v16.16b,v16.16b,v21.16b
    eor            v18.16b,v18.16b,v20.16b

        pmull          v21.1q,v31.1d,v1.1d
    pmull2         v23.1q,v31.2d,v1.2d
    pmull          v20.1q,v30.1d,v1.1d
    pmull2         v22.1q,v30.2d,v1.2d
    eor            v21.16b,v21.16b,v23.16b
    eor            v20.16b,v20.16b,v22.16b
    eor            v16.16b,v16.16b,v21.16b
    eor            v18.16b,v18.16b,v20.16b


        pmull          v7.1q,v16.1d,v6.1d
    eor            v18.16b,v18.16b,v7.16b
    ext            v18.16b,v18.16b,v18.16b,#8
    eor            v0.16b,v16.16b,v18.16b


    subs           x4,x4,#4
    b.ne           L4_blocks_loop

L1_block:
    ands           x2,x2,#3
    b.eq           Lghash_done

    ld1            {v24.2d,v25.2d},[x0]

L1_block_loop:
    ld1            {v1.2d},[x3],#16

    rev64          v1.16b,v1.16b


    eor            v1.16b,v1.16b,v0.16b

        pmull          v16.1q,v25.1d,v1.1d
    pmull2         v17.1q,v25.2d,v1.2d
    pmull          v18.1q,v24.1d,v1.1d
    pmull2         v19.1q,v24.2d,v1.2d
    eor            v16.16b,v16.16b,v17.16b
    eor            v18.16b,v18.16b,v19.16b


        pmull          v7.1q,v16.1d,v6.1d
    eor            v18.16b,v18.16b,v7.16b
    ext            v18.16b,v18.16b,v18.16b,#8
    eor            v0.16b,v16.16b,v18.16b


    subs           x2, x2, #1
    b.ne           L1_block_loop

Lghash_done:

    rev64          v0.16b,v0.16b

    st1            {v0.2d},[x1]
    mov            x0, x3
    ret
.size _nettle_ghash_update_arm64, . - _nettle_ghash_update_arm64



.section .note.GNU-stack,"",%progbits
