/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import sun.util.ResourceBundleEnumeration;

public abstract class OpenListResourceBundle
extends ResourceBundle {
    private Map<String, Object> lookup = null;

    protected OpenListResourceBundle() {
    }

    @Override
    public Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.loadLookupTablesIfNecessary();
        return this.lookup.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle parent = this.parent;
        return new ResourceBundleEnumeration(this.handleGetKeys(), parent != null ? parent.getKeys() : null);
    }

    public Set<String> handleGetKeys() {
        this.loadLookupTablesIfNecessary();
        return this.lookup.keySet();
    }

    public OpenListResourceBundle getParent() {
        return (OpenListResourceBundle)this.parent;
    }

    protected abstract Object[][] getContents();

    void loadLookupTablesIfNecessary() {
        if (this.lookup == null) {
            this.loadLookup();
        }
    }

    private synchronized void loadLookup() {
        if (this.lookup != null) {
            return;
        }
        Object[][] contents = this.getContents();
        Map<String, Object> temp = this.createMap(contents.length);
        for (int i = 0; i < contents.length; ++i) {
            String key = (String)contents[i][0];
            Object value = contents[i][1];
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            temp.put(key, value);
        }
        this.lookup = temp;
    }

    protected Map<String, Object> createMap(int size) {
        return new HashMap<String, Object>(size);
    }
}

