/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.tomcat.util.json.JSONFilter;

public class JsonAccessLogValve
extends AccessLogValve {
    private static final Map<Character, String> PATTERNS;

    @Override
    protected AbstractAccessLogValve.AccessLogElement[] createLogElements() {
        ArrayList<AbstractAccessLogValve.AccessLogElement> arrayList = new ArrayList<AbstractAccessLogValve.AccessLogElement>(Arrays.asList(super.createLogElements()));
        ListIterator<AbstractAccessLogValve.AccessLogElement> listIterator = arrayList.listIterator();
        listIterator.add((charArrayWriter, date, request, response, l) -> charArrayWriter.write(123));
        while (listIterator.hasNext()) {
            AbstractAccessLogValve.AccessLogElement accessLogElement = (AbstractAccessLogValve.AccessLogElement)listIterator.next();
            if (!(accessLogElement instanceof JsonWrappedElement)) {
                listIterator.remove();
                continue;
            }
            listIterator.add((charArrayWriter, date, request, response, l) -> charArrayWriter.write(44));
        }
        listIterator.previous();
        listIterator.remove();
        listIterator.add((charArrayWriter, date, request, response, l) -> charArrayWriter.write(125));
        return arrayList.toArray(new AbstractAccessLogValve.AccessLogElement[arrayList.size()]);
    }

    @Override
    protected AbstractAccessLogValve.AccessLogElement createAccessLogElement(char c) {
        AbstractAccessLogValve.AccessLogElement accessLogElement = super.createAccessLogElement(c);
        Object object = PATTERNS.get(Character.valueOf(c));
        if (object == null) {
            object = "other-" + new String(JSONFilter.escape((char)c));
        }
        return new JsonWrappedElement((String)object, true, accessLogElement);
    }

    static {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        hashMap.put(Character.valueOf('a'), "remoteAddr");
        hashMap.put(Character.valueOf('A'), "localAddr");
        hashMap.put(Character.valueOf('b'), "size");
        hashMap.put(Character.valueOf('B'), "byteSentNC");
        hashMap.put(Character.valueOf('D'), "elapsedTime");
        hashMap.put(Character.valueOf('F'), "firstByteTime");
        hashMap.put(Character.valueOf('h'), "host");
        hashMap.put(Character.valueOf('H'), "protocol");
        hashMap.put(Character.valueOf('l'), "logicalUserName");
        hashMap.put(Character.valueOf('m'), "method");
        hashMap.put(Character.valueOf('p'), "port");
        hashMap.put(Character.valueOf('q'), "query");
        hashMap.put(Character.valueOf('r'), "request");
        hashMap.put(Character.valueOf('s'), "statusCode");
        hashMap.put(Character.valueOf('S'), "sessionId");
        hashMap.put(Character.valueOf('t'), "time");
        hashMap.put(Character.valueOf('T'), "elapsedTimeS");
        hashMap.put(Character.valueOf('u'), "user");
        hashMap.put(Character.valueOf('U'), "path");
        hashMap.put(Character.valueOf('v'), "localServerName");
        hashMap.put(Character.valueOf('I'), "threadName");
        hashMap.put(Character.valueOf('X'), "connectionStatus");
        PATTERNS = Collections.unmodifiableMap(hashMap);
    }

    private static class JsonWrappedElement
    implements AbstractAccessLogValve.AccessLogElement,
    AbstractAccessLogValve.CachedElement {
        private CharSequence attributeName;
        private boolean quoteValue;
        private AbstractAccessLogValve.AccessLogElement delegate;

        private CharSequence escapeJsonString(CharSequence charSequence) {
            return JSONFilter.escape((CharSequence)charSequence);
        }

        JsonWrappedElement(String string, boolean bl, AbstractAccessLogValve.AccessLogElement accessLogElement) {
            this.attributeName = this.escapeJsonString(string);
            this.quoteValue = bl;
            this.delegate = accessLogElement;
        }

        @Override
        public void addElement(CharArrayWriter charArrayWriter, Date date, Request request, Response response, long l) {
            charArrayWriter.append('\"').append(this.attributeName).append('\"').append(':');
            if (this.quoteValue) {
                charArrayWriter.append('\"');
            }
            JsonCharArrayWriter jsonCharArrayWriter = new JsonCharArrayWriter(8);
            try {
                this.delegate.addElement(jsonCharArrayWriter, date, request, response, l);
                jsonCharArrayWriter.writeTo(charArrayWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.quoteValue) {
                charArrayWriter.append('\"');
            }
        }

        @Override
        public void cache(Request request) {
            if (this.delegate instanceof AbstractAccessLogValve.CachedElement) {
                ((AbstractAccessLogValve.CachedElement)((Object)this.delegate)).cache(request);
            }
        }
    }

    private static class JsonCharArrayWriter
    extends CharArrayWriter {
        JsonCharArrayWriter(int n) {
            super(n);
        }

        @Override
        public void write(int n) {
            try {
                super.write(JSONFilter.escape((char)((char)n)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            try {
                super.write(JSONFilter.escape((String)new String(cArray, n, n2)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void write(String string, int n, int n2) {
            CharSequence charSequence = JSONFilter.escape((CharSequence)string, (int)n, (int)n2);
            super.write(charSequence.toString(), 0, charSequence.length());
        }
    }
}

