/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CharsetUtil {
    private CharsetUtil() {
    }

    public static boolean isAsciiSuperset(Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        for (int i = 0; i < 128; ++i) {
            CharBuffer charBuffer;
            byteBuffer.clear();
            byteBuffer.put((byte)i);
            byteBuffer.flip();
            try {
                charBuffer = charsetDecoder.decode(byteBuffer);
            }
            catch (CharacterCodingException characterCodingException) {
                return false;
            }
            try {
                if (charBuffer.get() == i) continue;
                return false;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                return false;
            }
        }
        return true;
    }
}

