/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.XByteBuffer;

class BufferPool15Impl
implements BufferPool.BufferPoolAPI {
    protected int maxSize;
    protected final AtomicInteger size = new AtomicInteger(0);
    protected final ConcurrentLinkedQueue<XByteBuffer> queue = new ConcurrentLinkedQueue();

    BufferPool15Impl() {
    }

    @Override
    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    @Override
    public XByteBuffer getBuffer(int n, boolean bl) {
        XByteBuffer xByteBuffer = this.queue.poll();
        if (xByteBuffer != null) {
            this.size.addAndGet(-xByteBuffer.getCapacity());
        }
        if (xByteBuffer == null) {
            xByteBuffer = new XByteBuffer(n, bl);
        } else if (xByteBuffer.getCapacity() <= n) {
            xByteBuffer.expand(n);
        }
        xByteBuffer.setDiscard(bl);
        xByteBuffer.reset();
        return xByteBuffer;
    }

    @Override
    public void returnBuffer(XByteBuffer xByteBuffer) {
        if (this.size.get() + xByteBuffer.getCapacity() <= this.maxSize) {
            this.size.addAndGet(xByteBuffer.getCapacity());
            this.queue.offer(xByteBuffer);
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.size.set(0);
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

