/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.WindowsPopupMenuUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;

public class WindowsPopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new WindowsPopupMenuSeparatorUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension s = c.getSize();
        XPStyle xp = XPStyle.getXP();
        if (WindowsMenuItemUI.isVistaPainting(xp)) {
            Object gutterOffsetObject;
            int x = 1;
            Container parent = c.getParent();
            if (parent instanceof JComponent && (gutterOffsetObject = ((JComponent)parent).getClientProperty(WindowsPopupMenuUI.GUTTER_OFFSET_KEY)) instanceof Integer) {
                x = (Integer)gutterOffsetObject - c.getX();
                x += WindowsPopupMenuUI.getGutterWidth();
            }
            XPStyle.Skin skin = xp.getSkin(c, TMSchema.Part.MP_POPUPSEPARATOR);
            int skinHeight = skin.getHeight();
            int y = (s.height - skinHeight) / 2;
            skin.paintSkin(g, x, y, s.width - x - 1, skinHeight, TMSchema.State.NORMAL);
        } else {
            int y = s.height / 2;
            g.setColor(c.getForeground());
            g.drawLine(1, y - 1, s.width - 2, y - 1);
            g.setColor(c.getBackground());
            g.drawLine(1, y, s.width - 2, y);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int fontHeight = 0;
        Font font = c.getFont();
        if (font != null) {
            fontHeight = c.getFontMetrics(font).getHeight();
        }
        return new Dimension(0, fontHeight / 2 + 2);
    }
}

