/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;

public abstract class CustomCursor
extends Cursor {
    protected Image image;

    public CustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException {
        super(name);
        this.image = cursor;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Canvas c = new Canvas();
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(cursor, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int width = cursor.getWidth(c);
        int height = cursor.getHeight(c);
        if (tracker.isErrorAny() || width < 0 || height < 0) {
            hotSpot.y = 0;
            hotSpot.x = 0;
        }
        Dimension nativeSize = toolkit.getBestCursorSize(width, height);
        if ((nativeSize.width != width || nativeSize.height != height) && nativeSize.width != 0 && nativeSize.height != 0) {
            cursor = cursor.getScaledInstance(nativeSize.width, nativeSize.height, 1);
            width = nativeSize.width;
            height = nativeSize.height;
        }
        if (hotSpot.x >= width || hotSpot.y >= height || hotSpot.x < 0 || hotSpot.y < 0) {
            throw new IndexOutOfBoundsException("invalid hotSpot");
        }
        int[] pixels = new int[width * height];
        ImageProducer ip = cursor.getSource();
        PixelGrabber pg = new PixelGrabber(ip, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createNativeCursor(this.image, pixels, width, height, hotSpot.x, hotSpot.y);
    }

    protected abstract void createNativeCursor(Image var1, int[] var2, int var3, int var4, int var5, int var6);
}

