/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(BasicDataSourceFactory.class);
    private static final String PROP_DEFAULT_AUTO_COMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULT_READ_ONLY = "defaultReadOnly";
    private static final String PROP_DEFAULT_TRANSACTION_ISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULT_CATALOG = "defaultCatalog";
    private static final String PROP_DEFAULT_SCHEMA = "defaultSchema";
    private static final String PROP_CACHE_STATE = "cacheState";
    private static final String PROP_DRIVER_CLASS_NAME = "driverClassName";
    private static final String PROP_LIFO = "lifo";
    private static final String PROP_MAX_TOTAL = "maxTotal";
    private static final String PROP_MAX_IDLE = "maxIdle";
    private static final String PROP_MIN_IDLE = "minIdle";
    private static final String PROP_INITIAL_SIZE = "initialSize";
    private static final String PROP_MAX_WAIT_MILLIS = "maxWaitMillis";
    private static final String PROP_TEST_ON_CREATE = "testOnCreate";
    private static final String PROP_TEST_ON_BORROW = "testOnBorrow";
    private static final String PROP_TEST_ON_RETURN = "testOnReturn";
    private static final String PROP_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    private static final String PROP_MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = "softMinEvictableIdleTimeMillis";
    private static final String PROP_EVICTION_POLICY_CLASS_NAME = "evictionPolicyClassName";
    private static final String PROP_TEST_WHILE_IDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USER_NAME = "username";
    private static final String PROP_VALIDATION_QUERY = "validationQuery";
    private static final String PROP_VALIDATION_QUERY_TIMEOUT = "validationQueryTimeout";
    private static final String PROP_JMX_NAME = "jmxName";
    private static final String PROP_CONNECTION_FACTORY_CLASS_NAME = "connectionFactoryClassName";
    private static final String PROP_CONNECTION_INIT_SQLS = "connectionInitSqls";
    private static final String PROP_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVE_ABANDONED_ON_BORROW = "removeAbandonedOnBorrow";
    private static final String PROP_REMOVE_ABANDONED_ON_MAINTENANCE = "removeAbandonedOnMaintenance";
    private static final String PROP_REMOVE_ABANDONED_TIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOG_ABANDONED = "logAbandoned";
    private static final String PROP_ABANDONED_USAGE_TRACKING = "abandonedUsageTracking";
    private static final String PROP_POOL_PREPARED_STATEMENTS = "poolPreparedStatements";
    private static final String PROP_CLEAR_STATEMENT_POOL_ON_RETURN = "clearStatementPoolOnReturn";
    private static final String PROP_MAX_OPEN_PREPARED_STATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTION_PROPERTIES = "connectionProperties";
    private static final String PROP_MAX_CONN_LIFETIME_MILLIS = "maxConnLifetimeMillis";
    private static final String PROP_LOG_EXPIRED_CONNECTIONS = "logExpiredConnections";
    private static final String PROP_ROLLBACK_ON_RETURN = "rollbackOnReturn";
    private static final String PROP_ENABLE_AUTO_COMMIT_ON_RETURN = "enableAutoCommitOnReturn";
    private static final String PROP_DEFAULT_QUERY_TIMEOUT = "defaultQueryTimeout";
    private static final String PROP_FAST_FAIL_VALIDATION = "fastFailValidation";
    private static final String PROP_DISCONNECTION_SQL_CODES = "disconnectionSqlCodes";
    private static final String NUPROP_MAX_ACTIVE = "maxActive";
    private static final String NUPROP_REMOVE_ABANDONED = "removeAbandoned";
    private static final String NUPROP_MAXWAIT = "maxWait";
    private static final String SILENT_PROP_FACTORY = "factory";
    private static final String SILENT_PROP_SCOPE = "scope";
    private static final String SILENT_PROP_SINGLETON = "singleton";
    private static final String SILENT_PROP_AUTH = "auth";
    private static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "defaultSchema", "cacheState", "driverClassName", "lifo", "maxTotal", "maxIdle", "minIdle", "initialSize", "maxWaitMillis", "testOnCreate", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "softMinEvictableIdleTimeMillis", "evictionPolicyClassName", "testWhileIdle", "password", "url", "username", "validationQuery", "validationQueryTimeout", "connectionInitSqls", "accessToUnderlyingConnectionAllowed", "removeAbandonedOnBorrow", "removeAbandonedOnMaintenance", "removeAbandonedTimeout", "logAbandoned", "abandonedUsageTracking", "poolPreparedStatements", "clearStatementPoolOnReturn", "maxOpenPreparedStatements", "connectionProperties", "maxConnLifetimeMillis", "logExpiredConnections", "rollbackOnReturn", "enableAutoCommitOnReturn", "defaultQueryTimeout", "fastFailValidation", "disconnectionSqlCodes", "jmxName", "connectionFactoryClassName"};
    private static final Map<String, String> NUPROP_WARNTEXT = new LinkedHashMap<String, String>();
    private static final List<String> SILENT_PROPERTIES;

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        if (object == null || !(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        if (!"javax.sql.DataSource".equals(reference.getClassName())) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.validatePropertyNames(reference, name, arrayList, arrayList2);
        for (String stringArray : arrayList) {
            log.warn((Object)stringArray);
        }
        for (String string : arrayList2) {
            log.info((Object)string);
        }
        Properties properties = new Properties();
        for (String string : ALL_PROPERTIES) {
            RefAddr refAddr = reference.get(string);
            if (refAddr == null) continue;
            String string2 = refAddr.getContent().toString();
            properties.setProperty(string, string2);
        }
        return BasicDataSourceFactory.createDataSource(properties);
    }

    private void validatePropertyNames(Reference reference, Name name, List<String> list, List<String> list2) {
        CharSequence charSequence;
        CharSequence charSequence2;
        Object object;
        String string;
        List<String> list3 = Arrays.asList(ALL_PROPERTIES);
        String string2 = string = name != null ? "Name = " + name.toString() + " " : "";
        if (NUPROP_WARNTEXT != null && !NUPROP_WARNTEXT.isEmpty()) {
            for (String object2 : NUPROP_WARNTEXT.keySet()) {
                object = reference.get(object2);
                if (object == null || list3.contains(((RefAddr)object).getType())) continue;
                charSequence2 = new StringBuilder(string);
                charSequence = ((RefAddr)object).getContent().toString();
                ((StringBuilder)charSequence2).append(NUPROP_WARNTEXT.get(object2)).append(" You have set value of \"").append((String)charSequence).append("\" for \"").append(object2).append("\" property, which is being ignored.");
                list.add(((StringBuilder)charSequence2).toString());
            }
        }
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr refAddr = (RefAddr)enumeration.nextElement();
            object = refAddr.getType();
            if (list3.contains(object) || NUPROP_WARNTEXT.containsKey(object) || SILENT_PROPERTIES.contains(object)) continue;
            charSequence2 = refAddr.getContent().toString();
            charSequence = new StringBuilder(string);
            ((StringBuilder)charSequence).append("Ignoring unknown property: ").append("value of \"").append((String)charSequence2).append("\" for \"").append((String)object).append("\" property");
            list2.add(((StringBuilder)charSequence).toString());
        }
    }

    public static BasicDataSource createDataSource(Properties properties) throws Exception {
        BasicDataSource basicDataSource = new BasicDataSource();
        String string = properties.getProperty(PROP_DEFAULT_AUTO_COMMIT);
        if (string != null) {
            basicDataSource.setDefaultAutoCommit(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_DEFAULT_READ_ONLY)) != null) {
            basicDataSource.setDefaultReadOnly(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_DEFAULT_TRANSACTION_ISOLATION)) != null) {
            int n = -1;
            if ("NONE".equalsIgnoreCase(string)) {
                n = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(string)) {
                n = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(string)) {
                n = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(string)) {
                n = 8;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + string);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    n = -1;
                }
            }
            basicDataSource.setDefaultTransactionIsolation(n);
        }
        if ((string = properties.getProperty(PROP_DEFAULT_CATALOG)) != null) {
            basicDataSource.setDefaultCatalog(string);
        }
        if ((string = properties.getProperty(PROP_DEFAULT_SCHEMA)) != null) {
            basicDataSource.setDefaultSchema(string);
        }
        if ((string = properties.getProperty(PROP_CACHE_STATE)) != null) {
            basicDataSource.setCacheState(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_DRIVER_CLASS_NAME)) != null) {
            basicDataSource.setDriverClassName(string);
        }
        if ((string = properties.getProperty(PROP_LIFO)) != null) {
            basicDataSource.setLifo(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_MAX_TOTAL)) != null) {
            basicDataSource.setMaxTotal(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MAX_IDLE)) != null) {
            basicDataSource.setMaxIdle(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MIN_IDLE)) != null) {
            basicDataSource.setMinIdle(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_INITIAL_SIZE)) != null) {
            basicDataSource.setInitialSize(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MAX_WAIT_MILLIS)) != null) {
            basicDataSource.setMaxWaitMillis(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_TEST_ON_CREATE)) != null) {
            basicDataSource.setTestOnCreate(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_TEST_ON_BORROW)) != null) {
            basicDataSource.setTestOnBorrow(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_TEST_ON_RETURN)) != null) {
            basicDataSource.setTestOnReturn(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_TIME_BETWEEN_EVICTION_RUNS_MILLIS)) != null) {
            basicDataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_NUM_TESTS_PER_EVICTION_RUN)) != null) {
            basicDataSource.setNumTestsPerEvictionRun(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MIN_EVICTABLE_IDLE_TIME_MILLIS)) != null) {
            basicDataSource.setMinEvictableIdleTimeMillis(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS)) != null) {
            basicDataSource.setSoftMinEvictableIdleTimeMillis(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_EVICTION_POLICY_CLASS_NAME)) != null) {
            basicDataSource.setEvictionPolicyClassName(string);
        }
        if ((string = properties.getProperty(PROP_TEST_WHILE_IDLE)) != null) {
            basicDataSource.setTestWhileIdle(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_PASSWORD)) != null) {
            basicDataSource.setPassword(string);
        }
        if ((string = properties.getProperty(PROP_URL)) != null) {
            basicDataSource.setUrl(string);
        }
        if ((string = properties.getProperty(PROP_USER_NAME)) != null) {
            basicDataSource.setUsername(string);
        }
        if ((string = properties.getProperty(PROP_VALIDATION_QUERY)) != null) {
            basicDataSource.setValidationQuery(string);
        }
        if ((string = properties.getProperty(PROP_VALIDATION_QUERY_TIMEOUT)) != null) {
            basicDataSource.setValidationQueryTimeout(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED)) != null) {
            basicDataSource.setAccessToUnderlyingConnectionAllowed(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_REMOVE_ABANDONED_ON_BORROW)) != null) {
            basicDataSource.setRemoveAbandonedOnBorrow(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_REMOVE_ABANDONED_ON_MAINTENANCE)) != null) {
            basicDataSource.setRemoveAbandonedOnMaintenance(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_REMOVE_ABANDONED_TIMEOUT)) != null) {
            basicDataSource.setRemoveAbandonedTimeout(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_LOG_ABANDONED)) != null) {
            basicDataSource.setLogAbandoned(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_ABANDONED_USAGE_TRACKING)) != null) {
            basicDataSource.setAbandonedUsageTracking(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_POOL_PREPARED_STATEMENTS)) != null) {
            basicDataSource.setPoolPreparedStatements(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_CLEAR_STATEMENT_POOL_ON_RETURN)) != null) {
            basicDataSource.setClearStatementPoolOnReturn(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_MAX_OPEN_PREPARED_STATEMENTS)) != null) {
            basicDataSource.setMaxOpenPreparedStatements(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_CONNECTION_INIT_SQLS)) != null) {
            basicDataSource.setConnectionInitSqls(BasicDataSourceFactory.parseList(string, ';'));
        }
        if ((string = properties.getProperty(PROP_CONNECTION_PROPERTIES)) != null) {
            Properties properties2 = BasicDataSourceFactory.getProperties(string);
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                basicDataSource.addConnectionProperty(string2, properties2.getProperty(string2));
            }
        }
        if ((string = properties.getProperty(PROP_MAX_CONN_LIFETIME_MILLIS)) != null) {
            basicDataSource.setMaxConnLifetimeMillis(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_LOG_EXPIRED_CONNECTIONS)) != null) {
            basicDataSource.setLogExpiredConnections(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_JMX_NAME)) != null) {
            basicDataSource.setJmxName(string);
        }
        if ((string = properties.getProperty(PROP_ENABLE_AUTO_COMMIT_ON_RETURN)) != null) {
            basicDataSource.setAutoCommitOnReturn(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_ROLLBACK_ON_RETURN)) != null) {
            basicDataSource.setRollbackOnReturn(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_DEFAULT_QUERY_TIMEOUT)) != null) {
            basicDataSource.setDefaultQueryTimeout(Integer.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_FAST_FAIL_VALIDATION)) != null) {
            basicDataSource.setFastFailValidation(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_DISCONNECTION_SQL_CODES)) != null) {
            basicDataSource.setDisconnectionSqlCodes(BasicDataSourceFactory.parseList(string, ','));
        }
        if ((string = properties.getProperty(PROP_CONNECTION_FACTORY_CLASS_NAME)) != null) {
            basicDataSource.setConnectionFactoryClassName(string);
        }
        if (basicDataSource.getInitialSize() > 0) {
            basicDataSource.getLogWriter();
        }
        return basicDataSource;
    }

    private static Properties getProperties(String string) throws Exception {
        Properties properties = new Properties();
        if (string != null) {
            properties.load(new ByteArrayInputStream(string.replace(';', '\n').getBytes(StandardCharsets.ISO_8859_1)));
        }
        return properties;
    }

    private static Collection<String> parseList(String string, char c) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, Character.toString(c));
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    static {
        NUPROP_WARNTEXT.put(NUPROP_MAX_ACTIVE, "Property maxActive is not used in DBCP2, use maxTotal instead. maxTotal default value is 8.");
        NUPROP_WARNTEXT.put(NUPROP_REMOVE_ABANDONED, "Property removeAbandoned is not used in DBCP2, use one or both of removeAbandonedOnBorrow or removeAbandonedOnMaintenance instead. Both have default value set to false.");
        NUPROP_WARNTEXT.put(NUPROP_MAXWAIT, "Property maxWait is not used in DBCP2 , use maxWaitMillis instead. maxWaitMillis default value is -1.");
        SILENT_PROPERTIES = new ArrayList<String>();
        SILENT_PROPERTIES.add(SILENT_PROP_FACTORY);
        SILENT_PROPERTIES.add(SILENT_PROP_SCOPE);
        SILENT_PROPERTIES.add(SILENT_PROP_SINGLETON);
        SILENT_PROPERTIES.add(SILENT_PROP_AUTH);
    }
}

