/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ad.AbstractProfileRunner;
import org.opensearch.ad.ProfileUtil;
import org.opensearch.ad.common.exception.NotSerializedADExceptionName;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.model.DetectorProfile;
import org.opensearch.ad.model.DetectorProfileName;
import org.opensearch.ad.model.DetectorState;
import org.opensearch.ad.model.InitProgressProfile;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.settings.NumericSetting;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ProfileAction;
import org.opensearch.ad.transport.ProfileRequest;
import org.opensearch.ad.transport.ProfileResponse;
import org.opensearch.ad.transport.RCFPollingAction;
import org.opensearch.ad.transport.RCFPollingRequest;
import org.opensearch.ad.transport.RCFPollingResponse;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.ad.util.ExceptionUtil;
import org.opensearch.ad.util.MultiResponsesDelegateActionListener;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.opensearch.search.aggregations.metrics.InternalCardinality;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.TransportService;

public class AnomalyDetectorProfileRunner
extends AbstractProfileRunner {
    private final Logger logger = LogManager.getLogger(AnomalyDetectorProfileRunner.class);
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private DiscoveryNodeFilterer nodeFilter;
    private final TransportService transportService;
    private final ADTaskManager adTaskManager;
    private final int maxTotalEntitiesToTrack;

    public AnomalyDetectorProfileRunner(Client client, NamedXContentRegistry xContentRegistry, DiscoveryNodeFilterer nodeFilter, long requiredSamples, TransportService transportService, ADTaskManager adTaskManager) {
        super(requiredSamples);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        if (requiredSamples <= 0L) {
            throw new IllegalArgumentException("required samples should be a positive number, but was " + requiredSamples);
        }
        this.transportService = transportService;
        this.adTaskManager = adTaskManager;
        this.maxTotalEntitiesToTrack = 10000;
    }

    public void profile(String detectorId, ActionListener<DetectorProfile> listener, Set<DetectorProfileName> profilesToCollect) {
        if (profilesToCollect.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException(CommonErrorMessages.EMPTY_PROFILES_COLLECT));
            return;
        }
        this.calculateTotalResponsesToWait(detectorId, profilesToCollect, listener);
    }

    private void calculateTotalResponsesToWait(String detectorId, Set<DetectorProfileName> profilesToCollect, ActionListener<DetectorProfile> listener) {
        GetRequest getDetectorRequest = new GetRequest(".opendistro-anomaly-detectors", detectorId);
        this.client.get(getDetectorRequest, ActionListener.wrap(getDetectorResponse -> {
            if (getDetectorResponse != null && getDetectorResponse.isExists()) {
                try (XContentParser xContentParser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getDetectorResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xContentParser.nextToken(), (XContentParser)xContentParser);
                    AnomalyDetector detector = AnomalyDetector.parse(xContentParser, detectorId);
                    this.prepareProfile(detector, listener, profilesToCollect);
                }
                catch (Exception e) {
                    this.logger.error(CommonErrorMessages.FAIL_TO_PARSE_DETECTOR_MSG + detectorId, (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException(CommonErrorMessages.FAIL_TO_PARSE_DETECTOR_MSG + detectorId, RestStatus.BAD_REQUEST, new Object[0]));
                }
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException(CommonErrorMessages.FAIL_TO_FIND_DETECTOR_MSG + detectorId, RestStatus.BAD_REQUEST, new Object[0]));
            }
        }, exception -> {
            this.logger.error(CommonErrorMessages.FAIL_TO_FIND_DETECTOR_MSG + detectorId, (Throwable)exception);
            listener.onFailure((Exception)new OpenSearchStatusException(CommonErrorMessages.FAIL_TO_FIND_DETECTOR_MSG + detectorId, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }));
    }

    private void prepareProfile(AnomalyDetector detector, ActionListener<DetectorProfile> listener, Set<DetectorProfileName> profilesToCollect) {
        String detectorId = detector.getDetectorId();
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs", detectorId);
        this.client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (getResponse != null && getResponse.isExists()) {
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    AnomalyDetectorJob job = AnomalyDetectorJob.parse(parser);
                    long enabledTimeMs = job.getEnabledTime().toEpochMilli();
                    boolean isMultiEntityDetector = detector.isMultientityDetector();
                    int totalResponsesToWait = 0;
                    if (profilesToCollect.contains(DetectorProfileName.ERROR)) {
                        ++totalResponsesToWait;
                    }
                    if (isMultiEntityDetector) {
                        if (profilesToCollect.contains(DetectorProfileName.TOTAL_ENTITIES)) {
                            ++totalResponsesToWait;
                        }
                        if (profilesToCollect.contains(DetectorProfileName.COORDINATING_NODE) || profilesToCollect.contains(DetectorProfileName.SHINGLE_SIZE) || profilesToCollect.contains(DetectorProfileName.TOTAL_SIZE_IN_BYTES) || profilesToCollect.contains(DetectorProfileName.MODELS) || profilesToCollect.contains(DetectorProfileName.ACTIVE_ENTITIES) || profilesToCollect.contains(DetectorProfileName.INIT_PROGRESS) || profilesToCollect.contains(DetectorProfileName.STATE)) {
                            ++totalResponsesToWait;
                        }
                        if (profilesToCollect.contains(DetectorProfileName.AD_TASK)) {
                            ++totalResponsesToWait;
                        }
                    } else {
                        if (profilesToCollect.contains(DetectorProfileName.STATE) || profilesToCollect.contains(DetectorProfileName.INIT_PROGRESS)) {
                            ++totalResponsesToWait;
                        }
                        if (profilesToCollect.contains(DetectorProfileName.COORDINATING_NODE) || profilesToCollect.contains(DetectorProfileName.SHINGLE_SIZE) || profilesToCollect.contains(DetectorProfileName.TOTAL_SIZE_IN_BYTES) || profilesToCollect.contains(DetectorProfileName.MODELS)) {
                            ++totalResponsesToWait;
                        }
                        if (profilesToCollect.contains(DetectorProfileName.AD_TASK)) {
                            ++totalResponsesToWait;
                        }
                    }
                    MultiResponsesDelegateActionListener<DetectorProfile> delegateListener = new MultiResponsesDelegateActionListener<DetectorProfile>(listener, totalResponsesToWait, CommonErrorMessages.FAIL_FETCH_ERR_MSG + detectorId, false);
                    if (profilesToCollect.contains(DetectorProfileName.ERROR)) {
                        this.adTaskManager.getAndExecuteOnLatestDetectorLevelTask(detectorId, ADTaskType.REALTIME_TASK_TYPES, adTask -> {
                            DetectorProfile.Builder profileBuilder = new DetectorProfile.Builder();
                            if (adTask.isPresent()) {
                                long lastUpdateTimeMs = ((ADTask)adTask.get()).getLastUpdateTime().toEpochMilli();
                                if (lastUpdateTimeMs > enabledTimeMs && ((ADTask)adTask.get()).getError() != null) {
                                    profileBuilder.error(((ADTask)adTask.get()).getError());
                                }
                                delegateListener.onResponse(profileBuilder.build());
                            } else {
                                delegateListener.onResponse(profileBuilder.build());
                            }
                        }, this.transportService, false, delegateListener);
                    }
                    if (isMultiEntityDetector) {
                        if (profilesToCollect.contains(DetectorProfileName.TOTAL_ENTITIES)) {
                            this.profileEntityStats(delegateListener, detector);
                        }
                        if (profilesToCollect.contains(DetectorProfileName.COORDINATING_NODE) || profilesToCollect.contains(DetectorProfileName.SHINGLE_SIZE) || profilesToCollect.contains(DetectorProfileName.TOTAL_SIZE_IN_BYTES) || profilesToCollect.contains(DetectorProfileName.MODELS) || profilesToCollect.contains(DetectorProfileName.ACTIVE_ENTITIES) || profilesToCollect.contains(DetectorProfileName.INIT_PROGRESS) || profilesToCollect.contains(DetectorProfileName.STATE)) {
                            this.profileModels(detector, profilesToCollect, job, true, delegateListener);
                        }
                        if (profilesToCollect.contains(DetectorProfileName.AD_TASK)) {
                            this.adTaskManager.getLatestHistoricalTaskProfile(detectorId, this.transportService, null, delegateListener);
                        }
                    } else {
                        if (profilesToCollect.contains(DetectorProfileName.STATE) || profilesToCollect.contains(DetectorProfileName.INIT_PROGRESS)) {
                            this.profileStateRelated(detector, delegateListener, job.isEnabled(), profilesToCollect);
                        }
                        if (profilesToCollect.contains(DetectorProfileName.COORDINATING_NODE) || profilesToCollect.contains(DetectorProfileName.SHINGLE_SIZE) || profilesToCollect.contains(DetectorProfileName.TOTAL_SIZE_IN_BYTES) || profilesToCollect.contains(DetectorProfileName.MODELS)) {
                            this.profileModels(detector, profilesToCollect, job, false, delegateListener);
                        }
                        if (profilesToCollect.contains(DetectorProfileName.AD_TASK)) {
                            this.adTaskManager.getLatestHistoricalTaskProfile(detectorId, this.transportService, null, delegateListener);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error(CommonErrorMessages.FAIL_TO_GET_PROFILE_MSG, (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                this.onGetDetectorForPrepare(detectorId, listener, profilesToCollect);
            }
        }, exception -> {
            if (ExceptionUtil.isIndexNotAvailable(exception)) {
                this.logger.info(exception.getMessage());
                this.onGetDetectorForPrepare(detectorId, listener, profilesToCollect);
            } else {
                this.logger.error(CommonErrorMessages.FAIL_TO_GET_PROFILE_MSG + detectorId);
                listener.onFailure(exception);
            }
        }));
    }

    private void profileEntityStats(MultiResponsesDelegateActionListener<DetectorProfile> listener, AnomalyDetector detector) {
        List<String> categoryField = detector.getCategoryField();
        if (!detector.isMultientityDetector() || categoryField.size() > NumericSetting.maxCategoricalFields()) {
            listener.onResponse(new DetectorProfile.Builder().build());
        } else if (categoryField.size() == 1) {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            CardinalityAggregationBuilder aggBuilder = new CardinalityAggregationBuilder("total_entities");
            aggBuilder.field(categoryField.get(0));
            searchSourceBuilder.aggregation((AggregationBuilder)aggBuilder);
            SearchRequest request = new SearchRequest(detector.getIndices().toArray(new String[0]), searchSourceBuilder);
            this.client.search(request, ActionListener.wrap(searchResponse -> {
                Map aggMap = searchResponse.getAggregations().asMap();
                InternalCardinality totalEntities = (InternalCardinality)aggMap.get("total_entities");
                long value = totalEntities.getValue();
                DetectorProfile.Builder profileBuilder = new DetectorProfile.Builder();
                DetectorProfile profile = profileBuilder.totalEntities(value).build();
                listener.onResponse(profile);
            }, searchException -> {
                this.logger.warn(CommonErrorMessages.FAIL_TO_GET_TOTAL_ENTITIES + detector.getDetectorId());
                listener.onFailure((Exception)searchException);
            }));
        } else {
            CompositeAggregationBuilder bucketAggs = AggregationBuilders.composite((String)"total_entities", detector.getCategoryField().stream().map(f -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(f).field(f)).collect(Collectors.toList())).size(this.maxTotalEntitiesToTrack);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)bucketAggs).trackTotalHits(false).size(0);
            SearchRequest searchRequest = new SearchRequest().indices(detector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                DetectorProfile.Builder profileBuilder = new DetectorProfile.Builder();
                Aggregations aggs = searchResponse.getAggregations();
                if (aggs == null) {
                    this.logger.warn("Unexpected null aggregation.");
                    listener.onResponse(profileBuilder.totalEntities(0L).build());
                    return;
                }
                Aggregation aggrResult = aggs.get("total_entities");
                if (aggrResult == null) {
                    listener.onFailure(new IllegalArgumentException("Fail to find valid aggregation result"));
                    return;
                }
                CompositeAggregation compositeAgg = (CompositeAggregation)aggrResult;
                DetectorProfile profile = profileBuilder.totalEntities(Long.valueOf(compositeAgg.getBuckets().size())).build();
                listener.onResponse(profile);
            }, searchException -> {
                this.logger.warn(CommonErrorMessages.FAIL_TO_GET_TOTAL_ENTITIES + detector.getDetectorId());
                listener.onFailure((Exception)searchException);
            }));
        }
    }

    private void onGetDetectorForPrepare(String detectorId, ActionListener<DetectorProfile> listener, Set<DetectorProfileName> profiles) {
        DetectorProfile.Builder profileBuilder = new DetectorProfile.Builder();
        if (profiles.contains(DetectorProfileName.STATE)) {
            profileBuilder.state(DetectorState.DISABLED);
        }
        if (profiles.contains(DetectorProfileName.AD_TASK)) {
            this.adTaskManager.getLatestHistoricalTaskProfile(detectorId, this.transportService, profileBuilder.build(), listener);
        } else {
            listener.onResponse((Object)profileBuilder.build());
        }
    }

    private void profileStateRelated(AnomalyDetector detector, MultiResponsesDelegateActionListener<DetectorProfile> listener, boolean enabled, Set<DetectorProfileName> profilesToCollect) {
        if (enabled) {
            RCFPollingRequest request = new RCFPollingRequest(detector.getDetectorId());
            this.client.execute((ActionType)RCFPollingAction.INSTANCE, (ActionRequest)request, this.onPollRCFUpdates(detector, profilesToCollect, listener));
        } else {
            DetectorProfile.Builder builder = new DetectorProfile.Builder();
            if (profilesToCollect.contains(DetectorProfileName.STATE)) {
                builder.state(DetectorState.DISABLED);
            }
            listener.onResponse(builder.build());
        }
    }

    private void profileModels(AnomalyDetector detector, Set<DetectorProfileName> profiles, AnomalyDetectorJob job, boolean forMultiEntityDetector, MultiResponsesDelegateActionListener<DetectorProfile> listener) {
        DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
        ProfileRequest profileRequest = new ProfileRequest(detector.getDetectorId(), profiles, forMultiEntityDetector, dataNodes);
        this.client.execute((ActionType)ProfileAction.INSTANCE, (ActionRequest)profileRequest, this.onModelResponse(detector, profiles, job, listener));
    }

    private ActionListener<ProfileResponse> onModelResponse(AnomalyDetector detector, Set<DetectorProfileName> profilesToCollect, AnomalyDetectorJob job, MultiResponsesDelegateActionListener<DetectorProfile> listener) {
        boolean isMultientityDetector = detector.isMultientityDetector();
        return ActionListener.wrap(profileResponse -> {
            DetectorProfile.Builder profile = new DetectorProfile.Builder();
            if (profilesToCollect.contains(DetectorProfileName.COORDINATING_NODE)) {
                profile.coordinatingNode(profileResponse.getCoordinatingNode());
            }
            if (profilesToCollect.contains(DetectorProfileName.SHINGLE_SIZE)) {
                profile.shingleSize(profileResponse.getShingleSize());
            }
            if (profilesToCollect.contains(DetectorProfileName.TOTAL_SIZE_IN_BYTES)) {
                profile.totalSizeInBytes(profileResponse.getTotalSizeInBytes());
            }
            if (profilesToCollect.contains(DetectorProfileName.MODELS)) {
                profile.modelProfile(profileResponse.getModelProfile());
                profile.modelCount(profileResponse.getModelCount());
            }
            if (isMultientityDetector && profilesToCollect.contains(DetectorProfileName.ACTIVE_ENTITIES)) {
                profile.activeEntities(profileResponse.getActiveEntities());
            }
            if (isMultientityDetector && (profilesToCollect.contains(DetectorProfileName.INIT_PROGRESS) || profilesToCollect.contains(DetectorProfileName.STATE))) {
                this.profileMultiEntityDetectorStateRelated(job, profilesToCollect, (ProfileResponse)((Object)profileResponse), profile, detector, listener);
            } else {
                listener.onResponse(profile.build());
            }
        }, listener::onFailure);
    }

    private void profileMultiEntityDetectorStateRelated(AnomalyDetectorJob job, Set<DetectorProfileName> profilesToCollect, ProfileResponse profileResponse, DetectorProfile.Builder profileBuilder, AnomalyDetector detector, MultiResponsesDelegateActionListener<DetectorProfile> listener) {
        if (job.isEnabled()) {
            if (profileResponse.getTotalUpdates() < this.requiredSamples) {
                long enabledTime = job.getEnabledTime().toEpochMilli();
                long totalUpdates = profileResponse.getTotalUpdates();
                ProfileUtil.confirmDetectorRealtimeInitStatus(detector, enabledTime, this.client, this.onInittedEver(enabledTime, profileBuilder, profilesToCollect, detector, totalUpdates, listener));
            } else {
                this.createRunningStateAndInitProgress(profilesToCollect, profileBuilder);
                listener.onResponse(profileBuilder.build());
            }
        } else {
            if (profilesToCollect.contains(DetectorProfileName.STATE)) {
                profileBuilder.state(DetectorState.DISABLED);
            }
            listener.onResponse(profileBuilder.build());
        }
    }

    private ActionListener<SearchResponse> onInittedEver(long lastUpdateTimeMs, DetectorProfile.Builder profileBuilder, Set<DetectorProfileName> profilesToCollect, AnomalyDetector detector, long totalUpdates, MultiResponsesDelegateActionListener<DetectorProfile> listener) {
        return ActionListener.wrap(searchResponse -> {
            SearchHits hits = searchResponse.getHits();
            if (hits.getTotalHits().value == 0L) {
                this.processInitResponse(detector, profilesToCollect, totalUpdates, false, profileBuilder, listener);
            } else {
                this.createRunningStateAndInitProgress(profilesToCollect, profileBuilder);
                listener.onResponse(profileBuilder.build());
            }
        }, exception -> {
            if (ExceptionUtil.isIndexNotAvailable(exception)) {
                this.processInitResponse(detector, profilesToCollect, totalUpdates, false, profileBuilder, listener);
            } else {
                this.logger.error("Fail to find any anomaly result with anomaly score larger than 0 after AD job enabled time for detector {}", (Object)detector.getDetectorId());
                listener.onFailure((Exception)exception);
            }
        });
    }

    private ActionListener<RCFPollingResponse> onPollRCFUpdates(AnomalyDetector detector, Set<DetectorProfileName> profilesToCollect, MultiResponsesDelegateActionListener<DetectorProfile> listener) {
        return ActionListener.wrap(rcfPollResponse -> {
            long totalUpdates = rcfPollResponse.getTotalUpdates();
            if (totalUpdates < this.requiredSamples) {
                this.processInitResponse(detector, profilesToCollect, totalUpdates, false, new DetectorProfile.Builder(), listener);
            } else {
                DetectorProfile.Builder builder = new DetectorProfile.Builder();
                this.createRunningStateAndInitProgress(profilesToCollect, builder);
                listener.onResponse(builder.build());
            }
        }, exception -> {
            Throwable cause = Throwables.getRootCause((Throwable)exception);
            Exception causeException = (Exception)cause;
            if (ExceptionUtil.isException(causeException, ResourceNotFoundException.class, NotSerializedADExceptionName.RESOURCE_NOT_FOUND_EXCEPTION_NAME_UNDERSCORE.getName()) || ExceptionUtil.isIndexNotAvailable(causeException) && causeException.getMessage().contains(".opendistro-anomaly-checkpoints")) {
                this.processInitResponse(detector, profilesToCollect, 0L, true, new DetectorProfile.Builder(), listener);
            } else {
                this.logger.error((Message)new ParameterizedMessage("Fail to get init progress through messaging for {}", (Object)detector.getDetectorId()), (Throwable)exception);
                listener.onFailure((Exception)exception);
            }
        });
    }

    private void createRunningStateAndInitProgress(Set<DetectorProfileName> profilesToCollect, DetectorProfile.Builder builder) {
        if (profilesToCollect.contains(DetectorProfileName.STATE)) {
            builder.state(DetectorState.RUNNING).build();
        }
        if (profilesToCollect.contains(DetectorProfileName.INIT_PROGRESS)) {
            InitProgressProfile initProgress = new InitProgressProfile("100%", 0L, 0);
            builder.initProgress(initProgress);
        }
    }

    private void processInitResponse(AnomalyDetector detector, Set<DetectorProfileName> profilesToCollect, long totalUpdates, boolean hideMinutesLeft, DetectorProfile.Builder builder, MultiResponsesDelegateActionListener<DetectorProfile> listener) {
        if (profilesToCollect.contains(DetectorProfileName.STATE)) {
            builder.state(DetectorState.INIT);
        }
        if (profilesToCollect.contains(DetectorProfileName.INIT_PROGRESS)) {
            if (hideMinutesLeft) {
                InitProgressProfile initProgress = this.computeInitProgressProfile(totalUpdates, 0L);
                builder.initProgress(initProgress);
            } else {
                long intervalMins = ((IntervalTimeConfiguration)detector.getDetectionInterval()).toDuration().toMinutes();
                InitProgressProfile initProgress = this.computeInitProgressProfile(totalUpdates, intervalMins);
                builder.initProgress(initProgress);
            }
        }
        listener.onResponse(builder.build());
    }
}

